/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfloat.algo;

import cern.colt.GenericPermuting;
import cern.colt.GenericSorting;
import cern.colt.PersistentObject;
import cern.colt.Swapper;
import cern.colt.function.tfloat.FloatFloatFunction;
import cern.colt.function.tint.IntComparator;
import cern.colt.list.tobject.ObjectArrayList;
import cern.colt.matrix.Norm;
import cern.colt.matrix.tbit.QuickBitVector;
import cern.colt.matrix.tfcomplex.FComplexMatrix1D;
import cern.colt.matrix.tfcomplex.FComplexMatrix2D;
import cern.colt.matrix.tfcomplex.impl.DenseFComplexMatrix1D;
import cern.colt.matrix.tfloat.FloatFactory2D;
import cern.colt.matrix.tfloat.FloatMatrix1D;
import cern.colt.matrix.tfloat.FloatMatrix2D;
import cern.colt.matrix.tfloat.FloatMatrix3D;
import cern.colt.matrix.tfloat.algo.FloatProperty;
import cern.colt.matrix.tfloat.algo.SmpFloatBlas;
import cern.colt.matrix.tfloat.algo.decomposition.FloatCholeskyDecomposition;
import cern.colt.matrix.tfloat.algo.decomposition.FloatEigenvalueDecomposition;
import cern.colt.matrix.tfloat.algo.decomposition.FloatLUDecomposition;
import cern.colt.matrix.tfloat.algo.decomposition.FloatQRDecomposition;
import cern.colt.matrix.tfloat.algo.decomposition.FloatSingularValueDecomposition;
import cern.colt.matrix.tfloat.algo.decomposition.FloatSingularValueDecompositionDC;
import cern.colt.matrix.tfloat.impl.DenseFloatMatrix1D;
import cern.colt.matrix.tfloat.impl.DenseFloatMatrix2D;
import cern.colt.matrix.tfloat.impl.DenseFloatMatrix3D;
import cern.jet.math.tfcomplex.FComplex;
import cern.jet.math.tfcomplex.FComplexFunctions;
import cern.jet.math.tfloat.FloatFunctions;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public class FloatAlgebra
extends PersistentObject {
    private static final long serialVersionUID = 7387616224214397704L;
    public static final FloatAlgebra DEFAULT = new FloatAlgebra();
    public static final FloatAlgebra ZERO;
    protected FloatProperty property;

    public FloatAlgebra() {
        this(FloatProperty.DEFAULT.tolerance());
    }

    public FloatAlgebra(float f) {
        this.setProperty(new FloatProperty(f));
    }

    public FloatCholeskyDecomposition chol(FloatMatrix2D floatMatrix2D) {
        return new FloatCholeskyDecomposition(floatMatrix2D);
    }

    public Object clone() {
        return new FloatAlgebra(this.property.tolerance());
    }

    public float cond(FloatMatrix2D floatMatrix2D) {
        return this.svd(floatMatrix2D).cond();
    }

    public float det(FloatMatrix2D floatMatrix2D) {
        return this.lu(floatMatrix2D).det();
    }

    public FloatEigenvalueDecomposition eig(FloatMatrix2D floatMatrix2D) {
        return new FloatEigenvalueDecomposition(floatMatrix2D);
    }

    public static float hypot(float f, float f2) {
        float f3;
        if (Math.abs(f) > Math.abs(f2)) {
            f3 = f2 / f;
            f3 = (float)((double)Math.abs(f) * Math.sqrt(1.0f + f3 * f3));
        } else if (f2 != 0.0f) {
            f3 = f / f2;
            f3 = (float)((double)Math.abs(f2) * Math.sqrt(1.0f + f3 * f3));
        } else {
            f3 = 0.0f;
        }
        return f3;
    }

    public static FloatFloatFunction hypotFunction() {
        return new FloatFloatFunction(){

            public final float apply(float f, float f2) {
                return FloatAlgebra.hypot(f, f2);
            }
        };
    }

    public FloatMatrix2D inverse(FloatMatrix2D floatMatrix2D) {
        if (this.property.isSquare(floatMatrix2D) && this.property.isDiagonal(floatMatrix2D)) {
            FloatMatrix2D floatMatrix2D2 = floatMatrix2D.copy();
            boolean bl = true;
            int n = floatMatrix2D2.rows();
            while (--n >= 0) {
                float f = floatMatrix2D2.getQuick(n, n);
                bl &= f != 0.0f;
                floatMatrix2D2.setQuick(n, n, 1.0f / f);
            }
            if (!bl) {
                throw new IllegalArgumentException("A is singular.");
            }
            return floatMatrix2D2;
        }
        return this.solve(floatMatrix2D, FloatFactory2D.dense.identity(floatMatrix2D.rows()));
    }

    public FloatLUDecomposition lu(FloatMatrix2D floatMatrix2D) {
        return new FloatLUDecomposition(floatMatrix2D);
    }

    public FComplexMatrix1D kron(FComplexMatrix1D fComplexMatrix1D, FComplexMatrix1D fComplexMatrix1D2) {
        int n = fComplexMatrix1D.size();
        int n2 = fComplexMatrix1D2.size();
        DenseFComplexMatrix1D denseFComplexMatrix1D = new DenseFComplexMatrix1D(n * n2);
        for (int i = 0; i < n; ++i) {
            denseFComplexMatrix1D.viewPart(i * n2, n2).assign(fComplexMatrix1D2);
            denseFComplexMatrix1D.viewPart(i * n2, n2).assign(FComplexFunctions.mult(fComplexMatrix1D.getQuick(i)));
        }
        return denseFComplexMatrix1D;
    }

    public FloatMatrix1D kron(float[] fArray, float[] fArray2) {
        int n = fArray.length;
        int n2 = fArray2.length;
        DenseFloatMatrix1D denseFloatMatrix1D = new DenseFloatMatrix1D(n * n2);
        for (int i = 0; i < n; ++i) {
            denseFloatMatrix1D.viewPart(i * n2, n2).assign(fArray2);
            denseFloatMatrix1D.viewPart(i * n2, n2).assign(FloatFunctions.mult(fArray[i]));
        }
        return denseFloatMatrix1D;
    }

    public FloatMatrix1D kron(FloatMatrix1D floatMatrix1D, FloatMatrix1D floatMatrix1D2) {
        int n = floatMatrix1D.size();
        int n2 = floatMatrix1D2.size();
        DenseFloatMatrix1D denseFloatMatrix1D = new DenseFloatMatrix1D(n * n2);
        for (int i = 0; i < n; ++i) {
            denseFloatMatrix1D.viewPart(i * n2, n2).assign(floatMatrix1D2);
            denseFloatMatrix1D.viewPart(i * n2, n2).assign(FloatFunctions.mult(floatMatrix1D.getQuick(i)));
        }
        return denseFloatMatrix1D;
    }

    public float mult(FloatMatrix1D floatMatrix1D, FloatMatrix1D floatMatrix1D2) {
        return floatMatrix1D.zDotProduct(floatMatrix1D2);
    }

    public FloatMatrix1D mult(FloatMatrix2D floatMatrix2D, FloatMatrix1D floatMatrix1D) {
        return floatMatrix2D.zMult(floatMatrix1D, null);
    }

    public FloatMatrix2D mult(FloatMatrix2D floatMatrix2D, FloatMatrix2D floatMatrix2D2) {
        return floatMatrix2D.zMult(floatMatrix2D2, null);
    }

    public FloatMatrix2D multOuter(FloatMatrix1D floatMatrix1D, FloatMatrix1D floatMatrix1D2, FloatMatrix2D floatMatrix2D) {
        int n = floatMatrix1D.size();
        int n2 = floatMatrix1D2.size();
        if (floatMatrix2D == null) {
            floatMatrix2D = floatMatrix1D.like2D(n, n2);
        }
        if (floatMatrix2D.rows() != n || floatMatrix2D.columns() != n2) {
            throw new IllegalArgumentException();
        }
        int n3 = n;
        while (--n3 >= 0) {
            floatMatrix2D.viewRow(n3).assign(floatMatrix1D2);
        }
        n3 = n2;
        while (--n3 >= 0) {
            floatMatrix2D.viewColumn(n3).assign(floatMatrix1D, FloatFunctions.mult);
        }
        return floatMatrix2D;
    }

    public float norm1(FloatMatrix1D floatMatrix1D) {
        if (floatMatrix1D.size() == 0) {
            return 0.0f;
        }
        return floatMatrix1D.aggregate(FloatFunctions.plus, FloatFunctions.abs);
    }

    public float norm1(FloatMatrix2D floatMatrix2D) {
        float f = 0.0f;
        int n = floatMatrix2D.columns();
        while (--n >= 0) {
            f = Math.max(f, this.norm1(floatMatrix2D.viewColumn(n)));
        }
        return f;
    }

    public float norm2(FloatMatrix1D floatMatrix1D) {
        return (float)Math.sqrt(floatMatrix1D.zDotProduct(floatMatrix1D));
    }

    public float vectorNorm2(final FloatMatrix2D floatMatrix2D) {
        if (floatMatrix2D.isView() || !(floatMatrix2D instanceof DenseFloatMatrix2D)) {
            int n = floatMatrix2D.rows();
            final int n2 = floatMatrix2D.columns();
            float f = 0.0f;
            int n3 = ConcurrencyUtils.getNumberOfThreads();
            if (n3 > 1 && n * n2 >= ConcurrencyUtils.getThreadsBeginN_2D()) {
                int n4;
                Future[] futureArray = new Future[n3];
                int n5 = n / n3;
                for (n4 = 0; n4 < n3; ++n4) {
                    final int n6 = n4 * n5;
                    final int n7 = n4 == n3 - 1 ? n : n6 + n5;
                    futureArray[n4] = ConcurrencyUtils.submit(new Callable<Float>(){

                        @Override
                        public Float call() throws Exception {
                            float f = 0.0f;
                            for (int i = n6; i < n7; ++i) {
                                for (int j = 0; j < n2; ++j) {
                                    float f2 = floatMatrix2D.getQuick(i, j);
                                    f += f2 * f2;
                                }
                            }
                            return Float.valueOf(f);
                        }
                    });
                }
                try {
                    for (n4 = 0; n4 < n3; ++n4) {
                        Float f2 = (Float)futureArray[n4].get();
                        f += f2.floatValue();
                    }
                }
                catch (ExecutionException executionException) {
                    executionException.printStackTrace();
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            } else {
                for (int i = 0; i < n; ++i) {
                    for (int j = 0; j < n2; ++j) {
                        float f3 = floatMatrix2D.getQuick(i, j);
                        f += f3 * f3;
                    }
                }
            }
            return (float)Math.sqrt(f);
        }
        final float[] fArray = ((DenseFloatMatrix2D)floatMatrix2D).elements();
        float f = 0.0f;
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && fArray.length >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            int n8;
            Future[] futureArray = new Future[n];
            int n9 = fArray.length / n;
            for (n8 = 0; n8 < n; ++n8) {
                final int n10 = n8 * n9;
                final int n11 = n8 == n - 1 ? fArray.length : n10 + n9;
                futureArray[n8] = ConcurrencyUtils.submit(new Callable<Float>(){

                    @Override
                    public Float call() throws Exception {
                        float f = 0.0f;
                        for (int i = n10; i < n11; ++i) {
                            f += fArray[i] * fArray[i];
                        }
                        return Float.valueOf(f);
                    }
                });
            }
            try {
                for (n8 = 0; n8 < n; ++n8) {
                    Float f4 = (Float)futureArray[n8].get();
                    f += f4.floatValue();
                }
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        } else {
            for (int i = 0; i < fArray.length; ++i) {
                f += fArray[i] * fArray[i];
            }
        }
        return (float)Math.sqrt(f);
    }

    public float vectorNorm2(final FloatMatrix3D floatMatrix3D) {
        if (floatMatrix3D.isView() || !(floatMatrix3D instanceof DenseFloatMatrix3D)) {
            int n = floatMatrix3D.slices();
            final int n2 = floatMatrix3D.rows();
            final int n3 = floatMatrix3D.columns();
            float f = 0.0f;
            int n4 = ConcurrencyUtils.getNumberOfThreads();
            if (n4 > 1 && n2 * n3 >= ConcurrencyUtils.getThreadsBeginN_2D()) {
                int n5;
                Future[] futureArray = new Future[n4];
                int n6 = n / n4;
                for (n5 = 0; n5 < n4; ++n5) {
                    final int n7 = n5 * n6;
                    final int n8 = n5 == n4 - 1 ? n : n7 + n6;
                    futureArray[n5] = ConcurrencyUtils.submit(new Callable<Float>(){

                        @Override
                        public Float call() throws Exception {
                            float f = 0.0f;
                            for (int i = n7; i < n8; ++i) {
                                for (int j = 0; j < n2; ++j) {
                                    for (int k = 0; k < n3; ++k) {
                                        float f2 = floatMatrix3D.getQuick(i, j, k);
                                        f += f2 * f2;
                                    }
                                }
                            }
                            return Float.valueOf(f);
                        }
                    });
                }
                try {
                    for (n5 = 0; n5 < n4; ++n5) {
                        Float f2 = (Float)futureArray[n5].get();
                        f += f2.floatValue();
                    }
                }
                catch (ExecutionException executionException) {
                    executionException.printStackTrace();
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            } else {
                for (int i = 0; i < n; ++i) {
                    for (int j = 0; j < n2; ++j) {
                        for (int k = 0; k < n3; ++k) {
                            float f3 = floatMatrix3D.getQuick(i, j, k);
                            f += f3 * f3;
                        }
                    }
                }
            }
            return (float)Math.sqrt(f);
        }
        final float[] fArray = ((DenseFloatMatrix3D)floatMatrix3D).elements();
        float f = 0.0f;
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && fArray.length >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            int n9;
            Future[] futureArray = new Future[n];
            int n10 = fArray.length / n;
            for (n9 = 0; n9 < n; ++n9) {
                final int n11 = n9 * n10;
                final int n12 = n9 == n - 1 ? fArray.length : n11 + n10;
                futureArray[n9] = ConcurrencyUtils.submit(new Callable<Float>(){

                    @Override
                    public Float call() throws Exception {
                        float f = 0.0f;
                        for (int i = n11; i < n12; ++i) {
                            f += fArray[i] * fArray[i];
                        }
                        return Float.valueOf(f);
                    }
                });
            }
            try {
                for (n9 = 0; n9 < n; ++n9) {
                    Float f4 = (Float)futureArray[n9].get();
                    f += f4.floatValue();
                }
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        } else {
            for (int i = 0; i < fArray.length; ++i) {
                f += fArray[i] * fArray[i];
            }
        }
        return (float)Math.sqrt(f);
    }

    public float norm(FloatMatrix2D floatMatrix2D, Norm norm) {
        switch (norm) {
            case Frobenius: {
                return DEFAULT.normF(floatMatrix2D);
            }
            case Infinity: {
                return DEFAULT.normInfinity(floatMatrix2D);
            }
            case One: {
                return DEFAULT.norm1(floatMatrix2D);
            }
            case Two: {
                return DEFAULT.norm2(floatMatrix2D);
            }
        }
        return 0.0f;
    }

    public float norm(FloatMatrix1D floatMatrix1D, Norm norm) {
        switch (norm) {
            case Frobenius: {
                return DEFAULT.normF(floatMatrix1D);
            }
            case Infinity: {
                return DEFAULT.normInfinity(floatMatrix1D);
            }
            case One: {
                return DEFAULT.norm1(floatMatrix1D);
            }
            case Two: {
                return DEFAULT.norm2(floatMatrix1D);
            }
        }
        return 0.0f;
    }

    public float norm2(FloatMatrix2D floatMatrix2D) {
        return this.svd(floatMatrix2D).norm2();
    }

    public float normF(FloatMatrix2D floatMatrix2D) {
        if (floatMatrix2D.size() == 0) {
            return 0.0f;
        }
        return floatMatrix2D.aggregate(FloatAlgebra.hypotFunction(), FloatFunctions.identity);
    }

    public float normF(FloatMatrix1D floatMatrix1D) {
        if (floatMatrix1D.size() == 0) {
            return 0.0f;
        }
        return floatMatrix1D.aggregate(FloatAlgebra.hypotFunction(), FloatFunctions.identity);
    }

    public float normF(FComplexMatrix2D fComplexMatrix2D) {
        if (fComplexMatrix2D.size() == 0) {
            return 0.0f;
        }
        int n = fComplexMatrix2D.rows();
        int n2 = fComplexMatrix2D.columns();
        float f = 0.0f;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                float f2 = FComplex.abs(fComplexMatrix2D.getQuick(i, j));
                f += f2 * f2;
            }
        }
        return (float)Math.sqrt(f);
    }

    public float normInfinity(FloatMatrix1D floatMatrix1D) {
        if (floatMatrix1D.size() == 0) {
            return 0.0f;
        }
        return floatMatrix1D.aggregate(FloatFunctions.max, FloatFunctions.abs);
    }

    public float normInfinity(FloatMatrix2D floatMatrix2D) {
        float f = 0.0f;
        int n = floatMatrix2D.rows();
        while (--n >= 0) {
            f = Math.max(f, this.norm1(floatMatrix2D.viewRow(n)));
        }
        return f;
    }

    public FloatMatrix1D permute(FloatMatrix1D floatMatrix1D, int[] nArray, float[] fArray) {
        int n = floatMatrix1D.size();
        if (nArray.length != n) {
            throw new IndexOutOfBoundsException("invalid permutation");
        }
        if (fArray == null || n > fArray.length) {
            fArray = floatMatrix1D.toArray();
        } else {
            floatMatrix1D.toArray(fArray);
        }
        int n2 = n;
        while (--n2 >= 0) {
            floatMatrix1D.setQuick(n2, fArray[nArray[n2]]);
        }
        return floatMatrix1D;
    }

    public FloatMatrix2D permute(FloatMatrix2D floatMatrix2D, int[] nArray, int[] nArray2) {
        return floatMatrix2D.viewSelection(nArray, nArray2);
    }

    public FloatMatrix2D permuteColumns(FloatMatrix2D floatMatrix2D, int[] nArray, int[] nArray2) {
        return this.permuteRows(floatMatrix2D.viewDice(), nArray, nArray2);
    }

    public FloatMatrix2D permuteRows(final FloatMatrix2D floatMatrix2D, int[] nArray, int[] nArray2) {
        int n = floatMatrix2D.rows();
        if (nArray.length != n) {
            throw new IndexOutOfBoundsException("invalid permutation");
        }
        int n2 = floatMatrix2D.columns();
        if (n2 < n / 10) {
            float[] fArray = new float[n];
            int n3 = floatMatrix2D.columns();
            while (--n3 >= 0) {
                this.permute(floatMatrix2D.viewColumn(n3), nArray, fArray);
            }
            return floatMatrix2D;
        }
        Swapper swapper = new Swapper(){

            public void swap(int n, int n2) {
                floatMatrix2D.viewRow(n).swap(floatMatrix2D.viewRow(n2));
            }
        };
        GenericPermuting.permute(nArray, swapper, nArray2, null);
        return floatMatrix2D;
    }

    public FloatMatrix2D pow(FloatMatrix2D floatMatrix2D, int n) {
        FloatMatrix2D floatMatrix2D2;
        int n2;
        SmpFloatBlas smpFloatBlas = new SmpFloatBlas();
        FloatProperty.DEFAULT.checkSquare(floatMatrix2D);
        if (n < 0) {
            floatMatrix2D = this.inverse(floatMatrix2D);
            n = -n;
        }
        if (n == 0) {
            return FloatFactory2D.dense.identity(floatMatrix2D.rows());
        }
        FloatMatrix2D floatMatrix2D3 = floatMatrix2D.like();
        if (n == 1) {
            return floatMatrix2D3.assign(floatMatrix2D);
        }
        if (n == 2) {
            smpFloatBlas.dgemm(false, false, 1.0f, floatMatrix2D, floatMatrix2D, 0.0f, floatMatrix2D3);
            return floatMatrix2D3;
        }
        int n3 = QuickBitVector.mostSignificantBit(n);
        for (n2 = 0; n2 <= n3 && (n & 1 << n2) == 0; ++n2) {
            smpFloatBlas.dgemm(false, false, 1.0f, floatMatrix2D, floatMatrix2D, 0.0f, floatMatrix2D3);
            floatMatrix2D2 = floatMatrix2D;
            floatMatrix2D = floatMatrix2D3;
            floatMatrix2D3 = floatMatrix2D2;
        }
        floatMatrix2D2 = floatMatrix2D.copy();
        ++n2;
        while (n2 <= n3) {
            smpFloatBlas.dgemm(false, false, 1.0f, floatMatrix2D, floatMatrix2D, 0.0f, floatMatrix2D3);
            FloatMatrix2D floatMatrix2D4 = floatMatrix2D;
            floatMatrix2D = floatMatrix2D3;
            floatMatrix2D3 = floatMatrix2D4;
            if ((n & 1 << n2) != 0) {
                smpFloatBlas.dgemm(false, false, 1.0f, floatMatrix2D2, floatMatrix2D, 0.0f, floatMatrix2D3);
                floatMatrix2D4 = floatMatrix2D2;
                floatMatrix2D2 = floatMatrix2D3;
                floatMatrix2D3 = floatMatrix2D4;
            }
            ++n2;
        }
        return floatMatrix2D2;
    }

    public FloatProperty property() {
        return this.property;
    }

    public FloatQRDecomposition qr(FloatMatrix2D floatMatrix2D) {
        return new FloatQRDecomposition(floatMatrix2D);
    }

    public int rank(FloatMatrix2D floatMatrix2D) {
        return this.svd(floatMatrix2D).rank();
    }

    public void setProperty(FloatProperty floatProperty) {
        if (this == DEFAULT && floatProperty != this.property) {
            throw new IllegalArgumentException("Attempted to modify immutable object.");
        }
        if (this == ZERO && floatProperty != this.property) {
            throw new IllegalArgumentException("Attempted to modify immutable object.");
        }
        this.property = floatProperty;
    }

    public FloatMatrix1D backwardSolve(FloatMatrix2D floatMatrix2D, FloatMatrix1D floatMatrix1D) {
        int n = floatMatrix2D.rows();
        FloatMatrix1D floatMatrix1D2 = floatMatrix1D.like();
        floatMatrix1D2.setQuick(n - 1, floatMatrix1D.getQuick(n - 1) / floatMatrix2D.getQuick(n - 1, n - 1));
        for (int i = n - 2; i >= 0; --i) {
            float f = floatMatrix2D.viewRow(i).zDotProduct(floatMatrix1D2);
            floatMatrix1D2.setQuick(i, (floatMatrix1D.getQuick(i) - f) / floatMatrix2D.getQuick(i, i));
        }
        return floatMatrix1D2;
    }

    public FloatMatrix1D forwardSolve(FloatMatrix2D floatMatrix2D, FloatMatrix1D floatMatrix1D) {
        int n = floatMatrix2D.rows();
        FloatMatrix1D floatMatrix1D2 = floatMatrix1D.like();
        floatMatrix1D2.setQuick(0, floatMatrix1D.getQuick(0) / floatMatrix2D.getQuick(0, 0));
        for (int i = 1; i < n; ++i) {
            float f = floatMatrix2D.viewRow(i).zDotProduct(floatMatrix1D2);
            floatMatrix1D2.setQuick(i, (floatMatrix1D.getQuick(i) - f) / floatMatrix2D.getQuick(i, i));
        }
        return floatMatrix1D2;
    }

    public FloatMatrix1D solve(FloatMatrix2D floatMatrix2D, FloatMatrix1D floatMatrix1D) {
        return floatMatrix2D.rows() == floatMatrix2D.columns() ? this.lu(floatMatrix2D).solve(floatMatrix1D) : this.qr(floatMatrix2D).solve(floatMatrix1D);
    }

    public FloatMatrix2D solve(FloatMatrix2D floatMatrix2D, FloatMatrix2D floatMatrix2D2) {
        return floatMatrix2D.rows() == floatMatrix2D.columns() ? this.lu(floatMatrix2D).solve(floatMatrix2D2) : this.qr(floatMatrix2D).solve(floatMatrix2D2);
    }

    public FloatMatrix2D solveTranspose(FloatMatrix2D floatMatrix2D, FloatMatrix2D floatMatrix2D2) {
        return this.solve(this.transpose(floatMatrix2D), this.transpose(floatMatrix2D2));
    }

    public FloatMatrix2D subMatrix(FloatMatrix2D floatMatrix2D, int[] nArray, int n, int n2) {
        int n3 = n2 - n + 1;
        int n4 = floatMatrix2D.rows();
        floatMatrix2D = floatMatrix2D.viewPart(0, n, n4, n3);
        FloatMatrix2D floatMatrix2D2 = floatMatrix2D.like(nArray.length, n3);
        int n5 = nArray.length;
        while (--n5 >= 0) {
            int n6 = nArray[n5];
            if (n6 < 0 || n6 >= n4) {
                throw new IndexOutOfBoundsException("Illegal Index");
            }
            floatMatrix2D2.viewRow(n5).assign(floatMatrix2D.viewRow(n6));
        }
        return floatMatrix2D2;
    }

    public FloatMatrix2D subMatrix(FloatMatrix2D floatMatrix2D, int n, int n2, int[] nArray) {
        if (n2 - n >= floatMatrix2D.rows()) {
            throw new IndexOutOfBoundsException("Too many rows");
        }
        int n3 = n2 - n + 1;
        int n4 = floatMatrix2D.columns();
        floatMatrix2D = floatMatrix2D.viewPart(n, 0, n3, n4);
        FloatMatrix2D floatMatrix2D2 = floatMatrix2D.like(n3, nArray.length);
        int n5 = nArray.length;
        while (--n5 >= 0) {
            int n6 = nArray[n5];
            if (n6 < 0 || n6 >= n4) {
                throw new IndexOutOfBoundsException("Illegal Index");
            }
            floatMatrix2D2.viewColumn(n5).assign(floatMatrix2D.viewColumn(n6));
        }
        return floatMatrix2D2;
    }

    public FloatMatrix2D subMatrix(FloatMatrix2D floatMatrix2D, int n, int n2, int n3, int n4) {
        return floatMatrix2D.viewPart(n, n3, n2 - n + 1, n4 - n3 + 1);
    }

    public FloatSingularValueDecomposition svd(FloatMatrix2D floatMatrix2D) {
        return new FloatSingularValueDecomposition(floatMatrix2D);
    }

    public FloatSingularValueDecompositionDC svdDC(FloatMatrix2D floatMatrix2D) {
        return new FloatSingularValueDecompositionDC(floatMatrix2D, true, true);
    }

    public String toString(FloatMatrix2D floatMatrix2D) {
        int n;
        final ObjectArrayList objectArrayList = new ObjectArrayList();
        final ObjectArrayList objectArrayList2 = new ObjectArrayList();
        String string = "Illegal operation or error: ";
        objectArrayList.add("cond");
        try {
            objectArrayList2.add(String.valueOf(this.cond(floatMatrix2D)));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            objectArrayList2.add(string + illegalArgumentException.getMessage());
        }
        objectArrayList.add("det");
        try {
            objectArrayList2.add(String.valueOf(this.det(floatMatrix2D)));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            objectArrayList2.add(string + illegalArgumentException.getMessage());
        }
        objectArrayList.add("norm1");
        try {
            objectArrayList2.add(String.valueOf(this.norm1(floatMatrix2D)));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            objectArrayList2.add(string + illegalArgumentException.getMessage());
        }
        objectArrayList.add("norm2");
        try {
            objectArrayList2.add(String.valueOf(this.norm2(floatMatrix2D)));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            objectArrayList2.add(string + illegalArgumentException.getMessage());
        }
        objectArrayList.add("normF");
        try {
            objectArrayList2.add(String.valueOf(this.normF(floatMatrix2D)));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            objectArrayList2.add(string + illegalArgumentException.getMessage());
        }
        objectArrayList.add("normInfinity");
        try {
            objectArrayList2.add(String.valueOf(this.normInfinity(floatMatrix2D)));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            objectArrayList2.add(string + illegalArgumentException.getMessage());
        }
        objectArrayList.add("rank");
        try {
            objectArrayList2.add(String.valueOf(this.rank(floatMatrix2D)));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            objectArrayList2.add(string + illegalArgumentException.getMessage());
        }
        objectArrayList.add("trace");
        try {
            objectArrayList2.add(String.valueOf(this.trace(floatMatrix2D)));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            objectArrayList2.add(string + illegalArgumentException.getMessage());
        }
        IntComparator intComparator = new IntComparator(){

            public int compare(int n, int n2) {
                return FloatProperty.get(objectArrayList, n).compareTo(FloatProperty.get(objectArrayList, n2));
            }
        };
        Swapper swapper = new Swapper(){

            public void swap(int n, int n2) {
                Object object = objectArrayList.get(n);
                objectArrayList.set(n, objectArrayList.get(n2));
                objectArrayList.set(n2, object);
                object = objectArrayList2.get(n);
                objectArrayList2.set(n, objectArrayList2.get(n2));
                objectArrayList2.set(n2, object);
            }
        };
        GenericSorting.quickSort(0, objectArrayList.size(), intComparator, swapper);
        int n2 = 0;
        for (int i = 0; i < objectArrayList.size(); ++i) {
            n = ((String)objectArrayList.get(i)).length();
            n2 = Math.max(n, n2);
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (n = 0; n < objectArrayList.size(); ++n) {
            String string2 = (String)objectArrayList.get(n);
            stringBuffer.append(string2);
            stringBuffer.append(FloatProperty.blanks(n2 - string2.length()));
            stringBuffer.append(" : ");
            stringBuffer.append(objectArrayList2.get(n));
            if (n >= objectArrayList.size() - 1) continue;
            stringBuffer.append('\n');
        }
        return stringBuffer.toString();
    }

    public String toVerboseString(FloatMatrix2D floatMatrix2D) {
        String string = "Illegal operation or error upon construction of ";
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("A = ");
        stringBuffer.append(floatMatrix2D);
        stringBuffer.append("\n\n" + this.toString(floatMatrix2D));
        stringBuffer.append("\n\n" + FloatProperty.DEFAULT.toString(floatMatrix2D));
        FloatLUDecomposition floatLUDecomposition = null;
        try {
            floatLUDecomposition = new FloatLUDecomposition(floatMatrix2D);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            stringBuffer.append("\n\n" + string + " LUDecomposition: " + illegalArgumentException.getMessage());
        }
        if (floatLUDecomposition != null) {
            stringBuffer.append("\n\n" + floatLUDecomposition.toString());
        }
        FloatQRDecomposition floatQRDecomposition = null;
        try {
            floatQRDecomposition = new FloatQRDecomposition(floatMatrix2D);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            stringBuffer.append("\n\n" + string + " QRDecomposition: " + illegalArgumentException.getMessage());
        }
        if (floatQRDecomposition != null) {
            stringBuffer.append("\n\n" + floatQRDecomposition.toString());
        }
        FloatCholeskyDecomposition floatCholeskyDecomposition = null;
        try {
            floatCholeskyDecomposition = new FloatCholeskyDecomposition(floatMatrix2D);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            stringBuffer.append("\n\n" + string + " CholeskyDecomposition: " + illegalArgumentException.getMessage());
        }
        if (floatCholeskyDecomposition != null) {
            stringBuffer.append("\n\n" + floatCholeskyDecomposition.toString());
        }
        FloatEigenvalueDecomposition floatEigenvalueDecomposition = null;
        try {
            floatEigenvalueDecomposition = new FloatEigenvalueDecomposition(floatMatrix2D);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            stringBuffer.append("\n\n" + string + " EigenvalueDecomposition: " + illegalArgumentException.getMessage());
        }
        if (floatEigenvalueDecomposition != null) {
            stringBuffer.append("\n\n" + floatEigenvalueDecomposition.toString());
        }
        FloatSingularValueDecomposition floatSingularValueDecomposition = null;
        try {
            floatSingularValueDecomposition = new FloatSingularValueDecomposition(floatMatrix2D);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            stringBuffer.append("\n\n" + string + " SingularValueDecomposition: " + illegalArgumentException.getMessage());
        }
        if (floatSingularValueDecomposition != null) {
            stringBuffer.append("\n\n" + floatSingularValueDecomposition.toString());
        }
        return stringBuffer.toString();
    }

    public float trace(FloatMatrix2D floatMatrix2D) {
        float f = 0.0f;
        int n = Math.min(floatMatrix2D.rows(), floatMatrix2D.columns());
        while (--n >= 0) {
            f += floatMatrix2D.getQuick(n, n);
        }
        return f;
    }

    public FloatMatrix2D transpose(FloatMatrix2D floatMatrix2D) {
        return floatMatrix2D.viewDice();
    }

    public FloatMatrix2D trapezoidalLower(FloatMatrix2D floatMatrix2D) {
        int n = floatMatrix2D.rows();
        int n2 = floatMatrix2D.columns();
        int n3 = n;
        while (--n3 >= 0) {
            int n4 = n2;
            while (--n4 >= 0) {
                if (n3 >= n4) continue;
                floatMatrix2D.setQuick(n3, n4, 0.0f);
            }
        }
        return floatMatrix2D;
    }

    public FloatMatrix2D xmultOuter(FloatMatrix1D floatMatrix1D, FloatMatrix1D floatMatrix1D2) {
        FloatMatrix2D floatMatrix2D = floatMatrix1D.like2D(floatMatrix1D.size(), floatMatrix1D2.size());
        this.multOuter(floatMatrix1D, floatMatrix1D2, floatMatrix2D);
        return floatMatrix2D;
    }

    public FloatMatrix2D xpowSlow(FloatMatrix2D floatMatrix2D, int n) {
        FloatMatrix2D floatMatrix2D2 = floatMatrix2D.copy();
        for (int i = 0; i < n - 1; ++i) {
            floatMatrix2D2 = this.mult(floatMatrix2D2, floatMatrix2D);
        }
        return floatMatrix2D2;
    }

    static {
        FloatAlgebra.DEFAULT.property = FloatProperty.DEFAULT;
        ZERO = new FloatAlgebra();
        FloatAlgebra.ZERO.property = FloatProperty.ZERO;
    }
}

