/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfloat;

import cern.colt.function.tfloat.FloatProcedure;
import cern.colt.list.tfloat.FloatArrayList;
import cern.colt.list.tint.IntArrayList;
import cern.colt.matrix.tfloat.FloatMatrix1D;
import cern.colt.matrix.tfloat.FloatMatrix2D;
import cern.colt.matrix.tfloat.FloatMatrix2DProcedure;
import cern.colt.matrix.tfloat.FloatMatrix3D;
import cern.jet.math.tfloat.FloatFunctions;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import junit.framework.TestCase;

public abstract class FloatMatrix3DTest
extends TestCase {
    protected FloatMatrix3D A;
    protected FloatMatrix3D B;
    protected int NSLICES = 5;
    protected int NROWS = 13;
    protected int NCOLUMNS = 17;
    protected float TOL = 0.001f;

    public FloatMatrix3DTest(String string) {
        super(string);
    }

    protected void setUp() throws Exception {
        this.createMatrices();
        this.populateMatrices();
    }

    protected abstract void createMatrices() throws Exception;

    protected void populateMatrices() {
        int n;
        int n2;
        int n3;
        ConcurrencyUtils.setThreadsBeginN_3D(1);
        for (n3 = 0; n3 < this.NSLICES; ++n3) {
            for (n2 = 0; n2 < this.NROWS; ++n2) {
                for (n = 0; n < this.NCOLUMNS; ++n) {
                    this.A.setQuick(n3, n2, n, (float)Math.random());
                }
            }
        }
        for (n3 = 0; n3 < this.NSLICES; ++n3) {
            for (n2 = 0; n2 < this.NROWS; ++n2) {
                for (n = 0; n < this.NCOLUMNS; ++n) {
                    this.B.setQuick(n3, n2, n, (float)Math.random());
                }
            }
        }
    }

    protected void tearDown() throws Exception {
        this.B = null;
        this.A = null;
    }

    public void testAggregateFloatFloatFunctionFloatFunction() {
        float f = 0.0f;
        for (int i = 0; i < this.NSLICES; ++i) {
            for (int j = 0; j < this.NROWS; ++j) {
                for (int k = 0; k < this.NCOLUMNS; ++k) {
                    float f2 = this.A.getQuick(i, j, k);
                    f += f2 * f2;
                }
            }
        }
        float f3 = this.A.aggregate(FloatFunctions.plus, FloatFunctions.square);
        FloatMatrix3DTest.assertEquals((float)f, (float)f3, (float)this.TOL);
    }

    public void testAggregateFloatFloatFunctionFloatFunctionFloatProcedure() {
        FloatProcedure floatProcedure = new FloatProcedure(){

            public boolean apply(float f) {
                return (double)Math.abs(f) > 0.2;
            }
        };
        float f = 0.0f;
        for (int i = 0; i < this.NSLICES; ++i) {
            for (int j = 0; j < this.NROWS; ++j) {
                for (int k = 0; k < this.NCOLUMNS; ++k) {
                    float f2 = this.A.getQuick(i, j, k);
                    if (!((double)Math.abs(f2) > 0.2)) continue;
                    f += f2 * f2;
                }
            }
        }
        float f3 = this.A.aggregate(FloatFunctions.plus, FloatFunctions.square, floatProcedure);
        FloatMatrix3DTest.assertEquals((float)f, (float)f3, (float)this.TOL);
    }

    public void testAggregateFloatFloatFunctionFloatFunctionIntArrayListIntArrayListIntArrayList() {
        int n;
        int n2;
        IntArrayList intArrayList = new IntArrayList();
        IntArrayList intArrayList2 = new IntArrayList();
        IntArrayList intArrayList3 = new IntArrayList();
        for (int i = 0; i < this.NSLICES; ++i) {
            for (n2 = 0; n2 < this.NROWS; ++n2) {
                for (n = 0; n < this.NCOLUMNS; ++n) {
                    intArrayList.add(i);
                    intArrayList2.add(n2);
                    intArrayList3.add(n);
                }
            }
        }
        float f = 0.0f;
        for (n2 = 0; n2 < this.NSLICES; ++n2) {
            for (n = 0; n < this.NROWS; ++n) {
                for (int i = 0; i < this.NCOLUMNS; ++i) {
                    float f2 = this.A.getQuick(n2, n, i);
                    f += f2 * f2;
                }
            }
        }
        float f3 = this.A.aggregate(FloatFunctions.plus, FloatFunctions.square, intArrayList, intArrayList2, intArrayList3);
        FloatMatrix3DTest.assertEquals((float)f, (float)f3, (float)this.TOL);
    }

    public void testAggregateFloatMatrix2DFloatFloatFunctionFloatFloatFunction() {
        float f = 0.0f;
        for (int i = 0; i < this.NSLICES; ++i) {
            for (int j = 0; j < this.NROWS; ++j) {
                for (int k = 0; k < this.NCOLUMNS; ++k) {
                    float f2 = this.A.getQuick(i, j, k);
                    float f3 = this.B.getQuick(i, j, k);
                    f += f2 * f3;
                }
            }
        }
        float f4 = this.A.aggregate(this.B, FloatFunctions.plus, FloatFunctions.mult);
        FloatMatrix3DTest.assertEquals((float)f, (float)f4, (float)this.TOL);
    }

    public void testAssignFloat() {
        float f = (float)Math.random();
        this.A.assign(f);
        for (int i = 0; i < this.NSLICES; ++i) {
            for (int j = 0; j < this.NROWS; ++j) {
                for (int k = 0; k < this.NCOLUMNS; ++k) {
                    FloatMatrix3DTest.assertEquals((float)f, (float)this.A.getQuick(i, j, k), (float)this.TOL);
                }
            }
        }
    }

    public void testAssignFloatArray() {
        int n;
        float[] fArray = new float[this.A.size()];
        for (n = 0; n < this.A.size(); ++n) {
            fArray[n] = (float)Math.random();
        }
        this.A.assign(fArray);
        n = 0;
        for (int i = 0; i < this.NSLICES; ++i) {
            for (int j = 0; j < this.NROWS; ++j) {
                for (int k = 0; k < this.NCOLUMNS; ++k) {
                    FloatMatrix3DTest.assertEquals((float)fArray[n++], (float)this.A.getQuick(i, j, k), (float)this.TOL);
                }
            }
        }
    }

    public void testAssignFloatArrayArrayArray() {
        int n;
        int n2;
        int n3;
        float[][][] fArray = new float[this.NSLICES][this.NROWS][this.NCOLUMNS];
        for (n3 = 0; n3 < this.NSLICES; ++n3) {
            for (n2 = 0; n2 < this.NROWS; ++n2) {
                for (n = 0; n < this.NCOLUMNS; ++n) {
                    fArray[n3][n2][n] = (float)Math.random();
                }
            }
        }
        this.A.assign(fArray);
        for (n3 = 0; n3 < this.NSLICES; ++n3) {
            FloatMatrix3DTest.assertTrue((this.NROWS == fArray[n3].length ? 1 : 0) != 0);
            for (n2 = 0; n2 < this.NROWS; ++n2) {
                FloatMatrix3DTest.assertTrue((this.NCOLUMNS == fArray[n3][n2].length ? 1 : 0) != 0);
                for (n = 0; n < this.NCOLUMNS; ++n) {
                    FloatMatrix3DTest.assertEquals((float)fArray[n3][n2][n], (float)this.A.getQuick(n3, n2, n), (float)this.TOL);
                }
            }
        }
    }

    public void testAssignFloatFunction() {
        FloatMatrix3D floatMatrix3D = this.A.copy();
        this.A.assign(FloatFunctions.acos);
        for (int i = 0; i < this.NSLICES; ++i) {
            for (int j = 0; j < this.NROWS; ++j) {
                for (int k = 0; k < this.NCOLUMNS; ++k) {
                    float f = (float)Math.acos(floatMatrix3D.getQuick(i, j, k));
                    FloatMatrix3DTest.assertEquals((float)f, (float)this.A.getQuick(i, j, k), (float)this.TOL);
                }
            }
        }
    }

    public void testAssignFloatMatrix3D() {
        this.A.assign(this.B);
        for (int i = 0; i < this.NSLICES; ++i) {
            for (int j = 0; j < this.NROWS; ++j) {
                for (int k = 0; k < this.NCOLUMNS; ++k) {
                    FloatMatrix3DTest.assertEquals((float)this.B.getQuick(i, j, k), (float)this.A.getQuick(i, j, k), (float)this.TOL);
                }
            }
        }
    }

    public void testAssignFloatMatrix3DFloatFloatFunction() {
        FloatMatrix3D floatMatrix3D = this.A.copy();
        this.A.assign(this.B, FloatFunctions.div);
        for (int i = 0; i < this.NSLICES; ++i) {
            for (int j = 0; j < this.NROWS; ++j) {
                for (int k = 0; k < this.NCOLUMNS; ++k) {
                    FloatMatrix3DTest.assertEquals((float)(floatMatrix3D.getQuick(i, j, k) / this.B.getQuick(i, j, k)), (float)this.A.getQuick(i, j, k), (float)this.TOL);
                }
            }
        }
    }

    public void testAssignFloatMatrix3DFloatFloatFunctionIntArrayListIntArrayListIntArrayList() {
        int n;
        int n2;
        IntArrayList intArrayList = new IntArrayList();
        IntArrayList intArrayList2 = new IntArrayList();
        IntArrayList intArrayList3 = new IntArrayList();
        for (int i = 0; i < this.NSLICES; ++i) {
            for (n2 = 0; n2 < this.NROWS; ++n2) {
                for (n = 0; n < this.NCOLUMNS; ++n) {
                    intArrayList.add(i);
                    intArrayList2.add(n2);
                    intArrayList3.add(n);
                }
            }
        }
        FloatMatrix3D floatMatrix3D = this.A.copy();
        this.A.assign(this.B, FloatFunctions.div, intArrayList, intArrayList2, intArrayList3);
        for (n2 = 0; n2 < this.NSLICES; ++n2) {
            for (n = 0; n < this.NROWS; ++n) {
                for (int i = 0; i < this.NCOLUMNS; ++i) {
                    FloatMatrix3DTest.assertEquals((float)(floatMatrix3D.getQuick(n2, n, i) / this.B.getQuick(n2, n, i)), (float)this.A.getQuick(n2, n, i), (float)this.TOL);
                }
            }
        }
    }

    public void testAssignFloatProcedureFloat() {
        FloatProcedure floatProcedure = new FloatProcedure(){

            public boolean apply(float f) {
                return (double)Math.abs(f) > 0.1;
            }
        };
        FloatMatrix3D floatMatrix3D = this.A.copy();
        this.A.assign(floatProcedure, -1.0f);
        for (int i = 0; i < this.NSLICES; ++i) {
            for (int j = 0; j < this.NROWS; ++j) {
                for (int k = 0; k < this.NCOLUMNS; ++k) {
                    if ((double)Math.abs(floatMatrix3D.getQuick(i, j, k)) > 0.1) {
                        FloatMatrix3DTest.assertEquals((double)-1.0, (double)this.A.getQuick(i, j, k), (double)this.TOL);
                        continue;
                    }
                    FloatMatrix3DTest.assertEquals((float)floatMatrix3D.getQuick(i, j, k), (float)this.A.getQuick(i, j, k), (float)this.TOL);
                }
            }
        }
    }

    public void testAssignFloatProcedureFloatFunction() {
        FloatProcedure floatProcedure = new FloatProcedure(){

            public boolean apply(float f) {
                return (double)Math.abs(f) > 0.1;
            }
        };
        FloatMatrix3D floatMatrix3D = this.A.copy();
        this.A.assign(floatProcedure, FloatFunctions.tan);
        for (int i = 0; i < this.NSLICES; ++i) {
            for (int j = 0; j < this.NROWS; ++j) {
                for (int k = 0; k < this.NCOLUMNS; ++k) {
                    if ((double)Math.abs(floatMatrix3D.getQuick(i, j, k)) > 0.1) {
                        FloatMatrix3DTest.assertEquals((double)Math.tan(floatMatrix3D.getQuick(i, j, k)), (double)this.A.getQuick(i, j, k), (double)this.TOL);
                        continue;
                    }
                    FloatMatrix3DTest.assertEquals((float)floatMatrix3D.getQuick(i, j, k), (float)this.A.getQuick(i, j, k), (float)this.TOL);
                }
            }
        }
    }

    public void testCardinality() {
        int n = this.A.cardinality();
        FloatMatrix3DTest.assertEquals((int)(this.NSLICES * this.NROWS * this.NCOLUMNS), (int)n);
    }

    public void testEqualsFloat() {
        float f = 1.0f;
        this.A.assign(f);
        boolean bl = this.A.equals(f);
        FloatMatrix3DTest.assertTrue((boolean)bl);
        bl = this.A.equals(2.0f);
        FloatMatrix3DTest.assertFalse((boolean)bl);
    }

    public void testEqualsObject() {
        boolean bl = this.A.equals(this.A);
        FloatMatrix3DTest.assertTrue((boolean)bl);
        bl = this.A.equals(this.B);
        FloatMatrix3DTest.assertFalse((boolean)bl);
    }

    public void testMaxLocation() {
        this.A.assign(0.0f);
        this.A.setQuick(this.NSLICES / 3, this.NROWS / 3, this.NCOLUMNS / 3, 0.7f);
        this.A.setQuick(this.NSLICES / 3, this.NROWS / 2, this.NCOLUMNS / 2, 0.1f);
        float[] fArray = this.A.getMaxLocation();
        FloatMatrix3DTest.assertEquals((float)0.7f, (float)fArray[0], (float)this.TOL);
        FloatMatrix3DTest.assertEquals((int)(this.NSLICES / 3), (int)((int)fArray[1]));
        FloatMatrix3DTest.assertEquals((int)(this.NROWS / 3), (int)((int)fArray[2]));
        FloatMatrix3DTest.assertEquals((int)(this.NCOLUMNS / 3), (int)((int)fArray[3]));
    }

    public void testMinLocation() {
        this.A.assign(0.0f);
        this.A.setQuick(this.NSLICES / 3, this.NROWS / 3, this.NCOLUMNS / 3, -0.7f);
        this.A.setQuick(this.NSLICES / 3, this.NROWS / 2, this.NCOLUMNS / 2, -0.1f);
        float[] fArray = this.A.getMinLocation();
        FloatMatrix3DTest.assertEquals((float)-0.7f, (float)fArray[0], (float)this.TOL);
        FloatMatrix3DTest.assertEquals((int)(this.NSLICES / 3), (int)((int)fArray[1]));
        FloatMatrix3DTest.assertEquals((int)(this.NROWS / 3), (int)((int)fArray[2]));
        FloatMatrix3DTest.assertEquals((int)(this.NCOLUMNS / 3), (int)((int)fArray[3]));
    }

    public void testGetNegativeValues() {
        this.A.assign(0.0f);
        this.A.setQuick(this.NSLICES / 3, this.NROWS / 3, this.NCOLUMNS / 3, -0.7f);
        this.A.setQuick(this.NSLICES / 2, this.NROWS / 2, this.NCOLUMNS / 2, -0.1f);
        IntArrayList intArrayList = new IntArrayList();
        IntArrayList intArrayList2 = new IntArrayList();
        IntArrayList intArrayList3 = new IntArrayList();
        FloatArrayList floatArrayList = new FloatArrayList();
        this.A.getNegativeValues(intArrayList, intArrayList2, intArrayList3, floatArrayList);
        FloatMatrix3DTest.assertEquals((int)2, (int)intArrayList.size());
        FloatMatrix3DTest.assertEquals((int)2, (int)intArrayList2.size());
        FloatMatrix3DTest.assertEquals((int)2, (int)intArrayList3.size());
        FloatMatrix3DTest.assertEquals((int)2, (int)floatArrayList.size());
        FloatMatrix3DTest.assertTrue((boolean)intArrayList.contains(this.NSLICES / 3));
        FloatMatrix3DTest.assertTrue((boolean)intArrayList.contains(this.NSLICES / 2));
        FloatMatrix3DTest.assertTrue((boolean)intArrayList2.contains(this.NROWS / 3));
        FloatMatrix3DTest.assertTrue((boolean)intArrayList2.contains(this.NROWS / 2));
        FloatMatrix3DTest.assertTrue((boolean)intArrayList3.contains(this.NCOLUMNS / 3));
        FloatMatrix3DTest.assertTrue((boolean)intArrayList3.contains(this.NCOLUMNS / 2));
        FloatMatrix3DTest.assertTrue((boolean)floatArrayList.contains(-0.7f));
        FloatMatrix3DTest.assertTrue((boolean)floatArrayList.contains(-0.1f));
    }

    public void testGetNonZeros() {
        this.A.assign(0.0f);
        this.A.setQuick(this.NSLICES / 3, this.NROWS / 3, this.NCOLUMNS / 3, 0.7f);
        this.A.setQuick(this.NSLICES / 2, this.NROWS / 2, this.NCOLUMNS / 2, 0.1f);
        IntArrayList intArrayList = new IntArrayList();
        IntArrayList intArrayList2 = new IntArrayList();
        IntArrayList intArrayList3 = new IntArrayList();
        FloatArrayList floatArrayList = new FloatArrayList();
        this.A.getNonZeros(intArrayList, intArrayList2, intArrayList3, floatArrayList);
        FloatMatrix3DTest.assertEquals((int)2, (int)intArrayList.size());
        FloatMatrix3DTest.assertEquals((int)2, (int)intArrayList2.size());
        FloatMatrix3DTest.assertEquals((int)2, (int)intArrayList3.size());
        FloatMatrix3DTest.assertEquals((int)2, (int)floatArrayList.size());
        FloatMatrix3DTest.assertTrue((boolean)intArrayList.contains(this.NSLICES / 3));
        FloatMatrix3DTest.assertTrue((boolean)intArrayList.contains(this.NSLICES / 2));
        FloatMatrix3DTest.assertTrue((boolean)intArrayList2.contains(this.NROWS / 3));
        FloatMatrix3DTest.assertTrue((boolean)intArrayList2.contains(this.NROWS / 2));
        FloatMatrix3DTest.assertTrue((boolean)intArrayList3.contains(this.NCOLUMNS / 3));
        FloatMatrix3DTest.assertTrue((boolean)intArrayList3.contains(this.NCOLUMNS / 2));
        FloatMatrix3DTest.assertTrue((boolean)floatArrayList.contains(0.7f));
        FloatMatrix3DTest.assertTrue((boolean)floatArrayList.contains(0.1f));
    }

    public void testGetPositiveValues() {
        this.A.assign(0.0f);
        this.A.setQuick(this.NSLICES / 3, this.NROWS / 3, this.NCOLUMNS / 3, 0.7f);
        this.A.setQuick(this.NSLICES / 2, this.NROWS / 2, this.NCOLUMNS / 2, 0.1f);
        IntArrayList intArrayList = new IntArrayList();
        IntArrayList intArrayList2 = new IntArrayList();
        IntArrayList intArrayList3 = new IntArrayList();
        FloatArrayList floatArrayList = new FloatArrayList();
        this.A.getPositiveValues(intArrayList, intArrayList2, intArrayList3, floatArrayList);
        FloatMatrix3DTest.assertEquals((int)2, (int)intArrayList.size());
        FloatMatrix3DTest.assertEquals((int)2, (int)intArrayList2.size());
        FloatMatrix3DTest.assertEquals((int)2, (int)intArrayList3.size());
        FloatMatrix3DTest.assertEquals((int)2, (int)floatArrayList.size());
        FloatMatrix3DTest.assertTrue((boolean)intArrayList.contains(this.NSLICES / 3));
        FloatMatrix3DTest.assertTrue((boolean)intArrayList.contains(this.NSLICES / 2));
        FloatMatrix3DTest.assertTrue((boolean)intArrayList2.contains(this.NROWS / 3));
        FloatMatrix3DTest.assertTrue((boolean)intArrayList2.contains(this.NROWS / 2));
        FloatMatrix3DTest.assertTrue((boolean)intArrayList3.contains(this.NCOLUMNS / 3));
        FloatMatrix3DTest.assertTrue((boolean)intArrayList3.contains(this.NCOLUMNS / 2));
        FloatMatrix3DTest.assertTrue((boolean)floatArrayList.contains(0.7f));
        FloatMatrix3DTest.assertTrue((boolean)floatArrayList.contains(0.1f));
    }

    public void testToArray() {
        float[][][] fArray = this.A.toArray();
        for (int i = 0; i < this.NSLICES; ++i) {
            FloatMatrix3DTest.assertTrue((this.NROWS == fArray[i].length ? 1 : 0) != 0);
            for (int j = 0; j < this.NROWS; ++j) {
                FloatMatrix3DTest.assertTrue((this.NCOLUMNS == fArray[i][j].length ? 1 : 0) != 0);
                for (int k = 0; k < this.NCOLUMNS; ++k) {
                    FloatMatrix3DTest.assertEquals((float)0.0f, (float)Math.abs(fArray[i][j][k] - this.A.getQuick(i, j, k)), (float)this.TOL);
                }
            }
        }
    }

    public void testVectorize() {
        FloatMatrix1D floatMatrix1D = this.A.vectorize();
        int n = 0;
        for (int i = 0; i < this.NSLICES; ++i) {
            for (int j = 0; j < this.NCOLUMNS; ++j) {
                for (int k = 0; k < this.NROWS; ++k) {
                    FloatMatrix3DTest.assertEquals((float)this.A.getQuick(i, k, j), (float)floatMatrix1D.getQuick(n++), (float)this.TOL);
                }
            }
        }
    }

    public void testViewColumn() {
        FloatMatrix2D floatMatrix2D = this.A.viewColumn(this.NCOLUMNS / 2);
        FloatMatrix3DTest.assertEquals((int)this.NSLICES, (int)floatMatrix2D.rows());
        FloatMatrix3DTest.assertEquals((int)this.NROWS, (int)floatMatrix2D.columns());
        for (int i = 0; i < this.NSLICES; ++i) {
            for (int j = 0; j < this.NROWS; ++j) {
                FloatMatrix3DTest.assertEquals((float)this.A.getQuick(i, j, this.NCOLUMNS / 2), (float)floatMatrix2D.getQuick(i, j), (float)this.TOL);
            }
        }
    }

    public void testViewColumnFlip() {
        FloatMatrix3D floatMatrix3D = this.A.viewColumnFlip();
        FloatMatrix3DTest.assertEquals((int)this.A.size(), (int)floatMatrix3D.size());
        for (int i = 0; i < this.NSLICES; ++i) {
            for (int j = 0; j < this.NROWS; ++j) {
                for (int k = 0; k < this.NCOLUMNS; ++k) {
                    FloatMatrix3DTest.assertEquals((float)this.A.getQuick(i, j, this.NCOLUMNS - 1 - k), (float)floatMatrix3D.getQuick(i, j, k), (float)this.TOL);
                }
            }
        }
    }

    public void testViewDice() {
        FloatMatrix3D floatMatrix3D = this.A.viewDice(2, 1, 0);
        FloatMatrix3DTest.assertEquals((int)this.A.slices(), (int)floatMatrix3D.columns());
        FloatMatrix3DTest.assertEquals((int)this.A.rows(), (int)floatMatrix3D.rows());
        FloatMatrix3DTest.assertEquals((int)this.A.columns(), (int)floatMatrix3D.slices());
        for (int i = 0; i < this.NSLICES; ++i) {
            for (int j = 0; j < this.NROWS; ++j) {
                for (int k = 0; k < this.NCOLUMNS; ++k) {
                    FloatMatrix3DTest.assertEquals((float)this.A.getQuick(i, j, k), (float)floatMatrix3D.getQuick(k, j, i), (float)this.TOL);
                }
            }
        }
    }

    public void testViewPart() {
        FloatMatrix3D floatMatrix3D = this.A.viewPart(this.NSLICES / 2, this.NROWS / 2, this.NCOLUMNS / 2, this.NSLICES / 3, this.NROWS / 3, this.NCOLUMNS / 3);
        for (int i = 0; i < this.NSLICES / 3; ++i) {
            for (int j = 0; j < this.NROWS / 3; ++j) {
                for (int k = 0; k < this.NCOLUMNS / 3; ++k) {
                    FloatMatrix3DTest.assertEquals((float)this.A.getQuick(this.NSLICES / 2 + i, this.NROWS / 2 + j, this.NCOLUMNS / 2 + k), (float)floatMatrix3D.getQuick(i, j, k), (float)this.TOL);
                }
            }
        }
    }

    public void testViewRow() {
        FloatMatrix2D floatMatrix2D = this.A.viewRow(this.NROWS / 2);
        FloatMatrix3DTest.assertEquals((int)this.NSLICES, (int)floatMatrix2D.rows());
        FloatMatrix3DTest.assertEquals((int)this.NCOLUMNS, (int)floatMatrix2D.columns());
        for (int i = 0; i < this.NSLICES; ++i) {
            for (int j = 0; j < this.NCOLUMNS; ++j) {
                FloatMatrix3DTest.assertEquals((float)this.A.getQuick(i, this.NROWS / 2, j), (float)floatMatrix2D.getQuick(i, j), (float)this.TOL);
            }
        }
    }

    public void testViewRowFlip() {
        FloatMatrix3D floatMatrix3D = this.A.viewRowFlip();
        FloatMatrix3DTest.assertEquals((int)this.A.size(), (int)floatMatrix3D.size());
        for (int i = 0; i < this.NSLICES; ++i) {
            for (int j = 0; j < this.NROWS; ++j) {
                for (int k = 0; k < this.NCOLUMNS; ++k) {
                    FloatMatrix3DTest.assertEquals((float)this.A.getQuick(i, this.NROWS - 1 - j, k), (float)floatMatrix3D.getQuick(i, j, k), (float)this.TOL);
                }
            }
        }
    }

    public void testViewSelectionFloatMatrix2DProcedure() {
        this.A.assign(0.0f);
        this.A.setQuick(this.NSLICES / 2, this.NROWS / 4, 0, 2.0f);
        FloatMatrix3D floatMatrix3D = this.A.viewSelection(new FloatMatrix2DProcedure(){

            public boolean apply(FloatMatrix2D floatMatrix2D) {
                return Math.abs(floatMatrix2D.getQuick(FloatMatrix3DTest.this.NROWS / 4, 0) - 2.0f) <= FloatMatrix3DTest.this.TOL;
            }
        });
        FloatMatrix3DTest.assertEquals((int)1, (int)floatMatrix3D.slices());
        FloatMatrix3DTest.assertEquals((int)this.A.rows(), (int)floatMatrix3D.rows());
        FloatMatrix3DTest.assertEquals((int)this.A.columns(), (int)floatMatrix3D.columns());
        FloatMatrix3DTest.assertEquals((float)this.A.getQuick(this.NSLICES / 2, this.NROWS / 4, 0), (float)floatMatrix3D.getQuick(0, this.NROWS / 4, 0), (float)this.TOL);
    }

    public void testViewSelectionIntArrayIntArrayIntArray() {
        int[] nArray = new int[]{this.NSLICES / 2, this.NSLICES / 3};
        int[] nArray2 = new int[]{this.NROWS / 6, this.NROWS / 5, this.NROWS / 4, this.NROWS / 3, this.NROWS / 2};
        int[] nArray3 = new int[]{this.NCOLUMNS / 6, this.NCOLUMNS / 5, this.NCOLUMNS / 4, this.NCOLUMNS / 3, this.NCOLUMNS / 2, this.NCOLUMNS - 1};
        FloatMatrix3D floatMatrix3D = this.A.viewSelection(nArray, nArray2, nArray3);
        FloatMatrix3DTest.assertEquals((int)nArray.length, (int)floatMatrix3D.slices());
        FloatMatrix3DTest.assertEquals((int)nArray2.length, (int)floatMatrix3D.rows());
        FloatMatrix3DTest.assertEquals((int)nArray3.length, (int)floatMatrix3D.columns());
        for (int i = 0; i < nArray.length; ++i) {
            for (int j = 0; j < nArray2.length; ++j) {
                for (int k = 0; k < nArray3.length; ++k) {
                    FloatMatrix3DTest.assertEquals((float)this.A.getQuick(nArray[i], nArray2[j], nArray3[k]), (float)floatMatrix3D.getQuick(i, j, k), (float)this.TOL);
                }
            }
        }
    }

    public void testViewSlice() {
        FloatMatrix2D floatMatrix2D = this.A.viewSlice(this.NSLICES / 2);
        FloatMatrix3DTest.assertEquals((int)this.NROWS, (int)floatMatrix2D.rows());
        FloatMatrix3DTest.assertEquals((int)this.NCOLUMNS, (int)floatMatrix2D.columns());
        for (int i = 0; i < this.NROWS; ++i) {
            for (int j = 0; j < this.NCOLUMNS; ++j) {
                FloatMatrix3DTest.assertEquals((float)this.A.getQuick(this.NSLICES / 2, i, j), (float)floatMatrix2D.getQuick(i, j), (float)this.TOL);
            }
        }
    }

    public void testViewSliceFlip() {
        FloatMatrix3D floatMatrix3D = this.A.viewSliceFlip();
        FloatMatrix3DTest.assertEquals((int)this.A.size(), (int)floatMatrix3D.size());
        for (int i = 0; i < this.NSLICES; ++i) {
            for (int j = 0; j < this.NROWS; ++j) {
                for (int k = 0; k < this.NCOLUMNS; ++k) {
                    FloatMatrix3DTest.assertEquals((float)this.A.getQuick(this.NSLICES - 1 - i, j, k), (float)floatMatrix3D.getQuick(i, j, k), (float)this.TOL);
                }
            }
        }
    }

    public void testViewSorted() {
        FloatMatrix3D floatMatrix3D = this.A.viewSorted(1, 1);
        for (int i = 0; i < this.NSLICES - 1; ++i) {
            FloatMatrix3DTest.assertTrue((floatMatrix3D.getQuick(i + 1, 1, 1) >= floatMatrix3D.getQuick(i, 1, 1) ? 1 : 0) != 0);
        }
    }

    public void testViewStrides() {
        int n = 2;
        int n2 = 2;
        int n3 = 2;
        FloatMatrix3D floatMatrix3D = this.A.viewStrides(n, n2, n3);
        for (int i = 0; i < floatMatrix3D.slices(); ++i) {
            for (int j = 0; j < floatMatrix3D.rows(); ++j) {
                for (int k = 0; k < floatMatrix3D.columns(); ++k) {
                    FloatMatrix3DTest.assertEquals((float)this.A.getQuick(i * n, j * n2, k * n3), (float)floatMatrix3D.getQuick(i, j, k), (float)this.TOL);
                }
            }
        }
    }

    public void testZSum() {
        float f = this.A.zSum();
        float f2 = 0.0f;
        for (int i = 0; i < this.NSLICES; ++i) {
            for (int j = 0; j < this.NROWS; ++j) {
                for (int k = 0; k < this.NCOLUMNS; ++k) {
                    f2 += this.A.getQuick(i, j, k);
                }
            }
        }
        FloatMatrix3DTest.assertEquals((float)f2, (float)f, (float)this.TOL);
    }
}

