/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfloat;

import cern.colt.function.tfloat.Float9Function;
import cern.colt.function.tfloat.FloatFloatFunction;
import cern.colt.function.tfloat.FloatFunction;
import cern.colt.function.tfloat.FloatProcedure;
import cern.colt.function.tfloat.IntIntFloatFunction;
import cern.colt.list.tfloat.FloatArrayList;
import cern.colt.list.tint.IntArrayList;
import cern.colt.matrix.AbstractMatrix2D;
import cern.colt.matrix.tfloat.FloatMatrix1D;
import cern.colt.matrix.tfloat.FloatMatrix1DProcedure;
import cern.colt.matrix.tfloat.algo.FloatFormatter;
import cern.colt.matrix.tfloat.algo.FloatProperty;
import cern.colt.matrix.tfloat.algo.FloatSorting;
import cern.colt.matrix.tfloat.impl.DenseFloatMatrix1D;
import cern.colt.matrix.tfloat.impl.DenseFloatMatrix2D;
import cern.jet.math.tfloat.FloatFunctions;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FloatMatrix2D
extends AbstractMatrix2D {
    protected FloatMatrix2D() {
    }

    public float aggregate(final FloatFloatFunction floatFloatFunction, final FloatFunction floatFunction) {
        if (this.size() == 0) {
            return Float.NaN;
        }
        float f = 0.0f;
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            Future[] futureArray = new Future[n];
            Float[] floatArray = new Float[n];
            int n2 = this.rows / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.rows : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Callable<Float>(){

                    @Override
                    public Float call() throws Exception {
                        float f = floatFunction.apply(FloatMatrix2D.this.getQuick(n3, 0));
                        int n = 1;
                        for (int i = n3; i < n4; ++i) {
                            for (int j = n; j < FloatMatrix2D.this.columns; ++j) {
                                f = floatFloatFunction.apply(f, floatFunction.apply(FloatMatrix2D.this.getQuick(i, j)));
                            }
                            n = 0;
                        }
                        return Float.valueOf(f);
                    }
                });
            }
            f = ConcurrencyUtils.waitForCompletion(futureArray, floatFloatFunction);
        } else {
            f = floatFunction.apply(this.getQuick(0, 0));
            int n5 = 1;
            for (int i = 0; i < this.rows; ++i) {
                for (int j = n5; j < this.columns; ++j) {
                    f = floatFloatFunction.apply(f, floatFunction.apply(this.getQuick(i, j)));
                }
                n5 = 0;
            }
        }
        return f;
    }

    public float aggregate(final FloatFloatFunction floatFloatFunction, final FloatFunction floatFunction, final FloatProcedure floatProcedure) {
        if (this.size() == 0) {
            return Float.NaN;
        }
        float f = 0.0f;
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            Future[] futureArray = new Future[n];
            Float[] floatArray = new Float[n];
            int n2 = this.rows / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.rows : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Callable<Float>(){

                    @Override
                    public Float call() throws Exception {
                        float f = FloatMatrix2D.this.getQuick(n3, 0);
                        float f2 = 0.0f;
                        if (floatProcedure.apply(f)) {
                            f2 = floatFloatFunction.apply(f2, floatFunction.apply(f));
                        }
                        int n = 1;
                        for (int i = n3; i < n4; ++i) {
                            for (int j = n; j < FloatMatrix2D.this.columns; ++j) {
                                f = FloatMatrix2D.this.getQuick(i, j);
                                if (!floatProcedure.apply(f)) continue;
                                f2 = floatFloatFunction.apply(f2, floatFunction.apply(f));
                            }
                            n = 0;
                        }
                        return Float.valueOf(f2);
                    }
                });
            }
            f = ConcurrencyUtils.waitForCompletion(futureArray, floatFloatFunction);
        } else {
            float f2 = this.getQuick(0, 0);
            if (floatProcedure.apply(f2)) {
                f = floatFloatFunction.apply(f, floatFunction.apply(f2));
            }
            int n5 = 1;
            for (int i = 0; i < this.rows; ++i) {
                for (int j = n5; j < this.columns; ++j) {
                    f2 = this.getQuick(i, j);
                    if (!floatProcedure.apply(f2)) continue;
                    f = floatFloatFunction.apply(f, floatFunction.apply(f2));
                }
                n5 = 0;
            }
        }
        return f;
    }

    public float aggregate(final FloatFloatFunction floatFloatFunction, final FloatFunction floatFunction, IntArrayList intArrayList, IntArrayList intArrayList2) {
        if (this.size() == 0) {
            return Float.NaN;
        }
        int n = intArrayList.size();
        final int[] nArray = intArrayList.elements();
        final int[] nArray2 = intArrayList2.elements();
        float f = 0.0f;
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && n >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            Future[] futureArray = new Future[n2];
            Float[] floatArray = new Float[n2];
            int n3 = n / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? n : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Callable<Float>(){

                    @Override
                    public Float call() throws Exception {
                        float f = floatFunction.apply(FloatMatrix2D.this.getQuick(nArray[n4], nArray2[n4]));
                        for (int i = n4 + 1; i < n5; ++i) {
                            float f2 = FloatMatrix2D.this.getQuick(nArray[i], nArray2[i]);
                            f = floatFloatFunction.apply(f, floatFunction.apply(f2));
                        }
                        return Float.valueOf(f);
                    }
                });
            }
            f = ConcurrencyUtils.waitForCompletion(futureArray, floatFloatFunction);
        } else {
            f = floatFunction.apply(this.getQuick(nArray[0], nArray2[0]));
            for (int i = 1; i < n; ++i) {
                float f2 = this.getQuick(nArray[i], nArray2[i]);
                f = floatFloatFunction.apply(f, floatFunction.apply(f2));
            }
        }
        return f;
    }

    public float aggregate(final FloatMatrix2D floatMatrix2D, final FloatFloatFunction floatFloatFunction, final FloatFloatFunction floatFloatFunction2) {
        this.checkShape(floatMatrix2D);
        if (this.size() == 0) {
            return Float.NaN;
        }
        float f = 0.0f;
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            Future[] futureArray = new Future[n];
            Float[] floatArray = new Float[n];
            int n2 = this.rows / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.rows : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Callable<Float>(){

                    @Override
                    public Float call() throws Exception {
                        float f = floatFloatFunction2.apply(FloatMatrix2D.this.getQuick(n3, 0), floatMatrix2D.getQuick(n3, 0));
                        int n = 1;
                        for (int i = n3; i < n4; ++i) {
                            for (int j = n; j < FloatMatrix2D.this.columns; ++j) {
                                f = floatFloatFunction.apply(f, floatFloatFunction2.apply(FloatMatrix2D.this.getQuick(i, j), floatMatrix2D.getQuick(i, j)));
                            }
                            n = 0;
                        }
                        return Float.valueOf(f);
                    }
                });
            }
            f = ConcurrencyUtils.waitForCompletion(futureArray, floatFloatFunction);
        } else {
            f = floatFloatFunction2.apply(this.getQuick(0, 0), floatMatrix2D.getQuick(0, 0));
            int n5 = 1;
            for (int i = 0; i < this.rows; ++i) {
                for (int j = n5; j < this.columns; ++j) {
                    f = floatFloatFunction.apply(f, floatFloatFunction2.apply(this.getQuick(i, j), floatMatrix2D.getQuick(i, j)));
                }
                n5 = 0;
            }
        }
        return f;
    }

    public FloatMatrix2D assign(final FloatFunction floatFunction) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            Future[] futureArray = new Future[n];
            int n2 = this.rows / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.rows : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            for (int j = 0; j < FloatMatrix2D.this.columns; ++j) {
                                FloatMatrix2D.this.setQuick(i, j, floatFunction.apply(FloatMatrix2D.this.getQuick(i, j)));
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.rows; ++i) {
                for (int j = 0; j < this.columns; ++j) {
                    this.setQuick(i, j, floatFunction.apply(this.getQuick(i, j)));
                }
            }
        }
        return this;
    }

    public FloatMatrix2D assign(final FloatProcedure floatProcedure, final FloatFunction floatFunction) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            Future[] futureArray = new Future[n];
            int n2 = this.rows / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.rows : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            for (int j = 0; j < FloatMatrix2D.this.columns; ++j) {
                                float f = FloatMatrix2D.this.getQuick(i, j);
                                if (!floatProcedure.apply(f)) continue;
                                FloatMatrix2D.this.setQuick(i, j, floatFunction.apply(f));
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.rows; ++i) {
                for (int j = 0; j < this.columns; ++j) {
                    float f = this.getQuick(i, j);
                    if (!floatProcedure.apply(f)) continue;
                    this.setQuick(i, j, floatFunction.apply(f));
                }
            }
        }
        return this;
    }

    public FloatMatrix2D assign(final FloatProcedure floatProcedure, final float f) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            Future[] futureArray = new Future[n];
            int n2 = this.rows / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.rows : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            for (int j = 0; j < FloatMatrix2D.this.columns; ++j) {
                                float f2 = FloatMatrix2D.this.getQuick(i, j);
                                if (!floatProcedure.apply(f2)) continue;
                                FloatMatrix2D.this.setQuick(i, j, f);
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.rows; ++i) {
                for (int j = 0; j < this.columns; ++j) {
                    float f2 = this.getQuick(i, j);
                    if (!floatProcedure.apply(f2)) continue;
                    this.setQuick(i, j, f);
                }
            }
        }
        return this;
    }

    public FloatMatrix2D assign(final float f) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            Future[] futureArray = new Future[n];
            int n2 = this.rows / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.rows : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            for (int j = 0; j < FloatMatrix2D.this.columns; ++j) {
                                FloatMatrix2D.this.setQuick(i, j, f);
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.rows; ++i) {
                for (int j = 0; j < this.columns; ++j) {
                    this.setQuick(i, j, f);
                }
            }
        }
        return this;
    }

    public FloatMatrix2D assign(final float[] fArray) {
        if (fArray.length != this.rows * this.columns) {
            throw new IllegalArgumentException("Must have same length: length=" + fArray.length + "rows()*columns()=" + this.rows() * this.columns());
        }
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            Future[] futureArray = new Future[n];
            int n2 = this.rows / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i * n2 * this.columns;
                final int n5 = i == n - 1 ? this.rows : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n = n4;
                        for (int i = n3; i < n5; ++i) {
                            for (int j = 0; j < FloatMatrix2D.this.columns; ++j) {
                                FloatMatrix2D.this.setQuick(i, j, fArray[n++]);
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n6 = 0;
            for (int i = 0; i < this.rows; ++i) {
                for (int j = 0; j < this.columns; ++j) {
                    this.setQuick(i, j, fArray[n6++]);
                }
            }
        }
        return this;
    }

    public FloatMatrix2D assign(final float[][] fArray) {
        if (fArray.length != this.rows) {
            throw new IllegalArgumentException("Must have same number of rows: rows=" + fArray.length + "rows()=" + this.rows());
        }
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            Future[] futureArray = new Future[n];
            int n2 = this.rows / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.rows : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            float[] fArray2 = fArray[i];
                            if (fArray2.length != FloatMatrix2D.this.columns) {
                                throw new IllegalArgumentException("Must have same number of columns in every row: columns=" + fArray2.length + "columns()=" + FloatMatrix2D.this.columns());
                            }
                            for (int j = 0; j < FloatMatrix2D.this.columns; ++j) {
                                FloatMatrix2D.this.setQuick(i, j, fArray2[j]);
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.rows; ++i) {
                float[] fArray2 = fArray[i];
                if (fArray2.length != this.columns) {
                    throw new IllegalArgumentException("Must have same number of columns in every row: columns=" + fArray2.length + "columns()=" + this.columns());
                }
                for (int j = 0; j < this.columns; ++j) {
                    this.setQuick(i, j, fArray2[j]);
                }
            }
        }
        return this;
    }

    public FloatMatrix2D assign(FloatMatrix2D floatMatrix2D) {
        if (floatMatrix2D == this) {
            return this;
        }
        this.checkShape(floatMatrix2D);
        final FloatMatrix2D floatMatrix2D2 = this.haveSharedCells(floatMatrix2D) ? floatMatrix2D.copy() : floatMatrix2D;
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            Future[] futureArray = new Future[n];
            int n2 = this.rows / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.rows : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            for (int j = 0; j < FloatMatrix2D.this.columns; ++j) {
                                FloatMatrix2D.this.setQuick(i, j, floatMatrix2D2.getQuick(i, j));
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.rows; ++i) {
                for (int j = 0; j < this.columns; ++j) {
                    this.setQuick(i, j, floatMatrix2D2.getQuick(i, j));
                }
            }
        }
        return this;
    }

    public FloatMatrix2D assign(final FloatMatrix2D floatMatrix2D, final FloatFloatFunction floatFloatFunction) {
        this.checkShape(floatMatrix2D);
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            Future[] futureArray = new Future[n];
            int n2 = this.rows / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.rows : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            for (int j = 0; j < FloatMatrix2D.this.columns; ++j) {
                                FloatMatrix2D.this.setQuick(i, j, floatFloatFunction.apply(FloatMatrix2D.this.getQuick(i, j), floatMatrix2D.getQuick(i, j)));
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.rows; ++i) {
                for (int j = 0; j < this.columns; ++j) {
                    this.setQuick(i, j, floatFloatFunction.apply(this.getQuick(i, j), floatMatrix2D.getQuick(i, j)));
                }
            }
        }
        return this;
    }

    public FloatMatrix2D assign(final FloatMatrix2D floatMatrix2D, final FloatFloatFunction floatFloatFunction, IntArrayList intArrayList, IntArrayList intArrayList2) {
        this.checkShape(floatMatrix2D);
        int n = intArrayList.size();
        final int[] nArray = intArrayList.elements();
        final int[] nArray2 = intArrayList2.elements();
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && n >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            Future[] futureArray = new Future[n2];
            int n3 = n / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? n : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n4; i < n5; ++i) {
                            FloatMatrix2D.this.setQuick(nArray[i], nArray2[i], floatFloatFunction.apply(FloatMatrix2D.this.getQuick(nArray[i], nArray2[i]), floatMatrix2D.getQuick(nArray[i], nArray2[i])));
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < n; ++i) {
                this.setQuick(nArray[i], nArray2[i], floatFloatFunction.apply(this.getQuick(nArray[i], nArray2[i]), floatMatrix2D.getQuick(nArray[i], nArray2[i])));
            }
        }
        return this;
    }

    public int cardinality() {
        int n = 0;
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            int n3;
            Future[] futureArray = new Future[n2];
            Integer[] integerArray = new Integer[n2];
            int n4 = this.rows / n2;
            for (n3 = 0; n3 < n2; ++n3) {
                final int n5 = n3 * n4;
                final int n6 = n3 == n2 - 1 ? this.rows : n5 + n4;
                futureArray[n3] = ConcurrencyUtils.submit(new Callable<Integer>(){

                    @Override
                    public Integer call() throws Exception {
                        int n = 0;
                        for (int i = n5; i < n6; ++i) {
                            for (int j = 0; j < FloatMatrix2D.this.columns; ++j) {
                                if (FloatMatrix2D.this.getQuick(i, j) == 0.0f) continue;
                                ++n;
                            }
                        }
                        return n;
                    }
                });
            }
            try {
                for (n3 = 0; n3 < n2; ++n3) {
                    integerArray[n3] = (Integer)futureArray[n3].get();
                }
                n = integerArray[0];
                for (n3 = 1; n3 < n2; ++n3) {
                    n += integerArray[n3].intValue();
                }
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        } else {
            for (int i = 0; i < this.rows; ++i) {
                for (int j = 0; j < this.columns; ++j) {
                    if (this.getQuick(i, j) == 0.0f) continue;
                    ++n;
                }
            }
        }
        return n;
    }

    public FloatMatrix2D copy() {
        return this.like().assign(this);
    }

    public abstract Object elements();

    public boolean equals(float f) {
        return FloatProperty.DEFAULT.equals(this, f);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof FloatMatrix2D)) {
            return false;
        }
        return FloatProperty.DEFAULT.equals(this, (FloatMatrix2D)object);
    }

    public FloatMatrix2D forEachNonZero(final IntIntFloatFunction intIntFloatFunction) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            Future[] futureArray = new Future[n];
            int n2 = this.rows / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.rows : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            for (int j = 0; j < FloatMatrix2D.this.columns; ++j) {
                                float f;
                                float f2 = FloatMatrix2D.this.getQuick(i, j);
                                if (f2 == 0.0f || (f = intIntFloatFunction.apply(i, j, f2)) == f2) continue;
                                FloatMatrix2D.this.setQuick(i, j, f);
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.rows; ++i) {
                for (int j = 0; j < this.columns; ++j) {
                    float f;
                    float f2 = this.getQuick(i, j);
                    if (f2 == 0.0f || (f = intIntFloatFunction.apply(i, j, f2)) == f2) continue;
                    this.setQuick(i, j, f);
                }
            }
        }
        return this;
    }

    public float get(int n, int n2) {
        if (n2 < 0 || n2 >= this.columns || n < 0 || n >= this.rows) {
            throw new IndexOutOfBoundsException("row:" + n + ", column:" + n2);
        }
        return this.getQuick(n, n2);
    }

    protected FloatMatrix2D getContent() {
        return this;
    }

    public void getNegativeValues(IntArrayList intArrayList, IntArrayList intArrayList2, FloatArrayList floatArrayList) {
        intArrayList.clear();
        intArrayList2.clear();
        floatArrayList.clear();
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.columns; ++j) {
                float f = this.getQuick(i, j);
                if (!(f < 0.0f)) continue;
                intArrayList.add(i);
                intArrayList2.add(j);
                floatArrayList.add(f);
            }
        }
    }

    public void getNonZeros(IntArrayList intArrayList, IntArrayList intArrayList2, FloatArrayList floatArrayList) {
        intArrayList.clear();
        intArrayList2.clear();
        floatArrayList.clear();
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.columns; ++j) {
                float f = this.getQuick(i, j);
                if (f == 0.0f) continue;
                intArrayList.add(i);
                intArrayList2.add(j);
                floatArrayList.add(f);
            }
        }
    }

    public void getPositiveValues(IntArrayList intArrayList, IntArrayList intArrayList2, FloatArrayList floatArrayList) {
        intArrayList.clear();
        intArrayList2.clear();
        floatArrayList.clear();
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.columns; ++j) {
                float f = this.getQuick(i, j);
                if (!(f > 0.0f)) continue;
                intArrayList.add(i);
                intArrayList2.add(j);
                floatArrayList.add(f);
            }
        }
    }

    public abstract float getQuick(int var1, int var2);

    protected boolean haveSharedCells(FloatMatrix2D floatMatrix2D) {
        if (floatMatrix2D == null) {
            return false;
        }
        if (this == floatMatrix2D) {
            return true;
        }
        return this.getContent().haveSharedCellsRaw(floatMatrix2D.getContent());
    }

    protected boolean haveSharedCellsRaw(FloatMatrix2D floatMatrix2D) {
        return false;
    }

    public FloatMatrix2D like() {
        return this.like(this.rows, this.columns);
    }

    public abstract FloatMatrix2D like(int var1, int var2);

    public abstract FloatMatrix1D like1D(int var1);

    protected abstract FloatMatrix1D like1D(int var1, int var2, int var3);

    public float[] getMaxLocation() {
        int n = 0;
        int n2 = 0;
        float f = 0.0f;
        int n3 = ConcurrencyUtils.getNumberOfThreads();
        if (n3 > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            int n4;
            Future[] futureArray = new Future[n3];
            float[][] fArray = new float[n3][2];
            int n5 = this.rows / n3;
            for (n4 = 0; n4 < n3; ++n4) {
                final int n6 = n4 * n5;
                final int n7 = n4 == n3 - 1 ? this.rows : n6 + n5;
                futureArray[n4] = ConcurrencyUtils.submit(new Callable<float[]>(){

                    @Override
                    public float[] call() throws Exception {
                        int n = n6;
                        int n2 = 0;
                        float f = FloatMatrix2D.this.getQuick(n, 0);
                        int n3 = 1;
                        for (int i = n6; i < n7; ++i) {
                            for (int j = n3; j < FloatMatrix2D.this.columns; ++j) {
                                float f2 = FloatMatrix2D.this.getQuick(i, j);
                                if (!(f < f2)) continue;
                                f = f2;
                                n = i;
                                n2 = j;
                            }
                            n3 = 0;
                        }
                        return new float[]{f, n, n2};
                    }
                });
            }
            try {
                for (n4 = 0; n4 < n3; ++n4) {
                    fArray[n4] = (float[])futureArray[n4].get();
                }
                f = fArray[0][0];
                n = (int)fArray[0][1];
                n2 = (int)fArray[0][2];
                for (n4 = 1; n4 < n3; ++n4) {
                    if (!(f < fArray[n4][0])) continue;
                    f = fArray[n4][0];
                    n = (int)fArray[n4][1];
                    n2 = (int)fArray[n4][2];
                }
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        } else {
            f = this.getQuick(0, 0);
            int n8 = 1;
            for (int i = 0; i < this.rows; ++i) {
                for (int j = n8; j < this.columns; ++j) {
                    float f2 = this.getQuick(i, j);
                    if (!(f < f2)) continue;
                    f = f2;
                    n = i;
                    n2 = j;
                }
                n8 = 0;
            }
        }
        return new float[]{f, n, n2};
    }

    public float[] getMinLocation() {
        int n = 0;
        int n2 = 0;
        float f = 0.0f;
        int n3 = ConcurrencyUtils.getNumberOfThreads();
        if (n3 > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            int n4;
            Future[] futureArray = new Future[n3];
            float[][] fArray = new float[n3][2];
            int n5 = this.rows / n3;
            for (n4 = 0; n4 < n3; ++n4) {
                final int n6 = n4 * n5;
                final int n7 = n4 == n3 - 1 ? this.rows : n6 + n5;
                futureArray[n4] = ConcurrencyUtils.submit(new Callable<float[]>(){

                    @Override
                    public float[] call() throws Exception {
                        int n = n6;
                        int n2 = 0;
                        float f = FloatMatrix2D.this.getQuick(n, 0);
                        int n3 = 1;
                        for (int i = n6; i < n7; ++i) {
                            for (int j = n3; j < FloatMatrix2D.this.columns; ++j) {
                                float f2 = FloatMatrix2D.this.getQuick(i, j);
                                if (!(f > f2)) continue;
                                f = f2;
                                n = i;
                                n2 = j;
                            }
                            n3 = 0;
                        }
                        return new float[]{f, n, n2};
                    }
                });
            }
            try {
                for (n4 = 0; n4 < n3; ++n4) {
                    fArray[n4] = (float[])futureArray[n4].get();
                }
                f = fArray[0][0];
                n = (int)fArray[0][1];
                n2 = (int)fArray[0][2];
                for (n4 = 1; n4 < n3; ++n4) {
                    if (!(f > fArray[n4][0])) continue;
                    f = fArray[n4][0];
                    n = (int)fArray[n4][1];
                    n2 = (int)fArray[n4][2];
                }
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        } else {
            f = this.getQuick(0, 0);
            int n8 = 1;
            for (int i = 0; i < this.rows; ++i) {
                for (int j = n8; j < this.columns; ++j) {
                    float f2 = this.getQuick(i, j);
                    if (!(f > f2)) continue;
                    f = f2;
                    n = i;
                    n2 = j;
                }
                n8 = 0;
            }
        }
        return new float[]{f, n, n2};
    }

    public void normalize() {
        float f = this.getMinLocation()[0];
        if (f < 0.0f) {
            this.assign(FloatFunctions.minus(f));
        }
        if (this.getMaxLocation()[0] == 0.0f) {
            this.assign((float)(1.0 / (double)this.size()));
        } else {
            float f2 = this.zSum();
            f2 = (float)(1.0 / (double)f2);
            this.assign(FloatFunctions.mult(f2));
        }
    }

    public void set(int n, int n2, float f) {
        if (n2 < 0 || n2 >= this.columns || n < 0 || n >= this.rows) {
            throw new IndexOutOfBoundsException("row:" + n + ", column:" + n2);
        }
        this.setQuick(n, n2, f);
    }

    public abstract void setQuick(int var1, int var2, float var3);

    public float[][] toArray() {
        final float[][] fArray = new float[this.rows][this.columns];
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            Future[] futureArray = new Future[n];
            int n2 = this.rows / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.rows : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            float[] fArray2 = fArray[i];
                            for (int j = 0; j < FloatMatrix2D.this.columns; ++j) {
                                fArray2[j] = FloatMatrix2D.this.getQuick(i, j);
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.rows; ++i) {
                float[] fArray2 = fArray[i];
                for (int j = 0; j < this.columns; ++j) {
                    fArray2[j] = this.getQuick(i, j);
                }
            }
        }
        return fArray;
    }

    public String toString() {
        return new FloatFormatter().toString(this);
    }

    public abstract FloatMatrix1D vectorize();

    protected FloatMatrix2D view() {
        return (FloatMatrix2D)this.clone();
    }

    public FloatMatrix1D viewColumn(int n) {
        this.checkColumn(n);
        int n2 = this.rows;
        int n3 = (int)this.index(0, n);
        int n4 = this.rowStride;
        return this.like1D(n2, n3, n4);
    }

    public FloatMatrix2D viewColumnFlip() {
        return (FloatMatrix2D)this.view().vColumnFlip();
    }

    public FloatMatrix2D viewDice() {
        return (FloatMatrix2D)this.view().vDice();
    }

    public FloatMatrix2D viewPart(int n, int n2, int n3, int n4) {
        return (FloatMatrix2D)this.view().vPart(n, n2, n3, n4);
    }

    public FloatMatrix1D viewRow(int n) {
        this.checkRow(n);
        int n2 = this.columns;
        int n3 = (int)this.index(n, 0);
        int n4 = this.columnStride;
        return this.like1D(n2, n3, n4);
    }

    public FloatMatrix2D viewRowFlip() {
        return (FloatMatrix2D)this.view().vRowFlip();
    }

    public FloatMatrix2D viewSelection(FloatMatrix1DProcedure floatMatrix1DProcedure) {
        IntArrayList intArrayList = new IntArrayList();
        for (int i = 0; i < this.rows; ++i) {
            if (!floatMatrix1DProcedure.apply(this.viewRow(i))) continue;
            intArrayList.add(i);
        }
        intArrayList.trimToSize();
        return this.viewSelection(intArrayList.elements(), null);
    }

    public FloatMatrix2D viewSelection(int[] nArray, int[] nArray2) {
        int n;
        int n2;
        if (nArray == null) {
            nArray = new int[this.rows];
            for (n2 = 0; n2 < this.rows; ++n2) {
                nArray[n2] = n2;
            }
        }
        if (nArray2 == null) {
            nArray2 = new int[this.columns];
            for (n2 = 0; n2 < this.columns; ++n2) {
                nArray2[n2] = n2;
            }
        }
        this.checkRowIndexes(nArray);
        this.checkColumnIndexes(nArray2);
        int[] nArray3 = new int[nArray.length];
        int[] nArray4 = new int[nArray2.length];
        for (n = 0; n < nArray.length; ++n) {
            nArray3[n] = this._rowOffset(this._rowRank(nArray[n]));
        }
        for (n = 0; n < nArray2.length; ++n) {
            nArray4[n] = this._columnOffset(this._columnRank(nArray2[n]));
        }
        return this.viewSelectionLike(nArray3, nArray4);
    }

    public FloatMatrix2D viewSelection(Set<int[]> set) {
        int n;
        int[] nArray4;
        int n2 = set.size();
        int[] nArray2 = new int[n2];
        int[] nArray3 = new int[n2];
        int n3 = 0;
        for (int[] nArray4 : set) {
            nArray2[n3] = nArray4[0];
            nArray3[n3] = nArray4[1];
            ++n3;
        }
        this.checkRowIndexes(nArray2);
        this.checkColumnIndexes(nArray3);
        Object object = new int[nArray2.length];
        nArray4 = new int[nArray3.length];
        for (n = 0; n < nArray2.length; ++n) {
            object[n] = this._rowOffset(this._rowRank(nArray2[n]));
        }
        for (n = 0; n < nArray3.length; ++n) {
            nArray4[n] = this._columnOffset(this._columnRank(nArray3[n]));
        }
        return this.viewSelectionLike((int[])object, nArray4);
    }

    protected abstract FloatMatrix2D viewSelectionLike(int[] var1, int[] var2);

    public FloatMatrix2D viewSorted(int n) {
        return FloatSorting.mergeSort.sort(this, n);
    }

    public FloatMatrix2D viewStrides(int n, int n2) {
        return (FloatMatrix2D)this.view().vStrides(n, n2);
    }

    public void zAssign8Neighbors(FloatMatrix2D floatMatrix2D, Float9Function float9Function) {
        if (float9Function == null) {
            throw new NullPointerException("function must not be null.");
        }
        this.checkShape(floatMatrix2D);
        if (this.rows < 3 || this.columns < 3) {
            return;
        }
        int n = this.rows - 1;
        int n2 = this.columns - 1;
        for (int i = 1; i < n; ++i) {
            float f = this.getQuick(i - 1, 0);
            float f2 = this.getQuick(i - 1, 1);
            float f3 = this.getQuick(i, 0);
            float f4 = this.getQuick(i, 1);
            float f5 = this.getQuick(i + 1, 0);
            float f6 = this.getQuick(i + 1, 1);
            for (int j = 1; j < n2; ++j) {
                float f7 = this.getQuick(i - 1, j + 1);
                float f8 = this.getQuick(i, j + 1);
                float f9 = this.getQuick(i + 1, j + 1);
                floatMatrix2D.setQuick(i, j, float9Function.apply(f, f2, f7, f3, f4, f8, f5, f6, f9));
                f = f2;
                f3 = f4;
                f5 = f6;
                f2 = f7;
                f4 = f8;
                f6 = f9;
            }
        }
    }

    public FloatMatrix1D zMult(FloatMatrix1D floatMatrix1D, FloatMatrix1D floatMatrix1D2) {
        return this.zMult(floatMatrix1D, floatMatrix1D2, 1.0f, 0.0f, false);
    }

    public FloatMatrix1D zMult(final FloatMatrix1D floatMatrix1D, FloatMatrix1D floatMatrix1D2, final float f, final float f2, boolean bl) {
        if (bl) {
            return this.viewDice().zMult(floatMatrix1D, floatMatrix1D2, f, f2, false);
        }
        final FloatMatrix1D floatMatrix1D3 = floatMatrix1D2 == null ? new DenseFloatMatrix1D(this.rows) : floatMatrix1D2;
        if (this.columns != floatMatrix1D.size() || this.rows > floatMatrix1D3.size()) {
            throw new IllegalArgumentException("Incompatible args: " + this.toStringShort() + ", " + floatMatrix1D.toStringShort() + ", " + floatMatrix1D3.toStringShort());
        }
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            Future[] futureArray = new Future[n];
            int n2 = this.rows / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.rows : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){
                    float[] s = new float[2];

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            float f3 = 0.0f;
                            for (int j = 0; j < FloatMatrix2D.this.columns; ++j) {
                                f3 += FloatMatrix2D.this.getQuick(i, j) * floatMatrix1D.getQuick(j);
                            }
                            floatMatrix1D3.setQuick(i, f * f3 + f2 * floatMatrix1D3.getQuick(i));
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.rows; ++i) {
                float f3 = 0.0f;
                for (int j = 0; j < this.columns; ++j) {
                    f3 += this.getQuick(i, j) * floatMatrix1D.getQuick(j);
                }
                floatMatrix1D3.setQuick(i, f * f3 + f2 * floatMatrix1D3.getQuick(i));
            }
        }
        return floatMatrix1D3;
    }

    public FloatMatrix2D zMult(FloatMatrix2D floatMatrix2D, FloatMatrix2D floatMatrix2D2) {
        return this.zMult(floatMatrix2D, floatMatrix2D2, 1.0f, 0.0f, false, false);
    }

    public FloatMatrix2D zMult(final FloatMatrix2D floatMatrix2D, FloatMatrix2D floatMatrix2D2, final float f, final float f2, boolean bl, boolean bl2) {
        if (bl) {
            return this.viewDice().zMult(floatMatrix2D, floatMatrix2D2, f, f2, false, bl2);
        }
        if (bl2) {
            return this.zMult(floatMatrix2D.viewDice(), floatMatrix2D2, f, f2, bl, false);
        }
        final int n = this.rows;
        final int n2 = this.columns;
        int n3 = floatMatrix2D.columns;
        final FloatMatrix2D floatMatrix2D3 = floatMatrix2D2 == null ? new DenseFloatMatrix2D(n, n3) : floatMatrix2D2;
        if (floatMatrix2D.rows != n2) {
            throw new IllegalArgumentException("Matrix2D inner dimensions must agree:" + this.toStringShort() + ", " + floatMatrix2D.toStringShort());
        }
        if (floatMatrix2D3.rows != n || floatMatrix2D3.columns != n3) {
            throw new IllegalArgumentException("Incompatibe result matrix: " + this.toStringShort() + ", " + floatMatrix2D.toStringShort() + ", " + floatMatrix2D3.toStringShort());
        }
        if (this == floatMatrix2D3 || floatMatrix2D == floatMatrix2D3) {
            throw new IllegalArgumentException("Matrices must not be identical");
        }
        int n4 = ConcurrencyUtils.getNumberOfThreads();
        if (n4 > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            Future[] futureArray = new Future[n4];
            int n5 = n3 / n4;
            for (int i = 0; i < n4; ++i) {
                final int n6 = i * n5;
                final int n7 = i == n4 - 1 ? n3 : n6 + n5;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n6; i < n7; ++i) {
                            for (int j = 0; j < n; ++j) {
                                float f3 = 0.0f;
                                for (int k = 0; k < n2; ++k) {
                                    f3 += FloatMatrix2D.this.getQuick(j, k) * floatMatrix2D.getQuick(k, i);
                                }
                                floatMatrix2D3.setQuick(j, i, f * f3 + f2 * floatMatrix2D3.getQuick(j, i));
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < n3; ++i) {
                for (int j = 0; j < n; ++j) {
                    float f3 = 0.0f;
                    for (int k = 0; k < n2; ++k) {
                        f3 += this.getQuick(j, k) * floatMatrix2D.getQuick(k, i);
                    }
                    floatMatrix2D3.setQuick(j, i, f * f3 + f2 * floatMatrix2D3.getQuick(j, i));
                }
            }
        }
        return floatMatrix2D3;
    }

    public float zSum() {
        if (this.size() == 0) {
            return 0.0f;
        }
        return this.aggregate(FloatFunctions.plus, FloatFunctions.identity);
    }
}

