/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfloat;

import cern.colt.PersistentObject;
import cern.colt.matrix.tfloat.FloatMatrix3D;
import cern.colt.matrix.tfloat.impl.DenseFloatMatrix3D;
import cern.colt.matrix.tfloat.impl.SparseFloatMatrix3D;
import cern.jet.math.tfloat.FloatFunctions;

public class FloatFactory3D
extends PersistentObject {
    public static final FloatFactory3D dense = new FloatFactory3D();
    public static final FloatFactory3D sparse = new FloatFactory3D();

    protected FloatFactory3D() {
    }

    public FloatMatrix3D ascending(int n, int n2, int n3) {
        FloatFunctions floatFunctions = FloatFunctions.functions;
        return this.descending(n, n2, n3).assign(FloatFunctions.chain(FloatFunctions.neg, FloatFunctions.minus(n * n2 * n3)));
    }

    public FloatMatrix3D descending(int n, int n2, int n3) {
        FloatMatrix3D floatMatrix3D = this.make(n, n2, n3);
        int n4 = 0;
        int n5 = n;
        while (--n5 >= 0) {
            int n6 = n2;
            while (--n6 >= 0) {
                int n7 = n3;
                while (--n7 >= 0) {
                    floatMatrix3D.setQuick(n5, n6, n7, n4++);
                }
            }
        }
        return floatMatrix3D;
    }

    public FloatMatrix3D make(float[][][] fArray) {
        if (this == sparse) {
            return new SparseFloatMatrix3D(fArray);
        }
        return new DenseFloatMatrix3D(fArray);
    }

    public FloatMatrix3D make(int n, int n2, int n3) {
        if (this == sparse) {
            return new SparseFloatMatrix3D(n, n2, n3);
        }
        return new DenseFloatMatrix3D(n, n2, n3);
    }

    public FloatMatrix3D make(int n, int n2, int n3, float f) {
        return this.make(n, n2, n3).assign(f);
    }

    public FloatMatrix3D random(int n, int n2, int n3) {
        return this.make(n, n2, n3).assign(FloatFunctions.random());
    }
}

