/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfcomplex.impl;

import cern.colt.function.tfcomplex.FComplexFComplexFComplexFunction;
import cern.colt.function.tfcomplex.IntIntFComplexFunction;
import cern.colt.matrix.tfcomplex.FComplexMatrix1D;
import cern.colt.matrix.tfcomplex.FComplexMatrix2D;
import cern.colt.matrix.tfcomplex.impl.SelectedSparseFComplexMatrix2D;
import cern.colt.matrix.tfcomplex.impl.SparseFComplexMatrix1D;
import cern.colt.matrix.tfloat.FloatMatrix2D;
import cern.colt.matrix.tfloat.impl.SparseFloatMatrix2D;
import cern.jet.math.tfcomplex.FComplex;
import cern.jet.math.tfcomplex.FComplexPlusMult;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SparseFComplexMatrix2D
extends FComplexMatrix2D {
    private static final long serialVersionUID = 4055279694434233679L;
    protected ConcurrentHashMap<Integer, float[]> elements;
    protected int dummy;

    public SparseFComplexMatrix2D(float[][] fArray) {
        this(fArray.length, fArray.length == 0 ? 0 : fArray[0].length);
        this.assign(fArray);
    }

    public SparseFComplexMatrix2D(int n, int n2) {
        this.setUp(n, n2);
        this.elements = new ConcurrentHashMap(n * (n2 / 1000));
    }

    protected SparseFComplexMatrix2D(int n, int n2, ConcurrentHashMap<Integer, float[]> concurrentHashMap, int n3, int n4, int n5, int n6) {
        this.setUp(n, n2, n3, n4, n5, n6);
        this.elements = concurrentHashMap;
        this.isNoView = false;
    }

    @Override
    public FComplexMatrix2D assign(float[] fArray) {
        if (this.isNoView && fArray[0] == 0.0f && fArray[1] == 0.0f) {
            this.elements.clear();
        } else {
            super.assign(fArray);
        }
        return this;
    }

    @Override
    public FComplexMatrix2D assign(FComplexMatrix2D fComplexMatrix2D) {
        if (!(fComplexMatrix2D instanceof SparseFComplexMatrix2D)) {
            return super.assign(fComplexMatrix2D);
        }
        SparseFComplexMatrix2D sparseFComplexMatrix2D = (SparseFComplexMatrix2D)fComplexMatrix2D;
        if (sparseFComplexMatrix2D == this) {
            return this;
        }
        this.checkShape(sparseFComplexMatrix2D);
        if (this.isNoView && sparseFComplexMatrix2D.isNoView) {
            this.elements.clear();
            this.elements.putAll(sparseFComplexMatrix2D.elements);
            return this;
        }
        return super.assign(fComplexMatrix2D);
    }

    @Override
    public FComplexMatrix2D assign(FComplexMatrix2D fComplexMatrix2D, FComplexFComplexFComplexFunction fComplexFComplexFComplexFunction) {
        if (!this.isNoView) {
            return super.assign(fComplexMatrix2D, fComplexFComplexFComplexFunction);
        }
        this.checkShape(fComplexMatrix2D);
        if (fComplexFComplexFComplexFunction instanceof FComplexPlusMult) {
            final float[] fArray = ((FComplexPlusMult)fComplexFComplexFComplexFunction).multiplicator;
            if (fArray[0] == 0.0f && fArray[1] == 1.0f) {
                return this;
            }
            fComplexMatrix2D.forEachNonZero(new IntIntFComplexFunction(){

                public float[] apply(int n, int n2, float[] fArray2) {
                    SparseFComplexMatrix2D.this.setQuick(n, n2, FComplex.plus(SparseFComplexMatrix2D.this.getQuick(n, n2), FComplex.mult(fArray, fArray2)));
                    return fArray2;
                }
            });
            return this;
        }
        return super.assign(fComplexMatrix2D, fComplexFComplexFComplexFunction);
    }

    @Override
    public int cardinality() {
        if (this.isNoView) {
            return this.elements.size();
        }
        return super.cardinality();
    }

    @Override
    public float[] getQuick(int n, int n2) {
        float[] fArray = this.elements.get(this.rowZero + n * this.rowStride + this.columnZero + n2 * this.columnStride);
        if (fArray != null) {
            return new float[]{fArray[0], fArray[1]};
        }
        return new float[2];
    }

    @Override
    public ConcurrentHashMap<Integer, float[]> elements() {
        return this.elements;
    }

    @Override
    protected boolean haveSharedCellsRaw(FComplexMatrix2D fComplexMatrix2D) {
        if (fComplexMatrix2D instanceof SelectedSparseFComplexMatrix2D) {
            SelectedSparseFComplexMatrix2D selectedSparseFComplexMatrix2D = (SelectedSparseFComplexMatrix2D)fComplexMatrix2D;
            return this.elements == selectedSparseFComplexMatrix2D.elements;
        }
        if (fComplexMatrix2D instanceof SparseFComplexMatrix2D) {
            SparseFComplexMatrix2D sparseFComplexMatrix2D = (SparseFComplexMatrix2D)fComplexMatrix2D;
            return this.elements == sparseFComplexMatrix2D.elements;
        }
        return false;
    }

    @Override
    public long index(int n, int n2) {
        return this.rowZero + n * this.rowStride + this.columnZero + n2 * this.columnStride;
    }

    @Override
    public FComplexMatrix2D like(int n, int n2) {
        return new SparseFComplexMatrix2D(n, n2);
    }

    @Override
    public FComplexMatrix1D like1D(int n) {
        return new SparseFComplexMatrix1D(n);
    }

    @Override
    protected FComplexMatrix1D like1D(int n, int n2, int n3) {
        return new SparseFComplexMatrix1D(n, this.elements, n2, n3);
    }

    @Override
    public void setQuick(int n, int n2, float[] fArray) {
        int n3 = this.rowZero + n * this.rowStride + this.columnZero + n2 * this.columnStride;
        if (fArray[0] == 0.0f && fArray[1] == 0.0f) {
            this.elements.remove(n3);
        } else {
            this.elements.put(n3, fArray);
        }
    }

    @Override
    public FComplexMatrix1D vectorize() {
        SparseFComplexMatrix1D sparseFComplexMatrix1D = new SparseFComplexMatrix1D(this.size());
        int n = 0;
        for (int i = 0; i < this.columns; ++i) {
            for (int j = 0; j < this.rows; ++j) {
                float[] fArray = this.getQuick(j, i);
                if (fArray[0] == 0.0f && fArray[1] == 0.0f) continue;
                sparseFComplexMatrix1D.setQuick(n++, fArray);
            }
        }
        return sparseFComplexMatrix1D;
    }

    @Override
    public void setQuick(int n, int n2, float f, float f2) {
        int n3 = this.rowZero + n * this.rowStride + this.columnZero + n2 * this.columnStride;
        if (f == 0.0f && f2 == 0.0f) {
            this.elements.remove(n3);
        } else {
            this.elements.put(n3, new float[]{f, f2});
        }
    }

    @Override
    protected FComplexMatrix2D viewSelectionLike(int[] nArray, int[] nArray2) {
        return new SelectedSparseFComplexMatrix2D(this.elements, nArray, nArray2, 0);
    }

    @Override
    public FloatMatrix2D getImaginaryPart() {
        SparseFloatMatrix2D sparseFloatMatrix2D = new SparseFloatMatrix2D(this.rows, this.columns);
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.columns; ++j) {
                float[] fArray = this.getQuick(i, j);
                ((FloatMatrix2D)sparseFloatMatrix2D).setQuick(i, j, fArray[1]);
            }
        }
        return sparseFloatMatrix2D;
    }

    @Override
    public FloatMatrix2D getRealPart() {
        SparseFloatMatrix2D sparseFloatMatrix2D = new SparseFloatMatrix2D(this.rows, this.columns);
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.columns; ++j) {
                float[] fArray = this.getQuick(i, j);
                ((FloatMatrix2D)sparseFloatMatrix2D).setQuick(i, j, fArray[0]);
            }
        }
        return sparseFloatMatrix2D;
    }
}

