/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfcomplex.impl;

import cern.colt.function.tfcomplex.FComplexFComplexFComplexFunction;
import cern.colt.function.tfcomplex.FComplexFComplexFunction;
import cern.colt.function.tfcomplex.FComplexProcedure;
import cern.colt.function.tfcomplex.FComplexRealFunction;
import cern.colt.list.tint.IntArrayList;
import cern.colt.matrix.tfcomplex.FComplexMatrix1D;
import cern.colt.matrix.tfcomplex.FComplexMatrix2D;
import cern.colt.matrix.tfcomplex.FComplexMatrix3D;
import cern.colt.matrix.tfcomplex.impl.DenseFComplexMatrix1D;
import cern.colt.matrix.tfcomplex.impl.DenseFComplexMatrix2D;
import cern.colt.matrix.tfcomplex.impl.SelectedDenseFComplexMatrix3D;
import cern.colt.matrix.tfloat.FloatMatrix3D;
import cern.colt.matrix.tfloat.impl.DenseFloatMatrix3D;
import cern.jet.math.tfcomplex.FComplexFunctions;
import edu.emory.mathcs.jtransforms.fft.FloatFFT_3D;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DenseFComplexMatrix3D
extends FComplexMatrix3D {
    private static final long serialVersionUID = 3008992680697668332L;
    private FloatFFT_3D fft3;
    protected float[] elements;

    public DenseFComplexMatrix3D(float[][][] fArray) {
        this(fArray.length, fArray.length == 0 ? 0 : fArray[0].length, fArray.length == 0 ? 0 : (fArray[0].length == 0 ? 0 : fArray[0][0].length / 2));
        this.assign(fArray);
    }

    public DenseFComplexMatrix3D(FloatMatrix3D floatMatrix3D) {
        this(floatMatrix3D.slices(), floatMatrix3D.rows(), floatMatrix3D.columns());
        this.assignReal(floatMatrix3D);
    }

    public DenseFComplexMatrix3D(int n, int n2, int n3) {
        this.setUp(n, n2, n3, 0, 0, 0, n2 * 2 * n3, 2 * n3, 2);
        this.elements = new float[n * n2 * 2 * n3];
    }

    public DenseFComplexMatrix3D(int n, int n2, int n3, float[] fArray, int n4, int n5, int n6, int n7, int n8, int n9) {
        this.setUp(n, n2, n3, n4, n5, n6, n7, n8, n9);
        this.elements = fArray;
        this.isNoView = false;
    }

    @Override
    public float[] aggregate(final FComplexFComplexFComplexFunction fComplexFComplexFComplexFunction, final FComplexFComplexFunction fComplexFComplexFunction) {
        float[] fArray = new float[2];
        if (this.size() == 0) {
            fArray[0] = Float.NaN;
            fArray[1] = Float.NaN;
            return fArray;
        }
        final int n = (int)this.index(0, 0, 0);
        float[] fArray2 = null;
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            Future[] futureArray = new Future[n2];
            float[][] fArray3 = new float[n2][2];
            int n3 = this.slices / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? this.slices : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Callable<float[]>(){

                    @Override
                    public float[] call() throws Exception {
                        int n3 = n + n4 * DenseFComplexMatrix3D.this.sliceStride;
                        float[] fArray = fComplexFComplexFunction.apply(new float[]{DenseFComplexMatrix3D.this.elements[n3], DenseFComplexMatrix3D.this.elements[n3 + 1]});
                        int n2 = 1;
                        for (int i = n4; i < n5; ++i) {
                            for (int j = 0; j < DenseFComplexMatrix3D.this.rows; ++j) {
                                for (int k = n2; k < DenseFComplexMatrix3D.this.columns; ++k) {
                                    n3 = n + i * DenseFComplexMatrix3D.this.sliceStride + j * DenseFComplexMatrix3D.this.rowStride + k * DenseFComplexMatrix3D.this.columnStride;
                                    fArray = fComplexFComplexFComplexFunction.apply(fArray, fComplexFComplexFunction.apply(new float[]{DenseFComplexMatrix3D.this.elements[n3], DenseFComplexMatrix3D.this.elements[n3 + 1]}));
                                }
                                n2 = 0;
                            }
                        }
                        return fArray;
                    }
                });
            }
            fArray2 = ConcurrencyUtils.waitForCompletion(futureArray, fComplexFComplexFComplexFunction);
        } else {
            fArray2 = fComplexFComplexFunction.apply(new float[]{this.elements[n], this.elements[n + 1]});
            int n6 = 1;
            for (int i = 0; i < this.slices; ++i) {
                for (int j = 0; j < this.rows; ++j) {
                    for (int k = n6; k < this.columns; ++k) {
                        int n7 = n + i * this.sliceStride + j * this.rowStride + k * this.columnStride;
                        fArray2 = fComplexFComplexFComplexFunction.apply(fArray2, fComplexFComplexFunction.apply(new float[]{this.elements[n7], this.elements[n7 + 1]}));
                    }
                    n6 = 0;
                }
            }
        }
        return fArray2;
    }

    @Override
    public float[] aggregate(FComplexMatrix3D fComplexMatrix3D, final FComplexFComplexFComplexFunction fComplexFComplexFComplexFunction, final FComplexFComplexFComplexFunction fComplexFComplexFComplexFunction2) {
        this.checkShape(fComplexMatrix3D);
        float[] fArray = new float[2];
        if (this.size() == 0) {
            fArray[0] = Float.NaN;
            fArray[1] = Float.NaN;
            return fArray;
        }
        final int n = (int)this.index(0, 0, 0);
        final int n2 = (int)fComplexMatrix3D.index(0, 0, 0);
        final int n3 = fComplexMatrix3D.sliceStride();
        final int n4 = fComplexMatrix3D.rowStride();
        final int n5 = fComplexMatrix3D.columnStride();
        final float[] fArray2 = (float[])fComplexMatrix3D.elements();
        float[] fArray3 = null;
        int n6 = ConcurrencyUtils.getNumberOfThreads();
        if (n6 > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            Future[] futureArray = new Future[n6];
            float[][] fArray4 = new float[n6][2];
            int n7 = this.slices / n6;
            for (int i = 0; i < n6; ++i) {
                final int n8 = i * n7;
                final int n9 = i == n6 - 1 ? this.slices : n8 + n7;
                futureArray[i] = ConcurrencyUtils.submit(new Callable<float[]>(){

                    @Override
                    public float[] call() throws Exception {
                        int n6 = n + n8 * DenseFComplexMatrix3D.this.sliceStride;
                        int n22 = n2 + n8 * n3;
                        float[] fArray = fComplexFComplexFComplexFunction2.apply(new float[]{DenseFComplexMatrix3D.this.elements[n6], DenseFComplexMatrix3D.this.elements[n6 + 1]}, new float[]{fArray2[n22], fArray2[n22 + 1]});
                        int n32 = 1;
                        for (int i = n8; i < n9; ++i) {
                            for (int j = 0; j < DenseFComplexMatrix3D.this.rows; ++j) {
                                for (int k = n32; k < DenseFComplexMatrix3D.this.columns; ++k) {
                                    n6 = n + i * DenseFComplexMatrix3D.this.sliceStride + j * DenseFComplexMatrix3D.this.rowStride + k * DenseFComplexMatrix3D.this.columnStride;
                                    n22 = n2 + i * n3 + j * n4 + k * n5;
                                    fArray = fComplexFComplexFComplexFunction.apply(fArray, fComplexFComplexFComplexFunction2.apply(new float[]{DenseFComplexMatrix3D.this.elements[n6], DenseFComplexMatrix3D.this.elements[n6 + 1]}, new float[]{fArray2[n22], fArray2[n22 + 1]}));
                                }
                                n32 = 0;
                            }
                        }
                        return fArray;
                    }
                });
            }
            fArray3 = ConcurrencyUtils.waitForCompletion(futureArray, fComplexFComplexFComplexFunction);
        } else {
            fArray3 = fComplexFComplexFComplexFunction2.apply(new float[]{this.elements[n], this.elements[n + 1]}, new float[]{fArray2[n2], fArray2[n2 + 1]});
            int n10 = 1;
            for (int i = 0; i < this.slices; ++i) {
                for (int j = 0; j < this.rows; ++j) {
                    for (int k = n10; k < this.columns; ++k) {
                        int n11 = n + i * this.sliceStride + j * this.rowStride + k * this.columnStride;
                        int n12 = n2 + i * n3 + j * n4 + k * n5;
                        fArray3 = fComplexFComplexFComplexFunction.apply(fArray3, fComplexFComplexFComplexFunction2.apply(new float[]{this.elements[n11], this.elements[n11 + 1]}, new float[]{fArray2[n12], fArray2[n12 + 1]}));
                    }
                    n10 = 0;
                }
            }
        }
        return fArray3;
    }

    @Override
    public FComplexMatrix3D assign(final FComplexFComplexFunction fComplexFComplexFunction) {
        final int n = (int)this.index(0, 0, 0);
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            Future[] futureArray = new Future[n2];
            int n3 = this.slices / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? this.slices : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        float[] fArray = new float[2];
                        for (int i = n4; i < n5; ++i) {
                            for (int j = 0; j < DenseFComplexMatrix3D.this.rows; ++j) {
                                int n2 = n + i * DenseFComplexMatrix3D.this.sliceStride + j * DenseFComplexMatrix3D.this.rowStride;
                                for (int k = 0; k < DenseFComplexMatrix3D.this.columns; ++k) {
                                    fArray[0] = DenseFComplexMatrix3D.this.elements[n2];
                                    fArray[1] = DenseFComplexMatrix3D.this.elements[n2 + 1];
                                    fArray = fComplexFComplexFunction.apply(fArray);
                                    DenseFComplexMatrix3D.this.elements[n2] = fArray[0];
                                    DenseFComplexMatrix3D.this.elements[n2 + 1] = fArray[1];
                                    n2 += DenseFComplexMatrix3D.this.columnStride;
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            float[] fArray = new float[2];
            for (int i = 0; i < this.slices; ++i) {
                for (int j = 0; j < this.rows; ++j) {
                    int n6 = n + i * this.sliceStride + j * this.rowStride;
                    for (int k = 0; k < this.columns; ++k) {
                        fArray[0] = this.elements[n6];
                        fArray[1] = this.elements[n6 + 1];
                        fArray = fComplexFComplexFunction.apply(fArray);
                        this.elements[n6] = fArray[0];
                        this.elements[n6 + 1] = fArray[1];
                        n6 += this.columnStride;
                    }
                }
            }
        }
        return this;
    }

    @Override
    public FComplexMatrix3D assign(final FComplexProcedure fComplexProcedure, final FComplexFComplexFunction fComplexFComplexFunction) {
        final int n = (int)this.index(0, 0, 0);
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            Future[] futureArray = new Future[n2];
            int n3 = this.slices / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? this.slices : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        float[] fArray = new float[2];
                        for (int i = n4; i < n5; ++i) {
                            for (int j = 0; j < DenseFComplexMatrix3D.this.rows; ++j) {
                                int n2 = n + i * DenseFComplexMatrix3D.this.sliceStride + j * DenseFComplexMatrix3D.this.rowStride;
                                for (int k = 0; k < DenseFComplexMatrix3D.this.columns; ++k) {
                                    fArray[0] = DenseFComplexMatrix3D.this.elements[n2];
                                    fArray[1] = DenseFComplexMatrix3D.this.elements[n2 + 1];
                                    if (fComplexProcedure.apply(fArray)) {
                                        fArray = fComplexFComplexFunction.apply(fArray);
                                        DenseFComplexMatrix3D.this.elements[n2] = fArray[0];
                                        DenseFComplexMatrix3D.this.elements[n2 + 1] = fArray[1];
                                    }
                                    n2 += DenseFComplexMatrix3D.this.columnStride;
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            float[] fArray = new float[2];
            for (int i = 0; i < this.slices; ++i) {
                for (int j = 0; j < this.rows; ++j) {
                    int n6 = n + i * this.sliceStride + j * this.rowStride;
                    for (int k = 0; k < this.columns; ++k) {
                        fArray[0] = this.elements[n6];
                        fArray[1] = this.elements[n6 + 1];
                        if (fComplexProcedure.apply(fArray)) {
                            fArray = fComplexFComplexFunction.apply(fArray);
                            this.elements[n6] = fArray[0];
                            this.elements[n6 + 1] = fArray[1];
                        }
                        n6 += this.columnStride;
                    }
                }
            }
        }
        return this;
    }

    @Override
    public FComplexMatrix3D assign(final FComplexProcedure fComplexProcedure, final float[] fArray) {
        final int n = (int)this.index(0, 0, 0);
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            Future[] futureArray = new Future[n2];
            int n3 = this.slices / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? this.slices : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        float[] fArray2 = new float[2];
                        for (int i = n4; i < n5; ++i) {
                            for (int j = 0; j < DenseFComplexMatrix3D.this.rows; ++j) {
                                int n2 = n + i * DenseFComplexMatrix3D.this.sliceStride + j * DenseFComplexMatrix3D.this.rowStride;
                                for (int k = 0; k < DenseFComplexMatrix3D.this.columns; ++k) {
                                    fArray2[0] = DenseFComplexMatrix3D.this.elements[n2];
                                    fArray2[1] = DenseFComplexMatrix3D.this.elements[n2 + 1];
                                    if (fComplexProcedure.apply(fArray2)) {
                                        DenseFComplexMatrix3D.this.elements[n2] = fArray[0];
                                        DenseFComplexMatrix3D.this.elements[n2 + 1] = fArray[1];
                                    }
                                    n2 += DenseFComplexMatrix3D.this.columnStride;
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            float[] fArray2 = new float[2];
            for (int i = 0; i < this.slices; ++i) {
                for (int j = 0; j < this.rows; ++j) {
                    int n6 = n + i * this.sliceStride + j * this.rowStride;
                    for (int k = 0; k < this.columns; ++k) {
                        fArray2[0] = this.elements[n6];
                        fArray2[1] = this.elements[n6 + 1];
                        if (fComplexProcedure.apply(fArray2)) {
                            this.elements[n6] = fArray[0];
                            this.elements[n6 + 1] = fArray[1];
                        }
                        n6 += this.columnStride;
                    }
                }
            }
        }
        return this;
    }

    @Override
    public FComplexMatrix3D assign(final FComplexRealFunction fComplexRealFunction) {
        final int n = (int)this.index(0, 0, 0);
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            Future[] futureArray = new Future[n2];
            int n3 = this.slices / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? this.slices : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        float[] fArray = new float[2];
                        for (int i = n4; i < n5; ++i) {
                            for (int j = 0; j < DenseFComplexMatrix3D.this.rows; ++j) {
                                int n2 = n + i * DenseFComplexMatrix3D.this.sliceStride + j * DenseFComplexMatrix3D.this.rowStride;
                                for (int k = 0; k < DenseFComplexMatrix3D.this.columns; ++k) {
                                    fArray[0] = DenseFComplexMatrix3D.this.elements[n2];
                                    fArray[1] = DenseFComplexMatrix3D.this.elements[n2 + 1];
                                    fArray[0] = fComplexRealFunction.apply(fArray);
                                    DenseFComplexMatrix3D.this.elements[n2] = fArray[0];
                                    DenseFComplexMatrix3D.this.elements[n2 + 1] = 0.0f;
                                    n2 += DenseFComplexMatrix3D.this.columnStride;
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            float[] fArray = new float[2];
            for (int i = 0; i < this.slices; ++i) {
                for (int j = 0; j < this.rows; ++j) {
                    int n6 = n + i * this.sliceStride + j * this.rowStride;
                    for (int k = 0; k < this.columns; ++k) {
                        fArray[0] = this.elements[n6];
                        fArray[1] = this.elements[n6 + 1];
                        fArray[0] = fComplexRealFunction.apply(fArray);
                        this.elements[n6] = fArray[0];
                        this.elements[n6 + 1] = 0.0f;
                        n6 += this.columnStride;
                    }
                }
            }
        }
        return this;
    }

    @Override
    public FComplexMatrix3D assign(FComplexMatrix3D fComplexMatrix3D) {
        if (!(fComplexMatrix3D instanceof DenseFComplexMatrix3D)) {
            super.assign(fComplexMatrix3D);
            return this;
        }
        DenseFComplexMatrix3D denseFComplexMatrix3D = (DenseFComplexMatrix3D)fComplexMatrix3D;
        if (denseFComplexMatrix3D == this) {
            return this;
        }
        this.checkShape(denseFComplexMatrix3D);
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (this.isNoView && denseFComplexMatrix3D.isNoView) {
            System.arraycopy(denseFComplexMatrix3D.elements, 0, this.elements, 0, this.elements.length);
            return this;
        }
        DenseFComplexMatrix3D denseFComplexMatrix3D2 = (DenseFComplexMatrix3D)fComplexMatrix3D;
        if (this.haveSharedCells(denseFComplexMatrix3D2)) {
            FComplexMatrix3D fComplexMatrix3D2 = denseFComplexMatrix3D2.copy();
            if (!(fComplexMatrix3D2 instanceof DenseFComplexMatrix3D)) {
                super.assign(fComplexMatrix3D);
                return this;
            }
            denseFComplexMatrix3D2 = (DenseFComplexMatrix3D)fComplexMatrix3D2;
        }
        final int n2 = (int)this.index(0, 0, 0);
        final int n3 = (int)denseFComplexMatrix3D2.index(0, 0, 0);
        final int n4 = denseFComplexMatrix3D2.sliceStride;
        final int n5 = denseFComplexMatrix3D2.rowStride;
        final int n6 = denseFComplexMatrix3D2.columnStride;
        final float[] fArray = denseFComplexMatrix3D2.elements;
        if (n > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            Future[] futureArray = new Future[n];
            int n7 = this.slices / n;
            for (int i = 0; i < n; ++i) {
                final int n8 = i * n7;
                final int n9 = i == n - 1 ? this.slices : n8 + n7;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n8; i < n9; ++i) {
                            for (int j = 0; j < DenseFComplexMatrix3D.this.rows; ++j) {
                                int n = n2 + i * DenseFComplexMatrix3D.this.sliceStride + j * DenseFComplexMatrix3D.this.rowStride;
                                int n22 = n3 + i * n4 + j * n5;
                                for (int k = 0; k < DenseFComplexMatrix3D.this.columns; ++k) {
                                    DenseFComplexMatrix3D.this.elements[n] = fArray[n22];
                                    DenseFComplexMatrix3D.this.elements[n + 1] = fArray[n22 + 1];
                                    n += DenseFComplexMatrix3D.this.columnStride;
                                    n22 += n6;
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.slices; ++i) {
                for (int j = 0; j < this.rows; ++j) {
                    int n10 = n2 + i * this.sliceStride + j * this.rowStride;
                    int n11 = n3 + i * n4 + j * n5;
                    for (int k = 0; k < this.columns; ++k) {
                        this.elements[n10] = fArray[n11];
                        this.elements[n10 + 1] = fArray[n11 + 1];
                        n10 += this.columnStride;
                        n11 += n6;
                    }
                }
            }
        }
        return this;
    }

    @Override
    public FComplexMatrix3D assign(FComplexMatrix3D fComplexMatrix3D, final FComplexFComplexFComplexFunction fComplexFComplexFComplexFunction) {
        this.checkShape(fComplexMatrix3D);
        final int n = (int)this.index(0, 0, 0);
        final int n2 = (int)fComplexMatrix3D.index(0, 0, 0);
        final int n3 = fComplexMatrix3D.columnStride();
        final int n4 = fComplexMatrix3D.sliceStride();
        final int n5 = fComplexMatrix3D.rowStride();
        final float[] fArray = (float[])fComplexMatrix3D.elements();
        int n6 = ConcurrencyUtils.getNumberOfThreads();
        if (n6 > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            Future[] futureArray = new Future[n6];
            int n7 = this.slices / n6;
            for (int i = 0; i < n6; ++i) {
                final int n8 = i * n7;
                final int n9 = i == n6 - 1 ? this.slices : n8 + n7;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        float[] fArray3 = new float[2];
                        float[] fArray2 = new float[2];
                        if (fComplexFComplexFComplexFunction == FComplexFunctions.mult) {
                            for (int i = n8; i < n9; ++i) {
                                for (int j = 0; j < DenseFComplexMatrix3D.this.rows; ++j) {
                                    int n6 = n + i * DenseFComplexMatrix3D.this.sliceStride + j * DenseFComplexMatrix3D.this.rowStride;
                                    int n22 = n2 + i * n4 + j * n5;
                                    for (int k = 0; k < DenseFComplexMatrix3D.this.columns; ++k) {
                                        fArray3[0] = DenseFComplexMatrix3D.this.elements[n6];
                                        fArray3[1] = DenseFComplexMatrix3D.this.elements[n6 + 1];
                                        fArray2[0] = fArray[n22];
                                        fArray2[1] = fArray[n22 + 1];
                                        DenseFComplexMatrix3D.this.elements[n6] = fArray3[0] * fArray2[0] - fArray3[1] * fArray2[1];
                                        DenseFComplexMatrix3D.this.elements[n6 + 1] = fArray3[1] * fArray2[0] + fArray3[0] * fArray2[1];
                                        n6 += DenseFComplexMatrix3D.this.columnStride;
                                        n22 += n3;
                                    }
                                }
                            }
                        } else if (fComplexFComplexFComplexFunction == FComplexFunctions.multConjFirst) {
                            for (int i = n8; i < n9; ++i) {
                                for (int j = 0; j < DenseFComplexMatrix3D.this.rows; ++j) {
                                    int n7 = n + i * DenseFComplexMatrix3D.this.sliceStride + j * DenseFComplexMatrix3D.this.rowStride;
                                    int n32 = n2 + i * n4 + j * n5;
                                    for (int k = 0; k < DenseFComplexMatrix3D.this.columns; ++k) {
                                        fArray3[0] = DenseFComplexMatrix3D.this.elements[n7];
                                        fArray3[1] = DenseFComplexMatrix3D.this.elements[n7 + 1];
                                        fArray2[0] = fArray[n32];
                                        fArray2[1] = fArray[n32 + 1];
                                        DenseFComplexMatrix3D.this.elements[n7] = fArray3[0] * fArray2[0] + fArray3[1] * fArray2[1];
                                        DenseFComplexMatrix3D.this.elements[n7 + 1] = -fArray3[1] * fArray2[0] + fArray3[0] * fArray2[1];
                                        n7 += DenseFComplexMatrix3D.this.columnStride;
                                        n32 += n3;
                                    }
                                }
                            }
                        } else if (fComplexFComplexFComplexFunction == FComplexFunctions.multConjSecond) {
                            for (int i = n8; i < n9; ++i) {
                                for (int j = 0; j < DenseFComplexMatrix3D.this.rows; ++j) {
                                    int n10 = n + i * DenseFComplexMatrix3D.this.sliceStride + j * DenseFComplexMatrix3D.this.rowStride;
                                    int n42 = n2 + i * n4 + j * n5;
                                    for (int k = 0; k < DenseFComplexMatrix3D.this.columns; ++k) {
                                        fArray3[0] = DenseFComplexMatrix3D.this.elements[n10];
                                        fArray3[1] = DenseFComplexMatrix3D.this.elements[n10 + 1];
                                        fArray2[0] = fArray[n42];
                                        fArray2[1] = fArray[n42 + 1];
                                        DenseFComplexMatrix3D.this.elements[n10] = fArray3[0] * fArray2[0] + fArray3[1] * fArray2[1];
                                        DenseFComplexMatrix3D.this.elements[n10 + 1] = fArray3[1] * fArray2[0] - fArray3[0] * fArray2[1];
                                        n10 += DenseFComplexMatrix3D.this.columnStride;
                                        n42 += n3;
                                    }
                                }
                            }
                        } else {
                            for (int i = n8; i < n9; ++i) {
                                for (int j = 0; j < DenseFComplexMatrix3D.this.rows; ++j) {
                                    int n11 = n + i * DenseFComplexMatrix3D.this.sliceStride + j * DenseFComplexMatrix3D.this.rowStride;
                                    int n52 = n2 + i * n4 + j * n5;
                                    for (int k = 0; k < DenseFComplexMatrix3D.this.columns; ++k) {
                                        fArray3[0] = DenseFComplexMatrix3D.this.elements[n11];
                                        fArray3[1] = DenseFComplexMatrix3D.this.elements[n11 + 1];
                                        fArray2[0] = fArray[n52];
                                        fArray2[1] = fArray[n52 + 1];
                                        fArray3 = fComplexFComplexFComplexFunction.apply(fArray3, fArray2);
                                        DenseFComplexMatrix3D.this.elements[n11] = fArray3[0];
                                        DenseFComplexMatrix3D.this.elements[n11 + 1] = fArray3[1];
                                        n11 += DenseFComplexMatrix3D.this.columnStride;
                                        n52 += n3;
                                    }
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            float[] fArray2 = new float[2];
            float[] fArray3 = new float[2];
            if (fComplexFComplexFComplexFunction == FComplexFunctions.mult) {
                for (int i = 0; i < this.slices; ++i) {
                    for (int j = 0; j < this.rows; ++j) {
                        int n10 = n + i * this.sliceStride + j * this.rowStride;
                        int n11 = n2 + i * n4 + j * n5;
                        for (int k = 0; k < this.columns; ++k) {
                            fArray2[0] = this.elements[n10];
                            fArray2[1] = this.elements[n10 + 1];
                            fArray3[0] = fArray[n11];
                            fArray3[1] = fArray[n11 + 1];
                            this.elements[n10] = fArray2[0] * fArray3[0] - fArray2[1] * fArray3[1];
                            this.elements[n10 + 1] = fArray2[1] * fArray3[0] + fArray2[0] * fArray3[1];
                            n10 += this.columnStride;
                            n11 += n3;
                        }
                    }
                }
            } else if (fComplexFComplexFComplexFunction == FComplexFunctions.multConjFirst) {
                for (int i = 0; i < this.slices; ++i) {
                    for (int j = 0; j < this.rows; ++j) {
                        int n12 = n + i * this.sliceStride + j * this.rowStride;
                        int n13 = n2 + i * n4 + j * n5;
                        for (int k = 0; k < this.columns; ++k) {
                            fArray2[0] = this.elements[n12];
                            fArray2[1] = this.elements[n12 + 1];
                            fArray3[0] = fArray[n13];
                            fArray3[1] = fArray[n13 + 1];
                            this.elements[n12] = fArray2[0] * fArray3[0] + fArray2[1] * fArray3[1];
                            this.elements[n12 + 1] = -fArray2[1] * fArray3[0] + fArray2[0] * fArray3[1];
                            n12 += this.columnStride;
                            n13 += n3;
                        }
                    }
                }
            } else if (fComplexFComplexFComplexFunction == FComplexFunctions.multConjSecond) {
                for (int i = 0; i < this.slices; ++i) {
                    for (int j = 0; j < this.rows; ++j) {
                        int n14 = n + i * this.sliceStride + j * this.rowStride;
                        int n15 = n2 + i * n4 + j * n5;
                        for (int k = 0; k < this.columns; ++k) {
                            fArray2[0] = this.elements[n14];
                            fArray2[1] = this.elements[n14 + 1];
                            fArray3[0] = fArray[n15];
                            fArray3[1] = fArray[n15 + 1];
                            this.elements[n14] = fArray2[0] * fArray3[0] + fArray2[1] * fArray3[1];
                            this.elements[n14 + 1] = fArray2[1] * fArray3[0] - fArray2[0] * fArray3[1];
                            n14 += this.columnStride;
                            n15 += n3;
                        }
                    }
                }
            } else {
                for (int i = 0; i < this.slices; ++i) {
                    for (int j = 0; j < this.rows; ++j) {
                        int n16 = n + i * this.sliceStride + j * this.rowStride;
                        int n17 = n2 + i * n4 + j * n5;
                        for (int k = 0; k < this.columns; ++k) {
                            fArray2[0] = this.elements[n16];
                            fArray2[1] = this.elements[n16 + 1];
                            fArray3[0] = fArray[n17];
                            fArray3[1] = fArray[n17 + 1];
                            fArray2 = fComplexFComplexFComplexFunction.apply(fArray2, fArray3);
                            this.elements[n16] = fArray2[0];
                            this.elements[n16 + 1] = fArray2[1];
                            n16 += this.columnStride;
                            n17 += n3;
                        }
                    }
                }
            }
        }
        return this;
    }

    @Override
    public FComplexMatrix3D assign(final float f, final float f2) {
        if (!this.isNoView) {
            return super.assign(f, f2);
        }
        final int n = (int)this.index(0, 0, 0);
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.slices * this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            Future[] futureArray = new Future[n2];
            int n3 = this.slices / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? this.slices : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n4; i < n5; ++i) {
                            for (int j = 0; j < DenseFComplexMatrix3D.this.rows; ++j) {
                                int n2 = n + i * DenseFComplexMatrix3D.this.sliceStride + j * DenseFComplexMatrix3D.this.rowStride;
                                for (int k = 0; k < DenseFComplexMatrix3D.this.columns; ++k) {
                                    DenseFComplexMatrix3D.this.elements[n2] = f;
                                    DenseFComplexMatrix3D.this.elements[n2 + 1] = f2;
                                    n2 += DenseFComplexMatrix3D.this.columnStride;
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.slices; ++i) {
                for (int j = 0; j < this.rows; ++j) {
                    int n6 = n + i * this.sliceStride + j * this.rowStride;
                    for (int k = 0; k < this.columns; ++k) {
                        this.elements[n6] = f;
                        this.elements[n6 + 1] = f2;
                        n6 += this.columnStride;
                    }
                }
            }
        }
        return this;
    }

    @Override
    public FComplexMatrix3D assign(final float[] fArray) {
        if (fArray.length != this.slices * this.rows * 2 * this.columns) {
            throw new IllegalArgumentException("Must have same length: length=" + fArray.length + "slices()*rows()*2*columns()=" + this.slices() * this.rows() * 2 * this.columns());
        }
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (this.isNoView) {
            System.arraycopy(fArray, 0, this.elements, 0, fArray.length);
        } else {
            final int n2 = (int)this.index(0, 0, 0);
            if (n > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_3D()) {
                Future[] futureArray = new Future[n];
                int n3 = this.slices / n;
                for (int i = 0; i < n; ++i) {
                    final int n4 = i * n3;
                    final int n5 = i * n3 * 2 * this.rows * this.columns;
                    final int n6 = i == n - 1 ? this.slices : n4 + n3;
                    futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                        public void run() {
                            int n = n5;
                            for (int i = n4; i < n6; ++i) {
                                for (int j = 0; j < DenseFComplexMatrix3D.this.rows; ++j) {
                                    int n22 = n2 + i * DenseFComplexMatrix3D.this.sliceStride + j * DenseFComplexMatrix3D.this.rowStride;
                                    for (int k = 0; k < DenseFComplexMatrix3D.this.columns; ++k) {
                                        DenseFComplexMatrix3D.this.elements[n22] = fArray[n++];
                                        DenseFComplexMatrix3D.this.elements[n22 + 1] = fArray[n++];
                                        n22 += DenseFComplexMatrix3D.this.columnStride;
                                    }
                                }
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futureArray);
            } else {
                int n7 = 0;
                for (int i = 0; i < this.slices; ++i) {
                    for (int j = 0; j < this.rows; ++j) {
                        int n8 = n2 + i * this.sliceStride + j * this.rowStride;
                        for (int k = 0; k < this.columns; ++k) {
                            this.elements[n8] = fArray[n7++];
                            this.elements[n8 + 1] = fArray[n7++];
                            n8 += this.columnStride;
                        }
                    }
                }
            }
        }
        return this;
    }

    @Override
    public FComplexMatrix3D assign(final float[][][] fArray) {
        if (fArray.length != this.slices) {
            throw new IllegalArgumentException("Must have same number of slices: slices=" + fArray.length + "slices()=" + this.slices());
        }
        final int n = 2 * this.columns;
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (this.isNoView) {
            if (n2 > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_3D()) {
                Future[] futureArray = new Future[n2];
                int n3 = this.slices / n2;
                for (int i = 0; i < n2; ++i) {
                    final int n4 = i * n3;
                    final int n5 = i == n2 - 1 ? this.slices : n4 + n3;
                    futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                        public void run() {
                            int n2 = n4 * DenseFComplexMatrix3D.this.sliceStride;
                            for (int i = n4; i < n5; ++i) {
                                float[][] fArray3 = fArray[i];
                                if (fArray3.length != DenseFComplexMatrix3D.this.rows) {
                                    throw new IllegalArgumentException("Must have same number of rows in every slice: rows=" + fArray3.length + "rows()=" + DenseFComplexMatrix3D.this.rows());
                                }
                                for (int j = 0; j < DenseFComplexMatrix3D.this.rows; ++j) {
                                    float[] fArray2 = fArray3[j];
                                    if (fArray2.length != n) {
                                        throw new IllegalArgumentException("Must have same number of columns in every row: columns=" + fArray2.length + "2 * columns()=" + n);
                                    }
                                    System.arraycopy(fArray2, 0, DenseFComplexMatrix3D.this.elements, n2, n);
                                    n2 += n;
                                }
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futureArray);
            } else {
                int n6 = 0;
                for (int i = 0; i < this.slices; ++i) {
                    float[][] fArray2 = fArray[i];
                    if (fArray2.length != this.rows) {
                        throw new IllegalArgumentException("Must have same number of rows in every slice: rows=" + fArray2.length + "rows()=" + this.rows());
                    }
                    for (int j = 0; j < this.rows; ++j) {
                        float[] fArray3 = fArray2[j];
                        if (fArray3.length != n) {
                            throw new IllegalArgumentException("Must have same number of columns in every row: columns=" + fArray3.length + "2 * columns()=" + n);
                        }
                        System.arraycopy(fArray3, 0, this.elements, n6, n);
                        n6 += n;
                    }
                }
            }
        } else {
            final int n7 = (int)this.index(0, 0, 0);
            if (n2 > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_3D()) {
                Future[] futureArray = new Future[n2];
                int n8 = this.slices / n2;
                for (int i = 0; i < n2; ++i) {
                    final int n9 = i * n8;
                    final int n10 = i == n2 - 1 ? this.slices : n9 + n8;
                    futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                        public void run() {
                            for (int i = n9; i < n10; ++i) {
                                float[][] fArray3 = fArray[i];
                                if (fArray3.length != DenseFComplexMatrix3D.this.rows) {
                                    throw new IllegalArgumentException("Must have same number of rows in every slice: rows=" + fArray3.length + "rows()=" + DenseFComplexMatrix3D.this.rows());
                                }
                                for (int j = 0; j < DenseFComplexMatrix3D.this.rows; ++j) {
                                    int n2 = n7 + i * DenseFComplexMatrix3D.this.sliceStride + j * DenseFComplexMatrix3D.this.rowStride;
                                    float[] fArray2 = fArray3[j];
                                    if (fArray2.length != n) {
                                        throw new IllegalArgumentException("Must have same number of columns in every row: columns=" + fArray2.length + "2*columns()=" + n);
                                    }
                                    for (int k = 0; k < DenseFComplexMatrix3D.this.columns; ++k) {
                                        DenseFComplexMatrix3D.this.elements[n2] = fArray2[2 * k];
                                        DenseFComplexMatrix3D.this.elements[n2 + 1] = fArray2[2 * k + 1];
                                        n2 += DenseFComplexMatrix3D.this.columnStride;
                                    }
                                }
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futureArray);
            } else {
                for (int i = 0; i < this.slices; ++i) {
                    float[][] fArray4 = fArray[i];
                    if (fArray4.length != this.rows) {
                        throw new IllegalArgumentException("Must have same number of rows in every slice: rows=" + fArray4.length + "rows()=" + this.rows());
                    }
                    for (int j = 0; j < this.rows; ++j) {
                        int n11 = n7 + i * this.sliceStride + j * this.rowStride;
                        float[] fArray5 = fArray4[j];
                        if (fArray5.length != n) {
                            throw new IllegalArgumentException("Must have same number of columns in every row: columns=" + fArray5.length + "2*columns()=" + n);
                        }
                        for (int k = 0; k < this.columns; ++k) {
                            this.elements[n11] = fArray5[2 * k];
                            this.elements[n11 + 1] = fArray5[2 * k + 1];
                            n11 += this.columnStride;
                        }
                    }
                }
            }
        }
        return this;
    }

    @Override
    public FComplexMatrix3D assignImaginary(FloatMatrix3D floatMatrix3D) {
        this.checkShape(floatMatrix3D);
        final int n = (int)this.index(0, 0, 0);
        final int n2 = (int)floatMatrix3D.index(0, 0, 0);
        final int n3 = floatMatrix3D.sliceStride();
        final int n4 = floatMatrix3D.rowStride();
        final int n5 = floatMatrix3D.columnStride();
        final float[] fArray = (float[])floatMatrix3D.elements();
        int n6 = ConcurrencyUtils.getNumberOfThreads();
        if (n6 > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            Future[] futureArray = new Future[n6];
            int n7 = this.slices / n6;
            for (int i = 0; i < n6; ++i) {
                final int n8 = i * n7;
                final int n9 = i == n6 - 1 ? this.slices : n8 + n7;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n8; i < n9; ++i) {
                            for (int j = 0; j < DenseFComplexMatrix3D.this.rows; ++j) {
                                int n6 = n + i * DenseFComplexMatrix3D.this.sliceStride + j * DenseFComplexMatrix3D.this.rowStride;
                                int n22 = n2 + i * n3 + j * n4;
                                for (int k = 0; k < DenseFComplexMatrix3D.this.columns; ++k) {
                                    DenseFComplexMatrix3D.this.elements[n6 + 1] = fArray[n22];
                                    n6 += DenseFComplexMatrix3D.this.columnStride;
                                    n22 += n5;
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.slices; ++i) {
                for (int j = 0; j < this.rows; ++j) {
                    int n10 = n + i * this.sliceStride + j * this.rowStride;
                    int n11 = n2 + i * n3 + j * n4;
                    for (int k = 0; k < this.columns; ++k) {
                        this.elements[n10 + 1] = fArray[n11];
                        n10 += this.columnStride;
                        n11 += n5;
                    }
                }
            }
        }
        return this;
    }

    @Override
    public FComplexMatrix3D assignReal(FloatMatrix3D floatMatrix3D) {
        this.checkShape(floatMatrix3D);
        final int n = (int)this.index(0, 0, 0);
        final int n2 = (int)floatMatrix3D.index(0, 0, 0);
        final int n3 = floatMatrix3D.sliceStride();
        final int n4 = floatMatrix3D.rowStride();
        final int n5 = floatMatrix3D.columnStride();
        final float[] fArray = (float[])floatMatrix3D.elements();
        int n6 = ConcurrencyUtils.getNumberOfThreads();
        if (n6 > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            Future[] futureArray = new Future[n6];
            int n7 = this.slices / n6;
            for (int i = 0; i < n6; ++i) {
                final int n8 = i * n7;
                final int n9 = i == n6 - 1 ? this.slices : n8 + n7;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n8; i < n9; ++i) {
                            for (int j = 0; j < DenseFComplexMatrix3D.this.rows; ++j) {
                                int n6 = n + i * DenseFComplexMatrix3D.this.sliceStride + j * DenseFComplexMatrix3D.this.rowStride;
                                int n22 = n2 + i * n3 + j * n4;
                                for (int k = 0; k < DenseFComplexMatrix3D.this.columns; ++k) {
                                    DenseFComplexMatrix3D.this.elements[n6] = fArray[n22];
                                    n6 += DenseFComplexMatrix3D.this.columnStride;
                                    n22 += n5;
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.slices; ++i) {
                for (int j = 0; j < this.rows; ++j) {
                    int n10 = n + i * this.sliceStride + j * this.rowStride;
                    int n11 = n2 + i * n3 + j * n4;
                    for (int k = 0; k < this.columns; ++k) {
                        this.elements[n10] = fArray[n11];
                        n10 += this.columnStride;
                        n11 += n5;
                    }
                }
            }
        }
        return this;
    }

    @Override
    public int cardinality() {
        int n = 0;
        final int n2 = (int)this.index(0, 0, 0);
        int n3 = ConcurrencyUtils.getNumberOfThreads();
        if (n3 > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            int n4;
            Future[] futureArray = new Future[n3];
            Integer[] integerArray = new Integer[n3];
            int n5 = this.slices / n3;
            for (n4 = 0; n4 < n3; ++n4) {
                final int n6 = n4 * n5;
                final int n7 = n4 == n3 - 1 ? this.slices : n6 + n5;
                futureArray[n4] = ConcurrencyUtils.submit(new Callable<Integer>(){

                    @Override
                    public Integer call() throws Exception {
                        int n = 0;
                        for (int i = n6; i < n7; ++i) {
                            for (int j = 0; j < DenseFComplexMatrix3D.this.rows; ++j) {
                                int n22 = n2 + i * DenseFComplexMatrix3D.this.sliceStride + j * DenseFComplexMatrix3D.this.rowStride;
                                for (int k = 0; k < DenseFComplexMatrix3D.this.columns; ++k) {
                                    if ((double)DenseFComplexMatrix3D.this.elements[n22] != 0.0 || (double)DenseFComplexMatrix3D.this.elements[n22 + 1] != 0.0) {
                                        ++n;
                                    }
                                    n22 += DenseFComplexMatrix3D.this.columnStride;
                                }
                            }
                        }
                        return n;
                    }
                });
            }
            try {
                for (n4 = 0; n4 < n3; ++n4) {
                    integerArray[n4] = (Integer)futureArray[n4].get();
                }
                n = integerArray[0];
                for (n4 = 1; n4 < n3; ++n4) {
                    n += integerArray[n4].intValue();
                }
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        } else {
            for (int i = 0; i < this.slices; ++i) {
                for (int j = 0; j < this.rows; ++j) {
                    int n8 = n2 + i * this.sliceStride + j * this.rowStride;
                    for (int k = 0; k < this.columns; ++k) {
                        if ((double)this.elements[n8] != 0.0 || (double)this.elements[n8 + 1] != 0.0) {
                            ++n;
                        }
                        n8 += this.columnStride;
                    }
                }
            }
        }
        return n;
    }

    public void fft2Slices() {
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        for (int i = 0; i < this.slices; ++i) {
            ((DenseFComplexMatrix2D)this.viewSlice(i)).fft2();
        }
        ConcurrencyUtils.setNumberOfThreads(n);
    }

    public void fft3() {
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        if (this.fft3 == null) {
            this.fft3 = new FloatFFT_3D(this.slices, this.rows, this.columns);
        }
        if (this.isNoView) {
            this.fft3.complexForward(this.elements);
        } else {
            FComplexMatrix3D fComplexMatrix3D = this.copy();
            this.fft3.complexForward((float[])fComplexMatrix3D.elements());
            this.assign((float[])fComplexMatrix3D.elements());
        }
        ConcurrencyUtils.setNumberOfThreads(n);
    }

    public float[] elements() {
        return this.elements;
    }

    @Override
    public FloatMatrix3D getImaginaryPart() {
        DenseFloatMatrix3D denseFloatMatrix3D = new DenseFloatMatrix3D(this.slices, this.rows, this.columns);
        final float[] fArray = denseFloatMatrix3D.elements();
        final int n = denseFloatMatrix3D.sliceStride();
        final int n2 = denseFloatMatrix3D.rowStride();
        final int n3 = denseFloatMatrix3D.columnStride();
        final int n4 = (int)denseFloatMatrix3D.index(0, 0, 0);
        final int n5 = (int)this.index(0, 0, 0);
        int n6 = ConcurrencyUtils.getNumberOfThreads();
        if (n6 > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            Future[] futureArray = new Future[n6];
            int n7 = this.slices / n6;
            for (int i = 0; i < n6; ++i) {
                final int n8 = i * n7;
                final int n9 = i == n6 - 1 ? this.slices : n8 + n7;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n8; i < n9; ++i) {
                            for (int j = 0; j < DenseFComplexMatrix3D.this.rows; ++j) {
                                int n6 = n5 + i * DenseFComplexMatrix3D.this.sliceStride + j * DenseFComplexMatrix3D.this.rowStride;
                                int n22 = n4 + i * n + j * n2;
                                for (int k = 0; k < DenseFComplexMatrix3D.this.columns; ++k) {
                                    fArray[n22] = DenseFComplexMatrix3D.this.elements[n6 + 1];
                                    n6 += DenseFComplexMatrix3D.this.columnStride;
                                    n22 += n3;
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.slices; ++i) {
                for (int j = 0; j < this.rows; ++j) {
                    int n10 = n5 + i * this.sliceStride + j * this.rowStride;
                    int n11 = n4 + i * n + j * n2;
                    for (int k = 0; k < this.columns; ++k) {
                        fArray[n11] = this.elements[n10 + 1];
                        n10 += this.columnStride;
                        n11 += n3;
                    }
                }
            }
        }
        return denseFloatMatrix3D;
    }

    @Override
    public void getNonZeros(IntArrayList intArrayList, IntArrayList intArrayList2, IntArrayList intArrayList3, ArrayList<float[]> arrayList) {
        intArrayList.clear();
        intArrayList2.clear();
        intArrayList3.clear();
        arrayList.clear();
        int n = (int)this.index(0, 0, 0);
        for (int i = 0; i < this.slices; ++i) {
            for (int j = 0; j < this.rows; ++j) {
                int n2 = n + i * this.sliceStride + j * this.rowStride;
                for (int k = 0; k < this.columns; ++k) {
                    float[] fArray = new float[]{this.elements[n2], this.elements[n2 + 1]};
                    if (fArray[0] != 0.0f || fArray[1] != 0.0f) {
                        intArrayList.add(i);
                        intArrayList2.add(j);
                        intArrayList3.add(k);
                        arrayList.add(fArray);
                    }
                    n2 += this.columnStride;
                }
            }
        }
    }

    @Override
    public float[] getQuick(int n, int n2, int n3) {
        int n4 = this.sliceZero + n * this.sliceStride + this.rowZero + n2 * this.rowStride + this.columnZero + n3 * this.columnStride;
        return new float[]{this.elements[n4], this.elements[n4 + 1]};
    }

    @Override
    public FloatMatrix3D getRealPart() {
        DenseFloatMatrix3D denseFloatMatrix3D = new DenseFloatMatrix3D(this.slices, this.rows, this.columns);
        final float[] fArray = denseFloatMatrix3D.elements();
        final int n = denseFloatMatrix3D.sliceStride();
        final int n2 = denseFloatMatrix3D.rowStride();
        final int n3 = denseFloatMatrix3D.columnStride();
        final int n4 = (int)denseFloatMatrix3D.index(0, 0, 0);
        final int n5 = (int)this.index(0, 0, 0);
        int n6 = ConcurrencyUtils.getNumberOfThreads();
        if (n6 > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            Future[] futureArray = new Future[n6];
            int n7 = this.slices / n6;
            for (int i = 0; i < n6; ++i) {
                final int n8 = i * n7;
                final int n9 = i == n6 - 1 ? this.slices : n8 + n7;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n8; i < n9; ++i) {
                            for (int j = 0; j < DenseFComplexMatrix3D.this.rows; ++j) {
                                int n6 = n5 + i * DenseFComplexMatrix3D.this.sliceStride + j * DenseFComplexMatrix3D.this.rowStride;
                                int n22 = n4 + i * n + j * n2;
                                for (int k = 0; k < DenseFComplexMatrix3D.this.columns; ++k) {
                                    fArray[n22] = DenseFComplexMatrix3D.this.elements[n6];
                                    n6 += DenseFComplexMatrix3D.this.columnStride;
                                    n22 += n3;
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.slices; ++i) {
                for (int j = 0; j < this.rows; ++j) {
                    int n10 = n5 + i * this.sliceStride + j * this.rowStride;
                    int n11 = n4 + i * n + j * n2;
                    for (int k = 0; k < this.columns; ++k) {
                        fArray[n11] = this.elements[n10];
                        n10 += this.columnStride;
                        n11 += n3;
                    }
                }
            }
        }
        return denseFloatMatrix3D;
    }

    public void ifft2Slices(boolean bl) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        for (int i = 0; i < this.slices; ++i) {
            ((DenseFComplexMatrix2D)this.viewSlice(i)).ifft2(bl);
        }
        ConcurrencyUtils.setNumberOfThreads(n);
    }

    public void ifft3(boolean bl) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        if (this.fft3 == null) {
            this.fft3 = new FloatFFT_3D(this.slices, this.rows, this.columns);
        }
        if (this.isNoView) {
            this.fft3.complexInverse(this.elements, bl);
        } else {
            FComplexMatrix3D fComplexMatrix3D = this.copy();
            this.fft3.complexInverse((float[])fComplexMatrix3D.elements(), bl);
            this.assign((float[])fComplexMatrix3D.elements());
        }
        ConcurrencyUtils.setNumberOfThreads(n);
    }

    @Override
    public FComplexMatrix3D like(int n, int n2, int n3) {
        return new DenseFComplexMatrix3D(n, n2, n3);
    }

    @Override
    public void setQuick(int n, int n2, int n3, float f, float f2) {
        int n4 = this.sliceZero + n * this.sliceStride + this.rowZero + n2 * this.rowStride + this.columnZero + n3 * this.columnStride;
        this.elements[n4] = f;
        this.elements[n4 + 1] = f2;
    }

    @Override
    public void setQuick(int n, int n2, int n3, float[] fArray) {
        int n4 = this.sliceZero + n * this.sliceStride + this.rowZero + n2 * this.rowStride + this.columnZero + n3 * this.columnStride;
        this.elements[n4] = fArray[0];
        this.elements[n4 + 1] = fArray[1];
    }

    @Override
    public float[][][] toArray() {
        final int n = (int)this.index(0, 0, 0);
        final float[][][] fArray = new float[this.slices][this.rows][2 * this.columns];
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            Future[] futureArray = new Future[n2];
            int n3 = this.slices / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? this.slices : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n4; i < n5; ++i) {
                            float[][] fArray3 = fArray[i];
                            for (int j = 0; j < DenseFComplexMatrix3D.this.rows; ++j) {
                                float[] fArray2 = fArray3[j];
                                int n2 = n + i * DenseFComplexMatrix3D.this.sliceStride + j * DenseFComplexMatrix3D.this.rowStride;
                                for (int k = 0; k < DenseFComplexMatrix3D.this.columns; ++k) {
                                    fArray2[2 * k] = DenseFComplexMatrix3D.this.elements[n2];
                                    fArray2[2 * k + 1] = DenseFComplexMatrix3D.this.elements[n2 + 1];
                                    n2 += DenseFComplexMatrix3D.this.columnStride;
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.slices; ++i) {
                float[][] fArray2 = fArray[i];
                for (int j = 0; j < this.rows; ++j) {
                    float[] fArray3 = fArray2[j];
                    int n6 = n + i * this.sliceStride + j * this.rowStride;
                    for (int k = 0; k < this.columns; ++k) {
                        fArray3[2 * k] = this.elements[n6];
                        fArray3[2 * k + 1] = this.elements[n6 + 1];
                        n6 += this.columnStride;
                    }
                }
            }
        }
        return fArray;
    }

    @Override
    public FComplexMatrix1D vectorize() {
        DenseFComplexMatrix1D denseFComplexMatrix1D = new DenseFComplexMatrix1D(this.size());
        int n = this.rows * this.columns;
        for (int i = 0; i < this.slices; ++i) {
            FComplexMatrix2D fComplexMatrix2D = this.viewSlice(i);
            denseFComplexMatrix1D.viewPart(i * n, n).assign(fComplexMatrix2D.vectorize());
        }
        return denseFComplexMatrix1D;
    }

    @Override
    public float[] zSum() {
        float[] fArray = new float[2];
        final int n = (int)this.index(0, 0, 0);
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            int n3;
            Future[] futureArray = new Future[n2];
            int n4 = this.slices / n2;
            for (int i = 0; i < n2; ++i) {
                n3 = i * n4;
                final int n5 = i == n2 - 1 ? this.slices : n3 + n4;
                futureArray[i] = ConcurrencyUtils.submit(new Callable<float[]>(){

                    @Override
                    public float[] call() throws Exception {
                        float[] fArray = new float[2];
                        for (int i = n3; i < n5; ++i) {
                            for (int j = 0; j < DenseFComplexMatrix3D.this.rows; ++j) {
                                int n2 = n + i * DenseFComplexMatrix3D.this.sliceStride + j * DenseFComplexMatrix3D.this.rowStride;
                                for (int k = 0; k < DenseFComplexMatrix3D.this.columns; ++k) {
                                    fArray[0] = fArray[0] + DenseFComplexMatrix3D.this.elements[n2];
                                    fArray[1] = fArray[1] + DenseFComplexMatrix3D.this.elements[n2 + 1];
                                    n2 += DenseFComplexMatrix3D.this.columnStride;
                                }
                            }
                        }
                        return fArray;
                    }
                });
            }
            try {
                for (n3 = 0; n3 < n2; ++n3) {
                    float[] fArray2 = (float[])futureArray[n3].get();
                    fArray[0] = fArray[0] + fArray2[0];
                    fArray[1] = fArray[1] + fArray2[1];
                }
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        } else {
            for (int i = 0; i < this.slices; ++i) {
                for (int j = 0; j < this.rows; ++j) {
                    int n6 = n + i * this.sliceStride + j * this.rowStride;
                    for (int k = 0; k < this.columns; ++k) {
                        fArray[0] = fArray[0] + this.elements[n6];
                        fArray[1] = fArray[1] + this.elements[n6 + 1];
                        n6 += this.columnStride;
                    }
                }
            }
        }
        return fArray;
    }

    @Override
    protected boolean haveSharedCellsRaw(FComplexMatrix3D fComplexMatrix3D) {
        if (fComplexMatrix3D instanceof SelectedDenseFComplexMatrix3D) {
            SelectedDenseFComplexMatrix3D selectedDenseFComplexMatrix3D = (SelectedDenseFComplexMatrix3D)fComplexMatrix3D;
            return this.elements == selectedDenseFComplexMatrix3D.elements;
        }
        if (fComplexMatrix3D instanceof DenseFComplexMatrix3D) {
            DenseFComplexMatrix3D denseFComplexMatrix3D = (DenseFComplexMatrix3D)fComplexMatrix3D;
            return this.elements == denseFComplexMatrix3D.elements;
        }
        return false;
    }

    @Override
    public long index(int n, int n2, int n3) {
        return this.sliceZero + n * this.sliceStride + this.rowZero + n2 * this.rowStride + this.columnZero + n3 * this.columnStride;
    }

    @Override
    protected FComplexMatrix2D like2D(int n, int n2, int n3, int n4, int n5, int n6) {
        return new DenseFComplexMatrix2D(n, n2, this.elements, n3, n4, n5, n6);
    }

    @Override
    protected FComplexMatrix3D viewSelectionLike(int[] nArray, int[] nArray2, int[] nArray3) {
        return new SelectedDenseFComplexMatrix3D(this.elements, nArray, nArray2, nArray3, 0);
    }
}

