/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfcomplex;

import cern.colt.function.tfcomplex.FComplexFComplexFComplexFunction;
import cern.colt.function.tfcomplex.FComplexFComplexFunction;
import cern.colt.function.tfcomplex.FComplexProcedure;
import cern.colt.function.tfcomplex.FComplexRealFunction;
import cern.colt.list.tint.IntArrayList;
import cern.colt.matrix.AbstractMatrix3D;
import cern.colt.matrix.tfcomplex.FComplexMatrix1D;
import cern.colt.matrix.tfcomplex.FComplexMatrix2D;
import cern.colt.matrix.tfcomplex.FComplexMatrix2DProcedure;
import cern.colt.matrix.tfloat.FloatMatrix3D;
import cern.colt.matrix.tfloat.algo.FloatProperty;
import cern.jet.math.tfcomplex.FComplexFunctions;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FComplexMatrix3D
extends AbstractMatrix3D {
    protected FComplexMatrix3D() {
    }

    public float[] aggregate(final FComplexFComplexFComplexFunction fComplexFComplexFComplexFunction, final FComplexFComplexFunction fComplexFComplexFunction) {
        float[] fArray = new float[2];
        if (this.size() == 0) {
            fArray[0] = Float.NaN;
            fArray[1] = Float.NaN;
            return fArray;
        }
        float[] fArray2 = null;
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            Future[] futureArray = new Future[n];
            float[][] fArray3 = new float[n][2];
            int n2 = this.slices / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.slices : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Callable<float[]>(){

                    @Override
                    public float[] call() throws Exception {
                        float[] fArray = fComplexFComplexFunction.apply(FComplexMatrix3D.this.getQuick(n3, 0, 0));
                        int n = 1;
                        for (int i = n3; i < n4; ++i) {
                            for (int j = 0; j < FComplexMatrix3D.this.rows; ++j) {
                                for (int k = n; k < FComplexMatrix3D.this.columns; ++k) {
                                    fArray = fComplexFComplexFComplexFunction.apply(fArray, fComplexFComplexFunction.apply(FComplexMatrix3D.this.getQuick(i, j, k)));
                                }
                                n = 0;
                            }
                        }
                        return fArray;
                    }
                });
            }
            fArray2 = ConcurrencyUtils.waitForCompletion(futureArray, fComplexFComplexFComplexFunction);
        } else {
            fArray2 = fComplexFComplexFunction.apply(this.getQuick(0, 0, 0));
            int n5 = 1;
            for (int i = 0; i < this.slices; ++i) {
                for (int j = 0; j < this.rows; ++j) {
                    for (int k = n5; k < this.columns; ++k) {
                        fArray2 = fComplexFComplexFComplexFunction.apply(fArray2, fComplexFComplexFunction.apply(this.getQuick(i, j, k)));
                    }
                    n5 = 0;
                }
            }
        }
        return fArray2;
    }

    public float[] aggregate(final FComplexMatrix3D fComplexMatrix3D, final FComplexFComplexFComplexFunction fComplexFComplexFComplexFunction, final FComplexFComplexFComplexFunction fComplexFComplexFComplexFunction2) {
        this.checkShape(fComplexMatrix3D);
        float[] fArray = new float[2];
        if (this.size() == 0) {
            fArray[0] = Float.NaN;
            fArray[1] = Float.NaN;
            return fArray;
        }
        float[] fArray2 = null;
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            Future[] futureArray = new Future[n];
            float[][] fArray3 = new float[n][2];
            int n2 = this.slices / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.slices : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Callable<float[]>(){

                    @Override
                    public float[] call() throws Exception {
                        float[] fArray = fComplexFComplexFComplexFunction2.apply(FComplexMatrix3D.this.getQuick(n3, 0, 0), fComplexMatrix3D.getQuick(n3, 0, 0));
                        int n = 1;
                        for (int i = n3; i < n4; ++i) {
                            for (int j = 0; j < FComplexMatrix3D.this.rows; ++j) {
                                for (int k = n; k < FComplexMatrix3D.this.columns; ++k) {
                                    fArray = fComplexFComplexFComplexFunction.apply(fArray, fComplexFComplexFComplexFunction2.apply(FComplexMatrix3D.this.getQuick(i, j, k), fComplexMatrix3D.getQuick(i, j, k)));
                                }
                                n = 0;
                            }
                        }
                        return fArray;
                    }
                });
            }
            fArray2 = ConcurrencyUtils.waitForCompletion(futureArray, fComplexFComplexFComplexFunction);
        } else {
            fArray2 = fComplexFComplexFComplexFunction2.apply(this.getQuick(0, 0, 0), fComplexMatrix3D.getQuick(0, 0, 0));
            int n5 = 1;
            for (int i = 0; i < this.slices; ++i) {
                for (int j = 0; j < this.rows; ++j) {
                    for (int k = n5; k < this.columns; ++k) {
                        fArray2 = fComplexFComplexFComplexFunction.apply(fArray2, fComplexFComplexFComplexFunction2.apply(this.getQuick(i, j, k), fComplexMatrix3D.getQuick(i, j, k)));
                    }
                    n5 = 0;
                }
            }
        }
        return fArray2;
    }

    public FComplexMatrix3D assign(final FComplexFComplexFunction fComplexFComplexFunction) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            Future[] futureArray = new Future[n];
            int n2 = this.slices / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.slices : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            for (int j = 0; j < FComplexMatrix3D.this.rows; ++j) {
                                for (int k = 0; k < FComplexMatrix3D.this.columns; ++k) {
                                    FComplexMatrix3D.this.setQuick(i, j, k, fComplexFComplexFunction.apply(FComplexMatrix3D.this.getQuick(i, j, k)));
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.slices; ++i) {
                for (int j = 0; j < this.rows; ++j) {
                    for (int k = 0; k < this.columns; ++k) {
                        this.setQuick(i, j, k, fComplexFComplexFunction.apply(this.getQuick(i, j, k)));
                    }
                }
            }
        }
        return this;
    }

    public FComplexMatrix3D assign(final FComplexRealFunction fComplexRealFunction) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            Future[] futureArray = new Future[n];
            int n2 = this.slices / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.slices : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        float[] fArray = new float[2];
                        for (int i = n3; i < n4; ++i) {
                            for (int j = 0; j < FComplexMatrix3D.this.rows; ++j) {
                                for (int k = 0; k < FComplexMatrix3D.this.columns; ++k) {
                                    fArray[0] = fComplexRealFunction.apply(FComplexMatrix3D.this.getQuick(i, j, k));
                                    FComplexMatrix3D.this.setQuick(i, j, k, fArray);
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            float[] fArray = new float[2];
            for (int i = 0; i < this.slices; ++i) {
                for (int j = 0; j < this.rows; ++j) {
                    for (int k = 0; k < this.columns; ++k) {
                        fArray[0] = fComplexRealFunction.apply(this.getQuick(i, j, k));
                        this.setQuick(i, j, k, fArray);
                    }
                }
            }
        }
        return this;
    }

    public FComplexMatrix3D assign(final FComplexProcedure fComplexProcedure, final FComplexFComplexFunction fComplexFComplexFunction) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            Future[] futureArray = new Future[n];
            int n2 = this.slices / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.slices : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            for (int j = 0; j < FComplexMatrix3D.this.rows; ++j) {
                                for (int k = 0; k < FComplexMatrix3D.this.columns; ++k) {
                                    float[] fArray = FComplexMatrix3D.this.getQuick(i, j, k);
                                    if (!fComplexProcedure.apply(fArray)) continue;
                                    FComplexMatrix3D.this.setQuick(i, j, k, fComplexFComplexFunction.apply(fArray));
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.slices; ++i) {
                for (int j = 0; j < this.rows; ++j) {
                    for (int k = 0; k < this.columns; ++k) {
                        float[] fArray = this.getQuick(i, j, k);
                        if (!fComplexProcedure.apply(fArray)) continue;
                        this.setQuick(i, j, k, fComplexFComplexFunction.apply(fArray));
                    }
                }
            }
        }
        return this;
    }

    public FComplexMatrix3D assign(final FComplexProcedure fComplexProcedure, final float[] fArray) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            Future[] futureArray = new Future[n];
            int n2 = this.slices / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.slices : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            for (int j = 0; j < FComplexMatrix3D.this.rows; ++j) {
                                for (int k = 0; k < FComplexMatrix3D.this.columns; ++k) {
                                    float[] fArray2 = FComplexMatrix3D.this.getQuick(i, j, k);
                                    if (!fComplexProcedure.apply(fArray2)) continue;
                                    FComplexMatrix3D.this.setQuick(i, j, k, fArray);
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.slices; ++i) {
                for (int j = 0; j < this.rows; ++j) {
                    for (int k = 0; k < this.columns; ++k) {
                        float[] fArray2 = this.getQuick(i, j, k);
                        if (!fComplexProcedure.apply(fArray2)) continue;
                        this.setQuick(i, j, k, fArray);
                    }
                }
            }
        }
        return this;
    }

    public FComplexMatrix3D assign(FComplexMatrix3D fComplexMatrix3D) {
        if (fComplexMatrix3D == this) {
            return this;
        }
        this.checkShape(fComplexMatrix3D);
        final FComplexMatrix3D fComplexMatrix3D2 = this.haveSharedCells(fComplexMatrix3D) ? fComplexMatrix3D.copy() : fComplexMatrix3D;
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            Future[] futureArray = new Future[n];
            int n2 = this.slices / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.slices : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            for (int j = 0; j < FComplexMatrix3D.this.rows; ++j) {
                                for (int k = 0; k < FComplexMatrix3D.this.columns; ++k) {
                                    FComplexMatrix3D.this.setQuick(i, j, k, fComplexMatrix3D2.getQuick(i, j, k));
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.slices; ++i) {
                for (int j = 0; j < this.rows; ++j) {
                    for (int k = 0; k < this.columns; ++k) {
                        this.setQuick(i, j, k, fComplexMatrix3D2.getQuick(i, j, k));
                    }
                }
            }
        }
        return this;
    }

    public FComplexMatrix3D assign(final FComplexMatrix3D fComplexMatrix3D, final FComplexFComplexFComplexFunction fComplexFComplexFComplexFunction) {
        this.checkShape(fComplexMatrix3D);
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            Future[] futureArray = new Future[n];
            int n2 = this.slices / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.slices : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            for (int j = 0; j < FComplexMatrix3D.this.rows; ++j) {
                                for (int k = 0; k < FComplexMatrix3D.this.columns; ++k) {
                                    FComplexMatrix3D.this.setQuick(i, j, k, fComplexFComplexFComplexFunction.apply(FComplexMatrix3D.this.getQuick(i, j, k), fComplexMatrix3D.getQuick(i, j, k)));
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.slices; ++i) {
                for (int j = 0; j < this.rows; ++j) {
                    for (int k = 0; k < this.columns; ++k) {
                        this.setQuick(i, j, k, fComplexFComplexFComplexFunction.apply(this.getQuick(i, j, k), fComplexMatrix3D.getQuick(i, j, k)));
                    }
                }
            }
        }
        return this;
    }

    public FComplexMatrix3D assign(final float f, final float f2) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.slices * this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            Future[] futureArray = new Future[n];
            int n2 = this.slices / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.slices : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            for (int j = 0; j < FComplexMatrix3D.this.rows; ++j) {
                                for (int k = 0; k < FComplexMatrix3D.this.columns; ++k) {
                                    FComplexMatrix3D.this.setQuick(i, j, k, f, f2);
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.slices; ++i) {
                for (int j = 0; j < this.rows; ++j) {
                    for (int k = 0; k < this.columns; ++k) {
                        this.setQuick(i, j, k, f, f2);
                    }
                }
            }
        }
        return this;
    }

    public FComplexMatrix3D assign(final float[] fArray) {
        if (fArray.length != this.slices * this.rows * 2 * this.columns) {
            throw new IllegalArgumentException("Must have same length: length=" + fArray.length + "slices()*rows()*2*columns()=" + this.slices() * this.rows() * 2 * this.columns());
        }
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.slices * this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            Future[] futureArray = new Future[n];
            int n2 = this.slices / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i * n2 * 2 * this.rows * this.columns;
                final int n5 = i == n - 1 ? this.slices : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n = n4;
                        for (int i = n3; i < n5; ++i) {
                            for (int j = 0; j < FComplexMatrix3D.this.rows; ++j) {
                                for (int k = 0; k < FComplexMatrix3D.this.columns; ++k) {
                                    FComplexMatrix3D.this.setQuick(i, j, k, fArray[n], fArray[n + 1]);
                                    n += 2;
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n6 = 0;
            for (int i = 0; i < this.slices; ++i) {
                for (int j = 0; j < this.rows; ++j) {
                    for (int k = 0; k < this.columns; ++k) {
                        this.setQuick(i, j, k, fArray[n6], fArray[n6 + 1]);
                        n6 += 2;
                    }
                }
            }
        }
        return this;
    }

    public FComplexMatrix3D assign(final float[][][] fArray) {
        if (fArray.length != this.slices) {
            throw new IllegalArgumentException("Must have same number of slices: slices=" + fArray.length + "slices()=" + this.slices());
        }
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.slices * this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            Future[] futureArray = new Future[n];
            int n2 = this.slices / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.slices : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            float[][] fArray3 = fArray[i];
                            if (fArray3.length != FComplexMatrix3D.this.rows) {
                                throw new IllegalArgumentException("Must have same number of rows in every slice: rows=" + fArray3.length + "rows()=" + FComplexMatrix3D.this.rows());
                            }
                            for (int j = 0; j < FComplexMatrix3D.this.rows; ++j) {
                                float[] fArray2 = fArray3[j];
                                if (fArray2.length != 2 * FComplexMatrix3D.this.columns) {
                                    throw new IllegalArgumentException("Must have same number of columns in every row: columns=" + fArray2.length + "2*columns()=" + 2 * FComplexMatrix3D.this.columns());
                                }
                                for (int k = 0; k < FComplexMatrix3D.this.columns; ++k) {
                                    FComplexMatrix3D.this.setQuick(i, j, k, fArray2[2 * k], fArray2[2 * k + 1]);
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.slices; ++i) {
                float[][] fArray2 = fArray[i];
                if (fArray2.length != this.rows) {
                    throw new IllegalArgumentException("Must have same number of rows in every slice: rows=" + fArray2.length + "rows()=" + this.rows());
                }
                for (int j = 0; j < this.rows; ++j) {
                    float[] fArray3 = fArray2[j];
                    if (fArray3.length != 2 * this.columns) {
                        throw new IllegalArgumentException("Must have same number of columns in every row: columns=" + fArray3.length + "2*columns()=" + 2 * this.columns());
                    }
                    for (int k = 0; k < this.columns; ++k) {
                        this.setQuick(i, j, k, fArray3[2 * k], fArray3[2 * k + 1]);
                    }
                }
            }
        }
        return this;
    }

    public FComplexMatrix3D assignImaginary(final FloatMatrix3D floatMatrix3D) {
        this.checkShape(floatMatrix3D);
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            Future[] futureArray = new Future[n];
            int n2 = this.slices / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.slices : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            for (int j = 0; j < FComplexMatrix3D.this.rows; ++j) {
                                for (int k = 0; k < FComplexMatrix3D.this.columns; ++k) {
                                    float f = FComplexMatrix3D.this.getQuick(i, j, k)[0];
                                    float f2 = floatMatrix3D.getQuick(i, j, k);
                                    FComplexMatrix3D.this.setQuick(i, j, k, f, f2);
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.slices; ++i) {
                for (int j = 0; j < this.rows; ++j) {
                    for (int k = 0; k < this.columns; ++k) {
                        float f = this.getQuick(i, j, k)[0];
                        float f2 = floatMatrix3D.getQuick(i, j, k);
                        this.setQuick(i, j, k, f, f2);
                    }
                }
            }
        }
        return this;
    }

    public FComplexMatrix3D assignReal(final FloatMatrix3D floatMatrix3D) {
        this.checkShape(floatMatrix3D);
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            Future[] futureArray = new Future[n];
            int n2 = this.slices / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.slices : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            for (int j = 0; j < FComplexMatrix3D.this.rows; ++j) {
                                for (int k = 0; k < FComplexMatrix3D.this.columns; ++k) {
                                    float f = floatMatrix3D.getQuick(i, j, k);
                                    float f2 = FComplexMatrix3D.this.getQuick(i, j, k)[1];
                                    FComplexMatrix3D.this.setQuick(i, j, k, f, f2);
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.slices; ++i) {
                for (int j = 0; j < this.rows; ++j) {
                    for (int k = 0; k < this.columns; ++k) {
                        float f = floatMatrix3D.getQuick(i, j, k);
                        float f2 = this.getQuick(i, j, k)[1];
                        this.setQuick(i, j, k, f, f2);
                    }
                }
            }
        }
        return this;
    }

    public int cardinality() {
        int n = 0;
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            int n3;
            Future[] futureArray = new Future[n2];
            Integer[] integerArray = new Integer[n2];
            int n4 = this.slices / n2;
            for (n3 = 0; n3 < n2; ++n3) {
                final int n5 = n3 * n4;
                final int n6 = n3 == n2 - 1 ? this.slices : n5 + n4;
                futureArray[n3] = ConcurrencyUtils.submit(new Callable<Integer>(){

                    @Override
                    public Integer call() throws Exception {
                        int n = 0;
                        float[] fArray = new float[2];
                        for (int i = n5; i < n6; ++i) {
                            for (int j = 0; j < FComplexMatrix3D.this.rows; ++j) {
                                for (int k = 0; k < FComplexMatrix3D.this.columns; ++k) {
                                    fArray = FComplexMatrix3D.this.getQuick(i, j, k);
                                    if ((double)fArray[0] == 0.0 && (double)fArray[1] == 0.0) continue;
                                    ++n;
                                }
                            }
                        }
                        return n;
                    }
                });
            }
            try {
                for (n3 = 0; n3 < n2; ++n3) {
                    integerArray[n3] = (Integer)futureArray[n3].get();
                }
                n = integerArray[0];
                for (n3 = 1; n3 < n2; ++n3) {
                    n += integerArray[n3].intValue();
                }
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        } else {
            float[] fArray = new float[2];
            for (int i = 0; i < this.slices; ++i) {
                for (int j = 0; j < this.rows; ++j) {
                    for (int k = 0; k < this.columns; ++k) {
                        fArray = this.getQuick(i, j, k);
                        if (fArray[0] == 0.0f && fArray[1] == 0.0f) continue;
                        ++n;
                    }
                }
            }
        }
        return n;
    }

    public FComplexMatrix3D copy() {
        return this.like().assign(this);
    }

    public boolean equals(float[] fArray) {
        return FloatProperty.DEFAULT.equals(this, fArray);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof FComplexMatrix3D)) {
            return false;
        }
        return FloatProperty.DEFAULT.equals(this, (FComplexMatrix3D)object);
    }

    public float[] get(int n, int n2, int n3) {
        if (n < 0 || n >= this.slices || n2 < 0 || n2 >= this.rows || n3 < 0 || n3 >= this.columns) {
            throw new IndexOutOfBoundsException("slice:" + n + ", row:" + n2 + ", column:" + n3);
        }
        return this.getQuick(n, n2, n3);
    }

    public abstract Object elements();

    public abstract FloatMatrix3D getImaginaryPart();

    public void getNonZeros(IntArrayList intArrayList, IntArrayList intArrayList2, IntArrayList intArrayList3, ArrayList<float[]> arrayList) {
        intArrayList.clear();
        intArrayList2.clear();
        intArrayList3.clear();
        arrayList.clear();
        for (int i = 0; i < this.slices; ++i) {
            for (int j = 0; j < this.rows; ++j) {
                for (int k = 0; k < this.columns; ++k) {
                    float[] fArray = this.getQuick(i, j, k);
                    if (fArray[0] == 0.0f && fArray[1] == 0.0f) continue;
                    intArrayList.add(i);
                    intArrayList2.add(j);
                    intArrayList3.add(k);
                    arrayList.add(fArray);
                }
            }
        }
    }

    public abstract float[] getQuick(int var1, int var2, int var3);

    public abstract FloatMatrix3D getRealPart();

    public FComplexMatrix3D like() {
        return this.like(this.slices, this.rows, this.columns);
    }

    public abstract FComplexMatrix3D like(int var1, int var2, int var3);

    public void set(int n, int n2, int n3, float[] fArray) {
        if (n < 0 || n >= this.slices || n2 < 0 || n2 >= this.rows || n3 < 0 || n3 >= this.columns) {
            throw new IndexOutOfBoundsException("slice:" + n + ", row:" + n2 + ", column:" + n3);
        }
        this.setQuick(n, n2, n3, fArray);
    }

    public abstract void setQuick(int var1, int var2, int var3, float var4, float var5);

    public abstract void setQuick(int var1, int var2, int var3, float[] var4);

    public float[][][] toArray() {
        final float[][][] fArray = new float[this.slices][this.rows][2 * this.columns];
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            Future[] futureArray = new Future[n];
            int n2 = this.slices / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.slices : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        float[] fArray4 = new float[2];
                        for (int i = n3; i < n4; ++i) {
                            float[][] fArray2 = fArray[i];
                            for (int j = 0; j < FComplexMatrix3D.this.rows; ++j) {
                                float[] fArray3 = fArray2[j];
                                for (int k = 0; k < FComplexMatrix3D.this.columns; ++k) {
                                    fArray4 = FComplexMatrix3D.this.getQuick(i, j, k);
                                    fArray3[2 * k] = fArray4[0];
                                    fArray3[2 * k + 1] = fArray4[1];
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            float[] fArray2 = new float[2];
            for (int i = 0; i < this.slices; ++i) {
                float[][] fArray3 = fArray[i];
                for (int j = 0; j < this.rows; ++j) {
                    float[] fArray4 = fArray3[j];
                    for (int k = 0; k < this.columns; ++k) {
                        fArray2 = this.getQuick(i, j, k);
                        fArray4[2 * k] = fArray2[0];
                        fArray4[2 * k + 1] = fArray2[1];
                    }
                }
            }
        }
        return fArray;
    }

    public String toString() {
        return this.toString("%.4f");
    }

    public String toString(String string) {
        StringBuffer stringBuffer = new StringBuffer(String.format("ComplexMatrix3D: %d slices, %d rows, %d columns\n\n", this.slices, this.rows, this.columns));
        float[] fArray = new float[2];
        for (int i = 0; i < this.slices; ++i) {
            stringBuffer.append(String.format("(:,:,%d)=\n", i));
            for (int j = 0; j < this.rows; ++j) {
                for (int k = 0; k < this.columns; ++k) {
                    fArray = this.getQuick(i, j, k);
                    if (fArray[1] == 0.0f) {
                        stringBuffer.append(String.format(string + "\t", Float.valueOf(fArray[0])));
                        continue;
                    }
                    if (fArray[0] == 0.0f) {
                        stringBuffer.append(String.format(string + "i\t", Float.valueOf(fArray[1])));
                        continue;
                    }
                    if (fArray[1] < 0.0f) {
                        stringBuffer.append(String.format(string + " - " + string + "i\t", Float.valueOf(fArray[0]), Float.valueOf(-fArray[1])));
                        continue;
                    }
                    stringBuffer.append(String.format(string + " + " + string + "i\t", Float.valueOf(fArray[0]), Float.valueOf(fArray[1])));
                }
                stringBuffer.append("\n");
            }
        }
        return stringBuffer.toString();
    }

    public abstract FComplexMatrix1D vectorize();

    public FComplexMatrix2D viewColumn(int n) {
        this.checkColumn(n);
        int n2 = this.slices;
        int n3 = this.rows;
        int n4 = this.sliceZero;
        int n5 = this.rowZero + this._columnOffset(this._columnRank(n));
        int n6 = this.sliceStride;
        int n7 = this.rowStride;
        return this.like2D(n2, n3, n4, n5, n6, n7);
    }

    public FComplexMatrix3D viewColumnFlip() {
        return (FComplexMatrix3D)this.view().vColumnFlip();
    }

    public FComplexMatrix3D viewDice(int n, int n2, int n3) {
        return (FComplexMatrix3D)this.view().vDice(n, n2, n3);
    }

    public FComplexMatrix3D viewPart(int n, int n2, int n3, int n4, int n5, int n6) {
        return (FComplexMatrix3D)this.view().vPart(n, n2, n3, n4, n5, n6);
    }

    public FComplexMatrix2D viewRow(int n) {
        this.checkRow(n);
        int n2 = this.slices;
        int n3 = this.columns;
        int n4 = this.sliceZero;
        int n5 = this.columnZero + this._rowOffset(this._rowRank(n));
        int n6 = this.sliceStride;
        int n7 = this.columnStride;
        return this.like2D(n2, n3, n4, n5, n6, n7);
    }

    public FComplexMatrix3D viewRowFlip() {
        return (FComplexMatrix3D)this.view().vRowFlip();
    }

    public FComplexMatrix3D viewSelection(FComplexMatrix2DProcedure fComplexMatrix2DProcedure) {
        IntArrayList intArrayList = new IntArrayList();
        for (int i = 0; i < this.slices; ++i) {
            if (!fComplexMatrix2DProcedure.apply(this.viewSlice(i))) continue;
            intArrayList.add(i);
        }
        intArrayList.trimToSize();
        return this.viewSelection(intArrayList.elements(), null, null);
    }

    public FComplexMatrix3D viewSelection(int[] nArray, int[] nArray2, int[] nArray3) {
        int n;
        int n2;
        if (nArray == null) {
            nArray = new int[this.slices];
            n2 = this.slices;
            while (--n2 >= 0) {
                nArray[n2] = n2;
            }
        }
        if (nArray2 == null) {
            nArray2 = new int[this.rows];
            n2 = this.rows;
            while (--n2 >= 0) {
                nArray2[n2] = n2;
            }
        }
        if (nArray3 == null) {
            nArray3 = new int[this.columns];
            n2 = this.columns;
            while (--n2 >= 0) {
                nArray3[n2] = n2;
            }
        }
        this.checkSliceIndexes(nArray);
        this.checkRowIndexes(nArray2);
        this.checkColumnIndexes(nArray3);
        int[] nArray4 = new int[nArray.length];
        int[] nArray5 = new int[nArray2.length];
        int[] nArray6 = new int[nArray3.length];
        for (n = 0; n < nArray.length; ++n) {
            nArray4[n] = this._sliceOffset(this._sliceRank(nArray[n]));
        }
        for (n = 0; n < nArray2.length; ++n) {
            nArray5[n] = this._rowOffset(this._rowRank(nArray2[n]));
        }
        for (n = 0; n < nArray3.length; ++n) {
            nArray6[n] = this._columnOffset(this._columnRank(nArray3[n]));
        }
        return this.viewSelectionLike(nArray4, nArray5, nArray6);
    }

    public FComplexMatrix2D viewSlice(int n) {
        this.checkSlice(n);
        int n2 = this.rows;
        int n3 = this.columns;
        int n4 = this.rowZero;
        int n5 = this.columnZero + this._sliceOffset(this._sliceRank(n));
        int n6 = this.rowStride;
        int n7 = this.columnStride;
        return this.like2D(n2, n3, n4, n5, n6, n7);
    }

    public FComplexMatrix3D viewSliceFlip() {
        return (FComplexMatrix3D)this.view().vSliceFlip();
    }

    public FComplexMatrix3D viewStrides(int n, int n2, int n3) {
        return (FComplexMatrix3D)this.view().vStrides(n, n2, n3);
    }

    public float[] zSum() {
        if (this.size() == 0) {
            return new float[2];
        }
        return this.aggregate(FComplexFunctions.plus, FComplexFunctions.identity);
    }

    protected FComplexMatrix3D getContent() {
        return this;
    }

    protected boolean haveSharedCells(FComplexMatrix3D fComplexMatrix3D) {
        if (fComplexMatrix3D == null) {
            return false;
        }
        if (this == fComplexMatrix3D) {
            return true;
        }
        return this.getContent().haveSharedCellsRaw(fComplexMatrix3D.getContent());
    }

    protected boolean haveSharedCellsRaw(FComplexMatrix3D fComplexMatrix3D) {
        return false;
    }

    protected abstract FComplexMatrix2D like2D(int var1, int var2, int var3, int var4, int var5, int var6);

    protected FComplexMatrix3D view() {
        return (FComplexMatrix3D)this.clone();
    }

    protected abstract FComplexMatrix3D viewSelectionLike(int[] var1, int[] var2, int[] var3);
}

