/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfcomplex;

import cern.colt.function.tfcomplex.FComplexProcedure;
import cern.colt.function.tfcomplex.IntIntFComplexFunction;
import cern.colt.list.tint.IntArrayList;
import cern.colt.matrix.tfcomplex.FComplexMatrix1D;
import cern.colt.matrix.tfcomplex.FComplexMatrix1DProcedure;
import cern.colt.matrix.tfcomplex.FComplexMatrix2D;
import cern.colt.matrix.tfcomplex.impl.DenseFComplexMatrix1D;
import cern.colt.matrix.tfloat.FloatFactory2D;
import cern.colt.matrix.tfloat.FloatMatrix2D;
import cern.jet.math.tfcomplex.FComplex;
import cern.jet.math.tfcomplex.FComplexFunctions;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.util.ArrayList;
import junit.framework.TestCase;

public abstract class FComplexMatrix2DTest
extends TestCase {
    protected FComplexMatrix2D A;
    protected FComplexMatrix2D B;
    protected FComplexMatrix2D Bt;
    protected int NROWS = 13;
    protected int NCOLUMNS = 17;
    protected float TOL = 0.001f;

    public FComplexMatrix2DTest(String string) {
        super(string);
    }

    protected void setUp() throws Exception {
        this.createMatrices();
        this.populateMatrices();
    }

    protected abstract void createMatrices() throws Exception;

    protected void populateMatrices() {
        int n;
        int n2;
        ConcurrencyUtils.setThreadsBeginN_2D(1);
        for (n2 = 0; n2 < this.NROWS; ++n2) {
            for (n = 0; n < this.NCOLUMNS; ++n) {
                this.A.setQuick(n2, n, new float[]{(float)Math.random(), (float)Math.random()});
            }
        }
        for (n2 = 0; n2 < this.NROWS; ++n2) {
            for (n = 0; n < this.NCOLUMNS; ++n) {
                this.B.setQuick(n2, n, new float[]{(float)Math.random(), (float)Math.random()});
            }
        }
        for (n2 = 0; n2 < this.NCOLUMNS; ++n2) {
            for (n = 0; n < this.NROWS; ++n) {
                this.Bt.setQuick(n2, n, new float[]{(float)Math.random(), (float)Math.random()});
            }
        }
    }

    protected void tearDown() throws Exception {
        this.Bt = null;
        this.B = null;
        this.A = null;
    }

    public void testAggregateComplexComplexComplexFunctionComplexComplexFunction() {
        float[] fArray = this.A.aggregate(FComplexFunctions.plus, FComplexFunctions.square);
        float[] fArray2 = new float[2];
        for (int i = 0; i < this.NROWS; ++i) {
            for (int j = 0; j < this.NCOLUMNS; ++j) {
                fArray2 = FComplex.plus(fArray2, FComplex.square(this.A.getQuick(i, j)));
            }
        }
        this.assertEquals(fArray2, fArray, this.TOL);
    }

    public void testAggregateComplexMatrix2FComplexComplexComplexFunctionComplexComplexComplexFunction() {
        float[] fArray = this.A.aggregate(this.B, FComplexFunctions.plus, FComplexFunctions.mult);
        float[] fArray2 = new float[2];
        for (int i = 0; i < this.NROWS; ++i) {
            for (int j = 0; j < this.NCOLUMNS; ++j) {
                fArray2 = FComplex.plus(fArray2, FComplex.mult(this.A.getQuick(i, j), this.B.getQuick(i, j)));
            }
        }
        this.assertEquals(fArray2, fArray, this.TOL);
    }

    public void testAssignComplexComplexFunction() {
        FComplexMatrix2D fComplexMatrix2D = this.A.copy();
        this.A.assign(FComplexFunctions.acos);
        for (int i = 0; i < this.NROWS; ++i) {
            for (int j = 0; j < this.NCOLUMNS; ++j) {
                float[] fArray = FComplex.acos(fComplexMatrix2D.getQuick(i, j));
                this.assertEquals(fArray, this.A.getQuick(i, j), this.TOL);
            }
        }
    }

    public void testAssignComplexMatrix2D() {
        this.A.assign(this.B);
        for (int i = 0; i < this.NROWS; ++i) {
            for (int j = 0; j < this.NCOLUMNS; ++j) {
                this.assertEquals(this.B.getQuick(i, j), this.A.getQuick(i, j), this.TOL);
            }
        }
    }

    public void testAssignComplexMatrix2FComplexComplexComplexFunction() {
        FComplexMatrix2D fComplexMatrix2D = this.A.copy();
        this.A.assign(this.B, FComplexFunctions.div);
        for (int i = 0; i < this.NROWS; ++i) {
            for (int j = 0; j < this.NCOLUMNS; ++j) {
                this.assertEquals(FComplex.div(fComplexMatrix2D.getQuick(i, j), this.B.getQuick(i, j)), this.A.getQuick(i, j), this.TOL);
            }
        }
    }

    public void testAssignComplexProcedureComplexComplexFunction() {
        FComplexMatrix2D fComplexMatrix2D = this.A.copy();
        this.A.assign(new FComplexProcedure(){

            public boolean apply(float[] fArray) {
                return FComplex.abs(fArray) > 3.0f;
            }
        }, FComplexFunctions.tan);
        for (int i = 0; i < this.NROWS; ++i) {
            for (int j = 0; j < this.NCOLUMNS; ++j) {
                if (FComplex.abs(fComplexMatrix2D.getQuick(i, j)) > 3.0f) {
                    this.assertEquals(FComplex.tan(fComplexMatrix2D.getQuick(i, j)), this.A.getQuick(i, j), this.TOL);
                    continue;
                }
                this.assertEquals(fComplexMatrix2D.getQuick(i, j), this.A.getQuick(i, j), this.TOL);
            }
        }
    }

    public void testAssignComplexProcedureFloatArray() {
        FComplexMatrix2D fComplexMatrix2D = this.A.copy();
        float[] fArray = new float[]{(float)Math.random(), (float)Math.random()};
        this.A.assign(new FComplexProcedure(){

            public boolean apply(float[] fArray) {
                return FComplex.abs(fArray) > 3.0f;
            }
        }, fArray);
        for (int i = 0; i < this.NROWS; ++i) {
            for (int j = 0; j < this.NCOLUMNS; ++j) {
                if (FComplex.abs(this.A.getQuick(i, j)) > 3.0f) {
                    this.assertEquals(fArray, this.A.getQuick(i, j), this.TOL);
                    continue;
                }
                this.assertEquals(fComplexMatrix2D.getQuick(i, j), this.A.getQuick(i, j), this.TOL);
            }
        }
    }

    public void testAssignComplexRealFunction() {
        FComplexMatrix2D fComplexMatrix2D = this.A.copy();
        this.A.assign(FComplexFunctions.abs);
        for (int i = 0; i < this.NROWS; ++i) {
            for (int j = 0; j < this.NCOLUMNS; ++j) {
                float[] fArray = this.A.getQuick(i, j);
                FComplexMatrix2DTest.assertEquals((float)FComplex.abs(fComplexMatrix2D.getQuick(i, j)), (float)fArray[0], (float)this.TOL);
                FComplexMatrix2DTest.assertEquals((float)0.0f, (float)fArray[1], (float)this.TOL);
            }
        }
    }

    public void testAssignFloatArray() {
        int n;
        float[] fArray = new float[2 * this.A.size()];
        for (n = 0; n < 2 * this.A.size(); ++n) {
            fArray[n] = (float)Math.random();
        }
        this.A.assign(fArray);
        n = 0;
        for (int i = 0; i < this.NROWS; ++i) {
            for (int j = 0; j < this.NCOLUMNS; ++j) {
                float[] fArray2 = this.A.getQuick(i, j);
                FComplexMatrix2DTest.assertEquals((float)fArray[n], (float)fArray2[0], (float)this.TOL);
                FComplexMatrix2DTest.assertEquals((float)fArray[n + 1], (float)fArray2[1], (float)this.TOL);
                n += 2;
            }
        }
    }

    public void testAssignFloatArrayArray() {
        int n;
        int n2;
        float[][] fArray = new float[this.NROWS][2 * this.NCOLUMNS];
        for (n2 = 0; n2 < this.NROWS; ++n2) {
            for (n = 0; n < 2 * this.NCOLUMNS; ++n) {
                fArray[n2][n] = (float)Math.random();
            }
        }
        this.A.assign(fArray);
        for (n2 = 0; n2 < this.NROWS; ++n2) {
            for (n = 0; n < this.NCOLUMNS; ++n) {
                float[] fArray2 = this.A.getQuick(n2, n);
                FComplexMatrix2DTest.assertEquals((float)fArray[n2][2 * n], (float)fArray2[0], (float)this.TOL);
                FComplexMatrix2DTest.assertEquals((float)fArray[n2][2 * n + 1], (float)fArray2[1], (float)this.TOL);
            }
        }
    }

    public void testAssignFloatFloat() {
        float[] fArray = new float[]{(float)Math.random(), (float)Math.random()};
        this.A.assign(fArray[0], fArray[1]);
        for (int i = 0; i < this.NROWS; ++i) {
            for (int j = 0; j < this.NCOLUMNS; ++j) {
                float[] fArray2 = this.A.getQuick(i, j);
                this.assertEquals(fArray, fArray2, this.TOL);
            }
        }
    }

    public void testAssignImaginary() {
        FloatMatrix2D floatMatrix2D = FloatFactory2D.dense.random(this.NROWS, this.NCOLUMNS);
        FComplexMatrix2D fComplexMatrix2D = this.A.copy();
        this.A.assignImaginary(floatMatrix2D);
        for (int i = 0; i < this.NROWS; ++i) {
            for (int j = 0; j < this.NCOLUMNS; ++j) {
                FComplexMatrix2DTest.assertEquals((float)fComplexMatrix2D.getQuick(i, j)[0], (float)this.A.getQuick(i, j)[0], (float)this.TOL);
                FComplexMatrix2DTest.assertEquals((float)floatMatrix2D.getQuick(i, j), (float)this.A.getQuick(i, j)[1], (float)this.TOL);
            }
        }
    }

    public void testAssignReal() {
        FloatMatrix2D floatMatrix2D = FloatFactory2D.dense.random(this.NROWS, this.NCOLUMNS);
        FComplexMatrix2D fComplexMatrix2D = this.A.copy();
        this.A.assignReal(floatMatrix2D);
        for (int i = 0; i < this.NROWS; ++i) {
            for (int j = 0; j < this.NCOLUMNS; ++j) {
                FComplexMatrix2DTest.assertEquals((float)fComplexMatrix2D.getQuick(i, j)[1], (float)this.A.getQuick(i, j)[1], (float)this.TOL);
                FComplexMatrix2DTest.assertEquals((float)floatMatrix2D.getQuick(i, j), (float)this.A.getQuick(i, j)[0], (float)this.TOL);
            }
        }
    }

    public void testCardinality() {
        int n = this.A.cardinality();
        FComplexMatrix2DTest.assertEquals((int)this.A.size(), (int)n);
    }

    public void testEqualsFloatArray() {
        float[] fArray = new float[]{(float)Math.random(), (float)Math.random()};
        this.A.assign(fArray[0], fArray[1]);
        boolean bl = this.A.equals(fArray);
        FComplexMatrix2DTest.assertEquals((boolean)true, (boolean)bl);
        bl = this.A.equals(new float[]{fArray[0] + 1.0f, fArray[1] + 1.0f});
        FComplexMatrix2DTest.assertEquals((boolean)false, (boolean)bl);
    }

    public void testEqualsObject() {
        boolean bl = this.A.equals(this.A);
        FComplexMatrix2DTest.assertEquals((boolean)true, (boolean)bl);
        bl = this.A.equals(this.B);
        FComplexMatrix2DTest.assertEquals((boolean)false, (boolean)bl);
    }

    public void testForEachNonZero() {
        FComplexMatrix2D fComplexMatrix2D = this.A.copy();
        IntIntFComplexFunction intIntFComplexFunction = new IntIntFComplexFunction(){

            public float[] apply(int n, int n2, float[] fArray) {
                return FComplex.sqrt(fArray);
            }
        };
        this.A.forEachNonZero(intIntFComplexFunction);
        for (int i = 0; i < this.NROWS; ++i) {
            for (int j = 0; j < this.NCOLUMNS; ++j) {
                this.assertEquals(FComplex.sqrt(fComplexMatrix2D.getQuick(i, j)), this.A.getQuick(i, j), this.TOL);
            }
        }
    }

    public void testGetConjugateTranspose() {
        FComplexMatrix2D fComplexMatrix2D = this.A.getConjugateTranspose();
        FComplexMatrix2DTest.assertEquals((int)this.A.rows(), (int)fComplexMatrix2D.columns());
        FComplexMatrix2DTest.assertEquals((int)this.A.columns(), (int)fComplexMatrix2D.rows());
        for (int i = 0; i < this.NROWS; ++i) {
            for (int j = 0; j < this.NCOLUMNS; ++j) {
                FComplexMatrix2DTest.assertEquals((float)this.A.getQuick(i, j)[0], (float)fComplexMatrix2D.getQuick(j, i)[0], (float)this.TOL);
                FComplexMatrix2DTest.assertEquals((float)(-this.A.getQuick(i, j)[1]), (float)fComplexMatrix2D.getQuick(j, i)[1], (float)this.TOL);
            }
        }
    }

    public void testGetImaginaryPart() {
        FloatMatrix2D floatMatrix2D = this.A.getImaginaryPart();
        for (int i = 0; i < this.NROWS; ++i) {
            for (int j = 0; j < this.NCOLUMNS; ++j) {
                FComplexMatrix2DTest.assertEquals((float)this.A.getQuick(i, j)[1], (float)floatMatrix2D.getQuick(i, j), (float)this.TOL);
            }
        }
    }

    public void testGetNonZeros() {
        IntArrayList intArrayList = new IntArrayList();
        IntArrayList intArrayList2 = new IntArrayList();
        ArrayList<float[]> arrayList = new ArrayList<float[]>();
        this.A.getNonZeros(intArrayList, intArrayList2, arrayList);
        FComplexMatrix2DTest.assertEquals((int)this.A.size(), (int)intArrayList.size());
        FComplexMatrix2DTest.assertEquals((int)this.A.size(), (int)intArrayList2.size());
        FComplexMatrix2DTest.assertEquals((int)this.A.size(), (int)arrayList.size());
        int n = 0;
        for (int i = 0; i < this.NROWS; ++i) {
            for (int j = 0; j < this.NCOLUMNS; ++j) {
                this.assertEquals(this.A.getQuick(intArrayList.get(n), intArrayList2.get(n)), arrayList.get(n), this.TOL);
                ++n;
            }
        }
    }

    public void testGetRealPart() {
        FloatMatrix2D floatMatrix2D = this.A.getRealPart();
        for (int i = 0; i < this.NROWS; ++i) {
            for (int j = 0; j < this.NCOLUMNS; ++j) {
                FComplexMatrix2DTest.assertEquals((float)this.A.getQuick(i, j)[0], (float)floatMatrix2D.getQuick(i, j), (float)this.TOL);
            }
        }
    }

    public void testToArray() {
        float[][] fArray = this.A.toArray();
        for (int i = 0; i < this.NROWS; ++i) {
            for (int j = 0; j < this.NCOLUMNS; ++j) {
                FComplexMatrix2DTest.assertEquals((float)this.A.getQuick(i, j)[0], (float)fArray[i][2 * j], (float)this.TOL);
                FComplexMatrix2DTest.assertEquals((float)this.A.getQuick(i, j)[1], (float)fArray[i][2 * j + 1], (float)this.TOL);
            }
        }
    }

    public void testVectorize() {
        FComplexMatrix1D fComplexMatrix1D = this.A.vectorize();
        int n = 0;
        for (int i = 0; i < this.NCOLUMNS; ++i) {
            for (int j = 0; j < this.NROWS; ++j) {
                this.assertEquals(this.A.getQuick(j, i), fComplexMatrix1D.getQuick(n++), this.TOL);
            }
        }
    }

    public void testViewColumn() {
        FComplexMatrix1D fComplexMatrix1D = this.A.viewColumn(this.NCOLUMNS / 2);
        FComplexMatrix2DTest.assertEquals((int)this.NROWS, (int)fComplexMatrix1D.size());
        for (int i = 0; i < this.NROWS; ++i) {
            this.assertEquals(this.A.getQuick(i, this.NCOLUMNS / 2), fComplexMatrix1D.getQuick(i), this.TOL);
        }
    }

    public void testViewColumnFlip() {
        FComplexMatrix2D fComplexMatrix2D = this.A.viewColumnFlip();
        FComplexMatrix2DTest.assertEquals((int)this.A.size(), (int)fComplexMatrix2D.size());
        for (int i = 0; i < this.NROWS; ++i) {
            for (int j = 0; j < this.NCOLUMNS; ++j) {
                this.assertEquals(this.A.getQuick(i, this.NCOLUMNS - 1 - j), fComplexMatrix2D.getQuick(i, j), this.TOL);
            }
        }
    }

    public void testViewDice() {
        FComplexMatrix2D fComplexMatrix2D = this.A.viewDice();
        FComplexMatrix2DTest.assertEquals((int)this.A.rows(), (int)fComplexMatrix2D.columns());
        FComplexMatrix2DTest.assertEquals((int)this.A.columns(), (int)fComplexMatrix2D.rows());
        for (int i = 0; i < this.NROWS; ++i) {
            for (int j = 0; j < this.NCOLUMNS; ++j) {
                this.assertEquals(this.A.getQuick(i, j), fComplexMatrix2D.getQuick(j, i), this.TOL);
            }
        }
    }

    public void testViewPart() {
        FComplexMatrix2D fComplexMatrix2D = this.A.viewPart(this.NROWS / 2, this.NCOLUMNS / 2, this.NROWS / 3, this.NCOLUMNS / 3);
        for (int i = 0; i < this.NROWS / 3; ++i) {
            for (int j = 0; j < this.NCOLUMNS / 3; ++j) {
                this.assertEquals(this.A.getQuick(this.NROWS / 2 + i, this.NCOLUMNS / 2 + j), fComplexMatrix2D.getQuick(i, j), this.TOL);
            }
        }
    }

    public void testViewRow() {
        FComplexMatrix1D fComplexMatrix1D = this.A.viewRow(this.NROWS / 2);
        FComplexMatrix2DTest.assertEquals((int)this.NCOLUMNS, (int)fComplexMatrix1D.size());
        for (int i = 0; i < this.NCOLUMNS; ++i) {
            this.assertEquals(this.A.getQuick(this.NROWS / 2, i), fComplexMatrix1D.getQuick(i), this.TOL);
        }
    }

    public void testViewRowFlip() {
        FComplexMatrix2D fComplexMatrix2D = this.A.viewRowFlip();
        FComplexMatrix2DTest.assertEquals((int)this.A.size(), (int)fComplexMatrix2D.size());
        for (int i = 0; i < this.NROWS; ++i) {
            for (int j = 0; j < this.NCOLUMNS; ++j) {
                this.assertEquals(this.A.getQuick(this.NROWS - 1 - i, j), fComplexMatrix2D.getQuick(i, j), this.TOL);
            }
        }
    }

    public void testViewSelectionComplexMatrix1DProcedure() {
        final float[] fArray = new float[]{(float)Math.random(), (float)Math.random()};
        this.A.setQuick(this.NROWS / 3, 0, fArray);
        this.A.setQuick(this.NROWS / 2, 0, fArray);
        FComplexMatrix2D fComplexMatrix2D = this.A.viewSelection(new FComplexMatrix1DProcedure(){

            public boolean apply(FComplexMatrix1D fComplexMatrix1D) {
                return FComplex.isEqual(fComplexMatrix1D.getQuick(0), fArray, FComplexMatrix2DTest.this.TOL);
            }
        });
        FComplexMatrix2DTest.assertEquals((int)2, (int)fComplexMatrix2D.rows());
        FComplexMatrix2DTest.assertEquals((int)this.A.columns(), (int)fComplexMatrix2D.columns());
        this.assertEquals(this.A.getQuick(this.NROWS / 3, 0), fComplexMatrix2D.getQuick(0, 0), this.TOL);
        this.assertEquals(this.A.getQuick(this.NROWS / 2, 0), fComplexMatrix2D.getQuick(1, 0), this.TOL);
    }

    public void testViewSelectionIntArrayIntArray() {
        int[] nArray = new int[]{this.NROWS / 6, this.NROWS / 5, this.NROWS / 4, this.NROWS / 3, this.NROWS / 2};
        int[] nArray2 = new int[]{this.NCOLUMNS / 6, this.NCOLUMNS / 5, this.NCOLUMNS / 4, this.NCOLUMNS / 3, this.NCOLUMNS / 2, this.NCOLUMNS - 1};
        FComplexMatrix2D fComplexMatrix2D = this.A.viewSelection(nArray, nArray2);
        FComplexMatrix2DTest.assertEquals((int)nArray.length, (int)fComplexMatrix2D.rows());
        FComplexMatrix2DTest.assertEquals((int)nArray2.length, (int)fComplexMatrix2D.columns());
        for (int i = 0; i < nArray.length; ++i) {
            for (int j = 0; j < nArray2.length; ++j) {
                this.assertEquals(this.A.getQuick(nArray[i], nArray2[j]), fComplexMatrix2D.getQuick(i, j), this.TOL);
            }
        }
    }

    public void testViewStrides() {
        int n = 3;
        int n2 = 5;
        FComplexMatrix2D fComplexMatrix2D = this.A.viewStrides(n, n2);
        for (int i = 0; i < fComplexMatrix2D.rows(); ++i) {
            for (int j = 0; j < fComplexMatrix2D.columns(); ++j) {
                this.assertEquals(this.A.getQuick(i * n, j * n2), fComplexMatrix2D.getQuick(i, j), this.TOL);
            }
        }
    }

    public void testZMultFComplexMatrix1DFComplexMatrix1DFComplexFComplexBoolean() {
        int n;
        float[] fArray;
        int n2;
        DenseFComplexMatrix1D denseFComplexMatrix1D = new DenseFComplexMatrix1D(this.NCOLUMNS);
        for (int i = 0; i < denseFComplexMatrix1D.size(); ++i) {
            ((FComplexMatrix1D)denseFComplexMatrix1D).setQuick(i, new float[]{(float)Math.random(), (float)Math.random()});
        }
        float[] fArray2 = new float[]{3.0f, 2.0f};
        float[] fArray3 = new float[]{5.0f, 4.0f};
        FComplexMatrix1D fComplexMatrix1D = null;
        fComplexMatrix1D = this.A.zMult(denseFComplexMatrix1D, fComplexMatrix1D, fArray2, fArray3, false);
        float[] fArray4 = new float[2 * this.NROWS];
        float[] fArray5 = new float[2];
        for (n2 = 0; n2 < this.NROWS; ++n2) {
            fArray = new float[2];
            for (n = 0; n < this.NCOLUMNS; ++n) {
                fArray = FComplex.plus(fArray, FComplex.mult(this.A.getQuick(n2, n), ((FComplexMatrix1D)denseFComplexMatrix1D).getQuick(n)));
            }
            fArray5[0] = fArray4[2 * n2];
            fArray5[1] = fArray4[2 * n2 + 1];
            fArray5 = FComplex.mult(fArray3, fArray5);
            fArray5 = FComplex.plus(fArray5, FComplex.mult(fArray2, fArray));
            fArray4[2 * n2] = fArray5[0];
            fArray4[2 * n2 + 1] = fArray5[1];
        }
        for (n2 = 0; n2 < this.NROWS; ++n2) {
            FComplexMatrix2DTest.assertEquals((float)fArray4[2 * n2], (float)fComplexMatrix1D.getQuick(n2)[0], (float)this.TOL);
            FComplexMatrix2DTest.assertEquals((float)fArray4[2 * n2 + 1], (float)fComplexMatrix1D.getQuick(n2)[1], (float)this.TOL);
        }
        denseFComplexMatrix1D = new DenseFComplexMatrix1D(this.NROWS);
        for (n2 = 0; n2 < denseFComplexMatrix1D.size(); ++n2) {
            ((FComplexMatrix1D)denseFComplexMatrix1D).setQuick(n2, new float[]{(float)Math.random(), (float)Math.random()});
        }
        fComplexMatrix1D = null;
        fComplexMatrix1D = this.A.zMult(denseFComplexMatrix1D, fComplexMatrix1D, fArray2, fArray3, true);
        fArray4 = new float[2 * this.NCOLUMNS];
        for (n2 = 0; n2 < this.NCOLUMNS; ++n2) {
            fArray = new float[2];
            for (n = 0; n < this.NROWS; ++n) {
                fArray = FComplex.plus(fArray, FComplex.mult(FComplex.conj(this.A.getQuick(n, n2)), ((FComplexMatrix1D)denseFComplexMatrix1D).getQuick(n)));
            }
            fArray5[0] = fArray4[2 * n2];
            fArray5[1] = fArray4[2 * n2 + 1];
            fArray5 = FComplex.mult(fArray3, fArray5);
            fArray5 = FComplex.plus(fArray5, FComplex.mult(fArray2, fArray));
            fArray4[2 * n2] = fArray5[0];
            fArray4[2 * n2 + 1] = fArray5[1];
        }
        for (n2 = 0; n2 < this.NCOLUMNS; ++n2) {
            FComplexMatrix2DTest.assertEquals((float)fArray4[2 * n2], (float)fComplexMatrix1D.getQuick(n2)[0], (float)this.TOL);
            FComplexMatrix2DTest.assertEquals((float)fArray4[2 * n2 + 1], (float)fComplexMatrix1D.getQuick(n2)[1], (float)this.TOL);
        }
    }

    public void testZMultFloatMatrix2DFloatMatrix2DFloatFloatBooleanBoolean() {
        int n;
        float[] fArray;
        int n2;
        int n3;
        float[] fArray2 = new float[]{3.0f, 2.0f};
        float[] fArray3 = new float[]{5.0f, 4.0f};
        float[] fArray4 = new float[2];
        FComplexMatrix2D fComplexMatrix2D = null;
        fComplexMatrix2D = this.A.zMult(this.Bt, fComplexMatrix2D, fArray2, fArray3, false, false);
        float[][] fArray5 = new float[this.NROWS][2 * this.NROWS];
        for (n3 = 0; n3 < this.NROWS; ++n3) {
            for (n2 = 0; n2 < this.NROWS; ++n2) {
                fArray = new float[2];
                for (n = 0; n < this.NCOLUMNS; ++n) {
                    fArray = FComplex.plus(fArray, FComplex.mult(this.A.getQuick(n2, n), this.Bt.getQuick(n, n3)));
                }
                fArray4[0] = fArray5[n2][2 * n3];
                fArray4[1] = fArray5[n2][2 * n3 + 1];
                fArray4 = FComplex.mult(fArray4, fArray3);
                fArray4 = FComplex.plus(fArray4, FComplex.mult(fArray, fArray2));
                fArray5[n2][2 * n3] = fArray4[0];
                fArray5[n2][2 * n3 + 1] = fArray4[1];
            }
        }
        for (n3 = 0; n3 < this.NROWS; ++n3) {
            for (n2 = 0; n2 < this.NROWS; ++n2) {
                FComplexMatrix2DTest.assertEquals((float)fArray5[n3][2 * n2], (float)fComplexMatrix2D.getQuick(n3, n2)[0], (float)this.TOL);
                FComplexMatrix2DTest.assertEquals((float)fArray5[n3][2 * n2 + 1], (float)fComplexMatrix2D.getQuick(n3, n2)[1], (float)this.TOL);
            }
        }
        fComplexMatrix2D = null;
        fComplexMatrix2D = this.A.zMult(this.B, fComplexMatrix2D, fArray2, fArray3, true, false);
        fArray5 = new float[this.NCOLUMNS][2 * this.NCOLUMNS];
        for (n3 = 0; n3 < this.NCOLUMNS; ++n3) {
            for (n2 = 0; n2 < this.NCOLUMNS; ++n2) {
                fArray = new float[2];
                for (n = 0; n < this.NROWS; ++n) {
                    fArray = FComplex.plus(fArray, FComplex.mult(FComplex.conj(this.A.getQuick(n, n2)), this.B.getQuick(n, n3)));
                }
                fArray4[0] = fArray5[n2][2 * n3];
                fArray4[1] = fArray5[n2][2 * n3 + 1];
                fArray4 = FComplex.mult(fArray4, fArray3);
                fArray4 = FComplex.plus(fArray4, FComplex.mult(fArray, fArray2));
                fArray5[n2][2 * n3] = fArray4[0];
                fArray5[n2][2 * n3 + 1] = fArray4[1];
            }
        }
        for (n3 = 0; n3 < this.NCOLUMNS; ++n3) {
            for (n2 = 0; n2 < this.NCOLUMNS; ++n2) {
                FComplexMatrix2DTest.assertEquals((float)fArray5[n3][2 * n2], (float)fComplexMatrix2D.getQuick(n3, n2)[0], (float)this.TOL);
                FComplexMatrix2DTest.assertEquals((float)fArray5[n3][2 * n2 + 1], (float)fComplexMatrix2D.getQuick(n3, n2)[1], (float)this.TOL);
            }
        }
        fComplexMatrix2D = null;
        fComplexMatrix2D = this.A.zMult(this.B, fComplexMatrix2D, fArray2, fArray3, false, true);
        fArray5 = new float[this.NROWS][2 * this.NROWS];
        for (n3 = 0; n3 < this.NROWS; ++n3) {
            for (n2 = 0; n2 < this.NROWS; ++n2) {
                fArray = new float[2];
                for (n = 0; n < this.NCOLUMNS; ++n) {
                    fArray = FComplex.plus(fArray, FComplex.mult(this.A.getQuick(n2, n), FComplex.conj(this.B.getQuick(n3, n))));
                }
                fArray4[0] = fArray5[n2][2 * n3];
                fArray4[1] = fArray5[n2][2 * n3 + 1];
                fArray4 = FComplex.mult(fArray4, fArray3);
                fArray4 = FComplex.plus(fArray4, FComplex.mult(fArray, fArray2));
                fArray5[n2][2 * n3] = fArray4[0];
                fArray5[n2][2 * n3 + 1] = fArray4[1];
            }
        }
        for (n3 = 0; n3 < this.NROWS; ++n3) {
            for (n2 = 0; n2 < this.NROWS; ++n2) {
                FComplexMatrix2DTest.assertEquals((float)fArray5[n3][2 * n2], (float)fComplexMatrix2D.getQuick(n3, n2)[0], (float)this.TOL);
                FComplexMatrix2DTest.assertEquals((float)fArray5[n3][2 * n2 + 1], (float)fComplexMatrix2D.getQuick(n3, n2)[1], (float)this.TOL);
            }
        }
        fComplexMatrix2D = null;
        fComplexMatrix2D = this.A.zMult(this.Bt, fComplexMatrix2D, fArray2, fArray3, true, true);
        fArray5 = new float[this.NCOLUMNS][2 * this.NCOLUMNS];
        for (n3 = 0; n3 < this.NCOLUMNS; ++n3) {
            for (n2 = 0; n2 < this.NCOLUMNS; ++n2) {
                fArray = new float[2];
                for (n = 0; n < this.NROWS; ++n) {
                    fArray = FComplex.plus(fArray, FComplex.mult(FComplex.conj(this.A.getQuick(n, n2)), FComplex.conj(this.Bt.getQuick(n3, n))));
                }
                fArray4[0] = fArray5[n2][2 * n3];
                fArray4[1] = fArray5[n2][2 * n3 + 1];
                fArray4 = FComplex.mult(fArray4, fArray3);
                fArray4 = FComplex.plus(fArray4, FComplex.mult(fArray, fArray2));
                fArray5[n2][2 * n3] = fArray4[0];
                fArray5[n2][2 * n3 + 1] = fArray4[1];
            }
        }
        for (n3 = 0; n3 < this.NCOLUMNS; ++n3) {
            for (n2 = 0; n2 < this.NCOLUMNS; ++n2) {
                FComplexMatrix2DTest.assertEquals((float)fArray5[n3][2 * n2], (float)fComplexMatrix2D.getQuick(n3, n2)[0], (float)this.TOL);
                FComplexMatrix2DTest.assertEquals((float)fArray5[n3][2 * n2 + 1], (float)fComplexMatrix2D.getQuick(n3, n2)[1], (float)this.TOL);
            }
        }
    }

    public void testZSum() {
        float[] fArray = this.A.zSum();
        float[] fArray2 = new float[2];
        for (int i = 0; i < this.NROWS; ++i) {
            for (int j = 0; j < this.NCOLUMNS; ++j) {
                fArray2 = FComplex.plus(fArray2, this.A.getQuick(i, j));
            }
        }
        this.assertEquals(fArray2, fArray, this.TOL);
    }

    protected void assertEquals(float[] fArray, float[] fArray2, float f) {
        for (int i = 0; i < fArray2.length; ++i) {
            FComplexMatrix2DTest.assertEquals((float)fArray[i], (float)fArray2[i], (float)f);
        }
    }
}

