/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdouble.impl;

import cern.colt.map.tdouble.AbstractLongDoubleMap;
import cern.colt.matrix.tdouble.DoubleMatrix1D;
import cern.colt.matrix.tdouble.DoubleMatrix2D;
import cern.colt.matrix.tdouble.DoubleMatrix3D;
import cern.colt.matrix.tdouble.impl.SparseDoubleMatrix1D;
import cern.colt.matrix.tdouble.impl.SparseDoubleMatrix2D;
import cern.colt.matrix.tdouble.impl.SparseDoubleMatrix3D;

class SelectedSparseDoubleMatrix1D
extends DoubleMatrix1D {
    protected AbstractLongDoubleMap elements;
    protected int[] offsets;
    protected int offset;

    protected SelectedSparseDoubleMatrix1D(AbstractLongDoubleMap abstractLongDoubleMap, int[] nArray) {
        this(nArray.length, abstractLongDoubleMap, 0, 1, nArray, 0);
    }

    protected SelectedSparseDoubleMatrix1D(int n, AbstractLongDoubleMap abstractLongDoubleMap, int n2, int n3, int[] nArray, int n4) {
        this.setUp(n, n2, n3);
        this.elements = abstractLongDoubleMap;
        this.offsets = nArray;
        this.offset = n4;
        this.isNoView = false;
    }

    public AbstractLongDoubleMap elements() {
        return this.elements;
    }

    public double getQuick(int n) {
        return this.elements.get(this.offset + this.offsets[this.zero + n * this.stride]);
    }

    public long index(int n) {
        return this.offset + this.offsets[this.zero + n * this.stride];
    }

    public DoubleMatrix1D like(int n) {
        return new SparseDoubleMatrix1D(n);
    }

    public DoubleMatrix2D like2D(int n, int n2) {
        return new SparseDoubleMatrix2D(n, n2);
    }

    public DoubleMatrix2D reshape(int n, int n2) {
        if (n * n2 != this.size) {
            throw new IllegalArgumentException("rows*cols != size");
        }
        SparseDoubleMatrix2D sparseDoubleMatrix2D = new SparseDoubleMatrix2D(n, n2);
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                ((DoubleMatrix2D)sparseDoubleMatrix2D).setQuick(j, i, this.getQuick(n3++));
            }
        }
        return sparseDoubleMatrix2D;
    }

    public DoubleMatrix3D reshape(int n, int n2, int n3) {
        if (n * n2 * n3 != this.size) {
            throw new IllegalArgumentException("slices*rows*cols != size");
        }
        SparseDoubleMatrix3D sparseDoubleMatrix3D = new SparseDoubleMatrix3D(n, n2, n3);
        int n4 = 0;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n3; ++j) {
                for (int k = 0; k < n2; ++k) {
                    ((DoubleMatrix3D)sparseDoubleMatrix3D).setQuick(i, k, j, this.getQuick(n4++));
                }
            }
        }
        return sparseDoubleMatrix3D;
    }

    public void setQuick(int n, double d) {
        int n2 = this.offset + this.offsets[this.zero + n * this.stride];
        if (d == 0.0) {
            this.elements.removeKey(n2);
        } else {
            this.elements.put(n2, d);
        }
    }

    protected int _offset(int n) {
        return this.offsets[n];
    }

    protected boolean haveSharedCellsRaw(DoubleMatrix1D doubleMatrix1D) {
        if (doubleMatrix1D instanceof SelectedSparseDoubleMatrix1D) {
            SelectedSparseDoubleMatrix1D selectedSparseDoubleMatrix1D = (SelectedSparseDoubleMatrix1D)doubleMatrix1D;
            return this.elements == selectedSparseDoubleMatrix1D.elements;
        }
        if (doubleMatrix1D instanceof SparseDoubleMatrix1D) {
            SparseDoubleMatrix1D sparseDoubleMatrix1D = (SparseDoubleMatrix1D)doubleMatrix1D;
            return this.elements == sparseDoubleMatrix1D.elements;
        }
        return false;
    }

    protected void setUp(int n) {
        super.setUp(n);
        this.stride = 1;
        this.offset = 0;
    }

    protected DoubleMatrix1D viewSelectionLike(int[] nArray) {
        return new SelectedSparseDoubleMatrix1D(this.elements, nArray);
    }
}

