/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdouble.impl;

import cern.colt.function.tdouble.DoubleDoubleFunction;
import cern.colt.function.tdouble.DoubleFunction;
import cern.colt.function.tdouble.IntIntDoubleFunction;
import cern.colt.list.tdouble.DoubleArrayList;
import cern.colt.list.tint.IntArrayList;
import cern.colt.matrix.tdouble.DoubleMatrix1D;
import cern.colt.matrix.tdouble.DoubleMatrix2D;
import cern.colt.matrix.tdouble.impl.DenseDoubleMatrix1D;
import cern.colt.matrix.tdouble.impl.DenseDoubleMatrix2D;
import cern.colt.matrix.tdouble.impl.SparseDoubleMatrix1D;
import cern.colt.matrix.tdouble.impl.WrapperDoubleMatrix2D;
import cern.jet.math.tdouble.DoubleFunctions;
import cern.jet.math.tdouble.DoubleMult;
import cern.jet.math.tdouble.DoublePlusMultFirst;
import cern.jet.math.tdouble.DoublePlusMultSecond;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.util.concurrent.Future;

public class RCDoubleMatrix2D
extends WrapperDoubleMatrix2D {
    protected IntArrayList columnIndexes;
    protected DoubleArrayList values;
    protected int[] rowPointers;

    public RCDoubleMatrix2D(double[][] dArray) {
        this(dArray.length, dArray.length == 0 ? 0 : dArray[0].length);
        this.assign(dArray);
    }

    public RCDoubleMatrix2D(int n, int n2, int[] nArray, IntArrayList intArrayList, DoubleArrayList doubleArrayList) {
        block2: {
            super(null);
            try {
                this.setUp(n, n2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if ("matrix too large".equals(illegalArgumentException.getMessage())) break block2;
                throw illegalArgumentException;
            }
        }
        this.rowPointers = nArray;
        this.columnIndexes = intArrayList;
        this.values = doubleArrayList;
    }

    public RCDoubleMatrix2D(int n, int n2) {
        block2: {
            super(null);
            try {
                this.setUp(n, n2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if ("matrix too large".equals(illegalArgumentException.getMessage())) break block2;
                throw illegalArgumentException;
            }
        }
        this.columnIndexes = new IntArrayList();
        this.values = new DoubleArrayList();
        this.rowPointers = new int[n + 1];
    }

    public RCDoubleMatrix2D(int n, int n2, int n3) {
        block2: {
            super(null);
            try {
                this.setUp(n, n2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if ("matrix too large".equals(illegalArgumentException.getMessage())) break block2;
                throw illegalArgumentException;
            }
        }
        this.columnIndexes = new IntArrayList(n3);
        this.values = new DoubleArrayList(n3);
        this.rowPointers = new int[n + 1];
    }

    public RCDoubleMatrix2D(int n, int n2, IntArrayList intArrayList, IntArrayList intArrayList2, double d) {
        int n3;
        block4: {
            super(null);
            try {
                this.setUp(n, n2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if ("matrix too large".equals(illegalArgumentException.getMessage())) break block4;
                throw illegalArgumentException;
            }
        }
        int n4 = intArrayList.size();
        int[] nArray = intArrayList.elements();
        int[] nArray2 = intArrayList2.elements();
        int[] nArray3 = new int[n4];
        double[] dArray = new double[n4];
        int[] nArray4 = new int[n + 1];
        int[] nArray5 = new int[n];
        for (n3 = 0; n3 < n4; ++n3) {
            int n5 = nArray[n3];
            nArray5[n5] = nArray5[n5] + 1;
        }
        this.cumsum(nArray4, nArray5, n);
        for (n3 = 0; n3 < n4; ++n3) {
            int n6 = nArray[n3];
            nArray5[n6] = nArray5[n6] + 1;
            nArray3[var14_15] = nArray2[n3];
            dArray[var14_15] = d;
        }
        this.rowPointers = nArray4;
        this.columnIndexes = new IntArrayList(nArray3);
        this.values = new DoubleArrayList(dArray);
    }

    public RCDoubleMatrix2D(int n, int n2, IntArrayList intArrayList, IntArrayList intArrayList2, DoubleArrayList doubleArrayList) {
        int n3;
        block4: {
            super(null);
            try {
                this.setUp(n, n2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if ("matrix too large".equals(illegalArgumentException.getMessage())) break block4;
                throw illegalArgumentException;
            }
        }
        int n4 = intArrayList.size();
        int[] nArray = intArrayList.elements();
        int[] nArray2 = intArrayList2.elements();
        double[] dArray = doubleArrayList.elements();
        int[] nArray3 = new int[n4];
        double[] dArray2 = new double[n4];
        int[] nArray4 = new int[n + 1];
        int[] nArray5 = new int[n];
        for (n3 = 0; n3 < n4; ++n3) {
            int n5 = nArray[n3];
            nArray5[n5] = nArray5[n5] + 1;
        }
        this.cumsum(nArray4, nArray5, n);
        for (n3 = 0; n3 < n4; ++n3) {
            int n6 = nArray[n3];
            nArray5[n6] = nArray5[n6] + 1;
            nArray3[var14_16] = nArray2[n3];
            dArray2[var14_16] = dArray[n3];
        }
        this.rowPointers = nArray4;
        this.columnIndexes = new IntArrayList(nArray3);
        this.values = new DoubleArrayList(dArray2);
    }

    private double cumsum(int[] nArray, int[] nArray2, int n) {
        int n2 = 0;
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            nArray[i] = n2;
            n2 += nArray2[i];
            d += (double)nArray2[i];
            nArray2[i] = nArray[i];
        }
        nArray[n] = n2;
        return d;
    }

    public DoubleMatrix2D assign(double d) {
        if (d == 0.0) {
            this.columnIndexes.clear();
            this.values.clear();
            this.rowPointers = new int[this.rows + 1];
        } else {
            int n = this.cardinality();
            for (int i = 0; i < n; ++i) {
                this.values.setQuick(i, d);
            }
        }
        return this;
    }

    public DoubleMatrix2D assign(final DoubleFunction doubleFunction) {
        if (doubleFunction instanceof DoubleMult) {
            final double d = ((DoubleMult)doubleFunction).multiplicator;
            if (d == 1.0) {
                return this;
            }
            if (d == 0.0) {
                return this.assign(0.0);
            }
            if (d != d) {
                return this.assign(d);
            }
            final double[] dArray = this.values.elements();
            int n = ConcurrencyUtils.getNumberOfThreads();
            if (n > 1 && this.cardinality() >= ConcurrencyUtils.getThreadsBeginN_2D()) {
                Future[] futureArray = new Future[n];
                int n2 = dArray.length / n;
                for (int i = 0; i < n; ++i) {
                    final int n3 = i * n2;
                    final int n4 = i == n - 1 ? dArray.length : n3 + n2;
                    futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                        public void run() {
                            int n = n3;
                            while (n < n4) {
                                int n2 = n++;
                                dArray[n2] = dArray[n2] * d;
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futureArray);
            } else {
                int n5 = this.values.size();
                while (--n5 >= 0) {
                    int n6 = n5;
                    dArray[n6] = dArray[n6] * d;
                }
            }
        } else {
            this.forEachNonZero(new IntIntDoubleFunction(){

                public double apply(int n, int n2, double d) {
                    return doubleFunction.apply(d);
                }
            });
        }
        return this;
    }

    public DoubleMatrix2D assign(DoubleMatrix2D doubleMatrix2D) {
        if (doubleMatrix2D == this) {
            return this;
        }
        this.checkShape(doubleMatrix2D);
        if (!(doubleMatrix2D instanceof RCDoubleMatrix2D)) {
            this.assign(0.0);
            doubleMatrix2D.forEachNonZero(new IntIntDoubleFunction(){

                public double apply(int n, int n2, double d) {
                    RCDoubleMatrix2D.this.setQuick(n, n2, d);
                    return d;
                }
            });
            return this;
        }
        RCDoubleMatrix2D rCDoubleMatrix2D = (RCDoubleMatrix2D)doubleMatrix2D;
        System.arraycopy(rCDoubleMatrix2D.rowPointers, 0, this.rowPointers, 0, this.rowPointers.length);
        int n = rCDoubleMatrix2D.columnIndexes.size();
        this.columnIndexes.setSize(n);
        this.values.setSize(n);
        this.columnIndexes.replaceFromToWithFrom(0, n - 1, rCDoubleMatrix2D.columnIndexes, 0);
        this.values.replaceFromToWithFrom(0, n - 1, rCDoubleMatrix2D.values, 0);
        return this;
    }

    public DoubleMatrix2D assign(DoubleMatrix2D doubleMatrix2D, DoubleDoubleFunction doubleDoubleFunction) {
        Object[] objectArray;
        Object object;
        this.checkShape(doubleMatrix2D);
        if (doubleMatrix2D instanceof RCDoubleMatrix2D && doubleDoubleFunction == DoubleFunctions.plus) {
            object = (RCDoubleMatrix2D)doubleMatrix2D;
            objectArray = this.rowPointers;
            int[] nArray = this.columnIndexes.elements();
            double[] dArray = this.values.elements();
            int[] nArray2 = ((RCDoubleMatrix2D)object).rowPointers;
            int[] nArray3 = ((RCDoubleMatrix2D)object).columnIndexes.elements();
            double[] dArray2 = ((RCDoubleMatrix2D)object).values.elements();
            int[] nArray4 = new int[objectArray.length];
            int[] nArray5 = new int[nArray.length];
            double[] dArray3 = new double[dArray.length];
            int n = this.rows;
            int n2 = this.columns;
            int n3 = dArray.length;
            int n4 = this.cardinality();
            if (doubleDoubleFunction == DoubleFunctions.plus) {
                int n5;
                nArray4[0] = n5 = 0;
                for (int i = 0; i < n; ++i) {
                    int n6 = objectArray[i];
                    int n7 = nArray2[i];
                    int n8 = objectArray[i + 1] - 1;
                    int n9 = nArray2[i + 1] - 1;
                    while (n6 <= n8 || n7 <= n9) {
                        int n10;
                        int n11 = n6 <= n8 ? nArray[n6] : n2 + 1;
                        if (n11 == (n10 = n7 <= n9 ? nArray3[n7] : n2 + 1)) {
                            dArray3[n5] = dArray[n6] + dArray2[n7];
                            nArray5[n5] = n11;
                            ++n6;
                            ++n7;
                            ++n5;
                        } else if (n11 < n10) {
                            nArray5[n5] = n11;
                            dArray3[n5] = dArray[n6];
                            ++n6;
                            ++n5;
                        } else if (n11 > n10) {
                            nArray5[n5] = n10;
                            dArray3[n5] = dArray2[n7];
                            ++n7;
                            ++n5;
                            ++n4;
                        }
                        if (n5 < n3) continue;
                        throw new IllegalArgumentException("The number of elements in C exceeds nzmax");
                    }
                    nArray4[i + 1] = n5;
                }
                this.rowPointers = nArray4;
                this.columnIndexes = new IntArrayList(nArray5);
                this.columnIndexes.setSizeRaw(n4);
                this.values = new DoubleArrayList(dArray3);
                this.values.setSizeRaw(n4);
                return this;
            }
        }
        if (doubleDoubleFunction instanceof DoublePlusMultSecond) {
            final double d = ((DoublePlusMultSecond)doubleDoubleFunction).multiplicator;
            if (d == 0.0) {
                return this;
            }
            doubleMatrix2D.forEachNonZero(new IntIntDoubleFunction(){

                public double apply(int n, int n2, double d2) {
                    RCDoubleMatrix2D.this.setQuick(n, n2, RCDoubleMatrix2D.this.getQuick(n, n2) + d * d2);
                    return d2;
                }
            });
            return this;
        }
        if (doubleDoubleFunction instanceof DoublePlusMultFirst) {
            final double d = ((DoublePlusMultFirst)doubleDoubleFunction).multiplicator;
            if (d == 0.0) {
                return this.assign(doubleMatrix2D);
            }
            doubleMatrix2D.forEachNonZero(new IntIntDoubleFunction(){

                public double apply(int n, int n2, double d2) {
                    RCDoubleMatrix2D.this.setQuick(n, n2, d * RCDoubleMatrix2D.this.getQuick(n, n2) + d2);
                    return d2;
                }
            });
            return this;
        }
        if (doubleDoubleFunction == DoubleFunctions.mult) {
            object = this.columnIndexes.elements();
            objectArray = this.values.elements();
            int n = this.rowPointers.length - 1;
            while (--n >= 0) {
                int n12 = this.rowPointers[n];
                int n13 = this.rowPointers[n + 1];
                while (--n13 >= n12) {
                    Object object2 = object[n13];
                    int n14 = n13;
                    objectArray[n14] = objectArray[n14] * doubleMatrix2D.getQuick(n, (int)object2);
                    if (objectArray[n13] != 0.0) continue;
                    this.remove(n, (int)object2);
                }
            }
            return this;
        }
        if (doubleDoubleFunction == DoubleFunctions.div) {
            object = this.columnIndexes.elements();
            objectArray = this.values.elements();
            int n = this.rowPointers.length - 1;
            while (--n >= 0) {
                int n15 = this.rowPointers[n];
                int n16 = this.rowPointers[n + 1];
                while (--n16 >= n15) {
                    Object object3 = object[n16];
                    int n17 = n16;
                    objectArray[n17] = objectArray[n17] / doubleMatrix2D.getQuick(n, (int)object3);
                    if (objectArray[n16] != 0.0) continue;
                    this.remove(n, (int)object3);
                }
            }
            return this;
        }
        return super.assign(doubleMatrix2D, doubleDoubleFunction);
    }

    public DoubleMatrix2D forEachNonZero(final IntIntDoubleFunction intIntDoubleFunction) {
        final int[] nArray = this.columnIndexes.elements();
        final double[] dArray = this.values.elements();
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.cardinality() >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            Future[] futureArray = new Future[n];
            int n2 = (this.rowPointers.length - 1) / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.rowPointers.length - 1 : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            int n = RCDoubleMatrix2D.this.rowPointers[i + 1];
                            for (int j = RCDoubleMatrix2D.this.rowPointers[i]; j < n; ++j) {
                                int n2 = nArray[j];
                                double d = dArray[j];
                                double d2 = intIntDoubleFunction.apply(i, n2, d);
                                if (d2 == d) continue;
                                dArray[j] = d2;
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n5 = this.rowPointers.length - 1;
            while (--n5 >= 0) {
                int n6 = this.rowPointers[n5];
                int n7 = this.rowPointers[n5 + 1];
                while (--n7 >= n6) {
                    int n8 = nArray[n7];
                    double d = dArray[n7];
                    double d2 = intIntDoubleFunction.apply(n5, n8, d);
                    if (d2 == d) continue;
                    dArray[n7] = d2;
                }
            }
        }
        return this;
    }

    protected DoubleMatrix2D getContent() {
        return this;
    }

    public IntArrayList getColumnindexes() {
        return this.columnIndexes;
    }

    public int[] getRowPointers() {
        return this.rowPointers;
    }

    public DoubleArrayList getValues() {
        return this.values;
    }

    public double getQuick(int n, int n2) {
        int n3 = this.columnIndexes.binarySearchFromTo(n2, this.rowPointers[n], this.rowPointers[n + 1] - 1);
        double d = 0.0;
        if (n3 >= 0) {
            d = this.values.getQuick(n3);
        }
        return d;
    }

    protected synchronized void insert(int n, int n2, int n3, double d) {
        this.columnIndexes.beforeInsert(n3, n2);
        this.values.beforeInsert(n3, d);
        int n4 = this.rowPointers.length;
        while (--n4 > n) {
            int n5 = n4;
            this.rowPointers[n5] = this.rowPointers[n5] + 1;
        }
    }

    public DoubleMatrix2D like(int n, int n2) {
        return new RCDoubleMatrix2D(n, n2);
    }

    public DoubleMatrix1D like1D(int n) {
        return new SparseDoubleMatrix1D(n);
    }

    protected void remove(int n, int n2) {
        this.columnIndexes.remove(n2);
        this.values.remove(n2);
        int n3 = this.rowPointers.length;
        while (--n3 > n) {
            int n4 = n3;
            this.rowPointers[n4] = this.rowPointers[n4] - 1;
        }
    }

    public int cardinality() {
        return this.columnIndexes.size();
    }

    public synchronized void setQuick(int n, int n2, double d) {
        int n3 = this.columnIndexes.binarySearchFromTo(n2, this.rowPointers[n], this.rowPointers[n + 1] - 1);
        if (n3 >= 0) {
            if (d == 0.0) {
                this.remove(n, n3);
            } else {
                this.values.setQuick(n3, d);
            }
            return;
        }
        if (d != 0.0) {
            n3 = -n3 - 1;
            this.insert(n, n2, n3, d);
        }
    }

    public double[][] toArray() {
        double[][] dArray = new double[this.rows][this.columns];
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.columns; ++j) {
                dArray[i][j] = this.getQuick(i, j);
            }
        }
        return dArray;
    }

    public void trimToSize() {
        this.columnIndexes.trimToSize();
        this.values.trimToSize();
    }

    public DoubleMatrix1D zMult(DoubleMatrix1D doubleMatrix1D, DoubleMatrix1D doubleMatrix1D2, final double d, final double d2, boolean bl) {
        boolean bl2;
        int n = this.rows;
        int n2 = this.columns;
        if (bl) {
            n = this.columns;
            n2 = this.rows;
        }
        boolean bl3 = bl2 = doubleMatrix1D2 == null || !bl;
        if (doubleMatrix1D2 == null) {
            doubleMatrix1D2 = new DenseDoubleMatrix1D(n);
        }
        if (!(doubleMatrix1D instanceof DenseDoubleMatrix1D) || !(doubleMatrix1D2 instanceof DenseDoubleMatrix1D)) {
            return super.zMult(doubleMatrix1D, doubleMatrix1D2, d, d2, bl);
        }
        if (n2 != doubleMatrix1D.size() || n > doubleMatrix1D2.size()) {
            throw new IllegalArgumentException("Incompatible args: " + (bl ? this.viewDice() : this).toStringShort() + ", " + doubleMatrix1D.toStringShort() + ", " + doubleMatrix1D2.toStringShort());
        }
        DenseDoubleMatrix1D denseDoubleMatrix1D = (DenseDoubleMatrix1D)doubleMatrix1D2;
        final double[] dArray = denseDoubleMatrix1D.elements;
        final int n3 = denseDoubleMatrix1D.stride();
        final int n4 = (int)doubleMatrix1D2.index(0);
        DenseDoubleMatrix1D denseDoubleMatrix1D2 = (DenseDoubleMatrix1D)doubleMatrix1D;
        final double[] dArray2 = denseDoubleMatrix1D2.elements;
        final int n5 = denseDoubleMatrix1D2.stride();
        final int n6 = (int)doubleMatrix1D.index(0);
        final int[] nArray = this.columnIndexes.elements();
        final double[] dArray3 = this.values.elements();
        if (bl) {
            if (!bl2 && d2 != 1.0) {
                doubleMatrix1D2.assign(DoubleFunctions.mult(d2));
            }
            for (int i = 0; i < this.rows; ++i) {
                int n7 = this.rowPointers[i + 1];
                double d3 = d * dArray2[n6 + n5 * i];
                for (int j = this.rowPointers[i]; j < n7; ++j) {
                    int n8 = nArray[j];
                    int n9 = n4 + n3 * n8;
                    dArray[n9] = dArray[n9] + dArray3[j] * d3;
                }
            }
            return doubleMatrix1D2;
        }
        int n10 = ConcurrencyUtils.getNumberOfThreads();
        if (n10 > 1 && this.cardinality() >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            Future[] futureArray = new Future[n10];
            int n11 = this.rows / n10;
            for (int i = 0; i < n10; ++i) {
                final int n12 = i * n11;
                final int n13 = i == n10 - 1 ? this.rows : n12 + n11;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n = n4 + n12 * n3;
                        int n2 = RCDoubleMatrix2D.this.rowPointers[n12];
                        if (d2 == 0.0) {
                            for (int i = n12; i < n13; ++i) {
                                double d3 = 0.0;
                                int n32 = RCDoubleMatrix2D.this.rowPointers[i + 1];
                                while (n2 + 10 < n32) {
                                    int n42 = n2 + 9;
                                    d3 += dArray3[n42] * dArray2[n6 + n5 * nArray[n42--]] + dArray3[n42] * dArray2[n6 + n5 * nArray[n42--]] + dArray3[n42] * dArray2[n6 + n5 * nArray[n42--]] + dArray3[n42] * dArray2[n6 + n5 * nArray[n42--]] + dArray3[n42] * dArray2[n6 + n5 * nArray[n42--]] + dArray3[n42] * dArray2[n6 + n5 * nArray[n42--]] + dArray3[n42] * dArray2[n6 + n5 * nArray[n42--]] + dArray3[n42] * dArray2[n6 + n5 * nArray[n42--]] + dArray3[n42] * dArray2[n6 + n5 * nArray[n42--]] + dArray3[n42] * dArray2[n6 + n5 * nArray[n42--]];
                                    n2 += 10;
                                }
                                while (n2 < n32) {
                                    d3 += dArray3[n2] * dArray2[nArray[n2]];
                                    ++n2;
                                }
                                dArray[n] = d * d3;
                                n += n3;
                            }
                        } else {
                            for (int i = n12; i < n13; ++i) {
                                double d4 = 0.0;
                                int n52 = RCDoubleMatrix2D.this.rowPointers[i + 1];
                                while (n2 + 10 < n52) {
                                    int n62 = n2 + 9;
                                    d4 += dArray3[n62] * dArray2[n6 + n5 * nArray[n62--]] + dArray3[n62] * dArray2[n6 + n5 * nArray[n62--]] + dArray3[n62] * dArray2[n6 + n5 * nArray[n62--]] + dArray3[n62] * dArray2[n6 + n5 * nArray[n62--]] + dArray3[n62] * dArray2[n6 + n5 * nArray[n62--]] + dArray3[n62] * dArray2[n6 + n5 * nArray[n62--]] + dArray3[n62] * dArray2[n6 + n5 * nArray[n62--]] + dArray3[n62] * dArray2[n6 + n5 * nArray[n62--]] + dArray3[n62] * dArray2[n6 + n5 * nArray[n62--]] + dArray3[n62] * dArray2[n6 + n5 * nArray[n62--]];
                                    n2 += 10;
                                }
                                while (n2 < n52) {
                                    d4 += dArray3[n2] * dArray2[nArray[n2]];
                                    ++n2;
                                }
                                dArray[n] = d * d4 + d2 * dArray[n];
                                n += n3;
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n14 = n4;
            int n15 = this.rowPointers[0];
            if (d2 == 0.0) {
                for (int i = 0; i < this.rows; ++i) {
                    double d4 = 0.0;
                    int n16 = this.rowPointers[i + 1];
                    while (n15 + 10 < n16) {
                        int n17 = n15 + 9;
                        d4 += dArray3[n17] * dArray2[n6 + n5 * nArray[n17--]] + dArray3[n17] * dArray2[n6 + n5 * nArray[n17--]] + dArray3[n17] * dArray2[n6 + n5 * nArray[n17--]] + dArray3[n17] * dArray2[n6 + n5 * nArray[n17--]] + dArray3[n17] * dArray2[n6 + n5 * nArray[n17--]] + dArray3[n17] * dArray2[n6 + n5 * nArray[n17--]] + dArray3[n17] * dArray2[n6 + n5 * nArray[n17--]] + dArray3[n17] * dArray2[n6 + n5 * nArray[n17--]] + dArray3[n17] * dArray2[n6 + n5 * nArray[n17--]] + dArray3[n17] * dArray2[n6 + n5 * nArray[n17--]];
                        n15 += 10;
                    }
                    while (n15 < n16) {
                        d4 += dArray3[n15] * dArray2[nArray[n15]];
                        ++n15;
                    }
                    dArray[n14] = d * d4;
                    n14 += n3;
                }
            } else {
                for (int i = 0; i < this.rows; ++i) {
                    double d5 = 0.0;
                    int n18 = this.rowPointers[i + 1];
                    while (n15 + 10 < n18) {
                        int n19 = n15 + 9;
                        d5 += dArray3[n19] * dArray2[n6 + n5 * nArray[n19--]] + dArray3[n19] * dArray2[n6 + n5 * nArray[n19--]] + dArray3[n19] * dArray2[n6 + n5 * nArray[n19--]] + dArray3[n19] * dArray2[n6 + n5 * nArray[n19--]] + dArray3[n19] * dArray2[n6 + n5 * nArray[n19--]] + dArray3[n19] * dArray2[n6 + n5 * nArray[n19--]] + dArray3[n19] * dArray2[n6 + n5 * nArray[n19--]] + dArray3[n19] * dArray2[n6 + n5 * nArray[n19--]] + dArray3[n19] * dArray2[n6 + n5 * nArray[n19--]] + dArray3[n19] * dArray2[n6 + n5 * nArray[n19--]];
                        n15 += 10;
                    }
                    while (n15 < n18) {
                        d5 += dArray3[n15] * dArray2[nArray[n15]];
                        ++n15;
                    }
                    dArray[n14] = d * d5 + d2 * dArray[n14];
                    n14 += n3;
                }
            }
        }
        return doubleMatrix1D2;
    }

    public DoubleMatrix2D zMult(DoubleMatrix2D doubleMatrix2D, DoubleMatrix2D doubleMatrix2D2, double d, double d2, boolean bl, boolean bl2) {
        boolean bl3;
        if (bl2) {
            doubleMatrix2D = doubleMatrix2D.viewDice();
        }
        int n = this.rows;
        int n2 = this.columns;
        if (bl) {
            n = this.columns;
            n2 = this.rows;
        }
        int n3 = doubleMatrix2D.columns();
        boolean bl4 = bl3 = doubleMatrix2D2 == null;
        if (doubleMatrix2D2 == null) {
            doubleMatrix2D2 = new DenseDoubleMatrix2D(n, n3);
        }
        if (doubleMatrix2D.rows() != n2) {
            throw new IllegalArgumentException("Matrix2D inner dimensions must agree:" + this.toStringShort() + ", " + (bl2 ? doubleMatrix2D.viewDice() : doubleMatrix2D).toStringShort());
        }
        if (doubleMatrix2D2.rows() != n || doubleMatrix2D2.columns() != n3) {
            throw new IllegalArgumentException("Incompatible result matrix: " + this.toStringShort() + ", " + (bl2 ? doubleMatrix2D.viewDice() : doubleMatrix2D).toStringShort() + ", " + doubleMatrix2D2.toStringShort());
        }
        if (this == doubleMatrix2D2 || doubleMatrix2D == doubleMatrix2D2) {
            throw new IllegalArgumentException("Matrices must not be identical");
        }
        if (!bl3) {
            doubleMatrix2D2.assign(DoubleFunctions.mult(d2));
        }
        DoubleMatrix1D[] doubleMatrix1DArray = new DoubleMatrix1D[n2];
        int n4 = n2;
        while (--n4 >= 0) {
            doubleMatrix1DArray[n4] = doubleMatrix2D.viewRow(n4);
        }
        DoubleMatrix1D[] doubleMatrix1DArray2 = new DoubleMatrix1D[n];
        int n5 = n;
        while (--n5 >= 0) {
            doubleMatrix1DArray2[n5] = doubleMatrix2D2.viewRow(n5);
        }
        DoublePlusMultSecond doublePlusMultSecond = DoublePlusMultSecond.plusMult(0.0);
        int[] nArray = this.columnIndexes.elements();
        double[] dArray = this.values.elements();
        int n6 = this.rowPointers.length - 1;
        while (--n6 >= 0) {
            int n7 = this.rowPointers[n6];
            int n8 = this.rowPointers[n6 + 1];
            while (--n8 >= n7) {
                int n9 = nArray[n8];
                doublePlusMultSecond.multiplicator = dArray[n8] * d;
                if (!bl) {
                    doubleMatrix1DArray2[n6].assign(doubleMatrix1DArray[n9], doublePlusMultSecond);
                    continue;
                }
                doubleMatrix1DArray2[n9].assign(doubleMatrix1DArray[n6], doublePlusMultSecond);
            }
        }
        return doubleMatrix2D2;
    }
}

