/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdouble.impl;

import cern.colt.matrix.tdcomplex.DComplexMatrix3D;
import cern.colt.matrix.tdcomplex.impl.DenseDComplexMatrix3D;
import cern.colt.matrix.tdouble.DoubleMatrix3D;
import cern.colt.matrix.tdouble.DoubleMatrix3DTest;
import cern.colt.matrix.tdouble.impl.DenseDoubleMatrix3D;

public class DenseDoubleMatrix3DTest
extends DoubleMatrix3DTest {
    public DenseDoubleMatrix3DTest(String string) {
        super(string);
    }

    protected void createMatrices() throws Exception {
        this.A = new DenseDoubleMatrix3D(this.NSLICES, this.NROWS, this.NCOLUMNS);
        this.B = new DenseDoubleMatrix3D(this.NSLICES, this.NROWS, this.NCOLUMNS);
    }

    public void testDct3() {
        DoubleMatrix3D doubleMatrix3D = this.A.copy();
        ((DenseDoubleMatrix3D)this.A).dct3(true);
        ((DenseDoubleMatrix3D)this.A).idct3(true);
        for (int i = 0; i < this.NSLICES; ++i) {
            for (int j = 0; j < this.NROWS; ++j) {
                for (int k = 0; k < this.NCOLUMNS; ++k) {
                    DenseDoubleMatrix3DTest.assertEquals((double)0.0, (double)Math.abs(doubleMatrix3D.getQuick(i, j, k) - this.A.getQuick(i, j, k)), (double)this.TOL);
                }
            }
        }
    }

    public void testDst3() {
        DoubleMatrix3D doubleMatrix3D = this.A.copy();
        ((DenseDoubleMatrix3D)this.A).dst3(true);
        ((DenseDoubleMatrix3D)this.A).idst3(true);
        for (int i = 0; i < this.NSLICES; ++i) {
            for (int j = 0; j < this.NROWS; ++j) {
                for (int k = 0; k < this.NCOLUMNS; ++k) {
                    DenseDoubleMatrix3DTest.assertEquals((double)0.0, (double)Math.abs(doubleMatrix3D.getQuick(i, j, k) - this.A.getQuick(i, j, k)), (double)this.TOL);
                }
            }
        }
    }

    public void testDht3() {
        DoubleMatrix3D doubleMatrix3D = this.A.copy();
        ((DenseDoubleMatrix3D)this.A).dht3();
        ((DenseDoubleMatrix3D)this.A).idht3(true);
        for (int i = 0; i < this.NSLICES; ++i) {
            for (int j = 0; j < this.NROWS; ++j) {
                for (int k = 0; k < this.NCOLUMNS; ++k) {
                    DenseDoubleMatrix3DTest.assertEquals((double)0.0, (double)Math.abs(doubleMatrix3D.getQuick(i, j, k) - this.A.getQuick(i, j, k)), (double)this.TOL);
                }
            }
        }
    }

    public void testFft3() {
        int n = 16;
        int n2 = 32;
        int n3 = 64;
        DenseDoubleMatrix3D denseDoubleMatrix3D = new DenseDoubleMatrix3D(n, n2, n3);
        DoubleMatrix3D doubleMatrix3D = denseDoubleMatrix3D.copy();
        denseDoubleMatrix3D.fft3();
        denseDoubleMatrix3D.ifft3(true);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                for (int k = 0; k < n3; ++k) {
                    DenseDoubleMatrix3DTest.assertEquals((double)0.0, (double)Math.abs(doubleMatrix3D.getQuick(i, j, k) - ((DoubleMatrix3D)denseDoubleMatrix3D).getQuick(i, j, k)), (double)this.TOL);
                }
            }
        }
    }

    public void testDct2Slices() {
        DoubleMatrix3D doubleMatrix3D = this.A.copy();
        ((DenseDoubleMatrix3D)this.A).dct2Slices(true);
        ((DenseDoubleMatrix3D)this.A).idct2Slices(true);
        for (int i = 0; i < this.NSLICES; ++i) {
            for (int j = 0; j < this.NROWS; ++j) {
                for (int k = 0; k < this.NCOLUMNS; ++k) {
                    DenseDoubleMatrix3DTest.assertEquals((double)0.0, (double)Math.abs(doubleMatrix3D.getQuick(i, j, k) - this.A.getQuick(i, j, k)), (double)this.TOL);
                }
            }
        }
    }

    public void testDst2Slices() {
        DoubleMatrix3D doubleMatrix3D = this.A.copy();
        ((DenseDoubleMatrix3D)this.A).dst2Slices(true);
        ((DenseDoubleMatrix3D)this.A).idst2Slices(true);
        for (int i = 0; i < this.NSLICES; ++i) {
            for (int j = 0; j < this.NROWS; ++j) {
                for (int k = 0; k < this.NCOLUMNS; ++k) {
                    DenseDoubleMatrix3DTest.assertEquals((double)0.0, (double)Math.abs(doubleMatrix3D.getQuick(i, j, k) - this.A.getQuick(i, j, k)), (double)this.TOL);
                }
            }
        }
    }

    public void testDft2Slices() {
        DoubleMatrix3D doubleMatrix3D = this.A.copy();
        ((DenseDoubleMatrix3D)this.A).dht2Slices();
        ((DenseDoubleMatrix3D)this.A).idht2Slices(true);
        for (int i = 0; i < this.NSLICES; ++i) {
            for (int j = 0; j < this.NROWS; ++j) {
                for (int k = 0; k < this.NCOLUMNS; ++k) {
                    DenseDoubleMatrix3DTest.assertEquals((double)0.0, (double)Math.abs(doubleMatrix3D.getQuick(i, j, k) - this.A.getQuick(i, j, k)), (double)this.TOL);
                }
            }
        }
    }

    public void testGetFft3() {
        DenseDComplexMatrix3D denseDComplexMatrix3D = ((DenseDoubleMatrix3D)this.A).getFft3();
        denseDComplexMatrix3D.ifft3(true);
        for (int i = 0; i < this.NSLICES; ++i) {
            for (int j = 0; j < this.NROWS; ++j) {
                for (int k = 0; k < this.NCOLUMNS; ++k) {
                    double[] dArray = ((DComplexMatrix3D)denseDComplexMatrix3D).getQuick(i, j, k);
                    DenseDoubleMatrix3DTest.assertEquals((double)this.A.getQuick(i, j, k), (double)dArray[0], (double)this.TOL);
                    DenseDoubleMatrix3DTest.assertEquals((double)0.0, (double)dArray[1], (double)this.TOL);
                }
            }
        }
    }

    public void testGetIfft3() {
        DenseDComplexMatrix3D denseDComplexMatrix3D = ((DenseDoubleMatrix3D)this.A).getIfft3(true);
        denseDComplexMatrix3D.fft3();
        for (int i = 0; i < this.NSLICES; ++i) {
            for (int j = 0; j < this.NROWS; ++j) {
                for (int k = 0; k < this.NCOLUMNS; ++k) {
                    double[] dArray = ((DComplexMatrix3D)denseDComplexMatrix3D).getQuick(i, j, k);
                    DenseDoubleMatrix3DTest.assertEquals((double)this.A.getQuick(i, j, k), (double)dArray[0], (double)this.TOL);
                    DenseDoubleMatrix3DTest.assertEquals((double)0.0, (double)dArray[1], (double)this.TOL);
                }
            }
        }
    }

    public void testGetFft2Slices() {
        DenseDComplexMatrix3D denseDComplexMatrix3D = ((DenseDoubleMatrix3D)this.A).getFft2Slices();
        denseDComplexMatrix3D.ifft2Slices(true);
        for (int i = 0; i < this.NSLICES; ++i) {
            for (int j = 0; j < this.NROWS; ++j) {
                for (int k = 0; k < this.NCOLUMNS; ++k) {
                    double[] dArray = ((DComplexMatrix3D)denseDComplexMatrix3D).getQuick(i, j, k);
                    DenseDoubleMatrix3DTest.assertEquals((double)0.0, (double)Math.abs(this.A.getQuick(i, j, k) - dArray[0]), (double)this.TOL);
                    DenseDoubleMatrix3DTest.assertEquals((double)0.0, (double)dArray[1], (double)this.TOL);
                }
            }
        }
    }

    public void testGetIfft2Slices() {
        DenseDComplexMatrix3D denseDComplexMatrix3D = ((DenseDoubleMatrix3D)this.A).getIfft2Slices(true);
        denseDComplexMatrix3D.fft2Slices();
        for (int i = 0; i < this.NSLICES; ++i) {
            for (int j = 0; j < this.NROWS; ++j) {
                for (int k = 0; k < this.NCOLUMNS; ++k) {
                    double[] dArray = ((DComplexMatrix3D)denseDComplexMatrix3D).getQuick(i, j, k);
                    DenseDoubleMatrix3DTest.assertEquals((double)0.0, (double)Math.abs(this.A.getQuick(i, j, k) - dArray[0]), (double)this.TOL);
                    DenseDoubleMatrix3DTest.assertEquals((double)0.0, (double)dArray[1], (double)this.TOL);
                }
            }
        }
    }
}

