/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdouble.impl;

import cern.colt.function.tdouble.Double9Function;
import cern.colt.function.tdouble.DoubleDoubleFunction;
import cern.colt.function.tdouble.DoubleFunction;
import cern.colt.function.tdouble.DoubleProcedure;
import cern.colt.function.tdouble.IntIntDoubleFunction;
import cern.colt.list.tdouble.DoubleArrayList;
import cern.colt.list.tint.IntArrayList;
import cern.colt.matrix.io.MatrixInfo;
import cern.colt.matrix.io.MatrixSize;
import cern.colt.matrix.io.MatrixVectorReader;
import cern.colt.matrix.tdcomplex.impl.DenseDComplexMatrix2D;
import cern.colt.matrix.tdouble.DoubleMatrix1D;
import cern.colt.matrix.tdouble.DoubleMatrix2D;
import cern.colt.matrix.tdouble.impl.DenseDoubleMatrix1D;
import cern.colt.matrix.tdouble.impl.RCDoubleMatrix2D;
import cern.colt.matrix.tdouble.impl.SelectedDenseDoubleMatrix2D;
import cern.colt.matrix.tdouble.impl.SparseDoubleMatrix2D;
import cern.jet.math.tdouble.DoubleFunctions;
import cern.jet.math.tdouble.DoubleMult;
import cern.jet.math.tdouble.DoublePlusMultSecond;
import edu.emory.mathcs.jtransforms.dct.DoubleDCT_2D;
import edu.emory.mathcs.jtransforms.dht.DoubleDHT_2D;
import edu.emory.mathcs.jtransforms.dst.DoubleDST_2D;
import edu.emory.mathcs.jtransforms.fft.DoubleFFT_2D;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import jcuda.jcublas.JCublas;

public class DenseDoubleMatrix2D
extends DoubleMatrix2D {
    static final long serialVersionUID = 1020177651L;
    private DoubleFFT_2D fft2;
    private DoubleDCT_2D dct2;
    private DoubleDST_2D dst2;
    private DoubleDHT_2D dht2;
    protected double[] elements;

    public DenseDoubleMatrix2D(double[][] dArray) {
        this(dArray.length, dArray.length == 0 ? 0 : dArray[0].length);
        this.assign(dArray);
    }

    public DenseDoubleMatrix2D(int n, int n2) {
        this.setUp(n, n2);
        this.elements = new double[n * n2];
    }

    public DenseDoubleMatrix2D(int n, int n2, double[] dArray, int n3, int n4, int n5, int n6, boolean bl) {
        this.setUp(n, n2, n3, n4, n5, n6);
        this.elements = dArray;
        this.isNoView = !bl;
    }

    public DenseDoubleMatrix2D(MatrixVectorReader matrixVectorReader) throws IOException {
        block7: {
            int n;
            double[] dArray;
            int[] nArray;
            int[] nArray2;
            int n2;
            MatrixInfo matrixInfo;
            block6: {
                matrixInfo = matrixVectorReader.hasInfo() ? matrixVectorReader.readMatrixInfo() : new MatrixInfo(true, MatrixInfo.MatrixField.Real, MatrixInfo.MatrixSymmetry.General);
                if (matrixInfo.isPattern()) {
                    throw new UnsupportedOperationException("Pattern matrices are not supported");
                }
                if (matrixInfo.isDense()) {
                    throw new UnsupportedOperationException("Dense matrices are not supported");
                }
                if (matrixInfo.isComplex()) {
                    throw new UnsupportedOperationException("Complex matrices are not supported");
                }
                MatrixSize matrixSize = matrixVectorReader.readMatrixSize(matrixInfo);
                this.setUp(matrixSize.numRows(), matrixSize.numColumns());
                this.elements = new double[this.rows * this.columns];
                n2 = matrixSize.numEntries();
                nArray2 = new int[n2];
                nArray = new int[n2];
                dArray = new double[n2];
                matrixVectorReader.readCoordinate(nArray, nArray2, dArray);
                for (n = 0; n < n2; ++n) {
                    this.setQuick(nArray[n], nArray2[n], dArray[n]);
                }
                if (!matrixInfo.isSymmetric()) break block6;
                for (n = 0; n < n2; ++n) {
                    if (nArray[n] == nArray2[n]) continue;
                    this.setQuick(nArray2[n], nArray[n], dArray[n]);
                }
                break block7;
            }
            if (!matrixInfo.isSkewSymmetric()) break block7;
            for (n = 0; n < n2; ++n) {
                if (nArray[n] == nArray2[n]) continue;
                this.setQuick(nArray2[n], nArray[n], -dArray[n]);
            }
        }
    }

    public double aggregate(final DoubleDoubleFunction doubleDoubleFunction, final DoubleFunction doubleFunction) {
        if (this.size() == 0) {
            return Double.NaN;
        }
        final int n = (int)this.index(0, 0);
        double d = 0.0;
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            Future[] futureArray = new Future[n2];
            int n3 = this.rows / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = this.rows - i * n3;
                final int n5 = i == n2 - 1 ? 0 : n4 - n3;
                futureArray[i] = ConcurrencyUtils.submit(new Callable<Double>(){

                    @Override
                    public Double call() throws Exception {
                        double d = doubleFunction.apply(DenseDoubleMatrix2D.this.elements[n + (n4 - 1) * DenseDoubleMatrix2D.this.rowStride + (DenseDoubleMatrix2D.this.columns - 1) * DenseDoubleMatrix2D.this.columnStride]);
                        int n6 = 1;
                        int n2 = n4;
                        while (--n2 >= n5) {
                            int n3 = n + n2 * DenseDoubleMatrix2D.this.rowStride;
                            int n42 = DenseDoubleMatrix2D.this.columns - n6;
                            while (--n42 >= 0) {
                                d = doubleDoubleFunction.apply(d, doubleFunction.apply(DenseDoubleMatrix2D.this.elements[n3 + n42 * DenseDoubleMatrix2D.this.columnStride]));
                            }
                            n6 = 0;
                        }
                        return d;
                    }
                });
            }
            d = ConcurrencyUtils.waitForCompletion(futureArray, doubleDoubleFunction);
        } else {
            d = doubleFunction.apply(this.elements[n + (this.rows - 1) * this.rowStride + (this.columns - 1) * this.columnStride]);
            int n6 = 1;
            int n7 = this.rows;
            while (--n7 >= 0) {
                int n8 = n + n7 * this.rowStride;
                int n9 = this.columns - n6;
                while (--n9 >= 0) {
                    d = doubleDoubleFunction.apply(d, doubleFunction.apply(this.elements[n8 + n9 * this.columnStride]));
                }
                n6 = 0;
            }
        }
        return d;
    }

    public double aggregate(final DoubleDoubleFunction doubleDoubleFunction, final DoubleFunction doubleFunction, final DoubleProcedure doubleProcedure) {
        if (this.size() == 0) {
            return Double.NaN;
        }
        final int n = (int)this.index(0, 0);
        double d = 0.0;
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            Future[] futureArray = new Future[n2];
            Double[] doubleArray = new Double[n2];
            int n3 = this.rows / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? this.rows : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Callable<Double>(){

                    @Override
                    public Double call() throws Exception {
                        double d = DenseDoubleMatrix2D.this.elements[n + n4 * DenseDoubleMatrix2D.this.rowStride];
                        double d2 = 0.0;
                        if (doubleProcedure.apply(d)) {
                            d2 = doubleFunction.apply(d);
                        }
                        int n2 = 1;
                        for (int i = n4; i < n5; ++i) {
                            for (int j = n2; j < DenseDoubleMatrix2D.this.columns; ++j) {
                                d = DenseDoubleMatrix2D.this.elements[n + i * DenseDoubleMatrix2D.this.rowStride + j * DenseDoubleMatrix2D.this.columnStride];
                                if (!doubleProcedure.apply(d)) continue;
                                d2 = doubleDoubleFunction.apply(d2, doubleFunction.apply(d));
                            }
                            n2 = 0;
                        }
                        return d2;
                    }
                });
            }
            d = ConcurrencyUtils.waitForCompletion(futureArray, doubleDoubleFunction);
        } else {
            double d2 = this.elements[n];
            if (doubleProcedure.apply(d2)) {
                d = doubleFunction.apply(this.elements[n]);
            }
            int n6 = 1;
            for (int i = 0; i < this.rows; ++i) {
                for (int j = n6; j < this.columns; ++j) {
                    d2 = this.elements[n + i * this.rowStride + j * this.columnStride];
                    if (!doubleProcedure.apply(d2)) continue;
                    d = doubleDoubleFunction.apply(d, doubleFunction.apply(d2));
                }
                n6 = 0;
            }
        }
        return d;
    }

    public double aggregate(final DoubleDoubleFunction doubleDoubleFunction, final DoubleFunction doubleFunction, IntArrayList intArrayList, IntArrayList intArrayList2) {
        if (this.size() == 0) {
            return Double.NaN;
        }
        final int n = (int)this.index(0, 0);
        int n2 = intArrayList.size();
        final int[] nArray = intArrayList.elements();
        final int[] nArray2 = intArrayList2.elements();
        double d = 0.0;
        int n3 = ConcurrencyUtils.getNumberOfThreads();
        if (n3 > 1 && n2 >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            Future[] futureArray = new Future[n3];
            Double[] doubleArray = new Double[n3];
            int n4 = n2 / n3;
            for (int i = 0; i < n3; ++i) {
                final int n5 = i * n4;
                final int n6 = i == n3 - 1 ? n2 : n5 + n4;
                futureArray[i] = ConcurrencyUtils.submit(new Callable<Double>(){

                    @Override
                    public Double call() throws Exception {
                        double d = doubleFunction.apply(DenseDoubleMatrix2D.this.elements[n + nArray[n5] * DenseDoubleMatrix2D.this.rowStride + nArray2[n5] * DenseDoubleMatrix2D.this.columnStride]);
                        for (int i = n5 + 1; i < n6; ++i) {
                            double d2 = DenseDoubleMatrix2D.this.elements[n + nArray[i] * DenseDoubleMatrix2D.this.rowStride + nArray2[i] * DenseDoubleMatrix2D.this.columnStride];
                            d = doubleDoubleFunction.apply(d, doubleFunction.apply(d2));
                        }
                        return d;
                    }
                });
            }
            d = ConcurrencyUtils.waitForCompletion(futureArray, doubleDoubleFunction);
        } else {
            d = doubleFunction.apply(this.elements[n + nArray[0] * this.rowStride + nArray2[0] * this.columnStride]);
            for (int i = 1; i < n2; ++i) {
                double d2 = this.elements[n + nArray[i] * this.rowStride + nArray2[i] * this.columnStride];
                d = doubleDoubleFunction.apply(d, doubleFunction.apply(d2));
            }
        }
        return d;
    }

    public double aggregate(DoubleMatrix2D doubleMatrix2D, final DoubleDoubleFunction doubleDoubleFunction, final DoubleDoubleFunction doubleDoubleFunction2) {
        if (!(doubleMatrix2D instanceof DenseDoubleMatrix2D)) {
            return super.aggregate(doubleMatrix2D, doubleDoubleFunction, doubleDoubleFunction2);
        }
        this.checkShape(doubleMatrix2D);
        if (this.size() == 0) {
            return Double.NaN;
        }
        final int n = (int)this.index(0, 0);
        final int n2 = (int)doubleMatrix2D.index(0, 0);
        final int n3 = doubleMatrix2D.rowStride();
        final int n4 = doubleMatrix2D.columnStride();
        final double[] dArray = (double[])doubleMatrix2D.elements();
        double d = 0.0;
        int n5 = ConcurrencyUtils.getNumberOfThreads();
        if (n5 > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            Future[] futureArray = new Future[n5];
            Double[] doubleArray = new Double[n5];
            int n6 = this.rows / n5;
            for (int i = 0; i < n5; ++i) {
                final int n7 = i * n6;
                final int n8 = i == n5 - 1 ? this.rows : n7 + n6;
                futureArray[i] = ConcurrencyUtils.submit(new Callable<Double>(){

                    @Override
                    public Double call() throws Exception {
                        double d = doubleDoubleFunction2.apply(DenseDoubleMatrix2D.this.elements[n + n7 * DenseDoubleMatrix2D.this.rowStride], dArray[n2 + n7 * n3]);
                        int n5 = 1;
                        for (int i = n7; i < n8; ++i) {
                            for (int j = n5; j < DenseDoubleMatrix2D.this.columns; ++j) {
                                d = doubleDoubleFunction.apply(d, doubleDoubleFunction2.apply(DenseDoubleMatrix2D.this.elements[n + i * DenseDoubleMatrix2D.this.rowStride + j * DenseDoubleMatrix2D.this.columnStride], dArray[n2 + i * n3 + j * n4]));
                            }
                            n5 = 0;
                        }
                        return d;
                    }
                });
            }
            d = ConcurrencyUtils.waitForCompletion(futureArray, doubleDoubleFunction);
        } else {
            int n9 = 1;
            d = doubleDoubleFunction2.apply(this.elements[n], dArray[n2]);
            for (int i = 0; i < this.rows; ++i) {
                for (int j = n9; j < this.columns; ++j) {
                    d = doubleDoubleFunction.apply(d, doubleDoubleFunction2.apply(this.elements[n + i * this.rowStride + j * this.columnStride], dArray[n2 + i * n3 + j * n4]));
                }
                n9 = 0;
            }
        }
        return d;
    }

    public DoubleMatrix2D assign(final DoubleFunction doubleFunction) {
        final double[] dArray = this.elements;
        if (dArray == null) {
            throw new InternalError();
        }
        final int n = (int)this.index(0, 0);
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            if (doubleFunction instanceof DoubleMult) {
                double d = ((DoubleMult)doubleFunction).multiplicator;
                if (d == 1.0) {
                    return this;
                }
                if (d == 0.0) {
                    return this.assign(0.0);
                }
            }
            Future[] futureArray = new Future[n2];
            int n3 = this.rows / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? this.rows : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n6 = n + n4 * DenseDoubleMatrix2D.this.rowStride;
                        if (doubleFunction instanceof DoubleMult) {
                            double d = ((DoubleMult)doubleFunction).multiplicator;
                            if (d == 1.0) {
                                return;
                            }
                            for (int i = n4; i < n5; ++i) {
                                int n2 = n6;
                                for (int j = 0; j < DenseDoubleMatrix2D.this.columns; ++j) {
                                    int n3 = n2;
                                    dArray[n3] = dArray[n3] * d;
                                    n2 += DenseDoubleMatrix2D.this.columnStride;
                                }
                                n6 += DenseDoubleMatrix2D.this.rowStride;
                            }
                        } else {
                            for (int i = n4; i < n5; ++i) {
                                int n42 = n6;
                                for (int j = 0; j < DenseDoubleMatrix2D.this.columns; ++j) {
                                    dArray[n42] = doubleFunction.apply(dArray[n42]);
                                    n42 += DenseDoubleMatrix2D.this.columnStride;
                                }
                                n6 += DenseDoubleMatrix2D.this.rowStride;
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n6 = n + (this.rows - 1) * this.rowStride + (this.columns - 1) * this.columnStride;
            if (doubleFunction instanceof DoubleMult) {
                double d = ((DoubleMult)doubleFunction).multiplicator;
                if (d == 1.0) {
                    return this;
                }
                if (d == 0.0) {
                    return this.assign(0.0);
                }
                int n7 = this.rows;
                while (--n7 >= 0) {
                    int n8 = n6;
                    int n9 = this.columns;
                    while (--n9 >= 0) {
                        int n10 = n8;
                        dArray[n10] = dArray[n10] * d;
                        n8 -= this.columnStride;
                    }
                    n6 -= this.rowStride;
                }
            } else {
                int n11 = this.rows;
                while (--n11 >= 0) {
                    int n12 = n6;
                    int n13 = this.columns;
                    while (--n13 >= 0) {
                        dArray[n12] = doubleFunction.apply(dArray[n12]);
                        n12 -= this.columnStride;
                    }
                    n6 -= this.rowStride;
                }
            }
        }
        return this;
    }

    public DoubleMatrix2D assign(final DoubleProcedure doubleProcedure, final DoubleFunction doubleFunction) {
        final int n = (int)this.index(0, 0);
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            Future[] futureArray = new Future[n2];
            int n3 = this.rows / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? this.rows : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n3 = n + n4 * DenseDoubleMatrix2D.this.rowStride;
                        for (int i = n4; i < n5; ++i) {
                            int n2 = n3;
                            for (int j = 0; j < DenseDoubleMatrix2D.this.columns; ++j) {
                                double d = DenseDoubleMatrix2D.this.elements[n2];
                                if (doubleProcedure.apply(d)) {
                                    DenseDoubleMatrix2D.this.elements[n2] = doubleFunction.apply(d);
                                }
                                n2 += DenseDoubleMatrix2D.this.columnStride;
                            }
                            n3 += DenseDoubleMatrix2D.this.rowStride;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n6 = n;
            for (int i = 0; i < this.rows; ++i) {
                int n7 = n6;
                for (int j = 0; j < this.columns; ++j) {
                    double d = this.elements[n7];
                    if (doubleProcedure.apply(d)) {
                        this.elements[n7] = doubleFunction.apply(d);
                    }
                    n7 += this.columnStride;
                }
                n6 += this.rowStride;
            }
        }
        return this;
    }

    public DoubleMatrix2D assign(final DoubleProcedure doubleProcedure, final double d) {
        final int n = (int)this.index(0, 0);
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            Future[] futureArray = new Future[n2];
            int n3 = this.rows / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? this.rows : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n3 = n + n4 * DenseDoubleMatrix2D.this.rowStride;
                        for (int i = n4; i < n5; ++i) {
                            int n2 = n3;
                            for (int j = 0; j < DenseDoubleMatrix2D.this.columns; ++j) {
                                double d2 = DenseDoubleMatrix2D.this.elements[n2];
                                if (doubleProcedure.apply(d2)) {
                                    DenseDoubleMatrix2D.this.elements[n2] = d;
                                }
                                n2 += DenseDoubleMatrix2D.this.columnStride;
                            }
                            n3 += DenseDoubleMatrix2D.this.rowStride;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n6 = n;
            for (int i = 0; i < this.rows; ++i) {
                int n7 = n6;
                for (int j = 0; j < this.columns; ++j) {
                    double d2 = this.elements[n7];
                    if (doubleProcedure.apply(d2)) {
                        this.elements[n7] = d;
                    }
                    n7 += this.columnStride;
                }
                n6 += this.rowStride;
            }
        }
        return this;
    }

    public DoubleMatrix2D assign(final double d) {
        final double[] dArray = this.elements;
        final int n = (int)this.index(0, 0);
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            Future[] futureArray = new Future[n2];
            int n3 = this.rows / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? this.rows : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n3 = n + n4 * DenseDoubleMatrix2D.this.rowStride;
                        for (int i = n4; i < n5; ++i) {
                            int n2 = n3;
                            for (int j = 0; j < DenseDoubleMatrix2D.this.columns; ++j) {
                                dArray[n2] = d;
                                n2 += DenseDoubleMatrix2D.this.columnStride;
                            }
                            n3 += DenseDoubleMatrix2D.this.rowStride;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n6 = n;
            for (int i = 0; i < this.rows; ++i) {
                int n7 = n6;
                for (int j = 0; j < this.columns; ++j) {
                    dArray[n7] = d;
                    n7 += this.columnStride;
                }
                n6 += this.rowStride;
            }
        }
        return this;
    }

    public DoubleMatrix2D assign(final double[] dArray) {
        if (dArray.length != this.size()) {
            throw new IllegalArgumentException("Must have same length: length=" + dArray.length + " rows()*columns()=" + this.rows() * this.columns());
        }
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (this.isNoView) {
            if (n > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_2D()) {
                Future[] futureArray = new Future[n];
                int n2 = this.size() / n;
                for (int i = 0; i < n; ++i) {
                    final int n3 = i * n2;
                    final int n4 = i == n - 1 ? this.size() - n3 : n2;
                    futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                        public void run() {
                            System.arraycopy(dArray, n3, DenseDoubleMatrix2D.this.elements, n3, n4);
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futureArray);
            } else {
                System.arraycopy(dArray, 0, this.elements, 0, dArray.length);
            }
        } else {
            final int n5 = (int)this.index(0, 0);
            if (n > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_2D()) {
                Future[] futureArray = new Future[n];
                int n6 = this.rows / n;
                for (int i = 0; i < n; ++i) {
                    final int n7 = i * n6;
                    final int n8 = i * n6 * this.columns;
                    final int n9 = i == n - 1 ? this.rows : n7 + n6;
                    futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                        public void run() {
                            int n = n8;
                            int n2 = n5 + n7 * DenseDoubleMatrix2D.this.rowStride;
                            for (int i = n7; i < n9; ++i) {
                                int n3 = n2;
                                for (int j = 0; j < DenseDoubleMatrix2D.this.columns; ++j) {
                                    DenseDoubleMatrix2D.this.elements[n3] = dArray[n++];
                                    n3 += DenseDoubleMatrix2D.this.columnStride;
                                }
                                n2 += DenseDoubleMatrix2D.this.rowStride;
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futureArray);
            } else {
                int n10 = 0;
                int n11 = n5;
                for (int i = 0; i < this.rows; ++i) {
                    int n12 = n11;
                    for (int j = 0; j < this.columns; ++j) {
                        this.elements[n12] = dArray[n10++];
                        n12 += this.columnStride;
                    }
                    n11 += this.rowStride;
                }
            }
        }
        return this;
    }

    public DoubleMatrix2D assign(final double[][] dArray) {
        if (dArray.length != this.rows) {
            throw new IllegalArgumentException("Must have same number of rows: rows=" + dArray.length + "rows()=" + this.rows());
        }
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (this.isNoView) {
            if (n > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_2D()) {
                Future[] futureArray = new Future[n];
                int n2 = this.rows / n;
                for (int i = 0; i < n; ++i) {
                    final int n3 = i * n2;
                    final int n4 = i == n - 1 ? this.rows : n3 + n2;
                    futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                        public void run() {
                            int n = n3 * DenseDoubleMatrix2D.this.rowStride;
                            for (int i = n3; i < n4; ++i) {
                                double[] dArray2 = dArray[i];
                                if (dArray2.length != DenseDoubleMatrix2D.this.columns) {
                                    throw new IllegalArgumentException("Must have same number of columns in every row: columns=" + dArray2.length + "columns()=" + DenseDoubleMatrix2D.this.columns());
                                }
                                System.arraycopy(dArray2, 0, DenseDoubleMatrix2D.this.elements, n, DenseDoubleMatrix2D.this.columns);
                                n += DenseDoubleMatrix2D.this.columns;
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futureArray);
            } else {
                int n5 = 0;
                for (int i = 0; i < this.rows; ++i) {
                    double[] dArray2 = dArray[i];
                    if (dArray2.length != this.columns) {
                        throw new IllegalArgumentException("Must have same number of columns in every row: columns=" + dArray2.length + "columns()=" + this.columns());
                    }
                    System.arraycopy(dArray2, 0, this.elements, n5, this.columns);
                    n5 += this.columns;
                }
            }
        } else {
            final int n6 = (int)this.index(0, 0);
            if (n > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_2D()) {
                Future[] futureArray = new Future[n];
                int n7 = this.rows / n;
                for (int i = 0; i < n; ++i) {
                    final int n8 = i * n7;
                    final int n9 = i == n - 1 ? this.rows : n8 + n7;
                    futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                        public void run() {
                            int n = n6 + n8 * DenseDoubleMatrix2D.this.rowStride;
                            for (int i = n8; i < n9; ++i) {
                                double[] dArray2 = dArray[i];
                                if (dArray2.length != DenseDoubleMatrix2D.this.columns) {
                                    throw new IllegalArgumentException("Must have same number of columns in every row: columns=" + dArray2.length + "columns()=" + DenseDoubleMatrix2D.this.columns());
                                }
                                int n2 = n;
                                for (int j = 0; j < DenseDoubleMatrix2D.this.columns; ++j) {
                                    DenseDoubleMatrix2D.this.elements[n2] = dArray2[j];
                                    n2 += DenseDoubleMatrix2D.this.columnStride;
                                }
                                n += DenseDoubleMatrix2D.this.rowStride;
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futureArray);
            } else {
                int n10 = n6;
                for (int i = 0; i < this.rows; ++i) {
                    double[] dArray3 = dArray[i];
                    if (dArray3.length != this.columns) {
                        throw new IllegalArgumentException("Must have same number of columns in every row: columns=" + dArray3.length + "columns()=" + this.columns());
                    }
                    int n11 = n10;
                    for (int j = 0; j < this.columns; ++j) {
                        this.elements[n11] = dArray3[j];
                        n11 += this.columnStride;
                    }
                    n10 += this.rowStride;
                }
            }
            return this;
        }
        return this;
    }

    public DoubleMatrix2D assign(DoubleMatrix2D doubleMatrix2D) {
        Object object;
        if (!(doubleMatrix2D instanceof DenseDoubleMatrix2D)) {
            super.assign(doubleMatrix2D);
            return this;
        }
        final DenseDoubleMatrix2D denseDoubleMatrix2D = (DenseDoubleMatrix2D)doubleMatrix2D;
        if (denseDoubleMatrix2D == this) {
            return this;
        }
        this.checkShape(denseDoubleMatrix2D);
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (this.isNoView && denseDoubleMatrix2D.isNoView) {
            if (n > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_2D()) {
                Future[] futureArray = new Future[n];
                int n2 = this.size() / n;
                for (int i = 0; i < n; ++i) {
                    final int n3 = i * n2;
                    final int n4 = i == n - 1 ? this.size() - n3 : n2;
                    futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                        public void run() {
                            System.arraycopy(denseDoubleMatrix2D.elements, n3, DenseDoubleMatrix2D.this.elements, n3, n4);
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futureArray);
            } else {
                System.arraycopy(denseDoubleMatrix2D.elements, 0, this.elements, 0, this.elements.length);
            }
            return this;
        }
        DenseDoubleMatrix2D denseDoubleMatrix2D2 = (DenseDoubleMatrix2D)doubleMatrix2D;
        if (this.haveSharedCells(denseDoubleMatrix2D2)) {
            object = denseDoubleMatrix2D2.copy();
            if (!(object instanceof DenseDoubleMatrix2D)) {
                super.assign(denseDoubleMatrix2D2);
                return this;
            }
            denseDoubleMatrix2D2 = (DenseDoubleMatrix2D)object;
        }
        object = denseDoubleMatrix2D2.elements;
        if (this.elements == null || object == null) {
            throw new InternalError();
        }
        final int n5 = (int)denseDoubleMatrix2D2.index(0, 0);
        final int n6 = (int)this.index(0, 0);
        int n7 = denseDoubleMatrix2D2.columnStride;
        final int n8 = denseDoubleMatrix2D2.rowStride;
        if (n > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            Future[] futureArray = new Future[n];
            int n9 = this.rows / n;
            for (int i = 0; i < n; ++i) {
                final int n10 = i * n9;
                final int n11 = i == n - 1 ? this.rows : n10 + n9;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable((double[])object, n7){
                    final /* synthetic */ double[] val$elemsOther;
                    final /* synthetic */ int val$columnStrideOther;
                    {
                        this.val$elemsOther = dArray;
                        this.val$columnStrideOther = n62;
                    }

                    public void run() {
                        int n = n6 + n10 * DenseDoubleMatrix2D.this.rowStride;
                        int n2 = n5 + n10 * n8;
                        for (int i = n10; i < n11; ++i) {
                            int n3 = n;
                            int n4 = n2;
                            for (int j = 0; j < DenseDoubleMatrix2D.this.columns; ++j) {
                                DenseDoubleMatrix2D.this.elements[n3] = this.val$elemsOther[n4];
                                n3 += DenseDoubleMatrix2D.this.columnStride;
                                n4 += this.val$columnStrideOther;
                            }
                            n += DenseDoubleMatrix2D.this.rowStride;
                            n2 += n8;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n12 = n6;
            int n13 = n5;
            for (int i = 0; i < this.rows; ++i) {
                int n14 = n12;
                int n15 = n13;
                for (int j = 0; j < this.columns; ++j) {
                    this.elements[n14] = (double)object[n15];
                    n14 += this.columnStride;
                    n15 += n7;
                }
                n12 += this.rowStride;
                n13 += n8;
            }
        }
        return this;
    }

    public DoubleMatrix2D assign(DoubleMatrix2D doubleMatrix2D, final DoubleDoubleFunction doubleDoubleFunction) {
        if (!(doubleMatrix2D instanceof DenseDoubleMatrix2D)) {
            super.assign(doubleMatrix2D, doubleDoubleFunction);
            return this;
        }
        DenseDoubleMatrix2D denseDoubleMatrix2D = (DenseDoubleMatrix2D)doubleMatrix2D;
        this.checkShape(doubleMatrix2D);
        final double[] dArray = denseDoubleMatrix2D.elements;
        if (this.elements == null || dArray == null) {
            throw new InternalError();
        }
        final int n = (int)denseDoubleMatrix2D.index(0, 0);
        final int n2 = (int)this.index(0, 0);
        final int n3 = denseDoubleMatrix2D.columnStride;
        final int n4 = denseDoubleMatrix2D.rowStride;
        int n5 = ConcurrencyUtils.getNumberOfThreads();
        if (n5 > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            double d;
            if (doubleDoubleFunction instanceof DoublePlusMultSecond && (d = ((DoublePlusMultSecond)doubleDoubleFunction).multiplicator) == 0.0) {
                return this;
            }
            Future[] futureArray = new Future[n5];
            int n6 = this.rows / n5;
            for (int i = 0; i < n5; ++i) {
                final int n7 = i * n6;
                final int n8 = i == n5 - 1 ? this.rows : n7 + n6;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        if (doubleDoubleFunction == DoubleFunctions.mult) {
                            int n25 = n2 + n7 * DenseDoubleMatrix2D.this.rowStride;
                            int n26 = n + n7 * n4;
                            for (int i = n7; i < n8; ++i) {
                                int n32 = n25;
                                int n42 = n26;
                                for (int j = 0; j < DenseDoubleMatrix2D.this.columns; ++j) {
                                    int n5 = n32;
                                    DenseDoubleMatrix2D.this.elements[n5] = DenseDoubleMatrix2D.this.elements[n5] * dArray[n42];
                                    n32 += DenseDoubleMatrix2D.this.columnStride;
                                    n42 += n3;
                                }
                                n25 += DenseDoubleMatrix2D.this.rowStride;
                                n26 += n4;
                            }
                        } else if (doubleDoubleFunction == DoubleFunctions.div) {
                            int n27 = n2 + n7 * DenseDoubleMatrix2D.this.rowStride;
                            int n6 = n + n7 * n4;
                            for (int i = n7; i < n8; ++i) {
                                int n72 = n27;
                                int n82 = n6;
                                for (int j = 0; j < DenseDoubleMatrix2D.this.columns; ++j) {
                                    int n9 = n72;
                                    DenseDoubleMatrix2D.this.elements[n9] = DenseDoubleMatrix2D.this.elements[n9] / dArray[n82];
                                    n72 += DenseDoubleMatrix2D.this.columnStride;
                                    n82 += n3;
                                }
                                n27 += DenseDoubleMatrix2D.this.rowStride;
                                n6 += n4;
                            }
                        } else if (doubleDoubleFunction instanceof DoublePlusMultSecond) {
                            double d = ((DoublePlusMultSecond)doubleDoubleFunction).multiplicator;
                            if (d == 1.0) {
                                int n28 = n2 + n7 * DenseDoubleMatrix2D.this.rowStride;
                                int n10 = n + n7 * n4;
                                for (int i = n7; i < n8; ++i) {
                                    int n11 = n28;
                                    int n12 = n10;
                                    for (int j = 0; j < DenseDoubleMatrix2D.this.columns; ++j) {
                                        int n13 = n11;
                                        DenseDoubleMatrix2D.this.elements[n13] = DenseDoubleMatrix2D.this.elements[n13] + dArray[n12];
                                        n11 += DenseDoubleMatrix2D.this.columnStride;
                                        n12 += n3;
                                    }
                                    n28 += DenseDoubleMatrix2D.this.rowStride;
                                    n10 += n4;
                                }
                            } else if (d == -1.0) {
                                int n29 = n2 + n7 * DenseDoubleMatrix2D.this.rowStride;
                                int n14 = n + n7 * n4;
                                for (int i = n7; i < n8; ++i) {
                                    int n15 = n29;
                                    int n16 = n14;
                                    for (int j = 0; j < DenseDoubleMatrix2D.this.columns; ++j) {
                                        int n17 = n15;
                                        DenseDoubleMatrix2D.this.elements[n17] = DenseDoubleMatrix2D.this.elements[n17] - dArray[n16];
                                        n15 += DenseDoubleMatrix2D.this.columnStride;
                                        n16 += n3;
                                    }
                                    n29 += DenseDoubleMatrix2D.this.rowStride;
                                    n14 += n4;
                                }
                            } else {
                                int n30 = n2 + n7 * DenseDoubleMatrix2D.this.rowStride;
                                int n18 = n + n7 * n4;
                                for (int i = n7; i < n8; ++i) {
                                    int n19 = n30;
                                    int n20 = n18;
                                    for (int j = 0; j < DenseDoubleMatrix2D.this.columns; ++j) {
                                        int n21 = n19;
                                        DenseDoubleMatrix2D.this.elements[n21] = DenseDoubleMatrix2D.this.elements[n21] + d * dArray[n20];
                                        n19 += DenseDoubleMatrix2D.this.columnStride;
                                        n20 += n3;
                                    }
                                    n30 += DenseDoubleMatrix2D.this.rowStride;
                                    n18 += n4;
                                }
                            }
                        } else {
                            int n31 = n2 + n7 * DenseDoubleMatrix2D.this.rowStride;
                            int n22 = n + n7 * n4;
                            for (int i = n7; i < n8; ++i) {
                                int n23 = n31;
                                int n24 = n22;
                                for (int j = 0; j < DenseDoubleMatrix2D.this.columns; ++j) {
                                    DenseDoubleMatrix2D.this.elements[n23] = doubleDoubleFunction.apply(DenseDoubleMatrix2D.this.elements[n23], dArray[n24]);
                                    n23 += DenseDoubleMatrix2D.this.columnStride;
                                    n24 += n3;
                                }
                                n31 += DenseDoubleMatrix2D.this.rowStride;
                                n22 += n4;
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else if (doubleDoubleFunction == DoubleFunctions.mult) {
            int n9 = n2;
            int n10 = n;
            for (int i = 0; i < this.rows; ++i) {
                int n11 = n9;
                int n12 = n10;
                for (int j = 0; j < this.columns; ++j) {
                    int n13 = n11;
                    this.elements[n13] = this.elements[n13] * dArray[n12];
                    n11 += this.columnStride;
                    n12 += n3;
                }
                n9 += this.rowStride;
                n10 += n4;
            }
        } else if (doubleDoubleFunction == DoubleFunctions.div) {
            int n14 = n2;
            int n15 = n;
            for (int i = 0; i < this.rows; ++i) {
                int n16 = n14;
                int n17 = n15;
                for (int j = 0; j < this.columns; ++j) {
                    int n18 = n16;
                    this.elements[n18] = this.elements[n18] / dArray[n17];
                    n16 += this.columnStride;
                    n17 += n3;
                }
                n14 += this.rowStride;
                n15 += n4;
            }
        } else if (doubleDoubleFunction instanceof DoublePlusMultSecond) {
            double d = ((DoublePlusMultSecond)doubleDoubleFunction).multiplicator;
            if (d == 0.0) {
                return this;
            }
            if (d == 1.0) {
                int n19 = n2;
                int n20 = n;
                for (int i = 0; i < this.rows; ++i) {
                    int n21 = n19;
                    int n22 = n20;
                    for (int j = 0; j < this.columns; ++j) {
                        int n23 = n21;
                        this.elements[n23] = this.elements[n23] + dArray[n22];
                        n21 += this.columnStride;
                        n22 += n3;
                    }
                    n19 += this.rowStride;
                    n20 += n4;
                }
            } else if (d == -1.0) {
                int n24 = n2;
                int n25 = n;
                for (int i = 0; i < this.rows; ++i) {
                    int n26 = n24;
                    int n27 = n25;
                    for (int j = 0; j < this.columns; ++j) {
                        int n28 = n26;
                        this.elements[n28] = this.elements[n28] - dArray[n27];
                        n26 += this.columnStride;
                        n27 += n3;
                    }
                    n24 += this.rowStride;
                    n25 += n4;
                }
            } else {
                int n29 = n2;
                int n30 = n;
                for (int i = 0; i < this.rows; ++i) {
                    int n31 = n29;
                    int n32 = n30;
                    for (int j = 0; j < this.columns; ++j) {
                        int n33 = n31;
                        this.elements[n33] = this.elements[n33] + d * dArray[n32];
                        n31 += this.columnStride;
                        n32 += n3;
                    }
                    n29 += this.rowStride;
                    n30 += n4;
                }
            }
        } else {
            int n34 = n2;
            int n35 = n;
            for (int i = 0; i < this.rows; ++i) {
                int n36 = n34;
                int n37 = n35;
                for (int j = 0; j < this.columns; ++j) {
                    this.elements[n36] = doubleDoubleFunction.apply(this.elements[n36], dArray[n37]);
                    n36 += this.columnStride;
                    n37 += n3;
                }
                n34 += this.rowStride;
                n35 += n4;
            }
        }
        return this;
    }

    public DoubleMatrix2D assign(DoubleMatrix2D doubleMatrix2D, final DoubleDoubleFunction doubleDoubleFunction, IntArrayList intArrayList, IntArrayList intArrayList2) {
        this.checkShape(doubleMatrix2D);
        int n = intArrayList.size();
        final int[] nArray = intArrayList.elements();
        final int[] nArray2 = intArrayList2.elements();
        final double[] dArray = (double[])doubleMatrix2D.elements();
        final int n2 = (int)doubleMatrix2D.index(0, 0);
        final int n3 = (int)this.index(0, 0);
        final int n4 = doubleMatrix2D.columnStride();
        final int n5 = doubleMatrix2D.rowStride();
        int n6 = ConcurrencyUtils.getNumberOfThreads();
        if (n6 > 1 && n >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            Future[] futureArray = new Future[n6];
            int n7 = n / n6;
            for (int i = 0; i < n6; ++i) {
                final int n8 = i * n7;
                final int n9 = i == n6 - 1 ? n : n8 + n7;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n8; i < n9; ++i) {
                            int n = n3 + nArray[i] * DenseDoubleMatrix2D.this.rowStride + nArray2[i] * DenseDoubleMatrix2D.this.columnStride;
                            int n22 = n2 + nArray[i] * n5 + nArray2[i] * n4;
                            DenseDoubleMatrix2D.this.elements[n] = doubleDoubleFunction.apply(DenseDoubleMatrix2D.this.elements[n], dArray[n22]);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < n; ++i) {
                int n10 = n3 + nArray[i] * this.rowStride + nArray2[i] * this.columnStride;
                int n11 = n2 + nArray[i] * n5 + nArray2[i] * n4;
                this.elements[n10] = doubleDoubleFunction.apply(this.elements[n10], dArray[n11]);
            }
        }
        return this;
    }

    public DoubleMatrix2D assign(final float[] fArray) {
        if (fArray.length != this.size()) {
            throw new IllegalArgumentException("Must have same length: length=" + fArray.length + "rows()*columns()=" + this.rows() * this.columns());
        }
        final int n = (int)this.index(0, 0);
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            Future[] futureArray = new Future[n2];
            int n3 = this.rows / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i * n3 * this.columns;
                final int n6 = i == n2 - 1 ? this.rows : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n7 = n + n4 * DenseDoubleMatrix2D.this.rowStride;
                        int n2 = n5;
                        for (int i = n4; i < n6; ++i) {
                            int n3 = n7;
                            for (int j = 0; j < DenseDoubleMatrix2D.this.columns; ++j) {
                                DenseDoubleMatrix2D.this.elements[n3] = fArray[n2++];
                                n3 += DenseDoubleMatrix2D.this.columnStride;
                            }
                            n7 += DenseDoubleMatrix2D.this.rowStride;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n7 = 0;
            int n8 = n;
            for (int i = 0; i < this.rows; ++i) {
                int n9 = n8;
                for (int j = 0; j < this.columns; ++j) {
                    this.elements[n9] = fArray[n7++];
                    n9 += this.columnStride;
                }
                n8 += this.rowStride;
            }
        }
        return this;
    }

    public int cardinality() {
        int n = 0;
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        final int n3 = (int)this.index(0, 0);
        if (n2 > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            int n4;
            Future[] futureArray = new Future[n2];
            Integer[] integerArray = new Integer[n2];
            int n5 = this.rows / n2;
            for (n4 = 0; n4 < n2; ++n4) {
                final int n6 = n4 * n5;
                final int n7 = n4 == n2 - 1 ? this.rows : n6 + n5;
                futureArray[n4] = ConcurrencyUtils.submit(new Callable<Integer>(){

                    @Override
                    public Integer call() throws Exception {
                        int n = 0;
                        int n2 = n3 + n6 * DenseDoubleMatrix2D.this.rowStride;
                        for (int i = n6; i < n7; ++i) {
                            int n32 = n2;
                            for (int j = 0; j < DenseDoubleMatrix2D.this.columns; ++j) {
                                if (DenseDoubleMatrix2D.this.elements[n32] != 0.0) {
                                    ++n;
                                }
                                n32 += DenseDoubleMatrix2D.this.columnStride;
                            }
                            n2 += DenseDoubleMatrix2D.this.rowStride;
                        }
                        return n;
                    }
                });
            }
            try {
                for (n4 = 0; n4 < n2; ++n4) {
                    integerArray[n4] = (Integer)futureArray[n4].get();
                }
                n = integerArray[0];
                for (n4 = 1; n4 < n2; ++n4) {
                    n += integerArray[n4].intValue();
                }
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        } else {
            int n8 = n3;
            for (int i = 0; i < this.rows; ++i) {
                int n9 = n8;
                for (int j = 0; j < this.columns; ++j) {
                    if (this.elements[n9] != 0.0) {
                        ++n;
                    }
                    n9 += this.columnStride;
                }
                n8 += this.rowStride;
            }
        }
        return n;
    }

    public void dct2(boolean bl) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        if (this.dct2 == null) {
            this.dct2 = new DoubleDCT_2D(this.rows, this.columns);
        }
        if (this.isNoView) {
            this.dct2.forward(this.elements, bl);
        } else {
            DoubleMatrix2D doubleMatrix2D = this.copy();
            this.dct2.forward((double[])doubleMatrix2D.elements(), bl);
            this.assign((double[])doubleMatrix2D.elements());
        }
        ConcurrencyUtils.setNumberOfThreads(n);
    }

    public void dctColumns(final boolean bl) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            Future[] futureArray = new Future[n];
            int n2 = this.columns / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.columns : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            ((DenseDoubleMatrix1D)DenseDoubleMatrix2D.this.viewColumn(i)).dct(bl);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            for (int i = 0; i < this.columns; ++i) {
                ((DenseDoubleMatrix1D)this.viewColumn(i)).dct(bl);
            }
        }
    }

    public void dctRows(final boolean bl) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            Future[] futureArray = new Future[n2];
            int n3 = this.rows / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? this.rows : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n4; i < n5; ++i) {
                            ((DenseDoubleMatrix1D)DenseDoubleMatrix2D.this.viewRow(i)).dct(bl);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            for (int i = 0; i < this.rows; ++i) {
                ((DenseDoubleMatrix1D)this.viewRow(i)).dct(bl);
            }
        }
        ConcurrencyUtils.setNumberOfThreads(n);
    }

    public void dht2() {
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        if (this.dht2 == null) {
            this.dht2 = new DoubleDHT_2D(this.rows, this.columns);
        }
        if (this.isNoView) {
            this.dht2.forward(this.elements);
        } else {
            DoubleMatrix2D doubleMatrix2D = this.copy();
            this.dht2.forward((double[])doubleMatrix2D.elements());
            this.assign((double[])doubleMatrix2D.elements());
        }
        ConcurrencyUtils.setNumberOfThreads(n);
    }

    public void dhtColumns() {
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            Future[] futureArray = new Future[n2];
            int n3 = this.columns / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? this.columns : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n4; i < n5; ++i) {
                            ((DenseDoubleMatrix1D)DenseDoubleMatrix2D.this.viewColumn(i)).dht();
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            for (int i = 0; i < this.columns; ++i) {
                ((DenseDoubleMatrix1D)this.viewColumn(i)).dht();
            }
        }
        ConcurrencyUtils.setNumberOfThreads(n);
    }

    public void dhtRows() {
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            Future[] futureArray = new Future[n2];
            int n3 = this.rows / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? this.rows : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n4; i < n5; ++i) {
                            ((DenseDoubleMatrix1D)DenseDoubleMatrix2D.this.viewRow(i)).dht();
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            for (int i = 0; i < this.rows; ++i) {
                ((DenseDoubleMatrix1D)this.viewRow(i)).dht();
            }
        }
        ConcurrencyUtils.setNumberOfThreads(n);
    }

    public void dst2(boolean bl) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        if (this.dst2 == null) {
            this.dst2 = new DoubleDST_2D(this.rows, this.columns);
        }
        if (this.isNoView) {
            this.dst2.forward(this.elements, bl);
        } else {
            DoubleMatrix2D doubleMatrix2D = this.copy();
            this.dst2.forward((double[])doubleMatrix2D.elements(), bl);
            this.assign((double[])doubleMatrix2D.elements());
        }
        ConcurrencyUtils.setNumberOfThreads(n);
    }

    public void dstColumns(final boolean bl) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            Future[] futureArray = new Future[n2];
            int n3 = this.columns / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? this.columns : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n4; i < n5; ++i) {
                            ((DenseDoubleMatrix1D)DenseDoubleMatrix2D.this.viewColumn(i)).dst(bl);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            for (int i = 0; i < this.columns; ++i) {
                ((DenseDoubleMatrix1D)this.viewColumn(i)).dst(bl);
            }
        }
        ConcurrencyUtils.setNumberOfThreads(n);
    }

    public void dstRows(final boolean bl) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            Future[] futureArray = new Future[n2];
            int n3 = this.rows / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? this.rows : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n4; i < n5; ++i) {
                            ((DenseDoubleMatrix1D)DenseDoubleMatrix2D.this.viewRow(i)).dst(bl);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            for (int i = 0; i < this.rows; ++i) {
                ((DenseDoubleMatrix1D)this.viewRow(i)).dst(bl);
            }
        }
        ConcurrencyUtils.setNumberOfThreads(n);
    }

    public double[] elements() {
        return this.elements;
    }

    public void fft2() {
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        if (this.fft2 == null) {
            this.fft2 = new DoubleFFT_2D(this.rows, this.columns);
        }
        if (this.isNoView) {
            this.fft2.realForward(this.elements);
        } else {
            DoubleMatrix2D doubleMatrix2D = this.copy();
            this.fft2.realForward((double[])doubleMatrix2D.elements());
            this.assign((double[])doubleMatrix2D.elements());
        }
        ConcurrencyUtils.setNumberOfThreads(n);
    }

    public DoubleMatrix2D forEachNonZero(final IntIntDoubleFunction intIntDoubleFunction) {
        final int n = (int)this.index(0, 0);
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            Future[] futureArray = new Future[n2];
            int n3 = this.rows / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? this.rows : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n3 = n + n4 * DenseDoubleMatrix2D.this.rowStride;
                        for (int i = n4; i < n5; ++i) {
                            int n2 = n3;
                            for (int j = 0; j < DenseDoubleMatrix2D.this.columns; ++j) {
                                double d = DenseDoubleMatrix2D.this.elements[n2];
                                if (d != 0.0) {
                                    DenseDoubleMatrix2D.this.elements[n2] = intIntDoubleFunction.apply(i, j, d);
                                }
                                n2 += DenseDoubleMatrix2D.this.columnStride;
                            }
                            n3 += DenseDoubleMatrix2D.this.rowStride;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n6 = n;
            for (int i = 0; i < this.rows; ++i) {
                int n7 = n6;
                for (int j = 0; j < this.columns; ++j) {
                    double d = this.elements[n7];
                    if (d != 0.0) {
                        this.elements[n7] = intIntDoubleFunction.apply(i, j, d);
                    }
                    n7 += this.columnStride;
                }
                n6 += this.rowStride;
            }
        }
        return this;
    }

    public DenseDComplexMatrix2D getFft2() {
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        if (this.fft2 == null) {
            this.fft2 = new DoubleFFT_2D(this.rows, this.columns);
        }
        final double[] dArray = this.isNoView ? this.elements : (double[])this.copy().elements();
        DenseDComplexMatrix2D denseDComplexMatrix2D = new DenseDComplexMatrix2D(this.rows, this.columns);
        final double[] dArray2 = denseDComplexMatrix2D.elements();
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            Future[] futureArray = new Future[n2];
            int n3 = this.rows / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? this.rows : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n4; i < n5; ++i) {
                            System.arraycopy(dArray, i * DenseDoubleMatrix2D.this.columns, dArray2, i * DenseDoubleMatrix2D.this.columns, DenseDoubleMatrix2D.this.columns);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.rows; ++i) {
                System.arraycopy(dArray, i * this.columns, dArray2, i * this.columns, this.columns);
            }
        }
        this.fft2.realForwardFull(dArray2);
        ConcurrencyUtils.setNumberOfThreads(n);
        return denseDComplexMatrix2D;
    }

    public DenseDComplexMatrix2D getFftColumns() {
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        final DenseDComplexMatrix2D denseDComplexMatrix2D = new DenseDComplexMatrix2D(this.rows, this.columns);
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            Future[] futureArray = new Future[n2];
            int n3 = this.columns / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? this.columns : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n4; i < n5; ++i) {
                            denseDComplexMatrix2D.viewColumn(i).assign(((DenseDoubleMatrix1D)DenseDoubleMatrix2D.this.viewColumn(i)).getFft());
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            for (int i = 0; i < this.columns; ++i) {
                denseDComplexMatrix2D.viewColumn(i).assign(((DenseDoubleMatrix1D)this.viewColumn(i)).getFft());
            }
        }
        ConcurrencyUtils.setNumberOfThreads(n);
        return denseDComplexMatrix2D;
    }

    public DenseDComplexMatrix2D getFftRows() {
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        final DenseDComplexMatrix2D denseDComplexMatrix2D = new DenseDComplexMatrix2D(this.rows, this.columns);
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            Future[] futureArray = new Future[n2];
            int n3 = this.rows / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? this.rows : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n4; i < n5; ++i) {
                            denseDComplexMatrix2D.viewRow(i).assign(((DenseDoubleMatrix1D)DenseDoubleMatrix2D.this.viewRow(i)).getFft());
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            for (int i = 0; i < this.rows; ++i) {
                denseDComplexMatrix2D.viewRow(i).assign(((DenseDoubleMatrix1D)this.viewRow(i)).getFft());
            }
        }
        ConcurrencyUtils.setNumberOfThreads(n);
        return denseDComplexMatrix2D;
    }

    public DenseDComplexMatrix2D getIfft2(boolean bl) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        DenseDComplexMatrix2D denseDComplexMatrix2D = new DenseDComplexMatrix2D(this.rows, this.columns);
        final double[] dArray = denseDComplexMatrix2D.elements();
        final double[] dArray2 = this.isNoView ? this.elements : (double[])this.copy().elements();
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            Future[] futureArray = new Future[n2];
            int n3 = this.rows / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? this.rows : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n4; i < n5; ++i) {
                            System.arraycopy(dArray2, i * DenseDoubleMatrix2D.this.columns, dArray, i * DenseDoubleMatrix2D.this.columns, DenseDoubleMatrix2D.this.columns);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.rows; ++i) {
                System.arraycopy(dArray2, i * this.columns, dArray, i * this.columns, this.columns);
            }
        }
        if (this.fft2 == null) {
            this.fft2 = new DoubleFFT_2D(this.rows, this.columns);
        }
        this.fft2.realInverseFull(dArray, bl);
        ConcurrencyUtils.setNumberOfThreads(n);
        return denseDComplexMatrix2D;
    }

    public DenseDComplexMatrix2D getIfftColumns(final boolean bl) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        final DenseDComplexMatrix2D denseDComplexMatrix2D = new DenseDComplexMatrix2D(this.rows, this.columns);
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            Future[] futureArray = new Future[n2];
            int n3 = this.columns / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? this.columns : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n4; i < n5; ++i) {
                            denseDComplexMatrix2D.viewColumn(i).assign(((DenseDoubleMatrix1D)DenseDoubleMatrix2D.this.viewColumn(i)).getIfft(bl));
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            for (int i = 0; i < this.columns; ++i) {
                denseDComplexMatrix2D.viewColumn(i).assign(((DenseDoubleMatrix1D)this.viewColumn(i)).getIfft(bl));
            }
        }
        ConcurrencyUtils.setNumberOfThreads(n);
        return denseDComplexMatrix2D;
    }

    public DenseDComplexMatrix2D getIfftRows(final boolean bl) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        final DenseDComplexMatrix2D denseDComplexMatrix2D = new DenseDComplexMatrix2D(this.rows, this.columns);
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            Future[] futureArray = new Future[n2];
            int n3 = this.rows / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? this.rows : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n4; i < n5; ++i) {
                            denseDComplexMatrix2D.viewRow(i).assign(((DenseDoubleMatrix1D)DenseDoubleMatrix2D.this.viewRow(i)).getIfft(bl));
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            for (int i = 0; i < this.rows; ++i) {
                denseDComplexMatrix2D.viewRow(i).assign(((DenseDoubleMatrix1D)this.viewRow(i)).getIfft(bl));
            }
        }
        ConcurrencyUtils.setNumberOfThreads(n);
        return denseDComplexMatrix2D;
    }

    public void getNegativeValues(IntArrayList intArrayList, IntArrayList intArrayList2, DoubleArrayList doubleArrayList) {
        intArrayList.clear();
        intArrayList2.clear();
        doubleArrayList.clear();
        int n = (int)this.index(0, 0);
        for (int i = 0; i < this.rows; ++i) {
            int n2 = n;
            for (int j = 0; j < this.columns; ++j) {
                double d = this.elements[n2];
                if (d < 0.0) {
                    intArrayList.add(i);
                    intArrayList2.add(j);
                    doubleArrayList.add(d);
                }
                n2 += this.columnStride;
            }
            n += this.rowStride;
        }
    }

    public void getNonZeros(IntArrayList intArrayList, IntArrayList intArrayList2, DoubleArrayList doubleArrayList) {
        intArrayList.clear();
        intArrayList2.clear();
        doubleArrayList.clear();
        int n = (int)this.index(0, 0);
        for (int i = 0; i < this.rows; ++i) {
            int n2 = n;
            for (int j = 0; j < this.columns; ++j) {
                double d = this.elements[n2];
                if (d != 0.0) {
                    intArrayList.add(i);
                    intArrayList2.add(j);
                    doubleArrayList.add(d);
                }
                n2 += this.columnStride;
            }
            n += this.rowStride;
        }
    }

    public void getPositiveValues(IntArrayList intArrayList, IntArrayList intArrayList2, DoubleArrayList doubleArrayList) {
        intArrayList.clear();
        intArrayList2.clear();
        doubleArrayList.clear();
        int n = (int)this.index(0, 0);
        for (int i = 0; i < this.rows; ++i) {
            int n2 = n;
            for (int j = 0; j < this.columns; ++j) {
                double d = this.elements[n2];
                if (d > 0.0) {
                    intArrayList.add(i);
                    intArrayList2.add(j);
                    doubleArrayList.add(d);
                }
                n2 += this.columnStride;
            }
            n += this.rowStride;
        }
    }

    public double getQuick(int n, int n2) {
        return this.elements[this.rowZero + n * this.rowStride + this.columnZero + n2 * this.columnStride];
    }

    public void idct2(boolean bl) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        if (this.dct2 == null) {
            this.dct2 = new DoubleDCT_2D(this.rows, this.columns);
        }
        if (this.isNoView) {
            this.dct2.inverse(this.elements, bl);
        } else {
            DoubleMatrix2D doubleMatrix2D = this.copy();
            this.dct2.inverse((double[])doubleMatrix2D.elements(), bl);
            this.assign((double[])doubleMatrix2D.elements());
        }
        ConcurrencyUtils.setNumberOfThreads(n);
    }

    public void idctColumns(final boolean bl) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            Future[] futureArray = new Future[n2];
            int n3 = this.columns / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? this.columns : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n4; i < n5; ++i) {
                            ((DenseDoubleMatrix1D)DenseDoubleMatrix2D.this.viewColumn(i)).idct(bl);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            for (int i = 0; i < this.columns; ++i) {
                ((DenseDoubleMatrix1D)this.viewColumn(i)).idct(bl);
            }
        }
        ConcurrencyUtils.setNumberOfThreads(n);
    }

    public void idctRows(final boolean bl) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            Future[] futureArray = new Future[n2];
            int n3 = this.rows / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? this.rows : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n4; i < n5; ++i) {
                            ((DenseDoubleMatrix1D)DenseDoubleMatrix2D.this.viewRow(i)).idct(bl);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            for (int i = 0; i < this.rows; ++i) {
                ((DenseDoubleMatrix1D)this.viewRow(i)).idct(bl);
            }
        }
        ConcurrencyUtils.setNumberOfThreads(n);
    }

    public void idht2(boolean bl) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        if (this.dht2 == null) {
            this.dht2 = new DoubleDHT_2D(this.rows, this.columns);
        }
        if (this.isNoView) {
            this.dht2.inverse(this.elements, bl);
        } else {
            DoubleMatrix2D doubleMatrix2D = this.copy();
            this.dht2.inverse((double[])doubleMatrix2D.elements(), bl);
            this.assign((double[])doubleMatrix2D.elements());
        }
        ConcurrencyUtils.setNumberOfThreads(n);
    }

    public void idhtColumns(final boolean bl) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            Future[] futureArray = new Future[n2];
            int n3 = this.columns / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? this.columns : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n4; i < n5; ++i) {
                            ((DenseDoubleMatrix1D)DenseDoubleMatrix2D.this.viewColumn(i)).idht(bl);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            for (int i = 0; i < this.columns; ++i) {
                ((DenseDoubleMatrix1D)this.viewColumn(i)).idht(bl);
            }
        }
        ConcurrencyUtils.setNumberOfThreads(n);
    }

    public void idhtRows(final boolean bl) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            Future[] futureArray = new Future[n2];
            int n3 = this.rows / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? this.rows : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n4; i < n5; ++i) {
                            ((DenseDoubleMatrix1D)DenseDoubleMatrix2D.this.viewRow(i)).idht(bl);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            for (int i = 0; i < this.rows; ++i) {
                ((DenseDoubleMatrix1D)this.viewRow(i)).idht(bl);
            }
        }
        ConcurrencyUtils.setNumberOfThreads(n);
    }

    public void idst2(boolean bl) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        if (this.dst2 == null) {
            this.dst2 = new DoubleDST_2D(this.rows, this.columns);
        }
        if (this.isNoView) {
            this.dst2.inverse(this.elements, bl);
        } else {
            DoubleMatrix2D doubleMatrix2D = this.copy();
            this.dst2.inverse((double[])doubleMatrix2D.elements(), bl);
            this.assign((double[])doubleMatrix2D.elements());
        }
        ConcurrencyUtils.setNumberOfThreads(n);
    }

    public void idstColumns(final boolean bl) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            Future[] futureArray = new Future[n2];
            int n3 = this.columns / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? this.columns : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n4; i < n5; ++i) {
                            ((DenseDoubleMatrix1D)DenseDoubleMatrix2D.this.viewColumn(i)).idst(bl);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            for (int i = 0; i < this.columns; ++i) {
                ((DenseDoubleMatrix1D)this.viewColumn(i)).idst(bl);
            }
        }
        ConcurrencyUtils.setNumberOfThreads(n);
    }

    public void idstRows(final boolean bl) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            Future[] futureArray = new Future[n2];
            int n3 = this.rows / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? this.rows : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n4; i < n5; ++i) {
                            ((DenseDoubleMatrix1D)DenseDoubleMatrix2D.this.viewRow(i)).idst(bl);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            for (int i = 0; i < this.rows; ++i) {
                ((DenseDoubleMatrix1D)this.viewRow(i)).idst(bl);
            }
        }
        ConcurrencyUtils.setNumberOfThreads(n);
    }

    public void ifft2(boolean bl) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        if (this.fft2 == null) {
            this.fft2 = new DoubleFFT_2D(this.rows, this.columns);
        }
        if (this.isNoView) {
            this.fft2.realInverse(this.elements, bl);
        } else {
            DoubleMatrix2D doubleMatrix2D = this.copy();
            this.fft2.realInverse((double[])doubleMatrix2D.elements(), bl);
            this.assign((double[])doubleMatrix2D.elements());
        }
        ConcurrencyUtils.setNumberOfThreads(n);
    }

    public long index(int n, int n2) {
        return this.rowZero + n * this.rowStride + this.columnZero + n2 * this.columnStride;
    }

    public DoubleMatrix2D like(int n, int n2) {
        return new DenseDoubleMatrix2D(n, n2);
    }

    public DoubleMatrix1D like1D(int n) {
        return new DenseDoubleMatrix1D(n);
    }

    public double[] getMaxLocation() {
        int n = 0;
        int n2 = 0;
        final int n3 = (int)this.index(0, 0);
        double d = 0.0;
        int n4 = ConcurrencyUtils.getNumberOfThreads();
        if (n4 > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            int n5;
            Future[] futureArray = new Future[n4];
            double[][] dArray = new double[n4][2];
            int n6 = this.rows / n4;
            for (n5 = 0; n5 < n4; ++n5) {
                final int n7 = n5 * n6;
                final int n8 = n5 == n4 - 1 ? this.rows : n7 + n6;
                futureArray[n5] = ConcurrencyUtils.submit(new Callable<double[]>(){

                    @Override
                    public double[] call() throws Exception {
                        double d = DenseDoubleMatrix2D.this.elements[n3 + n7 * DenseDoubleMatrix2D.this.rowStride];
                        int n = n7;
                        int n2 = 0;
                        int n32 = 1;
                        for (int i = n7; i < n8; ++i) {
                            for (int j = n32; j < DenseDoubleMatrix2D.this.columns; ++j) {
                                double d2 = DenseDoubleMatrix2D.this.elements[n3 + i * DenseDoubleMatrix2D.this.rowStride + j * DenseDoubleMatrix2D.this.columnStride];
                                if (!(d < d2)) continue;
                                d = d2;
                                n = i;
                                n2 = j;
                            }
                            n32 = 0;
                        }
                        return new double[]{d, n, n2};
                    }
                });
            }
            try {
                for (n5 = 0; n5 < n4; ++n5) {
                    dArray[n5] = (double[])futureArray[n5].get();
                }
                d = dArray[0][0];
                n = (int)dArray[0][1];
                n2 = (int)dArray[0][2];
                for (n5 = 1; n5 < n4; ++n5) {
                    if (!(d < dArray[n5][0])) continue;
                    d = dArray[n5][0];
                    n = (int)dArray[n5][1];
                    n2 = (int)dArray[n5][2];
                }
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        } else {
            d = this.elements[n3];
            int n9 = 1;
            for (int i = 0; i < this.rows; ++i) {
                for (int j = n9; j < this.columns; ++j) {
                    double d2 = this.elements[n3 + i * this.rowStride + j * this.columnStride];
                    if (!(d < d2)) continue;
                    d = d2;
                    n = i;
                    n2 = j;
                }
                n9 = 0;
            }
        }
        return new double[]{d, n, n2};
    }

    public double[] getMinLocation() {
        int n = 0;
        int n2 = 0;
        final int n3 = (int)this.index(0, 0);
        double d = 0.0;
        int n4 = ConcurrencyUtils.getNumberOfThreads();
        if (n4 > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            int n5;
            Future[] futureArray = new Future[n4];
            double[][] dArray = new double[n4][2];
            int n6 = this.rows / n4;
            for (n5 = 0; n5 < n4; ++n5) {
                final int n7 = n5 * n6;
                final int n8 = n5 == n4 - 1 ? this.rows : n7 + n6;
                futureArray[n5] = ConcurrencyUtils.submit(new Callable<double[]>(){

                    @Override
                    public double[] call() throws Exception {
                        int n = n7;
                        int n2 = 0;
                        double d = DenseDoubleMatrix2D.this.elements[n3 + n7 * DenseDoubleMatrix2D.this.rowStride];
                        int n32 = 1;
                        for (int i = n7; i < n8; ++i) {
                            for (int j = n32; j < DenseDoubleMatrix2D.this.columns; ++j) {
                                double d2 = DenseDoubleMatrix2D.this.elements[n3 + i * DenseDoubleMatrix2D.this.rowStride + j * DenseDoubleMatrix2D.this.columnStride];
                                if (!(d > d2)) continue;
                                d = d2;
                                n = i;
                                n2 = j;
                            }
                            n32 = 0;
                        }
                        return new double[]{d, n, n2};
                    }
                });
            }
            try {
                for (n5 = 0; n5 < n4; ++n5) {
                    dArray[n5] = (double[])futureArray[n5].get();
                }
                d = dArray[0][0];
                n = (int)dArray[0][1];
                n2 = (int)dArray[0][2];
                for (n5 = 1; n5 < n4; ++n5) {
                    if (!(d > dArray[n5][0])) continue;
                    d = dArray[n5][0];
                    n = (int)dArray[n5][1];
                    n2 = (int)dArray[n5][2];
                }
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        } else {
            d = this.elements[n3];
            int n9 = 1;
            for (int i = 0; i < this.rows; ++i) {
                for (int j = n9; j < this.columns; ++j) {
                    double d2 = this.elements[n3 + i * this.rowStride + j * this.columnStride];
                    if (!(d > d2)) continue;
                    d = d2;
                    n = i;
                    n2 = j;
                }
                n9 = 0;
            }
        }
        return new double[]{d, n, n2};
    }

    public void setQuick(int n, int n2, double d) {
        this.elements[this.rowZero + n * this.rowStride + this.columnZero + n2 * this.columnStride] = d;
    }

    public double[][] toArray() {
        final double[][] dArray = new double[this.rows][this.columns];
        int n = ConcurrencyUtils.getNumberOfThreads();
        final int n2 = (int)this.index(0, 0);
        if (n > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            Future[] futureArray = new Future[n];
            int n3 = this.rows / n;
            for (int i = 0; i < n; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n - 1 ? this.rows : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n = n2 + n4 * DenseDoubleMatrix2D.this.rowStride;
                        for (int i = n4; i < n5; ++i) {
                            double[] dArray2 = dArray[i];
                            int n22 = n;
                            for (int j = 0; j < DenseDoubleMatrix2D.this.columns; ++j) {
                                dArray2[j] = DenseDoubleMatrix2D.this.elements[n22];
                                n22 += DenseDoubleMatrix2D.this.columnStride;
                            }
                            n += DenseDoubleMatrix2D.this.rowStride;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n6 = n2;
            for (int i = 0; i < this.rows; ++i) {
                double[] dArray2 = dArray[i];
                int n7 = n6;
                for (int j = 0; j < this.columns; ++j) {
                    dArray2[j] = this.elements[n7];
                    n7 += this.columnStride;
                }
                n6 += this.rowStride;
            }
        }
        return dArray;
    }

    public DoubleMatrix1D vectorize() {
        DenseDoubleMatrix1D denseDoubleMatrix1D = new DenseDoubleMatrix1D(this.size());
        final int n = (int)this.index(0, 0);
        final int n2 = (int)denseDoubleMatrix1D.index(0);
        final int n3 = denseDoubleMatrix1D.stride();
        final double[] dArray = denseDoubleMatrix1D.elements();
        int n4 = ConcurrencyUtils.getNumberOfThreads();
        if (n4 > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            Future[] futureArray = new Future[n4];
            int n5 = this.columns / n4;
            for (int i = 0; i < n4; ++i) {
                final int n6 = i * n5;
                final int n7 = i * n5 * this.rows;
                final int n8 = i == n4 - 1 ? this.columns : n6 + n5;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n4 = 0;
                        int n22 = n2 + n7 * n3;
                        for (int i = n6; i < n8; ++i) {
                            n4 = n + i * DenseDoubleMatrix2D.this.columnStride;
                            for (int j = 0; j < DenseDoubleMatrix2D.this.rows; ++j) {
                                dArray[n22] = DenseDoubleMatrix2D.this.elements[n4];
                                n4 += DenseDoubleMatrix2D.this.rowStride;
                                n22 += n3;
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n9 = n;
            int n10 = n2;
            for (int i = 0; i < this.columns; ++i) {
                n9 = n + i * this.columnStride;
                for (int j = 0; j < this.rows; ++j) {
                    dArray[n10] = this.elements[n9];
                    n9 += this.rowStride;
                    n10 += n3;
                }
            }
        }
        return denseDoubleMatrix1D;
    }

    public void zAssign8Neighbors(DoubleMatrix2D doubleMatrix2D, Double9Function double9Function) {
        if (!(doubleMatrix2D instanceof DenseDoubleMatrix2D)) {
            super.zAssign8Neighbors(doubleMatrix2D, double9Function);
            return;
        }
        if (double9Function == null) {
            throw new NullPointerException("function must not be null.");
        }
        this.checkShape(doubleMatrix2D);
        int n = this.rows - 1;
        int n2 = this.columns - 1;
        if (this.rows < 3 || this.columns < 3) {
            return;
        }
        DenseDoubleMatrix2D denseDoubleMatrix2D = (DenseDoubleMatrix2D)doubleMatrix2D;
        int n3 = this.rowStride;
        int n4 = denseDoubleMatrix2D.rowStride;
        int n5 = this.columnStride;
        int n6 = denseDoubleMatrix2D.columnStride;
        double[] dArray = this.elements;
        double[] dArray2 = denseDoubleMatrix2D.elements;
        if (dArray == null || dArray2 == null) {
            throw new InternalError();
        }
        int n7 = (int)this.index(1, 1);
        int n8 = (int)denseDoubleMatrix2D.index(1, 1);
        for (int i = 1; i < n; ++i) {
            int n9 = n8;
            int n10 = n7 - n3 - n5;
            int n11 = n10 + n3;
            int n12 = n11 + n3;
            double d = dArray[n10];
            double d2 = dArray[n10 += n5];
            double d3 = dArray[n11];
            double d4 = dArray[n11 += n5];
            double d5 = dArray[n12];
            double d6 = dArray[n12 += n5];
            for (int j = 1; j < n2; ++j) {
                double d7 = dArray[n10 += n5];
                double d8 = dArray[n11 += n5];
                double d9 = dArray[n12 += n5];
                dArray2[n9] = double9Function.apply(d, d2, d7, d3, d4, d8, d5, d6, d9);
                n9 += n6;
                d = d2;
                d2 = d7;
                d3 = d4;
                d4 = d8;
                d5 = d6;
                d6 = d9;
            }
            n7 += n3;
            n8 += n4;
        }
    }

    public DoubleMatrix1D zMult(DoubleMatrix1D doubleMatrix1D, DoubleMatrix1D doubleMatrix1D2, final double d, final double d2, boolean bl) {
        if (bl) {
            return this.viewDice().zMult(doubleMatrix1D, doubleMatrix1D2, d, d2, false);
        }
        DoubleMatrix1D doubleMatrix1D3 = doubleMatrix1D2 == null ? new DenseDoubleMatrix1D(this.rows) : doubleMatrix1D2;
        if (!(doubleMatrix1D instanceof DenseDoubleMatrix1D) || !(doubleMatrix1D3 instanceof DenseDoubleMatrix1D)) {
            return super.zMult(doubleMatrix1D, doubleMatrix1D3, d, d2, bl);
        }
        if (this.columns != doubleMatrix1D.size() || this.rows > doubleMatrix1D3.size()) {
            throw new IllegalArgumentException("Incompatible args: " + this.toStringShort() + ", " + doubleMatrix1D.toStringShort() + ", " + doubleMatrix1D3.toStringShort());
        }
        final double[] dArray = (double[])doubleMatrix1D.elements();
        final double[] dArray2 = (double[])doubleMatrix1D3.elements();
        if (this.elements == null || dArray == null || dArray2 == null) {
            throw new InternalError();
        }
        final int n = doubleMatrix1D.stride();
        final int n2 = doubleMatrix1D3.stride();
        final int n3 = (int)this.index(0, 0);
        final int n4 = (int)doubleMatrix1D.index(0);
        final int n5 = (int)doubleMatrix1D3.index(0);
        int n6 = ConcurrencyUtils.getNumberOfThreads();
        if (n6 > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            Future[] futureArray = new Future[n6];
            int n7 = this.rows / n6;
            for (int i = 0; i < n6; ++i) {
                final int n8 = i * n7;
                final int n9 = i == n6 - 1 ? this.rows : n8 + n7;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n6 = n3 + n8 * DenseDoubleMatrix2D.this.rowStride;
                        int n22 = n5 + n8 * n2;
                        for (int i = n8; i < n9; ++i) {
                            double d3 = 0.0;
                            int n32 = n6;
                            int n42 = n4;
                            for (int j = 0; j < DenseDoubleMatrix2D.this.columns; ++j) {
                                d3 += DenseDoubleMatrix2D.this.elements[n32] * dArray[n42];
                                n32 += DenseDoubleMatrix2D.this.columnStride;
                                n42 += n;
                            }
                            dArray2[n22] = d * d3 + d2 * dArray2[n22];
                            n6 += DenseDoubleMatrix2D.this.rowStride;
                            n22 += n2;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n10 = n3;
            int n11 = n5;
            for (int i = 0; i < this.rows; ++i) {
                double d3 = 0.0;
                int n12 = n10;
                int n13 = n4;
                for (int j = 0; j < this.columns; ++j) {
                    d3 += this.elements[n12] * dArray[n13];
                    n12 += this.columnStride;
                    n13 += n;
                }
                dArray2[n11] = d * d3 + d2 * dArray2[n11];
                n10 += this.rowStride;
                n11 += n2;
            }
        }
        return doubleMatrix1D3;
    }

    public DoubleMatrix2D zMult(DoubleMatrix2D doubleMatrix2D, DoubleMatrix2D doubleMatrix2D2, final double d, final double d2, final boolean bl, final boolean bl2) {
        int n;
        int n2 = this.rows;
        int n3 = this.columns;
        int n4 = doubleMatrix2D.rows();
        int n5 = doubleMatrix2D.columns();
        int n6 = bl ? n3 : n2;
        int n7 = n = bl2 ? n4 : n5;
        if (doubleMatrix2D2 == null) {
            doubleMatrix2D2 = new DenseDoubleMatrix2D(n6, n);
        }
        if (ConcurrencyUtils.getUseJCublas()) {
            double[] dArray = (double[])this.viewDice().copy().elements();
            double[] dArray2 = (double[])doubleMatrix2D.viewDice().copy().elements();
            double[] dArray3 = (double[])doubleMatrix2D2.viewDice().copy().elements();
            JCublas.cublasAlloc(this.size(), 8, "d_A");
            JCublas.cublasAlloc(doubleMatrix2D.size(), 8, "d_B");
            JCublas.cublasAlloc(doubleMatrix2D2.size(), 8, "d_C");
            JCublas.cublasSetVector(this.size(), dArray, 1, "d_A", 1);
            JCublas.cublasSetVector(doubleMatrix2D.size(), dArray2, 1, "d_B", 1);
            JCublas.cublasSetVector(doubleMatrix2D2.size(), dArray3, 1, "d_C", 1);
            int n8 = bl ? n3 : n2;
            int n9 = bl2 ? n4 : n5;
            int n10 = bl ? n2 : n3;
            int n11 = bl ? n10 : n8;
            int n12 = bl2 ? n9 : n10;
            int n13 = n8;
            JCublas.cublasDgemm(bl ? (char)'t' : 'n', bl2 ? (char)'t' : 'n', n8, n9, n10, d, "d_A", n11, "d_B", n12, d2, "d_C", n13);
            JCublas.cublasGetVector(doubleMatrix2D2.size(), "d_C", 1, dArray3, 1);
            JCublas.cublasFree("d_A");
            JCublas.cublasFree("d_B");
            JCublas.cublasFree("d_C");
            int n14 = JCublas.cublasGetError();
            if (n14 != 0) {
                throw new InternalError("Error occured while using CUBLAS library: " + n14);
            }
            doubleMatrix2D2.viewDice().assign(dArray3);
        } else {
            if (bl) {
                return this.viewDice().zMult(doubleMatrix2D, doubleMatrix2D2, d, d2, false, bl2);
            }
            if (doubleMatrix2D instanceof SparseDoubleMatrix2D || doubleMatrix2D instanceof RCDoubleMatrix2D) {
                if (doubleMatrix2D2 == null) {
                    return doubleMatrix2D.zMult(this, null, d, d2, !bl2, true).viewDice();
                }
                doubleMatrix2D.zMult(this, doubleMatrix2D2.viewDice(), d, d2, !bl2, true);
                return doubleMatrix2D2;
            }
            if (bl2) {
                return this.zMult(doubleMatrix2D.viewDice(), doubleMatrix2D2, d, d2, bl, false);
            }
            if (!(doubleMatrix2D2 instanceof DenseDoubleMatrix2D)) {
                return super.zMult(doubleMatrix2D, doubleMatrix2D2, d, d2, bl, bl2);
            }
            if (doubleMatrix2D.rows() != n3) {
                throw new IllegalArgumentException("Matrix2D inner dimensions must agree:" + this.toStringShort() + ", " + doubleMatrix2D.toStringShort());
            }
            if (doubleMatrix2D2.rows() != n2 || doubleMatrix2D2.columns() != n5) {
                throw new IllegalArgumentException("Incompatibe result matrix: " + this.toStringShort() + ", " + doubleMatrix2D.toStringShort() + ", " + doubleMatrix2D2.toStringShort());
            }
            if (this == doubleMatrix2D2 || doubleMatrix2D == doubleMatrix2D2) {
                throw new IllegalArgumentException("Matrices must not be identical");
            }
            long l = 2L * (long)n2 * (long)n3 * (long)n5;
            int n15 = (int)Math.min(l / 30000L, (long)ConcurrencyUtils.getNumberOfThreads());
            boolean bl3 = n5 >= n15;
            int n16 = bl3 ? n5 : n2;
            n15 = Math.min(n16, n15);
            if (n15 < 2) {
                return this.zMultSeq(doubleMatrix2D, doubleMatrix2D2, d, d2, bl, bl2);
            }
            int n17 = n16 / n15;
            Future[] futureArray = new Future[n15];
            for (int i = 0; i < n15; ++i) {
                DoubleMatrix2D doubleMatrix2D3;
                DoubleMatrix2D doubleMatrix2D4;
                DoubleMatrix2D doubleMatrix2D5;
                int n18 = i * n17;
                if (i == n15 - 1) {
                    n17 = n16 - n17 * i;
                }
                if (bl3) {
                    doubleMatrix2D5 = this;
                    doubleMatrix2D4 = doubleMatrix2D.viewPart(0, n18, n3, n17);
                    doubleMatrix2D3 = doubleMatrix2D2.viewPart(0, n18, n2, n17);
                } else {
                    doubleMatrix2D5 = this.viewPart(n18, 0, n17, n3);
                    doubleMatrix2D4 = doubleMatrix2D;
                    doubleMatrix2D3 = doubleMatrix2D2.viewPart(n18, 0, n17, n5);
                }
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        ((DenseDoubleMatrix2D)doubleMatrix2D5).zMultSeq(doubleMatrix2D4, doubleMatrix2D3, d, d2, bl, bl2);
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        }
        return doubleMatrix2D2;
    }

    public double zSum() {
        double d = 0.0;
        if (this.elements == null) {
            throw new InternalError();
        }
        final int n = (int)this.index(0, 0);
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            int n3;
            Future[] futureArray = new Future[n2];
            int n4 = this.rows / n2;
            for (n3 = 0; n3 < n2; ++n3) {
                final int n5 = n3 * n4;
                final int n6 = n3 == n2 - 1 ? this.rows : n5 + n4;
                futureArray[n3] = ConcurrencyUtils.submit(new Callable<Double>(){

                    @Override
                    public Double call() throws Exception {
                        double d = 0.0;
                        int n3 = n + n5 * DenseDoubleMatrix2D.this.rowStride;
                        for (int i = n5; i < n6; ++i) {
                            int n2 = n3;
                            for (int j = 0; j < DenseDoubleMatrix2D.this.columns; ++j) {
                                d += DenseDoubleMatrix2D.this.elements[n2];
                                n2 += DenseDoubleMatrix2D.this.columnStride;
                            }
                            n3 += DenseDoubleMatrix2D.this.rowStride;
                        }
                        return d;
                    }
                });
            }
            try {
                for (n3 = 0; n3 < n2; ++n3) {
                    d += ((Double)futureArray[n3].get()).doubleValue();
                }
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        } else {
            int n7 = n;
            for (int i = 0; i < this.rows; ++i) {
                int n8 = n7;
                for (int j = 0; j < this.columns; ++j) {
                    d += this.elements[n8];
                    n8 += this.columnStride;
                }
                n7 += this.rowStride;
            }
        }
        return d;
    }

    protected boolean haveSharedCellsRaw(DoubleMatrix2D doubleMatrix2D) {
        if (doubleMatrix2D instanceof SelectedDenseDoubleMatrix2D) {
            SelectedDenseDoubleMatrix2D selectedDenseDoubleMatrix2D = (SelectedDenseDoubleMatrix2D)doubleMatrix2D;
            return this.elements == selectedDenseDoubleMatrix2D.elements;
        }
        if (doubleMatrix2D instanceof DenseDoubleMatrix2D) {
            DenseDoubleMatrix2D denseDoubleMatrix2D = (DenseDoubleMatrix2D)doubleMatrix2D;
            return this.elements == denseDoubleMatrix2D.elements;
        }
        return false;
    }

    protected DoubleMatrix1D like1D(int n, int n2, int n3) {
        return new DenseDoubleMatrix1D(n, this.elements, n2, n3, true);
    }

    protected DoubleMatrix2D viewSelectionLike(int[] nArray, int[] nArray2) {
        return new SelectedDenseDoubleMatrix2D(this.elements, nArray, nArray2, 0);
    }

    private DoubleMatrix2D zMultSeq(DoubleMatrix2D doubleMatrix2D, DoubleMatrix2D doubleMatrix2D2, double d, double d2, boolean bl, boolean bl2) {
        if (bl) {
            return this.viewDice().zMult(doubleMatrix2D, doubleMatrix2D2, d, d2, false, bl2);
        }
        if (doubleMatrix2D instanceof SparseDoubleMatrix2D || doubleMatrix2D instanceof RCDoubleMatrix2D) {
            if (doubleMatrix2D2 == null) {
                return doubleMatrix2D.zMult(this, null, d, d2, !bl2, true).viewDice();
            }
            doubleMatrix2D.zMult(this, doubleMatrix2D2.viewDice(), d, d2, !bl2, true);
            return doubleMatrix2D2;
        }
        if (bl2) {
            return this.zMult(doubleMatrix2D.viewDice(), doubleMatrix2D2, d, d2, bl, false);
        }
        int n = this.rows;
        int n2 = this.columns;
        int n3 = doubleMatrix2D.columns();
        if (doubleMatrix2D2 == null) {
            doubleMatrix2D2 = new DenseDoubleMatrix2D(n, n3);
        }
        if (!(doubleMatrix2D2 instanceof DenseDoubleMatrix2D)) {
            return super.zMult(doubleMatrix2D, doubleMatrix2D2, d, d2, bl, bl2);
        }
        if (doubleMatrix2D.rows() != n2) {
            throw new IllegalArgumentException("Matrix2D inner dimensions must agree:" + this.toStringShort() + ", " + doubleMatrix2D.toStringShort());
        }
        if (doubleMatrix2D2.rows() != n || doubleMatrix2D2.columns() != n3) {
            throw new IllegalArgumentException("Incompatibel result matrix: " + this.toStringShort() + ", " + doubleMatrix2D.toStringShort() + ", " + doubleMatrix2D2.toStringShort());
        }
        if (this == doubleMatrix2D2 || doubleMatrix2D == doubleMatrix2D2) {
            throw new IllegalArgumentException("Matrices must not be identical");
        }
        DenseDoubleMatrix2D denseDoubleMatrix2D = (DenseDoubleMatrix2D)doubleMatrix2D;
        DenseDoubleMatrix2D denseDoubleMatrix2D2 = (DenseDoubleMatrix2D)doubleMatrix2D2;
        double[] dArray = this.elements;
        double[] dArray2 = denseDoubleMatrix2D.elements;
        double[] dArray3 = denseDoubleMatrix2D2.elements;
        if (dArray == null || dArray2 == null || dArray3 == null) {
            throw new InternalError();
        }
        int n4 = this.columnStride;
        int n5 = denseDoubleMatrix2D.columnStride;
        int n6 = denseDoubleMatrix2D2.columnStride;
        int n7 = this.rowStride;
        int n8 = denseDoubleMatrix2D.rowStride;
        int n9 = denseDoubleMatrix2D2.rowStride;
        int n10 = (30000 - n2) / (n2 + 1);
        if (n10 <= 0) {
            n10 = 1;
        }
        int n11 = n / n10;
        int n12 = 0;
        if (n % n10 != 0) {
            ++n11;
        }
        while (--n11 >= 0) {
            int n13 = (int)denseDoubleMatrix2D.index(0, 0);
            int n14 = (int)this.index(n12, 0);
            int n15 = (int)denseDoubleMatrix2D2.index(n12, 0);
            n12 += n10;
            if (n11 == 0) {
                n10 += n - n12;
            }
            int n16 = n3;
            while (--n16 >= 0) {
                int n17 = n14;
                int n18 = n15;
                int n19 = n10;
                while (--n19 >= 0) {
                    int n20 = n17;
                    int n21 = n13;
                    double d3 = 0.0;
                    n20 -= n4;
                    n21 -= n8;
                    int n22 = n2 % 4;
                    while (--n22 >= 0) {
                        d3 += dArray[n20 += n4] * dArray2[n21 += n8];
                    }
                    n22 = n2 / 4;
                    while (--n22 >= 0) {
                        int n23 = n20 + n4;
                        n20 = n23;
                        int n24 = n21 + n8;
                        n21 = n24;
                        int n25 = n20 + n4;
                        n20 = n25;
                        int n26 = n21 + n8;
                        n21 = n26;
                        n20 = n20 + n4;
                        n21 = n21 + n8;
                        d3 += dArray[n23] * dArray2[n24] + dArray[n25] * dArray2[n26] + dArray[n20] * dArray2[n21] + dArray[n20 += n4] * dArray2[n21 += n8];
                    }
                    dArray3[n18] = d * d3 + d2 * dArray3[n18];
                    n17 += n7;
                    n18 += n9;
                }
                n13 += n5;
                n15 += n6;
            }
        }
        return doubleMatrix2D2;
    }
}

