/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdouble.impl;

import cern.colt.matrix.tdcomplex.DComplexMatrix1D;
import cern.colt.matrix.tdcomplex.impl.DenseDComplexMatrix1D;
import cern.colt.matrix.tdouble.DoubleMatrix1D;
import cern.colt.matrix.tdouble.DoubleMatrix1DTest;
import cern.colt.matrix.tdouble.impl.DenseDoubleMatrix1D;

public class DenseDoubleMatrix1DTest
extends DoubleMatrix1DTest {
    public DenseDoubleMatrix1DTest(String string) {
        super(string);
    }

    protected void createMatrices() throws Exception {
        this.A = new DenseDoubleMatrix1D(this.SIZE);
        this.B = new DenseDoubleMatrix1D(this.SIZE);
    }

    public void testDct() {
        DoubleMatrix1D doubleMatrix1D = this.A.copy();
        ((DenseDoubleMatrix1D)this.A).dct(true);
        ((DenseDoubleMatrix1D)this.A).idct(true);
        for (int i = 0; i < this.SIZE; ++i) {
            DenseDoubleMatrix1DTest.assertEquals((double)doubleMatrix1D.getQuick(i), (double)this.A.getQuick(i), (double)this.TOL);
        }
    }

    public void testDst() {
        DoubleMatrix1D doubleMatrix1D = this.A.copy();
        ((DenseDoubleMatrix1D)this.A).dst(true);
        ((DenseDoubleMatrix1D)this.A).idst(true);
        for (int i = 0; i < this.SIZE; ++i) {
            DenseDoubleMatrix1DTest.assertEquals((double)doubleMatrix1D.getQuick(i), (double)this.A.getQuick(i), (double)this.TOL);
        }
    }

    public void testDht() {
        DoubleMatrix1D doubleMatrix1D = this.A.copy();
        ((DenseDoubleMatrix1D)this.A).dht();
        ((DenseDoubleMatrix1D)this.A).idht(true);
        for (int i = 0; i < this.SIZE; ++i) {
            DenseDoubleMatrix1DTest.assertEquals((double)doubleMatrix1D.getQuick(i), (double)this.A.getQuick(i), (double)this.TOL);
        }
    }

    public void testFft() {
        DoubleMatrix1D doubleMatrix1D = this.A.copy();
        ((DenseDoubleMatrix1D)this.A).fft();
        ((DenseDoubleMatrix1D)this.A).ifft(true);
        for (int i = 0; i < this.SIZE; ++i) {
            DenseDoubleMatrix1DTest.assertEquals((double)doubleMatrix1D.getQuick(i), (double)this.A.getQuick(i), (double)this.TOL);
        }
    }

    public void testGetFft() {
        DoubleMatrix1D doubleMatrix1D = this.A.copy();
        DenseDComplexMatrix1D denseDComplexMatrix1D = ((DenseDoubleMatrix1D)this.A).getFft();
        denseDComplexMatrix1D.ifft(true);
        for (int i = 0; i < this.SIZE; ++i) {
            double[] dArray = ((DComplexMatrix1D)denseDComplexMatrix1D).getQuick(i);
            DenseDoubleMatrix1DTest.assertEquals((double)doubleMatrix1D.getQuick(i), (double)dArray[0], (double)this.TOL);
            DenseDoubleMatrix1DTest.assertEquals((double)0.0, (double)dArray[1], (double)this.TOL);
        }
    }

    public void testGetIfft() {
        DoubleMatrix1D doubleMatrix1D = this.A.copy();
        DenseDComplexMatrix1D denseDComplexMatrix1D = ((DenseDoubleMatrix1D)this.A).getIfft(true);
        denseDComplexMatrix1D.fft();
        for (int i = 0; i < this.SIZE; ++i) {
            double[] dArray = ((DComplexMatrix1D)denseDComplexMatrix1D).getQuick(i);
            DenseDoubleMatrix1DTest.assertEquals((double)doubleMatrix1D.getQuick(i), (double)dArray[0], (double)this.TOL);
            DenseDoubleMatrix1DTest.assertEquals((double)0.0, (double)dArray[1], (double)this.TOL);
        }
    }
}

