/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdouble.impl;

import cern.colt.matrix.tdcomplex.DComplexMatrix2D;
import cern.colt.matrix.tdcomplex.impl.DenseDComplexMatrix2D;
import cern.colt.matrix.tdouble.DoubleMatrix2D;
import cern.colt.matrix.tdouble.DoubleMatrix2DTest;
import cern.colt.matrix.tdouble.impl.DenseColDoubleMatrix2D;

public class DenseColDoubleMatrix2DTest
extends DoubleMatrix2DTest {
    public DenseColDoubleMatrix2DTest(String string) {
        super(string);
    }

    protected void createMatrices() throws Exception {
        this.A = new DenseColDoubleMatrix2D(this.NROWS, this.NCOLUMNS);
        this.B = new DenseColDoubleMatrix2D(this.NROWS, this.NCOLUMNS);
        this.Bt = new DenseColDoubleMatrix2D(this.NCOLUMNS, this.NROWS);
    }

    public void testAssignDoubleArray() {
        int n;
        double[] dArray = new double[this.A.size()];
        for (n = 0; n < this.A.size(); ++n) {
            dArray[n] = Math.random();
        }
        this.A.assign(dArray);
        n = 0;
        for (int i = 0; i < this.A.columns(); ++i) {
            for (int j = 0; j < this.A.rows(); ++j) {
                DenseColDoubleMatrix2DTest.assertEquals((double)0.0, (double)Math.abs(dArray[n++] - this.A.getQuick(j, i)), (double)this.TOL);
            }
        }
    }

    public void testAssignFloatArray() {
        int n;
        float[] fArray = new float[this.NROWS * this.NCOLUMNS];
        for (n = 0; n < this.NROWS * this.NCOLUMNS; ++n) {
            fArray[n] = (float)Math.random();
        }
        this.A.assign(fArray);
        n = 0;
        for (int i = 0; i < this.NCOLUMNS; ++i) {
            for (int j = 0; j < this.NROWS; ++j) {
                DenseColDoubleMatrix2DTest.assertEquals((double)fArray[n++], (double)this.A.getQuick(j, i), (double)this.TOL);
            }
        }
    }

    public void testDct2() {
        DoubleMatrix2D doubleMatrix2D = this.A.copy();
        ((DenseColDoubleMatrix2D)this.A).dct2(true);
        ((DenseColDoubleMatrix2D)this.A).idct2(true);
        for (int i = 0; i < this.NROWS; ++i) {
            for (int j = 0; j < this.NCOLUMNS; ++j) {
                DenseColDoubleMatrix2DTest.assertEquals((double)0.0, (double)Math.abs(doubleMatrix2D.getQuick(i, j) - this.A.getQuick(i, j)), (double)this.TOL);
            }
        }
    }

    public void testDctColumns() {
        DoubleMatrix2D doubleMatrix2D = this.A.copy();
        ((DenseColDoubleMatrix2D)this.A).dctColumns(true);
        ((DenseColDoubleMatrix2D)this.A).idctColumns(true);
        for (int i = 0; i < this.NROWS; ++i) {
            for (int j = 0; j < this.NCOLUMNS; ++j) {
                DenseColDoubleMatrix2DTest.assertEquals((double)0.0, (double)Math.abs(doubleMatrix2D.getQuick(i, j) - this.A.getQuick(i, j)), (double)this.TOL);
            }
        }
    }

    public void testDctRows() {
        DoubleMatrix2D doubleMatrix2D = this.A.copy();
        ((DenseColDoubleMatrix2D)this.A).dctRows(true);
        ((DenseColDoubleMatrix2D)this.A).idctRows(true);
        for (int i = 0; i < this.NROWS; ++i) {
            for (int j = 0; j < this.NCOLUMNS; ++j) {
                DenseColDoubleMatrix2DTest.assertEquals((double)0.0, (double)Math.abs(doubleMatrix2D.getQuick(i, j) - this.A.getQuick(i, j)), (double)this.TOL);
            }
        }
    }

    public void testDht2() {
        DoubleMatrix2D doubleMatrix2D = this.A.copy();
        ((DenseColDoubleMatrix2D)this.A).dht2();
        ((DenseColDoubleMatrix2D)this.A).idht2(true);
        for (int i = 0; i < this.NROWS; ++i) {
            for (int j = 0; j < this.NCOLUMNS; ++j) {
                DenseColDoubleMatrix2DTest.assertEquals((double)0.0, (double)Math.abs(doubleMatrix2D.getQuick(i, j) - this.A.getQuick(i, j)), (double)this.TOL);
            }
        }
    }

    public void testDhtColumns() {
        DoubleMatrix2D doubleMatrix2D = this.A.copy();
        ((DenseColDoubleMatrix2D)this.A).dhtColumns();
        ((DenseColDoubleMatrix2D)this.A).idhtColumns(true);
        for (int i = 0; i < this.NROWS; ++i) {
            for (int j = 0; j < this.NCOLUMNS; ++j) {
                DenseColDoubleMatrix2DTest.assertEquals((double)0.0, (double)Math.abs(doubleMatrix2D.getQuick(i, j) - this.A.getQuick(i, j)), (double)this.TOL);
            }
        }
    }

    public void testDhtRows() {
        DoubleMatrix2D doubleMatrix2D = this.A.copy();
        ((DenseColDoubleMatrix2D)this.A).dhtRows();
        ((DenseColDoubleMatrix2D)this.A).idhtRows(true);
        for (int i = 0; i < this.NROWS; ++i) {
            for (int j = 0; j < this.NCOLUMNS; ++j) {
                DenseColDoubleMatrix2DTest.assertEquals((double)0.0, (double)Math.abs(doubleMatrix2D.getQuick(i, j) - this.A.getQuick(i, j)), (double)this.TOL);
            }
        }
    }

    public void testDst2() {
        DoubleMatrix2D doubleMatrix2D = this.A.copy();
        ((DenseColDoubleMatrix2D)this.A).dst2(true);
        ((DenseColDoubleMatrix2D)this.A).idst2(true);
        for (int i = 0; i < this.NROWS; ++i) {
            for (int j = 0; j < this.NCOLUMNS; ++j) {
                DenseColDoubleMatrix2DTest.assertEquals((double)0.0, (double)Math.abs(doubleMatrix2D.getQuick(i, j) - this.A.getQuick(i, j)), (double)this.TOL);
            }
        }
    }

    public void testDstColumns() {
        DoubleMatrix2D doubleMatrix2D = this.A.copy();
        ((DenseColDoubleMatrix2D)this.A).dstColumns(true);
        ((DenseColDoubleMatrix2D)this.A).idstColumns(true);
        for (int i = 0; i < this.NROWS; ++i) {
            for (int j = 0; j < this.NCOLUMNS; ++j) {
                DenseColDoubleMatrix2DTest.assertEquals((double)0.0, (double)Math.abs(doubleMatrix2D.getQuick(i, j) - this.A.getQuick(i, j)), (double)this.TOL);
            }
        }
    }

    public void testDstRows() {
        DoubleMatrix2D doubleMatrix2D = this.A.copy();
        ((DenseColDoubleMatrix2D)this.A).dstRows(true);
        ((DenseColDoubleMatrix2D)this.A).idstRows(true);
        for (int i = 0; i < this.NROWS; ++i) {
            for (int j = 0; j < this.NCOLUMNS; ++j) {
                DenseColDoubleMatrix2DTest.assertEquals((double)0.0, (double)Math.abs(doubleMatrix2D.getQuick(i, j) - this.A.getQuick(i, j)), (double)this.TOL);
            }
        }
    }

    public void testFft2() {
        int n = 64;
        int n2 = 128;
        DenseColDoubleMatrix2D denseColDoubleMatrix2D = new DenseColDoubleMatrix2D(n, n2);
        DoubleMatrix2D doubleMatrix2D = denseColDoubleMatrix2D.copy();
        denseColDoubleMatrix2D.fft2();
        denseColDoubleMatrix2D.ifft2(true);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                DenseColDoubleMatrix2DTest.assertEquals((double)doubleMatrix2D.getQuick(i, j), (double)((DoubleMatrix2D)denseColDoubleMatrix2D).getQuick(i, j), (double)this.TOL);
            }
        }
    }

    public void testGetFft2() {
        DoubleMatrix2D doubleMatrix2D = this.A.copy();
        DComplexMatrix2D dComplexMatrix2D = ((DenseColDoubleMatrix2D)this.A).getFft2();
        ((DenseDComplexMatrix2D)dComplexMatrix2D).ifft2(true);
        for (int i = 0; i < this.NROWS; ++i) {
            for (int j = 0; j < this.NCOLUMNS; ++j) {
                double[] dArray = dComplexMatrix2D.getQuick(i, j);
                DenseColDoubleMatrix2DTest.assertEquals((double)doubleMatrix2D.getQuick(i, j), (double)dArray[0], (double)this.TOL);
                DenseColDoubleMatrix2DTest.assertEquals((double)0.0, (double)dArray[1], (double)this.TOL);
            }
        }
    }

    public void testGetIfft2() {
        DoubleMatrix2D doubleMatrix2D = this.A.copy();
        DComplexMatrix2D dComplexMatrix2D = ((DenseColDoubleMatrix2D)this.A).getIfft2(true);
        ((DenseDComplexMatrix2D)dComplexMatrix2D).fft2();
        for (int i = 0; i < this.NROWS; ++i) {
            for (int j = 0; j < this.NCOLUMNS; ++j) {
                double[] dArray = dComplexMatrix2D.getQuick(i, j);
                DenseColDoubleMatrix2DTest.assertEquals((double)doubleMatrix2D.getQuick(i, j), (double)dArray[0], (double)this.TOL);
                DenseColDoubleMatrix2DTest.assertEquals((double)0.0, (double)dArray[1], (double)this.TOL);
            }
        }
    }

    public void testGetFftColumns() {
        DoubleMatrix2D doubleMatrix2D = this.A.copy();
        DComplexMatrix2D dComplexMatrix2D = ((DenseColDoubleMatrix2D)this.A).getFftColumns();
        ((DenseDComplexMatrix2D)dComplexMatrix2D).ifftColumns(true);
        for (int i = 0; i < this.NROWS; ++i) {
            for (int j = 0; j < this.NCOLUMNS; ++j) {
                double[] dArray = dComplexMatrix2D.getQuick(i, j);
                DenseColDoubleMatrix2DTest.assertEquals((double)doubleMatrix2D.getQuick(i, j), (double)dArray[0], (double)this.TOL);
                DenseColDoubleMatrix2DTest.assertEquals((double)0.0, (double)dArray[1], (double)this.TOL);
            }
        }
    }

    public void testGetIfftColumns() {
        DoubleMatrix2D doubleMatrix2D = this.A.copy();
        DComplexMatrix2D dComplexMatrix2D = ((DenseColDoubleMatrix2D)this.A).getIfftColumns(true);
        ((DenseDComplexMatrix2D)dComplexMatrix2D).fftColumns();
        for (int i = 0; i < this.NROWS; ++i) {
            for (int j = 0; j < this.NCOLUMNS; ++j) {
                double[] dArray = dComplexMatrix2D.getQuick(i, j);
                DenseColDoubleMatrix2DTest.assertEquals((double)doubleMatrix2D.getQuick(i, j), (double)dArray[0], (double)this.TOL);
                DenseColDoubleMatrix2DTest.assertEquals((double)0.0, (double)dArray[1], (double)this.TOL);
            }
        }
    }

    public void testGetFftRows() {
        DoubleMatrix2D doubleMatrix2D = this.A.copy();
        DComplexMatrix2D dComplexMatrix2D = ((DenseColDoubleMatrix2D)this.A).getFftRows();
        ((DenseDComplexMatrix2D)dComplexMatrix2D).ifftRows(true);
        for (int i = 0; i < this.NROWS; ++i) {
            for (int j = 0; j < this.NCOLUMNS; ++j) {
                double[] dArray = dComplexMatrix2D.getQuick(i, j);
                DenseColDoubleMatrix2DTest.assertEquals((double)doubleMatrix2D.getQuick(i, j), (double)dArray[0], (double)this.TOL);
                DenseColDoubleMatrix2DTest.assertEquals((double)0.0, (double)dArray[1], (double)this.TOL);
            }
        }
    }

    public void testGetIfftRows() {
        DoubleMatrix2D doubleMatrix2D = this.A.copy();
        DComplexMatrix2D dComplexMatrix2D = ((DenseColDoubleMatrix2D)this.A).getIfftRows(true);
        ((DenseDComplexMatrix2D)dComplexMatrix2D).fftRows();
        for (int i = 0; i < this.NROWS; ++i) {
            for (int j = 0; j < this.NCOLUMNS; ++j) {
                double[] dArray = dComplexMatrix2D.getQuick(i, j);
                DenseColDoubleMatrix2DTest.assertEquals((double)doubleMatrix2D.getQuick(i, j), (double)dArray[0], (double)this.TOL);
                DenseColDoubleMatrix2DTest.assertEquals((double)0.0, (double)dArray[1], (double)this.TOL);
            }
        }
    }
}

