/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdouble.impl;

import cern.colt.function.tdouble.DoubleDoubleFunction;
import cern.colt.function.tdouble.DoubleFunction;
import cern.colt.function.tdouble.IntIntDoubleFunction;
import cern.colt.list.tdouble.DoubleArrayList;
import cern.colt.list.tint.IntArrayList;
import cern.colt.matrix.tdouble.DoubleMatrix1D;
import cern.colt.matrix.tdouble.DoubleMatrix2D;
import cern.colt.matrix.tdouble.impl.DenseDoubleMatrix1D;
import cern.colt.matrix.tdouble.impl.DenseDoubleMatrix2D;
import cern.colt.matrix.tdouble.impl.SparseDoubleMatrix1D;
import cern.colt.matrix.tdouble.impl.WrapperDoubleMatrix2D;
import cern.jet.math.tdouble.DoubleFunctions;
import cern.jet.math.tdouble.DoubleMult;
import cern.jet.math.tdouble.DoublePlusMultSecond;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.util.concurrent.Future;

public class CCDoubleMatrix2D
extends WrapperDoubleMatrix2D {
    protected IntArrayList rowIndexes;
    protected DoubleArrayList values;
    protected int[] columnPointers;

    public CCDoubleMatrix2D(double[][] dArray) {
        this(dArray.length, dArray.length == 0 ? 0 : dArray[0].length);
        this.assign(dArray);
    }

    public CCDoubleMatrix2D(int n, int n2, int[] nArray, IntArrayList intArrayList, DoubleArrayList doubleArrayList) {
        block2: {
            super(null);
            try {
                this.setUp(n, n2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if ("matrix too large".equals(illegalArgumentException.getMessage())) break block2;
                throw illegalArgumentException;
            }
        }
        this.columnPointers = nArray;
        this.rowIndexes = intArrayList;
        this.values = doubleArrayList;
    }

    public CCDoubleMatrix2D(int n, int n2) {
        block2: {
            super(null);
            try {
                this.setUp(n, n2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if ("matrix too large".equals(illegalArgumentException.getMessage())) break block2;
                throw illegalArgumentException;
            }
        }
        this.rowIndexes = new IntArrayList();
        this.values = new DoubleArrayList();
        this.columnPointers = new int[n2 + 1];
    }

    public CCDoubleMatrix2D(int n, int n2, int n3) {
        block2: {
            super(null);
            try {
                this.setUp(n, n2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if ("matrix too large".equals(illegalArgumentException.getMessage())) break block2;
                throw illegalArgumentException;
            }
        }
        this.rowIndexes = new IntArrayList(n3);
        this.values = new DoubleArrayList(n3);
        this.columnPointers = new int[n2 + 1];
    }

    public CCDoubleMatrix2D(int n, int n2, IntArrayList intArrayList, IntArrayList intArrayList2, DoubleArrayList doubleArrayList) {
        int n3;
        block4: {
            super(null);
            try {
                this.setUp(n, n2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if ("matrix too large".equals(illegalArgumentException.getMessage())) break block4;
                throw illegalArgumentException;
            }
        }
        int n4 = intArrayList.size();
        int[] nArray = intArrayList.elements();
        int[] nArray2 = intArrayList2.elements();
        double[] dArray = doubleArrayList.elements();
        int[] nArray3 = new int[n4];
        double[] dArray2 = new double[n4];
        int[] nArray4 = new int[n2 + 1];
        int[] nArray5 = new int[n2];
        for (n3 = 0; n3 < n4; ++n3) {
            int n5 = nArray2[n3];
            nArray5[n5] = nArray5[n5] + 1;
        }
        this.cumsum(nArray4, nArray5, n2);
        for (n3 = 0; n3 < n4; ++n3) {
            int n6 = nArray2[n3];
            nArray5[n6] = nArray5[n6] + 1;
            nArray3[var14_16] = nArray[n3];
            dArray2[var14_16] = dArray[n3];
        }
        this.columnPointers = nArray4;
        this.rowIndexes = new IntArrayList(nArray3);
        this.values = new DoubleArrayList(dArray2);
    }

    public CCDoubleMatrix2D(int n, int n2, IntArrayList intArrayList, IntArrayList intArrayList2, double d) {
        int n3;
        block4: {
            super(null);
            try {
                this.setUp(n, n2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if ("matrix too large".equals(illegalArgumentException.getMessage())) break block4;
                throw illegalArgumentException;
            }
        }
        int n4 = intArrayList.size();
        int[] nArray = intArrayList.elements();
        int[] nArray2 = intArrayList2.elements();
        int[] nArray3 = new int[n4];
        double[] dArray = new double[n4];
        int[] nArray4 = new int[n2 + 1];
        int[] nArray5 = new int[n2];
        for (n3 = 0; n3 < n4; ++n3) {
            int n5 = nArray2[n3];
            nArray5[n5] = nArray5[n5] + 1;
        }
        this.cumsum(nArray4, nArray5, n2);
        for (n3 = 0; n3 < n4; ++n3) {
            int n6 = nArray2[n3];
            nArray5[n6] = nArray5[n6] + 1;
            nArray3[var14_15] = nArray[n3];
            dArray[var14_15] = d;
        }
        this.columnPointers = nArray4;
        this.rowIndexes = new IntArrayList(nArray3);
        this.values = new DoubleArrayList(dArray);
    }

    private float cumsum(int[] nArray, int[] nArray2, int n) {
        int n2 = 0;
        float f = 0.0f;
        for (int i = 0; i < n; ++i) {
            nArray[i] = n2;
            n2 += nArray2[i];
            f += (float)nArray2[i];
            nArray2[i] = nArray[i];
        }
        nArray[n] = n2;
        return f;
    }

    public DoubleMatrix2D assign(double d) {
        if (d == 0.0) {
            this.rowIndexes.clear();
            this.values.clear();
            this.columnPointers = new int[this.columns + 1];
        } else {
            int n = this.cardinality();
            for (int i = 0; i < n; ++i) {
                this.values.setQuick(i, d);
            }
        }
        return this;
    }

    public DoubleMatrix2D assign(final DoubleFunction doubleFunction) {
        if (doubleFunction instanceof DoubleMult) {
            final double d = ((DoubleMult)doubleFunction).multiplicator;
            if (d == 1.0) {
                return this;
            }
            if (d == 0.0) {
                return this.assign(0.0);
            }
            if (d != d) {
                return this.assign(d);
            }
            final double[] dArray = this.values.elements();
            int n = ConcurrencyUtils.getNumberOfThreads();
            if (n > 1 && this.cardinality() >= ConcurrencyUtils.getThreadsBeginN_2D()) {
                Future[] futureArray = new Future[n];
                int n2 = dArray.length / n;
                for (int i = 0; i < n; ++i) {
                    final int n3 = i * n2;
                    final int n4 = i == n - 1 ? dArray.length : n3 + n2;
                    futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                        public void run() {
                            int n = n3;
                            while (n < n4) {
                                int n2 = n++;
                                dArray[n2] = dArray[n2] * d;
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futureArray);
            } else {
                int n5 = this.values.size();
                while (--n5 >= 0) {
                    int n6 = n5;
                    dArray[n6] = dArray[n6] * d;
                }
            }
        } else {
            this.forEachNonZero(new IntIntDoubleFunction(){

                public double apply(int n, int n2, double d) {
                    return doubleFunction.apply(d);
                }
            });
        }
        return this;
    }

    public DoubleMatrix2D assign(DoubleMatrix2D doubleMatrix2D) {
        if (doubleMatrix2D == this) {
            return this;
        }
        this.checkShape(doubleMatrix2D);
        if (!(doubleMatrix2D instanceof CCDoubleMatrix2D)) {
            this.assign(0.0);
            doubleMatrix2D.forEachNonZero(new IntIntDoubleFunction(){

                public double apply(int n, int n2, double d) {
                    CCDoubleMatrix2D.this.setQuick(n, n2, d);
                    return d;
                }
            });
            return this;
        }
        CCDoubleMatrix2D cCDoubleMatrix2D = (CCDoubleMatrix2D)doubleMatrix2D;
        System.arraycopy(cCDoubleMatrix2D.columnPointers, 0, this.columnPointers, 0, this.columnPointers.length);
        int n = cCDoubleMatrix2D.rowIndexes.size();
        this.rowIndexes.setSize(n);
        this.values.setSize(n);
        this.rowIndexes.replaceFromToWithFrom(0, n - 1, cCDoubleMatrix2D.rowIndexes, 0);
        this.values.replaceFromToWithFrom(0, n - 1, cCDoubleMatrix2D.values, 0);
        return this;
    }

    public DoubleMatrix2D assign(final DoubleMatrix2D doubleMatrix2D, DoubleDoubleFunction doubleDoubleFunction) {
        this.checkShape(doubleMatrix2D);
        if (doubleDoubleFunction instanceof DoublePlusMultSecond) {
            final double d = ((DoublePlusMultSecond)doubleDoubleFunction).multiplicator;
            if (d == 0.0) {
                return this;
            }
            doubleMatrix2D.forEachNonZero(new IntIntDoubleFunction(){

                public double apply(int n, int n2, double d2) {
                    CCDoubleMatrix2D.this.setQuick(n, n2, CCDoubleMatrix2D.this.getQuick(n, n2) + d * d2);
                    return d2;
                }
            });
            return this;
        }
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (doubleDoubleFunction == DoubleFunctions.mult) {
            final int[] nArray = this.rowIndexes.elements();
            final double[] dArray = this.values.elements();
            if (n > 1 && this.cardinality() >= ConcurrencyUtils.getThreadsBeginN_2D()) {
                Future[] futureArray = new Future[n];
                int n2 = (this.columnPointers.length - 1) / n;
                for (int i = 0; i < n; ++i) {
                    final int n3 = i * n2;
                    final int n4 = i == n - 1 ? this.columnPointers.length - 1 : n3 + n2;
                    futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                        public void run() {
                            for (int i = n3; i < n4; ++i) {
                                int n = CCDoubleMatrix2D.this.columnPointers[i + 1];
                                for (int j = CCDoubleMatrix2D.this.columnPointers[i]; j < n; ++j) {
                                    int n2 = nArray[j];
                                    int n32 = j;
                                    dArray[n32] = dArray[n32] * doubleMatrix2D.getQuick(n2, i);
                                    if (dArray[j] != 0.0) continue;
                                    CCDoubleMatrix2D.this.remove(n2, i);
                                }
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futureArray);
            } else {
                int n5 = this.columnPointers.length - 1;
                while (--n5 >= 0) {
                    int n6 = this.columnPointers[n5];
                    int n7 = this.columnPointers[n5 + 1];
                    while (--n7 >= n6) {
                        int n8 = nArray[n7];
                        int n9 = n7;
                        dArray[n9] = dArray[n9] * doubleMatrix2D.getQuick(n8, n5);
                        if (dArray[n7] != 0.0) continue;
                        this.remove(n8, n5);
                    }
                }
            }
            return this;
        }
        if (doubleDoubleFunction == DoubleFunctions.div) {
            final int[] nArray = this.rowIndexes.elements();
            final double[] dArray = this.values.elements();
            if (n > 1 && this.cardinality() >= ConcurrencyUtils.getThreadsBeginN_2D()) {
                Future[] futureArray = new Future[n];
                int n10 = (this.columnPointers.length - 1) / n;
                for (int i = 0; i < n; ++i) {
                    final int n11 = i * n10;
                    final int n12 = i == n - 1 ? this.columnPointers.length - 1 : n11 + n10;
                    futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                        public void run() {
                            for (int i = n11; i < n12; ++i) {
                                int n = CCDoubleMatrix2D.this.columnPointers[i + 1];
                                for (int j = CCDoubleMatrix2D.this.columnPointers[i]; j < n; ++j) {
                                    int n2 = nArray[j];
                                    int n3 = j;
                                    dArray[n3] = dArray[n3] / doubleMatrix2D.getQuick(n2, i);
                                    if (dArray[j] != 0.0) continue;
                                    CCDoubleMatrix2D.this.remove(n2, i);
                                }
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futureArray);
            } else {
                int n13 = this.columnPointers.length - 1;
                while (--n13 >= 0) {
                    int n14 = this.columnPointers[n13];
                    int n15 = this.columnPointers[n13 + 1];
                    while (--n15 >= n14) {
                        int n16 = nArray[n15];
                        int n17 = n15;
                        dArray[n17] = dArray[n17] / doubleMatrix2D.getQuick(n16, n13);
                        if (dArray[n15] != 0.0) continue;
                        this.remove(n16, n13);
                    }
                }
            }
            return this;
        }
        return super.assign(doubleMatrix2D, doubleDoubleFunction);
    }

    public DoubleMatrix2D forEachNonZero(final IntIntDoubleFunction intIntDoubleFunction) {
        final int[] nArray = this.rowIndexes.elements();
        final double[] dArray = this.values.elements();
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.cardinality() >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            Future[] futureArray = new Future[n];
            int n2 = (this.columnPointers.length - 1) / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.columnPointers.length - 1 : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            int n = CCDoubleMatrix2D.this.columnPointers[i + 1];
                            for (int j = CCDoubleMatrix2D.this.columnPointers[i]; j < n; ++j) {
                                int n2 = nArray[j];
                                double d = dArray[j];
                                double d2 = intIntDoubleFunction.apply(n2, i, d);
                                if (d2 == d) continue;
                                dArray[j] = d2;
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n5 = this.columnPointers.length - 1;
            while (--n5 >= 0) {
                int n6 = this.columnPointers[n5];
                int n7 = this.columnPointers[n5 + 1];
                while (--n7 >= n6) {
                    int n8 = nArray[n7];
                    double d = dArray[n7];
                    double d2 = intIntDoubleFunction.apply(n8, n5, d);
                    if (d2 == d) continue;
                    dArray[n7] = d2;
                }
            }
        }
        return this;
    }

    protected DoubleMatrix2D getContent() {
        return this;
    }

    public IntArrayList getRowindexes() {
        return this.rowIndexes;
    }

    public int[] getColumnPointers() {
        return this.columnPointers;
    }

    public DoubleArrayList getValues() {
        return this.values;
    }

    public double getQuick(int n, int n2) {
        int n3 = this.rowIndexes.binarySearchFromTo(n, this.columnPointers[n2], this.columnPointers[n2 + 1] - 1);
        double d = 0.0;
        if (n3 >= 0) {
            d = this.values.getQuick(n3);
        }
        return d;
    }

    protected synchronized void insert(int n, int n2, int n3, double d) {
        this.rowIndexes.beforeInsert(n3, n);
        this.values.beforeInsert(n3, d);
        int n4 = this.columnPointers.length;
        while (--n4 > n2) {
            int n5 = n4;
            this.columnPointers[n5] = this.columnPointers[n5] + 1;
        }
    }

    public DoubleMatrix2D like(int n, int n2) {
        return new CCDoubleMatrix2D(n, n2);
    }

    public DoubleMatrix1D like1D(int n) {
        return new SparseDoubleMatrix1D(n);
    }

    protected void remove(int n, int n2) {
        this.rowIndexes.remove(n2);
        this.values.remove(n2);
        int n3 = this.columnPointers.length;
        while (--n3 > n) {
            int n4 = n3;
            this.columnPointers[n4] = this.columnPointers[n4] - 1;
        }
    }

    public int cardinality() {
        return this.rowIndexes.size();
    }

    public synchronized void setQuick(int n, int n2, double d) {
        int n3 = this.rowIndexes.binarySearchFromTo(n, this.columnPointers[n2], this.columnPointers[n2 + 1] - 1);
        if (n3 >= 0) {
            if (d == 0.0) {
                this.remove(n2, n3);
            } else {
                this.values.setQuick(n3, d);
            }
            return;
        }
        if (d != 0.0) {
            n3 = -n3 - 1;
            this.insert(n, n2, n3, d);
        }
    }

    public DenseDoubleMatrix2D getFull() {
        final DenseDoubleMatrix2D denseDoubleMatrix2D = new DenseDoubleMatrix2D(this.rows, this.columns);
        this.forEachNonZero(new IntIntDoubleFunction(){

            public double apply(int n, int n2, double d) {
                denseDoubleMatrix2D.setQuick(n, n2, CCDoubleMatrix2D.this.getQuick(n, n2));
                return d;
            }
        });
        return denseDoubleMatrix2D;
    }

    public void trimToSize() {
        this.rowIndexes.trimToSize();
        this.values.trimToSize();
    }

    public DoubleMatrix1D zMult(DoubleMatrix1D doubleMatrix1D, DoubleMatrix1D doubleMatrix1D2, final double d, final double d2, boolean bl) {
        boolean bl2;
        int n = this.rows;
        int n2 = this.columns;
        if (bl) {
            n = this.columns;
            n2 = this.rows;
        }
        boolean bl3 = bl2 = doubleMatrix1D2 == null || bl;
        if (doubleMatrix1D2 == null) {
            doubleMatrix1D2 = new DenseDoubleMatrix1D(n);
        }
        if (!(doubleMatrix1D instanceof DenseDoubleMatrix1D) || !(doubleMatrix1D2 instanceof DenseDoubleMatrix1D)) {
            return super.zMult(doubleMatrix1D, doubleMatrix1D2, d, d2, bl);
        }
        if (n2 != doubleMatrix1D.size() || n > doubleMatrix1D2.size()) {
            throw new IllegalArgumentException("Incompatible args: " + (bl ? this.viewDice() : this).toStringShort() + ", " + doubleMatrix1D.toStringShort() + ", " + doubleMatrix1D2.toStringShort());
        }
        DenseDoubleMatrix1D denseDoubleMatrix1D = (DenseDoubleMatrix1D)doubleMatrix1D2;
        final double[] dArray = denseDoubleMatrix1D.elements;
        final int n3 = denseDoubleMatrix1D.stride();
        final int n4 = (int)denseDoubleMatrix1D.index(0);
        DenseDoubleMatrix1D denseDoubleMatrix1D2 = (DenseDoubleMatrix1D)doubleMatrix1D;
        final double[] dArray2 = denseDoubleMatrix1D2.elements;
        final int n5 = denseDoubleMatrix1D2.stride();
        final int n6 = (int)denseDoubleMatrix1D2.index(0);
        final int[] nArray = this.rowIndexes.elements();
        final double[] dArray3 = this.values.elements();
        int n7 = n4;
        if (!bl) {
            if (!bl2 && d2 / d != 1.0) {
                doubleMatrix1D2.assign(DoubleFunctions.mult(d2 / d));
            }
            for (int i = 0; i < this.columns; ++i) {
                int n8 = this.columnPointers[i + 1];
                double d3 = dArray2[n6 + n5 * i];
                for (int j = this.columnPointers[i]; j < n8; ++j) {
                    int n9 = nArray[j];
                    int n10 = n4 + n3 * n9;
                    dArray[n10] = dArray[n10] + dArray3[j] * d3;
                }
            }
            if (d != 1.0) {
                doubleMatrix1D2.assign(DoubleFunctions.mult(d));
            }
        } else {
            int n11 = ConcurrencyUtils.getNumberOfThreads();
            if (n11 > 1 && this.cardinality() >= ConcurrencyUtils.getThreadsBeginN_2D()) {
                Future[] futureArray = new Future[n11];
                int n12 = this.columns / n11;
                for (int i = 0; i < n11; ++i) {
                    final int n13 = i * n12;
                    final int n14 = i == n11 - 1 ? this.columns : n13 + n12;
                    futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                        public void run() {
                            int n = n4 + n13 * n3;
                            for (int i = n13; i < n14; ++i) {
                                int n2 = CCDoubleMatrix2D.this.columnPointers[i + 1];
                                double d3 = 0.0;
                                for (int j = CCDoubleMatrix2D.this.columnPointers[i]; j < n2; ++j) {
                                    int n32 = nArray[j];
                                    d3 += dArray3[j] * dArray2[n6 + n5 * n32];
                                }
                                dArray[n] = d * d3 + dArray[n] * d2;
                                n += n3;
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futureArray);
            } else {
                for (int i = 0; i < this.columns; ++i) {
                    int n15 = this.columnPointers[i + 1];
                    double d4 = 0.0;
                    for (int j = this.columnPointers[i]; j < n15; ++j) {
                        int n16 = nArray[j];
                        d4 += dArray3[j] * dArray2[n6 + n5 * n16];
                    }
                    dArray[n7] = d * d4 + dArray[n7] * d2;
                    n7 += n3;
                }
            }
        }
        return doubleMatrix1D2;
    }

    public DoubleMatrix2D zMult(DoubleMatrix2D doubleMatrix2D, DoubleMatrix2D doubleMatrix2D2, double d, double d2, boolean bl, boolean bl2) {
        boolean bl3;
        if (bl2) {
            doubleMatrix2D = doubleMatrix2D.viewDice();
        }
        int n = this.rows;
        int n2 = this.columns;
        if (bl) {
            n = this.columns;
            n2 = this.rows;
        }
        int n3 = doubleMatrix2D.columns();
        boolean bl4 = bl3 = doubleMatrix2D2 == null;
        if (doubleMatrix2D2 == null) {
            doubleMatrix2D2 = new DenseDoubleMatrix2D(n, n3);
        }
        if (doubleMatrix2D.rows() != n2) {
            throw new IllegalArgumentException("Matrix2D inner dimensions must agree:" + this.toStringShort() + ", " + (bl2 ? doubleMatrix2D.viewDice() : doubleMatrix2D).toStringShort());
        }
        if (doubleMatrix2D2.rows() != n || doubleMatrix2D2.columns() != n3) {
            throw new IllegalArgumentException("Incompatible result matrix: " + this.toStringShort() + ", " + (bl2 ? doubleMatrix2D.viewDice() : doubleMatrix2D).toStringShort() + ", " + doubleMatrix2D2.toStringShort());
        }
        if (this == doubleMatrix2D2 || doubleMatrix2D == doubleMatrix2D2) {
            throw new IllegalArgumentException("Matrices must not be identical");
        }
        if (!bl3) {
            doubleMatrix2D2.assign(DoubleFunctions.mult(d2));
        }
        DoubleMatrix1D[] doubleMatrix1DArray = new DoubleMatrix1D[n2];
        int n4 = n2;
        while (--n4 >= 0) {
            doubleMatrix1DArray[n4] = doubleMatrix2D.viewRow(n4);
        }
        DoubleMatrix1D[] doubleMatrix1DArray2 = new DoubleMatrix1D[n];
        int n5 = n;
        while (--n5 >= 0) {
            doubleMatrix1DArray2[n5] = doubleMatrix2D2.viewRow(n5);
        }
        DoublePlusMultSecond doublePlusMultSecond = DoublePlusMultSecond.plusMult(0.0);
        int[] nArray = this.rowIndexes.elements();
        double[] dArray = this.values.elements();
        int n6 = this.columns;
        while (--n6 >= 0) {
            int n7 = this.columnPointers[n6];
            int n8 = this.columnPointers[n6 + 1];
            while (--n8 >= n7) {
                int n9 = nArray[n8];
                doublePlusMultSecond.multiplicator = dArray[n8] * d;
                if (!bl) {
                    doubleMatrix1DArray2[n9].assign(doubleMatrix1DArray[n6], doublePlusMultSecond);
                    continue;
                }
                doubleMatrix1DArray2[n6].assign(doubleMatrix1DArray[n9], doublePlusMultSecond);
            }
        }
        return doubleMatrix2D2;
    }
}

