/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdouble.algo.solver.preconditioner;

import cern.colt.matrix.Norm;
import cern.colt.matrix.tdouble.DoubleMatrix1D;
import cern.colt.matrix.tdouble.DoubleMatrix2D;
import cern.colt.matrix.tdouble.algo.DoubleAlgebra;
import cern.colt.matrix.tdouble.algo.solver.preconditioner.DoublePreconditioner;
import cern.colt.matrix.tdouble.impl.DenseDoubleMatrix1D;
import cern.colt.matrix.tdouble.impl.RCMDoubleMatrix2D;
import cern.colt.matrix.tdouble.impl.SparseDoubleMatrix1D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class DoubleILUT
implements DoublePreconditioner {
    private final RCMDoubleMatrix2D LU;
    private final DoubleMatrix1D y;
    private final double tau;
    private final List<IntDoubleEntry> lower;
    private final List<IntDoubleEntry> upper;
    private final int p;

    public DoubleILUT(RCMDoubleMatrix2D rCMDoubleMatrix2D, double d, int n) {
        if (rCMDoubleMatrix2D.rows() != rCMDoubleMatrix2D.columns()) {
            throw new IllegalArgumentException("ILUT only applies to square matrices");
        }
        this.LU = rCMDoubleMatrix2D;
        this.tau = d;
        this.p = n;
        int n2 = rCMDoubleMatrix2D.rows();
        this.lower = new ArrayList<IntDoubleEntry>(n2);
        this.upper = new ArrayList<IntDoubleEntry>(n2);
        this.y = new DenseDoubleMatrix1D(n2);
    }

    public DoubleILUT(RCMDoubleMatrix2D rCMDoubleMatrix2D) {
        this(rCMDoubleMatrix2D, 1.0E-6, 25);
    }

    public DoubleMatrix1D apply(DoubleMatrix1D doubleMatrix1D, DoubleMatrix1D doubleMatrix1D2) {
        if (doubleMatrix1D2 == null) {
            doubleMatrix1D2 = doubleMatrix1D.like();
        }
        this.unitLowerSolve(doubleMatrix1D, this.y);
        return this.upperSolve(this.y, doubleMatrix1D2);
    }

    public DoubleMatrix1D transApply(DoubleMatrix1D doubleMatrix1D, DoubleMatrix1D doubleMatrix1D2) {
        if (doubleMatrix1D2 == null) {
            doubleMatrix1D2 = doubleMatrix1D.like();
        }
        this.upperTransSolve(doubleMatrix1D, this.y);
        return this.unitLowerTransSolve(this.y, doubleMatrix1D2);
    }

    public void setMatrix(DoubleMatrix2D doubleMatrix2D) {
        this.LU.assign(doubleMatrix2D);
        this.LU.trimToSize();
        this.factor();
    }

    private void factor() {
        int n = this.LU.rows();
        for (int i = 1; i < n; ++i) {
            SparseDoubleMatrix1D sparseDoubleMatrix1D = this.LU.viewRow(i);
            double d = DoubleAlgebra.DEFAULT.norm(sparseDoubleMatrix1D, Norm.Two) * this.tau;
            for (int j = 0; j < i; ++j) {
                SparseDoubleMatrix1D sparseDoubleMatrix1D2 = this.LU.viewRow(j);
                if (sparseDoubleMatrix1D2.getQuick(j) == 0.0) {
                    throw new RuntimeException("Zero diagonal entry on row " + (j + 1) + " during ILU process");
                }
                double d2 = sparseDoubleMatrix1D.getQuick(j) / sparseDoubleMatrix1D2.getQuick(j);
                if (Math.abs(d2) <= d) continue;
                int n2 = sparseDoubleMatrix1D2.size();
                for (int k = j + 1; k < n2; ++k) {
                    sparseDoubleMatrix1D.setQuick(k, sparseDoubleMatrix1D.getQuick(k) - d2 * sparseDoubleMatrix1D2.getQuick(k));
                }
                sparseDoubleMatrix1D.setQuick(j, d2);
            }
            this.gather(sparseDoubleMatrix1D, d, i);
        }
    }

    private void gather(SparseDoubleMatrix1D sparseDoubleMatrix1D, double d, int n) {
        IntDoubleEntry intDoubleEntry;
        int n2;
        int n3 = 0;
        int n4 = 0;
        long[] lArray = sparseDoubleMatrix1D.elements().keys().elements();
        for (int i = 0; i < lArray.length; ++i) {
            if (lArray[i] < (long)n) {
                ++n3;
                continue;
            }
            if (lArray[i] <= (long)n) continue;
            ++n4;
        }
        double[] dArray = sparseDoubleMatrix1D.toArray();
        sparseDoubleMatrix1D.assign(0.0);
        this.lower.clear();
        for (n2 = 0; n2 < n; ++n2) {
            if (!(Math.abs(dArray[n2]) > d)) continue;
            this.lower.add(new IntDoubleEntry(n2, dArray[n2]));
        }
        this.upper.clear();
        for (n2 = n + 1; n2 < dArray.length; ++n2) {
            if (!(Math.abs(dArray[n2]) > d)) continue;
            this.upper.add(new IntDoubleEntry(n2, dArray[n2]));
        }
        Collections.sort(this.lower);
        Collections.sort(this.upper);
        sparseDoubleMatrix1D.setQuick(n, dArray[n]);
        for (n2 = 0; n2 < Math.min(n3 + this.p, this.lower.size()); ++n2) {
            intDoubleEntry = this.lower.get(n2);
            sparseDoubleMatrix1D.setQuick(intDoubleEntry.index, intDoubleEntry.value);
        }
        for (n2 = 0; n2 < Math.min(n4 + this.p, this.upper.size()); ++n2) {
            intDoubleEntry = this.upper.get(n2);
            sparseDoubleMatrix1D.setQuick(intDoubleEntry.index, intDoubleEntry.value);
        }
    }

    private DoubleMatrix1D unitLowerSolve(DoubleMatrix1D doubleMatrix1D, DoubleMatrix1D doubleMatrix1D2) {
        double[] dArray = ((DenseDoubleMatrix1D)doubleMatrix1D).elements();
        double[] dArray2 = ((DenseDoubleMatrix1D)doubleMatrix1D2).elements();
        int n = this.LU.rows();
        for (int i = 0; i < n; ++i) {
            SparseDoubleMatrix1D sparseDoubleMatrix1D = this.LU.viewRow(i);
            double d = 0.0;
            for (int j = 0; j < i; ++j) {
                d += sparseDoubleMatrix1D.getQuick(j) * dArray2[j];
            }
            dArray2[i] = dArray[i] - d;
        }
        return doubleMatrix1D2;
    }

    private DoubleMatrix1D unitLowerTransSolve(DoubleMatrix1D doubleMatrix1D, DoubleMatrix1D doubleMatrix1D2) {
        doubleMatrix1D2.assign(doubleMatrix1D);
        double[] dArray = ((DenseDoubleMatrix1D)doubleMatrix1D2).elements();
        int n = this.LU.rows();
        for (int i = n - 1; i >= 0; --i) {
            SparseDoubleMatrix1D sparseDoubleMatrix1D = this.LU.viewRow(i);
            for (int j = 0; j < i; ++j) {
                int n2 = j;
                dArray[n2] = dArray[n2] - sparseDoubleMatrix1D.getQuick(j) * dArray[i];
            }
        }
        return doubleMatrix1D2;
    }

    private DoubleMatrix1D upperSolve(DoubleMatrix1D doubleMatrix1D, DoubleMatrix1D doubleMatrix1D2) {
        double[] dArray = ((DenseDoubleMatrix1D)doubleMatrix1D).elements();
        double[] dArray2 = ((DenseDoubleMatrix1D)doubleMatrix1D2).elements();
        int n = this.LU.rows();
        for (int i = n - 1; i >= 0; --i) {
            SparseDoubleMatrix1D sparseDoubleMatrix1D = this.LU.viewRow(i);
            int n2 = sparseDoubleMatrix1D.size();
            double d = 0.0;
            for (int j = i + 1; j < n2; ++j) {
                d += sparseDoubleMatrix1D.getQuick(j) * dArray2[j];
            }
            dArray2[i] = (dArray[i] - d) / sparseDoubleMatrix1D.getQuick(i);
        }
        return doubleMatrix1D2;
    }

    private DoubleMatrix1D upperTransSolve(DoubleMatrix1D doubleMatrix1D, DoubleMatrix1D doubleMatrix1D2) {
        doubleMatrix1D2.assign(doubleMatrix1D);
        double[] dArray = ((DenseDoubleMatrix1D)doubleMatrix1D2).elements();
        int n = this.LU.rows();
        for (int i = 0; i < n; ++i) {
            SparseDoubleMatrix1D sparseDoubleMatrix1D = this.LU.viewRow(i);
            int n2 = sparseDoubleMatrix1D.size();
            int n3 = i;
            dArray[n3] = dArray[n3] / sparseDoubleMatrix1D.getQuick(i);
            for (int j = i + 1; j < n2; ++j) {
                int n4 = j;
                dArray[n4] = dArray[n4] - sparseDoubleMatrix1D.getQuick(j) * dArray[i];
            }
        }
        return doubleMatrix1D2;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class IntDoubleEntry
    implements Comparable<IntDoubleEntry> {
        public int index;
        public double value;

        public IntDoubleEntry(int n, double d) {
            this.index = n;
            this.value = d;
        }

        @Override
        public int compareTo(IntDoubleEntry intDoubleEntry) {
            if (Math.abs(this.value) < Math.abs(intDoubleEntry.value)) {
                return 1;
            }
            if (Math.abs(this.value) == Math.abs(intDoubleEntry.value)) {
                return 0;
            }
            return -1;
        }

        public String toString() {
            return "(" + this.index + "=" + this.value + ")";
        }
    }
}

