/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdouble.algo.solver;

import cern.colt.list.tint.IntArrayList;
import cern.colt.matrix.tdouble.DoubleMatrix1D;
import cern.colt.matrix.tdouble.DoubleMatrix2D;
import cern.colt.matrix.tdouble.algo.DoubleAlgebra;
import cern.colt.matrix.tdouble.algo.solver.AbstractDoubleIterativeSolver;
import cern.colt.matrix.tdouble.algo.solver.IterativeSolverDoubleNotConvergedException;
import cern.colt.matrix.tdouble.algo.solver.MRNSDDoubleIterationMonitor;
import cern.colt.matrix.tdouble.algo.solver.preconditioner.DoubleIdentity;
import cern.jet.math.tdouble.DoubleFunctions;

public class DoubleMRNSD
extends AbstractDoubleIterativeSolver {
    private static final DoubleAlgebra alg = DoubleAlgebra.DEFAULT;
    public static final double sqrteps = Math.sqrt(Math.pow(2.0, -52.0));

    public DoubleMRNSD() {
        this.iter = new MRNSDDoubleIterationMonitor();
        ((MRNSDDoubleIterationMonitor)this.iter).setRelativeTolerance(-1.0);
    }

    public DoubleMatrix1D solve(DoubleMatrix2D doubleMatrix2D, DoubleMatrix1D doubleMatrix1D, DoubleMatrix1D doubleMatrix1D2) throws IterativeSolverDoubleNotConvergedException {
        double d;
        double d2;
        double d3;
        if (!(this.iter instanceof MRNSDDoubleIterationMonitor)) {
            this.iter = new MRNSDDoubleIterationMonitor();
            ((MRNSDDoubleIterationMonitor)this.iter).setRelativeTolerance(-1.0);
        }
        double d4 = d3 = sqrteps;
        double[] dArray = doubleMatrix1D2.getMinLocation();
        double d5 = dArray[0];
        if (d5 < 0.0) {
            doubleMatrix1D2.assign(DoubleFunctions.plus(-d5 + d4));
        }
        if (((MRNSDDoubleIterationMonitor)this.iter).getRelativeTolerance() == -1.0) {
            ((MRNSDDoubleIterationMonitor)this.iter).setRelativeTolerance(sqrteps * alg.norm2(doubleMatrix2D.zMult(doubleMatrix1D, null, 1.0, 0.0, true)));
        }
        DoubleMatrix1D doubleMatrix1D3 = doubleMatrix2D.zMult(doubleMatrix1D2, null);
        doubleMatrix1D3.assign(doubleMatrix1D, DoubleFunctions.plusMultFirst(-1.0));
        if (!(this.M instanceof DoubleIdentity)) {
            doubleMatrix1D3 = this.M.apply(doubleMatrix1D3, null);
            doubleMatrix1D3 = this.M.transApply(doubleMatrix1D3, null);
            doubleMatrix1D3 = doubleMatrix2D.zMult(doubleMatrix1D3, null, 1.0, 0.0, true);
            doubleMatrix1D3.assign(DoubleFunctions.neg);
            d2 = doubleMatrix1D2.aggregate(doubleMatrix1D3, DoubleFunctions.plus, DoubleFunctions.multSquare);
            d = alg.norm2(doubleMatrix1D3);
        } else {
            doubleMatrix1D3 = doubleMatrix2D.zMult(doubleMatrix1D3, null, 1.0, 0.0, true);
            doubleMatrix1D3.assign(DoubleFunctions.neg);
            d2 = doubleMatrix1D2.aggregate(doubleMatrix1D3, DoubleFunctions.plus, DoubleFunctions.multSquare);
            d = Math.sqrt(d2);
        }
        IntArrayList intArrayList = new IntArrayList(doubleMatrix1D.size());
        this.iter.setFirst();
        while (!this.iter.converged(d, doubleMatrix1D2)) {
            DoubleMatrix1D doubleMatrix1D4 = doubleMatrix1D2.copy();
            doubleMatrix1D4.assign(doubleMatrix1D3, DoubleFunctions.multNeg);
            DoubleMatrix1D doubleMatrix1D5 = doubleMatrix2D.zMult(doubleMatrix1D4, null);
            if (!(this.M instanceof DoubleIdentity)) {
                doubleMatrix1D5 = this.M.apply(doubleMatrix1D5, null);
            }
            double d6 = d2 / doubleMatrix1D5.aggregate(DoubleFunctions.plus, DoubleFunctions.square);
            doubleMatrix1D4.getNegativeValues(intArrayList, null);
            DoubleMatrix1D doubleMatrix1D6 = doubleMatrix1D2.copy();
            doubleMatrix1D6.assign(doubleMatrix1D4, DoubleFunctions.divNeg, intArrayList);
            double d7 = Math.min(d6, doubleMatrix1D6.aggregate(DoubleFunctions.min, DoubleFunctions.identity, intArrayList));
            doubleMatrix1D2.assign(doubleMatrix1D4, DoubleFunctions.plusMultSecond(d7));
            if (!(this.M instanceof DoubleIdentity)) {
                doubleMatrix1D6 = this.M.transApply(doubleMatrix1D5, null);
                doubleMatrix1D6 = doubleMatrix2D.zMult(doubleMatrix1D5, null, 1.0, 0.0, true);
                doubleMatrix1D3.assign(doubleMatrix1D6, DoubleFunctions.plusMultSecond(d7));
                d2 = doubleMatrix1D2.aggregate(doubleMatrix1D3, DoubleFunctions.plus, DoubleFunctions.multSquare);
                d = alg.norm2(doubleMatrix1D3);
            } else {
                doubleMatrix1D6 = doubleMatrix2D.zMult(doubleMatrix1D5, null, 1.0, 0.0, true);
                doubleMatrix1D3.assign(doubleMatrix1D6, DoubleFunctions.plusMultSecond(d7));
                d2 = doubleMatrix1D2.aggregate(doubleMatrix1D3, DoubleFunctions.plus, DoubleFunctions.multSquare);
                d = Math.sqrt(d2);
            }
            this.iter.next();
        }
        return doubleMatrix1D2;
    }
}

