/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdouble.algo.solver;

import cern.colt.Timer;
import cern.colt.matrix.io.MatrixVectorReader;
import cern.colt.matrix.tdouble.DoubleMatrix1D;
import cern.colt.matrix.tdouble.DoubleMatrix2D;
import cern.colt.matrix.tdouble.algo.solver.DefaultDoubleIterationMonitor;
import cern.colt.matrix.tdouble.algo.solver.DoubleIterationMonitor;
import cern.colt.matrix.tdouble.algo.solver.DoubleIterativeSolver;
import cern.colt.matrix.tdouble.algo.solver.IterativeSolverDoubleNotConvergedException;
import cern.colt.matrix.tdouble.algo.solver.preconditioner.DoublePreconditioner;
import cern.colt.matrix.tdouble.impl.DenseDoubleMatrix1D;
import cern.colt.matrix.tdouble.impl.SparseDoubleMatrix2D;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.RandomAccessFile;
import junit.framework.TestCase;

public abstract class DoubleIterativeSolverBenchmark
extends TestCase {
    protected int repeat;
    protected int[] nthreads;
    protected int maxIter;
    protected DoubleMatrix2D A;
    protected DoubleMatrix1D b;
    protected DoubleMatrix1D x;
    protected DoubleIterativeSolver solver;
    protected DoublePreconditioner M;
    protected DoubleIterationMonitor monitor;
    protected static final Timer t = new Timer();

    public DoubleIterativeSolverBenchmark(String string) {
        super(string);
    }

    protected void setUp() throws Exception {
        this.readIterativeSolverBenchmarkSettings();
        int n = this.A.rows();
        this.x = new DenseDoubleMatrix1D(n);
        this.b = new DenseDoubleMatrix1D(n);
        this.createSolver();
        this.solver.setIterationMonitor(this.monitor);
        this.M.setMatrix(this.A);
        this.solver.setPreconditioner(this.M);
        this.x.assign(1.0);
        this.b = this.A.zMult(this.x, this.b);
        this.x = new DenseDoubleMatrix1D(n);
    }

    protected void tearDown() throws Exception {
        this.x = null;
        this.b = null;
        this.solver = null;
    }

    protected abstract void createSolver() throws Exception;

    public void testBenchmark() {
        System.out.println("Benchmarking " + this.solver.getClass().getName() + " with preconditioner " + this.solver.getPreconditioner().getClass().getName());
        for (int i = 0; i < this.nthreads.length; ++i) {
            System.out.println("\tNumber of threads = " + this.nthreads[i]);
            ConcurrencyUtils.setNumberOfThreads(this.nthreads[i]);
            IterativeSolverDoubleNotConvergedException iterativeSolverDoubleNotConvergedException = null;
            double d = 0.0;
            for (int j = 0; j < this.repeat; ++j) {
                t.reset().start();
                try {
                    this.solver.solve(this.A, this.b, this.x);
                }
                catch (IterativeSolverDoubleNotConvergedException iterativeSolverDoubleNotConvergedException2) {
                    iterativeSolverDoubleNotConvergedException = iterativeSolverDoubleNotConvergedException2;
                }
                t.stop();
                d += t.seconds();
                this.x.assign(0.0);
            }
            if (iterativeSolverDoubleNotConvergedException != null) {
                System.out.println("\t\tSolver did not converge: " + (Object)((Object)iterativeSolverDoubleNotConvergedException.getReason()) + ". Residual=" + iterativeSolverDoubleNotConvergedException.getResidual());
            }
            System.out.println("\t\tNumber of iterations performed = " + this.solver.getIterationMonitor().iterations());
            System.out.println("\t\tAverage execution time = " + d / (double)this.repeat + " seconds");
        }
    }

    private void readIterativeSolverBenchmarkSettings() {
        String string = System.getProperty("iterativeSolverSettingsFile");
        if (string == null) {
            throw new IllegalArgumentException("Property iterativeSolverSettingsFile not found!");
        }
        File file = new File(string);
        if (file.exists()) {
            try {
                RandomAccessFile randomAccessFile = null;
                randomAccessFile = new RandomAccessFile(string, "r");
                String string2 = randomAccessFile.readLine();
                String string3 = string2 = randomAccessFile.readLine();
                MatrixVectorReader matrixVectorReader = new MatrixVectorReader(new BufferedReader(new FileReader(string3)));
                SparseDoubleMatrix2D sparseDoubleMatrix2D = new SparseDoubleMatrix2D(matrixVectorReader);
                this.A = sparseDoubleMatrix2D.convertToRCDoubleMatrix2D();
                string2 = randomAccessFile.readLine();
                this.repeat = Integer.parseInt(string2.trim());
                string2 = randomAccessFile.readLine();
                this.maxIter = Integer.parseInt(string2.trim());
                this.monitor = new DefaultDoubleIterationMonitor(this.maxIter, 0.0, 0.0, Double.MAX_VALUE);
                string2 = randomAccessFile.readLine();
                String[] stringArray = string2.split(",");
                this.nthreads = new int[stringArray.length];
                for (int i = 0; i < stringArray.length; ++i) {
                    this.nthreads[i] = Integer.parseInt(stringArray[i].trim());
                }
                randomAccessFile.close();
                System.out.println("Settings were loaded");
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        } else {
            throw new IllegalArgumentException("The settings file does not exist!");
        }
    }
}

