/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdouble.algo.decomposition;

import cern.colt.matrix.tdouble.DoubleFactory2D;
import cern.colt.matrix.tdouble.DoubleMatrix1D;
import cern.colt.matrix.tdouble.DoubleMatrix2D;
import cern.colt.matrix.tdouble.algo.DoubleProperty;
import cern.jet.math.tdouble.DoubleFunctions;
import java.io.Serializable;

public class DoubleCholeskyDecomposition
implements Serializable {
    static final long serialVersionUID = 1020L;
    private DoubleMatrix2D L;
    private DoubleMatrix2D Lt;
    private int n;
    private boolean isSymmetricPositiveDefinite;

    public DoubleCholeskyDecomposition(DoubleMatrix2D doubleMatrix2D) {
        int n;
        DoubleProperty.DEFAULT.checkSquare(doubleMatrix2D);
        this.n = doubleMatrix2D.rows();
        this.L = doubleMatrix2D.like(this.n, this.n);
        this.isSymmetricPositiveDefinite = doubleMatrix2D.columns() == this.n;
        DoubleMatrix1D[] doubleMatrix1DArray = new DoubleMatrix1D[this.n];
        for (n = 0; n < this.n; ++n) {
            doubleMatrix1DArray[n] = this.L.viewRow(n);
        }
        for (n = 0; n < this.n; ++n) {
            int n2;
            double d = 0.0;
            for (n2 = 0; n2 < n; ++n2) {
                double d2 = doubleMatrix1DArray[n2].zDotProduct(doubleMatrix1DArray[n], 0, n2);
                d2 = (doubleMatrix2D.getQuick(n, n2) - d2) / this.L.getQuick(n2, n2);
                doubleMatrix1DArray[n].setQuick(n2, d2);
                d += d2 * d2;
                this.isSymmetricPositiveDefinite = this.isSymmetricPositiveDefinite && doubleMatrix2D.getQuick(n2, n) == doubleMatrix2D.getQuick(n, n2);
            }
            d = doubleMatrix2D.getQuick(n, n) - d;
            this.isSymmetricPositiveDefinite = this.isSymmetricPositiveDefinite && d > 0.0;
            this.L.setQuick(n, n, Math.sqrt(Math.max(d, 0.0)));
            for (n2 = n + 1; n2 < this.n; ++n2) {
                this.L.setQuick(n, n2, 0.0);
            }
        }
        this.Lt = this.L.viewDice().copy();
    }

    public DoubleMatrix2D getL() {
        return this.L;
    }

    public DoubleMatrix2D getLtranspose() {
        return this.Lt;
    }

    public boolean isSymmetricPositiveDefinite() {
        return this.isSymmetricPositiveDefinite;
    }

    public DoubleMatrix2D solve(DoubleMatrix2D doubleMatrix2D) {
        DoubleMatrix2D doubleMatrix2D2 = doubleMatrix2D.copy();
        int n = doubleMatrix2D.columns();
        for (int i = 0; i < n; ++i) {
            int n2;
            double d;
            int n3;
            for (n3 = 0; n3 < this.n; ++n3) {
                d = doubleMatrix2D.getQuick(n3, i);
                for (n2 = n3 - 1; n2 >= 0; --n2) {
                    d -= this.L.getQuick(n3, n2) * doubleMatrix2D2.getQuick(n2, i);
                }
                doubleMatrix2D2.setQuick(n3, i, d / this.L.getQuick(n3, n3));
            }
            for (n3 = this.n - 1; n3 >= 0; --n3) {
                d = doubleMatrix2D2.getQuick(n3, i);
                for (n2 = n3 + 1; n2 < this.n; ++n2) {
                    d -= this.L.getQuick(n2, n3) * doubleMatrix2D2.getQuick(n2, i);
                }
                doubleMatrix2D2.setQuick(n3, i, d / this.L.getQuick(n3, n3));
            }
        }
        return doubleMatrix2D2;
    }

    public DoubleMatrix1D solve(DoubleMatrix1D doubleMatrix1D) {
        int n;
        double d;
        int n2;
        DoubleMatrix1D doubleMatrix1D2 = doubleMatrix1D.copy();
        for (n2 = 0; n2 < this.n; ++n2) {
            d = doubleMatrix1D.getQuick(n2);
            for (n = n2 - 1; n >= 0; --n) {
                d -= this.L.getQuick(n2, n) * doubleMatrix1D2.getQuick(n);
            }
            doubleMatrix1D2.setQuick(n2, d / this.L.getQuick(n2, n2));
        }
        for (n2 = this.n - 1; n2 >= 0; --n2) {
            d = doubleMatrix1D2.getQuick(n2);
            for (n = n2 + 1; n < this.n; ++n) {
                d -= this.L.getQuick(n, n2) * doubleMatrix1D2.getQuick(n);
            }
            doubleMatrix1D2.setQuick(n2, d / this.L.getQuick(n2, n2));
        }
        return doubleMatrix1D2;
    }

    private DoubleMatrix2D XXXsolveBuggy(DoubleMatrix2D doubleMatrix2D) {
        int n;
        int n2;
        DoubleFunctions doubleFunctions = DoubleFunctions.functions;
        if (doubleMatrix2D.rows() != this.n) {
            throw new IllegalArgumentException("Matrix row dimensions must agree.");
        }
        if (!this.isSymmetricPositiveDefinite) {
            throw new IllegalArgumentException("Matrix is not symmetric positive definite.");
        }
        DoubleMatrix2D doubleMatrix2D2 = doubleMatrix2D.copy();
        int n3 = doubleMatrix2D.columns();
        DoubleMatrix1D[] doubleMatrix1DArray = new DoubleMatrix1D[this.n];
        for (n2 = 0; n2 < this.n; ++n2) {
            doubleMatrix1DArray[n2] = doubleMatrix2D2.viewRow(n2);
        }
        for (n2 = 0; n2 < this.n; ++n2) {
            for (n = n2 + 1; n < this.n; ++n) {
                doubleMatrix1DArray[n].assign(doubleMatrix1DArray[n2], DoubleFunctions.minusMult(this.L.getQuick(n, n2)));
            }
            doubleMatrix1DArray[n2].assign(DoubleFunctions.div(this.L.getQuick(n2, n2)));
        }
        for (n2 = this.n - 1; n2 >= 0; --n2) {
            doubleMatrix1DArray[n2].assign(DoubleFunctions.div(this.L.getQuick(n2, n2)));
            for (n = 0; n < n2; ++n) {
                doubleMatrix1DArray[n].assign(doubleMatrix1DArray[n2], DoubleFunctions.minusMult(this.L.getQuick(n2, n)));
            }
        }
        return doubleMatrix2D2;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = "Illegal operation or error: ";
        stringBuffer.append("--------------------------------------------------------------------------\n");
        stringBuffer.append("CholeskyDecomposition(A) --> isSymmetricPositiveDefinite(A), L, inverse(A)\n");
        stringBuffer.append("--------------------------------------------------------------------------\n");
        stringBuffer.append("isSymmetricPositiveDefinite = ");
        try {
            stringBuffer.append(String.valueOf(this.isSymmetricPositiveDefinite()));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            stringBuffer.append(string + illegalArgumentException.getMessage());
        }
        stringBuffer.append("\n\nL = ");
        try {
            stringBuffer.append(String.valueOf(this.getL()));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            stringBuffer.append(string + illegalArgumentException.getMessage());
        }
        stringBuffer.append("\n\ninverse(A) = ");
        try {
            stringBuffer.append(String.valueOf(this.solve(DoubleFactory2D.dense.identity(this.L.rows()))));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            stringBuffer.append(string + illegalArgumentException.getMessage());
        }
        return stringBuffer.toString();
    }
}

