/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdouble.algo;

import cern.colt.GenericPermuting;
import cern.colt.GenericSorting;
import cern.colt.PersistentObject;
import cern.colt.Swapper;
import cern.colt.function.tdouble.DoubleDoubleFunction;
import cern.colt.function.tint.IntComparator;
import cern.colt.list.tobject.ObjectArrayList;
import cern.colt.matrix.Norm;
import cern.colt.matrix.tbit.QuickBitVector;
import cern.colt.matrix.tdcomplex.DComplexMatrix1D;
import cern.colt.matrix.tdcomplex.DComplexMatrix2D;
import cern.colt.matrix.tdcomplex.impl.DenseDComplexMatrix1D;
import cern.colt.matrix.tdouble.DoubleFactory2D;
import cern.colt.matrix.tdouble.DoubleMatrix1D;
import cern.colt.matrix.tdouble.DoubleMatrix2D;
import cern.colt.matrix.tdouble.DoubleMatrix3D;
import cern.colt.matrix.tdouble.algo.DoubleProperty;
import cern.colt.matrix.tdouble.algo.SmpDoubleBlas;
import cern.colt.matrix.tdouble.algo.decomposition.DoubleCholeskyDecomposition;
import cern.colt.matrix.tdouble.algo.decomposition.DoubleEigenvalueDecomposition;
import cern.colt.matrix.tdouble.algo.decomposition.DoubleLUDecomposition;
import cern.colt.matrix.tdouble.algo.decomposition.DoubleQRDecomposition;
import cern.colt.matrix.tdouble.algo.decomposition.DoubleSingularValueDecomposition;
import cern.colt.matrix.tdouble.algo.decomposition.DoubleSingularValueDecompositionDC;
import cern.colt.matrix.tdouble.impl.DenseDoubleMatrix1D;
import cern.colt.matrix.tdouble.impl.DenseDoubleMatrix2D;
import cern.colt.matrix.tdouble.impl.DenseDoubleMatrix3D;
import cern.jet.math.tdcomplex.DComplex;
import cern.jet.math.tdcomplex.DComplexFunctions;
import cern.jet.math.tdouble.DoubleFunctions;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public class DoubleAlgebra
extends PersistentObject {
    private static final long serialVersionUID = 7387616224214397704L;
    public static final DoubleAlgebra DEFAULT = new DoubleAlgebra();
    public static final DoubleAlgebra ZERO;
    protected DoubleProperty property;

    public DoubleAlgebra() {
        this(DoubleProperty.DEFAULT.tolerance());
    }

    public DoubleAlgebra(double d) {
        this.setProperty(new DoubleProperty(d));
    }

    public DoubleCholeskyDecomposition chol(DoubleMatrix2D doubleMatrix2D) {
        return new DoubleCholeskyDecomposition(doubleMatrix2D);
    }

    public Object clone() {
        return new DoubleAlgebra(this.property.tolerance());
    }

    public double cond(DoubleMatrix2D doubleMatrix2D) {
        return this.svd(doubleMatrix2D).cond();
    }

    public double det(DoubleMatrix2D doubleMatrix2D) {
        return this.lu(doubleMatrix2D).det();
    }

    public DoubleEigenvalueDecomposition eig(DoubleMatrix2D doubleMatrix2D) {
        return new DoubleEigenvalueDecomposition(doubleMatrix2D);
    }

    public static double hypot(double d, double d2) {
        double d3;
        if (Math.abs(d) > Math.abs(d2)) {
            d3 = d2 / d;
            d3 = Math.abs(d) * Math.sqrt(1.0 + d3 * d3);
        } else if (d2 != 0.0) {
            d3 = d / d2;
            d3 = Math.abs(d2) * Math.sqrt(1.0 + d3 * d3);
        } else {
            d3 = 0.0;
        }
        return d3;
    }

    public static DoubleDoubleFunction hypotFunction() {
        return new DoubleDoubleFunction(){

            public final double apply(double d, double d2) {
                return DoubleAlgebra.hypot(d, d2);
            }
        };
    }

    public DoubleMatrix2D inverse(DoubleMatrix2D doubleMatrix2D) {
        if (this.property.isSquare(doubleMatrix2D) && this.property.isDiagonal(doubleMatrix2D)) {
            DoubleMatrix2D doubleMatrix2D2 = doubleMatrix2D.copy();
            boolean bl = true;
            int n = doubleMatrix2D2.rows();
            while (--n >= 0) {
                double d = doubleMatrix2D2.getQuick(n, n);
                bl &= d != 0.0;
                doubleMatrix2D2.setQuick(n, n, 1.0 / d);
            }
            if (!bl) {
                throw new IllegalArgumentException("A is singular.");
            }
            return doubleMatrix2D2;
        }
        return this.solve(doubleMatrix2D, DoubleFactory2D.dense.identity(doubleMatrix2D.rows()));
    }

    public DoubleLUDecomposition lu(DoubleMatrix2D doubleMatrix2D) {
        return new DoubleLUDecomposition(doubleMatrix2D);
    }

    public DComplexMatrix1D kron(DComplexMatrix1D dComplexMatrix1D, DComplexMatrix1D dComplexMatrix1D2) {
        int n = dComplexMatrix1D.size();
        int n2 = dComplexMatrix1D2.size();
        DenseDComplexMatrix1D denseDComplexMatrix1D = new DenseDComplexMatrix1D(n * n2);
        for (int i = 0; i < n; ++i) {
            denseDComplexMatrix1D.viewPart(i * n2, n2).assign(dComplexMatrix1D2);
            denseDComplexMatrix1D.viewPart(i * n2, n2).assign(DComplexFunctions.mult(dComplexMatrix1D.getQuick(i)));
        }
        return denseDComplexMatrix1D;
    }

    public DoubleMatrix1D kron(double[] dArray, double[] dArray2) {
        int n = dArray.length;
        int n2 = dArray2.length;
        DenseDoubleMatrix1D denseDoubleMatrix1D = new DenseDoubleMatrix1D(n * n2);
        for (int i = 0; i < n; ++i) {
            denseDoubleMatrix1D.viewPart(i * n2, n2).assign(dArray2);
            denseDoubleMatrix1D.viewPart(i * n2, n2).assign(DoubleFunctions.mult(dArray[i]));
        }
        return denseDoubleMatrix1D;
    }

    public DoubleMatrix1D kron(DoubleMatrix1D doubleMatrix1D, DoubleMatrix1D doubleMatrix1D2) {
        int n = doubleMatrix1D.size();
        int n2 = doubleMatrix1D2.size();
        DenseDoubleMatrix1D denseDoubleMatrix1D = new DenseDoubleMatrix1D(n * n2);
        for (int i = 0; i < n; ++i) {
            denseDoubleMatrix1D.viewPart(i * n2, n2).assign(doubleMatrix1D2);
            denseDoubleMatrix1D.viewPart(i * n2, n2).assign(DoubleFunctions.mult(doubleMatrix1D.getQuick(i)));
        }
        return denseDoubleMatrix1D;
    }

    public double mult(DoubleMatrix1D doubleMatrix1D, DoubleMatrix1D doubleMatrix1D2) {
        return doubleMatrix1D.zDotProduct(doubleMatrix1D2);
    }

    public DoubleMatrix1D mult(DoubleMatrix2D doubleMatrix2D, DoubleMatrix1D doubleMatrix1D) {
        return doubleMatrix2D.zMult(doubleMatrix1D, null);
    }

    public DoubleMatrix2D mult(DoubleMatrix2D doubleMatrix2D, DoubleMatrix2D doubleMatrix2D2) {
        return doubleMatrix2D.zMult(doubleMatrix2D2, null);
    }

    public DoubleMatrix2D multOuter(DoubleMatrix1D doubleMatrix1D, DoubleMatrix1D doubleMatrix1D2, DoubleMatrix2D doubleMatrix2D) {
        int n = doubleMatrix1D.size();
        int n2 = doubleMatrix1D2.size();
        if (doubleMatrix2D == null) {
            doubleMatrix2D = doubleMatrix1D.like2D(n, n2);
        }
        if (doubleMatrix2D.rows() != n || doubleMatrix2D.columns() != n2) {
            throw new IllegalArgumentException();
        }
        int n3 = n;
        while (--n3 >= 0) {
            doubleMatrix2D.viewRow(n3).assign(doubleMatrix1D2);
        }
        n3 = n2;
        while (--n3 >= 0) {
            doubleMatrix2D.viewColumn(n3).assign(doubleMatrix1D, DoubleFunctions.mult);
        }
        return doubleMatrix2D;
    }

    public double norm1(DoubleMatrix1D doubleMatrix1D) {
        if (doubleMatrix1D.size() == 0) {
            return 0.0;
        }
        return doubleMatrix1D.aggregate(DoubleFunctions.plus, DoubleFunctions.abs);
    }

    public double norm1(DoubleMatrix2D doubleMatrix2D) {
        double d = 0.0;
        int n = doubleMatrix2D.columns();
        while (--n >= 0) {
            d = Math.max(d, this.norm1(doubleMatrix2D.viewColumn(n)));
        }
        return d;
    }

    public double norm2(DoubleMatrix1D doubleMatrix1D) {
        return Math.sqrt(doubleMatrix1D.zDotProduct(doubleMatrix1D));
    }

    public double vectorNorm2(final DoubleMatrix2D doubleMatrix2D) {
        if (doubleMatrix2D.isView() || !(doubleMatrix2D instanceof DenseDoubleMatrix2D)) {
            int n = doubleMatrix2D.rows();
            final int n2 = doubleMatrix2D.columns();
            double d = 0.0;
            int n3 = ConcurrencyUtils.getNumberOfThreads();
            if (n3 > 1 && n * n2 >= ConcurrencyUtils.getThreadsBeginN_2D()) {
                int n4;
                Future[] futureArray = new Future[n3];
                int n5 = n / n3;
                for (n4 = 0; n4 < n3; ++n4) {
                    final int n6 = n4 * n5;
                    final int n7 = n4 == n3 - 1 ? n : n6 + n5;
                    futureArray[n4] = ConcurrencyUtils.submit(new Callable<Double>(){

                        @Override
                        public Double call() throws Exception {
                            double d = 0.0;
                            for (int i = n6; i < n7; ++i) {
                                for (int j = 0; j < n2; ++j) {
                                    double d2 = doubleMatrix2D.getQuick(i, j);
                                    d += d2 * d2;
                                }
                            }
                            return d;
                        }
                    });
                }
                try {
                    for (n4 = 0; n4 < n3; ++n4) {
                        Double d2 = (Double)futureArray[n4].get();
                        d += d2.doubleValue();
                    }
                }
                catch (ExecutionException executionException) {
                    executionException.printStackTrace();
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            } else {
                for (int i = 0; i < n; ++i) {
                    for (int j = 0; j < n2; ++j) {
                        double d3 = doubleMatrix2D.getQuick(i, j);
                        d += d3 * d3;
                    }
                }
            }
            return Math.sqrt(d);
        }
        final double[] dArray = ((DenseDoubleMatrix2D)doubleMatrix2D).elements();
        double d = 0.0;
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && dArray.length >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            int n8;
            Future[] futureArray = new Future[n];
            int n9 = dArray.length / n;
            for (n8 = 0; n8 < n; ++n8) {
                final int n10 = n8 * n9;
                final int n11 = n8 == n - 1 ? dArray.length : n10 + n9;
                futureArray[n8] = ConcurrencyUtils.submit(new Callable<Double>(){

                    @Override
                    public Double call() throws Exception {
                        double d = 0.0;
                        for (int i = n10; i < n11; ++i) {
                            d += dArray[i] * dArray[i];
                        }
                        return d;
                    }
                });
            }
            try {
                for (n8 = 0; n8 < n; ++n8) {
                    Double d4 = (Double)futureArray[n8].get();
                    d += d4.doubleValue();
                }
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        } else {
            for (int i = 0; i < dArray.length; ++i) {
                d += dArray[i] * dArray[i];
            }
        }
        return Math.sqrt(d);
    }

    public double vectorNorm2(final DoubleMatrix3D doubleMatrix3D) {
        if (doubleMatrix3D.isView() || !(doubleMatrix3D instanceof DenseDoubleMatrix3D)) {
            int n = doubleMatrix3D.slices();
            final int n2 = doubleMatrix3D.rows();
            final int n3 = doubleMatrix3D.columns();
            double d = 0.0;
            int n4 = ConcurrencyUtils.getNumberOfThreads();
            if (n4 > 1 && n2 * n3 >= ConcurrencyUtils.getThreadsBeginN_2D()) {
                int n5;
                Future[] futureArray = new Future[n4];
                int n6 = n / n4;
                for (n5 = 0; n5 < n4; ++n5) {
                    final int n7 = n5 * n6;
                    final int n8 = n5 == n4 - 1 ? n : n7 + n6;
                    futureArray[n5] = ConcurrencyUtils.submit(new Callable<Double>(){

                        @Override
                        public Double call() throws Exception {
                            double d = 0.0;
                            for (int i = n7; i < n8; ++i) {
                                for (int j = 0; j < n2; ++j) {
                                    for (int k = 0; k < n3; ++k) {
                                        double d2 = doubleMatrix3D.getQuick(i, j, k);
                                        d += d2 * d2;
                                    }
                                }
                            }
                            return d;
                        }
                    });
                }
                try {
                    for (n5 = 0; n5 < n4; ++n5) {
                        Double d2 = (Double)futureArray[n5].get();
                        d += d2.doubleValue();
                    }
                }
                catch (ExecutionException executionException) {
                    executionException.printStackTrace();
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            } else {
                for (int i = 0; i < n; ++i) {
                    for (int j = 0; j < n2; ++j) {
                        for (int k = 0; k < n3; ++k) {
                            double d3 = doubleMatrix3D.getQuick(i, j, k);
                            d += d3 * d3;
                        }
                    }
                }
            }
            return Math.sqrt(d);
        }
        final double[] dArray = ((DenseDoubleMatrix3D)doubleMatrix3D).elements();
        double d = 0.0;
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && dArray.length >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            int n9;
            Future[] futureArray = new Future[n];
            int n10 = dArray.length / n;
            for (n9 = 0; n9 < n; ++n9) {
                final int n11 = n9 * n10;
                final int n12 = n9 == n - 1 ? dArray.length : n11 + n10;
                futureArray[n9] = ConcurrencyUtils.submit(new Callable<Double>(){

                    @Override
                    public Double call() throws Exception {
                        double d = 0.0;
                        for (int i = n11; i < n12; ++i) {
                            d += dArray[i] * dArray[i];
                        }
                        return d;
                    }
                });
            }
            try {
                for (n9 = 0; n9 < n; ++n9) {
                    Double d4 = (Double)futureArray[n9].get();
                    d += d4.doubleValue();
                }
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        } else {
            for (int i = 0; i < dArray.length; ++i) {
                d += dArray[i] * dArray[i];
            }
        }
        return Math.sqrt(d);
    }

    public double norm(DoubleMatrix2D doubleMatrix2D, Norm norm) {
        switch (norm) {
            case Frobenius: {
                return DEFAULT.normF(doubleMatrix2D);
            }
            case Infinity: {
                return DEFAULT.normInfinity(doubleMatrix2D);
            }
            case One: {
                return DEFAULT.norm1(doubleMatrix2D);
            }
            case Two: {
                return DEFAULT.norm2(doubleMatrix2D);
            }
        }
        return 0.0;
    }

    public double norm(DoubleMatrix1D doubleMatrix1D, Norm norm) {
        switch (norm) {
            case Frobenius: {
                return DEFAULT.normF(doubleMatrix1D);
            }
            case Infinity: {
                return DEFAULT.normInfinity(doubleMatrix1D);
            }
            case One: {
                return DEFAULT.norm1(doubleMatrix1D);
            }
            case Two: {
                return DEFAULT.norm2(doubleMatrix1D);
            }
        }
        return 0.0;
    }

    public double norm2(DoubleMatrix2D doubleMatrix2D) {
        return this.svd(doubleMatrix2D).norm2();
    }

    public double normF(DoubleMatrix2D doubleMatrix2D) {
        if (doubleMatrix2D.size() == 0) {
            return 0.0;
        }
        return doubleMatrix2D.aggregate(DoubleAlgebra.hypotFunction(), DoubleFunctions.identity);
    }

    public double normF(DoubleMatrix1D doubleMatrix1D) {
        if (doubleMatrix1D.size() == 0) {
            return 0.0;
        }
        return doubleMatrix1D.aggregate(DoubleAlgebra.hypotFunction(), DoubleFunctions.identity);
    }

    public double normF(DComplexMatrix2D dComplexMatrix2D) {
        if (dComplexMatrix2D.size() == 0) {
            return 0.0;
        }
        int n = dComplexMatrix2D.rows();
        int n2 = dComplexMatrix2D.columns();
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                double d2 = DComplex.abs(dComplexMatrix2D.getQuick(i, j));
                d += d2 * d2;
            }
        }
        return Math.sqrt(d);
    }

    public double normInfinity(DoubleMatrix1D doubleMatrix1D) {
        if (doubleMatrix1D.size() == 0) {
            return 0.0;
        }
        return doubleMatrix1D.aggregate(DoubleFunctions.max, DoubleFunctions.abs);
    }

    public double normInfinity(DoubleMatrix2D doubleMatrix2D) {
        double d = 0.0;
        int n = doubleMatrix2D.rows();
        while (--n >= 0) {
            d = Math.max(d, this.norm1(doubleMatrix2D.viewRow(n)));
        }
        return d;
    }

    public DoubleMatrix1D permute(DoubleMatrix1D doubleMatrix1D, int[] nArray, double[] dArray) {
        int n = doubleMatrix1D.size();
        if (nArray.length != n) {
            throw new IndexOutOfBoundsException("invalid permutation");
        }
        if (dArray == null || n > dArray.length) {
            dArray = doubleMatrix1D.toArray();
        } else {
            doubleMatrix1D.toArray(dArray);
        }
        int n2 = n;
        while (--n2 >= 0) {
            doubleMatrix1D.setQuick(n2, dArray[nArray[n2]]);
        }
        return doubleMatrix1D;
    }

    public DoubleMatrix2D permute(DoubleMatrix2D doubleMatrix2D, int[] nArray, int[] nArray2) {
        return doubleMatrix2D.viewSelection(nArray, nArray2);
    }

    public DoubleMatrix2D permuteColumns(DoubleMatrix2D doubleMatrix2D, int[] nArray, int[] nArray2) {
        return this.permuteRows(doubleMatrix2D.viewDice(), nArray, nArray2);
    }

    public DoubleMatrix2D permuteRows(final DoubleMatrix2D doubleMatrix2D, int[] nArray, int[] nArray2) {
        int n = doubleMatrix2D.rows();
        if (nArray.length != n) {
            throw new IndexOutOfBoundsException("invalid permutation");
        }
        int n2 = doubleMatrix2D.columns();
        if (n2 < n / 10) {
            double[] dArray = new double[n];
            int n3 = doubleMatrix2D.columns();
            while (--n3 >= 0) {
                this.permute(doubleMatrix2D.viewColumn(n3), nArray, dArray);
            }
            return doubleMatrix2D;
        }
        Swapper swapper = new Swapper(){

            public void swap(int n, int n2) {
                doubleMatrix2D.viewRow(n).swap(doubleMatrix2D.viewRow(n2));
            }
        };
        GenericPermuting.permute(nArray, swapper, nArray2, null);
        return doubleMatrix2D;
    }

    public DoubleMatrix2D pow(DoubleMatrix2D doubleMatrix2D, int n) {
        DoubleMatrix2D doubleMatrix2D2;
        int n2;
        SmpDoubleBlas smpDoubleBlas = new SmpDoubleBlas();
        DoubleProperty.DEFAULT.checkSquare(doubleMatrix2D);
        if (n < 0) {
            doubleMatrix2D = this.inverse(doubleMatrix2D);
            n = -n;
        }
        if (n == 0) {
            return DoubleFactory2D.dense.identity(doubleMatrix2D.rows());
        }
        DoubleMatrix2D doubleMatrix2D3 = doubleMatrix2D.like();
        if (n == 1) {
            return doubleMatrix2D3.assign(doubleMatrix2D);
        }
        if (n == 2) {
            smpDoubleBlas.dgemm(false, false, 1.0, doubleMatrix2D, doubleMatrix2D, 0.0, doubleMatrix2D3);
            return doubleMatrix2D3;
        }
        int n3 = QuickBitVector.mostSignificantBit(n);
        for (n2 = 0; n2 <= n3 && (n & 1 << n2) == 0; ++n2) {
            smpDoubleBlas.dgemm(false, false, 1.0, doubleMatrix2D, doubleMatrix2D, 0.0, doubleMatrix2D3);
            doubleMatrix2D2 = doubleMatrix2D;
            doubleMatrix2D = doubleMatrix2D3;
            doubleMatrix2D3 = doubleMatrix2D2;
        }
        doubleMatrix2D2 = doubleMatrix2D.copy();
        ++n2;
        while (n2 <= n3) {
            smpDoubleBlas.dgemm(false, false, 1.0, doubleMatrix2D, doubleMatrix2D, 0.0, doubleMatrix2D3);
            DoubleMatrix2D doubleMatrix2D4 = doubleMatrix2D;
            doubleMatrix2D = doubleMatrix2D3;
            doubleMatrix2D3 = doubleMatrix2D4;
            if ((n & 1 << n2) != 0) {
                smpDoubleBlas.dgemm(false, false, 1.0, doubleMatrix2D2, doubleMatrix2D, 0.0, doubleMatrix2D3);
                doubleMatrix2D4 = doubleMatrix2D2;
                doubleMatrix2D2 = doubleMatrix2D3;
                doubleMatrix2D3 = doubleMatrix2D4;
            }
            ++n2;
        }
        return doubleMatrix2D2;
    }

    public DoubleProperty property() {
        return this.property;
    }

    public DoubleQRDecomposition qr(DoubleMatrix2D doubleMatrix2D) {
        return new DoubleQRDecomposition(doubleMatrix2D);
    }

    public int rank(DoubleMatrix2D doubleMatrix2D) {
        return this.svd(doubleMatrix2D).rank();
    }

    public void setProperty(DoubleProperty doubleProperty) {
        if (this == DEFAULT && doubleProperty != this.property) {
            throw new IllegalArgumentException("Attempted to modify immutable object.");
        }
        if (this == ZERO && doubleProperty != this.property) {
            throw new IllegalArgumentException("Attempted to modify immutable object.");
        }
        this.property = doubleProperty;
    }

    public DoubleMatrix1D backwardSolve(DoubleMatrix2D doubleMatrix2D, DoubleMatrix1D doubleMatrix1D) {
        int n = doubleMatrix2D.rows();
        DoubleMatrix1D doubleMatrix1D2 = doubleMatrix1D.like();
        doubleMatrix1D2.setQuick(n - 1, doubleMatrix1D.getQuick(n - 1) / doubleMatrix2D.getQuick(n - 1, n - 1));
        for (int i = n - 2; i >= 0; --i) {
            double d = doubleMatrix2D.viewRow(i).zDotProduct(doubleMatrix1D2);
            doubleMatrix1D2.setQuick(i, (doubleMatrix1D.getQuick(i) - d) / doubleMatrix2D.getQuick(i, i));
        }
        return doubleMatrix1D2;
    }

    public DoubleMatrix1D forwardSolve(DoubleMatrix2D doubleMatrix2D, DoubleMatrix1D doubleMatrix1D) {
        int n = doubleMatrix2D.rows();
        DoubleMatrix1D doubleMatrix1D2 = doubleMatrix1D.like();
        doubleMatrix1D2.setQuick(0, doubleMatrix1D.getQuick(0) / doubleMatrix2D.getQuick(0, 0));
        for (int i = 1; i < n; ++i) {
            double d = doubleMatrix2D.viewRow(i).zDotProduct(doubleMatrix1D2);
            doubleMatrix1D2.setQuick(i, (doubleMatrix1D.getQuick(i) - d) / doubleMatrix2D.getQuick(i, i));
        }
        return doubleMatrix1D2;
    }

    public DoubleMatrix1D solve(DoubleMatrix2D doubleMatrix2D, DoubleMatrix1D doubleMatrix1D) {
        return doubleMatrix2D.rows() == doubleMatrix2D.columns() ? this.lu(doubleMatrix2D).solve(doubleMatrix1D) : this.qr(doubleMatrix2D).solve(doubleMatrix1D);
    }

    public DoubleMatrix2D solve(DoubleMatrix2D doubleMatrix2D, DoubleMatrix2D doubleMatrix2D2) {
        return doubleMatrix2D.rows() == doubleMatrix2D.columns() ? this.lu(doubleMatrix2D).solve(doubleMatrix2D2) : this.qr(doubleMatrix2D).solve(doubleMatrix2D2);
    }

    public DoubleMatrix2D solveTranspose(DoubleMatrix2D doubleMatrix2D, DoubleMatrix2D doubleMatrix2D2) {
        return this.solve(this.transpose(doubleMatrix2D), this.transpose(doubleMatrix2D2));
    }

    public DoubleMatrix2D subMatrix(DoubleMatrix2D doubleMatrix2D, int[] nArray, int n, int n2) {
        int n3 = n2 - n + 1;
        int n4 = doubleMatrix2D.rows();
        doubleMatrix2D = doubleMatrix2D.viewPart(0, n, n4, n3);
        DoubleMatrix2D doubleMatrix2D2 = doubleMatrix2D.like(nArray.length, n3);
        int n5 = nArray.length;
        while (--n5 >= 0) {
            int n6 = nArray[n5];
            if (n6 < 0 || n6 >= n4) {
                throw new IndexOutOfBoundsException("Illegal Index");
            }
            doubleMatrix2D2.viewRow(n5).assign(doubleMatrix2D.viewRow(n6));
        }
        return doubleMatrix2D2;
    }

    public DoubleMatrix2D subMatrix(DoubleMatrix2D doubleMatrix2D, int n, int n2, int[] nArray) {
        if (n2 - n >= doubleMatrix2D.rows()) {
            throw new IndexOutOfBoundsException("Too many rows");
        }
        int n3 = n2 - n + 1;
        int n4 = doubleMatrix2D.columns();
        doubleMatrix2D = doubleMatrix2D.viewPart(n, 0, n3, n4);
        DoubleMatrix2D doubleMatrix2D2 = doubleMatrix2D.like(n3, nArray.length);
        int n5 = nArray.length;
        while (--n5 >= 0) {
            int n6 = nArray[n5];
            if (n6 < 0 || n6 >= n4) {
                throw new IndexOutOfBoundsException("Illegal Index");
            }
            doubleMatrix2D2.viewColumn(n5).assign(doubleMatrix2D.viewColumn(n6));
        }
        return doubleMatrix2D2;
    }

    public DoubleMatrix2D subMatrix(DoubleMatrix2D doubleMatrix2D, int n, int n2, int n3, int n4) {
        return doubleMatrix2D.viewPart(n, n3, n2 - n + 1, n4 - n3 + 1);
    }

    public DoubleSingularValueDecomposition svd(DoubleMatrix2D doubleMatrix2D) {
        return new DoubleSingularValueDecomposition(doubleMatrix2D);
    }

    public DoubleSingularValueDecompositionDC svdDC(DoubleMatrix2D doubleMatrix2D) {
        return new DoubleSingularValueDecompositionDC(doubleMatrix2D, true, true);
    }

    public String toString(DoubleMatrix2D doubleMatrix2D) {
        int n;
        final ObjectArrayList objectArrayList = new ObjectArrayList();
        final ObjectArrayList objectArrayList2 = new ObjectArrayList();
        String string = "Illegal operation or error: ";
        objectArrayList.add("cond");
        try {
            objectArrayList2.add(String.valueOf(this.cond(doubleMatrix2D)));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            objectArrayList2.add(string + illegalArgumentException.getMessage());
        }
        objectArrayList.add("det");
        try {
            objectArrayList2.add(String.valueOf(this.det(doubleMatrix2D)));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            objectArrayList2.add(string + illegalArgumentException.getMessage());
        }
        objectArrayList.add("norm1");
        try {
            objectArrayList2.add(String.valueOf(this.norm1(doubleMatrix2D)));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            objectArrayList2.add(string + illegalArgumentException.getMessage());
        }
        objectArrayList.add("norm2");
        try {
            objectArrayList2.add(String.valueOf(this.norm2(doubleMatrix2D)));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            objectArrayList2.add(string + illegalArgumentException.getMessage());
        }
        objectArrayList.add("normF");
        try {
            objectArrayList2.add(String.valueOf(this.normF(doubleMatrix2D)));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            objectArrayList2.add(string + illegalArgumentException.getMessage());
        }
        objectArrayList.add("normInfinity");
        try {
            objectArrayList2.add(String.valueOf(this.normInfinity(doubleMatrix2D)));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            objectArrayList2.add(string + illegalArgumentException.getMessage());
        }
        objectArrayList.add("rank");
        try {
            objectArrayList2.add(String.valueOf(this.rank(doubleMatrix2D)));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            objectArrayList2.add(string + illegalArgumentException.getMessage());
        }
        objectArrayList.add("trace");
        try {
            objectArrayList2.add(String.valueOf(this.trace(doubleMatrix2D)));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            objectArrayList2.add(string + illegalArgumentException.getMessage());
        }
        IntComparator intComparator = new IntComparator(){

            public int compare(int n, int n2) {
                return DoubleProperty.get(objectArrayList, n).compareTo(DoubleProperty.get(objectArrayList, n2));
            }
        };
        Swapper swapper = new Swapper(){

            public void swap(int n, int n2) {
                Object object = objectArrayList.get(n);
                objectArrayList.set(n, objectArrayList.get(n2));
                objectArrayList.set(n2, object);
                object = objectArrayList2.get(n);
                objectArrayList2.set(n, objectArrayList2.get(n2));
                objectArrayList2.set(n2, object);
            }
        };
        GenericSorting.quickSort(0, objectArrayList.size(), intComparator, swapper);
        int n2 = 0;
        for (int i = 0; i < objectArrayList.size(); ++i) {
            n = ((String)objectArrayList.get(i)).length();
            n2 = Math.max(n, n2);
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (n = 0; n < objectArrayList.size(); ++n) {
            String string2 = (String)objectArrayList.get(n);
            stringBuffer.append(string2);
            stringBuffer.append(DoubleProperty.blanks(n2 - string2.length()));
            stringBuffer.append(" : ");
            stringBuffer.append(objectArrayList2.get(n));
            if (n >= objectArrayList.size() - 1) continue;
            stringBuffer.append('\n');
        }
        return stringBuffer.toString();
    }

    public String toVerboseString(DoubleMatrix2D doubleMatrix2D) {
        String string = "Illegal operation or error upon construction of ";
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("A = ");
        stringBuffer.append(doubleMatrix2D);
        stringBuffer.append("\n\n" + this.toString(doubleMatrix2D));
        stringBuffer.append("\n\n" + DoubleProperty.DEFAULT.toString(doubleMatrix2D));
        DoubleLUDecomposition doubleLUDecomposition = null;
        try {
            doubleLUDecomposition = new DoubleLUDecomposition(doubleMatrix2D);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            stringBuffer.append("\n\n" + string + " LUDecomposition: " + illegalArgumentException.getMessage());
        }
        if (doubleLUDecomposition != null) {
            stringBuffer.append("\n\n" + doubleLUDecomposition.toString());
        }
        DoubleQRDecomposition doubleQRDecomposition = null;
        try {
            doubleQRDecomposition = new DoubleQRDecomposition(doubleMatrix2D);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            stringBuffer.append("\n\n" + string + " QRDecomposition: " + illegalArgumentException.getMessage());
        }
        if (doubleQRDecomposition != null) {
            stringBuffer.append("\n\n" + doubleQRDecomposition.toString());
        }
        DoubleCholeskyDecomposition doubleCholeskyDecomposition = null;
        try {
            doubleCholeskyDecomposition = new DoubleCholeskyDecomposition(doubleMatrix2D);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            stringBuffer.append("\n\n" + string + " CholeskyDecomposition: " + illegalArgumentException.getMessage());
        }
        if (doubleCholeskyDecomposition != null) {
            stringBuffer.append("\n\n" + doubleCholeskyDecomposition.toString());
        }
        DoubleEigenvalueDecomposition doubleEigenvalueDecomposition = null;
        try {
            doubleEigenvalueDecomposition = new DoubleEigenvalueDecomposition(doubleMatrix2D);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            stringBuffer.append("\n\n" + string + " EigenvalueDecomposition: " + illegalArgumentException.getMessage());
        }
        if (doubleEigenvalueDecomposition != null) {
            stringBuffer.append("\n\n" + doubleEigenvalueDecomposition.toString());
        }
        DoubleSingularValueDecomposition doubleSingularValueDecomposition = null;
        try {
            doubleSingularValueDecomposition = new DoubleSingularValueDecomposition(doubleMatrix2D);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            stringBuffer.append("\n\n" + string + " SingularValueDecomposition: " + illegalArgumentException.getMessage());
        }
        if (doubleSingularValueDecomposition != null) {
            stringBuffer.append("\n\n" + doubleSingularValueDecomposition.toString());
        }
        return stringBuffer.toString();
    }

    public double trace(DoubleMatrix2D doubleMatrix2D) {
        double d = 0.0;
        int n = Math.min(doubleMatrix2D.rows(), doubleMatrix2D.columns());
        while (--n >= 0) {
            d += doubleMatrix2D.getQuick(n, n);
        }
        return d;
    }

    public DoubleMatrix2D transpose(DoubleMatrix2D doubleMatrix2D) {
        return doubleMatrix2D.viewDice();
    }

    public DoubleMatrix2D trapezoidalLower(DoubleMatrix2D doubleMatrix2D) {
        int n = doubleMatrix2D.rows();
        int n2 = doubleMatrix2D.columns();
        int n3 = n;
        while (--n3 >= 0) {
            int n4 = n2;
            while (--n4 >= 0) {
                if (n3 >= n4) continue;
                doubleMatrix2D.setQuick(n3, n4, 0.0);
            }
        }
        return doubleMatrix2D;
    }

    public DoubleMatrix2D xmultOuter(DoubleMatrix1D doubleMatrix1D, DoubleMatrix1D doubleMatrix1D2) {
        DoubleMatrix2D doubleMatrix2D = doubleMatrix1D.like2D(doubleMatrix1D.size(), doubleMatrix1D2.size());
        this.multOuter(doubleMatrix1D, doubleMatrix1D2, doubleMatrix2D);
        return doubleMatrix2D;
    }

    public DoubleMatrix2D xpowSlow(DoubleMatrix2D doubleMatrix2D, int n) {
        DoubleMatrix2D doubleMatrix2D2 = doubleMatrix2D.copy();
        for (int i = 0; i < n - 1; ++i) {
            doubleMatrix2D2 = this.mult(doubleMatrix2D2, doubleMatrix2D);
        }
        return doubleMatrix2D2;
    }

    static {
        DoubleAlgebra.DEFAULT.property = DoubleProperty.DEFAULT;
        ZERO = new DoubleAlgebra();
        DoubleAlgebra.ZERO.property = DoubleProperty.ZERO;
    }
}

