/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdouble;

import cern.colt.function.tdouble.DoubleProcedure;
import cern.colt.list.tdouble.DoubleArrayList;
import cern.colt.list.tint.IntArrayList;
import cern.colt.matrix.tdouble.DoubleMatrix1D;
import cern.colt.matrix.tdouble.DoubleMatrix2D;
import cern.colt.matrix.tdouble.DoubleMatrix2DProcedure;
import cern.colt.matrix.tdouble.DoubleMatrix3D;
import cern.jet.math.tdouble.DoubleFunctions;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import junit.framework.TestCase;

public abstract class DoubleMatrix3DTest
extends TestCase {
    protected DoubleMatrix3D A;
    protected DoubleMatrix3D B;
    protected int NSLICES = 5;
    protected int NROWS = 13;
    protected int NCOLUMNS = 17;
    protected double TOL = 1.0E-10;

    public DoubleMatrix3DTest(String string) {
        super(string);
    }

    protected void setUp() throws Exception {
        this.createMatrices();
        this.populateMatrices();
    }

    protected abstract void createMatrices() throws Exception;

    protected void populateMatrices() {
        int n;
        int n2;
        int n3;
        ConcurrencyUtils.setThreadsBeginN_3D(1);
        for (n3 = 0; n3 < this.NSLICES; ++n3) {
            for (n2 = 0; n2 < this.NROWS; ++n2) {
                for (n = 0; n < this.NCOLUMNS; ++n) {
                    this.A.setQuick(n3, n2, n, Math.random());
                }
            }
        }
        for (n3 = 0; n3 < this.NSLICES; ++n3) {
            for (n2 = 0; n2 < this.NROWS; ++n2) {
                for (n = 0; n < this.NCOLUMNS; ++n) {
                    this.B.setQuick(n3, n2, n, Math.random());
                }
            }
        }
    }

    protected void tearDown() throws Exception {
        this.B = null;
        this.A = null;
    }

    public void testAggregateDoubleDoubleFunctionDoubleFunction() {
        double d = 0.0;
        for (int i = 0; i < this.NSLICES; ++i) {
            for (int j = 0; j < this.NROWS; ++j) {
                for (int k = 0; k < this.NCOLUMNS; ++k) {
                    double d2 = this.A.getQuick(i, j, k);
                    d += d2 * d2;
                }
            }
        }
        double d3 = this.A.aggregate(DoubleFunctions.plus, DoubleFunctions.square);
        DoubleMatrix3DTest.assertEquals((double)d, (double)d3, (double)this.TOL);
    }

    public void testAggregateDoubleDoubleFunctionDoubleFunctionDoubleProcedure() {
        DoubleProcedure doubleProcedure = new DoubleProcedure(){

            public boolean apply(double d) {
                return Math.abs(d) > 0.2;
            }
        };
        double d = 0.0;
        for (int i = 0; i < this.NSLICES; ++i) {
            for (int j = 0; j < this.NROWS; ++j) {
                for (int k = 0; k < this.NCOLUMNS; ++k) {
                    double d2 = this.A.getQuick(i, j, k);
                    if (!(Math.abs(d2) > 0.2)) continue;
                    d += d2 * d2;
                }
            }
        }
        double d3 = this.A.aggregate(DoubleFunctions.plus, DoubleFunctions.square, doubleProcedure);
        DoubleMatrix3DTest.assertEquals((double)d, (double)d3, (double)this.TOL);
    }

    public void testAggregateDoubleDoubleFunctionDoubleFunctionIntArrayListIntArrayListIntArrayList() {
        int n;
        IntArrayList intArrayList = new IntArrayList();
        IntArrayList intArrayList2 = new IntArrayList();
        IntArrayList intArrayList3 = new IntArrayList();
        for (int i = 0; i < this.NSLICES; ++i) {
            for (int j = 0; j < this.NROWS; ++j) {
                for (n = 0; n < this.NCOLUMNS; ++n) {
                    intArrayList.add(i);
                    intArrayList2.add(j);
                    intArrayList3.add(n);
                }
            }
        }
        double d = 0.0;
        for (n = 0; n < this.NSLICES; ++n) {
            for (int i = 0; i < this.NROWS; ++i) {
                for (int j = 0; j < this.NCOLUMNS; ++j) {
                    double d2 = this.A.getQuick(n, i, j);
                    d += d2 * d2;
                }
            }
        }
        double d3 = this.A.aggregate(DoubleFunctions.plus, DoubleFunctions.square, intArrayList, intArrayList2, intArrayList3);
        DoubleMatrix3DTest.assertEquals((double)d, (double)d3, (double)this.TOL);
    }

    public void testAggregateDoubleMatrix2DDoubleDoubleFunctionDoubleDoubleFunction() {
        double d = 0.0;
        for (int i = 0; i < this.NSLICES; ++i) {
            for (int j = 0; j < this.NROWS; ++j) {
                for (int k = 0; k < this.NCOLUMNS; ++k) {
                    double d2 = this.A.getQuick(i, j, k);
                    double d3 = this.B.getQuick(i, j, k);
                    d += d2 * d3;
                }
            }
        }
        double d4 = this.A.aggregate(this.B, DoubleFunctions.plus, DoubleFunctions.mult);
        DoubleMatrix3DTest.assertEquals((double)d, (double)d4, (double)this.TOL);
    }

    public void testAssignDouble() {
        double d = Math.random();
        this.A.assign(d);
        for (int i = 0; i < this.NSLICES; ++i) {
            for (int j = 0; j < this.NROWS; ++j) {
                for (int k = 0; k < this.NCOLUMNS; ++k) {
                    DoubleMatrix3DTest.assertEquals((double)d, (double)this.A.getQuick(i, j, k), (double)this.TOL);
                }
            }
        }
    }

    public void testAssignDoubleArray() {
        int n;
        double[] dArray = new double[this.A.size()];
        for (n = 0; n < this.A.size(); ++n) {
            dArray[n] = Math.random();
        }
        this.A.assign(dArray);
        n = 0;
        for (int i = 0; i < this.NSLICES; ++i) {
            for (int j = 0; j < this.NROWS; ++j) {
                for (int k = 0; k < this.NCOLUMNS; ++k) {
                    DoubleMatrix3DTest.assertEquals((double)dArray[n++], (double)this.A.getQuick(i, j, k), (double)this.TOL);
                }
            }
        }
    }

    public void testAssignDoubleArrayArrayArray() {
        int n;
        int n2;
        int n3;
        double[][][] dArray = new double[this.NSLICES][this.NROWS][this.NCOLUMNS];
        for (n3 = 0; n3 < this.NSLICES; ++n3) {
            for (n2 = 0; n2 < this.NROWS; ++n2) {
                for (n = 0; n < this.NCOLUMNS; ++n) {
                    dArray[n3][n2][n] = Math.random();
                }
            }
        }
        this.A.assign(dArray);
        for (n3 = 0; n3 < this.NSLICES; ++n3) {
            DoubleMatrix3DTest.assertTrue((this.NROWS == dArray[n3].length ? 1 : 0) != 0);
            for (n2 = 0; n2 < this.NROWS; ++n2) {
                DoubleMatrix3DTest.assertTrue((this.NCOLUMNS == dArray[n3][n2].length ? 1 : 0) != 0);
                for (n = 0; n < this.NCOLUMNS; ++n) {
                    DoubleMatrix3DTest.assertEquals((double)dArray[n3][n2][n], (double)this.A.getQuick(n3, n2, n), (double)this.TOL);
                }
            }
        }
    }

    public void testAssignDoubleFunction() {
        DoubleMatrix3D doubleMatrix3D = this.A.copy();
        this.A.assign(DoubleFunctions.acos);
        for (int i = 0; i < this.NSLICES; ++i) {
            for (int j = 0; j < this.NROWS; ++j) {
                for (int k = 0; k < this.NCOLUMNS; ++k) {
                    double d = Math.acos(doubleMatrix3D.getQuick(i, j, k));
                    DoubleMatrix3DTest.assertEquals((double)d, (double)this.A.getQuick(i, j, k), (double)this.TOL);
                }
            }
        }
    }

    public void testAssignDoubleMatrix3D() {
        this.A.assign(this.B);
        for (int i = 0; i < this.NSLICES; ++i) {
            for (int j = 0; j < this.NROWS; ++j) {
                for (int k = 0; k < this.NCOLUMNS; ++k) {
                    DoubleMatrix3DTest.assertEquals((double)this.B.getQuick(i, j, k), (double)this.A.getQuick(i, j, k), (double)this.TOL);
                }
            }
        }
    }

    public void testAssignDoubleMatrix3DDoubleDoubleFunction() {
        DoubleMatrix3D doubleMatrix3D = this.A.copy();
        this.A.assign(this.B, DoubleFunctions.div);
        for (int i = 0; i < this.NSLICES; ++i) {
            for (int j = 0; j < this.NROWS; ++j) {
                for (int k = 0; k < this.NCOLUMNS; ++k) {
                    DoubleMatrix3DTest.assertEquals((double)(doubleMatrix3D.getQuick(i, j, k) / this.B.getQuick(i, j, k)), (double)this.A.getQuick(i, j, k), (double)this.TOL);
                }
            }
        }
    }

    public void testAssignDoubleMatrix3DDoubleDoubleFunctionIntArrayListIntArrayListIntArrayList() {
        int n;
        int n2;
        IntArrayList intArrayList = new IntArrayList();
        IntArrayList intArrayList2 = new IntArrayList();
        IntArrayList intArrayList3 = new IntArrayList();
        for (int i = 0; i < this.NSLICES; ++i) {
            for (n2 = 0; n2 < this.NROWS; ++n2) {
                for (n = 0; n < this.NCOLUMNS; ++n) {
                    intArrayList.add(i);
                    intArrayList2.add(n2);
                    intArrayList3.add(n);
                }
            }
        }
        DoubleMatrix3D doubleMatrix3D = this.A.copy();
        this.A.assign(this.B, DoubleFunctions.div, intArrayList, intArrayList2, intArrayList3);
        for (n2 = 0; n2 < this.NSLICES; ++n2) {
            for (n = 0; n < this.NROWS; ++n) {
                for (int i = 0; i < this.NCOLUMNS; ++i) {
                    DoubleMatrix3DTest.assertEquals((double)(doubleMatrix3D.getQuick(n2, n, i) / this.B.getQuick(n2, n, i)), (double)this.A.getQuick(n2, n, i), (double)this.TOL);
                }
            }
        }
    }

    public void testAssignDoubleProcedureDouble() {
        DoubleProcedure doubleProcedure = new DoubleProcedure(){

            public boolean apply(double d) {
                return Math.abs(d) > 0.1;
            }
        };
        DoubleMatrix3D doubleMatrix3D = this.A.copy();
        this.A.assign(doubleProcedure, -1.0);
        for (int i = 0; i < this.NSLICES; ++i) {
            for (int j = 0; j < this.NROWS; ++j) {
                for (int k = 0; k < this.NCOLUMNS; ++k) {
                    if (Math.abs(doubleMatrix3D.getQuick(i, j, k)) > 0.1) {
                        DoubleMatrix3DTest.assertEquals((double)-1.0, (double)this.A.getQuick(i, j, k), (double)this.TOL);
                        continue;
                    }
                    DoubleMatrix3DTest.assertEquals((double)doubleMatrix3D.getQuick(i, j, k), (double)this.A.getQuick(i, j, k), (double)this.TOL);
                }
            }
        }
    }

    public void testAssignDoubleProcedureDoubleFunction() {
        DoubleProcedure doubleProcedure = new DoubleProcedure(){

            public boolean apply(double d) {
                return Math.abs(d) > 0.1;
            }
        };
        DoubleMatrix3D doubleMatrix3D = this.A.copy();
        this.A.assign(doubleProcedure, DoubleFunctions.tan);
        for (int i = 0; i < this.NSLICES; ++i) {
            for (int j = 0; j < this.NROWS; ++j) {
                for (int k = 0; k < this.NCOLUMNS; ++k) {
                    if (Math.abs(doubleMatrix3D.getQuick(i, j, k)) > 0.1) {
                        DoubleMatrix3DTest.assertEquals((double)Math.tan(doubleMatrix3D.getQuick(i, j, k)), (double)this.A.getQuick(i, j, k), (double)this.TOL);
                        continue;
                    }
                    DoubleMatrix3DTest.assertEquals((double)doubleMatrix3D.getQuick(i, j, k), (double)this.A.getQuick(i, j, k), (double)this.TOL);
                }
            }
        }
    }

    public void testCardinality() {
        int n = this.A.cardinality();
        DoubleMatrix3DTest.assertEquals((int)(this.NSLICES * this.NROWS * this.NCOLUMNS), (int)n);
    }

    public void testEqualsDouble() {
        double d = 1.0;
        this.A.assign(d);
        boolean bl = this.A.equals(d);
        DoubleMatrix3DTest.assertTrue((boolean)bl);
        bl = this.A.equals(2.0);
        DoubleMatrix3DTest.assertFalse((boolean)bl);
    }

    public void testEqualsObject() {
        boolean bl = this.A.equals(this.A);
        DoubleMatrix3DTest.assertTrue((boolean)bl);
        bl = this.A.equals(this.B);
        DoubleMatrix3DTest.assertFalse((boolean)bl);
    }

    public void testMaxLocation() {
        this.A.assign(0.0);
        this.A.setQuick(this.NSLICES / 3, this.NROWS / 3, this.NCOLUMNS / 3, 0.7);
        this.A.setQuick(this.NSLICES / 3, this.NROWS / 2, this.NCOLUMNS / 2, 0.1);
        double[] dArray = this.A.getMaxLocation();
        DoubleMatrix3DTest.assertEquals((double)0.7, (double)dArray[0], (double)this.TOL);
        DoubleMatrix3DTest.assertEquals((int)(this.NSLICES / 3), (int)((int)dArray[1]));
        DoubleMatrix3DTest.assertEquals((int)(this.NROWS / 3), (int)((int)dArray[2]));
        DoubleMatrix3DTest.assertEquals((int)(this.NCOLUMNS / 3), (int)((int)dArray[3]));
    }

    public void testMinLocation() {
        this.A.assign(0.0);
        this.A.setQuick(this.NSLICES / 3, this.NROWS / 3, this.NCOLUMNS / 3, -0.7);
        this.A.setQuick(this.NSLICES / 3, this.NROWS / 2, this.NCOLUMNS / 2, -0.1);
        double[] dArray = this.A.getMinLocation();
        DoubleMatrix3DTest.assertEquals((double)-0.7, (double)dArray[0], (double)this.TOL);
        DoubleMatrix3DTest.assertEquals((int)(this.NSLICES / 3), (int)((int)dArray[1]));
        DoubleMatrix3DTest.assertEquals((int)(this.NROWS / 3), (int)((int)dArray[2]));
        DoubleMatrix3DTest.assertEquals((int)(this.NCOLUMNS / 3), (int)((int)dArray[3]));
    }

    public void testGetNegativeValues() {
        this.A.assign(0.0);
        this.A.setQuick(this.NSLICES / 3, this.NROWS / 3, this.NCOLUMNS / 3, -0.7);
        this.A.setQuick(this.NSLICES / 2, this.NROWS / 2, this.NCOLUMNS / 2, -0.1);
        IntArrayList intArrayList = new IntArrayList();
        IntArrayList intArrayList2 = new IntArrayList();
        IntArrayList intArrayList3 = new IntArrayList();
        DoubleArrayList doubleArrayList = new DoubleArrayList();
        this.A.getNegativeValues(intArrayList, intArrayList2, intArrayList3, doubleArrayList);
        DoubleMatrix3DTest.assertEquals((int)2, (int)intArrayList.size());
        DoubleMatrix3DTest.assertEquals((int)2, (int)intArrayList2.size());
        DoubleMatrix3DTest.assertEquals((int)2, (int)intArrayList3.size());
        DoubleMatrix3DTest.assertEquals((int)2, (int)doubleArrayList.size());
        DoubleMatrix3DTest.assertTrue((boolean)intArrayList.contains(this.NSLICES / 3));
        DoubleMatrix3DTest.assertTrue((boolean)intArrayList.contains(this.NSLICES / 2));
        DoubleMatrix3DTest.assertTrue((boolean)intArrayList2.contains(this.NROWS / 3));
        DoubleMatrix3DTest.assertTrue((boolean)intArrayList2.contains(this.NROWS / 2));
        DoubleMatrix3DTest.assertTrue((boolean)intArrayList3.contains(this.NCOLUMNS / 3));
        DoubleMatrix3DTest.assertTrue((boolean)intArrayList3.contains(this.NCOLUMNS / 2));
        DoubleMatrix3DTest.assertTrue((boolean)doubleArrayList.contains(-0.7));
        DoubleMatrix3DTest.assertTrue((boolean)doubleArrayList.contains(-0.1));
    }

    public void testGetNonZeros() {
        this.A.assign(0.0);
        this.A.setQuick(this.NSLICES / 3, this.NROWS / 3, this.NCOLUMNS / 3, 0.7);
        this.A.setQuick(this.NSLICES / 2, this.NROWS / 2, this.NCOLUMNS / 2, 0.1);
        IntArrayList intArrayList = new IntArrayList();
        IntArrayList intArrayList2 = new IntArrayList();
        IntArrayList intArrayList3 = new IntArrayList();
        DoubleArrayList doubleArrayList = new DoubleArrayList();
        this.A.getNonZeros(intArrayList, intArrayList2, intArrayList3, doubleArrayList);
        DoubleMatrix3DTest.assertEquals((int)2, (int)intArrayList.size());
        DoubleMatrix3DTest.assertEquals((int)2, (int)intArrayList2.size());
        DoubleMatrix3DTest.assertEquals((int)2, (int)intArrayList3.size());
        DoubleMatrix3DTest.assertEquals((int)2, (int)doubleArrayList.size());
        DoubleMatrix3DTest.assertTrue((boolean)intArrayList.contains(this.NSLICES / 3));
        DoubleMatrix3DTest.assertTrue((boolean)intArrayList.contains(this.NSLICES / 2));
        DoubleMatrix3DTest.assertTrue((boolean)intArrayList2.contains(this.NROWS / 3));
        DoubleMatrix3DTest.assertTrue((boolean)intArrayList2.contains(this.NROWS / 2));
        DoubleMatrix3DTest.assertTrue((boolean)intArrayList3.contains(this.NCOLUMNS / 3));
        DoubleMatrix3DTest.assertTrue((boolean)intArrayList3.contains(this.NCOLUMNS / 2));
        DoubleMatrix3DTest.assertTrue((boolean)doubleArrayList.contains(0.7));
        DoubleMatrix3DTest.assertTrue((boolean)doubleArrayList.contains(0.1));
    }

    public void testGetPositiveValues() {
        this.A.assign(0.0);
        this.A.setQuick(this.NSLICES / 3, this.NROWS / 3, this.NCOLUMNS / 3, 0.7);
        this.A.setQuick(this.NSLICES / 2, this.NROWS / 2, this.NCOLUMNS / 2, 0.1);
        IntArrayList intArrayList = new IntArrayList();
        IntArrayList intArrayList2 = new IntArrayList();
        IntArrayList intArrayList3 = new IntArrayList();
        DoubleArrayList doubleArrayList = new DoubleArrayList();
        this.A.getPositiveValues(intArrayList, intArrayList2, intArrayList3, doubleArrayList);
        DoubleMatrix3DTest.assertEquals((int)2, (int)intArrayList.size());
        DoubleMatrix3DTest.assertEquals((int)2, (int)intArrayList2.size());
        DoubleMatrix3DTest.assertEquals((int)2, (int)intArrayList3.size());
        DoubleMatrix3DTest.assertEquals((int)2, (int)doubleArrayList.size());
        DoubleMatrix3DTest.assertTrue((boolean)intArrayList.contains(this.NSLICES / 3));
        DoubleMatrix3DTest.assertTrue((boolean)intArrayList.contains(this.NSLICES / 2));
        DoubleMatrix3DTest.assertTrue((boolean)intArrayList2.contains(this.NROWS / 3));
        DoubleMatrix3DTest.assertTrue((boolean)intArrayList2.contains(this.NROWS / 2));
        DoubleMatrix3DTest.assertTrue((boolean)intArrayList3.contains(this.NCOLUMNS / 3));
        DoubleMatrix3DTest.assertTrue((boolean)intArrayList3.contains(this.NCOLUMNS / 2));
        DoubleMatrix3DTest.assertTrue((boolean)doubleArrayList.contains(0.7));
        DoubleMatrix3DTest.assertTrue((boolean)doubleArrayList.contains(0.1));
    }

    public void testToArray() {
        double[][][] dArray = this.A.toArray();
        for (int i = 0; i < this.NSLICES; ++i) {
            DoubleMatrix3DTest.assertTrue((this.NROWS == dArray[i].length ? 1 : 0) != 0);
            for (int j = 0; j < this.NROWS; ++j) {
                DoubleMatrix3DTest.assertTrue((this.NCOLUMNS == dArray[i][j].length ? 1 : 0) != 0);
                for (int k = 0; k < this.NCOLUMNS; ++k) {
                    DoubleMatrix3DTest.assertEquals((double)0.0, (double)Math.abs(dArray[i][j][k] - this.A.getQuick(i, j, k)), (double)this.TOL);
                }
            }
        }
    }

    public void testVectorize() {
        DoubleMatrix1D doubleMatrix1D = this.A.vectorize();
        int n = 0;
        for (int i = 0; i < this.NSLICES; ++i) {
            for (int j = 0; j < this.NCOLUMNS; ++j) {
                for (int k = 0; k < this.NROWS; ++k) {
                    DoubleMatrix3DTest.assertEquals((double)this.A.getQuick(i, k, j), (double)doubleMatrix1D.getQuick(n++), (double)this.TOL);
                }
            }
        }
    }

    public void testViewColumn() {
        DoubleMatrix2D doubleMatrix2D = this.A.viewColumn(this.NCOLUMNS / 2);
        DoubleMatrix3DTest.assertEquals((int)this.NSLICES, (int)doubleMatrix2D.rows());
        DoubleMatrix3DTest.assertEquals((int)this.NROWS, (int)doubleMatrix2D.columns());
        for (int i = 0; i < this.NSLICES; ++i) {
            for (int j = 0; j < this.NROWS; ++j) {
                DoubleMatrix3DTest.assertEquals((double)this.A.getQuick(i, j, this.NCOLUMNS / 2), (double)doubleMatrix2D.getQuick(i, j), (double)this.TOL);
            }
        }
    }

    public void testViewColumnFlip() {
        DoubleMatrix3D doubleMatrix3D = this.A.viewColumnFlip();
        DoubleMatrix3DTest.assertEquals((int)this.A.size(), (int)doubleMatrix3D.size());
        for (int i = 0; i < this.NSLICES; ++i) {
            for (int j = 0; j < this.NROWS; ++j) {
                for (int k = 0; k < this.NCOLUMNS; ++k) {
                    DoubleMatrix3DTest.assertEquals((double)this.A.getQuick(i, j, this.NCOLUMNS - 1 - k), (double)doubleMatrix3D.getQuick(i, j, k), (double)this.TOL);
                }
            }
        }
    }

    public void testViewDice() {
        DoubleMatrix3D doubleMatrix3D = this.A.viewDice(2, 1, 0);
        DoubleMatrix3DTest.assertEquals((int)this.A.slices(), (int)doubleMatrix3D.columns());
        DoubleMatrix3DTest.assertEquals((int)this.A.rows(), (int)doubleMatrix3D.rows());
        DoubleMatrix3DTest.assertEquals((int)this.A.columns(), (int)doubleMatrix3D.slices());
        for (int i = 0; i < this.NSLICES; ++i) {
            for (int j = 0; j < this.NROWS; ++j) {
                for (int k = 0; k < this.NCOLUMNS; ++k) {
                    DoubleMatrix3DTest.assertEquals((double)this.A.getQuick(i, j, k), (double)doubleMatrix3D.getQuick(k, j, i), (double)this.TOL);
                }
            }
        }
    }

    public void testViewPart() {
        DoubleMatrix3D doubleMatrix3D = this.A.viewPart(this.NSLICES / 2, this.NROWS / 2, this.NCOLUMNS / 2, this.NSLICES / 3, this.NROWS / 3, this.NCOLUMNS / 3);
        for (int i = 0; i < this.NSLICES / 3; ++i) {
            for (int j = 0; j < this.NROWS / 3; ++j) {
                for (int k = 0; k < this.NCOLUMNS / 3; ++k) {
                    DoubleMatrix3DTest.assertEquals((double)this.A.getQuick(this.NSLICES / 2 + i, this.NROWS / 2 + j, this.NCOLUMNS / 2 + k), (double)doubleMatrix3D.getQuick(i, j, k), (double)this.TOL);
                }
            }
        }
    }

    public void testViewRow() {
        DoubleMatrix2D doubleMatrix2D = this.A.viewRow(this.NROWS / 2);
        DoubleMatrix3DTest.assertEquals((int)this.NSLICES, (int)doubleMatrix2D.rows());
        DoubleMatrix3DTest.assertEquals((int)this.NCOLUMNS, (int)doubleMatrix2D.columns());
        for (int i = 0; i < this.NSLICES; ++i) {
            for (int j = 0; j < this.NCOLUMNS; ++j) {
                DoubleMatrix3DTest.assertEquals((double)this.A.getQuick(i, this.NROWS / 2, j), (double)doubleMatrix2D.getQuick(i, j), (double)this.TOL);
            }
        }
    }

    public void testViewRowFlip() {
        DoubleMatrix3D doubleMatrix3D = this.A.viewRowFlip();
        DoubleMatrix3DTest.assertEquals((int)this.A.size(), (int)doubleMatrix3D.size());
        for (int i = 0; i < this.NSLICES; ++i) {
            for (int j = 0; j < this.NROWS; ++j) {
                for (int k = 0; k < this.NCOLUMNS; ++k) {
                    DoubleMatrix3DTest.assertEquals((double)this.A.getQuick(i, this.NROWS - 1 - j, k), (double)doubleMatrix3D.getQuick(i, j, k), (double)this.TOL);
                }
            }
        }
    }

    public void testViewSelectionDoubleMatrix2DProcedure() {
        this.A.assign(0.0);
        this.A.setQuick(this.NSLICES / 2, this.NROWS / 4, 0, 2.0);
        DoubleMatrix3D doubleMatrix3D = this.A.viewSelection(new DoubleMatrix2DProcedure(){

            public boolean apply(DoubleMatrix2D doubleMatrix2D) {
                return Math.abs(doubleMatrix2D.getQuick(DoubleMatrix3DTest.this.NROWS / 4, 0) - 2.0) <= DoubleMatrix3DTest.this.TOL;
            }
        });
        DoubleMatrix3DTest.assertEquals((int)1, (int)doubleMatrix3D.slices());
        DoubleMatrix3DTest.assertEquals((int)this.A.rows(), (int)doubleMatrix3D.rows());
        DoubleMatrix3DTest.assertEquals((int)this.A.columns(), (int)doubleMatrix3D.columns());
        DoubleMatrix3DTest.assertEquals((double)this.A.getQuick(this.NSLICES / 2, this.NROWS / 4, 0), (double)doubleMatrix3D.getQuick(0, this.NROWS / 4, 0), (double)this.TOL);
    }

    public void testViewSelectionIntArrayIntArrayIntArray() {
        int[] nArray = new int[]{this.NSLICES / 2, this.NSLICES / 3};
        int[] nArray2 = new int[]{this.NROWS / 6, this.NROWS / 5, this.NROWS / 4, this.NROWS / 3, this.NROWS / 2};
        int[] nArray3 = new int[]{this.NCOLUMNS / 6, this.NCOLUMNS / 5, this.NCOLUMNS / 4, this.NCOLUMNS / 3, this.NCOLUMNS / 2, this.NCOLUMNS - 1};
        DoubleMatrix3D doubleMatrix3D = this.A.viewSelection(nArray, nArray2, nArray3);
        DoubleMatrix3DTest.assertEquals((int)nArray.length, (int)doubleMatrix3D.slices());
        DoubleMatrix3DTest.assertEquals((int)nArray2.length, (int)doubleMatrix3D.rows());
        DoubleMatrix3DTest.assertEquals((int)nArray3.length, (int)doubleMatrix3D.columns());
        for (int i = 0; i < nArray.length; ++i) {
            for (int j = 0; j < nArray2.length; ++j) {
                for (int k = 0; k < nArray3.length; ++k) {
                    DoubleMatrix3DTest.assertEquals((double)this.A.getQuick(nArray[i], nArray2[j], nArray3[k]), (double)doubleMatrix3D.getQuick(i, j, k), (double)this.TOL);
                }
            }
        }
    }

    public void testViewSlice() {
        DoubleMatrix2D doubleMatrix2D = this.A.viewSlice(this.NSLICES / 2);
        DoubleMatrix3DTest.assertEquals((int)this.NROWS, (int)doubleMatrix2D.rows());
        DoubleMatrix3DTest.assertEquals((int)this.NCOLUMNS, (int)doubleMatrix2D.columns());
        for (int i = 0; i < this.NROWS; ++i) {
            for (int j = 0; j < this.NCOLUMNS; ++j) {
                DoubleMatrix3DTest.assertEquals((double)this.A.getQuick(this.NSLICES / 2, i, j), (double)doubleMatrix2D.getQuick(i, j), (double)this.TOL);
            }
        }
    }

    public void testViewSliceFlip() {
        DoubleMatrix3D doubleMatrix3D = this.A.viewSliceFlip();
        DoubleMatrix3DTest.assertEquals((int)this.A.size(), (int)doubleMatrix3D.size());
        for (int i = 0; i < this.NSLICES; ++i) {
            for (int j = 0; j < this.NROWS; ++j) {
                for (int k = 0; k < this.NCOLUMNS; ++k) {
                    DoubleMatrix3DTest.assertEquals((double)this.A.getQuick(this.NSLICES - 1 - i, j, k), (double)doubleMatrix3D.getQuick(i, j, k), (double)this.TOL);
                }
            }
        }
    }

    public void testViewSorted() {
        DoubleMatrix3D doubleMatrix3D = this.A.viewSorted(1, 1);
        for (int i = 0; i < this.NSLICES - 1; ++i) {
            DoubleMatrix3DTest.assertTrue((doubleMatrix3D.getQuick(i + 1, 1, 1) >= doubleMatrix3D.getQuick(i, 1, 1) ? 1 : 0) != 0);
        }
    }

    public void testViewStrides() {
        int n = 2;
        int n2 = 2;
        int n3 = 2;
        DoubleMatrix3D doubleMatrix3D = this.A.viewStrides(n, n2, n3);
        for (int i = 0; i < doubleMatrix3D.slices(); ++i) {
            for (int j = 0; j < doubleMatrix3D.rows(); ++j) {
                for (int k = 0; k < doubleMatrix3D.columns(); ++k) {
                    DoubleMatrix3DTest.assertEquals((double)this.A.getQuick(i * n, j * n2, k * n3), (double)doubleMatrix3D.getQuick(i, j, k), (double)this.TOL);
                }
            }
        }
    }

    public void testZSum() {
        double d = this.A.zSum();
        double d2 = 0.0;
        for (int i = 0; i < this.NSLICES; ++i) {
            for (int j = 0; j < this.NROWS; ++j) {
                for (int k = 0; k < this.NCOLUMNS; ++k) {
                    d2 += this.A.getQuick(i, j, k);
                }
            }
        }
        DoubleMatrix3DTest.assertEquals((double)d2, (double)d, (double)this.TOL);
    }
}

