/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdouble;

import cern.colt.function.tdouble.DoubleDoubleFunction;
import cern.colt.function.tdouble.DoubleFunction;
import cern.colt.function.tdouble.DoubleProcedure;
import cern.colt.list.tdouble.DoubleArrayList;
import cern.colt.list.tint.IntArrayList;
import cern.colt.matrix.AbstractMatrix1D;
import cern.colt.matrix.tdouble.DoubleMatrix2D;
import cern.colt.matrix.tdouble.DoubleMatrix3D;
import cern.colt.matrix.tdouble.algo.DoubleFormatter;
import cern.colt.matrix.tdouble.algo.DoubleProperty;
import cern.colt.matrix.tdouble.algo.DoubleSorting;
import cern.jet.math.tdouble.DoubleFunctions;
import cern.jet.math.tdouble.DoublePlusMultSecond;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public abstract class DoubleMatrix1D
extends AbstractMatrix1D {
    protected DoubleMatrix1D() {
    }

    public double aggregate(final DoubleDoubleFunction doubleDoubleFunction, final DoubleFunction doubleFunction) {
        if (this.size == 0) {
            return Double.NaN;
        }
        double d = doubleFunction.apply(this.getQuick(0));
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            Future[] futureArray = new Future[n];
            Double[] doubleArray = new Double[n];
            int n2 = this.size / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.size : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Callable<Double>(){

                    @Override
                    public Double call() throws Exception {
                        double d = doubleFunction.apply(DoubleMatrix1D.this.getQuick(n3));
                        for (int i = n3 + 1; i < n4; ++i) {
                            d = doubleDoubleFunction.apply(d, doubleFunction.apply(DoubleMatrix1D.this.getQuick(i)));
                        }
                        return d;
                    }
                });
            }
            d = ConcurrencyUtils.waitForCompletion(futureArray, doubleDoubleFunction);
        } else {
            for (int i = 1; i < this.size; ++i) {
                d = doubleDoubleFunction.apply(d, doubleFunction.apply(this.getQuick(i)));
            }
        }
        return d;
    }

    public double aggregate(final DoubleMatrix1D doubleMatrix1D, final DoubleDoubleFunction doubleDoubleFunction, final DoubleDoubleFunction doubleDoubleFunction2) {
        this.checkSize(doubleMatrix1D);
        if (this.size == 0) {
            return Double.NaN;
        }
        double d = doubleDoubleFunction2.apply(this.getQuick(0), doubleMatrix1D.getQuick(0));
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            Future[] futureArray = new Future[n];
            Double[] doubleArray = new Double[n];
            int n2 = this.size / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.size : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Callable<Double>(){

                    @Override
                    public Double call() throws Exception {
                        double d = doubleDoubleFunction2.apply(DoubleMatrix1D.this.getQuick(n3), doubleMatrix1D.getQuick(n3));
                        for (int i = n3 + 1; i < n4; ++i) {
                            d = doubleDoubleFunction.apply(d, doubleDoubleFunction2.apply(DoubleMatrix1D.this.getQuick(i), doubleMatrix1D.getQuick(i)));
                        }
                        return d;
                    }
                });
            }
            d = ConcurrencyUtils.waitForCompletion(futureArray, doubleDoubleFunction);
        } else {
            for (int i = 1; i < this.size; ++i) {
                d = doubleDoubleFunction.apply(d, doubleDoubleFunction2.apply(this.getQuick(i), doubleMatrix1D.getQuick(i)));
            }
        }
        return d;
    }

    public double aggregate(final DoubleDoubleFunction doubleDoubleFunction, final DoubleFunction doubleFunction, IntArrayList intArrayList) {
        if (this.size() == 0) {
            return Double.NaN;
        }
        int n = intArrayList.size();
        final int[] nArray = intArrayList.elements();
        double d = 0.0;
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && n >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            Future[] futureArray = new Future[n2];
            int n3 = n / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? n : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Callable<Double>(){

                    @Override
                    public Double call() throws Exception {
                        double d = doubleFunction.apply(DoubleMatrix1D.this.getQuick(nArray[n4]));
                        for (int i = n4 + 1; i < n5; ++i) {
                            double d2 = DoubleMatrix1D.this.getQuick(nArray[i]);
                            d = doubleDoubleFunction.apply(d, doubleFunction.apply(d2));
                        }
                        return d;
                    }
                });
            }
            d = ConcurrencyUtils.waitForCompletion(futureArray, doubleDoubleFunction);
        } else {
            d = doubleFunction.apply(this.getQuick(nArray[0]));
            for (int i = 1; i < n; ++i) {
                double d2 = this.getQuick(nArray[i]);
                d = doubleDoubleFunction.apply(d, doubleFunction.apply(d2));
            }
        }
        return d;
    }

    public DoubleMatrix1D assign(final DoubleFunction doubleFunction) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            Future[] futureArray = new Future[n];
            int n2 = this.size / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.size : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            DoubleMatrix1D.this.setQuick(i, doubleFunction.apply(DoubleMatrix1D.this.getQuick(i)));
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.size; ++i) {
                this.setQuick(i, doubleFunction.apply(this.getQuick(i)));
            }
        }
        return this;
    }

    public DoubleMatrix1D assign(final DoubleProcedure doubleProcedure, final DoubleFunction doubleFunction) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            Future[] futureArray = new Future[n];
            int n2 = this.size / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.size : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            double d = DoubleMatrix1D.this.getQuick(i);
                            if (!doubleProcedure.apply(d)) continue;
                            DoubleMatrix1D.this.setQuick(i, doubleFunction.apply(d));
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.size; ++i) {
                double d = this.getQuick(i);
                if (!doubleProcedure.apply(d)) continue;
                this.setQuick(i, doubleFunction.apply(d));
            }
        }
        return this;
    }

    public DoubleMatrix1D assign(final DoubleProcedure doubleProcedure, final double d) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            Future[] futureArray = new Future[n];
            int n2 = this.size / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.size : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            double d2 = DoubleMatrix1D.this.getQuick(i);
                            if (!doubleProcedure.apply(d2)) continue;
                            DoubleMatrix1D.this.setQuick(i, d);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.size; ++i) {
                double d2 = this.getQuick(i);
                if (!doubleProcedure.apply(d2)) continue;
                this.setQuick(i, d);
            }
        }
        return this;
    }

    public DoubleMatrix1D assign(final double d) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            Future[] futureArray = new Future[n];
            int n2 = this.size / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.size : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            DoubleMatrix1D.this.setQuick(i, d);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.size; ++i) {
                this.setQuick(i, d);
            }
        }
        return this;
    }

    public DoubleMatrix1D assign(final double[] dArray) {
        if (dArray.length != this.size) {
            throw new IllegalArgumentException("Must have same number of cells: length=" + dArray.length + "size()=" + this.size());
        }
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            Future[] futureArray = new Future[n];
            int n2 = this.size / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.size : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            DoubleMatrix1D.this.setQuick(i, dArray[i]);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.size; ++i) {
                this.setQuick(i, dArray[i]);
            }
        }
        return this;
    }

    public DoubleMatrix1D assign(DoubleMatrix1D doubleMatrix1D) {
        if (doubleMatrix1D == this) {
            return this;
        }
        this.checkSize(doubleMatrix1D);
        final DoubleMatrix1D doubleMatrix1D2 = this.haveSharedCells(doubleMatrix1D) ? doubleMatrix1D.copy() : doubleMatrix1D;
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            Future[] futureArray = new Future[n];
            int n2 = this.size / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.size : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            DoubleMatrix1D.this.setQuick(i, doubleMatrix1D2.getQuick(i));
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.size; ++i) {
                this.setQuick(i, doubleMatrix1D2.getQuick(i));
            }
        }
        return this;
    }

    public DoubleMatrix1D assign(final DoubleMatrix1D doubleMatrix1D, final DoubleDoubleFunction doubleDoubleFunction) {
        this.checkSize(doubleMatrix1D);
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            Future[] futureArray = new Future[n];
            int n2 = this.size / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.size : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            DoubleMatrix1D.this.setQuick(i, doubleDoubleFunction.apply(DoubleMatrix1D.this.getQuick(i), doubleMatrix1D.getQuick(i)));
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.size; ++i) {
                this.setQuick(i, doubleDoubleFunction.apply(this.getQuick(i), doubleMatrix1D.getQuick(i)));
            }
        }
        return this;
    }

    public DoubleMatrix1D assign(DoubleMatrix1D doubleMatrix1D, DoubleDoubleFunction doubleDoubleFunction, IntArrayList intArrayList) {
        this.checkSize(doubleMatrix1D);
        int[] nArray = intArrayList.elements();
        if (doubleDoubleFunction == DoubleFunctions.mult) {
            int n = 0;
            int n2 = intArrayList.size();
            while (--n2 >= 0) {
                int n3 = nArray[n2];
                while (n < n3) {
                    this.setQuick(n, 0.0);
                    ++n;
                }
                this.setQuick(n3, this.getQuick(n3) * doubleMatrix1D.getQuick(n3));
                ++n;
            }
        } else if (doubleDoubleFunction instanceof DoublePlusMultSecond) {
            double d = ((DoublePlusMultSecond)doubleDoubleFunction).multiplicator;
            if (d == 0.0) {
                return this;
            }
            if (d == 1.0) {
                int n = intArrayList.size();
                while (--n >= 0) {
                    int n4 = nArray[n];
                    this.setQuick(n4, this.getQuick(n4) + doubleMatrix1D.getQuick(n4));
                }
            } else if (d == -1.0) {
                int n = intArrayList.size();
                while (--n >= 0) {
                    int n5 = nArray[n];
                    this.setQuick(n5, this.getQuick(n5) - doubleMatrix1D.getQuick(n5));
                }
            } else {
                int n = intArrayList.size();
                while (--n >= 0) {
                    int n6 = nArray[n];
                    this.setQuick(n6, this.getQuick(n6) + d * doubleMatrix1D.getQuick(n6));
                }
            }
        } else {
            return this.assign(doubleMatrix1D, doubleDoubleFunction);
        }
        return this;
    }

    public int cardinality() {
        int n = 0;
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            int n3;
            Future[] futureArray = new Future[n2];
            Integer[] integerArray = new Integer[n2];
            int n4 = this.size / n2;
            for (n3 = 0; n3 < n2; ++n3) {
                final int n5 = n3 * n4;
                final int n6 = n3 == n2 - 1 ? this.size : n5 + n4;
                futureArray[n3] = ConcurrencyUtils.submit(new Callable<Integer>(){

                    @Override
                    public Integer call() throws Exception {
                        int n = 0;
                        for (int i = n5; i < n6; ++i) {
                            if (DoubleMatrix1D.this.getQuick(i) == 0.0) continue;
                            ++n;
                        }
                        return n;
                    }
                });
            }
            try {
                for (n3 = 0; n3 < n2; ++n3) {
                    integerArray[n3] = (Integer)futureArray[n3].get();
                }
                n = integerArray[0];
                for (n3 = 1; n3 < n2; ++n3) {
                    n += integerArray[n3].intValue();
                }
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        } else {
            for (int i = 0; i < this.size; ++i) {
                if (this.getQuick(i) == 0.0) continue;
                ++n;
            }
        }
        return n;
    }

    protected int cardinality(int n) {
        int n2 = 0;
        int n3 = this.size;
        while (--n3 >= 0 && n2 < n) {
            if (this.getQuick(n3) == 0.0) continue;
            ++n2;
        }
        return n2;
    }

    public DoubleMatrix1D copy() {
        DoubleMatrix1D doubleMatrix1D = this.like();
        doubleMatrix1D.assign(this);
        return doubleMatrix1D;
    }

    public abstract Object elements();

    public boolean equals(double d) {
        return DoubleProperty.DEFAULT.equals(this, d);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof DoubleMatrix1D)) {
            return false;
        }
        return DoubleProperty.DEFAULT.equals(this, (DoubleMatrix1D)object);
    }

    public double get(int n) {
        if (n < 0 || n >= this.size) {
            this.checkIndex(n);
        }
        return this.getQuick(n);
    }

    protected DoubleMatrix1D getContent() {
        return this;
    }

    public void getNegativeValues(IntArrayList intArrayList, DoubleArrayList doubleArrayList) {
        double d;
        int n;
        boolean bl;
        boolean bl2 = intArrayList != null;
        boolean bl3 = bl = doubleArrayList != null;
        if (bl2) {
            intArrayList.clear();
        }
        if (bl) {
            doubleArrayList.clear();
        }
        if ((n = this.size % 2) == 1 && (d = this.getQuick(0)) < 0.0) {
            if (bl2) {
                intArrayList.add(0);
            }
            if (bl) {
                doubleArrayList.add(d);
            }
        }
        for (int i = n; i < this.size; i += 2) {
            double d2 = this.getQuick(i);
            if (d2 < 0.0) {
                if (bl2) {
                    intArrayList.add(i);
                }
                if (bl) {
                    doubleArrayList.add(d2);
                }
            }
            if (!((d2 = this.getQuick(i + 1)) < 0.0)) continue;
            if (bl2) {
                intArrayList.add(i + 1);
            }
            if (!bl) continue;
            doubleArrayList.add(d2);
        }
    }

    public void getNonZeros(IntArrayList intArrayList, DoubleArrayList doubleArrayList) {
        double d;
        int n;
        boolean bl;
        boolean bl2 = intArrayList != null;
        boolean bl3 = bl = doubleArrayList != null;
        if (bl2) {
            intArrayList.clear();
        }
        if (bl) {
            doubleArrayList.clear();
        }
        if ((n = this.size % 2) == 1 && (d = this.getQuick(0)) != 0.0) {
            if (bl2) {
                intArrayList.add(0);
            }
            if (bl) {
                doubleArrayList.add(d);
            }
        }
        for (int i = n; i < this.size; i += 2) {
            double d2 = this.getQuick(i);
            if (d2 != 0.0) {
                if (bl2) {
                    intArrayList.add(i);
                }
                if (bl) {
                    doubleArrayList.add(d2);
                }
            }
            if ((d2 = this.getQuick(i + 1)) == 0.0) continue;
            if (bl2) {
                intArrayList.add(i + 1);
            }
            if (!bl) continue;
            doubleArrayList.add(d2);
        }
    }

    public void getNonZeros(IntArrayList intArrayList, DoubleArrayList doubleArrayList, int n) {
        boolean bl = intArrayList != null;
        boolean bl2 = doubleArrayList != null;
        int n2 = this.cardinality(n);
        if (bl) {
            intArrayList.clear();
        }
        if (bl2) {
            doubleArrayList.clear();
        }
        int n3 = this.size;
        int n4 = 0;
        for (int i = 0; i < n3; ++i) {
            double d = this.getQuick(i);
            if (d != 0.0) {
                if (bl) {
                    intArrayList.add(i);
                }
                if (bl2) {
                    doubleArrayList.add(d);
                }
                ++n4;
            }
            if (n4 >= n) break;
        }
    }

    public void getPositiveValues(IntArrayList intArrayList, DoubleArrayList doubleArrayList) {
        double d;
        int n;
        boolean bl;
        boolean bl2 = intArrayList != null;
        boolean bl3 = bl = doubleArrayList != null;
        if (bl2) {
            intArrayList.clear();
        }
        if (bl) {
            doubleArrayList.clear();
        }
        if ((n = this.size % 2) == 1 && (d = this.getQuick(0)) > 0.0) {
            if (bl2) {
                intArrayList.add(0);
            }
            if (bl) {
                doubleArrayList.add(d);
            }
        }
        for (int i = n; i < this.size; i += 2) {
            double d2 = this.getQuick(i);
            if (d2 > 0.0) {
                if (bl2) {
                    intArrayList.add(i);
                }
                if (bl) {
                    doubleArrayList.add(d2);
                }
            }
            if (!((d2 = this.getQuick(i + 1)) > 0.0)) continue;
            if (bl2) {
                intArrayList.add(i + 1);
            }
            if (!bl) continue;
            doubleArrayList.add(d2);
        }
    }

    public abstract double getQuick(int var1);

    protected boolean haveSharedCells(DoubleMatrix1D doubleMatrix1D) {
        if (doubleMatrix1D == null) {
            return false;
        }
        if (this == doubleMatrix1D) {
            return true;
        }
        return this.getContent().haveSharedCellsRaw(doubleMatrix1D.getContent());
    }

    protected boolean haveSharedCellsRaw(DoubleMatrix1D doubleMatrix1D) {
        return false;
    }

    public DoubleMatrix1D like() {
        return this.like(this.size);
    }

    public abstract DoubleMatrix1D like(int var1);

    public abstract DoubleMatrix2D like2D(int var1, int var2);

    public double[] getMaxLocation() {
        int n = 0;
        double d = 0.0;
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            int n3;
            Future[] futureArray = new Future[n2];
            double[][] dArray = new double[n2][2];
            int n4 = this.size / n2;
            for (n3 = 0; n3 < n2; ++n3) {
                final int n5 = n3 * n4;
                final int n6 = n3 == n2 - 1 ? this.size : n5 + n4;
                futureArray[n3] = ConcurrencyUtils.submit(new Callable<double[]>(){

                    @Override
                    public double[] call() throws Exception {
                        int n = n5;
                        double d = DoubleMatrix1D.this.getQuick(n);
                        for (int i = n5 + 1; i < n6; ++i) {
                            double d2 = DoubleMatrix1D.this.getQuick(i);
                            if (!(d < d2)) continue;
                            d = d2;
                            n = i;
                        }
                        return new double[]{d, n};
                    }
                });
            }
            try {
                for (n3 = 0; n3 < n2; ++n3) {
                    dArray[n3] = (double[])futureArray[n3].get();
                }
                d = dArray[0][0];
                n = (int)dArray[0][1];
                for (n3 = 1; n3 < n2; ++n3) {
                    if (!(d < dArray[n3][0])) continue;
                    d = dArray[n3][0];
                    n = (int)dArray[n3][1];
                }
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        } else {
            d = this.getQuick(n);
            for (int i = 1; i < this.size(); ++i) {
                double d2 = this.getQuick(i);
                if (!(d < d2)) continue;
                d = d2;
                n = i;
            }
        }
        return new double[]{d, n};
    }

    public double[] getMinLocation() {
        int n = 0;
        double d = 0.0;
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            int n3;
            Future[] futureArray = new Future[n2];
            double[][] dArray = new double[n2][2];
            int n4 = this.size / n2;
            for (n3 = 0; n3 < n2; ++n3) {
                final int n5 = n3 * n4;
                final int n6 = n3 == n2 - 1 ? this.size : n5 + n4;
                futureArray[n3] = ConcurrencyUtils.submit(new Callable<double[]>(){

                    @Override
                    public double[] call() throws Exception {
                        int n = n5;
                        double d = DoubleMatrix1D.this.getQuick(n);
                        for (int i = n5 + 1; i < n6; ++i) {
                            double d2 = DoubleMatrix1D.this.getQuick(i);
                            if (!(d > d2)) continue;
                            d = d2;
                            n = i;
                        }
                        return new double[]{d, n};
                    }
                });
            }
            try {
                for (n3 = 0; n3 < n2; ++n3) {
                    dArray[n3] = (double[])futureArray[n3].get();
                }
                d = dArray[0][0];
                n = (int)dArray[0][1];
                for (n3 = 1; n3 < n2; ++n3) {
                    if (!(d > dArray[n3][0])) continue;
                    d = dArray[n3][0];
                    n = (int)dArray[n3][1];
                }
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        } else {
            d = this.getQuick(n);
            for (int i = 1; i < this.size(); ++i) {
                double d2 = this.getQuick(i);
                if (!(d > d2)) continue;
                d = d2;
                n = i;
            }
        }
        return new double[]{d, n};
    }

    public void normalize() {
        double d = this.getMinLocation()[0];
        if (d < 0.0) {
            this.assign(DoubleFunctions.minus(d));
        }
        if (this.getMaxLocation()[0] == 0.0) {
            this.assign(1.0 / (double)this.size());
        } else {
            double d2 = this.zSum();
            d2 = 1.0 / d2;
            this.assign(DoubleFunctions.mult(d2));
        }
    }

    public abstract DoubleMatrix2D reshape(int var1, int var2);

    public abstract DoubleMatrix3D reshape(int var1, int var2, int var3);

    public void set(int n, double d) {
        if (n < 0 || n >= this.size) {
            this.checkIndex(n);
        }
        this.setQuick(n, d);
    }

    public abstract void setQuick(int var1, double var2);

    public void setSize(int n) {
        this.size = n;
    }

    public void swap(final DoubleMatrix1D doubleMatrix1D) {
        this.checkSize(doubleMatrix1D);
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            Future[] futureArray = new Future[n];
            int n2 = this.size / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.size : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            double d = DoubleMatrix1D.this.getQuick(i);
                            DoubleMatrix1D.this.setQuick(i, doubleMatrix1D.getQuick(i));
                            doubleMatrix1D.setQuick(i, d);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.size; ++i) {
                double d = this.getQuick(i);
                this.setQuick(i, doubleMatrix1D.getQuick(i));
                doubleMatrix1D.setQuick(i, d);
            }
        }
    }

    public double[] toArray() {
        double[] dArray = new double[this.size];
        this.toArray(dArray);
        return dArray;
    }

    public void toArray(final double[] dArray) {
        if (dArray.length < this.size) {
            throw new IllegalArgumentException("values too small");
        }
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            Future[] futureArray = new Future[n];
            int n2 = this.size / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.size : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            dArray[i] = DoubleMatrix1D.this.getQuick(i);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.size; ++i) {
                dArray[i] = this.getQuick(i);
            }
        }
    }

    public String toString() {
        return new DoubleFormatter().toString(this);
    }

    protected DoubleMatrix1D view() {
        return (DoubleMatrix1D)this.clone();
    }

    public DoubleMatrix1D viewFlip() {
        return (DoubleMatrix1D)this.view().vFlip();
    }

    public DoubleMatrix1D viewPart(int n, int n2) {
        return (DoubleMatrix1D)this.view().vPart(n, n2);
    }

    public DoubleMatrix1D viewSelection(DoubleProcedure doubleProcedure) {
        IntArrayList intArrayList = new IntArrayList();
        for (int i = 0; i < this.size; ++i) {
            if (!doubleProcedure.apply(this.getQuick(i))) continue;
            intArrayList.add(i);
        }
        intArrayList.trimToSize();
        return this.viewSelection(intArrayList.elements());
    }

    public DoubleMatrix1D viewSelection(int[] nArray) {
        if (nArray == null) {
            nArray = new int[this.size];
            for (int i = 0; i < this.size; ++i) {
                nArray[i] = i;
            }
        }
        this.checkIndexes(nArray);
        int[] nArray2 = new int[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            nArray2[i] = (int)this.index(nArray[i]);
        }
        return this.viewSelectionLike(nArray2);
    }

    protected abstract DoubleMatrix1D viewSelectionLike(int[] var1);

    public DoubleMatrix1D viewSorted() {
        return DoubleSorting.mergeSort.sort(this);
    }

    public DoubleMatrix1D viewStrides(int n) {
        return (DoubleMatrix1D)this.view().vStrides(n);
    }

    public double zDotProduct(DoubleMatrix1D doubleMatrix1D) {
        return this.zDotProduct(doubleMatrix1D, 0, this.size);
    }

    public double zDotProduct(final DoubleMatrix1D doubleMatrix1D, final int n, int n2) {
        if (n < 0 || n2 <= 0) {
            return 0.0;
        }
        int n3 = n + n2;
        if (this.size < n3) {
            n3 = this.size;
        }
        if (doubleMatrix1D.size < n3) {
            n3 = doubleMatrix1D.size;
        }
        n2 = n3 - n;
        double d = 0.0;
        int n4 = ConcurrencyUtils.getNumberOfThreads();
        if (n4 > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            int n5;
            Future[] futureArray = new Future[n4];
            Double[] doubleArray = new Double[n4];
            int n6 = n2 / n4;
            for (n5 = 0; n5 < n4; ++n5) {
                final int n7 = n5 * n6;
                final int n8 = n5 == n4 - 1 ? n2 : n7 + n6;
                futureArray[n5] = ConcurrencyUtils.submit(new Callable<Double>(){

                    @Override
                    public Double call() throws Exception {
                        double d = 0.0;
                        for (int i = n7; i < n8; ++i) {
                            int n2 = i + n;
                            d += DoubleMatrix1D.this.getQuick(n2) * doubleMatrix1D.getQuick(n2);
                        }
                        return d;
                    }
                });
            }
            try {
                for (n5 = 0; n5 < n4; ++n5) {
                    doubleArray[n5] = (Double)futureArray[n5].get();
                }
                d = doubleArray[0];
                for (n5 = 1; n5 < n4; ++n5) {
                    d += doubleArray[n5].doubleValue();
                }
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        } else {
            int n9 = n3 - 1;
            int n10 = n2;
            while (--n10 >= 0) {
                d += this.getQuick(n9) * doubleMatrix1D.getQuick(n9);
                --n9;
            }
        }
        return d;
    }

    public double zDotProduct(DoubleMatrix1D doubleMatrix1D, int n, int n2, IntArrayList intArrayList) {
        int n3;
        int n4;
        if (n < 0 || n2 <= 0) {
            return 0.0;
        }
        int n5 = n + n2;
        if (this.size < n5) {
            n5 = this.size;
        }
        if (doubleMatrix1D.size < n5) {
            n5 = doubleMatrix1D.size;
        }
        if ((n2 = n5 - n) <= 0) {
            return 0.0;
        }
        IntArrayList intArrayList2 = intArrayList.copy();
        intArrayList2.trimToSize();
        intArrayList2.quickSort();
        int[] nArray = intArrayList2.elements();
        int n6 = intArrayList2.size();
        for (n4 = 0; n4 < n6 && nArray[n4] < n; ++n4) {
        }
        double d = 0.0;
        while (--n2 >= 0 && n4 < n6 && (n3 = nArray[n4]) < n5) {
            d += this.getQuick(n3) * doubleMatrix1D.getQuick(n3);
            ++n4;
        }
        return d;
    }

    protected double zDotProduct(DoubleMatrix1D doubleMatrix1D, IntArrayList intArrayList) {
        return this.zDotProduct(doubleMatrix1D, 0, this.size, intArrayList);
    }

    public double zSum() {
        if (this.size() == 0) {
            return 0.0;
        }
        return this.aggregate(DoubleFunctions.plus, DoubleFunctions.identity);
    }
}

