/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdouble;

import cern.colt.PersistentObject;
import cern.colt.matrix.tdouble.DoubleMatrix1D;
import cern.colt.matrix.tdouble.DoubleMatrix2D;
import cern.colt.matrix.tdouble.impl.DenseDoubleMatrix2D;
import cern.colt.matrix.tdouble.impl.RCDoubleMatrix2D;
import cern.colt.matrix.tdouble.impl.SparseDoubleMatrix2D;
import cern.jet.math.tdouble.DoubleFunctions;
import cern.jet.random.tdouble.engine.DoubleMersenneTwister;
import cern.jet.random.tdouble.sampling.DoubleRandomSamplingAssistant;

public class DoubleFactory2D
extends PersistentObject {
    public static final DoubleFactory2D dense = new DoubleFactory2D();
    public static final DoubleFactory2D sparse = new DoubleFactory2D();
    public static final DoubleFactory2D rowCompressed = new DoubleFactory2D();

    protected DoubleFactory2D() {
    }

    public DoubleMatrix2D appendColumns(DoubleMatrix2D doubleMatrix2D, DoubleMatrix2D doubleMatrix2D2) {
        if (doubleMatrix2D2.rows() > doubleMatrix2D.rows()) {
            doubleMatrix2D2 = doubleMatrix2D2.viewPart(0, 0, doubleMatrix2D.rows(), doubleMatrix2D2.columns());
        } else if (doubleMatrix2D2.rows() < doubleMatrix2D.rows()) {
            doubleMatrix2D = doubleMatrix2D.viewPart(0, 0, doubleMatrix2D2.rows(), doubleMatrix2D.columns());
        }
        int n = doubleMatrix2D.columns();
        int n2 = doubleMatrix2D2.columns();
        int n3 = doubleMatrix2D.rows();
        DoubleMatrix2D doubleMatrix2D3 = this.make(n3, n + n2);
        doubleMatrix2D3.viewPart(0, 0, n3, n).assign(doubleMatrix2D);
        doubleMatrix2D3.viewPart(0, n, n3, n2).assign(doubleMatrix2D2);
        return doubleMatrix2D3;
    }

    public DoubleMatrix2D appendColumn(DoubleMatrix2D doubleMatrix2D, DoubleMatrix1D doubleMatrix1D) {
        if (doubleMatrix1D.size() > doubleMatrix2D.rows()) {
            doubleMatrix1D = doubleMatrix1D.viewPart(0, doubleMatrix2D.rows());
        } else if (doubleMatrix1D.size() < doubleMatrix2D.rows()) {
            doubleMatrix2D = doubleMatrix2D.viewPart(0, 0, doubleMatrix1D.size(), doubleMatrix2D.columns());
        }
        int n = doubleMatrix2D.columns();
        int n2 = 1;
        int n3 = doubleMatrix2D.rows();
        DoubleMatrix2D doubleMatrix2D2 = this.make(n3, n + n2);
        doubleMatrix2D2.viewPart(0, 0, n3, n).assign(doubleMatrix2D);
        doubleMatrix2D2.viewColumn(n).assign(doubleMatrix1D);
        return doubleMatrix2D2;
    }

    public DoubleMatrix2D appendRows(DoubleMatrix2D doubleMatrix2D, DoubleMatrix2D doubleMatrix2D2) {
        if (doubleMatrix2D2.columns() > doubleMatrix2D.columns()) {
            doubleMatrix2D2 = doubleMatrix2D2.viewPart(0, 0, doubleMatrix2D2.rows(), doubleMatrix2D.columns());
        } else if (doubleMatrix2D2.columns() < doubleMatrix2D.columns()) {
            doubleMatrix2D = doubleMatrix2D.viewPart(0, 0, doubleMatrix2D.rows(), doubleMatrix2D2.columns());
        }
        int n = doubleMatrix2D.rows();
        int n2 = doubleMatrix2D2.rows();
        int n3 = doubleMatrix2D.columns();
        DoubleMatrix2D doubleMatrix2D3 = this.make(n + n2, n3);
        doubleMatrix2D3.viewPart(0, 0, n, n3).assign(doubleMatrix2D);
        doubleMatrix2D3.viewPart(n, 0, n2, n3).assign(doubleMatrix2D2);
        return doubleMatrix2D3;
    }

    public DoubleMatrix2D appendRow(DoubleMatrix2D doubleMatrix2D, DoubleMatrix1D doubleMatrix1D) {
        if (doubleMatrix1D.size() > doubleMatrix2D.columns()) {
            doubleMatrix1D = doubleMatrix1D.viewPart(0, doubleMatrix2D.columns());
        } else if (doubleMatrix1D.size() < doubleMatrix2D.columns()) {
            doubleMatrix2D = doubleMatrix2D.viewPart(0, 0, doubleMatrix2D.rows(), doubleMatrix1D.size());
        }
        int n = doubleMatrix2D.rows();
        int n2 = 1;
        int n3 = doubleMatrix2D.columns();
        DoubleMatrix2D doubleMatrix2D2 = this.make(n + n2, n3);
        doubleMatrix2D2.viewPart(0, 0, n, n3).assign(doubleMatrix2D);
        doubleMatrix2D2.viewRow(n).assign(doubleMatrix1D);
        return doubleMatrix2D2;
    }

    public DoubleMatrix2D ascending(int n, int n2) {
        DoubleFunctions doubleFunctions = DoubleFunctions.functions;
        return this.descending(n, n2).assign(DoubleFunctions.chain(DoubleFunctions.neg, DoubleFunctions.minus(n2 * n)));
    }

    protected static void checkRectangularShape(double[][] dArray) {
        int n = -1;
        int n2 = dArray.length;
        while (--n2 >= 0) {
            if (dArray[n2] == null) continue;
            if (n == -1) {
                n = dArray[n2].length;
            }
            if (dArray[n2].length == n) continue;
            throw new IllegalArgumentException("All rows of array must have same number of columns.");
        }
    }

    protected static void checkRectangularShape(DoubleMatrix2D[][] doubleMatrix2DArray) {
        int n = -1;
        int n2 = doubleMatrix2DArray.length;
        while (--n2 >= 0) {
            if (doubleMatrix2DArray[n2] == null) continue;
            if (n == -1) {
                n = doubleMatrix2DArray[n2].length;
            }
            if (doubleMatrix2DArray[n2].length == n) continue;
            throw new IllegalArgumentException("All rows of array must have same number of columns.");
        }
    }

    public DoubleMatrix2D reshape(DoubleMatrix1D doubleMatrix1D, int n, int n2) {
        if (doubleMatrix1D.size() != n * n2) {
            throw new IllegalArgumentException("a.size() != rows*columns");
        }
        DoubleMatrix2D doubleMatrix2D = this == sparse ? new SparseDoubleMatrix2D(n, n2) : new DenseDoubleMatrix2D(n, n2);
        for (int i = 0; i < n2; ++i) {
            doubleMatrix2D.viewColumn(i).assign(doubleMatrix1D.viewPart(i * n, n));
        }
        return doubleMatrix2D;
    }

    public DoubleMatrix2D compose(DoubleMatrix2D[][] doubleMatrix2DArray) {
        int n;
        int n2;
        int n3;
        DoubleFactory2D.checkRectangularShape(doubleMatrix2DArray);
        int n4 = doubleMatrix2DArray.length;
        int n5 = 0;
        if (doubleMatrix2DArray.length > 0) {
            n5 = doubleMatrix2DArray[0].length;
        }
        DoubleMatrix2D doubleMatrix2D = this.make(0, 0);
        if (n4 == 0 || n5 == 0) {
            return doubleMatrix2D;
        }
        int[] nArray = new int[n5];
        int n6 = n5;
        while (--n6 >= 0) {
            n3 = 0;
            n2 = n4;
            while (--n2 >= 0) {
                DoubleMatrix2D doubleMatrix2D2 = doubleMatrix2DArray[n2][n6];
                if (doubleMatrix2D2 == null) continue;
                int n7 = doubleMatrix2D2.columns();
                if (n3 > 0 && n7 > 0 && n7 != n3) {
                    throw new IllegalArgumentException("Different number of columns.");
                }
                n3 = Math.max(n3, n7);
            }
            nArray[n6] = n3;
        }
        int[] nArray2 = new int[n4];
        n3 = n4;
        while (--n3 >= 0) {
            n2 = 0;
            int n8 = n5;
            while (--n8 >= 0) {
                DoubleMatrix2D doubleMatrix2D3 = doubleMatrix2DArray[n3][n8];
                if (doubleMatrix2D3 == null) continue;
                n = doubleMatrix2D3.rows();
                if (n2 > 0 && n > 0 && n != n2) {
                    throw new IllegalArgumentException("Different number of rows.");
                }
                n2 = Math.max(n2, n);
            }
            nArray2[n3] = n2;
        }
        n3 = 0;
        n2 = n4;
        while (--n2 >= 0) {
            n3 += nArray2[n2];
        }
        n2 = 0;
        int n9 = n5;
        while (--n9 >= 0) {
            n2 += nArray[n9];
        }
        DoubleMatrix2D doubleMatrix2D4 = this.make(n3, n2);
        int n10 = 0;
        for (n = 0; n < n4; ++n) {
            int n11 = 0;
            for (int i = 0; i < n5; ++i) {
                DoubleMatrix2D doubleMatrix2D5 = doubleMatrix2DArray[n][i];
                if (doubleMatrix2D5 != null) {
                    doubleMatrix2D4.viewPart(n10, n11, doubleMatrix2D5.rows(), doubleMatrix2D5.columns()).assign(doubleMatrix2D5);
                }
                n11 += nArray[i];
            }
            n10 += nArray2[n];
        }
        return doubleMatrix2D4;
    }

    public DoubleMatrix2D composeDiagonal(DoubleMatrix2D doubleMatrix2D, DoubleMatrix2D doubleMatrix2D2) {
        int n = doubleMatrix2D.rows();
        int n2 = doubleMatrix2D.columns();
        int n3 = doubleMatrix2D2.rows();
        int n4 = doubleMatrix2D2.columns();
        DoubleMatrix2D doubleMatrix2D3 = this.make(n + n3, n2 + n4);
        doubleMatrix2D3.viewPart(0, 0, n, n2).assign(doubleMatrix2D);
        doubleMatrix2D3.viewPart(n, n2, n3, n4).assign(doubleMatrix2D2);
        return doubleMatrix2D3;
    }

    public DoubleMatrix2D composeDiagonal(DoubleMatrix2D doubleMatrix2D, DoubleMatrix2D doubleMatrix2D2, DoubleMatrix2D doubleMatrix2D3) {
        DoubleMatrix2D doubleMatrix2D4 = this.make(doubleMatrix2D.rows() + doubleMatrix2D2.rows() + doubleMatrix2D3.rows(), doubleMatrix2D.columns() + doubleMatrix2D2.columns() + doubleMatrix2D3.columns());
        doubleMatrix2D4.viewPart(0, 0, doubleMatrix2D.rows(), doubleMatrix2D.columns()).assign(doubleMatrix2D);
        doubleMatrix2D4.viewPart(doubleMatrix2D.rows(), doubleMatrix2D.columns(), doubleMatrix2D2.rows(), doubleMatrix2D2.columns()).assign(doubleMatrix2D2);
        doubleMatrix2D4.viewPart(doubleMatrix2D.rows() + doubleMatrix2D2.rows(), doubleMatrix2D.columns() + doubleMatrix2D2.columns(), doubleMatrix2D3.rows(), doubleMatrix2D3.columns()).assign(doubleMatrix2D3);
        return doubleMatrix2D4;
    }

    public DoubleMatrix2D composeBidiagonal(DoubleMatrix2D doubleMatrix2D, DoubleMatrix2D doubleMatrix2D2) {
        int n = doubleMatrix2D.rows();
        int n2 = doubleMatrix2D.columns();
        int n3 = doubleMatrix2D2.rows();
        int n4 = doubleMatrix2D2.columns();
        DoubleMatrix2D doubleMatrix2D3 = this.make(n + n3 - 1, n2 + n4);
        doubleMatrix2D3.viewPart(0, 0, n, n2).assign(doubleMatrix2D);
        doubleMatrix2D3.viewPart(n - 1, n2, n3, n4).assign(doubleMatrix2D2);
        return doubleMatrix2D3;
    }

    public void decompose(DoubleMatrix2D[][] doubleMatrix2DArray, DoubleMatrix2D doubleMatrix2D) {
        int n;
        int n2;
        int n3;
        DoubleFactory2D.checkRectangularShape(doubleMatrix2DArray);
        int n4 = doubleMatrix2DArray.length;
        int n5 = 0;
        if (doubleMatrix2DArray.length > 0) {
            n5 = doubleMatrix2DArray[0].length;
        }
        if (n4 == 0 || n5 == 0) {
            return;
        }
        int[] nArray = new int[n5];
        int n6 = n5;
        while (--n6 >= 0) {
            n3 = 0;
            n2 = n4;
            while (--n2 >= 0) {
                DoubleMatrix2D doubleMatrix2D2 = doubleMatrix2DArray[n2][n6];
                if (doubleMatrix2D2 == null) continue;
                int n7 = doubleMatrix2D2.columns();
                if (n3 > 0 && n7 > 0 && n7 != n3) {
                    throw new IllegalArgumentException("Different number of columns.");
                }
                n3 = Math.max(n3, n7);
            }
            nArray[n6] = n3;
        }
        int[] nArray2 = new int[n4];
        n3 = n4;
        while (--n3 >= 0) {
            n2 = 0;
            int n8 = n5;
            while (--n8 >= 0) {
                DoubleMatrix2D doubleMatrix2D3 = doubleMatrix2DArray[n3][n8];
                if (doubleMatrix2D3 == null) continue;
                n = doubleMatrix2D3.rows();
                if (n2 > 0 && n > 0 && n != n2) {
                    throw new IllegalArgumentException("Different number of rows.");
                }
                n2 = Math.max(n2, n);
            }
            nArray2[n3] = n2;
        }
        n3 = 0;
        n2 = n4;
        while (--n2 >= 0) {
            n3 += nArray2[n2];
        }
        n2 = 0;
        int n9 = n5;
        while (--n9 >= 0) {
            n2 += nArray[n9];
        }
        if (doubleMatrix2D.rows() < n3 || doubleMatrix2D.columns() < n2) {
            throw new IllegalArgumentException("Parts larger than matrix.");
        }
        n9 = 0;
        for (int i = 0; i < n4; ++i) {
            n = 0;
            for (int j = 0; j < n5; ++j) {
                DoubleMatrix2D doubleMatrix2D4 = doubleMatrix2DArray[i][j];
                if (doubleMatrix2D4 != null) {
                    doubleMatrix2D4.assign(doubleMatrix2D.viewPart(n9, n, doubleMatrix2D4.rows(), doubleMatrix2D4.columns()));
                }
                n += nArray[j];
            }
            n9 += nArray2[i];
        }
    }

    public void demo1() {
        System.out.println("\n\n");
        DoubleMatrix2D[][] doubleMatrix2DArray = new DoubleMatrix2D[][]{{null, this.make(2, 2, 1.0), null}, {this.make(4, 4, 2.0), null, this.make(4, 3, 3.0)}, {null, this.make(2, 2, 4.0), null}};
        System.out.println("\n" + this.compose(doubleMatrix2DArray));
        DoubleMatrix2D[][] doubleMatrix2DArray2 = new DoubleMatrix2D[][]{{this.identity(3), null}, {null, this.identity(3).viewColumnFlip()}, {this.identity(3).viewRowFlip(), null}};
        System.out.println("\n" + this.compose(doubleMatrix2DArray2));
        DoubleMatrix2D doubleMatrix2D = this.ascending(2, 2);
        DoubleMatrix2D doubleMatrix2D2 = this.descending(2, 2);
        Object var5_5 = null;
        DoubleMatrix2D[][] doubleMatrix2DArray3 = new DoubleMatrix2D[][]{{doubleMatrix2D, var5_5, doubleMatrix2D, var5_5}, {var5_5, doubleMatrix2D, var5_5, doubleMatrix2D2}};
        System.out.println("\n" + this.compose(doubleMatrix2DArray3));
    }

    public void demo2() {
        System.out.println("\n\n");
        Object var9_1 = null;
        DoubleMatrix2D doubleMatrix2D = this.make(2, 2, 1.0);
        DoubleMatrix2D doubleMatrix2D2 = this.make(4, 4, 2.0);
        DoubleMatrix2D doubleMatrix2D3 = this.make(4, 3, 3.0);
        DoubleMatrix2D doubleMatrix2D4 = this.make(2, 2, 4.0);
        DoubleMatrix2D[][] doubleMatrix2DArray = new DoubleMatrix2D[][]{{var9_1, doubleMatrix2D, var9_1}, {doubleMatrix2D2, var9_1, doubleMatrix2D3}, {var9_1, doubleMatrix2D4, var9_1}};
        DoubleMatrix2D doubleMatrix2D5 = this.compose(doubleMatrix2DArray);
        System.out.println("\n" + doubleMatrix2D5);
        doubleMatrix2D.assign(9.0);
        doubleMatrix2D2.assign(9.0);
        doubleMatrix2D3.assign(9.0);
        doubleMatrix2D4.assign(9.0);
        this.decompose(doubleMatrix2DArray, doubleMatrix2D5);
        System.out.println(doubleMatrix2D);
        System.out.println(doubleMatrix2D2);
        System.out.println(doubleMatrix2D3);
        System.out.println(doubleMatrix2D4);
    }

    public DoubleMatrix2D descending(int n, int n2) {
        DoubleMatrix2D doubleMatrix2D = this.make(n, n2);
        int n3 = 0;
        int n4 = n;
        while (--n4 >= 0) {
            int n5 = n2;
            while (--n5 >= 0) {
                doubleMatrix2D.setQuick(n4, n5, n3++);
            }
        }
        return doubleMatrix2D;
    }

    public DoubleMatrix2D diagonal(DoubleMatrix1D doubleMatrix1D) {
        int n = doubleMatrix1D.size();
        DoubleMatrix2D doubleMatrix2D = this.make(n, n);
        int n2 = n;
        while (--n2 >= 0) {
            doubleMatrix2D.setQuick(n2, n2, doubleMatrix1D.getQuick(n2));
        }
        return doubleMatrix2D;
    }

    public DoubleMatrix2D diagonal(double[] dArray) {
        int n = dArray.length;
        DoubleMatrix2D doubleMatrix2D = this.make(n, n);
        for (int i = 0; i < n; ++i) {
            doubleMatrix2D.setQuick(i, i, dArray[i]);
        }
        return doubleMatrix2D;
    }

    public DoubleMatrix1D diagonal(DoubleMatrix2D doubleMatrix2D) {
        int n = Math.min(doubleMatrix2D.rows(), doubleMatrix2D.columns());
        DoubleMatrix1D doubleMatrix1D = this.make1D(n);
        int n2 = n;
        while (--n2 >= 0) {
            doubleMatrix1D.setQuick(n2, doubleMatrix2D.getQuick(n2, n2));
        }
        return doubleMatrix1D;
    }

    public DoubleMatrix2D identity(int n) {
        DoubleMatrix2D doubleMatrix2D = this.make(n, n);
        int n2 = n;
        while (--n2 >= 0) {
            doubleMatrix2D.setQuick(n2, n2, 1.0);
        }
        return doubleMatrix2D;
    }

    public DoubleMatrix2D make(double[][] dArray) {
        if (this == sparse) {
            return new SparseDoubleMatrix2D(dArray);
        }
        return new DenseDoubleMatrix2D(dArray);
    }

    public DoubleMatrix2D make(double[] dArray, int n) {
        int n2;
        int n3 = n2 = n != 0 ? dArray.length / n : 0;
        if (n * n2 != dArray.length) {
            throw new IllegalArgumentException("Array length must be a multiple of m.");
        }
        DoubleMatrix2D doubleMatrix2D = this.make(n, n2);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                doubleMatrix2D.setQuick(i, j, dArray[i + j * n]);
            }
        }
        return doubleMatrix2D;
    }

    public DoubleMatrix2D make(int n, int n2) {
        if (this == sparse) {
            return new SparseDoubleMatrix2D(n, n2);
        }
        if (this == rowCompressed) {
            return new RCDoubleMatrix2D(n, n2);
        }
        return new DenseDoubleMatrix2D(n, n2);
    }

    public DoubleMatrix2D make(int n, int n2, double d) {
        if (d == 0.0) {
            return this.make(n, n2);
        }
        return this.make(n, n2).assign(d);
    }

    protected DoubleMatrix1D make1D(int n) {
        return this.make(0, 0).like1D(n);
    }

    public DoubleMatrix2D random(int n, int n2) {
        return this.make(n, n2).assign(DoubleFunctions.random());
    }

    public DoubleMatrix2D repeat(DoubleMatrix2D doubleMatrix2D, int n, int n2) {
        int n3 = doubleMatrix2D.rows();
        int n4 = doubleMatrix2D.columns();
        DoubleMatrix2D doubleMatrix2D2 = this.make(n3 * n, n4 * n2);
        int n5 = n;
        while (--n5 >= 0) {
            int n6 = n2;
            while (--n6 >= 0) {
                doubleMatrix2D2.viewPart(n3 * n5, n4 * n6, n3, n4).assign(doubleMatrix2D);
            }
        }
        return doubleMatrix2D2;
    }

    public DoubleMatrix2D sample(int n, int n2, double d, double d2) {
        DoubleMatrix2D doubleMatrix2D = this.make(n, n2);
        this.sample(doubleMatrix2D, d, d2);
        return doubleMatrix2D;
    }

    public DoubleMatrix2D sample(DoubleMatrix2D doubleMatrix2D, double d, double d2) {
        int n = doubleMatrix2D.rows();
        int n2 = doubleMatrix2D.columns();
        double d3 = 1.0E-9;
        if (d2 < 0.0 - d3 || d2 > 1.0 + d3) {
            throw new IllegalArgumentException();
        }
        if (d2 < 0.0) {
            d2 = 0.0;
        }
        if (d2 > 1.0) {
            d2 = 1.0;
        }
        doubleMatrix2D.assign(0.0);
        int n3 = n * n2;
        int n4 = (int)Math.round((double)n3 * d2);
        if (n4 == 0) {
            return doubleMatrix2D;
        }
        DoubleRandomSamplingAssistant doubleRandomSamplingAssistant = new DoubleRandomSamplingAssistant(n4, n3, new DoubleMersenneTwister());
        for (int i = 0; i < n3; ++i) {
            if (!doubleRandomSamplingAssistant.sampleNextElement()) continue;
            int n5 = i / n2;
            int n6 = i % n2;
            doubleMatrix2D.set(n5, n6, d);
        }
        return doubleMatrix2D;
    }
}

