/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdouble;

import cern.colt.PersistentObject;
import cern.colt.list.tdouble.AbstractDoubleList;
import cern.colt.list.tdouble.DoubleArrayList;
import cern.colt.matrix.tdouble.DoubleMatrix1D;
import cern.colt.matrix.tdouble.impl.DenseDoubleMatrix1D;
import cern.colt.matrix.tdouble.impl.SparseDoubleMatrix1D;
import cern.jet.math.tdouble.DoubleFunctions;
import cern.jet.random.tdouble.engine.DoubleMersenneTwister;
import cern.jet.random.tdouble.sampling.DoubleRandomSamplingAssistant;

public class DoubleFactory1D
extends PersistentObject {
    public static final DoubleFactory1D dense = new DoubleFactory1D();
    public static final DoubleFactory1D sparse = new DoubleFactory1D();

    protected DoubleFactory1D() {
    }

    public DoubleMatrix1D append(DoubleMatrix1D doubleMatrix1D, DoubleMatrix1D doubleMatrix1D2) {
        DoubleMatrix1D doubleMatrix1D3 = this.make(doubleMatrix1D.size() + doubleMatrix1D2.size());
        doubleMatrix1D3.viewPart(0, doubleMatrix1D.size()).assign(doubleMatrix1D);
        doubleMatrix1D3.viewPart(doubleMatrix1D.size(), doubleMatrix1D2.size()).assign(doubleMatrix1D2);
        return doubleMatrix1D3;
    }

    public DoubleMatrix1D ascending(int n) {
        DoubleFunctions doubleFunctions = DoubleFunctions.functions;
        return this.descending(n).assign(DoubleFunctions.chain(DoubleFunctions.neg, DoubleFunctions.minus(n)));
    }

    public DoubleMatrix1D descending(int n) {
        DoubleMatrix1D doubleMatrix1D = this.make(n);
        int n2 = 0;
        int n3 = n;
        while (--n3 >= 0) {
            doubleMatrix1D.setQuick(n3, n2++);
        }
        return doubleMatrix1D;
    }

    public DoubleMatrix1D make(double[] dArray) {
        if (this == sparse) {
            return new SparseDoubleMatrix1D(dArray);
        }
        return new DenseDoubleMatrix1D(dArray);
    }

    public DoubleMatrix1D make(DoubleMatrix1D[] doubleMatrix1DArray) {
        if (doubleMatrix1DArray.length == 0) {
            return this.make(0);
        }
        int n = 0;
        for (int i = 0; i < doubleMatrix1DArray.length; ++i) {
            n += doubleMatrix1DArray[i].size();
        }
        DoubleMatrix1D doubleMatrix1D = this.make(n);
        n = 0;
        for (int i = 0; i < doubleMatrix1DArray.length; ++i) {
            doubleMatrix1D.viewPart(n, doubleMatrix1DArray[i].size()).assign(doubleMatrix1DArray[i]);
            n += doubleMatrix1DArray[i].size();
        }
        return doubleMatrix1D;
    }

    public DoubleMatrix1D make(int n) {
        if (this == sparse) {
            return new SparseDoubleMatrix1D(n);
        }
        return new DenseDoubleMatrix1D(n);
    }

    public DoubleMatrix1D make(int n, double d) {
        return this.make(n).assign(d);
    }

    public DoubleMatrix1D make(AbstractDoubleList abstractDoubleList) {
        int n = abstractDoubleList.size();
        DoubleMatrix1D doubleMatrix1D = this.make(n);
        int n2 = n;
        while (--n2 >= 0) {
            doubleMatrix1D.set(n2, abstractDoubleList.get(n2));
        }
        return doubleMatrix1D;
    }

    public DoubleMatrix1D random(int n) {
        return this.make(n).assign(DoubleFunctions.random());
    }

    public DoubleMatrix1D repeat(DoubleMatrix1D doubleMatrix1D, int n) {
        int n2 = doubleMatrix1D.size();
        DoubleMatrix1D doubleMatrix1D2 = this.make(n * n2);
        int n3 = n;
        while (--n3 >= 0) {
            doubleMatrix1D2.viewPart(n2 * n3, n2).assign(doubleMatrix1D);
        }
        return doubleMatrix1D2;
    }

    public DoubleMatrix1D sample(int n, double d, double d2) {
        double d3 = 1.0E-9;
        if (d2 < 0.0 - d3 || d2 > 1.0 + d3) {
            throw new IllegalArgumentException();
        }
        if (d2 < 0.0) {
            d2 = 0.0;
        }
        if (d2 > 1.0) {
            d2 = 1.0;
        }
        DoubleMatrix1D doubleMatrix1D = this.make(n);
        int n2 = (int)Math.round((double)n * d2);
        if (n2 == 0) {
            return doubleMatrix1D;
        }
        DoubleRandomSamplingAssistant doubleRandomSamplingAssistant = new DoubleRandomSamplingAssistant(n2, n, new DoubleMersenneTwister());
        int n3 = n;
        while (--n3 >= 0) {
            if (!doubleRandomSamplingAssistant.sampleNextElement()) continue;
            doubleMatrix1D.set(n3, d);
        }
        return doubleMatrix1D;
    }

    public DoubleArrayList toList(DoubleMatrix1D doubleMatrix1D) {
        int n = doubleMatrix1D.size();
        DoubleArrayList doubleArrayList = new DoubleArrayList(n);
        doubleArrayList.setSize(n);
        int n2 = n;
        while (--n2 >= 0) {
            doubleArrayList.set(n2, doubleMatrix1D.get(n2));
        }
        return doubleArrayList;
    }
}

