/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdcomplex.impl;

import cern.colt.matrix.tdcomplex.DComplexMatrix1D;
import cern.colt.matrix.tdcomplex.DComplexMatrix2D;
import cern.colt.matrix.tdcomplex.DComplexMatrix3D;
import cern.colt.matrix.tdcomplex.impl.SelectedSparseDComplexMatrix1D;
import cern.colt.matrix.tdcomplex.impl.SparseDComplexMatrix2D;
import cern.colt.matrix.tdcomplex.impl.SparseDComplexMatrix3D;
import cern.colt.matrix.tdouble.DoubleMatrix1D;
import cern.colt.matrix.tdouble.impl.SparseDoubleMatrix1D;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SparseDComplexMatrix1D
extends DComplexMatrix1D {
    private static final long serialVersionUID = -7792866167410993582L;
    protected ConcurrentHashMap<Integer, double[]> elements;

    public SparseDComplexMatrix1D(double[] dArray) {
        this(dArray.length);
        this.assign(dArray);
    }

    public SparseDComplexMatrix1D(int n) {
        this.setUp(n);
        this.elements = new ConcurrentHashMap(n / 1000);
    }

    protected SparseDComplexMatrix1D(int n, ConcurrentHashMap<Integer, double[]> concurrentHashMap, int n2, int n3) {
        this.setUp(n, n2, n3);
        this.elements = concurrentHashMap;
        this.isNoView = false;
    }

    @Override
    public DComplexMatrix1D assign(double[] dArray) {
        if (this.isNoView && dArray[0] == 0.0 && dArray[1] == 0.0) {
            this.elements.clear();
        } else {
            super.assign(dArray);
        }
        return this;
    }

    @Override
    public int cardinality() {
        if (this.isNoView) {
            return this.elements.size();
        }
        return super.cardinality();
    }

    @Override
    public double[] getQuick(int n) {
        double[] dArray = this.elements.get(this.zero + n * this.stride);
        if (dArray != null) {
            return new double[]{dArray[0], dArray[1]};
        }
        return new double[2];
    }

    @Override
    public ConcurrentHashMap<Integer, double[]> elements() {
        return this.elements;
    }

    @Override
    protected boolean haveSharedCellsRaw(DComplexMatrix1D dComplexMatrix1D) {
        if (dComplexMatrix1D instanceof SelectedSparseDComplexMatrix1D) {
            SelectedSparseDComplexMatrix1D selectedSparseDComplexMatrix1D = (SelectedSparseDComplexMatrix1D)dComplexMatrix1D;
            return this.elements == selectedSparseDComplexMatrix1D.elements;
        }
        if (dComplexMatrix1D instanceof SparseDComplexMatrix1D) {
            SparseDComplexMatrix1D sparseDComplexMatrix1D = (SparseDComplexMatrix1D)dComplexMatrix1D;
            return this.elements == sparseDComplexMatrix1D.elements;
        }
        return false;
    }

    @Override
    public long index(int n) {
        return this.zero + n * this.stride;
    }

    @Override
    public DComplexMatrix1D like(int n) {
        return new SparseDComplexMatrix1D(n);
    }

    @Override
    public DComplexMatrix2D like2D(int n, int n2) {
        return new SparseDComplexMatrix2D(n, n2);
    }

    @Override
    public DComplexMatrix2D reshape(int n, int n2) {
        if (n * n2 != this.size) {
            throw new IllegalArgumentException("rows*cols != size");
        }
        SparseDComplexMatrix2D sparseDComplexMatrix2D = new SparseDComplexMatrix2D(n, n2);
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                double[] dArray;
                if ((dArray = this.getQuick(n3++))[0] == 0.0 && dArray[1] == 0.0) continue;
                ((DComplexMatrix2D)sparseDComplexMatrix2D).setQuick(j, i, dArray);
            }
        }
        return sparseDComplexMatrix2D;
    }

    @Override
    public DComplexMatrix3D reshape(int n, int n2, int n3) {
        if (n * n2 * n3 != this.size) {
            throw new IllegalArgumentException("slices*rows*cols != size");
        }
        SparseDComplexMatrix3D sparseDComplexMatrix3D = new SparseDComplexMatrix3D(n, n2, n3);
        int n4 = 0;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n3; ++j) {
                for (int k = 0; k < n2; ++k) {
                    double[] dArray;
                    if ((dArray = this.getQuick(n4++))[0] == 0.0 && dArray[1] == 0.0) continue;
                    ((DComplexMatrix3D)sparseDComplexMatrix3D).setQuick(i, k, j, dArray);
                }
            }
        }
        return sparseDComplexMatrix3D;
    }

    @Override
    public void setQuick(int n, double[] dArray) {
        int n2 = this.zero + n * this.stride;
        if (dArray[0] == 0.0 && dArray[1] == 0.0) {
            this.elements.remove(n2);
        } else {
            this.elements.put(n2, dArray);
        }
    }

    @Override
    public void setQuick(int n, double d, double d2) {
        int n2 = this.zero + n * this.stride;
        if (d == 0.0 && d2 == 0.0) {
            this.elements.remove(n2);
        } else {
            this.elements.put(n2, new double[]{d, d2});
        }
    }

    @Override
    protected DComplexMatrix1D viewSelectionLike(int[] nArray) {
        return new SelectedSparseDComplexMatrix1D(this.elements, nArray);
    }

    @Override
    public DoubleMatrix1D getImaginaryPart() {
        int n = this.size();
        SparseDoubleMatrix1D sparseDoubleMatrix1D = new SparseDoubleMatrix1D(n);
        double[] dArray = new double[2];
        for (int i = 0; i < n; ++i) {
            dArray = this.getQuick(i);
            ((DoubleMatrix1D)sparseDoubleMatrix1D).setQuick(i, dArray[1]);
        }
        return sparseDoubleMatrix1D;
    }

    @Override
    public DoubleMatrix1D getRealPart() {
        int n = this.size();
        SparseDoubleMatrix1D sparseDoubleMatrix1D = new SparseDoubleMatrix1D(n);
        double[] dArray = new double[2];
        for (int i = 0; i < n; ++i) {
            dArray = this.getQuick(i);
            ((DoubleMatrix1D)sparseDoubleMatrix1D).setQuick(i, dArray[0]);
        }
        return sparseDoubleMatrix1D;
    }
}

