/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdcomplex.impl;

import cern.colt.matrix.AbstractMatrix2D;
import cern.colt.matrix.tdcomplex.DComplexMatrix1D;
import cern.colt.matrix.tdcomplex.DComplexMatrix2D;
import cern.colt.matrix.tdcomplex.impl.SelectedSparseDComplexMatrix1D;
import cern.colt.matrix.tdcomplex.impl.SparseDComplexMatrix1D;
import cern.colt.matrix.tdcomplex.impl.SparseDComplexMatrix2D;
import cern.colt.matrix.tdouble.DoubleMatrix2D;
import cern.colt.matrix.tdouble.impl.SparseDoubleMatrix2D;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SelectedSparseDComplexMatrix2D
extends DComplexMatrix2D {
    protected ConcurrentHashMap<Integer, double[]> elements;
    protected int[] rowOffsets;
    protected int[] columnOffsets;
    protected int offset;

    protected SelectedSparseDComplexMatrix2D(int n, int n2, ConcurrentHashMap<Integer, double[]> concurrentHashMap, int n3, int n4, int n5, int n6, int[] nArray, int[] nArray2, int n7) {
        this.setUp(n, n2, n3, n4, n5, n6);
        this.elements = concurrentHashMap;
        this.rowOffsets = nArray;
        this.columnOffsets = nArray2;
        this.offset = n7;
        this.isNoView = false;
    }

    protected SelectedSparseDComplexMatrix2D(ConcurrentHashMap<Integer, double[]> concurrentHashMap, int[] nArray, int[] nArray2, int n) {
        this(nArray.length, nArray2.length, concurrentHashMap, 0, 0, 1, 1, nArray, nArray2, n);
    }

    @Override
    protected int _columnOffset(int n) {
        return this.columnOffsets[n];
    }

    @Override
    protected int _rowOffset(int n) {
        return this.rowOffsets[n];
    }

    @Override
    public double[] getQuick(int n, int n2) {
        return this.elements.get(this.offset + this.rowOffsets[this.rowZero + n * this.rowStride] + this.columnOffsets[this.columnZero + n2 * this.columnStride]);
    }

    @Override
    public ConcurrentHashMap<Integer, double[]> elements() {
        return this.elements;
    }

    @Override
    protected boolean haveSharedCellsRaw(DComplexMatrix2D dComplexMatrix2D) {
        if (dComplexMatrix2D instanceof SelectedSparseDComplexMatrix2D) {
            SelectedSparseDComplexMatrix2D selectedSparseDComplexMatrix2D = (SelectedSparseDComplexMatrix2D)dComplexMatrix2D;
            return this.elements == selectedSparseDComplexMatrix2D.elements;
        }
        if (dComplexMatrix2D instanceof SparseDComplexMatrix2D) {
            SparseDComplexMatrix2D sparseDComplexMatrix2D = (SparseDComplexMatrix2D)dComplexMatrix2D;
            return this.elements == sparseDComplexMatrix2D.elements;
        }
        return false;
    }

    @Override
    public long index(int n, int n2) {
        return this.offset + this.rowOffsets[this.rowZero + n * this.rowStride] + this.columnOffsets[this.columnZero + n2 * this.columnStride];
    }

    @Override
    public DComplexMatrix2D like(int n, int n2) {
        return new SparseDComplexMatrix2D(n, n2);
    }

    @Override
    public DComplexMatrix1D like1D(int n) {
        return new SparseDComplexMatrix1D(n);
    }

    @Override
    protected DComplexMatrix1D like1D(int n, int n2, int n3) {
        throw new InternalError();
    }

    @Override
    public void setQuick(int n, int n2, double[] dArray) {
        int n3 = this.offset + this.rowOffsets[this.rowZero + n * this.rowStride] + this.columnOffsets[this.columnZero + n2 * this.columnStride];
        if (dArray[0] == 0.0 && dArray[1] == 0.0) {
            this.elements.remove(n3);
        } else {
            this.elements.put(n3, dArray);
        }
    }

    @Override
    public DComplexMatrix1D vectorize() {
        SparseDComplexMatrix1D sparseDComplexMatrix1D = new SparseDComplexMatrix1D(this.size());
        int n = 0;
        for (int i = 0; i < this.columns; ++i) {
            for (int j = 0; j < this.rows; ++j) {
                sparseDComplexMatrix1D.setQuick(n++, this.getQuick(i, j));
            }
        }
        return sparseDComplexMatrix1D;
    }

    @Override
    public void setQuick(int n, int n2, double d, double d2) {
        int n3 = this.offset + this.rowOffsets[this.rowZero + n * this.rowStride] + this.columnOffsets[this.columnZero + n2 * this.columnStride];
        if (d == 0.0 && d2 == 0.0) {
            this.elements.remove(n3);
        } else {
            this.elements.put(n3, new double[]{d, d2});
        }
    }

    @Override
    protected void setUp(int n, int n2) {
        super.setUp(n, n2);
        this.rowStride = 1;
        this.columnStride = 1;
        this.offset = 0;
    }

    @Override
    protected AbstractMatrix2D vDice() {
        super.vDice();
        int[] nArray = this.rowOffsets;
        this.rowOffsets = this.columnOffsets;
        this.columnOffsets = nArray;
        this.isNoView = false;
        return this;
    }

    @Override
    public DComplexMatrix1D viewColumn(int n) {
        this.checkColumn(n);
        int n2 = this.rows;
        int n3 = this.rowZero;
        int n4 = this.rowStride;
        int[] nArray = this.rowOffsets;
        int n5 = this.offset + this._columnOffset(this._columnRank(n));
        return new SelectedSparseDComplexMatrix1D(n2, this.elements, n3, n4, nArray, n5);
    }

    @Override
    public DComplexMatrix1D viewRow(int n) {
        this.checkRow(n);
        int n2 = this.columns;
        int n3 = this.columnZero;
        int n4 = this.columnStride;
        int[] nArray = this.columnOffsets;
        int n5 = this.offset + this._rowOffset(this._rowRank(n));
        return new SelectedSparseDComplexMatrix1D(n2, this.elements, n3, n4, nArray, n5);
    }

    @Override
    protected DComplexMatrix2D viewSelectionLike(int[] nArray, int[] nArray2) {
        return new SelectedSparseDComplexMatrix2D(this.elements, nArray, nArray2, this.offset);
    }

    @Override
    public DoubleMatrix2D getImaginaryPart() {
        SparseDoubleMatrix2D sparseDoubleMatrix2D = new SparseDoubleMatrix2D(this.rows, this.columns);
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.columns; ++j) {
                double[] dArray = this.getQuick(i, j);
                ((DoubleMatrix2D)sparseDoubleMatrix2D).setQuick(i, j, dArray[1]);
            }
        }
        return sparseDoubleMatrix2D;
    }

    @Override
    public DoubleMatrix2D getRealPart() {
        SparseDoubleMatrix2D sparseDoubleMatrix2D = new SparseDoubleMatrix2D(this.rows, this.columns);
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.columns; ++j) {
                double[] dArray = this.getQuick(i, j);
                ((DoubleMatrix2D)sparseDoubleMatrix2D).setQuick(i, j, dArray[0]);
            }
        }
        return sparseDoubleMatrix2D;
    }
}

