/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdcomplex.impl;

import cern.colt.matrix.AbstractMatrix3D;
import cern.colt.matrix.tdcomplex.DComplexMatrix1D;
import cern.colt.matrix.tdcomplex.DComplexMatrix2D;
import cern.colt.matrix.tdcomplex.DComplexMatrix3D;
import cern.colt.matrix.tdcomplex.impl.DenseDComplexMatrix3D;
import cern.colt.matrix.tdcomplex.impl.SelectedDenseDComplexMatrix2D;
import cern.colt.matrix.tdouble.DoubleMatrix3D;
import cern.colt.matrix.tdouble.impl.DenseDoubleMatrix3D;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.util.concurrent.Future;

class SelectedDenseDComplexMatrix3D
extends DComplexMatrix3D {
    private static final long serialVersionUID = 6875063762867388470L;
    protected double[] elements;
    protected int[] sliceOffsets;
    protected int[] rowOffsets;
    protected int[] columnOffsets;
    protected int offset;

    protected SelectedDenseDComplexMatrix3D(double[] dArray, int[] nArray, int[] nArray2, int[] nArray3, int n) {
        int n2 = nArray.length;
        int n3 = nArray2.length;
        int n4 = nArray3.length;
        this.setUp(n2, n3, n4);
        this.elements = dArray;
        this.sliceOffsets = nArray;
        this.rowOffsets = nArray2;
        this.columnOffsets = nArray3;
        this.offset = n;
        this.isNoView = false;
    }

    protected int _columnOffset(int n) {
        return this.columnOffsets[n];
    }

    protected int _rowOffset(int n) {
        return this.rowOffsets[n];
    }

    protected int _sliceOffset(int n) {
        return this.sliceOffsets[n];
    }

    public double[] getQuick(int n, int n2, int n3) {
        int n4 = this.sliceZero + n * this.sliceStride;
        int n5 = this.rowZero + n2 * this.rowStride;
        int n6 = this.columnZero + n3 * this.columnStride;
        return new double[]{this.elements[this.offset + this.sliceOffsets[n4] + this.rowOffsets[n5] + this.columnOffsets[n6]], this.elements[this.offset + this.sliceOffsets[n4] + this.rowOffsets[n5] + this.columnOffsets[n6] + 1]};
    }

    public double[] elements() {
        throw new IllegalAccessError("getElements() is not supported for SelectedDenseComplexMatrix3D.");
    }

    protected boolean haveSharedCellsRaw(DComplexMatrix3D dComplexMatrix3D) {
        if (dComplexMatrix3D instanceof SelectedDenseDComplexMatrix3D) {
            SelectedDenseDComplexMatrix3D selectedDenseDComplexMatrix3D = (SelectedDenseDComplexMatrix3D)dComplexMatrix3D;
            return this.elements == selectedDenseDComplexMatrix3D.elements;
        }
        if (dComplexMatrix3D instanceof DenseDComplexMatrix3D) {
            DenseDComplexMatrix3D denseDComplexMatrix3D = (DenseDComplexMatrix3D)dComplexMatrix3D;
            return this.elements == denseDComplexMatrix3D.elements;
        }
        return false;
    }

    public long index(int n, int n2, int n3) {
        return this.offset + this.sliceOffsets[this.sliceZero + n * this.sliceStride] + this.rowOffsets[this.rowZero + n2 * this.rowStride] + this.columnOffsets[this.columnZero + n3 * this.columnStride];
    }

    public DComplexMatrix3D like(int n, int n2, int n3) {
        return new DenseDComplexMatrix3D(n, n2, n3);
    }

    protected DComplexMatrix2D like2D(int n, int n2, int n3, int n4, int n5, int n6) {
        throw new InternalError();
    }

    public void setQuick(int n, int n2, int n3, double[] dArray) {
        int n4 = this.sliceZero + n * this.sliceStride;
        int n5 = this.rowZero + n2 * this.rowStride;
        int n6 = this.columnZero + n3 * this.columnStride;
        this.elements[this.offset + this.sliceOffsets[n4] + this.rowOffsets[n5] + this.columnOffsets[n6]] = dArray[0];
        this.elements[this.offset + this.sliceOffsets[n4] + this.rowOffsets[n5] + this.columnOffsets[n6] + 1] = dArray[1];
    }

    public void setQuick(int n, int n2, int n3, double d, double d2) {
        int n4 = this.sliceZero + n * this.sliceStride;
        int n5 = this.rowZero + n2 * this.rowStride;
        int n6 = this.columnZero + n3 * this.columnStride;
        this.elements[this.offset + this.sliceOffsets[n4] + this.rowOffsets[n5] + this.columnOffsets[n6]] = d;
        this.elements[this.offset + this.sliceOffsets[n4] + this.rowOffsets[n5] + this.columnOffsets[n6] + 1] = d2;
    }

    protected void setUp(int n, int n2, int n3) {
        super.setUp(n, n2, n3);
        this.sliceStride = 1;
        this.rowStride = 1;
        this.columnStride = 1;
        this.offset = 0;
    }

    protected AbstractMatrix3D vDice(int n, int n2, int n3) {
        super.vDice(n, n2, n3);
        int[][] nArrayArray = new int[][]{this.sliceOffsets, this.rowOffsets, this.columnOffsets};
        this.sliceOffsets = nArrayArray[n];
        this.rowOffsets = nArrayArray[n2];
        this.columnOffsets = nArrayArray[n3];
        return this;
    }

    public DComplexMatrix2D viewColumn(int n) {
        this.checkColumn(n);
        int n2 = this.slices;
        int n3 = this.rows;
        int n4 = this.sliceZero;
        int n5 = this.rowZero;
        int n6 = this.offset + this._columnOffset(this._columnRank(n));
        int n7 = this.sliceStride;
        int n8 = this.rowStride;
        int[] nArray = this.sliceOffsets;
        int[] nArray2 = this.rowOffsets;
        return new SelectedDenseDComplexMatrix2D(n2, n3, this.elements, n4, n5, n7, n8, nArray, nArray2, n6);
    }

    public DComplexMatrix2D viewRow(int n) {
        this.checkRow(n);
        int n2 = this.slices;
        int n3 = this.columns;
        int n4 = this.sliceZero;
        int n5 = this.columnZero;
        int n6 = this.offset + this._rowOffset(this._rowRank(n));
        int n7 = this.sliceStride;
        int n8 = this.columnStride;
        int[] nArray = this.sliceOffsets;
        int[] nArray2 = this.columnOffsets;
        return new SelectedDenseDComplexMatrix2D(n2, n3, this.elements, n4, n5, n7, n8, nArray, nArray2, n6);
    }

    protected DComplexMatrix3D viewSelectionLike(int[] nArray, int[] nArray2, int[] nArray3) {
        return new SelectedDenseDComplexMatrix3D(this.elements, nArray, nArray2, nArray3, this.offset);
    }

    public DComplexMatrix2D viewSlice(int n) {
        this.checkSlice(n);
        int n2 = this.rows;
        int n3 = this.columns;
        int n4 = this.rowZero;
        int n5 = this.columnZero;
        int n6 = this.offset + this._sliceOffset(this._sliceRank(n));
        int n7 = this.rowStride;
        int n8 = this.columnStride;
        int[] nArray = this.rowOffsets;
        int[] nArray2 = this.columnOffsets;
        return new SelectedDenseDComplexMatrix2D(n2, n3, this.elements, n4, n5, n7, n8, nArray, nArray2, n6);
    }

    public DComplexMatrix1D vectorize() {
        throw new IllegalArgumentException("This method is not supported yet");
    }

    public DoubleMatrix3D getImaginaryPart() {
        final DenseDoubleMatrix3D denseDoubleMatrix3D = new DenseDoubleMatrix3D(this.slices, this.rows, this.columns);
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            Future[] futureArray = new Future[n];
            int n2 = this.slices / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.slices : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            for (int j = 0; j < SelectedDenseDComplexMatrix3D.this.rows; ++j) {
                                for (int k = 0; k < SelectedDenseDComplexMatrix3D.this.columns; ++k) {
                                    double[] dArray = SelectedDenseDComplexMatrix3D.this.getQuick(i, j, k);
                                    denseDoubleMatrix3D.setQuick(i, j, k, dArray[1]);
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.slices; ++i) {
                for (int j = 0; j < this.rows; ++j) {
                    for (int k = 0; k < this.columns; ++k) {
                        double[] dArray = this.getQuick(i, j, k);
                        denseDoubleMatrix3D.setQuick(i, j, k, dArray[1]);
                    }
                }
            }
        }
        return denseDoubleMatrix3D;
    }

    public DoubleMatrix3D getRealPart() {
        final DenseDoubleMatrix3D denseDoubleMatrix3D = new DenseDoubleMatrix3D(this.slices, this.rows, this.columns);
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            Future[] futureArray = new Future[n];
            int n2 = this.slices / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.slices : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            for (int j = 0; j < SelectedDenseDComplexMatrix3D.this.rows; ++j) {
                                for (int k = 0; k < SelectedDenseDComplexMatrix3D.this.columns; ++k) {
                                    double[] dArray = SelectedDenseDComplexMatrix3D.this.getQuick(i, j, k);
                                    denseDoubleMatrix3D.setQuick(i, j, k, dArray[0]);
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.slices; ++i) {
                for (int j = 0; j < this.rows; ++j) {
                    for (int k = 0; k < this.columns; ++k) {
                        double[] dArray = this.getQuick(i, j, k);
                        denseDoubleMatrix3D.setQuick(i, j, k, dArray[0]);
                    }
                }
            }
        }
        return denseDoubleMatrix3D;
    }
}

