/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdcomplex.impl;

import cern.colt.function.tdcomplex.DComplexDComplexDComplexFunction;
import cern.colt.function.tdcomplex.DComplexDComplexFunction;
import cern.colt.function.tdcomplex.DComplexProcedure;
import cern.colt.function.tdcomplex.DComplexRealFunction;
import cern.colt.function.tdcomplex.IntIntDComplexFunction;
import cern.colt.list.tint.IntArrayList;
import cern.colt.matrix.AbstractMatrix1D;
import cern.colt.matrix.tdcomplex.DComplexMatrix1D;
import cern.colt.matrix.tdcomplex.DComplexMatrix2D;
import cern.colt.matrix.tdcomplex.impl.DenseDComplexMatrix1D;
import cern.colt.matrix.tdcomplex.impl.SelectedDenseDComplexMatrix2D;
import cern.colt.matrix.tdouble.DoubleMatrix2D;
import cern.colt.matrix.tdouble.impl.DenseDoubleMatrix2D;
import cern.jet.math.tdcomplex.DComplexFunctions;
import cern.jet.math.tdcomplex.DComplexMult;
import edu.emory.mathcs.jtransforms.fft.DoubleFFT_2D;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import jcuda.jcublas.JCuDoubleComplex;
import jcuda.jcublas.JCublas;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DenseDComplexMatrix2D
extends DComplexMatrix2D {
    static final long serialVersionUID = 1020177651L;
    private DoubleFFT_2D fft2;
    protected double[] elements;

    public DenseDComplexMatrix2D(double[][] dArray) {
        this(dArray.length, dArray.length == 0 ? 0 : dArray[0].length / 2);
        this.assign(dArray);
    }

    public DenseDComplexMatrix2D(DoubleMatrix2D doubleMatrix2D) {
        this(doubleMatrix2D.rows(), doubleMatrix2D.columns());
        this.assignReal(doubleMatrix2D);
    }

    public DenseDComplexMatrix2D(int n, int n2) {
        this.setUp(n, n2, 0, 0, 2 * n2, 2);
        this.elements = new double[n * 2 * n2];
    }

    public DenseDComplexMatrix2D(int n, int n2, double[] dArray, int n3, int n4, int n5, int n6) {
        this.setUp(n, n2, n3, n4, n5, n6);
        this.elements = dArray;
        this.isNoView = false;
    }

    @Override
    public double[] aggregate(final DComplexDComplexDComplexFunction dComplexDComplexDComplexFunction, final DComplexDComplexFunction dComplexDComplexFunction) {
        double[] dArray = new double[2];
        if (this.size() == 0) {
            dArray[0] = Double.NaN;
            dArray[1] = Double.NaN;
            return dArray;
        }
        final int n = (int)this.index(0, 0);
        double[] dArray2 = null;
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            Future[] futureArray = new Future[n2];
            double[][] dArray3 = new double[n2][2];
            int n3 = this.rows / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? this.rows : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Callable<double[]>(){

                    @Override
                    public double[] call() throws Exception {
                        int n3 = n + n4 * DenseDComplexMatrix2D.this.rowStride;
                        double[] dArray = dComplexDComplexFunction.apply(DenseDComplexMatrix2D.this.elements[n3], DenseDComplexMatrix2D.this.elements[n3 + 1]);
                        int n2 = 1;
                        for (int i = n4; i < n5; ++i) {
                            for (int j = n2; j < DenseDComplexMatrix2D.this.columns; ++j) {
                                n3 = n + i * DenseDComplexMatrix2D.this.rowStride + j * DenseDComplexMatrix2D.this.columnStride;
                                dArray = dComplexDComplexDComplexFunction.apply(dArray, dComplexDComplexFunction.apply(DenseDComplexMatrix2D.this.elements[n3], DenseDComplexMatrix2D.this.elements[n3 + 1]));
                            }
                            n2 = 0;
                        }
                        return dArray;
                    }
                });
            }
            dArray2 = ConcurrencyUtils.waitForCompletion(futureArray, dComplexDComplexDComplexFunction);
        } else {
            dArray2 = dComplexDComplexFunction.apply(this.elements[n], this.elements[n + 1]);
            int n6 = 1;
            for (int i = 0; i < this.rows; ++i) {
                for (int j = n6; j < this.columns; ++j) {
                    int n7 = n + i * this.rowStride + j * this.columnStride;
                    dArray2 = dComplexDComplexDComplexFunction.apply(dArray2, dComplexDComplexFunction.apply(this.elements[n7], this.elements[n7 + 1]));
                }
                n6 = 0;
            }
        }
        return dArray2;
    }

    @Override
    public double[] aggregate(DComplexMatrix2D dComplexMatrix2D, final DComplexDComplexDComplexFunction dComplexDComplexDComplexFunction, final DComplexDComplexDComplexFunction dComplexDComplexDComplexFunction2) {
        if (!(dComplexMatrix2D instanceof DenseDComplexMatrix2D)) {
            return super.aggregate(dComplexMatrix2D, dComplexDComplexDComplexFunction, dComplexDComplexDComplexFunction2);
        }
        this.checkShape(dComplexMatrix2D);
        double[] dArray = new double[2];
        if (this.size() == 0) {
            dArray[0] = Double.NaN;
            dArray[1] = Double.NaN;
            return dArray;
        }
        final int n = (int)this.index(0, 0);
        final int n2 = (int)dComplexMatrix2D.index(0, 0);
        final int n3 = dComplexMatrix2D.rowStride();
        final int n4 = dComplexMatrix2D.columnStride();
        final double[] dArray2 = (double[])dComplexMatrix2D.elements();
        double[] dArray3 = null;
        int n5 = ConcurrencyUtils.getNumberOfThreads();
        if (n5 > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            Future[] futureArray = new Future[n5];
            double[][] dArray4 = new double[n5][2];
            int n6 = this.rows / n5;
            for (int i = 0; i < n5; ++i) {
                final int n7 = i * n6;
                final int n8 = i == n5 - 1 ? this.rows : n7 + n6;
                futureArray[i] = ConcurrencyUtils.submit(new Callable<double[]>(){

                    @Override
                    public double[] call() throws Exception {
                        int n5 = n + n7 * DenseDComplexMatrix2D.this.rowStride;
                        int n22 = n2 + n7 * n3;
                        double[] dArray = dComplexDComplexDComplexFunction2.apply(new double[]{DenseDComplexMatrix2D.this.elements[n5], DenseDComplexMatrix2D.this.elements[n5 + 1]}, new double[]{dArray2[n22], dArray2[n22 + 1]});
                        int n32 = 1;
                        for (int i = n7; i < n8; ++i) {
                            for (int j = n32; j < DenseDComplexMatrix2D.this.columns; ++j) {
                                n5 = n + i * DenseDComplexMatrix2D.this.rowStride + j * DenseDComplexMatrix2D.this.columnStride;
                                n22 = n2 + i * n3 + j * n4;
                                dArray = dComplexDComplexDComplexFunction.apply(dArray, dComplexDComplexDComplexFunction2.apply(new double[]{DenseDComplexMatrix2D.this.elements[n5], DenseDComplexMatrix2D.this.elements[n5 + 1]}, new double[]{dArray2[n22], dArray2[n22 + 1]}));
                            }
                            n32 = 0;
                        }
                        return dArray;
                    }
                });
            }
            dArray3 = ConcurrencyUtils.waitForCompletion(futureArray, dComplexDComplexDComplexFunction);
        } else {
            dArray3 = dComplexDComplexDComplexFunction2.apply(new double[]{this.elements[n], this.elements[n + 1]}, new double[]{dArray2[n2], dArray2[n2 + 1]});
            int n9 = 1;
            for (int i = 0; i < this.rows; ++i) {
                for (int j = n9; j < this.columns; ++j) {
                    int n10 = n + i * this.rowStride + j * this.columnStride;
                    int n11 = n2 + i * n3 + j * n4;
                    dArray3 = dComplexDComplexDComplexFunction.apply(dArray3, dComplexDComplexDComplexFunction2.apply(new double[]{this.elements[n10], this.elements[n10 + 1]}, new double[]{dArray2[n11], dArray2[n11 + 1]}));
                }
                n9 = 0;
            }
        }
        return dArray3;
    }

    @Override
    public DComplexMatrix2D assign(final DComplexDComplexFunction dComplexDComplexFunction) {
        final int n = (int)this.index(0, 0);
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            Object[] objectArray;
            if (dComplexDComplexFunction instanceof DComplexMult) {
                objectArray = ((DComplexMult)dComplexDComplexFunction).multiplicator;
                if (objectArray[0] == 1.0 && objectArray[1] == 0.0) {
                    return this;
                }
                if (objectArray[0] == 0.0 && objectArray[1] == 0.0) {
                    return this.assign(0.0, 0.0);
                }
            }
            objectArray = new Future[n2];
            int n3 = this.rows / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? this.rows : n4 + n3;
                objectArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n6 = n + n4 * DenseDComplexMatrix2D.this.rowStride;
                        double[] dArray = new double[2];
                        if (dComplexDComplexFunction instanceof DComplexMult) {
                            double[] dArray2 = ((DComplexMult)dComplexDComplexFunction).multiplicator;
                            for (int i = n4; i < n5; ++i) {
                                int n2 = n6;
                                for (int j = 0; j < DenseDComplexMatrix2D.this.columns; ++j) {
                                    dArray[0] = DenseDComplexMatrix2D.this.elements[n2];
                                    dArray[1] = DenseDComplexMatrix2D.this.elements[n2 + 1];
                                    DenseDComplexMatrix2D.this.elements[n2] = dArray[0] * dArray2[0] - dArray[1] * dArray2[1];
                                    DenseDComplexMatrix2D.this.elements[n2 + 1] = dArray[1] * dArray2[0] + dArray[0] * dArray2[1];
                                    n2 += DenseDComplexMatrix2D.this.columnStride;
                                }
                                n6 += DenseDComplexMatrix2D.this.rowStride;
                            }
                        } else {
                            for (int i = n4; i < n5; ++i) {
                                int n3 = n6;
                                for (int j = 0; j < DenseDComplexMatrix2D.this.columns; ++j) {
                                    dArray = dComplexDComplexFunction.apply(DenseDComplexMatrix2D.this.elements[n3], DenseDComplexMatrix2D.this.elements[n3 + 1]);
                                    DenseDComplexMatrix2D.this.elements[n3] = dArray[0];
                                    DenseDComplexMatrix2D.this.elements[n3 + 1] = dArray[1];
                                    n3 += DenseDComplexMatrix2D.this.columnStride;
                                }
                                n6 += DenseDComplexMatrix2D.this.rowStride;
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(objectArray);
        } else {
            int n6 = n;
            double[] dArray = new double[2];
            if (dComplexDComplexFunction instanceof DComplexMult) {
                double[] dArray2 = ((DComplexMult)dComplexDComplexFunction).multiplicator;
                for (int i = 0; i < this.rows; ++i) {
                    int n7 = n6;
                    for (int j = 0; j < this.columns; ++j) {
                        dArray[0] = this.elements[n7];
                        dArray[1] = this.elements[n7 + 1];
                        this.elements[n7] = dArray[0] * dArray2[0] - dArray[1] * dArray2[1];
                        this.elements[n7 + 1] = dArray[1] * dArray2[0] + dArray[0] * dArray2[1];
                        n7 += this.columnStride;
                    }
                    n6 += this.rowStride;
                }
            } else {
                for (int i = 0; i < this.rows; ++i) {
                    int n8 = n6;
                    for (int j = 0; j < this.columns; ++j) {
                        dArray = dComplexDComplexFunction.apply(this.elements[n8], this.elements[n8 + 1]);
                        this.elements[n8] = dArray[0];
                        this.elements[n8 + 1] = dArray[1];
                        n8 += this.columnStride;
                    }
                    n6 += this.rowStride;
                }
            }
        }
        return this;
    }

    @Override
    public DComplexMatrix2D assign(final DComplexProcedure dComplexProcedure, final DComplexDComplexFunction dComplexDComplexFunction) {
        final int n = (int)this.index(0, 0);
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            Future[] futureArray = new Future[n2];
            int n3 = this.rows / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? this.rows : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        double[] dArray = new double[2];
                        int n3 = n + n4 * DenseDComplexMatrix2D.this.rowStride;
                        for (int i = n4; i < n5; ++i) {
                            int n2 = n3;
                            for (int j = 0; j < DenseDComplexMatrix2D.this.columns; ++j) {
                                dArray[0] = DenseDComplexMatrix2D.this.elements[n2];
                                dArray[1] = DenseDComplexMatrix2D.this.elements[n2 + 1];
                                if (dComplexProcedure.apply(dArray)) {
                                    dArray = dComplexDComplexFunction.apply(dArray);
                                    DenseDComplexMatrix2D.this.elements[n2] = dArray[0];
                                    DenseDComplexMatrix2D.this.elements[n2 + 1] = dArray[1];
                                }
                                n2 += DenseDComplexMatrix2D.this.columnStride;
                            }
                            n3 += DenseDComplexMatrix2D.this.rowStride;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            double[] dArray = new double[2];
            int n6 = n;
            for (int i = 0; i < this.rows; ++i) {
                int n7 = n6;
                for (int j = 0; j < this.columns; ++j) {
                    dArray[0] = this.elements[n7];
                    dArray[1] = this.elements[n7 + 1];
                    if (dComplexProcedure.apply(dArray)) {
                        dArray = dComplexDComplexFunction.apply(dArray);
                        this.elements[n7] = dArray[0];
                        this.elements[n7 + 1] = dArray[1];
                    }
                    n7 += this.columnStride;
                }
                n6 += this.rowStride;
            }
        }
        return this;
    }

    @Override
    public DComplexMatrix2D assign(final DComplexProcedure dComplexProcedure, final double[] dArray) {
        final int n = (int)this.index(0, 0);
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            Future[] futureArray = new Future[n2];
            int n3 = this.rows / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? this.rows : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n3 = n + n4 * DenseDComplexMatrix2D.this.rowStride;
                        double[] dArray2 = new double[2];
                        for (int i = n4; i < n5; ++i) {
                            int n2 = n3;
                            for (int j = 0; j < DenseDComplexMatrix2D.this.columns; ++j) {
                                dArray2[0] = DenseDComplexMatrix2D.this.elements[n2];
                                dArray2[1] = DenseDComplexMatrix2D.this.elements[n2 + 1];
                                if (dComplexProcedure.apply(dArray2)) {
                                    DenseDComplexMatrix2D.this.elements[n2] = dArray[0];
                                    DenseDComplexMatrix2D.this.elements[n2 + 1] = dArray[1];
                                }
                                n2 += DenseDComplexMatrix2D.this.columnStride;
                            }
                            n3 += DenseDComplexMatrix2D.this.rowStride;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            double[] dArray2 = new double[2];
            int n6 = n;
            for (int i = 0; i < this.rows; ++i) {
                int n7 = n6;
                for (int j = 0; j < this.columns; ++j) {
                    dArray2[0] = this.elements[n7];
                    dArray2[1] = this.elements[n7 + 1];
                    if (dComplexProcedure.apply(dArray2)) {
                        this.elements[n7] = dArray[0];
                        this.elements[n7 + 1] = dArray[1];
                    }
                    n7 += this.columnStride;
                }
                n6 += this.rowStride;
            }
        }
        return this;
    }

    @Override
    public DComplexMatrix2D assign(final DComplexRealFunction dComplexRealFunction) {
        final int n = (int)this.index(0, 0);
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            Future[] futureArray = new Future[n2];
            int n3 = this.rows / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? this.rows : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n6 = n + n4 * DenseDComplexMatrix2D.this.rowStride;
                        double[] dArray = new double[2];
                        if (dComplexRealFunction == DComplexFunctions.abs) {
                            for (int i = n4; i < n5; ++i) {
                                int n2 = n6;
                                for (int j = 0; j < DenseDComplexMatrix2D.this.columns; ++j) {
                                    double d;
                                    dArray[0] = DenseDComplexMatrix2D.this.elements[n2];
                                    dArray[1] = DenseDComplexMatrix2D.this.elements[n2 + 1];
                                    double d2 = Math.abs(dArray[0]);
                                    double d3 = Math.abs(dArray[1]);
                                    if (d2 == 0.0 && d3 == 0.0) {
                                        DenseDComplexMatrix2D.this.elements[n2] = 0.0;
                                    } else if (d2 >= d3) {
                                        d = dArray[1] / dArray[0];
                                        DenseDComplexMatrix2D.this.elements[n2] = d2 * Math.sqrt(1.0 + d * d);
                                    } else {
                                        d = dArray[0] / dArray[1];
                                        DenseDComplexMatrix2D.this.elements[n2] = d3 * Math.sqrt(1.0 + d * d);
                                    }
                                    DenseDComplexMatrix2D.this.elements[n2 + 1] = 0.0;
                                    n2 += DenseDComplexMatrix2D.this.columnStride;
                                }
                                n6 += DenseDComplexMatrix2D.this.rowStride;
                            }
                        } else {
                            for (int i = n4; i < n5; ++i) {
                                int n3 = n6;
                                for (int j = 0; j < DenseDComplexMatrix2D.this.columns; ++j) {
                                    dArray[0] = DenseDComplexMatrix2D.this.elements[n3];
                                    dArray[1] = DenseDComplexMatrix2D.this.elements[n3 + 1];
                                    dArray[0] = dComplexRealFunction.apply(dArray);
                                    DenseDComplexMatrix2D.this.elements[n3] = dArray[0];
                                    DenseDComplexMatrix2D.this.elements[n3 + 1] = 0.0;
                                    n3 += DenseDComplexMatrix2D.this.columnStride;
                                }
                                n6 += DenseDComplexMatrix2D.this.rowStride;
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n6 = n;
            double[] dArray = new double[2];
            if (dComplexRealFunction == DComplexFunctions.abs) {
                for (int i = 0; i < this.rows; ++i) {
                    int n7 = n6;
                    for (int j = 0; j < this.columns; ++j) {
                        double d;
                        dArray[0] = this.elements[n7];
                        dArray[1] = this.elements[n7 + 1];
                        double d2 = Math.abs(dArray[0]);
                        double d3 = Math.abs(dArray[1]);
                        if (d2 == 0.0 && d3 == 0.0) {
                            this.elements[n7] = 0.0;
                        } else if (d2 >= d3) {
                            d = dArray[1] / dArray[0];
                            this.elements[n7] = d2 * Math.sqrt(1.0 + d * d);
                        } else {
                            d = dArray[0] / dArray[1];
                            this.elements[n7] = d3 * Math.sqrt(1.0 + d * d);
                        }
                        this.elements[n7 + 1] = 0.0;
                        n7 += this.columnStride;
                    }
                    n6 += this.rowStride;
                }
            } else {
                for (int i = 0; i < this.rows; ++i) {
                    int n8 = n6;
                    for (int j = 0; j < this.columns; ++j) {
                        dArray[0] = this.elements[n8];
                        dArray[1] = this.elements[n8 + 1];
                        dArray[0] = dComplexRealFunction.apply(dArray);
                        this.elements[n8] = dArray[0];
                        this.elements[n8 + 1] = 0.0;
                        n8 += this.columnStride;
                    }
                    n6 += this.rowStride;
                }
            }
        }
        return this;
    }

    @Override
    public DComplexMatrix2D assign(DComplexMatrix2D dComplexMatrix2D) {
        Object object;
        if (!(dComplexMatrix2D instanceof DenseDComplexMatrix2D)) {
            super.assign(dComplexMatrix2D);
            return this;
        }
        DenseDComplexMatrix2D denseDComplexMatrix2D = (DenseDComplexMatrix2D)dComplexMatrix2D;
        if (denseDComplexMatrix2D == this) {
            return this;
        }
        this.checkShape(denseDComplexMatrix2D);
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (this.isNoView && denseDComplexMatrix2D.isNoView) {
            System.arraycopy(denseDComplexMatrix2D.elements, 0, this.elements, 0, this.elements.length);
            return this;
        }
        DenseDComplexMatrix2D denseDComplexMatrix2D2 = (DenseDComplexMatrix2D)dComplexMatrix2D;
        if (this.haveSharedCells(denseDComplexMatrix2D2)) {
            object = denseDComplexMatrix2D2.copy();
            if (!(object instanceof DenseDComplexMatrix2D)) {
                super.assign(denseDComplexMatrix2D2);
                return this;
            }
            denseDComplexMatrix2D2 = (DenseDComplexMatrix2D)object;
        }
        object = denseDComplexMatrix2D2.elements;
        if (this.elements == null || object == null) {
            throw new InternalError();
        }
        int n2 = denseDComplexMatrix2D2.columnStride;
        final int n3 = denseDComplexMatrix2D2.rowStride;
        final int n4 = (int)denseDComplexMatrix2D2.index(0, 0);
        final int n5 = (int)this.index(0, 0);
        if (n > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            Future[] futureArray = new Future[n];
            int n6 = this.rows / n;
            for (int i = 0; i < n; ++i) {
                final int n7 = i * n6;
                final int n8 = i == n - 1 ? this.rows : n7 + n6;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable((double[])object, n2){
                    final /* synthetic */ double[] val$elemsOther;
                    final /* synthetic */ int val$columnStrideOther;
                    {
                        this.val$elemsOther = dArray;
                        this.val$columnStrideOther = n6;
                    }

                    public void run() {
                        int n = n5 + n7 * DenseDComplexMatrix2D.this.rowStride;
                        int n2 = n4 + n7 * n3;
                        for (int i = n7; i < n8; ++i) {
                            int n32 = n;
                            int n42 = n2;
                            for (int j = 0; j < DenseDComplexMatrix2D.this.columns; ++j) {
                                DenseDComplexMatrix2D.this.elements[n32] = this.val$elemsOther[n42];
                                DenseDComplexMatrix2D.this.elements[n32 + 1] = this.val$elemsOther[n42 + 1];
                                n32 += DenseDComplexMatrix2D.this.columnStride;
                                n42 += this.val$columnStrideOther;
                            }
                            n += DenseDComplexMatrix2D.this.rowStride;
                            n2 += n3;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n9 = n5;
            int n10 = n4;
            for (int i = 0; i < this.rows; ++i) {
                int n11 = n9;
                int n12 = n10;
                for (int j = 0; j < this.columns; ++j) {
                    this.elements[n11] = (double)object[n12];
                    this.elements[n11 + 1] = (double)object[n12 + 1];
                    n11 += this.columnStride;
                    n12 += n2;
                }
                n9 += this.rowStride;
                n10 += n3;
            }
        }
        return this;
    }

    @Override
    public DComplexMatrix2D assign(DComplexMatrix2D dComplexMatrix2D, final DComplexDComplexDComplexFunction dComplexDComplexDComplexFunction) {
        if (!(dComplexMatrix2D instanceof DenseDComplexMatrix2D)) {
            super.assign(dComplexMatrix2D, dComplexDComplexDComplexFunction);
            return this;
        }
        this.checkShape(dComplexMatrix2D);
        final double[] dArray = ((DenseDComplexMatrix2D)dComplexMatrix2D).elements;
        if (this.elements == null || dArray == null) {
            throw new InternalError();
        }
        final int n = dComplexMatrix2D.columnStride();
        final int n2 = dComplexMatrix2D.rowStride();
        final int n3 = (int)dComplexMatrix2D.index(0, 0);
        final int n4 = (int)this.index(0, 0);
        int n5 = ConcurrencyUtils.getNumberOfThreads();
        if (n5 > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            Future[] futureArray = new Future[n5];
            int n6 = this.rows / n5;
            for (int i = 0; i < n5; ++i) {
                final int n7 = i * n6;
                final int n8 = i == n5 - 1 ? this.rows : n7 + n6;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n11 = n4 + n7 * DenseDComplexMatrix2D.this.rowStride;
                        int n22 = n3 + n7 * n2;
                        double[] dArray3 = new double[2];
                        double[] dArray2 = new double[2];
                        if (dComplexDComplexDComplexFunction == DComplexFunctions.mult) {
                            for (int i = n7; i < n8; ++i) {
                                int n32 = n11;
                                int n42 = n22;
                                for (int j = 0; j < DenseDComplexMatrix2D.this.columns; ++j) {
                                    dArray3[0] = DenseDComplexMatrix2D.this.elements[n32];
                                    dArray3[1] = DenseDComplexMatrix2D.this.elements[n32 + 1];
                                    dArray2[0] = dArray[n42];
                                    dArray2[1] = dArray[n42 + 1];
                                    DenseDComplexMatrix2D.this.elements[n32] = dArray3[0] * dArray2[0] - dArray3[1] * dArray2[1];
                                    DenseDComplexMatrix2D.this.elements[n32 + 1] = dArray3[1] * dArray2[0] + dArray3[0] * dArray2[1];
                                    n32 += DenseDComplexMatrix2D.this.columnStride;
                                    n42 += n;
                                }
                                n11 += DenseDComplexMatrix2D.this.rowStride;
                                n22 += n2;
                            }
                        } else if (dComplexDComplexDComplexFunction == DComplexFunctions.multConjFirst) {
                            for (int i = n7; i < n8; ++i) {
                                int n5 = n11;
                                int n6 = n22;
                                for (int j = 0; j < DenseDComplexMatrix2D.this.columns; ++j) {
                                    dArray3[0] = DenseDComplexMatrix2D.this.elements[n5];
                                    dArray3[1] = DenseDComplexMatrix2D.this.elements[n5 + 1];
                                    dArray2[0] = dArray[n6];
                                    dArray2[1] = dArray[n6 + 1];
                                    DenseDComplexMatrix2D.this.elements[n5] = dArray3[0] * dArray2[0] + dArray3[1] * dArray2[1];
                                    DenseDComplexMatrix2D.this.elements[n5 + 1] = -dArray3[1] * dArray2[0] + dArray3[0] * dArray2[1];
                                    n5 += DenseDComplexMatrix2D.this.columnStride;
                                    n6 += n;
                                }
                                n11 += DenseDComplexMatrix2D.this.rowStride;
                                n22 += n2;
                            }
                        } else if (dComplexDComplexDComplexFunction == DComplexFunctions.multConjSecond) {
                            for (int i = n7; i < n8; ++i) {
                                int n72 = n11;
                                int n82 = n22;
                                for (int j = 0; j < DenseDComplexMatrix2D.this.columns; ++j) {
                                    dArray3[0] = DenseDComplexMatrix2D.this.elements[n72];
                                    dArray3[1] = DenseDComplexMatrix2D.this.elements[n72 + 1];
                                    dArray2[0] = dArray[n82];
                                    dArray2[1] = dArray[n82 + 1];
                                    DenseDComplexMatrix2D.this.elements[n72] = dArray3[0] * dArray2[0] + dArray3[1] * dArray2[1];
                                    DenseDComplexMatrix2D.this.elements[n72 + 1] = dArray3[1] * dArray2[0] - dArray3[0] * dArray2[1];
                                    n72 += DenseDComplexMatrix2D.this.columnStride;
                                    n82 += n;
                                }
                                n11 += DenseDComplexMatrix2D.this.rowStride;
                                n22 += n2;
                            }
                        } else {
                            for (int i = n7; i < n8; ++i) {
                                int n9 = n11;
                                int n10 = n22;
                                for (int j = 0; j < DenseDComplexMatrix2D.this.columns; ++j) {
                                    dArray3[0] = DenseDComplexMatrix2D.this.elements[n9];
                                    dArray3[1] = DenseDComplexMatrix2D.this.elements[n9 + 1];
                                    dArray2[0] = dArray[n10];
                                    dArray2[1] = dArray[n10 + 1];
                                    dArray3 = dComplexDComplexDComplexFunction.apply(dArray3, dArray2);
                                    DenseDComplexMatrix2D.this.elements[n9] = dArray3[0];
                                    DenseDComplexMatrix2D.this.elements[n9 + 1] = dArray3[1];
                                    n9 += DenseDComplexMatrix2D.this.columnStride;
                                    n10 += n;
                                }
                                n11 += DenseDComplexMatrix2D.this.rowStride;
                                n22 += n2;
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            double[] dArray2 = new double[2];
            double[] dArray3 = new double[2];
            int n9 = n4;
            int n10 = n3;
            if (dComplexDComplexDComplexFunction == DComplexFunctions.mult) {
                for (int i = 0; i < this.rows; ++i) {
                    int n11 = n9;
                    int n12 = n10;
                    for (int j = 0; j < this.columns; ++j) {
                        dArray2[0] = this.elements[n11];
                        dArray2[1] = this.elements[n11 + 1];
                        dArray3[0] = dArray[n12];
                        dArray3[1] = dArray[n12 + 1];
                        this.elements[n11] = dArray2[0] * dArray3[0] - dArray2[1] * dArray3[1];
                        this.elements[n11 + 1] = dArray2[1] * dArray3[0] + dArray2[0] * dArray3[1];
                        n11 += this.columnStride;
                        n12 += n;
                    }
                    n9 += this.rowStride;
                    n10 += n2;
                }
            } else if (dComplexDComplexDComplexFunction == DComplexFunctions.multConjFirst) {
                for (int i = 0; i < this.rows; ++i) {
                    int n13 = n9;
                    int n14 = n10;
                    for (int j = 0; j < this.columns; ++j) {
                        dArray2[0] = this.elements[n13];
                        dArray2[1] = this.elements[n13 + 1];
                        dArray3[0] = dArray[n14];
                        dArray3[1] = dArray[n14 + 1];
                        this.elements[n13] = dArray2[0] * dArray3[0] + dArray2[1] * dArray3[1];
                        this.elements[n13 + 1] = -dArray2[1] * dArray3[0] + dArray2[0] * dArray3[1];
                        n13 += this.columnStride;
                        n14 += n;
                    }
                    n9 += this.rowStride;
                    n10 += n2;
                }
            } else if (dComplexDComplexDComplexFunction == DComplexFunctions.multConjSecond) {
                for (int i = 0; i < this.rows; ++i) {
                    int n15 = n9;
                    int n16 = n10;
                    for (int j = 0; j < this.columns; ++j) {
                        dArray2[0] = this.elements[n15];
                        dArray2[1] = this.elements[n15 + 1];
                        dArray3[0] = dArray[n16];
                        dArray3[1] = dArray[n16 + 1];
                        this.elements[n15] = dArray2[0] * dArray3[0] + dArray2[1] * dArray3[1];
                        this.elements[n15 + 1] = dArray2[1] * dArray3[0] - dArray2[0] * dArray3[1];
                        n15 += this.columnStride;
                        n16 += n;
                    }
                    n9 += this.rowStride;
                    n10 += n2;
                }
            } else {
                for (int i = 0; i < this.rows; ++i) {
                    int n17 = n9;
                    int n18 = n10;
                    for (int j = 0; j < this.columns; ++j) {
                        dArray2[0] = this.elements[n17];
                        dArray2[1] = this.elements[n17 + 1];
                        dArray3[0] = dArray[n18];
                        dArray3[1] = dArray[n18 + 1];
                        dArray2 = dComplexDComplexDComplexFunction.apply(dArray2, dArray3);
                        this.elements[n17] = dArray2[0];
                        this.elements[n17 + 1] = dArray2[1];
                        n17 += this.columnStride;
                        n18 += n;
                    }
                    n9 += this.rowStride;
                    n10 += n2;
                }
            }
        }
        return this;
    }

    @Override
    public DComplexMatrix2D assign(final double d, final double d2) {
        final int n = (int)this.index(0, 0);
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            Future[] futureArray = new Future[n2];
            int n3 = this.rows / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? this.rows : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n3 = n + n4 * DenseDComplexMatrix2D.this.rowStride;
                        for (int i = n4; i < n5; ++i) {
                            int n2 = n3;
                            for (int j = 0; j < DenseDComplexMatrix2D.this.columns; ++j) {
                                DenseDComplexMatrix2D.this.elements[n2] = d;
                                DenseDComplexMatrix2D.this.elements[n2 + 1] = d2;
                                n2 += DenseDComplexMatrix2D.this.columnStride;
                            }
                            n3 += DenseDComplexMatrix2D.this.rowStride;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n6 = n;
            for (int i = 0; i < this.rows; ++i) {
                int n7 = n6;
                for (int j = 0; j < this.columns; ++j) {
                    this.elements[n7] = d;
                    this.elements[n7 + 1] = d2;
                    n7 += this.columnStride;
                }
                n6 += this.rowStride;
            }
        }
        return this;
    }

    @Override
    public DComplexMatrix2D assign(final double[] dArray) {
        if (dArray.length != this.rows * 2 * this.columns) {
            throw new IllegalArgumentException("Must have same length: length=" + dArray.length + "rows()*2*columns()=" + this.rows() * 2 * this.columns());
        }
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (this.isNoView) {
            System.arraycopy(dArray, 0, this.elements, 0, dArray.length);
        } else {
            final int n2 = (int)this.index(0, 0);
            if (n > 1 && this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_2D()) {
                Future[] futureArray = new Future[n];
                int n3 = this.rows / n;
                for (int i = 0; i < n; ++i) {
                    final int n4 = i * n3;
                    final int n5 = i * n3 * 2 * this.columns;
                    final int n6 = i == n - 1 ? this.rows : n4 + n3;
                    futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                        public void run() {
                            int n = n5;
                            int n22 = n2 + n4 * DenseDComplexMatrix2D.this.rowStride;
                            for (int i = n4; i < n6; ++i) {
                                int n3 = n22;
                                for (int j = 0; j < DenseDComplexMatrix2D.this.columns; ++j) {
                                    DenseDComplexMatrix2D.this.elements[n3] = dArray[n++];
                                    DenseDComplexMatrix2D.this.elements[n3 + 1] = dArray[n++];
                                    n3 += DenseDComplexMatrix2D.this.columnStride;
                                }
                                n22 += DenseDComplexMatrix2D.this.rowStride;
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futureArray);
            } else {
                int n7 = 0;
                int n8 = n2;
                for (int i = 0; i < this.rows; ++i) {
                    int n9 = n8;
                    for (int j = 0; j < this.columns; ++j) {
                        this.elements[n9] = dArray[n7++];
                        this.elements[n9 + 1] = dArray[n7++];
                        n9 += this.columnStride;
                    }
                    n8 += this.rowStride;
                }
            }
        }
        return this;
    }

    @Override
    public DComplexMatrix2D assign(final double[][] dArray) {
        if (dArray.length != this.rows) {
            throw new IllegalArgumentException("Must have same number of rows: rows=" + dArray.length + "rows()=" + this.rows());
        }
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (this.isNoView) {
            if (n > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_2D()) {
                Future[] futureArray = new Future[n];
                int n2 = this.rows / n;
                for (int i = 0; i < n; ++i) {
                    final int n3 = i * n2;
                    final int n4 = i == n - 1 ? this.rows : n3 + n2;
                    futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                        public void run() {
                            int n = 2 * DenseDComplexMatrix2D.this.columns;
                            int n2 = n3 * DenseDComplexMatrix2D.this.rowStride;
                            for (int i = n3; i < n4; ++i) {
                                double[] dArray2 = dArray[i];
                                if (dArray2.length != n) {
                                    throw new IllegalArgumentException("Must have same number of columns in every row: columns=" + dArray2.length + "2*columns()=" + n);
                                }
                                System.arraycopy(dArray2, 0, DenseDComplexMatrix2D.this.elements, n2, n);
                                n2 += n;
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futureArray);
            } else {
                int n5 = 2 * this.columns;
                int n6 = 0;
                for (int i = 0; i < this.rows; ++i) {
                    double[] dArray2 = dArray[i];
                    if (dArray2.length != n5) {
                        throw new IllegalArgumentException("Must have same number of columns in every row: columns=" + dArray2.length + "2*columns()=" + n5);
                    }
                    System.arraycopy(dArray2, 0, this.elements, n6, n5);
                    n6 += n5;
                }
            }
        } else {
            final int n7 = (int)this.index(0, 0);
            if (n > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_2D()) {
                Future[] futureArray = new Future[n];
                int n8 = this.rows / n;
                for (int i = 0; i < n; ++i) {
                    final int n9 = i * n8;
                    final int n10 = i == n - 1 ? this.rows : n9 + n8;
                    futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                        public void run() {
                            int n = n7 + n9 * DenseDComplexMatrix2D.this.rowStride;
                            for (int i = n9; i < n10; ++i) {
                                double[] dArray2 = dArray[i];
                                if (dArray2.length != 2 * DenseDComplexMatrix2D.this.columns) {
                                    throw new IllegalArgumentException("Must have same number of columns in every row: columns=" + dArray2.length + "2*columns()=" + 2 * DenseDComplexMatrix2D.this.columns());
                                }
                                int n2 = n;
                                for (int j = 0; j < DenseDComplexMatrix2D.this.columns; ++j) {
                                    DenseDComplexMatrix2D.this.elements[n2] = dArray2[2 * j];
                                    DenseDComplexMatrix2D.this.elements[n2 + 1] = dArray2[2 * j + 1];
                                    n2 += DenseDComplexMatrix2D.this.columnStride;
                                }
                                n += DenseDComplexMatrix2D.this.rowStride;
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futureArray);
            } else {
                int n11 = n7;
                for (int i = 0; i < this.rows; ++i) {
                    double[] dArray3 = dArray[i];
                    if (dArray3.length != 2 * this.columns) {
                        throw new IllegalArgumentException("Must have same number of columns in every row: columns=" + dArray3.length + "2*columns()=" + 2 * this.columns());
                    }
                    int n12 = n11;
                    for (int j = 0; j < this.columns; ++j) {
                        this.elements[n12] = dArray3[2 * j];
                        this.elements[n12 + 1] = dArray3[2 * j + 1];
                        n12 += this.columnStride;
                    }
                    n11 += this.rowStride;
                }
            }
        }
        return this;
    }

    @Override
    public DComplexMatrix2D assign(final float[] fArray) {
        if (fArray.length != this.rows * 2 * this.columns) {
            throw new IllegalArgumentException("Must have same length: length=" + fArray.length + "rows()*2*columns()=" + this.rows() * 2 * this.columns());
        }
        final int n = (int)this.index(0, 0);
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            Future[] futureArray = new Future[n2];
            int n3 = this.rows / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i * n3 * 2 * this.columns;
                final int n6 = i == n2 - 1 ? this.rows : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n7 = n5;
                        int n2 = n + n4 * DenseDComplexMatrix2D.this.rowStride;
                        for (int i = n4; i < n6; ++i) {
                            int n3 = n2;
                            for (int j = 0; j < DenseDComplexMatrix2D.this.columns; ++j) {
                                DenseDComplexMatrix2D.this.elements[n3] = fArray[n7];
                                DenseDComplexMatrix2D.this.elements[n3 + 1] = fArray[n7 + 1];
                                n3 += DenseDComplexMatrix2D.this.columnStride;
                                n7 += 2;
                            }
                            n2 += DenseDComplexMatrix2D.this.rowStride;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n7 = n;
            int n8 = 0;
            for (int i = 0; i < this.rows; ++i) {
                int n9 = n7;
                for (int j = 0; j < this.columns; ++j) {
                    this.elements[n9] = fArray[n8];
                    this.elements[n9 + 1] = fArray[n8 + 1];
                    n9 += this.columnStride;
                    n8 += 2;
                }
                n7 += this.rowStride;
            }
        }
        return this;
    }

    @Override
    public DComplexMatrix2D assignImaginary(DoubleMatrix2D doubleMatrix2D) {
        this.checkShape(doubleMatrix2D);
        final int n = doubleMatrix2D.columnStride();
        final int n2 = doubleMatrix2D.rowStride();
        final int n3 = (int)doubleMatrix2D.index(0, 0);
        final int n4 = (int)this.index(0, 0);
        final double[] dArray = ((DenseDoubleMatrix2D)doubleMatrix2D).elements();
        int n5 = ConcurrencyUtils.getNumberOfThreads();
        if (n5 > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            Future[] futureArray = new Future[n5];
            int n6 = this.rows / n5;
            for (int i = 0; i < n5; ++i) {
                final int n7 = i * n6;
                final int n8 = i == n5 - 1 ? this.rows : n7 + n6;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n5 = n4 + n7 * DenseDComplexMatrix2D.this.rowStride;
                        int n22 = n3 + n7 * n2;
                        for (int i = n7; i < n8; ++i) {
                            int n32 = n5;
                            int n42 = n22;
                            for (int j = 0; j < DenseDComplexMatrix2D.this.columns; ++j) {
                                DenseDComplexMatrix2D.this.elements[n32 + 1] = dArray[n42];
                                n32 += DenseDComplexMatrix2D.this.columnStride;
                                n42 += n;
                            }
                            n5 += DenseDComplexMatrix2D.this.rowStride;
                            n22 += n2;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n9 = n4;
            int n10 = n3;
            for (int i = 0; i < this.rows; ++i) {
                int n11 = n9;
                int n12 = n10;
                for (int j = 0; j < this.columns; ++j) {
                    this.elements[n11 + 1] = dArray[n12];
                    n11 += this.columnStride;
                    n12 += n;
                }
                n9 += this.rowStride;
                n10 += n2;
            }
        }
        return this;
    }

    @Override
    public DComplexMatrix2D assignReal(DoubleMatrix2D doubleMatrix2D) {
        this.checkShape(doubleMatrix2D);
        final int n = doubleMatrix2D.columnStride();
        final int n2 = doubleMatrix2D.rowStride();
        final int n3 = (int)doubleMatrix2D.index(0, 0);
        final int n4 = (int)this.index(0, 0);
        final double[] dArray = ((DenseDoubleMatrix2D)doubleMatrix2D).elements();
        int n5 = ConcurrencyUtils.getNumberOfThreads();
        if (n5 > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            Future[] futureArray = new Future[n5];
            int n6 = this.rows / n5;
            for (int i = 0; i < n5; ++i) {
                final int n7 = i * n6;
                final int n8 = i == n5 - 1 ? this.rows : n7 + n6;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n5 = n4 + n7 * DenseDComplexMatrix2D.this.rowStride;
                        int n22 = n3 + n7 * n2;
                        for (int i = n7; i < n8; ++i) {
                            int n32 = n5;
                            int n42 = n22;
                            for (int j = 0; j < DenseDComplexMatrix2D.this.columns; ++j) {
                                DenseDComplexMatrix2D.this.elements[n32] = dArray[n42];
                                n32 += DenseDComplexMatrix2D.this.columnStride;
                                n42 += n;
                            }
                            n5 += DenseDComplexMatrix2D.this.rowStride;
                            n22 += n2;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n9 = n4;
            int n10 = n3;
            for (int i = 0; i < this.rows; ++i) {
                int n11 = n9;
                int n12 = n10;
                for (int j = 0; j < this.columns; ++j) {
                    this.elements[n11] = dArray[n12];
                    n11 += this.columnStride;
                    n12 += n;
                }
                n9 += this.rowStride;
                n10 += n2;
            }
        }
        return this;
    }

    @Override
    public int cardinality() {
        int n = 0;
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        final int n3 = (int)this.index(0, 0);
        if (n2 > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            int n4;
            Future[] futureArray = new Future[n2];
            Integer[] integerArray = new Integer[n2];
            int n5 = this.rows / n2;
            for (n4 = 0; n4 < n2; ++n4) {
                final int n6 = n4 * n5;
                final int n7 = n4 == n2 - 1 ? this.rows : n6 + n5;
                futureArray[n4] = ConcurrencyUtils.submit(new Callable<Integer>(){

                    @Override
                    public Integer call() throws Exception {
                        int n = 0;
                        int n2 = n3 + n6 * DenseDComplexMatrix2D.this.rowStride;
                        for (int i = n6; i < n7; ++i) {
                            int n32 = n2;
                            for (int j = 0; j < DenseDComplexMatrix2D.this.columns; ++j) {
                                if (DenseDComplexMatrix2D.this.elements[n32] != 0.0 || DenseDComplexMatrix2D.this.elements[n32 + 1] != 0.0) {
                                    ++n;
                                }
                                n32 += DenseDComplexMatrix2D.this.columnStride;
                            }
                            n2 += DenseDComplexMatrix2D.this.rowStride;
                        }
                        return n;
                    }
                });
            }
            try {
                for (n4 = 0; n4 < n2; ++n4) {
                    integerArray[n4] = (Integer)futureArray[n4].get();
                }
                n = integerArray[0];
                for (n4 = 1; n4 < n2; ++n4) {
                    n += integerArray[n4].intValue();
                }
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        } else {
            int n8 = n3;
            for (int i = 0; i < this.rows; ++i) {
                int n9 = n8;
                for (int j = 0; j < this.columns; ++j) {
                    if (this.elements[n9] != 0.0 || this.elements[n9 + 1] != 0.0) {
                        ++n;
                    }
                    n9 += this.columnStride;
                }
                n8 += this.rowStride;
            }
        }
        return n;
    }

    public void fft2() {
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        if (this.fft2 == null) {
            this.fft2 = new DoubleFFT_2D(this.rows, this.columns);
        }
        if (this.isNoView) {
            this.fft2.complexForward(this.elements);
        } else {
            DComplexMatrix2D dComplexMatrix2D = this.copy();
            this.fft2.complexForward((double[])dComplexMatrix2D.elements());
            this.assign((double[])dComplexMatrix2D.elements());
        }
        ConcurrencyUtils.setNumberOfThreads(n);
    }

    public void fftColumns() {
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        for (int i = 0; i < this.columns; ++i) {
            ((DenseDComplexMatrix1D)this.viewColumn(i)).fft();
        }
        ConcurrencyUtils.setNumberOfThreads(n);
    }

    public void fftRows() {
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        for (int i = 0; i < this.rows; ++i) {
            ((DenseDComplexMatrix1D)this.viewRow(i)).fft();
        }
        ConcurrencyUtils.setNumberOfThreads(n);
    }

    @Override
    public DComplexMatrix2D forEachNonZero(final IntIntDComplexFunction intIntDComplexFunction) {
        final int n = (int)this.index(0, 0);
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            Future[] futureArray = new Future[n2];
            int n3 = this.rows / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? this.rows : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n3 = n + n4 * DenseDComplexMatrix2D.this.rowStride;
                        double[] dArray = new double[2];
                        for (int i = n4; i < n5; ++i) {
                            int n2 = n3;
                            for (int j = 0; j < DenseDComplexMatrix2D.this.columns; ++j) {
                                dArray[0] = DenseDComplexMatrix2D.this.elements[n2];
                                dArray[1] = DenseDComplexMatrix2D.this.elements[n2 + 1];
                                if (dArray[0] != 0.0 || dArray[1] != 0.0) {
                                    double[] dArray2 = intIntDComplexFunction.apply(i, j, dArray);
                                    DenseDComplexMatrix2D.this.elements[n2] = dArray2[0];
                                    DenseDComplexMatrix2D.this.elements[n2 + 1] = dArray2[1];
                                }
                                n2 += DenseDComplexMatrix2D.this.columnStride;
                            }
                            n3 += DenseDComplexMatrix2D.this.rowStride;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n6 = n;
            double[] dArray = new double[2];
            for (int i = 0; i < this.rows; ++i) {
                int n7 = n6;
                for (int j = 0; j < this.columns; ++j) {
                    dArray[0] = this.elements[n7];
                    dArray[1] = this.elements[n7 + 1];
                    if (dArray[0] != 0.0 || dArray[1] != 0.0) {
                        double[] dArray2 = intIntDComplexFunction.apply(i, j, dArray);
                        this.elements[n7] = dArray2[0];
                        this.elements[n7 + 1] = dArray2[1];
                    }
                    n7 += this.columnStride;
                }
                n6 += this.rowStride;
            }
        }
        return this;
    }

    @Override
    public DComplexMatrix2D getConjugateTranspose() {
        DComplexMatrix2D dComplexMatrix2D = this.viewDice().copy();
        final double[] dArray = ((DenseDComplexMatrix2D)dComplexMatrix2D).elements;
        final int n = (int)dComplexMatrix2D.index(0, 0);
        final int n2 = dComplexMatrix2D.columnStride();
        final int n3 = dComplexMatrix2D.rowStride();
        int n4 = ConcurrencyUtils.getNumberOfThreads();
        final int n5 = dComplexMatrix2D.columns();
        int n6 = dComplexMatrix2D.rows();
        if (n4 > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            Future[] futureArray = new Future[n4];
            int n7 = n6 / n4;
            for (int i = 0; i < n4; ++i) {
                final int n8 = i * n7;
                final int n9 = i == n4 - 1 ? n6 : n8 + n7;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n4 = n + n8 * n3;
                        for (int i = n8; i < n9; ++i) {
                            for (int j = 0; j < n5; ++j) {
                                dArray[n4 + 1] = -dArray[n4 + 1];
                                n4 += n2;
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n10 = n;
            for (int i = 0; i < n6; ++i) {
                for (int j = 0; j < n5; ++j) {
                    dArray[n10 + 1] = -dArray[n10 + 1];
                    n10 += n2;
                }
            }
        }
        return dComplexMatrix2D;
    }

    public double[] elements() {
        return this.elements;
    }

    @Override
    public DoubleMatrix2D getImaginaryPart() {
        DenseDoubleMatrix2D denseDoubleMatrix2D = new DenseDoubleMatrix2D(this.rows, this.columns);
        final double[] dArray = denseDoubleMatrix2D.elements();
        final int n = denseDoubleMatrix2D.columnStride();
        final int n2 = denseDoubleMatrix2D.rowStride();
        final int n3 = (int)denseDoubleMatrix2D.index(0, 0);
        final int n4 = (int)this.index(0, 0);
        int n5 = ConcurrencyUtils.getNumberOfThreads();
        if (n5 > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            Future[] futureArray = new Future[n5];
            int n6 = this.rows / n5;
            for (int i = 0; i < n5; ++i) {
                final int n7 = i * n6;
                final int n8 = i == n5 - 1 ? this.rows : n7 + n6;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n5 = n4 + n7 * DenseDComplexMatrix2D.this.rowStride;
                        int n22 = n3 + n7 * n2;
                        for (int i = n7; i < n8; ++i) {
                            int n32 = n5;
                            int n42 = n22;
                            for (int j = 0; j < DenseDComplexMatrix2D.this.columns; ++j) {
                                dArray[n42] = DenseDComplexMatrix2D.this.elements[n32 + 1];
                                n32 += DenseDComplexMatrix2D.this.columnStride;
                                n42 += n;
                            }
                            n5 += DenseDComplexMatrix2D.this.rowStride;
                            n22 += n2;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n9 = n4;
            int n10 = n3;
            for (int i = 0; i < this.rows; ++i) {
                int n11 = n9;
                int n12 = n10;
                for (int j = 0; j < this.columns; ++j) {
                    dArray[n12] = this.elements[n11 + 1];
                    n11 += this.columnStride;
                    n12 += n;
                }
                n9 += this.rowStride;
                n10 += n2;
            }
        }
        return denseDoubleMatrix2D;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getNonZeros(IntArrayList intArrayList, IntArrayList intArrayList2, ArrayList<double[]> arrayList) {
        intArrayList.clear();
        intArrayList2.clear();
        arrayList.clear();
        int n = (int)this.index(0, 0);
        for (int i = 0; i < this.rows; ++i) {
            int n2 = n;
            for (int j = 0; j < this.columns; ++j) {
                double[] dArray = new double[]{this.elements[n2], this.elements[n2 + 1]};
                if (dArray[0] != 0.0 || dArray[1] != 0.0) {
                    IntArrayList intArrayList3 = intArrayList;
                    synchronized (intArrayList3) {
                        intArrayList.add(i);
                        intArrayList2.add(j);
                        arrayList.add(dArray);
                    }
                }
                n2 += this.columnStride;
            }
            n += this.rowStride;
        }
    }

    @Override
    public double[] getQuick(int n, int n2) {
        int n3 = this.rowZero + n * this.rowStride + this.columnZero + n2 * this.columnStride;
        return new double[]{this.elements[n3], this.elements[n3 + 1]};
    }

    @Override
    public DoubleMatrix2D getRealPart() {
        DenseDoubleMatrix2D denseDoubleMatrix2D = new DenseDoubleMatrix2D(this.rows, this.columns);
        final double[] dArray = denseDoubleMatrix2D.elements();
        final int n = denseDoubleMatrix2D.columnStride();
        final int n2 = denseDoubleMatrix2D.rowStride();
        final int n3 = (int)denseDoubleMatrix2D.index(0, 0);
        final int n4 = (int)this.index(0, 0);
        int n5 = ConcurrencyUtils.getNumberOfThreads();
        if (n5 > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            Future[] futureArray = new Future[n5];
            int n6 = this.rows / n5;
            for (int i = 0; i < n5; ++i) {
                final int n7 = i * n6;
                final int n8 = i == n5 - 1 ? this.rows : n7 + n6;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n5 = n4 + n7 * DenseDComplexMatrix2D.this.rowStride;
                        int n22 = n3 + n7 * n2;
                        for (int i = n7; i < n8; ++i) {
                            int n32 = n5;
                            int n42 = n22;
                            for (int j = 0; j < DenseDComplexMatrix2D.this.columns; ++j) {
                                dArray[n42] = DenseDComplexMatrix2D.this.elements[n32];
                                n32 += DenseDComplexMatrix2D.this.columnStride;
                                n42 += n;
                            }
                            n5 += DenseDComplexMatrix2D.this.rowStride;
                            n22 += n2;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n9 = n4;
            int n10 = n3;
            for (int i = 0; i < this.rows; ++i) {
                int n11 = n9;
                int n12 = n10;
                for (int j = 0; j < this.columns; ++j) {
                    dArray[n12] = this.elements[n11];
                    n11 += this.columnStride;
                    n12 += n;
                }
                n9 += this.rowStride;
                n10 += n2;
            }
        }
        return denseDoubleMatrix2D;
    }

    public void ifft2(boolean bl) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        if (this.fft2 == null) {
            this.fft2 = new DoubleFFT_2D(this.rows, this.columns);
        }
        if (this.isNoView) {
            this.fft2.complexInverse(this.elements, bl);
        } else {
            DComplexMatrix2D dComplexMatrix2D = this.copy();
            this.fft2.complexInverse((double[])dComplexMatrix2D.elements(), bl);
            this.assign((double[])dComplexMatrix2D.elements());
        }
        ConcurrencyUtils.setNumberOfThreads(n);
    }

    public void ifftColumns(boolean bl) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        for (int i = 0; i < this.columns; ++i) {
            ((DenseDComplexMatrix1D)this.viewColumn(i)).ifft(bl);
        }
        ConcurrencyUtils.setNumberOfThreads(n);
    }

    public void ifftRows(boolean bl) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        for (int i = 0; i < this.rows; ++i) {
            ((DenseDComplexMatrix1D)this.viewRow(i)).ifft(bl);
        }
        ConcurrencyUtils.setNumberOfThreads(n);
    }

    @Override
    public DComplexMatrix2D like(int n, int n2) {
        return new DenseDComplexMatrix2D(n, n2);
    }

    @Override
    public DComplexMatrix1D like1D(int n) {
        return new DenseDComplexMatrix1D(n);
    }

    @Override
    public void setQuick(int n, int n2, double d, double d2) {
        int n3 = this.rowZero + n * this.rowStride + this.columnZero + n2 * this.columnStride;
        this.elements[n3] = d;
        this.elements[n3 + 1] = d2;
    }

    @Override
    public void setQuick(int n, int n2, double[] dArray) {
        int n3 = this.rowZero + n * this.rowStride + this.columnZero + n2 * this.columnStride;
        this.elements[n3] = dArray[0];
        this.elements[n3 + 1] = dArray[1];
    }

    @Override
    public double[][] toArray() {
        final double[][] dArray = new double[this.rows][2 * this.columns];
        int n = ConcurrencyUtils.getNumberOfThreads();
        final int n2 = (int)this.index(0, 0);
        if (n > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            Future[] futureArray = new Future[n];
            int n3 = this.rows / n;
            for (int i = 0; i < n; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n - 1 ? this.rows : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n = n2 + n4 * DenseDComplexMatrix2D.this.rowStride;
                        for (int i = n4; i < n5; ++i) {
                            int n22 = n;
                            for (int j = 0; j < DenseDComplexMatrix2D.this.columns; ++j) {
                                dArray[i][2 * j] = DenseDComplexMatrix2D.this.elements[n22];
                                dArray[i][2 * j + 1] = DenseDComplexMatrix2D.this.elements[n22 + 1];
                                n22 += DenseDComplexMatrix2D.this.columnStride;
                            }
                            n += DenseDComplexMatrix2D.this.rowStride;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n6 = n2;
            for (int i = 0; i < this.rows; ++i) {
                int n7 = n6;
                for (int j = 0; j < this.columns; ++j) {
                    dArray[i][2 * j] = this.elements[n7];
                    dArray[i][2 * j + 1] = this.elements[n7 + 1];
                    n7 += this.columnStride;
                }
                n6 += this.rowStride;
            }
        }
        return dArray;
    }

    @Override
    public DComplexMatrix1D vectorize() {
        DenseDComplexMatrix1D denseDComplexMatrix1D = new DenseDComplexMatrix1D(this.size());
        final int n = (int)this.index(0, 0);
        final int n2 = (int)((AbstractMatrix1D)denseDComplexMatrix1D).index(0);
        final int n3 = denseDComplexMatrix1D.stride();
        final double[] dArray = (double[])((DComplexMatrix1D)denseDComplexMatrix1D).elements();
        int n4 = ConcurrencyUtils.getNumberOfThreads();
        if (n4 > 1 && this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            Future[] futureArray = new Future[n4];
            int n5 = this.columns / n4;
            for (int i = 0; i < n4; ++i) {
                final int n6 = i * n5;
                final int n7 = i * n5 * this.rows;
                final int n8 = i == n4 - 1 ? this.columns : n6 + n5;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n4 = 0;
                        int n22 = n2 + n7 * n3;
                        for (int i = n6; i < n8; ++i) {
                            n4 = n + i * DenseDComplexMatrix2D.this.columnStride;
                            for (int j = 0; j < DenseDComplexMatrix2D.this.rows; ++j) {
                                dArray[n22] = DenseDComplexMatrix2D.this.elements[n4];
                                dArray[n22 + 1] = DenseDComplexMatrix2D.this.elements[n4 + 1];
                                n4 += DenseDComplexMatrix2D.this.rowStride;
                                n22 += n3;
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n9 = 0;
            int n10 = n2;
            for (int i = 0; i < this.columns; ++i) {
                n9 = n + i * this.columnStride;
                for (int j = 0; j < this.rows; ++j) {
                    dArray[n10] = this.elements[n9];
                    dArray[n10 + 1] = this.elements[n9 + 1];
                    n9 += this.rowStride;
                    n10 += n3;
                }
            }
        }
        return denseDComplexMatrix1D;
    }

    @Override
    public DComplexMatrix1D zMult(DComplexMatrix1D dComplexMatrix1D, DComplexMatrix1D dComplexMatrix1D2, final double[] dArray, final double[] dArray2, boolean bl) {
        if (bl) {
            return this.getConjugateTranspose().zMult(dComplexMatrix1D, dComplexMatrix1D2, dArray, dArray2, false);
        }
        DComplexMatrix1D dComplexMatrix1D3 = dComplexMatrix1D2 == null ? new DenseDComplexMatrix1D(this.rows) : dComplexMatrix1D2;
        if (this.columns != dComplexMatrix1D.size() || this.rows > dComplexMatrix1D3.size()) {
            throw new IllegalArgumentException("Incompatible args: " + this.toStringShort() + ", " + dComplexMatrix1D.toStringShort() + ", " + dComplexMatrix1D3.toStringShort());
        }
        final double[] dArray3 = (double[])dComplexMatrix1D.elements();
        final double[] dArray4 = (double[])dComplexMatrix1D3.elements();
        if (this.elements == null || dArray3 == null || dArray4 == null) {
            throw new InternalError();
        }
        final int n = dComplexMatrix1D.stride();
        final int n2 = dComplexMatrix1D3.stride();
        final int n3 = (int)this.index(0, 0);
        final int n4 = (int)dComplexMatrix1D.index(0);
        final int n5 = (int)dComplexMatrix1D3.index(0);
        int n6 = ConcurrencyUtils.getNumberOfThreads();
        if (n6 > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            Future[] futureArray = new Future[n6];
            int n7 = this.rows / n6;
            for (int i = 0; i < n6; ++i) {
                final int n8 = i * n7;
                final int n9 = i == n6 - 1 ? this.rows : n8 + n7;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n6 = n3 + n8 * DenseDComplexMatrix2D.this.rowStride;
                        int n22 = n5 + n8 * n2;
                        for (int i = n8; i < n9; ++i) {
                            double d = 0.0;
                            double d2 = 0.0;
                            int n32 = n6;
                            int n42 = n4;
                            for (int j = 0; j < DenseDComplexMatrix2D.this.columns; ++j) {
                                double d3 = DenseDComplexMatrix2D.this.elements[n32];
                                double d4 = DenseDComplexMatrix2D.this.elements[n32 + 1];
                                double d5 = dArray3[n42];
                                double d6 = dArray3[n42 + 1];
                                d += d3 * d5 - d4 * d6;
                                d2 += d4 * d5 + d3 * d6;
                                n32 += DenseDComplexMatrix2D.this.columnStride;
                                n42 += n;
                            }
                            double d7 = dArray4[n22];
                            double d8 = dArray4[n22 + 1];
                            dArray4[n22] = d * dArray[0] - d2 * dArray[1] + d7 * dArray2[0] - d8 * dArray2[1];
                            dArray4[n22 + 1] = d2 * dArray[0] + d * dArray[1] + d8 * dArray2[0] + d7 * dArray2[1];
                            n6 += DenseDComplexMatrix2D.this.rowStride;
                            n22 += n2;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n10 = n3;
            int n11 = n5;
            for (int i = 0; i < this.rows; ++i) {
                double d = 0.0;
                double d2 = 0.0;
                int n12 = n10;
                int n13 = n4;
                for (int j = 0; j < this.columns; ++j) {
                    double d3 = this.elements[n12];
                    double d4 = this.elements[n12 + 1];
                    double d5 = dArray3[n13];
                    double d6 = dArray3[n13 + 1];
                    d += d3 * d5 - d4 * d6;
                    d2 += d4 * d5 + d3 * d6;
                    n12 += this.columnStride;
                    n13 += n;
                }
                double d7 = dArray4[n11];
                double d8 = dArray4[n11 + 1];
                dArray4[n11] = d * dArray[0] - d2 * dArray[1] + d7 * dArray2[0] - d8 * dArray2[1];
                dArray4[n11 + 1] = d2 * dArray[0] + d * dArray[1] + d8 * dArray2[0] + d7 * dArray2[1];
                n10 += this.rowStride;
                n11 += n2;
            }
        }
        dComplexMatrix1D2 = dComplexMatrix1D3;
        return dComplexMatrix1D2;
    }

    @Override
    public DComplexMatrix2D zMult(final DComplexMatrix2D dComplexMatrix2D, DComplexMatrix2D dComplexMatrix2D2, final double[] dArray, final double[] dArray2, final boolean bl, final boolean bl2) {
        int n;
        final int n2 = this.rows;
        int n3 = this.columns;
        final int n4 = dComplexMatrix2D.rows();
        int n5 = dComplexMatrix2D.columns();
        final int n6 = bl ? n3 : n2;
        int n7 = n = bl2 ? n4 : n5;
        if (dComplexMatrix2D2 == null) {
            dComplexMatrix2D2 = new DenseDComplexMatrix2D(n6, n);
        }
        if (ConcurrencyUtils.getUseJCublas()) {
            int n8;
            int n9;
            int n10;
            int n11;
            final DComplexMatrix2D dComplexMatrix2D3 = dComplexMatrix2D2;
            JCuDoubleComplex jCuDoubleComplex = JCuDoubleComplex.cuCmplx(dArray[0], dArray[1]);
            JCuDoubleComplex jCuDoubleComplex2 = JCuDoubleComplex.cuCmplx(dArray2[0], dArray2[1]);
            final JCuDoubleComplex[] jCuDoubleComplexArray = new JCuDoubleComplex[n2 * n3];
            final JCuDoubleComplex[] jCuDoubleComplexArray2 = new JCuDoubleComplex[n4 * n5];
            final JCuDoubleComplex[] jCuDoubleComplexArray3 = new JCuDoubleComplex[n6 * n];
            int n12 = ConcurrencyUtils.getNumberOfThreads();
            if (n12 > 1 && n2 * n3 >= ConcurrencyUtils.getThreadsBeginN_2D()) {
                Future[] futureArray = new Future[n12];
                n11 = n3 / n12;
                for (n10 = 0; n10 < n12; ++n10) {
                    n9 = n10 * n11;
                    n8 = n10 == n12 - 1 ? n3 : n9 + n11;
                    futureArray[n10] = ConcurrencyUtils.submit(new Runnable(){

                        public void run() {
                            for (int i = n9; i < n8; ++i) {
                                for (int j = 0; j < n2; ++j) {
                                    double[] dArray = DenseDComplexMatrix2D.this.getQuick(j, i);
                                    jCuDoubleComplexArray[i * n2 + j] = JCuDoubleComplex.cuCmplx(dArray[0], dArray[1]);
                                }
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futureArray);
                n11 = n5 / n12;
                for (n10 = 0; n10 < n12; ++n10) {
                    n9 = n10 * n11;
                    n8 = n10 == n12 - 1 ? n5 : n9 + n11;
                    futureArray[n10] = ConcurrencyUtils.submit(new Runnable(){

                        public void run() {
                            for (int i = n9; i < n8; ++i) {
                                for (int j = 0; j < n4; ++j) {
                                    double[] dArray = dComplexMatrix2D.getQuick(j, i);
                                    jCuDoubleComplexArray2[i * n4 + j] = JCuDoubleComplex.cuCmplx(dArray[0], dArray[1]);
                                }
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futureArray);
                n11 = n / n12;
                for (n10 = 0; n10 < n12; ++n10) {
                    n9 = n10 * n11;
                    n8 = n10 == n12 - 1 ? n : n9 + n11;
                    futureArray[n10] = ConcurrencyUtils.submit(new Runnable(){

                        public void run() {
                            for (int i = n9; i < n8; ++i) {
                                for (int j = 0; j < n6; ++j) {
                                    double[] dArray = dComplexMatrix2D3.getQuick(j, i);
                                    jCuDoubleComplexArray3[i * n6 + j] = JCuDoubleComplex.cuCmplx(dArray[0], dArray[1]);
                                }
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futureArray);
            } else {
                double[] dArray3;
                int n13;
                for (n13 = 0; n13 < n3; ++n13) {
                    for (n11 = 0; n11 < n2; ++n11) {
                        dArray3 = this.getQuick(n11, n13);
                        jCuDoubleComplexArray[n13 * n2 + n11] = JCuDoubleComplex.cuCmplx(dArray3[0], dArray3[1]);
                    }
                }
                for (n13 = 0; n13 < n5; ++n13) {
                    for (n11 = 0; n11 < n4; ++n11) {
                        dArray3 = dComplexMatrix2D.getQuick(n11, n13);
                        jCuDoubleComplexArray2[n13 * n4 + n11] = JCuDoubleComplex.cuCmplx(dArray3[0], dArray3[1]);
                    }
                }
                for (n13 = 0; n13 < n; ++n13) {
                    for (n11 = 0; n11 < n6; ++n11) {
                        dArray3 = dComplexMatrix2D2.getQuick(n11, n13);
                        jCuDoubleComplexArray3[n13 * n6 + n11] = JCuDoubleComplex.cuCmplx(dArray3[0], dArray3[1]);
                    }
                }
            }
            JCublas.cublasAlloc(this.size(), 16, "d_A");
            JCublas.cublasAlloc(dComplexMatrix2D.size(), 16, "d_B");
            JCublas.cublasAlloc(dComplexMatrix2D2.size(), 16, "d_C");
            JCublas.cublasSetVector(this.size(), jCuDoubleComplexArray, 1, "d_A", 1);
            JCublas.cublasSetVector(dComplexMatrix2D.size(), jCuDoubleComplexArray2, 1, "d_B", 1);
            JCublas.cublasSetVector(dComplexMatrix2D2.size(), jCuDoubleComplexArray3, 1, "d_C", 1);
            int n14 = bl ? n3 : n2;
            n11 = bl2 ? n4 : n5;
            n10 = bl ? n2 : n3;
            n9 = bl ? n10 : n14;
            n8 = bl2 ? n11 : n10;
            int n15 = n14;
            JCublas.cublasZgemm(bl ? (char)'c' : 'n', bl2 ? (char)'c' : 'n', n14, n11, n10, jCuDoubleComplex, "d_A", n9, "d_B", n8, jCuDoubleComplex2, "d_C", n15);
            JCublas.cublasGetVector(dComplexMatrix2D2.size(), "d_C", 1, jCuDoubleComplexArray3, 1);
            JCublas.cublasFree("d_A");
            JCublas.cublasFree("d_B");
            JCublas.cublasFree("d_C");
            int n16 = JCublas.cublasGetError();
            if (n16 != 0) {
                throw new InternalError("Error occured while using CUBLAS library: " + n16);
            }
            if (n12 > 1 && n2 * n3 >= ConcurrencyUtils.getThreadsBeginN_2D()) {
                Future[] futureArray = new Future[n12];
                n10 = n / n12;
                for (int i = 0; i < n12; ++i) {
                    final int n17 = i * n10;
                    final int n18 = i == n12 - 1 ? n : n17 + n10;
                    futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                        public void run() {
                            for (int i = n17; i < n18; ++i) {
                                for (int j = 0; j < n6; ++j) {
                                    JCuDoubleComplex jCuDoubleComplex = jCuDoubleComplexArray3[i * n6 + j];
                                    dComplexMatrix2D3.setQuick(j, i, new double[]{jCuDoubleComplex.x, jCuDoubleComplex.y});
                                }
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futureArray);
            } else {
                for (int i = 0; i < n; ++i) {
                    for (int j = 0; j < n6; ++j) {
                        JCuDoubleComplex jCuDoubleComplex3 = jCuDoubleComplexArray3[i * n6 + j];
                        dComplexMatrix2D2.setQuick(j, i, new double[]{jCuDoubleComplex3.x, jCuDoubleComplex3.y});
                    }
                }
            }
        } else {
            if (bl) {
                return this.getConjugateTranspose().zMult(dComplexMatrix2D, dComplexMatrix2D2, dArray, dArray2, false, bl2);
            }
            if (bl2) {
                return this.zMult(dComplexMatrix2D.getConjugateTranspose(), dComplexMatrix2D2, dArray, dArray2, bl, false);
            }
            if (dComplexMatrix2D.rows() != n3) {
                throw new IllegalArgumentException("Matrix2D inner dimensions must agree:" + this.toStringShort() + ", " + dComplexMatrix2D.toStringShort());
            }
            if (dComplexMatrix2D2.rows() != n2 || dComplexMatrix2D2.columns() != n5) {
                throw new IllegalArgumentException("Incompatibe result matrix: " + this.toStringShort() + ", " + dComplexMatrix2D.toStringShort() + ", " + dComplexMatrix2D2.toStringShort());
            }
            if (this == dComplexMatrix2D2 || dComplexMatrix2D == dComplexMatrix2D2) {
                throw new IllegalArgumentException("Matrices must not be identical");
            }
            long l = 2L * (long)n2 * (long)n3 * (long)n5;
            int n19 = (int)Math.min(l / 30000L, (long)ConcurrencyUtils.getNumberOfThreads());
            boolean bl3 = n5 >= n19;
            int n20 = bl3 ? n5 : n2;
            n19 = Math.min(n20, n19);
            if (n19 < 2) {
                return this.zMultSeq(dComplexMatrix2D, dComplexMatrix2D2, dArray, dArray2, bl, bl2);
            }
            int n21 = n20 / n19;
            Future[] futureArray = new Future[n19];
            for (int i = 0; i < n19; ++i) {
                DComplexMatrix2D dComplexMatrix2D4;
                DComplexMatrix2D dComplexMatrix2D5;
                DComplexMatrix2D dComplexMatrix2D6;
                int n22 = i * n21;
                if (i == n19 - 1) {
                    n21 = n20 - n21 * i;
                }
                if (bl3) {
                    dComplexMatrix2D6 = this;
                    dComplexMatrix2D5 = dComplexMatrix2D.viewPart(0, n22, n3, n21);
                    dComplexMatrix2D4 = dComplexMatrix2D2.viewPart(0, n22, n2, n21);
                } else {
                    dComplexMatrix2D6 = this.viewPart(n22, 0, n21, n3);
                    dComplexMatrix2D5 = dComplexMatrix2D;
                    dComplexMatrix2D4 = dComplexMatrix2D2.viewPart(n22, 0, n21, n5);
                }
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        ((DenseDComplexMatrix2D)dComplexMatrix2D6).zMultSeq(dComplexMatrix2D5, dComplexMatrix2D4, dArray, dArray2, bl, bl2);
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        }
        return dComplexMatrix2D2;
    }

    protected DComplexMatrix2D zMultSeq(DComplexMatrix2D dComplexMatrix2D, DComplexMatrix2D dComplexMatrix2D2, double[] dArray, double[] dArray2, boolean bl, boolean bl2) {
        if (bl) {
            return this.getConjugateTranspose().zMult(dComplexMatrix2D, dComplexMatrix2D2, dArray, dArray2, false, bl2);
        }
        if (bl2) {
            return this.zMult(dComplexMatrix2D.getConjugateTranspose(), dComplexMatrix2D2, dArray, dArray2, bl, false);
        }
        int n = this.rows;
        int n2 = this.columns;
        int n3 = dComplexMatrix2D.columns();
        if (dComplexMatrix2D2 == null) {
            dComplexMatrix2D2 = new DenseDComplexMatrix2D(n, n3);
        }
        if (!(dComplexMatrix2D2 instanceof DenseDComplexMatrix2D)) {
            return super.zMult(dComplexMatrix2D, dComplexMatrix2D2, dArray, dArray2, bl, bl2);
        }
        if (dComplexMatrix2D.rows() != n2) {
            throw new IllegalArgumentException("Matrix2D inner dimensions must agree:" + this.toStringShort() + ", " + dComplexMatrix2D.toStringShort());
        }
        if (dComplexMatrix2D2.rows() != n || dComplexMatrix2D2.columns() != n3) {
            throw new IllegalArgumentException("Incompatibel result matrix: " + this.toStringShort() + ", " + dComplexMatrix2D.toStringShort() + ", " + dComplexMatrix2D2.toStringShort());
        }
        if (this == dComplexMatrix2D2 || dComplexMatrix2D == dComplexMatrix2D2) {
            throw new IllegalArgumentException("Matrices must not be identical");
        }
        DenseDComplexMatrix2D denseDComplexMatrix2D = (DenseDComplexMatrix2D)dComplexMatrix2D;
        DenseDComplexMatrix2D denseDComplexMatrix2D2 = (DenseDComplexMatrix2D)dComplexMatrix2D2;
        double[] dArray3 = this.elements;
        double[] dArray4 = denseDComplexMatrix2D.elements;
        double[] dArray5 = denseDComplexMatrix2D2.elements;
        if (dArray3 == null || dArray4 == null || dArray5 == null) {
            throw new InternalError();
        }
        int n4 = this.columnStride;
        int n5 = denseDComplexMatrix2D.columnStride;
        int n6 = denseDComplexMatrix2D2.columnStride;
        int n7 = this.rowStride;
        int n8 = denseDComplexMatrix2D.rowStride;
        int n9 = denseDComplexMatrix2D2.rowStride;
        int n10 = (30000 - n2) / (n2 + 1);
        if (n10 <= 0) {
            n10 = 1;
        }
        int n11 = n / n10;
        int n12 = 0;
        if (n % n10 != 0) {
            ++n11;
        }
        while (--n11 >= 0) {
            int n13 = (int)denseDComplexMatrix2D.index(0, 0);
            int n14 = (int)this.index(n12, 0);
            int n15 = (int)denseDComplexMatrix2D2.index(n12, 0);
            n12 += n10;
            if (n11 == 0) {
                n10 += n - n12;
            }
            int n16 = n3;
            while (--n16 >= 0) {
                int n17 = n14;
                int n18 = n15;
                int n19 = n10;
                while (--n19 >= 0) {
                    double d;
                    double d2;
                    double d3;
                    double d4;
                    int n20 = n17;
                    int n21 = n13;
                    double d5 = 0.0;
                    double d6 = 0.0;
                    n20 -= n4;
                    n21 -= n8;
                    int n22 = n2 % 4;
                    while (--n22 >= 0) {
                        d4 = dArray3[n20 += n4];
                        d3 = dArray3[n20 + 1];
                        d2 = dArray4[n21 += n8];
                        d = dArray4[n21 + 1];
                        d5 += d4 * d2 - d3 * d;
                        d6 += d3 * d2 + d4 * d;
                    }
                    n22 = n2 / 4;
                    while (--n22 >= 0) {
                        d4 = dArray3[n20 += n4];
                        d3 = dArray3[n20 + 1];
                        d2 = dArray4[n21 += n8];
                        d = dArray4[n21 + 1];
                        d5 += d4 * d2 - d3 * d;
                        d6 += d3 * d2 + d4 * d;
                        d4 = dArray3[n20 += n4];
                        d3 = dArray3[n20 + 1];
                        d2 = dArray4[n21 += n8];
                        d = dArray4[n21 + 1];
                        d5 += d4 * d2 - d3 * d;
                        d6 += d3 * d2 + d4 * d;
                        d4 = dArray3[n20 += n4];
                        d3 = dArray3[n20 + 1];
                        d2 = dArray4[n21 += n8];
                        d = dArray4[n21 + 1];
                        d5 += d4 * d2 - d3 * d;
                        d6 += d3 * d2 + d4 * d;
                        d4 = dArray3[n20 += n4];
                        d3 = dArray3[n20 + 1];
                        d2 = dArray4[n21 += n8];
                        d = dArray4[n21 + 1];
                        d5 += d4 * d2 - d3 * d;
                        d6 += d3 * d2 + d4 * d;
                    }
                    double d7 = dArray5[n18];
                    double d8 = dArray5[n18 + 1];
                    dArray5[n18] = dArray[0] * d5 - dArray[1] * d6 + dArray2[0] * d7 - dArray2[1] * d8;
                    dArray5[n18 + 1] = dArray[1] * d5 + dArray[0] * d6 + dArray2[1] * d7 + dArray2[0] * d8;
                    n17 += n7;
                    n18 += n9;
                }
                n13 += n5;
                n15 += n6;
            }
        }
        return dComplexMatrix2D2;
    }

    @Override
    public double[] zSum() {
        double[] dArray = new double[2];
        final int n = (int)this.index(0, 0);
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            int n3;
            Future[] futureArray = new Future[n2];
            int n4 = this.rows / n2;
            for (int i = 0; i < n2; ++i) {
                n3 = i * n4;
                final int n5 = i == n2 - 1 ? this.rows : n3 + n4;
                futureArray[i] = ConcurrencyUtils.submit(new Callable<double[]>(){

                    @Override
                    public double[] call() throws Exception {
                        double[] dArray = new double[2];
                        int n4 = n + n3 * DenseDComplexMatrix2D.this.rowStride;
                        for (int i = n3; i < n5; ++i) {
                            int n2 = n4;
                            for (int j = 0; j < DenseDComplexMatrix2D.this.columns; ++j) {
                                dArray[0] = dArray[0] + DenseDComplexMatrix2D.this.elements[n2];
                                dArray[1] = dArray[1] + DenseDComplexMatrix2D.this.elements[n2 + 1];
                                n2 += DenseDComplexMatrix2D.this.columnStride;
                            }
                            n4 += DenseDComplexMatrix2D.this.rowStride;
                        }
                        return dArray;
                    }
                });
            }
            try {
                for (n3 = 0; n3 < n2; ++n3) {
                    double[] dArray2 = (double[])futureArray[n3].get();
                    dArray[0] = dArray[0] + dArray2[0];
                    dArray[1] = dArray[1] + dArray2[1];
                }
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        } else {
            int n6 = n;
            for (int i = 0; i < this.rows; ++i) {
                int n7 = n6;
                for (int j = 0; j < this.columns; ++j) {
                    dArray[0] = dArray[0] + this.elements[n7];
                    dArray[1] = dArray[1] + this.elements[n7 + 1];
                    n7 += this.columnStride;
                }
                n6 += this.rowStride;
            }
        }
        return dArray;
    }

    @Override
    protected boolean haveSharedCellsRaw(DComplexMatrix2D dComplexMatrix2D) {
        if (dComplexMatrix2D instanceof SelectedDenseDComplexMatrix2D) {
            SelectedDenseDComplexMatrix2D selectedDenseDComplexMatrix2D = (SelectedDenseDComplexMatrix2D)dComplexMatrix2D;
            return this.elements == selectedDenseDComplexMatrix2D.elements;
        }
        if (dComplexMatrix2D instanceof DenseDComplexMatrix2D) {
            DenseDComplexMatrix2D denseDComplexMatrix2D = (DenseDComplexMatrix2D)dComplexMatrix2D;
            return this.elements == denseDComplexMatrix2D.elements;
        }
        return false;
    }

    @Override
    public long index(int n, int n2) {
        return this.rowZero + n * this.rowStride + this.columnZero + n2 * this.columnStride;
    }

    @Override
    protected DComplexMatrix1D like1D(int n, int n2, int n3) {
        return new DenseDComplexMatrix1D(n, this.elements, n2, n3);
    }

    @Override
    protected DComplexMatrix2D viewSelectionLike(int[] nArray, int[] nArray2) {
        return new SelectedDenseDComplexMatrix2D(this.elements, nArray, nArray2, 0);
    }
}

