/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdcomplex.impl;

import cern.colt.Timer;
import cern.colt.function.tdcomplex.DComplexProcedure;
import cern.colt.function.tdcomplex.IntIntDComplexFunction;
import cern.colt.list.tint.IntArrayList;
import cern.colt.matrix.BenchmarkMatrixKernel;
import cern.colt.matrix.tdcomplex.DComplexMatrix1D;
import cern.colt.matrix.tdcomplex.DComplexMatrix2D;
import cern.colt.matrix.tdcomplex.impl.DenseDComplexMatrix1D;
import cern.colt.matrix.tdcomplex.impl.DenseDComplexMatrix2D;
import cern.colt.matrix.tdouble.DoubleMatrix2D;
import cern.jet.math.tdcomplex.DComplex;
import cern.jet.math.tdcomplex.DComplexFunctions;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.util.ArrayList;
import java.util.Random;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.JUnitCore;

public class BenchmarkDenseDComplexMatrix2D {
    private static Timer t = new Timer();
    private static final String outputFile = "BenchmarkDenseDComplexMatrix2D.txt";
    private static double[][] a_2d;
    private static double[][] b_2d;
    private static double[] a_1d;
    private static double[] b_1d;
    private static double[] noViewTimes;
    private static double[] viewTimes;

    public static void main(String[] stringArray) {
        JUnitCore.main((String[])new String[]{"cern.colt.matrix.tdcomplex.impl.BenchmarkDenseDComplexMatrix2D"});
    }

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        int n;
        int n2;
        BenchmarkMatrixKernel.readSettings2D();
        Random random = new Random(0L);
        ConcurrencyUtils.setThreadsBeginN_2D(BenchmarkMatrixKernel.MATRIX_SIZE_2D[0] * BenchmarkMatrixKernel.MATRIX_SIZE_2D[1]);
        a_1d = new double[2 * BenchmarkMatrixKernel.MATRIX_SIZE_2D[0] * BenchmarkMatrixKernel.MATRIX_SIZE_2D[1]];
        a_2d = new double[BenchmarkMatrixKernel.MATRIX_SIZE_2D[0]][2 * BenchmarkMatrixKernel.MATRIX_SIZE_2D[1]];
        int n3 = 0;
        for (n2 = 0; n2 < BenchmarkMatrixKernel.MATRIX_SIZE_2D[0]; ++n2) {
            for (n = 0; n < 2 * BenchmarkMatrixKernel.MATRIX_SIZE_2D[1]; ++n) {
                BenchmarkDenseDComplexMatrix2D.a_2d[n2][n] = random.nextDouble();
                BenchmarkDenseDComplexMatrix2D.a_1d[n3++] = a_2d[n2][n];
            }
        }
        b_1d = new double[2 * BenchmarkMatrixKernel.MATRIX_SIZE_2D[0] * BenchmarkMatrixKernel.MATRIX_SIZE_2D[1]];
        b_2d = new double[BenchmarkMatrixKernel.MATRIX_SIZE_2D[0]][2 * BenchmarkMatrixKernel.MATRIX_SIZE_2D[1]];
        n3 = 0;
        for (n2 = 0; n2 < BenchmarkMatrixKernel.MATRIX_SIZE_2D[0]; ++n2) {
            for (n = 0; n < 2 * BenchmarkMatrixKernel.MATRIX_SIZE_2D[1]; ++n) {
                BenchmarkDenseDComplexMatrix2D.b_2d[n2][n] = random.nextDouble();
                BenchmarkDenseDComplexMatrix2D.b_1d[n3++] = b_2d[n2][n];
            }
        }
        BenchmarkMatrixKernel.writePropertiesToFile(outputFile, BenchmarkMatrixKernel.MATRIX_SIZE_2D);
        BenchmarkMatrixKernel.displayProperties(BenchmarkMatrixKernel.MATRIX_SIZE_2D);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        a_1d = null;
        a_2d = null;
        b_1d = null;
        b_2d = null;
        ConcurrencyUtils.resetThreadsBeginN();
        System.gc();
    }

    @Before
    public void setUpBefore() {
        noViewTimes = new double[BenchmarkMatrixKernel.NTHREADS.length];
        viewTimes = new double[BenchmarkMatrixKernel.NTHREADS.length];
    }

    @Test
    public void testAggregateDComplexDComplexDComplexFunctionDComplexDComplexFunction() {
        DenseDComplexMatrix2D denseDComplexMatrix2D = new DenseDComplexMatrix2D(a_2d);
        int n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            double[] dArray = ((DComplexMatrix2D)denseDComplexMatrix2D).aggregate(DComplexFunctions.plus, DComplexFunctions.square);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                t.reset().start();
                dArray = ((DComplexMatrix2D)denseDComplexMatrix2D).aggregate(DComplexFunctions.plus, DComplexFunctions.square);
                t.stop();
                int n2 = n;
                noViewTimes[n2] = noViewTimes[n2] + t.millis();
            }
            int n3 = n++;
            noViewTimes[n3] = noViewTimes[n3] / (double)BenchmarkMatrixKernel.NITERS;
        }
        DComplexMatrix2D dComplexMatrix2D = new DenseDComplexMatrix2D(BenchmarkMatrixKernel.MATRIX_SIZE_2D[1], BenchmarkMatrixKernel.MATRIX_SIZE_2D[0]).viewDice().assign(a_2d);
        int n4 = 0;
        while (n4 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n4]);
            double[] dArray = dComplexMatrix2D.aggregate(DComplexFunctions.plus, DComplexFunctions.square);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                t.reset().start();
                dArray = dComplexMatrix2D.aggregate(DComplexFunctions.plus, DComplexFunctions.square);
                t.stop();
                int n5 = n4;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n4++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "aggregate(DComplexDComplexDComplexFunction, DComplexDComplexFunction)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testAggregateDComplexMatrix2DDComplexDComplexDComplexFunctionDComplexDComplexDComplexFunction() {
        int n;
        Object object;
        DenseDComplexMatrix2D denseDComplexMatrix2D = new DenseDComplexMatrix2D(a_2d);
        DenseDComplexMatrix2D denseDComplexMatrix2D2 = new DenseDComplexMatrix2D(b_2d);
        int n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            object = ((DComplexMatrix2D)denseDComplexMatrix2D).aggregate(denseDComplexMatrix2D2, DComplexFunctions.plus, DComplexFunctions.mult);
            for (n = 0; n < BenchmarkMatrixKernel.NITERS; ++n) {
                t.reset().start();
                object = ((DComplexMatrix2D)denseDComplexMatrix2D).aggregate(denseDComplexMatrix2D2, DComplexFunctions.plus, DComplexFunctions.mult);
                t.stop();
                int n3 = n2;
                noViewTimes[n3] = noViewTimes[n3] + t.millis();
            }
            int n4 = n2++;
            noViewTimes[n4] = noViewTimes[n4] / (double)BenchmarkMatrixKernel.NITERS;
        }
        DComplexMatrix2D dComplexMatrix2D = new DenseDComplexMatrix2D(BenchmarkMatrixKernel.MATRIX_SIZE_2D[1], BenchmarkMatrixKernel.MATRIX_SIZE_2D[0]).viewDice().assign(a_2d);
        object = new DenseDComplexMatrix2D(BenchmarkMatrixKernel.MATRIX_SIZE_2D[1], BenchmarkMatrixKernel.MATRIX_SIZE_2D[0]).viewDice().assign(b_2d);
        n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            double[] dArray = dComplexMatrix2D.aggregate((DComplexMatrix2D)object, DComplexFunctions.plus, DComplexFunctions.mult);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                t.reset().start();
                dArray = dComplexMatrix2D.aggregate((DComplexMatrix2D)object, DComplexFunctions.plus, DComplexFunctions.mult);
                t.stop();
                int n5 = n;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "aggregate(DComplexMatrix2D, DComplexDComplexDComplexFunction, DComplexDComplexDComplexFunction)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testAssignDoubleDouble() {
        int n;
        DenseDComplexMatrix2D denseDComplexMatrix2D = new DenseDComplexMatrix2D(BenchmarkMatrixKernel.MATRIX_SIZE_2D[0], BenchmarkMatrixKernel.MATRIX_SIZE_2D[1]);
        double d = Math.random();
        int n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            ((DComplexMatrix2D)denseDComplexMatrix2D).assign(d, d);
            for (n = 0; n < BenchmarkMatrixKernel.NITERS; ++n) {
                ((DComplexMatrix2D)denseDComplexMatrix2D).assign(0.0, 0.0);
                t.reset().start();
                ((DComplexMatrix2D)denseDComplexMatrix2D).assign(d, d);
                t.stop();
                int n3 = n2;
                noViewTimes[n3] = noViewTimes[n3] + t.millis();
            }
            int n4 = n2++;
            noViewTimes[n4] = noViewTimes[n4] / (double)BenchmarkMatrixKernel.NITERS;
        }
        DComplexMatrix2D dComplexMatrix2D = new DenseDComplexMatrix2D(BenchmarkMatrixKernel.MATRIX_SIZE_2D[1], BenchmarkMatrixKernel.MATRIX_SIZE_2D[0]).viewDice();
        n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            dComplexMatrix2D.assign(d, d);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                dComplexMatrix2D.assign(0.0, 0.0);
                t.reset().start();
                dComplexMatrix2D.assign(d, d);
                t.stop();
                int n5 = n;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "assign(double, double)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testAssignDoubleArray() {
        int n;
        DenseDComplexMatrix2D denseDComplexMatrix2D = new DenseDComplexMatrix2D(BenchmarkMatrixKernel.MATRIX_SIZE_2D[0], BenchmarkMatrixKernel.MATRIX_SIZE_2D[1]);
        int n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            ((DComplexMatrix2D)denseDComplexMatrix2D).assign(a_1d);
            for (n = 0; n < BenchmarkMatrixKernel.NITERS; ++n) {
                ((DComplexMatrix2D)denseDComplexMatrix2D).assign(0.0, 0.0);
                t.reset().start();
                ((DComplexMatrix2D)denseDComplexMatrix2D).assign(a_1d);
                t.stop();
                int n3 = n2;
                noViewTimes[n3] = noViewTimes[n3] + t.millis();
            }
            int n4 = n2++;
            noViewTimes[n4] = noViewTimes[n4] / (double)BenchmarkMatrixKernel.NITERS;
        }
        DComplexMatrix2D dComplexMatrix2D = new DenseDComplexMatrix2D(BenchmarkMatrixKernel.MATRIX_SIZE_2D[1], BenchmarkMatrixKernel.MATRIX_SIZE_2D[0]).viewDice();
        n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            dComplexMatrix2D.assign(a_1d);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                dComplexMatrix2D.assign(0.0, 0.0);
                t.reset().start();
                dComplexMatrix2D.assign(a_1d);
                t.stop();
                int n5 = n;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "assign(double[])";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testAssignDoubleArrayArray() {
        int n;
        DenseDComplexMatrix2D denseDComplexMatrix2D = new DenseDComplexMatrix2D(BenchmarkMatrixKernel.MATRIX_SIZE_2D[0], BenchmarkMatrixKernel.MATRIX_SIZE_2D[1]);
        int n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            ((DComplexMatrix2D)denseDComplexMatrix2D).assign(a_2d);
            for (n = 0; n < BenchmarkMatrixKernel.NITERS; ++n) {
                ((DComplexMatrix2D)denseDComplexMatrix2D).assign(0.0, 0.0);
                t.reset().start();
                ((DComplexMatrix2D)denseDComplexMatrix2D).assign(a_2d);
                t.stop();
                int n3 = n2;
                noViewTimes[n3] = noViewTimes[n3] + t.millis();
            }
            int n4 = n2++;
            noViewTimes[n4] = noViewTimes[n4] / (double)BenchmarkMatrixKernel.NITERS;
        }
        DComplexMatrix2D dComplexMatrix2D = new DenseDComplexMatrix2D(BenchmarkMatrixKernel.MATRIX_SIZE_2D[1], BenchmarkMatrixKernel.MATRIX_SIZE_2D[0]).viewDice();
        n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            dComplexMatrix2D.assign(a_2d);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                dComplexMatrix2D.assign(0.0, 0.0);
                t.reset().start();
                dComplexMatrix2D.assign(a_2d);
                t.stop();
                int n5 = n;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "assign(double[][])";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testAssignDComplexDComplexFunction() {
        int n;
        DenseDComplexMatrix2D denseDComplexMatrix2D = new DenseDComplexMatrix2D(a_2d);
        int n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            ((DComplexMatrix2D)denseDComplexMatrix2D).assign(DComplexFunctions.acos);
            for (n = 0; n < BenchmarkMatrixKernel.NITERS; ++n) {
                ((DComplexMatrix2D)denseDComplexMatrix2D).assign(a_2d);
                t.reset().start();
                ((DComplexMatrix2D)denseDComplexMatrix2D).assign(DComplexFunctions.acos);
                t.stop();
                int n3 = n2;
                noViewTimes[n3] = noViewTimes[n3] + t.millis();
            }
            int n4 = n2++;
            noViewTimes[n4] = noViewTimes[n4] / (double)BenchmarkMatrixKernel.NITERS;
        }
        DComplexMatrix2D dComplexMatrix2D = new DenseDComplexMatrix2D(BenchmarkMatrixKernel.MATRIX_SIZE_2D[1], BenchmarkMatrixKernel.MATRIX_SIZE_2D[0]).viewDice().assign(a_2d);
        n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            dComplexMatrix2D.assign(DComplexFunctions.acos);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                dComplexMatrix2D.assign(a_2d);
                t.reset().start();
                dComplexMatrix2D.assign(DComplexFunctions.acos);
                t.stop();
                int n5 = n;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "assign(DComplexDComplexFunction)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testAssignDComplexMatrix2D() {
        DenseDComplexMatrix2D denseDComplexMatrix2D = new DenseDComplexMatrix2D(BenchmarkMatrixKernel.MATRIX_SIZE_2D[0], BenchmarkMatrixKernel.MATRIX_SIZE_2D[1]);
        DenseDComplexMatrix2D denseDComplexMatrix2D2 = new DenseDComplexMatrix2D(a_2d);
        int n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            ((DComplexMatrix2D)denseDComplexMatrix2D).assign(denseDComplexMatrix2D2);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                ((DComplexMatrix2D)denseDComplexMatrix2D).assign(0.0, 0.0);
                t.reset().start();
                ((DComplexMatrix2D)denseDComplexMatrix2D).assign(denseDComplexMatrix2D2);
                t.stop();
                int n2 = n;
                noViewTimes[n2] = noViewTimes[n2] + t.millis();
            }
            int n3 = n++;
            noViewTimes[n3] = noViewTimes[n3] / (double)BenchmarkMatrixKernel.NITERS;
        }
        denseDComplexMatrix2D = new DenseDComplexMatrix2D(BenchmarkMatrixKernel.MATRIX_SIZE_2D[0], BenchmarkMatrixKernel.MATRIX_SIZE_2D[1]);
        DComplexMatrix2D dComplexMatrix2D = denseDComplexMatrix2D.viewDice();
        denseDComplexMatrix2D2 = new DenseDComplexMatrix2D(a_2d);
        DComplexMatrix2D dComplexMatrix2D2 = denseDComplexMatrix2D2.viewDice();
        int n4 = 0;
        while (n4 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n4]);
            dComplexMatrix2D.assign(dComplexMatrix2D2);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                dComplexMatrix2D.assign(0.0, 0.0);
                t.reset().start();
                dComplexMatrix2D.assign(dComplexMatrix2D2);
                t.stop();
                int n5 = n4;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n4++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "assign(DComplexMatrix2D)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testAssignDComplexMatrix2DDComplexDComplexDComplexFunction() {
        DenseDComplexMatrix2D denseDComplexMatrix2D = new DenseDComplexMatrix2D(a_2d);
        DenseDComplexMatrix2D denseDComplexMatrix2D2 = new DenseDComplexMatrix2D(b_2d);
        int n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            ((DComplexMatrix2D)denseDComplexMatrix2D).assign(denseDComplexMatrix2D2, DComplexFunctions.div);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                ((DComplexMatrix2D)denseDComplexMatrix2D).assign(a_2d);
                t.reset().start();
                ((DComplexMatrix2D)denseDComplexMatrix2D).assign(denseDComplexMatrix2D2, DComplexFunctions.div);
                t.stop();
                int n2 = n;
                noViewTimes[n2] = noViewTimes[n2] + t.millis();
            }
            int n3 = n++;
            noViewTimes[n3] = noViewTimes[n3] / (double)BenchmarkMatrixKernel.NITERS;
        }
        DComplexMatrix2D dComplexMatrix2D = new DenseDComplexMatrix2D(BenchmarkMatrixKernel.MATRIX_SIZE_2D[1], BenchmarkMatrixKernel.MATRIX_SIZE_2D[0]).viewDice().assign(a_2d);
        DComplexMatrix2D dComplexMatrix2D2 = new DenseDComplexMatrix2D(BenchmarkMatrixKernel.MATRIX_SIZE_2D[1], BenchmarkMatrixKernel.MATRIX_SIZE_2D[0]).viewDice().assign(b_2d);
        int n4 = 0;
        while (n4 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n4]);
            dComplexMatrix2D.assign(dComplexMatrix2D2, DComplexFunctions.div);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                dComplexMatrix2D.assign(a_2d);
                t.reset().start();
                dComplexMatrix2D.assign(dComplexMatrix2D2, DComplexFunctions.div);
                t.stop();
                int n5 = n4;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n4++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "assign(DComplexMatrix2D, DComplexDComplexDComplexFunction)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testAssignDComplexProcedureDoubleArray() {
        int n;
        DenseDComplexMatrix2D denseDComplexMatrix2D = new DenseDComplexMatrix2D(a_2d);
        double[] dArray = new double[]{-1.0, -2.0};
        DComplexProcedure dComplexProcedure = new DComplexProcedure(){

            public boolean apply(double[] dArray) {
                return DComplex.abs(dArray) > 0.1;
            }
        };
        int n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            ((DComplexMatrix2D)denseDComplexMatrix2D).assign(dComplexProcedure, dArray);
            for (n = 0; n < BenchmarkMatrixKernel.NITERS; ++n) {
                ((DComplexMatrix2D)denseDComplexMatrix2D).assign(a_2d);
                t.reset().start();
                ((DComplexMatrix2D)denseDComplexMatrix2D).assign(dComplexProcedure, dArray);
                t.stop();
                int n3 = n2;
                noViewTimes[n3] = noViewTimes[n3] + t.millis();
            }
            int n4 = n2++;
            noViewTimes[n4] = noViewTimes[n4] / (double)BenchmarkMatrixKernel.NITERS;
        }
        DComplexMatrix2D dComplexMatrix2D = new DenseDComplexMatrix2D(BenchmarkMatrixKernel.MATRIX_SIZE_2D[1], BenchmarkMatrixKernel.MATRIX_SIZE_2D[0]).viewDice().assign(a_2d);
        n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            dComplexMatrix2D.assign(dComplexProcedure, dArray);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                dComplexMatrix2D.assign(a_2d);
                t.reset().start();
                dComplexMatrix2D.assign(dComplexProcedure, dArray);
                t.stop();
                int n5 = n;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "assign(DComplexProcedure, double[])";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testAssignDComplexProcedureDComplexDComplexFunction() {
        int n;
        DenseDComplexMatrix2D denseDComplexMatrix2D = new DenseDComplexMatrix2D(a_2d);
        DComplexProcedure dComplexProcedure = new DComplexProcedure(){

            public boolean apply(double[] dArray) {
                return DComplex.abs(dArray) > 0.1;
            }
        };
        int n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            ((DComplexMatrix2D)denseDComplexMatrix2D).assign(dComplexProcedure, DComplexFunctions.tan);
            for (n = 0; n < BenchmarkMatrixKernel.NITERS; ++n) {
                ((DComplexMatrix2D)denseDComplexMatrix2D).assign(a_2d);
                t.reset().start();
                ((DComplexMatrix2D)denseDComplexMatrix2D).assign(dComplexProcedure, DComplexFunctions.tan);
                t.stop();
                int n3 = n2;
                noViewTimes[n3] = noViewTimes[n3] + t.millis();
            }
            int n4 = n2++;
            noViewTimes[n4] = noViewTimes[n4] / (double)BenchmarkMatrixKernel.NITERS;
        }
        DComplexMatrix2D dComplexMatrix2D = new DenseDComplexMatrix2D(BenchmarkMatrixKernel.MATRIX_SIZE_2D[1], BenchmarkMatrixKernel.MATRIX_SIZE_2D[0]).viewDice().assign(a_2d);
        n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            dComplexMatrix2D.assign(dComplexProcedure, DComplexFunctions.tan);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                dComplexMatrix2D.assign(a_2d);
                t.reset().start();
                dComplexMatrix2D.assign(dComplexProcedure, DComplexFunctions.tan);
                t.stop();
                int n5 = n;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "assign(DComplexProcedure, DComplexDComplexFunction)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testAssignFloatArray() {
        int n;
        int n2;
        DenseDComplexMatrix2D denseDComplexMatrix2D = new DenseDComplexMatrix2D(BenchmarkMatrixKernel.MATRIX_SIZE_2D[0], BenchmarkMatrixKernel.MATRIX_SIZE_2D[1]);
        float[] fArray = new float[2 * BenchmarkMatrixKernel.MATRIX_SIZE_2D[0] * BenchmarkMatrixKernel.MATRIX_SIZE_2D[1]];
        for (n2 = 0; n2 < 2 * BenchmarkMatrixKernel.MATRIX_SIZE_2D[0] * BenchmarkMatrixKernel.MATRIX_SIZE_2D[1]; ++n2) {
            fArray[n2] = (float)Math.random();
        }
        n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            ((DComplexMatrix2D)denseDComplexMatrix2D).assign(fArray);
            for (n = 0; n < BenchmarkMatrixKernel.NITERS; ++n) {
                ((DComplexMatrix2D)denseDComplexMatrix2D).assign(0.0, 0.0);
                t.reset().start();
                ((DComplexMatrix2D)denseDComplexMatrix2D).assign(fArray);
                t.stop();
                int n3 = n2;
                noViewTimes[n3] = noViewTimes[n3] + t.millis();
            }
            int n4 = n2++;
            noViewTimes[n4] = noViewTimes[n4] / (double)BenchmarkMatrixKernel.NITERS;
        }
        DComplexMatrix2D dComplexMatrix2D = new DenseDComplexMatrix2D(BenchmarkMatrixKernel.MATRIX_SIZE_2D[1], BenchmarkMatrixKernel.MATRIX_SIZE_2D[0]).viewDice();
        n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            dComplexMatrix2D.assign(fArray);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                dComplexMatrix2D.assign(0.0, 0.0);
                t.reset().start();
                dComplexMatrix2D.assign(fArray);
                t.stop();
                int n5 = n;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "assign(float[])";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testCardinality() {
        int n;
        int n2;
        DenseDComplexMatrix2D denseDComplexMatrix2D = new DenseDComplexMatrix2D(a_2d);
        int n3 = 0;
        while (n3 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n3]);
            n2 = ((DComplexMatrix2D)denseDComplexMatrix2D).cardinality();
            for (n = 0; n < BenchmarkMatrixKernel.NITERS; ++n) {
                t.reset().start();
                n2 = ((DComplexMatrix2D)denseDComplexMatrix2D).cardinality();
                t.stop();
                int n4 = n3;
                noViewTimes[n4] = noViewTimes[n4] + t.millis();
            }
            int n5 = n3++;
            noViewTimes[n5] = noViewTimes[n5] / (double)BenchmarkMatrixKernel.NITERS;
        }
        denseDComplexMatrix2D = new DenseDComplexMatrix2D(a_2d);
        DComplexMatrix2D dComplexMatrix2D = denseDComplexMatrix2D.viewDice();
        n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            n = dComplexMatrix2D.cardinality();
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                t.reset().start();
                n = dComplexMatrix2D.cardinality();
                t.stop();
                int n6 = n2;
                viewTimes[n6] = viewTimes[n6] + t.millis();
            }
            int n7 = n2++;
            viewTimes[n7] = viewTimes[n7] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "cardinality()";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testFft2() {
        int n;
        DenseDComplexMatrix2D denseDComplexMatrix2D = new DenseDComplexMatrix2D(a_2d);
        int n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            denseDComplexMatrix2D.fft2();
            for (n = 0; n < BenchmarkMatrixKernel.NITERS; ++n) {
                denseDComplexMatrix2D.assign(a_2d);
                t.reset().start();
                denseDComplexMatrix2D.fft2();
                t.stop();
                int n3 = n2;
                noViewTimes[n3] = noViewTimes[n3] + t.millis();
            }
            int n4 = n2++;
            noViewTimes[n4] = noViewTimes[n4] / (double)BenchmarkMatrixKernel.NITERS;
        }
        DComplexMatrix2D dComplexMatrix2D = new DenseDComplexMatrix2D(BenchmarkMatrixKernel.MATRIX_SIZE_2D[1], BenchmarkMatrixKernel.MATRIX_SIZE_2D[0]).viewDice().assign(a_2d);
        n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            ((DenseDComplexMatrix2D)dComplexMatrix2D).fft2();
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                dComplexMatrix2D.assign(a_2d);
                t.reset().start();
                ((DenseDComplexMatrix2D)dComplexMatrix2D).fft2();
                t.stop();
                int n5 = n;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "fft2()";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testFftColumns() {
        int n;
        DenseDComplexMatrix2D denseDComplexMatrix2D = new DenseDComplexMatrix2D(a_2d);
        int n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            denseDComplexMatrix2D.fftColumns();
            for (n = 0; n < BenchmarkMatrixKernel.NITERS; ++n) {
                denseDComplexMatrix2D.assign(a_2d);
                t.reset().start();
                denseDComplexMatrix2D.fftColumns();
                t.stop();
                int n3 = n2;
                noViewTimes[n3] = noViewTimes[n3] + t.millis();
            }
            int n4 = n2++;
            noViewTimes[n4] = noViewTimes[n4] / (double)BenchmarkMatrixKernel.NITERS;
        }
        DComplexMatrix2D dComplexMatrix2D = new DenseDComplexMatrix2D(BenchmarkMatrixKernel.MATRIX_SIZE_2D[1], BenchmarkMatrixKernel.MATRIX_SIZE_2D[0]).viewDice().assign(a_2d);
        n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            ((DenseDComplexMatrix2D)dComplexMatrix2D).fftColumns();
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                dComplexMatrix2D.assign(a_2d);
                t.reset().start();
                ((DenseDComplexMatrix2D)dComplexMatrix2D).fftColumns();
                t.stop();
                int n5 = n;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "fftColumns()";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testFftRows() {
        int n;
        DenseDComplexMatrix2D denseDComplexMatrix2D = new DenseDComplexMatrix2D(a_2d);
        int n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            denseDComplexMatrix2D.fftRows();
            for (n = 0; n < BenchmarkMatrixKernel.NITERS; ++n) {
                denseDComplexMatrix2D.assign(a_2d);
                t.reset().start();
                denseDComplexMatrix2D.fftRows();
                t.stop();
                int n3 = n2;
                noViewTimes[n3] = noViewTimes[n3] + t.millis();
            }
            int n4 = n2++;
            noViewTimes[n4] = noViewTimes[n4] / (double)BenchmarkMatrixKernel.NITERS;
        }
        DComplexMatrix2D dComplexMatrix2D = new DenseDComplexMatrix2D(BenchmarkMatrixKernel.MATRIX_SIZE_2D[1], BenchmarkMatrixKernel.MATRIX_SIZE_2D[0]).viewDice().assign(a_2d);
        n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            ((DenseDComplexMatrix2D)dComplexMatrix2D).fftRows();
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                dComplexMatrix2D.assign(a_2d);
                t.reset().start();
                ((DenseDComplexMatrix2D)dComplexMatrix2D).fftRows();
                t.stop();
                int n5 = n;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "fftRows()";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testForEachNonZero() {
        int n;
        IntIntDComplexFunction intIntDComplexFunction = new IntIntDComplexFunction(){

            public double[] apply(int n, int n2, double[] dArray) {
                return DComplex.sqrt(dArray);
            }
        };
        DenseDComplexMatrix2D denseDComplexMatrix2D = new DenseDComplexMatrix2D(a_2d);
        int n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            ((DComplexMatrix2D)denseDComplexMatrix2D).forEachNonZero(intIntDComplexFunction);
            for (n = 0; n < BenchmarkMatrixKernel.NITERS; ++n) {
                ((DComplexMatrix2D)denseDComplexMatrix2D).assign(a_2d);
                t.reset().start();
                ((DComplexMatrix2D)denseDComplexMatrix2D).forEachNonZero(intIntDComplexFunction);
                t.stop();
                int n3 = n2;
                noViewTimes[n3] = noViewTimes[n3] + t.millis();
            }
            int n4 = n2++;
            noViewTimes[n4] = noViewTimes[n4] / (double)BenchmarkMatrixKernel.NITERS;
        }
        DComplexMatrix2D dComplexMatrix2D = new DenseDComplexMatrix2D(a_2d).viewDice();
        n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            dComplexMatrix2D.forEachNonZero(intIntDComplexFunction);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                dComplexMatrix2D.assign(a_2d);
                t.reset().start();
                dComplexMatrix2D.forEachNonZero(intIntDComplexFunction);
                t.stop();
                int n5 = n;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "forEachNonZero(IntIntDComplexFunction)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testGetConjugateTranspose() {
        DenseDComplexMatrix2D denseDComplexMatrix2D = new DenseDComplexMatrix2D(a_2d);
        int n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            DComplexMatrix2D dComplexMatrix2D = ((DComplexMatrix2D)denseDComplexMatrix2D).getConjugateTranspose();
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                t.reset().start();
                dComplexMatrix2D = ((DComplexMatrix2D)denseDComplexMatrix2D).getConjugateTranspose();
                t.stop();
                int n2 = n;
                noViewTimes[n2] = noViewTimes[n2] + t.millis();
            }
            int n3 = n++;
            noViewTimes[n3] = noViewTimes[n3] / (double)BenchmarkMatrixKernel.NITERS;
        }
        DComplexMatrix2D dComplexMatrix2D = new DenseDComplexMatrix2D(BenchmarkMatrixKernel.MATRIX_SIZE_2D[1], BenchmarkMatrixKernel.MATRIX_SIZE_2D[0]).viewDice().assign(a_2d);
        int n4 = 0;
        while (n4 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n4]);
            DComplexMatrix2D dComplexMatrix2D2 = dComplexMatrix2D.getConjugateTranspose();
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                t.reset().start();
                dComplexMatrix2D2 = dComplexMatrix2D.getConjugateTranspose();
                t.stop();
                int n5 = n4;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n4++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "getConjugateTranspose()";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testGetRealPart() {
        DenseDComplexMatrix2D denseDComplexMatrix2D = new DenseDComplexMatrix2D(a_2d);
        int n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            DoubleMatrix2D doubleMatrix2D = ((DComplexMatrix2D)denseDComplexMatrix2D).getRealPart();
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                t.reset().start();
                doubleMatrix2D = ((DComplexMatrix2D)denseDComplexMatrix2D).getRealPart();
                t.stop();
                int n2 = n;
                noViewTimes[n2] = noViewTimes[n2] + t.millis();
            }
            int n3 = n++;
            noViewTimes[n3] = noViewTimes[n3] / (double)BenchmarkMatrixKernel.NITERS;
        }
        DComplexMatrix2D dComplexMatrix2D = new DenseDComplexMatrix2D(BenchmarkMatrixKernel.MATRIX_SIZE_2D[1], BenchmarkMatrixKernel.MATRIX_SIZE_2D[0]).viewDice().assign(a_2d);
        int n4 = 0;
        while (n4 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n4]);
            DoubleMatrix2D doubleMatrix2D = dComplexMatrix2D.getRealPart();
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                t.reset().start();
                doubleMatrix2D = dComplexMatrix2D.getRealPart();
                t.stop();
                int n5 = n4;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n4++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "getRealPart()";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testGetImaginaryPart() {
        DenseDComplexMatrix2D denseDComplexMatrix2D = new DenseDComplexMatrix2D(a_2d);
        int n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            DoubleMatrix2D doubleMatrix2D = ((DComplexMatrix2D)denseDComplexMatrix2D).getImaginaryPart();
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                t.reset().start();
                doubleMatrix2D = ((DComplexMatrix2D)denseDComplexMatrix2D).getImaginaryPart();
                t.stop();
                int n2 = n;
                noViewTimes[n2] = noViewTimes[n2] + t.millis();
            }
            int n3 = n++;
            noViewTimes[n3] = noViewTimes[n3] / (double)BenchmarkMatrixKernel.NITERS;
        }
        DComplexMatrix2D dComplexMatrix2D = new DenseDComplexMatrix2D(BenchmarkMatrixKernel.MATRIX_SIZE_2D[1], BenchmarkMatrixKernel.MATRIX_SIZE_2D[0]).viewDice().assign(a_2d);
        int n4 = 0;
        while (n4 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n4]);
            DoubleMatrix2D doubleMatrix2D = dComplexMatrix2D.getImaginaryPart();
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                t.reset().start();
                doubleMatrix2D = dComplexMatrix2D.getImaginaryPart();
                t.stop();
                int n5 = n4;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n4++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "getImaginaryPart()";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testGetNonZerosIntArrayListIntArrayListArrayList() {
        int n;
        DenseDComplexMatrix2D denseDComplexMatrix2D = new DenseDComplexMatrix2D(a_2d);
        IntArrayList intArrayList = new IntArrayList();
        IntArrayList intArrayList2 = new IntArrayList();
        ArrayList<double[]> arrayList = new ArrayList<double[]>();
        int n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            ((DComplexMatrix2D)denseDComplexMatrix2D).getNonZeros(intArrayList, intArrayList2, arrayList);
            for (n = 0; n < BenchmarkMatrixKernel.NITERS; ++n) {
                intArrayList.clear();
                intArrayList2.clear();
                arrayList.clear();
                t.reset().start();
                ((DComplexMatrix2D)denseDComplexMatrix2D).getNonZeros(intArrayList, intArrayList2, arrayList);
                t.stop();
                int n3 = n2;
                noViewTimes[n3] = noViewTimes[n3] + t.millis();
            }
            int n4 = n2++;
            noViewTimes[n4] = noViewTimes[n4] / (double)BenchmarkMatrixKernel.NITERS;
        }
        DComplexMatrix2D dComplexMatrix2D = new DenseDComplexMatrix2D(a_2d).viewDice();
        intArrayList.clear();
        intArrayList2.clear();
        arrayList.clear();
        n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            dComplexMatrix2D.getNonZeros(intArrayList, intArrayList2, arrayList);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                intArrayList.clear();
                intArrayList2.clear();
                arrayList.clear();
                t.reset().start();
                dComplexMatrix2D.getNonZeros(intArrayList, intArrayList2, arrayList);
                t.stop();
                int n5 = n;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "getNonZeros(IntArrayList, IntArrayList, ArrayList)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testIfft2() {
        int n;
        DenseDComplexMatrix2D denseDComplexMatrix2D = new DenseDComplexMatrix2D(a_2d);
        int n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            denseDComplexMatrix2D.ifft2(true);
            for (n = 0; n < BenchmarkMatrixKernel.NITERS; ++n) {
                denseDComplexMatrix2D.assign(a_2d);
                t.reset().start();
                denseDComplexMatrix2D.ifft2(true);
                t.stop();
                int n3 = n2;
                noViewTimes[n3] = noViewTimes[n3] + t.millis();
            }
            int n4 = n2++;
            noViewTimes[n4] = noViewTimes[n4] / (double)BenchmarkMatrixKernel.NITERS;
        }
        DComplexMatrix2D dComplexMatrix2D = new DenseDComplexMatrix2D(BenchmarkMatrixKernel.MATRIX_SIZE_2D[1], BenchmarkMatrixKernel.MATRIX_SIZE_2D[0]).viewDice().assign(a_2d);
        n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            ((DenseDComplexMatrix2D)dComplexMatrix2D).ifft2(true);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                dComplexMatrix2D.assign(a_2d);
                t.reset().start();
                ((DenseDComplexMatrix2D)dComplexMatrix2D).ifft2(true);
                t.stop();
                int n5 = n;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "ifft2(boolean)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testIfftColumns() {
        int n;
        DenseDComplexMatrix2D denseDComplexMatrix2D = new DenseDComplexMatrix2D(a_2d);
        int n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            denseDComplexMatrix2D.ifftColumns(true);
            for (n = 0; n < BenchmarkMatrixKernel.NITERS; ++n) {
                denseDComplexMatrix2D.assign(a_2d);
                t.reset().start();
                denseDComplexMatrix2D.ifftColumns(true);
                t.stop();
                int n3 = n2;
                noViewTimes[n3] = noViewTimes[n3] + t.millis();
            }
            int n4 = n2++;
            noViewTimes[n4] = noViewTimes[n4] / (double)BenchmarkMatrixKernel.NITERS;
        }
        DComplexMatrix2D dComplexMatrix2D = new DenseDComplexMatrix2D(BenchmarkMatrixKernel.MATRIX_SIZE_2D[1], BenchmarkMatrixKernel.MATRIX_SIZE_2D[0]).viewDice().assign(a_2d);
        n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            ((DenseDComplexMatrix2D)dComplexMatrix2D).ifftColumns(true);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                dComplexMatrix2D.assign(a_2d);
                t.reset().start();
                ((DenseDComplexMatrix2D)dComplexMatrix2D).ifftColumns(true);
                t.stop();
                int n5 = n;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "ifftColumns(boolean)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testIfftRows() {
        int n;
        DenseDComplexMatrix2D denseDComplexMatrix2D = new DenseDComplexMatrix2D(a_2d);
        int n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            denseDComplexMatrix2D.ifftRows(true);
            for (n = 0; n < BenchmarkMatrixKernel.NITERS; ++n) {
                denseDComplexMatrix2D.assign(a_2d);
                t.reset().start();
                denseDComplexMatrix2D.ifftRows(true);
                t.stop();
                int n3 = n2;
                noViewTimes[n3] = noViewTimes[n3] + t.millis();
            }
            int n4 = n2++;
            noViewTimes[n4] = noViewTimes[n4] / (double)BenchmarkMatrixKernel.NITERS;
        }
        DComplexMatrix2D dComplexMatrix2D = new DenseDComplexMatrix2D(BenchmarkMatrixKernel.MATRIX_SIZE_2D[1], BenchmarkMatrixKernel.MATRIX_SIZE_2D[0]).viewDice().assign(a_2d);
        n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            ((DenseDComplexMatrix2D)dComplexMatrix2D).ifftRows(true);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                dComplexMatrix2D.assign(a_2d);
                t.reset().start();
                ((DenseDComplexMatrix2D)dComplexMatrix2D).ifftRows(true);
                t.stop();
                int n5 = n;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "ifftRows(true)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testSum() {
        DenseDComplexMatrix2D denseDComplexMatrix2D = new DenseDComplexMatrix2D(a_2d);
        int n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            double[] dArray = ((DComplexMatrix2D)denseDComplexMatrix2D).zSum();
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                t.reset().start();
                dArray = ((DComplexMatrix2D)denseDComplexMatrix2D).zSum();
                t.stop();
                int n2 = n;
                noViewTimes[n2] = noViewTimes[n2] + t.millis();
            }
            int n3 = n++;
            noViewTimes[n3] = noViewTimes[n3] / (double)BenchmarkMatrixKernel.NITERS;
        }
        DComplexMatrix2D dComplexMatrix2D = new DenseDComplexMatrix2D(BenchmarkMatrixKernel.MATRIX_SIZE_2D[1], BenchmarkMatrixKernel.MATRIX_SIZE_2D[0]).viewDice().assign(a_2d);
        int n4 = 0;
        while (n4 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n4]);
            double[] dArray = dComplexMatrix2D.zSum();
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                t.reset().start();
                dArray = dComplexMatrix2D.zSum();
                t.stop();
                int n5 = n4;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n4++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "zSum()";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testToArray() {
        DenseDComplexMatrix2D denseDComplexMatrix2D = new DenseDComplexMatrix2D(a_2d);
        int n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            double[][] dArray = ((DComplexMatrix2D)denseDComplexMatrix2D).toArray();
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                t.reset().start();
                dArray = ((DComplexMatrix2D)denseDComplexMatrix2D).toArray();
                t.stop();
                int n2 = n;
                noViewTimes[n2] = noViewTimes[n2] + t.millis();
            }
            int n3 = n++;
            noViewTimes[n3] = noViewTimes[n3] / (double)BenchmarkMatrixKernel.NITERS;
        }
        DComplexMatrix2D dComplexMatrix2D = new DenseDComplexMatrix2D(BenchmarkMatrixKernel.MATRIX_SIZE_2D[1], BenchmarkMatrixKernel.MATRIX_SIZE_2D[0]).viewDice().assign(a_2d);
        int n4 = 0;
        while (n4 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n4]);
            double[][] dArray = dComplexMatrix2D.toArray();
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                t.reset().start();
                dArray = dComplexMatrix2D.toArray();
                t.stop();
                int n5 = n4;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n4++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "toArray()";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testVectorize() {
        DenseDComplexMatrix2D denseDComplexMatrix2D = new DenseDComplexMatrix2D(a_2d);
        int n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            DComplexMatrix1D dComplexMatrix1D = ((DComplexMatrix2D)denseDComplexMatrix2D).vectorize();
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                t.reset().start();
                dComplexMatrix1D = ((DComplexMatrix2D)denseDComplexMatrix2D).vectorize();
                t.stop();
                int n2 = n;
                noViewTimes[n2] = noViewTimes[n2] + t.millis();
            }
            int n3 = n++;
            noViewTimes[n3] = noViewTimes[n3] / (double)BenchmarkMatrixKernel.NITERS;
        }
        DComplexMatrix2D dComplexMatrix2D = new DenseDComplexMatrix2D(BenchmarkMatrixKernel.MATRIX_SIZE_2D[1], BenchmarkMatrixKernel.MATRIX_SIZE_2D[0]).viewDice().assign(a_2d);
        int n4 = 0;
        while (n4 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n4]);
            DComplexMatrix1D dComplexMatrix1D = dComplexMatrix2D.vectorize();
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                t.reset().start();
                dComplexMatrix1D = dComplexMatrix2D.vectorize();
                t.stop();
                int n5 = n4;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n4++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "vectorize()";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testZMultDComplexMatrix1DDComplexMatrix1DDoubleArrayDoubleArrayBoolean() {
        int n;
        DenseDComplexMatrix2D denseDComplexMatrix2D = new DenseDComplexMatrix2D(a_2d);
        DenseDComplexMatrix1D denseDComplexMatrix1D = new DenseDComplexMatrix1D(denseDComplexMatrix2D.columns());
        double[] dArray = new double[]{3.0, 4.0};
        double[] dArray2 = new double[]{5.0, 6.0};
        for (int i = 0; i < denseDComplexMatrix1D.size(); ++i) {
            denseDComplexMatrix1D.set(i, new double[]{Math.random(), Math.random()});
        }
        DenseDComplexMatrix1D denseDComplexMatrix1D2 = new DenseDComplexMatrix1D(denseDComplexMatrix2D.rows());
        int n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            ((DComplexMatrix2D)denseDComplexMatrix2D).zMult(denseDComplexMatrix1D, denseDComplexMatrix1D2, dArray, dArray2, false);
            for (n = 0; n < BenchmarkMatrixKernel.NITERS; ++n) {
                ((DComplexMatrix1D)denseDComplexMatrix1D2).assign(0.0, 0.0);
                t.reset().start();
                ((DComplexMatrix2D)denseDComplexMatrix2D).zMult(denseDComplexMatrix1D, denseDComplexMatrix1D2, dArray, dArray2, false);
                t.stop();
                int n3 = n2;
                noViewTimes[n3] = noViewTimes[n3] + t.millis();
            }
            int n4 = n2++;
            noViewTimes[n4] = noViewTimes[n4] / (double)BenchmarkMatrixKernel.NITERS;
        }
        DComplexMatrix2D dComplexMatrix2D = new DenseDComplexMatrix2D(BenchmarkMatrixKernel.MATRIX_SIZE_2D[1], BenchmarkMatrixKernel.MATRIX_SIZE_2D[0]).viewDice().assign(a_2d);
        n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            dComplexMatrix2D.zMult(denseDComplexMatrix1D, denseDComplexMatrix1D2, dArray, dArray2, false);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                ((DComplexMatrix1D)denseDComplexMatrix1D2).assign(0.0, 0.0);
                t.reset().start();
                dComplexMatrix2D.zMult(denseDComplexMatrix1D, denseDComplexMatrix1D2, dArray, dArray2, false);
                t.stop();
                int n5 = n;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "zMult(DComplexMatrix1D, DComplexMatrix1D, double[], double[], boolean)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testZMultDComplexMatrix2DDComplexMatrix2DDoubleArrayDoubleArrayBooleanBoolean() {
        int n = BenchmarkMatrixKernel.NITERS;
        BenchmarkMatrixKernel.NITERS = 10;
        DenseDComplexMatrix2D denseDComplexMatrix2D = new DenseDComplexMatrix2D(a_2d);
        DComplexMatrix2D dComplexMatrix2D = new DenseDComplexMatrix2D(b_2d);
        dComplexMatrix2D = dComplexMatrix2D.viewDice().copy();
        DenseDComplexMatrix2D denseDComplexMatrix2D2 = new DenseDComplexMatrix2D(BenchmarkMatrixKernel.MATRIX_SIZE_2D[0], BenchmarkMatrixKernel.MATRIX_SIZE_2D[0]);
        double[] dArray = new double[]{3.0, 4.0};
        double[] dArray2 = new double[]{5.0, 6.0};
        int n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            ((DComplexMatrix2D)denseDComplexMatrix2D).zMult(dComplexMatrix2D, denseDComplexMatrix2D2, dArray, dArray2, false, false);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                ((DComplexMatrix2D)denseDComplexMatrix2D2).assign(0.0, 0.0);
                t.reset().start();
                ((DComplexMatrix2D)denseDComplexMatrix2D).zMult(dComplexMatrix2D, denseDComplexMatrix2D2, dArray, dArray2, false, false);
                t.stop();
                int n3 = n2;
                noViewTimes[n3] = noViewTimes[n3] + t.millis();
            }
            int n4 = n2++;
            noViewTimes[n4] = noViewTimes[n4] / (double)BenchmarkMatrixKernel.NITERS;
        }
        denseDComplexMatrix2D = new DenseDComplexMatrix2D(a_2d);
        DComplexMatrix2D dComplexMatrix2D2 = denseDComplexMatrix2D.viewDice();
        dComplexMatrix2D = new DenseDComplexMatrix2D(b_2d);
        dComplexMatrix2D = dComplexMatrix2D.viewDice().copy();
        DComplexMatrix2D dComplexMatrix2D3 = dComplexMatrix2D.viewDice();
        denseDComplexMatrix2D2 = new DenseDComplexMatrix2D(BenchmarkMatrixKernel.MATRIX_SIZE_2D[1], BenchmarkMatrixKernel.MATRIX_SIZE_2D[1]);
        DComplexMatrix2D dComplexMatrix2D4 = denseDComplexMatrix2D2.viewDice();
        int n5 = 0;
        while (n5 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n5]);
            dComplexMatrix2D2.zMult(dComplexMatrix2D3, dComplexMatrix2D4, dArray, dArray2, false, false);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                dComplexMatrix2D4.assign(0.0, 0.0);
                t.reset().start();
                dComplexMatrix2D2.zMult(dComplexMatrix2D3, dComplexMatrix2D4, dArray, dArray2, false, false);
                t.stop();
                int n6 = n5;
                viewTimes[n6] = viewTimes[n6] + t.millis();
            }
            int n7 = n5++;
            viewTimes[n7] = viewTimes[n7] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "zMult(DComplexMatrix2D, DComplexMatrix2D, double[], double[], boolean, boolean)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.NITERS = n;
    }
}

