/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdcomplex;

import cern.colt.PersistentObject;
import cern.colt.matrix.tdcomplex.DComplexMatrix1D;
import cern.colt.matrix.tdcomplex.impl.DenseDComplexMatrix1D;
import cern.colt.matrix.tdcomplex.impl.SparseDComplexMatrix1D;
import cern.jet.math.tdcomplex.DComplexFunctions;
import cern.jet.random.tdouble.engine.DoubleMersenneTwister;
import cern.jet.random.tdouble.sampling.DoubleRandomSamplingAssistant;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DComplexFactory1D
extends PersistentObject {
    private static final long serialVersionUID = 438423343000681857L;
    public static final DComplexFactory1D dense = new DComplexFactory1D();
    public static final DComplexFactory1D sparse = new DComplexFactory1D();

    protected DComplexFactory1D() {
    }

    public DComplexMatrix1D append(DComplexMatrix1D dComplexMatrix1D, DComplexMatrix1D dComplexMatrix1D2) {
        DComplexMatrix1D dComplexMatrix1D3 = this.make(dComplexMatrix1D.size() + dComplexMatrix1D2.size());
        dComplexMatrix1D3.viewPart(0, dComplexMatrix1D.size()).assign(dComplexMatrix1D);
        dComplexMatrix1D3.viewPart(dComplexMatrix1D.size(), dComplexMatrix1D2.size()).assign(dComplexMatrix1D2);
        return dComplexMatrix1D3;
    }

    public DComplexMatrix1D make(double[] dArray) {
        if (this == sparse) {
            return new SparseDComplexMatrix1D(dArray);
        }
        return new DenseDComplexMatrix1D(dArray);
    }

    public DComplexMatrix1D make(DComplexMatrix1D[] dComplexMatrix1DArray) {
        if (dComplexMatrix1DArray.length == 0) {
            return this.make(0);
        }
        int n = 0;
        for (int i = 0; i < dComplexMatrix1DArray.length; ++i) {
            n += dComplexMatrix1DArray[i].size();
        }
        DComplexMatrix1D dComplexMatrix1D = this.make(n);
        n = 0;
        for (int i = 0; i < dComplexMatrix1DArray.length; ++i) {
            dComplexMatrix1D.viewPart(n, dComplexMatrix1DArray[i].size()).assign(dComplexMatrix1DArray[i]);
            n += dComplexMatrix1DArray[i].size();
        }
        return dComplexMatrix1D;
    }

    public DComplexMatrix1D make(int n) {
        if (this == sparse) {
            return new SparseDComplexMatrix1D(n);
        }
        return new DenseDComplexMatrix1D(n);
    }

    public DComplexMatrix1D make(int n, double[] dArray) {
        return this.make(n).assign(dArray);
    }

    public DComplexMatrix1D make(ArrayList<double[]> arrayList) {
        int n = arrayList.size();
        DComplexMatrix1D dComplexMatrix1D = this.make(n);
        for (int i = 0; i < n; ++i) {
            dComplexMatrix1D.set(i, arrayList.get(i));
        }
        return dComplexMatrix1D;
    }

    public DComplexMatrix1D random(int n) {
        return this.make(n).assign(DComplexFunctions.random());
    }

    public DComplexMatrix1D repeat(DComplexMatrix1D dComplexMatrix1D, int n) {
        int n2 = dComplexMatrix1D.size();
        DComplexMatrix1D dComplexMatrix1D2 = this.make(n * n2);
        for (int i = 0; i < n; ++i) {
            dComplexMatrix1D2.viewPart(n2 * i, n2).assign(dComplexMatrix1D);
        }
        return dComplexMatrix1D2;
    }

    public DComplexMatrix1D sample(int n, double[] dArray, double d) {
        double d2 = 1.0E-9;
        if (d < 0.0 - d2 || d > 1.0 + d2) {
            throw new IllegalArgumentException();
        }
        if (d < 0.0) {
            d = 0.0;
        }
        if (d > 1.0) {
            d = 1.0;
        }
        DComplexMatrix1D dComplexMatrix1D = this.make(n);
        int n2 = (int)Math.round((double)n * d);
        if (n2 == 0) {
            return dComplexMatrix1D;
        }
        DoubleRandomSamplingAssistant doubleRandomSamplingAssistant = new DoubleRandomSamplingAssistant(n2, n, new DoubleMersenneTwister());
        for (int i = 0; i < n; ++i) {
            if (!doubleRandomSamplingAssistant.sampleNextElement()) continue;
            dComplexMatrix1D.set(i, dArray);
        }
        return dComplexMatrix1D;
    }

    public ArrayList<double[]> toList(DComplexMatrix1D dComplexMatrix1D) {
        int n = dComplexMatrix1D.size();
        ArrayList<double[]> arrayList = new ArrayList<double[]>(n);
        for (int i = 0; i < n; ++i) {
            arrayList.set(i, dComplexMatrix1D.get(i));
        }
        return arrayList;
    }
}

