/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix;

import cern.colt.matrix.TimerProcedure;
import cern.colt.matrix.tobject.algo.ObjectFormatter;
import cern.colt.matrix.tobject.impl.DenseObjectMatrix2D;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Arrays;
import java.util.Date;

public class BenchmarkMatrixKernel {
    public static int MATRIX_SIZE_1D = (int)Math.pow(2.0, 19.0);
    public static int[] MATRIX_SIZE_2D = new int[]{(int)Math.pow(2.0, 10.0), (int)Math.pow(2.0, 10.0)};
    public static int[] MATRIX_SIZE_3D = new int[]{(int)Math.pow(2.0, 7.0), (int)Math.pow(2.0, 7.0), (int)Math.pow(2.0, 7.0)};
    public static int[] NTHREADS = new int[]{1, 2};
    public static int NITERS = 100;
    private static String settingsFileName1D = "settings1D.txt";
    private static String settingsFileName2D = "settings2D.txt";
    private static String settingsFileName3D = "settings3D.txt";

    private BenchmarkMatrixKernel() {
    }

    public static void readSettings1D() {
        File file = new File(settingsFileName1D = System.getProperty("settingsFile1D", settingsFileName1D));
        if (file.exists()) {
            try {
                RandomAccessFile randomAccessFile = null;
                randomAccessFile = new RandomAccessFile(settingsFileName1D, "r");
                String string = randomAccessFile.readLine();
                string = randomAccessFile.readLine();
                String[] stringArray = string.split(",");
                NTHREADS = new int[stringArray.length];
                for (int i = 0; i < stringArray.length; ++i) {
                    BenchmarkMatrixKernel.NTHREADS[i] = Integer.parseInt(stringArray[i].trim());
                }
                string = randomAccessFile.readLine();
                MATRIX_SIZE_1D = Integer.parseInt(string.trim());
                string = randomAccessFile.readLine();
                NITERS = Integer.parseInt(string.trim());
                randomAccessFile.close();
                System.out.println("Settings were loaded");
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        } else {
            System.out.println("Settings file not found. Default settings will be used.");
            System.out.println("NTHREADS = " + Arrays.toString(NTHREADS));
            System.out.println("MATRIX_SIZE = " + MATRIX_SIZE_1D);
            System.out.println("NITERS = " + NITERS);
        }
    }

    public static void readSettings2D() {
        File file = new File(settingsFileName2D = System.getProperty("settingsFile2D", settingsFileName2D));
        if (file.exists()) {
            try {
                RandomAccessFile randomAccessFile = null;
                randomAccessFile = new RandomAccessFile(settingsFileName2D, "r");
                String string = randomAccessFile.readLine();
                string = randomAccessFile.readLine();
                String[] stringArray = string.split(",");
                NTHREADS = new int[stringArray.length];
                for (int i = 0; i < stringArray.length; ++i) {
                    BenchmarkMatrixKernel.NTHREADS[i] = Integer.parseInt(stringArray[i].trim());
                }
                string = randomAccessFile.readLine();
                BenchmarkMatrixKernel.MATRIX_SIZE_2D[0] = Integer.parseInt(string.trim());
                string = randomAccessFile.readLine();
                BenchmarkMatrixKernel.MATRIX_SIZE_2D[1] = Integer.parseInt(string.trim());
                string = randomAccessFile.readLine();
                NITERS = Integer.parseInt(string.trim());
                randomAccessFile.close();
                System.out.println("Settings were loaded");
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        } else {
            System.out.println("Settings file not found. Default settings will be used.");
            System.out.println("NTHREADS = " + Arrays.toString(NTHREADS));
            System.out.println("MATRIX_SIZE = " + MATRIX_SIZE_2D[0] + " x " + MATRIX_SIZE_2D[1]);
            System.out.println("NITERS = " + NITERS);
        }
    }

    public static void readSettings3D() {
        File file = new File(settingsFileName3D = System.getProperty("settingsFile3D", settingsFileName3D));
        if (file.exists()) {
            try {
                RandomAccessFile randomAccessFile = null;
                randomAccessFile = new RandomAccessFile(settingsFileName3D, "r");
                String string = randomAccessFile.readLine();
                string = randomAccessFile.readLine();
                String[] stringArray = string.split(",");
                NTHREADS = new int[stringArray.length];
                for (int i = 0; i < stringArray.length; ++i) {
                    BenchmarkMatrixKernel.NTHREADS[i] = Integer.parseInt(stringArray[i].trim());
                }
                string = randomAccessFile.readLine();
                BenchmarkMatrixKernel.MATRIX_SIZE_3D[0] = Integer.parseInt(string.trim());
                string = randomAccessFile.readLine();
                BenchmarkMatrixKernel.MATRIX_SIZE_3D[1] = Integer.parseInt(string.trim());
                string = randomAccessFile.readLine();
                BenchmarkMatrixKernel.MATRIX_SIZE_3D[2] = Integer.parseInt(string.trim());
                string = randomAccessFile.readLine();
                NITERS = Integer.parseInt(string.trim());
                randomAccessFile.close();
                System.out.println("Settings were loaded");
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        } else {
            System.out.println("Settings file not found. Default settings will be used.");
            System.out.println("NTHREADS = " + Arrays.toString(NTHREADS));
            System.out.println("MATRIX_SIZE = " + MATRIX_SIZE_3D[0] + " x " + MATRIX_SIZE_3D[1] + " x " + MATRIX_SIZE_3D[2]);
            System.out.println("NITERS = " + NITERS);
        }
    }

    public static void writePropertiesToFile(String string, int[] nArray) {
        String[] stringArray = new String[]{"os.name", "os.version", "os.arch", "java.vendor", "java.version"};
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(string, false));
            bufferedWriter.write(new Date().toString());
            bufferedWriter.newLine();
            bufferedWriter.write("System properties:");
            bufferedWriter.newLine();
            bufferedWriter.write("\tos.name = " + System.getProperty(stringArray[0]));
            bufferedWriter.newLine();
            bufferedWriter.write("\tos.version = " + System.getProperty(stringArray[1]));
            bufferedWriter.newLine();
            bufferedWriter.write("\tos.arch = " + System.getProperty(stringArray[2]));
            bufferedWriter.newLine();
            bufferedWriter.write("\tjava.vendor = " + System.getProperty(stringArray[3]));
            bufferedWriter.newLine();
            bufferedWriter.write("\tjava.version = " + System.getProperty(stringArray[4]));
            bufferedWriter.newLine();
            bufferedWriter.write("\tavailable processors = " + Runtime.getRuntime().availableProcessors());
            bufferedWriter.newLine();
            switch (nArray.length) {
                case 1: {
                    bufferedWriter.write("Matrix size = " + nArray[0]);
                    break;
                }
                case 2: {
                    bufferedWriter.write("Matrix size = " + nArray[0] + " x " + nArray[1]);
                    break;
                }
                case 3: {
                    bufferedWriter.write("Matrix size = " + nArray[0] + " x " + nArray[1] + " x " + nArray[2]);
                }
            }
            bufferedWriter.newLine();
            bufferedWriter.write("--------------------------------------------------------------------------------------------------");
            bufferedWriter.newLine();
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static void writeMatrixBenchmarkResultsToFile(String string, String string2, int[] nArray, double[] dArray, double[] dArray2) {
        try {
            int n;
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(string, true));
            bufferedWriter.write("Method = " + string2);
            bufferedWriter.newLine();
            bufferedWriter.write("\tNo view execution times:");
            bufferedWriter.newLine();
            for (n = 0; n < nArray.length; ++n) {
                if (nArray[n] == 1) {
                    bufferedWriter.write("\t\t" + nArray[n] + " thread  = " + String.format("%.2f", dArray[n]) + " milliseconds");
                } else {
                    bufferedWriter.write("\t\t" + nArray[n] + " threads = " + String.format("%.2f", dArray[n]) + " milliseconds");
                }
                bufferedWriter.newLine();
            }
            bufferedWriter.write("\tView execution times:");
            bufferedWriter.newLine();
            for (n = 0; n < nArray.length; ++n) {
                if (nArray[n] == 1) {
                    bufferedWriter.write("\t\t" + nArray[n] + " thread  = " + String.format("%.2f", dArray2[n]) + " milliseconds");
                } else {
                    bufferedWriter.write("\t\t" + nArray[n] + " threads = " + String.format("%.2f", dArray2[n]) + " milliseconds");
                }
                bufferedWriter.newLine();
            }
            bufferedWriter.write("--------------------------------------------------------------------------------------------------");
            bufferedWriter.newLine();
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static void displayProperties(int[] nArray) {
        String[] stringArray = new String[]{"os.name", "os.version", "os.arch", "java.vendor", "java.version"};
        System.out.println(new Date().toString());
        System.out.println("System properties:");
        System.out.println("\tos.name = " + System.getProperty(stringArray[0]));
        System.out.println("\tos.version = " + System.getProperty(stringArray[1]));
        System.out.println("\tos.arch = " + System.getProperty(stringArray[2]));
        System.out.println("\tjava.vendor = " + System.getProperty(stringArray[3]));
        System.out.println("\tjava.version = " + System.getProperty(stringArray[4]));
        System.out.println("\tavailable processors = " + Runtime.getRuntime().availableProcessors());
        switch (nArray.length) {
            case 1: {
                System.out.println("Matrix size = " + nArray[0]);
                break;
            }
            case 2: {
                System.out.println("Matrix size = " + nArray[0] + " x " + nArray[1]);
                break;
            }
            case 3: {
                System.out.println("Matrix size = " + nArray[0] + " x " + nArray[1] + " x " + nArray[2]);
            }
        }
        System.out.println("--------------------------------------------------------------------------------------------------");
    }

    public static void displayMatrixBenchmarkResults(String string, int[] nArray, double[] dArray, double[] dArray2) {
        int n;
        System.out.println("Method = " + string);
        System.out.println("\tNo view execution times:");
        for (n = 0; n < nArray.length; ++n) {
            if (nArray[n] == 1) {
                System.out.println("\t\t" + nArray[n] + " thread  = " + String.format("%.2f", dArray[n]) + " milliseconds");
                continue;
            }
            System.out.println("\t\t" + nArray[n] + " threads = " + String.format("%.2f", dArray[n]) + " milliseconds");
        }
        System.out.println("\tView execution times:");
        for (n = 0; n < nArray.length; ++n) {
            if (nArray[n] == 1) {
                System.out.println("\t\t" + nArray[n] + " thread  = " + String.format("%.2f", dArray2[n]) + " milliseconds");
                continue;
            }
            System.out.println("\t\t" + nArray[n] + " threads = " + String.format("%.2f", dArray2[n]) + " milliseconds");
        }
        System.out.println("--------------------------------------------------------------------------------------------------");
    }

    public static float run(double d, TimerProcedure timerProcedure) {
        long l;
        long l2 = 0L;
        long l3 = (long)(d * 1000.0);
        long l4 = System.currentTimeMillis();
        long l5 = l4 + l3;
        while (System.currentTimeMillis() < l5) {
            timerProcedure.init();
            timerProcedure.apply(null);
            ++l2;
        }
        long l6 = System.currentTimeMillis();
        if (d / (double)l2 < 0.1) {
            l4 = System.currentTimeMillis();
            l = l2;
            while (--l >= 0L) {
                timerProcedure.init();
                timerProcedure.apply(null);
            }
            l6 = System.currentTimeMillis();
        }
        l = System.currentTimeMillis();
        int n = 1;
        long l7 = l2;
        while (--l7 >= 0L) {
            n = (int)((long)n * l7);
            timerProcedure.init();
        }
        l7 = System.currentTimeMillis();
        long l8 = l6 - l4 - (l7 - l);
        return (float)l8 / 1000.0f / (float)l2;
    }

    public static String systemInfo() {
        Object[] objectArray = new String[]{"java.vm.vendor", "java.vm.version", "java.vm.name", "os.name", "os.version", "os.arch", "java.version", "java.vendor", "java.vendor.url"};
        DenseObjectMatrix2D denseObjectMatrix2D = new DenseObjectMatrix2D(objectArray.length, 2);
        denseObjectMatrix2D.viewColumn(0).assign(objectArray);
        for (int i = 0; i < objectArray.length; ++i) {
            String string = System.getProperty((String)objectArray[i]);
            if (string == null) {
                string = "?";
            }
            denseObjectMatrix2D.set(i, 1, string);
        }
        ObjectFormatter objectFormatter = new ObjectFormatter();
        objectFormatter.setPrintShape(false);
        return objectFormatter.toString(denseObjectMatrix2D);
    }
}

