/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix;

import cern.colt.matrix.AbstractFormatter;
import cern.colt.matrix.AbstractMatrix;

public abstract class AbstractMatrix3D
extends AbstractMatrix {
    protected int slices;
    protected int rows;
    protected int columns;
    protected int sliceStride;
    protected int rowStride;
    protected int columnStride;
    protected int sliceZero;
    protected int rowZero;
    protected int columnZero;

    protected AbstractMatrix3D() {
    }

    protected int _columnOffset(int n) {
        return n;
    }

    protected int _columnRank(int n) {
        return this.columnZero + n * this.columnStride;
    }

    protected int _rowOffset(int n) {
        return n;
    }

    protected int _rowRank(int n) {
        return this.rowZero + n * this.rowStride;
    }

    protected int _sliceOffset(int n) {
        return n;
    }

    protected int _sliceRank(int n) {
        return this.sliceZero + n * this.sliceStride;
    }

    protected void checkBox(int n, int n2, int n3, int n4, int n5, int n6) {
        if (n < 0 || n4 < 0 || n + n4 > this.slices || n2 < 0 || n5 < 0 || n2 + n5 > this.rows || n3 < 0 || n6 < 0 || n3 + n6 > this.columns) {
            throw new IndexOutOfBoundsException(this.toStringShort() + ", slice:" + n + ", row:" + n2 + " ,column:" + n3 + ", depth:" + n4 + " ,height:" + n5 + ", width:" + n6);
        }
    }

    protected void checkColumn(int n) {
        if (n < 0 || n >= this.columns) {
            throw new IndexOutOfBoundsException("Attempted to access " + this.toStringShort() + " at column=" + n);
        }
    }

    protected void checkColumnIndexes(int[] nArray) {
        int n = nArray.length;
        while (--n >= 0) {
            int n2 = nArray[n];
            if (n2 >= 0 && n2 < this.columns) continue;
            this.checkColumn(n2);
        }
    }

    protected void checkRow(int n) {
        if (n < 0 || n >= this.rows) {
            throw new IndexOutOfBoundsException("Attempted to access " + this.toStringShort() + " at row=" + n);
        }
    }

    protected void checkRowIndexes(int[] nArray) {
        int n = nArray.length;
        while (--n >= 0) {
            int n2 = nArray[n];
            if (n2 >= 0 && n2 < this.rows) continue;
            this.checkRow(n2);
        }
    }

    public void checkShape(AbstractMatrix3D abstractMatrix3D) {
        if (this.slices != abstractMatrix3D.slices || this.rows != abstractMatrix3D.rows || this.columns != abstractMatrix3D.columns) {
            throw new IllegalArgumentException("Incompatible dimensions: " + this.toStringShort() + " and " + abstractMatrix3D.toStringShort());
        }
    }

    public void checkShape(AbstractMatrix3D abstractMatrix3D, AbstractMatrix3D abstractMatrix3D2) {
        if (this.slices != abstractMatrix3D.slices || this.rows != abstractMatrix3D.rows || this.columns != abstractMatrix3D.columns || this.slices != abstractMatrix3D2.slices || this.rows != abstractMatrix3D2.rows || this.columns != abstractMatrix3D2.columns) {
            throw new IllegalArgumentException("Incompatible dimensions: " + this.toStringShort() + ", " + abstractMatrix3D.toStringShort() + ", " + abstractMatrix3D2.toStringShort());
        }
    }

    protected void checkSlice(int n) {
        if (n < 0 || n >= this.slices) {
            throw new IndexOutOfBoundsException("Attempted to access " + this.toStringShort() + " at slice=" + n);
        }
    }

    protected void checkSliceIndexes(int[] nArray) {
        int n = nArray.length;
        while (--n >= 0) {
            int n2 = nArray[n];
            if (n2 >= 0 && n2 < this.slices) continue;
            this.checkSlice(n2);
        }
    }

    public int columns() {
        return this.columns;
    }

    public int columnStride() {
        return this.columnStride;
    }

    public long index(int n, int n2, int n3) {
        return this._sliceOffset(this._sliceRank(n)) + this._rowOffset(this._rowRank(n2)) + this._columnOffset(this._columnRank(n3));
    }

    public int rows() {
        return this.rows;
    }

    public int rowStride() {
        return this.rowStride;
    }

    protected void setUp(int n, int n2, int n3) {
        this.setUp(n, n2, n3, 0, 0, 0, n2 * n3, n3, 1);
    }

    protected void setUp(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        if (n < 0 || n2 < 0 || n3 < 0) {
            throw new IllegalArgumentException("negative size");
        }
        if ((double)n * (double)n2 * (double)n3 > 2.147483647E9) {
            throw new IllegalArgumentException("matrix too large");
        }
        this.slices = n;
        this.rows = n2;
        this.columns = n3;
        this.sliceZero = n4;
        this.rowZero = n5;
        this.columnZero = n6;
        this.sliceStride = n7;
        this.rowStride = n8;
        this.columnStride = n9;
        this.isNoView = true;
    }

    protected int[] shape() {
        int[] nArray = new int[]{this.slices, this.rows, this.columns};
        return nArray;
    }

    public int size() {
        return this.slices * this.rows * this.columns;
    }

    public int slices() {
        return this.slices;
    }

    public int sliceStride() {
        return this.sliceStride;
    }

    public String toStringShort() {
        return AbstractFormatter.shape(this);
    }

    protected AbstractMatrix3D vColumnFlip() {
        if (this.columns > 0) {
            this.columnZero += (this.columns - 1) * this.columnStride;
            this.columnStride = -this.columnStride;
            this.isNoView = false;
        }
        return this;
    }

    protected AbstractMatrix3D vDice(int n, int n2, int n3) {
        int n4 = 3;
        if (n < 0 || n >= n4 || n2 < 0 || n2 >= n4 || n3 < 0 || n3 >= n4 || n == n2 || n == n3 || n2 == n3) {
            throw new IllegalArgumentException("Illegal Axes: " + n + ", " + n2 + ", " + n3);
        }
        int[] nArray = this.shape();
        this.slices = nArray[n];
        this.rows = nArray[n2];
        this.columns = nArray[n3];
        int[] nArray2 = new int[]{this.sliceStride, this.rowStride, this.columnStride};
        this.sliceStride = nArray2[n];
        this.rowStride = nArray2[n2];
        this.columnStride = nArray2[n3];
        this.isNoView = false;
        return this;
    }

    protected AbstractMatrix3D vPart(int n, int n2, int n3, int n4, int n5, int n6) {
        this.checkBox(n, n2, n3, n4, n5, n6);
        this.sliceZero += this.sliceStride * n;
        this.rowZero += this.rowStride * n2;
        this.columnZero += this.columnStride * n3;
        this.slices = n4;
        this.rows = n5;
        this.columns = n6;
        this.isNoView = false;
        return this;
    }

    protected AbstractMatrix3D vRowFlip() {
        if (this.rows > 0) {
            this.rowZero += (this.rows - 1) * this.rowStride;
            this.rowStride = -this.rowStride;
            this.isNoView = false;
        }
        return this;
    }

    protected AbstractMatrix3D vSliceFlip() {
        if (this.slices > 0) {
            this.sliceZero += (this.slices - 1) * this.sliceStride;
            this.sliceStride = -this.sliceStride;
            this.isNoView = false;
        }
        return this;
    }

    protected AbstractMatrix3D vStrides(int n, int n2, int n3) {
        if (n <= 0 || n2 <= 0 || n3 <= 0) {
            throw new IndexOutOfBoundsException("illegal strides: " + n + ", " + n2 + ", " + n3);
        }
        this.sliceStride *= n;
        this.rowStride *= n2;
        this.columnStride *= n3;
        if (this.slices != 0) {
            this.slices = (this.slices - 1) / n + 1;
        }
        if (this.rows != 0) {
            this.rows = (this.rows - 1) / n2 + 1;
        }
        if (this.columns != 0) {
            this.columns = (this.columns - 1) / n3 + 1;
        }
        this.isNoView = false;
        return this;
    }
}

