/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.map.tfloat;

import cern.colt.function.tfloat.FloatFunction;
import cern.colt.function.tfloat.LongFloatProcedure;
import cern.colt.function.tlong.LongProcedure;
import cern.colt.list.tbyte.ByteArrayList;
import cern.colt.list.tfloat.FloatArrayList;
import cern.colt.list.tlong.LongArrayList;
import cern.colt.map.HashFunctions;
import cern.colt.map.tfloat.AbstractLongFloatMap;
import cern.jet.math.tfloat.FloatMult;

public class OpenLongFloatHashMap
extends AbstractLongFloatMap {
    protected long[] table;
    protected float[] values;
    protected byte[] state;
    protected int freeEntries;
    protected static final byte FREE = 0;
    protected static final byte FULL = 1;
    protected static final byte REMOVED = 2;

    public OpenLongFloatHashMap() {
        this(277);
    }

    public OpenLongFloatHashMap(int n) {
        this(n, 0.2f, 0.5f);
    }

    public OpenLongFloatHashMap(int n, float f, float f2) {
        this.setUp(n, f, f2);
    }

    public void assign(FloatFunction floatFunction) {
        if (floatFunction instanceof FloatMult) {
            float f = ((FloatMult)floatFunction).multiplicator;
            if (f == 1.0f) {
                return;
            }
            if (f == 0.0f) {
                this.clear();
                return;
            }
            int n = this.table.length;
            while (n-- > 0) {
                if (this.state[n] != 1) continue;
                int n2 = n;
                this.values[n2] = this.values[n2] * f;
            }
        } else {
            int n = this.table.length;
            while (n-- > 0) {
                if (this.state[n] != 1) continue;
                this.values[n] = floatFunction.apply(this.values[n]);
            }
        }
    }

    public void assign(AbstractLongFloatMap abstractLongFloatMap) {
        if (!(abstractLongFloatMap instanceof OpenLongFloatHashMap)) {
            super.assign(abstractLongFloatMap);
            return;
        }
        OpenLongFloatHashMap openLongFloatHashMap = (OpenLongFloatHashMap)abstractLongFloatMap;
        OpenLongFloatHashMap openLongFloatHashMap2 = (OpenLongFloatHashMap)openLongFloatHashMap.copy();
        this.values = openLongFloatHashMap2.values;
        this.table = openLongFloatHashMap2.table;
        this.state = openLongFloatHashMap2.state;
        this.freeEntries = openLongFloatHashMap2.freeEntries;
        this.distinct = openLongFloatHashMap2.distinct;
        this.lowWaterMark = openLongFloatHashMap2.lowWaterMark;
        this.highWaterMark = openLongFloatHashMap2.highWaterMark;
        this.minLoadFactor = openLongFloatHashMap2.minLoadFactor;
        this.maxLoadFactor = openLongFloatHashMap2.maxLoadFactor;
    }

    public void clear() {
        new ByteArrayList(this.state).fillFromToWith(0, this.state.length - 1, (byte)0);
        this.distinct = 0;
        this.freeEntries = this.table.length;
        this.trimToSize();
    }

    public Object clone() {
        OpenLongFloatHashMap openLongFloatHashMap = (OpenLongFloatHashMap)super.clone();
        openLongFloatHashMap.table = (long[])openLongFloatHashMap.table.clone();
        openLongFloatHashMap.values = (float[])openLongFloatHashMap.values.clone();
        openLongFloatHashMap.state = (byte[])openLongFloatHashMap.state.clone();
        return openLongFloatHashMap;
    }

    public boolean containsKey(long l) {
        return this.indexOfKey(l) >= 0;
    }

    public boolean containsValue(float f) {
        return this.indexOfValue(f) >= 0;
    }

    public void ensureCapacity(int n) {
        if (this.table.length < n) {
            int n2 = this.nextPrime(n);
            this.rehash(n2);
        }
    }

    public boolean forEachKey(LongProcedure longProcedure) {
        int n = this.table.length;
        while (n-- > 0) {
            if (this.state[n] != 1 || longProcedure.apply(this.table[n])) continue;
            return false;
        }
        return true;
    }

    public boolean forEachPair(LongFloatProcedure longFloatProcedure) {
        int n = this.table.length;
        while (n-- > 0) {
            if (this.state[n] != 1 || longFloatProcedure.apply(this.table[n], this.values[n])) continue;
            return false;
        }
        return true;
    }

    public float get(long l) {
        int n = this.indexOfKey(l);
        if (n < 0) {
            return 0.0f;
        }
        return this.values[n];
    }

    protected int indexOfInsertion(long l) {
        long[] lArray = this.table;
        byte[] byArray = this.state;
        int n = lArray.length;
        int n2 = HashFunctions.hash(l) & Integer.MAX_VALUE;
        int n3 = n2 % n;
        int n4 = n2 % (n - 2);
        if (n4 == 0) {
            n4 = 1;
        }
        while (byArray[n3] == 1 && lArray[n3] != l) {
            if ((n3 -= n4) >= 0) continue;
            n3 += n;
        }
        if (byArray[n3] == 2) {
            int n5 = n3;
            while (byArray[n3] != 0 && (byArray[n3] == 2 || lArray[n3] != l)) {
                if ((n3 -= n4) >= 0) continue;
                n3 += n;
            }
            if (byArray[n3] == 0) {
                n3 = n5;
            }
        }
        if (byArray[n3] == 1) {
            return -n3 - 1;
        }
        return n3;
    }

    protected int indexOfKey(long l) {
        long[] lArray = this.table;
        byte[] byArray = this.state;
        int n = lArray.length;
        int n2 = HashFunctions.hash(l) & Integer.MAX_VALUE;
        int n3 = n2 % n;
        int n4 = n2 % (n - 2);
        if (n4 == 0) {
            n4 = 1;
        }
        while (byArray[n3] != 0 && (byArray[n3] == 2 || lArray[n3] != l)) {
            if ((n3 -= n4) >= 0) continue;
            n3 += n;
        }
        if (byArray[n3] == 0) {
            return -1;
        }
        return n3;
    }

    protected int indexOfValue(float f) {
        float[] fArray = this.values;
        byte[] byArray = this.state;
        int n = byArray.length;
        while (--n >= 0) {
            if (byArray[n] != 1 || fArray[n] != f) continue;
            return n;
        }
        return -1;
    }

    public long keyOf(float f) {
        int n = this.indexOfValue(f);
        if (n < 0) {
            return Long.MIN_VALUE;
        }
        return this.table[n];
    }

    public void keys(LongArrayList longArrayList) {
        longArrayList.setSize(this.distinct);
        long[] lArray = longArrayList.elements();
        long[] lArray2 = this.table;
        byte[] byArray = this.state;
        int n = 0;
        int n2 = lArray2.length;
        while (n2-- > 0) {
            if (byArray[n2] != 1) continue;
            lArray[n++] = lArray2[n2];
        }
    }

    public void pairsMatching(LongFloatProcedure longFloatProcedure, LongArrayList longArrayList, FloatArrayList floatArrayList) {
        longArrayList.clear();
        floatArrayList.clear();
        int n = this.table.length;
        while (n-- > 0) {
            if (this.state[n] != 1 || !longFloatProcedure.apply(this.table[n], this.values[n])) continue;
            longArrayList.add(this.table[n]);
            floatArrayList.add(this.values[n]);
        }
    }

    public boolean put(long l, float f) {
        int n = this.indexOfInsertion(l);
        if (n < 0) {
            n = -n - 1;
            this.values[n] = f;
            return false;
        }
        if (this.distinct > this.highWaterMark) {
            int n2 = this.chooseGrowCapacity(this.distinct + 1, this.minLoadFactor, this.maxLoadFactor);
            this.rehash(n2);
            return this.put(l, f);
        }
        this.table[n] = l;
        this.values[n] = f;
        if (this.state[n] == 0) {
            --this.freeEntries;
        }
        this.state[n] = 1;
        ++this.distinct;
        if (this.freeEntries < 1) {
            int n3 = this.chooseGrowCapacity(this.distinct + 1, this.minLoadFactor, this.maxLoadFactor);
            this.rehash(n3);
        }
        return true;
    }

    protected void rehash(int n) {
        int n2 = this.table.length;
        if (n <= this.distinct) {
            throw new InternalError();
        }
        long[] lArray = this.table;
        float[] fArray = this.values;
        byte[] byArray = this.state;
        long[] lArray2 = new long[n];
        float[] fArray2 = new float[n];
        byte[] byArray2 = new byte[n];
        this.lowWaterMark = this.chooseLowWaterMark(n, this.minLoadFactor);
        this.highWaterMark = this.chooseHighWaterMark(n, this.maxLoadFactor);
        this.table = lArray2;
        this.values = fArray2;
        this.state = byArray2;
        this.freeEntries = n - this.distinct;
        int n3 = n2;
        while (n3-- > 0) {
            if (byArray[n3] != 1) continue;
            long l = lArray[n3];
            int n4 = this.indexOfInsertion(l);
            lArray2[n4] = l;
            fArray2[n4] = fArray[n3];
            byArray2[n4] = 1;
        }
    }

    public boolean removeKey(long l) {
        int n = this.indexOfKey(l);
        if (n < 0) {
            return false;
        }
        this.state[n] = 2;
        --this.distinct;
        if (this.distinct < this.lowWaterMark) {
            int n2 = this.chooseShrinkCapacity(this.distinct, this.minLoadFactor, this.maxLoadFactor);
            this.rehash(n2);
        }
        return true;
    }

    protected void setUp(int n, float f, float f2) {
        int n2 = n;
        super.setUp(n2, f, f2);
        n2 = this.nextPrime(n2);
        if (n2 == 0) {
            n2 = 1;
        }
        this.table = new long[n2];
        this.values = new float[n2];
        this.state = new byte[n2];
        this.minLoadFactor = f;
        this.maxLoadFactor = n2 == Integer.MAX_VALUE ? 1.0f : f2;
        this.distinct = 0;
        this.freeEntries = n2;
        this.lowWaterMark = 0;
        this.highWaterMark = this.chooseHighWaterMark(n2, this.maxLoadFactor);
    }

    public void trimToSize() {
        int n = this.nextPrime((int)(1.0 + 1.2 * (double)this.size()));
        if (this.table.length > n) {
            this.rehash(n);
        }
    }

    public void values(FloatArrayList floatArrayList) {
        floatArrayList.setSize(this.distinct);
        float[] fArray = floatArrayList.elements();
        float[] fArray2 = this.values;
        byte[] byArray = this.state;
        int n = 0;
        int n2 = byArray.length;
        while (n2-- > 0) {
            if (byArray[n2] != 1) continue;
            fArray[n++] = fArray2[n2];
        }
    }
}

