/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.map.tfloat;

import cern.colt.function.tfloat.FloatFunction;
import cern.colt.function.tfloat.IntFloatProcedure;
import cern.colt.function.tint.IntProcedure;
import cern.colt.list.tbyte.ByteArrayList;
import cern.colt.list.tfloat.FloatArrayList;
import cern.colt.list.tint.IntArrayList;
import cern.colt.map.HashFunctions;
import cern.colt.map.tfloat.AbstractIntFloatMap;
import cern.jet.math.tfloat.FloatMult;

public class OpenIntFloatHashMap
extends AbstractIntFloatMap {
    protected int[] table;
    protected float[] values;
    protected byte[] state;
    protected int freeEntries;
    protected static final byte FREE = 0;
    protected static final byte FULL = 1;
    protected static final byte REMOVED = 2;

    public OpenIntFloatHashMap() {
        this(277);
    }

    public OpenIntFloatHashMap(int n) {
        this(n, 0.2f, 0.5f);
    }

    public OpenIntFloatHashMap(int n, float f, float f2) {
        this.setUp(n, f, f2);
    }

    public void assign(FloatFunction floatFunction) {
        if (floatFunction instanceof FloatMult) {
            float f = ((FloatMult)floatFunction).multiplicator;
            if (f == 1.0f) {
                return;
            }
            if (f == 0.0f) {
                this.clear();
                return;
            }
            int n = this.table.length;
            while (n-- > 0) {
                if (this.state[n] != 1) continue;
                int n2 = n;
                this.values[n2] = this.values[n2] * f;
            }
        } else {
            int n = this.table.length;
            while (n-- > 0) {
                if (this.state[n] != 1) continue;
                this.values[n] = floatFunction.apply(this.values[n]);
            }
        }
    }

    public void assign(AbstractIntFloatMap abstractIntFloatMap) {
        if (!(abstractIntFloatMap instanceof OpenIntFloatHashMap)) {
            super.assign(abstractIntFloatMap);
            return;
        }
        OpenIntFloatHashMap openIntFloatHashMap = (OpenIntFloatHashMap)abstractIntFloatMap;
        OpenIntFloatHashMap openIntFloatHashMap2 = (OpenIntFloatHashMap)openIntFloatHashMap.copy();
        this.values = openIntFloatHashMap2.values;
        this.table = openIntFloatHashMap2.table;
        this.state = openIntFloatHashMap2.state;
        this.freeEntries = openIntFloatHashMap2.freeEntries;
        this.distinct = openIntFloatHashMap2.distinct;
        this.lowWaterMark = openIntFloatHashMap2.lowWaterMark;
        this.highWaterMark = openIntFloatHashMap2.highWaterMark;
        this.minLoadFactor = openIntFloatHashMap2.minLoadFactor;
        this.maxLoadFactor = openIntFloatHashMap2.maxLoadFactor;
    }

    public void clear() {
        new ByteArrayList(this.state).fillFromToWith(0, this.state.length - 1, (byte)0);
        this.distinct = 0;
        this.freeEntries = this.table.length;
        this.trimToSize();
    }

    public Object clone() {
        OpenIntFloatHashMap openIntFloatHashMap = (OpenIntFloatHashMap)super.clone();
        openIntFloatHashMap.table = (int[])openIntFloatHashMap.table.clone();
        openIntFloatHashMap.values = (float[])openIntFloatHashMap.values.clone();
        openIntFloatHashMap.state = (byte[])openIntFloatHashMap.state.clone();
        return openIntFloatHashMap;
    }

    public boolean containsKey(int n) {
        return this.indexOfKey(n) >= 0;
    }

    public boolean containsValue(float f) {
        return this.indexOfValue(f) >= 0;
    }

    public void ensureCapacity(int n) {
        if (this.table.length < n) {
            int n2 = this.nextPrime(n);
            this.rehash(n2);
        }
    }

    public boolean forEachKey(IntProcedure intProcedure) {
        int n = this.table.length;
        while (n-- > 0) {
            if (this.state[n] != 1 || intProcedure.apply(this.table[n])) continue;
            return false;
        }
        return true;
    }

    public boolean forEachPair(IntFloatProcedure intFloatProcedure) {
        int n = this.table.length;
        while (n-- > 0) {
            if (this.state[n] != 1 || intFloatProcedure.apply(this.table[n], this.values[n])) continue;
            return false;
        }
        return true;
    }

    public float get(int n) {
        int n2 = this.indexOfKey(n);
        if (n2 < 0) {
            return 0.0f;
        }
        return this.values[n2];
    }

    protected int indexOfInsertion(int n) {
        int[] nArray = this.table;
        byte[] byArray = this.state;
        int n2 = nArray.length;
        int n3 = HashFunctions.hash(n) & Integer.MAX_VALUE;
        int n4 = n3 % n2;
        int n5 = n3 % (n2 - 2);
        if (n5 == 0) {
            n5 = 1;
        }
        while (byArray[n4] == 1 && nArray[n4] != n) {
            if ((n4 -= n5) >= 0) continue;
            n4 += n2;
        }
        if (byArray[n4] == 2) {
            int n6 = n4;
            while (byArray[n4] != 0 && (byArray[n4] == 2 || nArray[n4] != n)) {
                if ((n4 -= n5) >= 0) continue;
                n4 += n2;
            }
            if (byArray[n4] == 0) {
                n4 = n6;
            }
        }
        if (byArray[n4] == 1) {
            return -n4 - 1;
        }
        return n4;
    }

    protected int indexOfKey(int n) {
        int[] nArray = this.table;
        byte[] byArray = this.state;
        int n2 = nArray.length;
        int n3 = HashFunctions.hash(n) & Integer.MAX_VALUE;
        int n4 = n3 % n2;
        int n5 = n3 % (n2 - 2);
        if (n5 == 0) {
            n5 = 1;
        }
        while (byArray[n4] != 0 && (byArray[n4] == 2 || nArray[n4] != n)) {
            if ((n4 -= n5) >= 0) continue;
            n4 += n2;
        }
        if (byArray[n4] == 0) {
            return -1;
        }
        return n4;
    }

    protected int indexOfValue(float f) {
        float[] fArray = this.values;
        byte[] byArray = this.state;
        int n = byArray.length;
        while (--n >= 0) {
            if (byArray[n] != 1 || fArray[n] != f) continue;
            return n;
        }
        return -1;
    }

    public int keyOf(float f) {
        int n = this.indexOfValue(f);
        if (n < 0) {
            return Integer.MIN_VALUE;
        }
        return this.table[n];
    }

    public void keys(IntArrayList intArrayList) {
        intArrayList.setSize(this.distinct);
        int[] nArray = intArrayList.elements();
        int[] nArray2 = this.table;
        byte[] byArray = this.state;
        int n = 0;
        int n2 = nArray2.length;
        while (n2-- > 0) {
            if (byArray[n2] != 1) continue;
            nArray[n++] = nArray2[n2];
        }
    }

    public void pairsMatching(IntFloatProcedure intFloatProcedure, IntArrayList intArrayList, FloatArrayList floatArrayList) {
        intArrayList.clear();
        floatArrayList.clear();
        int n = this.table.length;
        while (n-- > 0) {
            if (this.state[n] != 1 || !intFloatProcedure.apply(this.table[n], this.values[n])) continue;
            intArrayList.add(this.table[n]);
            floatArrayList.add(this.values[n]);
        }
    }

    public boolean put(int n, float f) {
        int n2 = this.indexOfInsertion(n);
        if (n2 < 0) {
            n2 = -n2 - 1;
            this.values[n2] = f;
            return false;
        }
        if (this.distinct > this.highWaterMark) {
            int n3 = this.chooseGrowCapacity(this.distinct + 1, this.minLoadFactor, this.maxLoadFactor);
            this.rehash(n3);
            return this.put(n, f);
        }
        this.table[n2] = n;
        this.values[n2] = f;
        if (this.state[n2] == 0) {
            --this.freeEntries;
        }
        this.state[n2] = 1;
        ++this.distinct;
        if (this.freeEntries < 1) {
            int n4 = this.chooseGrowCapacity(this.distinct + 1, this.minLoadFactor, this.maxLoadFactor);
            this.rehash(n4);
        }
        return true;
    }

    protected void rehash(int n) {
        int n2 = this.table.length;
        if (n <= this.distinct) {
            throw new InternalError();
        }
        int[] nArray = this.table;
        float[] fArray = this.values;
        byte[] byArray = this.state;
        int[] nArray2 = new int[n];
        float[] fArray2 = new float[n];
        byte[] byArray2 = new byte[n];
        this.lowWaterMark = this.chooseLowWaterMark(n, this.minLoadFactor);
        this.highWaterMark = this.chooseHighWaterMark(n, this.maxLoadFactor);
        this.table = nArray2;
        this.values = fArray2;
        this.state = byArray2;
        this.freeEntries = n - this.distinct;
        int n3 = n2;
        while (n3-- > 0) {
            if (byArray[n3] != 1) continue;
            int n4 = nArray[n3];
            int n5 = this.indexOfInsertion(n4);
            nArray2[n5] = n4;
            fArray2[n5] = fArray[n3];
            byArray2[n5] = 1;
        }
    }

    public boolean removeKey(int n) {
        int n2 = this.indexOfKey(n);
        if (n2 < 0) {
            return false;
        }
        this.state[n2] = 2;
        --this.distinct;
        if (this.distinct < this.lowWaterMark) {
            int n3 = this.chooseShrinkCapacity(this.distinct, this.minLoadFactor, this.maxLoadFactor);
            this.rehash(n3);
        }
        return true;
    }

    protected void setUp(int n, float f, float f2) {
        int n2 = n;
        super.setUp(n2, f, f2);
        n2 = this.nextPrime(n2);
        if (n2 == 0) {
            n2 = 1;
        }
        this.table = new int[n2];
        this.values = new float[n2];
        this.state = new byte[n2];
        this.minLoadFactor = f;
        this.maxLoadFactor = n2 == Integer.MAX_VALUE ? 1.0f : f2;
        this.distinct = 0;
        this.freeEntries = n2;
        this.lowWaterMark = 0;
        this.highWaterMark = this.chooseHighWaterMark(n2, this.maxLoadFactor);
    }

    public void trimToSize() {
        int n = this.nextPrime((int)(1.0 + 1.2 * (double)this.size()));
        if (this.table.length > n) {
            this.rehash(n);
        }
    }

    public void values(FloatArrayList floatArrayList) {
        floatArrayList.setSize(this.distinct);
        float[] fArray = floatArrayList.elements();
        float[] fArray2 = this.values;
        byte[] byArray = this.state;
        int n = 0;
        int n2 = byArray.length;
        while (n2-- > 0) {
            if (byArray[n2] != 1) continue;
            fArray[n++] = fArray2[n2];
        }
    }
}

