/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.map.tfloat;

import cern.colt.GenericSorting;
import cern.colt.Swapper;
import cern.colt.function.tfloat.FloatIntProcedure;
import cern.colt.function.tfloat.FloatProcedure;
import cern.colt.function.tint.IntComparator;
import cern.colt.list.tfloat.FloatArrayList;
import cern.colt.list.tint.IntArrayList;
import cern.colt.map.tfloat.AbstractFloatMap;

public abstract class AbstractFloatIntMap
extends AbstractFloatMap {
    protected AbstractFloatIntMap() {
    }

    public boolean containsKey(final float f) {
        return !this.forEachKey(new FloatProcedure(){

            public boolean apply(float f2) {
                return f != f2;
            }
        });
    }

    public boolean containsValue(final int n) {
        return !this.forEachPair(new FloatIntProcedure(){

            public boolean apply(float f, int n2) {
                return n != n2;
            }
        });
    }

    public AbstractFloatIntMap copy() {
        return (AbstractFloatIntMap)this.clone();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof AbstractFloatIntMap)) {
            return false;
        }
        final AbstractFloatIntMap abstractFloatIntMap = (AbstractFloatIntMap)object;
        if (abstractFloatIntMap.size() != this.size()) {
            return false;
        }
        return this.forEachPair(new FloatIntProcedure(){

            public boolean apply(float f, int n) {
                return abstractFloatIntMap.containsKey(f) && abstractFloatIntMap.get(f) == n;
            }
        }) && abstractFloatIntMap.forEachPair(new FloatIntProcedure(){

            public boolean apply(float f, int n) {
                return AbstractFloatIntMap.this.containsKey(f) && AbstractFloatIntMap.this.get(f) == n;
            }
        });
    }

    public abstract boolean forEachKey(FloatProcedure var1);

    public boolean forEachPair(final FloatIntProcedure floatIntProcedure) {
        return this.forEachKey(new FloatProcedure(){

            public boolean apply(float f) {
                return floatIntProcedure.apply(f, AbstractFloatIntMap.this.get(f));
            }
        });
    }

    public abstract int get(float var1);

    public float keyOf(final int n) {
        final float[] fArray = new float[1];
        boolean bl = this.forEachPair(new FloatIntProcedure(){

            public boolean apply(float f, int n2) {
                boolean bl;
                boolean bl2 = bl = n == n2;
                if (bl) {
                    fArray[0] = f;
                }
                return !bl;
            }
        });
        if (bl) {
            return Float.NaN;
        }
        return fArray[0];
    }

    public FloatArrayList keys() {
        FloatArrayList floatArrayList = new FloatArrayList(this.size());
        this.keys(floatArrayList);
        return floatArrayList;
    }

    public void keys(final FloatArrayList floatArrayList) {
        floatArrayList.clear();
        this.forEachKey(new FloatProcedure(){

            public boolean apply(float f) {
                floatArrayList.add(f);
                return true;
            }
        });
    }

    public void keysSortedByValue(FloatArrayList floatArrayList) {
        this.pairsSortedByValue(floatArrayList, new IntArrayList(this.size()));
    }

    public void pairsMatching(final FloatIntProcedure floatIntProcedure, final FloatArrayList floatArrayList, final IntArrayList intArrayList) {
        floatArrayList.clear();
        intArrayList.clear();
        this.forEachPair(new FloatIntProcedure(){

            public boolean apply(float f, int n) {
                if (floatIntProcedure.apply(f, n)) {
                    floatArrayList.add(f);
                    intArrayList.add(n);
                }
                return true;
            }
        });
    }

    public void pairsSortedByKey(FloatArrayList floatArrayList, IntArrayList intArrayList) {
        this.keys(floatArrayList);
        floatArrayList.sort();
        intArrayList.setSize(floatArrayList.size());
        int n = floatArrayList.size();
        while (--n >= 0) {
            intArrayList.setQuick(n, this.get(floatArrayList.getQuick(n)));
        }
    }

    public void pairsSortedByValue(FloatArrayList floatArrayList, IntArrayList intArrayList) {
        this.keys(floatArrayList);
        this.values(intArrayList);
        final float[] fArray = floatArrayList.elements();
        final int[] nArray = intArrayList.elements();
        Swapper swapper = new Swapper(){

            public void swap(int n, int n2) {
                int n3 = nArray[n];
                nArray[n] = nArray[n2];
                nArray[n2] = n3;
                float f = fArray[n];
                fArray[n] = fArray[n2];
                fArray[n2] = f;
            }
        };
        IntComparator intComparator = new IntComparator(){

            public int compare(int n, int n2) {
                return nArray[n] < nArray[n2] ? -1 : (nArray[n] > nArray[n2] ? 1 : (fArray[n] < fArray[n2] ? -1 : (fArray[n] == fArray[n2] ? 0 : 1)));
            }
        };
        GenericSorting.quickSort(0, floatArrayList.size(), intComparator, swapper);
    }

    public abstract boolean put(float var1, int var2);

    public abstract boolean removeKey(float var1);

    public String toString() {
        FloatArrayList floatArrayList = this.keys();
        floatArrayList.sort();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        int n = floatArrayList.size() - 1;
        for (int i = 0; i <= n; ++i) {
            float f = floatArrayList.get(i);
            stringBuffer.append(String.valueOf(f));
            stringBuffer.append("->");
            stringBuffer.append(String.valueOf(this.get(f)));
            if (i >= n) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public String toStringByValue() {
        FloatArrayList floatArrayList = new FloatArrayList();
        this.keysSortedByValue(floatArrayList);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        int n = floatArrayList.size() - 1;
        for (int i = 0; i <= n; ++i) {
            float f = floatArrayList.get(i);
            stringBuffer.append(String.valueOf(f));
            stringBuffer.append("->");
            stringBuffer.append(String.valueOf(this.get(f)));
            if (i >= n) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public IntArrayList values() {
        IntArrayList intArrayList = new IntArrayList(this.size());
        this.values(intArrayList);
        return intArrayList;
    }

    public void values(final IntArrayList intArrayList) {
        intArrayList.clear();
        this.forEachKey(new FloatProcedure(){

            public boolean apply(float f) {
                intArrayList.add(AbstractFloatIntMap.this.get(f));
                return true;
            }
        });
    }
}

