/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.map;

import cern.colt.Timer;
import cern.colt.map.PrimeFinder;
import cern.colt.map.tint.AbstractIntIntMap;
import cern.colt.map.tint.OpenIntIntHashMap;
import cern.colt.map.tint.QuickOpenIntIntHashMap;
import cern.jet.random.tdouble.DoubleUniform;
import cern.jet.random.tdouble.engine.DoubleMersenneTwister;

public class BenchmarkMap {
    protected BenchmarkMap() {
    }

    public static void benchmark(int n, int n2, String string) {
        System.out.println("initializing...");
        QuickOpenIntIntHashMap quickOpenIntIntHashMap = new QuickOpenIntIntHashMap();
        for (int i = 0; i < n2; ++i) {
            quickOpenIntIntHashMap.put(i, i);
        }
        Runtime.getRuntime().gc();
        try {
            Thread.currentThread();
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        System.out.println("Now benchmarking...");
        int n3 = 0;
        Timer timer = new Timer();
        Timer timer2 = new Timer();
        Timer timer3 = new Timer();
        int n4 = n;
        while (--n4 >= 0) {
            int n5;
            if (string.equals("add")) {
                quickOpenIntIntHashMap.clear();
                timer.start();
                n5 = n2;
                while (--n5 >= 0) {
                    quickOpenIntIntHashMap.put(n5, n5);
                }
                timer.stop();
            }
            if (string.equals("get")) {
                timer.start();
                n5 = n2;
                while (--n5 >= 0) {
                    n3 += quickOpenIntIntHashMap.get(n5);
                }
                timer.stop();
                continue;
            }
            timer2.start();
            quickOpenIntIntHashMap.rehash(PrimeFinder.nextPrime(n2 * 2));
            timer2.stop();
            timer3.start();
            quickOpenIntIntHashMap.rehash(PrimeFinder.nextPrime((int)((double)n2 * 1.5)));
            timer3.stop();
        }
        System.out.println("adding: " + timer);
        System.out.println("growing: " + timer2);
        System.out.println("shrinking: " + timer3);
        System.out.println("total: " + timer2.plus(timer3));
        System.out.print(n3);
    }

    public static void main(String[] stringArray) {
        int n = Integer.parseInt(stringArray[0]);
        int n2 = Integer.parseInt(stringArray[1]);
        String string = stringArray[2];
        BenchmarkMap.benchmark(n, n2, string);
    }

    public static void test2(int n) {
        int n2;
        DoubleUniform doubleUniform = new DoubleUniform(new DoubleMersenneTwister());
        int[] nArray = new int[n];
        int n3 = 10000000;
        for (int i = 0; i < n; ++i) {
            nArray[i] = doubleUniform.nextIntFromTo(0, n3);
        }
        int[] nArray2 = (int[])nArray.clone();
        int n4 = nArray.length;
        OpenIntIntHashMap openIntIntHashMap = new OpenIntIntHashMap();
        for (n2 = 0; n2 < nArray.length; ++n2) {
            ((AbstractIntIntMap)openIntIntHashMap).put(nArray[n2], nArray2[n2]);
        }
        n2 = 0;
        for (int i = 0; i < nArray.length; ++i) {
            n2 += ((AbstractIntIntMap)openIntIntHashMap).get(nArray[i]);
        }
        System.out.println(openIntIntHashMap);
        System.out.println(n2);
        System.out.println("\n\n");
    }
}

