/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.list.tobject;

import cern.colt.Arrays;
import cern.colt.Sorting;
import cern.colt.function.tobject.ObjectProcedure;
import cern.colt.list.AbstractList;
import cern.jet.random.tdouble.DoubleUniform;
import cern.jet.random.tdouble.engine.DRand;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;

public class ObjectArrayList
extends AbstractList {
    protected Object[] elements;
    protected int size;

    public ObjectArrayList() {
        this(10);
    }

    public ObjectArrayList(Object[] objectArray) {
        this.elements(objectArray);
    }

    public ObjectArrayList(int n) {
        this(new Object[n]);
        this.size = 0;
    }

    public void add(Object object) {
        if (this.size == this.elements.length) {
            this.ensureCapacity(this.size + 1);
        }
        this.elements[this.size++] = object;
    }

    public void addAllOfFromTo(ObjectArrayList objectArrayList, int n, int n2) {
        this.beforeInsertAllOfFromTo(this.size, objectArrayList, n, n2);
    }

    public void beforeInsert(int n, Object object) {
        if (n > this.size || n < 0) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + this.size);
        }
        this.ensureCapacity(this.size + 1);
        System.arraycopy(this.elements, n, this.elements, n + 1, this.size - n);
        this.elements[n] = object;
        ++this.size;
    }

    public void beforeInsertAllOfFromTo(int n, ObjectArrayList objectArrayList, int n2, int n3) {
        int n4 = n3 - n2 + 1;
        this.beforeInsertDummies(n, n4);
        this.replaceFromToWithFrom(n, n + n4 - 1, objectArrayList, n2);
    }

    protected void beforeInsertDummies(int n, int n2) {
        if (n > this.size || n < 0) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + this.size);
        }
        if (n2 > 0) {
            this.ensureCapacity(this.size + n2);
            System.arraycopy(this.elements, n, this.elements, n + n2, this.size - n);
            this.size += n2;
        }
    }

    public int binarySearch(Object object) {
        return this.binarySearchFromTo(object, 0, this.size - 1);
    }

    public int binarySearchFromTo(Object object, int n, int n2) {
        int n3 = n;
        int n4 = n2;
        while (n3 <= n4) {
            int n5 = (n3 + n4) / 2;
            Object object2 = this.elements[n5];
            int n6 = ((Comparable)object2).compareTo(object);
            if (n6 < 0) {
                n3 = n5 + 1;
                continue;
            }
            if (n6 > 0) {
                n4 = n5 - 1;
                continue;
            }
            return n5;
        }
        return -(n3 + 1);
    }

    public int binarySearchFromTo(Object object, int n, int n2, Comparator comparator) {
        return Sorting.binarySearchFromTo(this.elements, object, n, n2, comparator);
    }

    public Object clone() {
        ObjectArrayList objectArrayList = (ObjectArrayList)super.clone();
        objectArrayList.elements = (Object[])this.elements.clone();
        return objectArrayList;
    }

    public boolean contains(Object object, boolean bl) {
        return this.indexOfFromTo(object, 0, this.size - 1, bl) >= 0;
    }

    public ObjectArrayList copy() {
        return (ObjectArrayList)this.clone();
    }

    public void delete(Object object, boolean bl) {
        int n = this.indexOfFromTo(object, 0, this.size - 1, bl);
        if (n >= 0) {
            this.removeFromTo(n, n);
        }
    }

    public Object[] elements() {
        return this.elements;
    }

    public ObjectArrayList elements(Object[] objectArray) {
        this.elements = objectArray;
        this.size = objectArray.length;
        return this;
    }

    public void ensureCapacity(int n) {
        this.elements = Arrays.ensureCapacity(this.elements, n);
    }

    public boolean equals(Object object) {
        return this.equals(object, true);
    }

    public boolean equals(Object object, boolean bl) {
        if (!(object instanceof ObjectArrayList)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        ObjectArrayList objectArrayList = (ObjectArrayList)object;
        if (this.elements == objectArrayList.elements()) {
            return true;
        }
        if (this.size != objectArrayList.size()) {
            return false;
        }
        Object[] objectArray = objectArrayList.elements();
        Object[] objectArray2 = this.elements;
        if (!bl) {
            int n = this.size;
            while (--n >= 0) {
                if (objectArray2[n] == objectArray[n]) continue;
                return false;
            }
        } else {
            int n = this.size;
            while (--n >= 0) {
                if (objectArray2[n] != null ? objectArray2[n].equals(objectArray[n]) : objectArray[n] == null) continue;
                return false;
            }
        }
        return true;
    }

    public void fillFromToWith(int n, int n2, Object object) {
        ObjectArrayList.checkRangeFromTo(n, n2, this.size);
        int n3 = n;
        while (n3 <= n2) {
            this.setQuick(n3++, object);
        }
    }

    public boolean forEach(ObjectProcedure objectProcedure) {
        Object[] objectArray = this.elements;
        int n = this.size;
        int n2 = 0;
        while (n2 < n) {
            if (objectProcedure.apply(objectArray[n2++])) continue;
            return false;
        }
        return true;
    }

    public Object get(int n) {
        if (n >= this.size || n < 0) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + this.size);
        }
        return this.elements[n];
    }

    public Object getQuick(int n) {
        return this.elements[n];
    }

    public int indexOf(Object object, boolean bl) {
        return this.indexOfFromTo(object, 0, this.size - 1, bl);
    }

    public int indexOfFromTo(Object object, int n, int n2, boolean bl) {
        if (this.size == 0) {
            return -1;
        }
        ObjectArrayList.checkRangeFromTo(n, n2, this.size);
        Object[] objectArray = this.elements;
        if (bl && object != null) {
            for (int i = n; i <= n2; ++i) {
                if (!object.equals(objectArray[i])) continue;
                return i;
            }
        } else {
            for (int i = n; i <= n2; ++i) {
                if (object != objectArray[i]) continue;
                return i;
            }
        }
        return -1;
    }

    public boolean isSortedFromTo(int n, int n2) {
        if (this.size == 0) {
            return true;
        }
        ObjectArrayList.checkRangeFromTo(n, n2, this.size);
        Object[] objectArray = this.elements;
        for (int i = n + 1; i <= n2; ++i) {
            if (((Comparable)objectArray[i]).compareTo((Comparable)objectArray[i - 1]) >= 0) continue;
            return false;
        }
        return true;
    }

    public int lastIndexOf(Object object, boolean bl) {
        return this.lastIndexOfFromTo(object, 0, this.size - 1, bl);
    }

    public int lastIndexOfFromTo(Object object, int n, int n2, boolean bl) {
        if (this.size == 0) {
            return -1;
        }
        ObjectArrayList.checkRangeFromTo(n, n2, this.size);
        Object[] objectArray = this.elements;
        if (bl && object != null) {
            for (int i = n2; i >= n; --i) {
                if (!object.equals(objectArray[i])) continue;
                return i;
            }
        } else {
            for (int i = n2; i >= n; --i) {
                if (object != objectArray[i]) continue;
                return i;
            }
        }
        return -1;
    }

    public void mergeSortFromTo(int n, int n2) {
        if (this.size == 0) {
            return;
        }
        ObjectArrayList.checkRangeFromTo(n, n2, this.size);
        java.util.Arrays.sort(this.elements, n, n2 + 1);
    }

    public void mergeSortFromTo(int n, int n2, Comparator comparator) {
        if (this.size == 0) {
            return;
        }
        ObjectArrayList.checkRangeFromTo(n, n2, this.size);
        java.util.Arrays.sort(this.elements, n, n2 + 1, comparator);
    }

    public ObjectArrayList partFromTo(int n, int n2) {
        if (this.size == 0) {
            return new ObjectArrayList(0);
        }
        ObjectArrayList.checkRangeFromTo(n, n2, this.size);
        Object[] objectArray = new Object[n2 - n + 1];
        System.arraycopy(this.elements, n, objectArray, 0, n2 - n + 1);
        return new ObjectArrayList(objectArray);
    }

    public void quickSortFromTo(int n, int n2) {
        if (this.size == 0) {
            return;
        }
        ObjectArrayList.checkRangeFromTo(n, n2, this.size);
        Sorting.quickSort(this.elements, n, n2 + 1);
    }

    public void quickSortFromTo(int n, int n2, Comparator comparator) {
        if (this.size == 0) {
            return;
        }
        ObjectArrayList.checkRangeFromTo(n, n2, this.size);
        Sorting.quickSort(this.elements, n, n2 + 1, comparator);
    }

    public boolean removeAll(ObjectArrayList objectArrayList, boolean bl) {
        int n;
        if (objectArrayList.size == 0) {
            return false;
        }
        int n2 = objectArrayList.size - 1;
        int n3 = 0;
        Object[] objectArray = this.elements;
        for (n = 0; n < this.size; ++n) {
            if (objectArrayList.indexOfFromTo(objectArray[n], 0, n2, bl) >= 0) continue;
            objectArray[n3++] = objectArray[n];
        }
        n = n3 != this.size ? 1 : 0;
        this.setSize(n3);
        return n != 0;
    }

    public void removeFromTo(int n, int n2) {
        int n3;
        ObjectArrayList.checkRangeFromTo(n, n2, this.size);
        int n4 = this.size - n2 - 1;
        if (n4 >= 0) {
            System.arraycopy(this.elements, n2 + 1, this.elements, n, n4);
            this.fillFromToWith(n + n4, this.size - 1, null);
        }
        if ((n3 = n2 - n + 1) > 0) {
            this.size -= n3;
        }
    }

    public void replaceFromToWithFrom(int n, int n2, ObjectArrayList objectArrayList, int n3) {
        int n4 = n2 - n + 1;
        if (n4 > 0) {
            ObjectArrayList.checkRangeFromTo(n, n2, this.size);
            ObjectArrayList.checkRangeFromTo(n3, n3 + n4 - 1, objectArrayList.size);
            System.arraycopy(objectArrayList.elements, n3, this.elements, n, n4);
        }
    }

    public void replaceFromToWithFromTo(int n, int n2, ObjectArrayList objectArrayList, int n3, int n4) {
        int n5;
        if (n3 > n4) {
            throw new IndexOutOfBoundsException("otherFrom: " + n3 + ", otherTo: " + n4);
        }
        if (this == objectArrayList && n2 - n != n4 - n3) {
            this.replaceFromToWithFromTo(n, n2, this.partFromTo(n3, n4), 0, n4 - n3);
            return;
        }
        int n6 = n5 = n4 - n3 + 1;
        int n7 = n - 1;
        if (n2 >= n) {
            n6 -= n2 - n + 1;
            n7 = n2;
        }
        if (n6 > 0) {
            this.beforeInsertDummies(n7 + 1, n6);
        } else if (n6 < 0) {
            this.removeFromTo(n7 + n6, n7 - 1);
        }
        if (n5 > 0) {
            System.arraycopy(objectArrayList.elements, n3, this.elements, n, n5);
        }
    }

    public void replaceFromWith(int n, Collection collection) {
        ObjectArrayList.checkRange(n, this.size);
        Iterator iterator = collection.iterator();
        int n2 = n;
        int n3 = Math.min(this.size - n, collection.size());
        for (int i = 0; i < n3; ++i) {
            this.elements[n2++] = iterator.next();
        }
    }

    public boolean retainAll(ObjectArrayList objectArrayList, boolean bl) {
        int n;
        if (objectArrayList.size == 0) {
            if (this.size == 0) {
                return false;
            }
            this.setSize(0);
            return true;
        }
        int n2 = objectArrayList.size - 1;
        int n3 = 0;
        Object[] objectArray = this.elements;
        for (n = 0; n < this.size; ++n) {
            if (objectArrayList.indexOfFromTo(objectArray[n], 0, n2, bl) < 0) continue;
            objectArray[n3++] = objectArray[n];
        }
        n = n3 != this.size ? 1 : 0;
        this.setSize(n3);
        return n != 0;
    }

    public void reverse() {
        int n = this.size / 2;
        int n2 = this.size - 1;
        Object[] objectArray = this.elements;
        int n3 = 0;
        while (n3 < n) {
            Object object = objectArray[n3];
            objectArray[n3++] = objectArray[n2];
            objectArray[n2--] = object;
        }
    }

    public void set(int n, Object object) {
        if (n >= this.size || n < 0) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + this.size);
        }
        this.elements[n] = object;
    }

    public void setQuick(int n, Object object) {
        this.elements[n] = object;
    }

    public void shuffleFromTo(int n, int n2) {
        if (this.size == 0) {
            return;
        }
        ObjectArrayList.checkRangeFromTo(n, n2, this.size);
        DoubleUniform doubleUniform = new DoubleUniform(new DRand(new Date()));
        Object[] objectArray = this.elements;
        for (int i = n; i < n2; ++i) {
            int n3 = doubleUniform.nextIntFromTo(i, n2);
            Object object = objectArray[n3];
            objectArray[n3] = objectArray[i];
            objectArray[i] = object;
        }
    }

    public int size() {
        return this.size;
    }

    public ObjectArrayList times(int n) {
        ObjectArrayList objectArrayList = new ObjectArrayList(n * this.size);
        int n2 = n;
        while (--n2 >= 0) {
            objectArrayList.addAllOfFromTo(this, 0, this.size() - 1);
        }
        return objectArrayList;
    }

    public Object[] toArray(Object[] objectArray) {
        if (objectArray.length < this.size) {
            objectArray = (Object[])Array.newInstance(objectArray.getClass().getComponentType(), this.size);
        }
        Object[] objectArray2 = this.elements;
        int n = this.size;
        while (--n >= 0) {
            objectArray[n] = objectArray2[n];
        }
        if (objectArray.length > this.size) {
            objectArray[this.size] = null;
        }
        return objectArray;
    }

    public ArrayList toList() {
        int n = this.size();
        Object[] objectArray = this.elements;
        ArrayList<Object> arrayList = new ArrayList<Object>(n);
        for (int i = 0; i < n; ++i) {
            arrayList.add(objectArray[i]);
        }
        return arrayList;
    }

    public String toString() {
        return Arrays.toString(this.partFromTo(0, this.size() - 1).elements());
    }

    public void trimToSize() {
        this.elements = Arrays.trimToCapacity(this.elements, this.size());
    }
}

