/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.buffer.tobject;

import cern.colt.PersistentObject;
import cern.colt.buffer.tobject.ObjectBufferConsumer;
import cern.colt.list.tobject.ObjectArrayList;

public class ObjectBuffer
extends PersistentObject
implements ObjectBufferConsumer {
    protected ObjectBufferConsumer target;
    protected Object[] elements;
    protected ObjectArrayList list;
    protected int capacity;
    protected int size;

    public ObjectBuffer(ObjectBufferConsumer objectBufferConsumer, int n) {
        this.target = objectBufferConsumer;
        this.capacity = n;
        this.elements = new Object[n];
        this.list = new ObjectArrayList(this.elements);
        this.size = 0;
    }

    public void add(Object object) {
        if (this.size == this.capacity) {
            this.flush();
        }
        this.elements[this.size++] = object;
    }

    public void addAllOf(ObjectArrayList objectArrayList) {
        int n = objectArrayList.size();
        if (this.size + n >= this.capacity) {
            this.flush();
        }
        this.target.addAllOf(objectArrayList);
    }

    public void clear() {
        this.size = 0;
    }

    public void flush() {
        if (this.size > 0) {
            this.list.setSize(this.size);
            this.target.addAllOf(this.list);
            this.size = 0;
        }
    }
}

