/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.buffer.tdouble;

import cern.colt.PersistentObject;
import cern.colt.buffer.tdouble.DoubleBuffer2DConsumer;
import cern.colt.list.tdouble.DoubleArrayList;

public class DoubleBuffer2D
extends PersistentObject
implements DoubleBuffer2DConsumer {
    protected DoubleBuffer2DConsumer target;
    protected double[] xElements;
    protected double[] yElements;
    protected DoubleArrayList xList;
    protected DoubleArrayList yList;
    protected int capacity;
    protected int size;

    public DoubleBuffer2D(DoubleBuffer2DConsumer doubleBuffer2DConsumer, int n) {
        this.target = doubleBuffer2DConsumer;
        this.capacity = n;
        this.xElements = new double[n];
        this.yElements = new double[n];
        this.xList = new DoubleArrayList(this.xElements);
        this.yList = new DoubleArrayList(this.yElements);
        this.size = 0;
    }

    public void add(double d, double d2) {
        if (this.size == this.capacity) {
            this.flush();
        }
        this.xElements[this.size] = d;
        this.yElements[this.size++] = d2;
    }

    public void addAllOf(DoubleArrayList doubleArrayList, DoubleArrayList doubleArrayList2) {
        int n = doubleArrayList.size();
        if (this.size + n >= this.capacity) {
            this.flush();
        }
        this.target.addAllOf(doubleArrayList, doubleArrayList2);
    }

    public void clear() {
        this.size = 0;
    }

    public void flush() {
        if (this.size > 0) {
            this.xList.setSize(this.size);
            this.yList.setSize(this.size);
            this.target.addAllOf(this.xList, this.yList);
            this.size = 0;
        }
    }
}

