/*
 * Decompiled with CFR 0.152.
 */
package com.sun.opengl.impl.x11.glx;

import com.sun.gluegen.runtime.ProcAddressTable;
import com.sun.opengl.impl.GLContextImpl;
import com.sun.opengl.impl.GLContextShareSet;
import com.sun.opengl.impl.GLDrawableFactoryImpl;
import com.sun.opengl.impl.x11.glx.GLX;
import com.sun.opengl.impl.x11.glx.GLXExt;
import com.sun.opengl.impl.x11.glx.GLXExtImpl;
import com.sun.opengl.impl.x11.glx.GLXExtProcAddressTable;
import com.sun.opengl.impl.x11.glx.GLXUtil;
import com.sun.opengl.impl.x11.glx.X11GLXDrawable;
import com.sun.opengl.impl.x11.glx.X11GLXGraphicsConfiguration;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLDrawable;
import javax.media.opengl.GLException;

public abstract class X11GLXContext
extends GLContextImpl {
    protected X11GLXDrawable drawable;
    protected long context;
    private boolean glXQueryExtensionsStringInitialized;
    private boolean glXQueryExtensionsStringAvailable;
    private static final Map functionNameMap = new HashMap();
    private GLXExt glXExt;
    private GLXExtProcAddressTable glXExtProcAddressTable;
    private int hasSwapIntervalSGI = 0;
    private boolean isVendorATI = false;

    public X11GLXContext(X11GLXDrawable x11GLXDrawable, GLContext gLContext) {
        super(x11GLXDrawable.getGLProfile(), gLContext);
        this.drawable = x11GLXDrawable;
    }

    public final ProcAddressTable getPlatformExtProcAddressTable() {
        return this.getGLXExtProcAddressTable();
    }

    public final GLXExtProcAddressTable getGLXExtProcAddressTable() {
        return this.glXExtProcAddressTable;
    }

    public Object getPlatformGLExtensions() {
        return this.getGLXExt();
    }

    public GLXExt getGLXExt() {
        if (this.glXExt == null) {
            this.glXExt = new GLXExtImpl(this);
        }
        return this.glXExt;
    }

    public GLDrawable getGLDrawable() {
        return this.drawable;
    }

    protected String mapToRealGLFunctionName(String string) {
        String string2 = (String)functionNameMap.get(string);
        if (string2 != null) {
            return string2;
        }
        return string;
    }

    protected String mapToRealGLExtensionName(String string) {
        return string;
    }

    protected abstract void create();

    protected void createContext(boolean bl) {
        X11GLXGraphicsConfiguration x11GLXGraphicsConfiguration = (X11GLXGraphicsConfiguration)this.drawable.getNativeWindow().getGraphicsConfiguration().getNativeGraphicsConfiguration();
        if (DEBUG) {
            System.err.println("X11GLXContext.createContext got " + x11GLXGraphicsConfiguration);
        }
        long l = x11GLXGraphicsConfiguration.getScreen().getDevice().getHandle();
        X11GLXContext x11GLXContext = (X11GLXContext)GLContextShareSet.getShareContext(this);
        long l2 = 0L;
        if (x11GLXContext != null) {
            l2 = x11GLXContext.getContext();
            if (l2 == 0L) {
                throw new GLException("GLContextShareSet returned an invalid OpenGL context");
            }
            bl = GLX.glXIsDirect(l, l2);
        }
        GLCapabilities gLCapabilities = (GLCapabilities)x11GLXGraphicsConfiguration.getChosenCapabilities();
        this.isVendorATI = GLXUtil.isVendorATI(l);
        if (x11GLXGraphicsConfiguration.getFBConfigID() < 0) {
            if (gLCapabilities.getGLProfile().isGL3()) {
                throw new GLException("Unable to create OpenGL >= 3.1 context");
            }
            this.context = GLX.glXCreateContext(l, x11GLXGraphicsConfiguration.getXVisualInfo(), l2, bl);
            if (this.context == 0L) {
                throw new GLException("Unable to create OpenGL context");
            }
            if (!GLX.glXMakeContextCurrent(l, this.drawable.getNativeWindow().getSurfaceHandle(), this.drawable.getNativeWindow().getSurfaceHandle(), this.context)) {
                throw new GLException("Error making temp context (old2) current: display 0x" + Long.toHexString(l) + ", context 0x" + Long.toHexString(this.context) + ", drawable " + this.drawable);
            }
            this.setGLFunctionAvailability(true);
            if (DEBUG) {
                System.err.println("X11GLXContext.createContext done (old2 ctx) 0x" + Long.toHexString(this.context));
            }
        } else {
            long l3 = GLX.glXCreateNewContext(l, x11GLXGraphicsConfiguration.getFBConfig(), 32788, l2, bl);
            if (l3 == 0L) {
                throw new GLException("Unable to create temp OpenGL context");
            }
            if (!GLX.glXMakeContextCurrent(l, this.drawable.getNativeWindow().getSurfaceHandle(), this.drawable.getNativeWindow().getSurfaceHandle(), l3)) {
                throw new GLException("Error making temp context (old) current: display 0x" + Long.toHexString(l) + ", context 0x" + Long.toHexString(this.context) + ", drawable " + this.drawable);
            }
            this.setGLFunctionAvailability(true);
            if (!this.isFunctionAvailable("glXCreateContextAttribsARB") || !this.isExtensionAvailable("GLX_ARB_create_context")) {
                if (gLCapabilities.getGLProfile().isGL3()) {
                    GLX.glXMakeContextCurrent(l, 0L, 0L, 0L);
                    GLX.glXDestroyContext(l, l3);
                    throw new GLException("Unable to create OpenGL >= 3.1 context (no GLX_ARB_create_context)");
                }
                this.context = l3;
                if (DEBUG) {
                    System.err.println("X11GLXContext.createContext done (old ctx < 3.0 - no GLX_ARB_create_context) 0x" + Long.toHexString(this.context));
                }
            } else {
                GLXExt gLXExt = this.getGLXExt();
                int[] nArray = new int[]{8337, 3, 8338, 0, 32785, 32788, 8340, 0, 0, 0, 0};
                if (gLCapabilities.getGLProfile().isGL3()) {
                    nArray[1] = 3;
                    nArray[3] = 2;
                    this.context = gLXExt.glXCreateContextAttribsARB(l, x11GLXGraphicsConfiguration.getFBConfig(), l2, bl, nArray, 0);
                    if (0L != this.context) {
                        if (!GLX.glXMakeContextCurrent(l, this.drawable.getNativeWindow().getSurfaceHandle(), this.drawable.getNativeWindow().getSurfaceHandle(), this.context)) {
                            if (DEBUG) {
                                System.err.println("X11GLXContext.createContext couldn't make >= 3.2 core context current - fallback");
                            }
                            GLX.glXMakeContextCurrent(l, 0L, 0L, 0L);
                            GLX.glXDestroyContext(l, this.context);
                            this.context = 0L;
                        } else if (DEBUG) {
                            System.err.println("X11GLXContext.createContext >= 3.2 available 0x" + Long.toHexString(this.context));
                        }
                    } else if (DEBUG) {
                        System.err.println("X11GLXContext.createContext couldn't create >= 3.2 core context - fallback");
                    }
                    if (0L == this.context) {
                        nArray[1] = 3;
                        nArray[3] = 1;
                        nArray[7] = nArray[7] | 2;
                        nArray[8] = 0;
                        nArray[9] = 0;
                    }
                }
                if (0L == this.context) {
                    this.context = gLXExt.glXCreateContextAttribsARB(l, x11GLXGraphicsConfiguration.getFBConfig(), l2, bl, nArray, 0);
                    if (0L != this.context) {
                        if (!GLX.glXMakeContextCurrent(l, this.drawable.getNativeWindow().getSurfaceHandle(), this.drawable.getNativeWindow().getSurfaceHandle(), this.context)) {
                            if (DEBUG) {
                                System.err.println("X11GLXContext.createContext couldn't make >= 3.0 core context current - fallback");
                            }
                            GLX.glXMakeContextCurrent(l, 0L, 0L, 0L);
                            GLX.glXDestroyContext(l, this.context);
                            this.context = 0L;
                        } else if (DEBUG) {
                            System.err.println("X11GLXContext.createContext >= 3.0 available 0x" + Long.toHexString(this.context));
                        }
                    } else if (DEBUG) {
                        System.err.println("X11GLXContext.createContext couldn't create >= 3.0 core context - fallback");
                    }
                }
                if (0L == this.context) {
                    if (gLCapabilities.getGLProfile().isGL3()) {
                        GLX.glXMakeContextCurrent(l, 0L, 0L, 0L);
                        GLX.glXDestroyContext(l, l3);
                        throw new GLException("Unable to create OpenGL >= 3.1 context (have GLX_ARB_create_context)");
                    }
                    this.context = l3;
                    if (!GLX.glXMakeContextCurrent(l, this.drawable.getNativeWindow().getSurfaceHandle(), this.drawable.getNativeWindow().getSurfaceHandle(), this.context)) {
                        GLX.glXMakeContextCurrent(l, 0L, 0L, 0L);
                        GLX.glXDestroyContext(l, l3);
                        throw new GLException("Error making context (old) current: display 0x" + Long.toHexString(l) + ", context 0x" + Long.toHexString(this.context) + ", drawable " + this.drawable);
                    }
                    if (DEBUG) {
                        System.err.println("X11GLXContext.createContext done (old ctx < 3.0 - no 3.0) 0x" + Long.toHexString(this.context));
                    }
                } else {
                    GLX.glXDestroyContext(l, l3);
                    this.updateGLProcAddressTable();
                    if (DEBUG) {
                        System.err.println("X11GLXContext.createContext done (new ctx >= 3.0) 0x" + Long.toHexString(this.context));
                    }
                }
            }
        }
        GLContextShareSet.contextCreated(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int makeCurrentImpl() throws GLException {
        this.getDrawableImpl().getFactoryImpl().lockToolkit();
        try {
            if (this.drawable.getNativeWindow().getSurfaceHandle() == 0L) {
                if (DEBUG) {
                    System.err.println("drawable not properly initialized");
                }
                int n = 0;
                return n;
            }
            boolean bl = false;
            if (this.context == 0L) {
                this.create();
                if (DEBUG) {
                    System.err.println(X11GLXContext.getThreadName() + ": !!! Created GL context for " + this.getClass().getName());
                }
                bl = true;
            }
            if (GLX.glXGetCurrentContext() != this.context) {
                if (!GLX.glXMakeContextCurrent(this.drawable.getNativeWindow().getDisplayHandle(), this.drawable.getNativeWindow().getSurfaceHandle(), this.drawable.getNativeWindow().getSurfaceHandle(), this.context)) {
                    throw new GLException("Error making context current");
                }
                if (DEBUG && (VERBOSE || bl)) {
                    System.err.println(X11GLXContext.getThreadName() + ": glXMakeCurrent(display " + X11GLXContext.toHexString(this.drawable.getNativeWindow().getDisplayHandle()) + ", drawable " + X11GLXContext.toHexString(this.drawable.getNativeWindow().getSurfaceHandle()) + ", context " + X11GLXContext.toHexString(this.context) + ") succeeded");
                }
            }
            if (bl) {
                this.setGLFunctionAvailability(false);
                int n = 2;
                return n;
            }
            int n = 1;
            return n;
        }
        finally {
            this.getDrawableImpl().getFactoryImpl().unlockToolkit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void releaseImpl() throws GLException {
        this.getDrawableImpl().getFactoryImpl().lockToolkit();
        try {
            if (!GLX.glXMakeContextCurrent(this.drawable.getNativeWindow().getDisplayHandle(), 0L, 0L, 0L)) {
                throw new GLException("Error freeing OpenGL context");
            }
        }
        finally {
            this.getDrawableImpl().getFactoryImpl().unlockToolkit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void destroyImpl() throws GLException {
        this.getDrawableImpl().getFactoryImpl().lockToolkit();
        try {
            if (this.context != 0L) {
                if (DEBUG) {
                    System.err.println("glXDestroyContext(0x" + Long.toHexString(this.drawable.getNativeWindow().getDisplayHandle()) + ", 0x" + Long.toHexString(this.context) + ")");
                }
                GLX.glXDestroyContext(this.drawable.getNativeWindow().getDisplayHandle(), this.context);
                if (DEBUG) {
                    System.err.println("!!! Destroyed OpenGL context " + this.context);
                }
                this.context = 0L;
                GLContextShareSet.contextDestroyed(this);
            }
        }
        finally {
            this.getDrawableImpl().getFactoryImpl().unlockToolkit();
        }
    }

    public boolean isCreated() {
        return this.context != 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copy(GLContext gLContext, int n) throws GLException {
        long l = this.getContext();
        long l2 = ((X11GLXContext)gLContext).getContext();
        if (l2 == 0L) {
            throw new GLException("Source OpenGL context has not been created");
        }
        if (l == 0L) {
            throw new GLException("Destination OpenGL context has not been created");
        }
        if (this.drawable.getNativeWindow().getDisplayHandle() == 0L) {
            throw new GLException("Connection to X display not yet set up");
        }
        this.getDrawableImpl().getFactoryImpl().lockToolkit();
        try {
            GLX.glXCopyContext(this.drawable.getNativeWindow().getDisplayHandle(), l2, l, n);
        }
        finally {
            this.getDrawableImpl().getFactoryImpl().unlockToolkit();
        }
    }

    protected void updateGLProcAddressTable() {
        if (DEBUG) {
            System.err.println(X11GLXContext.getThreadName() + ": !!! Initializing GLX extension address table");
        }
        if (this.glXExtProcAddressTable == null) {
            this.glXExtProcAddressTable = new GLXExtProcAddressTable();
        }
        this.resetProcAddressTable(this.getGLXExtProcAddressTable());
        super.updateGLProcAddressTable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized String getPlatformExtensionsString() {
        if (!this.glXQueryExtensionsStringInitialized) {
            this.glXQueryExtensionsStringAvailable = this.getDrawableImpl().getDynamicLookupHelper().dynamicLookupFunction("glXQueryExtensionsString") != 0L;
            this.glXQueryExtensionsStringInitialized = true;
        }
        if (this.glXQueryExtensionsStringAvailable) {
            GLDrawableFactoryImpl gLDrawableFactoryImpl = this.getDrawableImpl().getFactoryImpl();
            gLDrawableFactoryImpl.lockToolkit();
            try {
                String string = GLX.glXQueryExtensionsString(this.drawable.getNativeWindow().getDisplayHandle(), this.drawable.getNativeWindow().getScreenIndex());
                if (DEBUG) {
                    System.err.println("!!! GLX extensions: " + string);
                }
                String string2 = string;
                return string2;
            }
            finally {
                gLDrawableFactoryImpl.unlockToolkit();
            }
        }
        return "";
    }

    public boolean isExtensionAvailable(String string) {
        if (string.equals("GL_ARB_pbuffer") || string.equals("GL_ARB_pixel_format")) {
            return this.getGLDrawable().getFactory().canCreateGLPbuffer();
        }
        return super.isExtensionAvailable(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setSwapIntervalImpl(int n) {
        block9: {
            this.getDrawableImpl().getFactoryImpl().lockToolkit();
            try {
                GLXExt gLXExt = this.getGLXExt();
                if (0 == this.hasSwapIntervalSGI) {
                    try {
                        this.hasSwapIntervalSGI = gLXExt.isExtensionAvailable("GLX_SGI_swap_control") ? 1 : -1;
                    }
                    catch (Throwable throwable) {
                        this.hasSwapIntervalSGI = 1;
                    }
                }
                if (this.hasSwapIntervalSGI <= 0) break block9;
                try {
                    if (0 == gLXExt.glXSwapIntervalSGI(n)) {
                        this.currentSwapInterval = n;
                    }
                }
                catch (Throwable throwable) {
                    this.hasSwapIntervalSGI = -1;
                }
            }
            finally {
                this.getDrawableImpl().getFactoryImpl().unlockToolkit();
            }
        }
    }

    public ByteBuffer glAllocateMemoryNV(int n, float f, float f2, float f3) {
        return this.getGLXExt().glXAllocateMemoryNV(n, f, f2, f3);
    }

    public int getOffscreenContextPixelDataType() {
        throw new GLException("Should not call this");
    }

    public int getOffscreenContextReadBuffer() {
        throw new GLException("Should not call this");
    }

    public boolean offscreenImageNeedsVerticalFlip() {
        throw new GLException("Should not call this");
    }

    public void bindPbufferToTexture() {
        throw new GLException("Should not call this");
    }

    public void releasePbufferFromTexture() {
        throw new GLException("Should not call this");
    }

    public boolean isOptimizable() {
        return super.isOptimizable() && !this.isVendorATI;
    }

    public long getContext() {
        return this.context;
    }

    static {
        functionNameMap.put("glAllocateMemoryNV", "glXAllocateMemoryNV");
        functionNameMap.put("glFreeMemoryNV", "glXFreeMemoryNV");
    }
}

