/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.util;

import java.util.Iterator;
import java.util.List;
import mpicbg.imglib.type.Type;
import mpicbg.imglib.type.numeric.ExponentialMathType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Util {
    public static double log2(double d) {
        return Math.log(d) / Math.log(2.0);
    }

    public static double[] getArrayFromValue(double d, int n) {
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = d;
        }
        return dArray;
    }

    public static float[] getArrayFromValue(float f, int n) {
        float[] fArray = new float[n];
        for (int i = 0; i < n; ++i) {
            fArray[i] = f;
        }
        return fArray;
    }

    public static int[] getArrayFromValue(int n, int n2) {
        int[] nArray = new int[n2];
        for (int i = 0; i < n2; ++i) {
            nArray[i] = n;
        }
        return nArray;
    }

    public static final float computeDistance(int[] nArray, int[] nArray2) {
        float f = 0.0f;
        for (int i = 0; i < nArray.length; ++i) {
            int n = nArray2[i] - nArray[i];
            f += (float)(n * n);
        }
        return (float)Math.sqrt(f);
    }

    public static final float computeLength(int[] nArray) {
        float f = 0.0f;
        for (int i = 0; i < nArray.length; ++i) {
            int n = nArray[i];
            f += (float)(n * n);
        }
        return (float)Math.sqrt(f);
    }

    public static long computeMedian(long[] lArray) {
        long[] lArray2 = (long[])lArray.clone();
        int n = lArray2.length;
        Util.quicksort(lArray2, 0, n - 1);
        long l = n % 2 == 1 ? lArray2[n / 2] : (lArray2[n / 2] + lArray2[n / 2 - 1]) / 2L;
        return l;
    }

    public static double computeMedian(double[] dArray) {
        double[] dArray2 = (double[])dArray.clone();
        int n = dArray2.length;
        Util.quicksort(dArray2, 0, n - 1);
        double d = n % 2 == 1 ? dArray2[n / 2] : (dArray2[n / 2] + dArray2[n / 2 - 1]) / 2.0;
        return d;
    }

    public static double computePercentile(double[] dArray, double d) {
        double[] dArray2 = (double[])dArray.clone();
        int n = dArray2.length;
        Util.quicksort(dArray2);
        return dArray2[Math.min(n - 1, Math.max(0, (int)Math.round((double)(n - 1) * d)))];
    }

    public static double computeAverageDouble(List<Double> list) {
        double d = list.size();
        double d2 = 0.0;
        for (double d3 : list) {
            d2 += d3 / d;
        }
        return d2;
    }

    public static float computeAverageFloat(List<Float> list) {
        double d = list.size();
        double d2 = 0.0;
        Iterator<Float> iterator = list.iterator();
        while (iterator.hasNext()) {
            double d3 = iterator.next().floatValue();
            d2 += d3 / d;
        }
        return (float)d2;
    }

    public static float computeMinimum(List<Float> list) {
        float f = Float.MAX_VALUE;
        for (float f2 : list) {
            if (!(f2 < f)) continue;
            f = f2;
        }
        return f;
    }

    public static float computeMaximum(List<Float> list) {
        float f = -3.4028235E38f;
        for (float f2 : list) {
            if (!(f2 > f)) continue;
            f = f2;
        }
        return f;
    }

    public static float computeAverage(float[] fArray) {
        double d = fArray.length;
        double d2 = 0.0;
        for (float f : fArray) {
            d2 += (double)f / d;
        }
        return (float)d2;
    }

    public static double computeAverage(double[] dArray) {
        double d = dArray.length;
        double d2 = 0.0;
        for (double d3 : dArray) {
            d2 += d3 / d;
        }
        return d2;
    }

    public static double computeMin(double[] dArray) {
        double d = dArray[0];
        for (double d2 : dArray) {
            if (!(d2 < d)) continue;
            d = d2;
        }
        return d;
    }

    public static double computeMax(double[] dArray) {
        double d = dArray[0];
        for (double d2 : dArray) {
            if (!(d2 > d)) continue;
            d = d2;
        }
        return d;
    }

    public static float computeMedian(float[] fArray) {
        float[] fArray2 = (float[])fArray.clone();
        int n = fArray2.length;
        Util.quicksort(fArray2, 0, n - 1);
        float f = n % 2 == 1 ? fArray2[n / 2] : (fArray2[n / 2] + fArray2[n / 2 - 1]) / 2.0f;
        return f;
    }

    public static void quicksort(long[] lArray, int n, int n2) {
        if (lArray == null || lArray.length < 2) {
            return;
        }
        int n3 = n;
        int n4 = n2;
        long l = lArray[(n + n2) / 2];
        while (true) {
            if (lArray[n3] < l) {
                ++n3;
                continue;
            }
            while (l < lArray[n4]) {
                --n4;
            }
            if (n3 <= n4) {
                long l2 = lArray[n3];
                lArray[n3] = lArray[n4];
                lArray[n4] = l2;
                ++n3;
                --n4;
            }
            if (n3 > n4) break;
        }
        if (n < n4) {
            Util.quicksort(lArray, n, n4);
        }
        if (n3 < n2) {
            Util.quicksort(lArray, n3, n2);
        }
    }

    public static void quicksort(double[] dArray) {
        Util.quicksort(dArray, 0, dArray.length - 1);
    }

    public static void quicksort(double[] dArray, int n, int n2) {
        if (dArray == null || dArray.length < 2) {
            return;
        }
        int n3 = n;
        int n4 = n2;
        double d = dArray[(n + n2) / 2];
        while (true) {
            if (dArray[n3] < d) {
                ++n3;
                continue;
            }
            while (d < dArray[n4]) {
                --n4;
            }
            if (n3 <= n4) {
                double d2 = dArray[n3];
                dArray[n3] = dArray[n4];
                dArray[n4] = d2;
                ++n3;
                --n4;
            }
            if (n3 > n4) break;
        }
        if (n < n4) {
            Util.quicksort(dArray, n, n4);
        }
        if (n3 < n2) {
            Util.quicksort(dArray, n3, n2);
        }
    }

    public static void quicksort(float[] fArray) {
        Util.quicksort(fArray, 0, fArray.length - 1);
    }

    public static void quicksort(float[] fArray, int n, int n2) {
        if (fArray == null || fArray.length < 2) {
            return;
        }
        int n3 = n;
        int n4 = n2;
        float f = fArray[(n + n2) / 2];
        while (true) {
            if (fArray[n3] < f) {
                ++n3;
                continue;
            }
            while (f < fArray[n4]) {
                --n4;
            }
            if (n3 <= n4) {
                float f2 = fArray[n3];
                fArray[n3] = fArray[n4];
                fArray[n4] = f2;
                ++n3;
                --n4;
            }
            if (n3 > n4) break;
        }
        if (n < n4) {
            Util.quicksort(fArray, n, n4);
        }
        if (n3 < n2) {
            Util.quicksort(fArray, n3, n2);
        }
    }

    public static void quicksort(double[] dArray, int[] nArray, int n, int n2) {
        if (dArray == null || dArray.length < 2) {
            return;
        }
        int n3 = n;
        int n4 = n2;
        double d = dArray[(n + n2) / 2];
        while (true) {
            if (dArray[n3] < d) {
                ++n3;
                continue;
            }
            while (d < dArray[n4]) {
                --n4;
            }
            if (n3 <= n4) {
                double d2 = dArray[n3];
                dArray[n3] = dArray[n4];
                dArray[n4] = d2;
                int n5 = nArray[n3];
                nArray[n3] = nArray[n4];
                nArray[n4] = n5;
                ++n3;
                --n4;
            }
            if (n3 > n4) break;
        }
        if (n < n4) {
            Util.quicksort(dArray, nArray, n, n4);
        }
        if (n3 < n2) {
            Util.quicksort(dArray, nArray, n3, n2);
        }
    }

    public static double gLog(double d, double d2) {
        if (d2 == 0.0) {
            return d;
        }
        return Math.log10((d + Math.sqrt(d * d + d2 * d2)) / 2.0);
    }

    public static float gLog(float f, float f2) {
        if (f2 == 0.0f) {
            return f;
        }
        return (float)Math.log10(((double)f + Math.sqrt(f * f + f2 * f2)) / 2.0);
    }

    public static double gLogInv(double d, double d2) {
        if (d2 == 0.0) {
            return d;
        }
        return Math.pow(10.0, d) - d2 * d2 * Math.pow(10.0, -d) / 4.0;
    }

    public static double gLogInv(float f, float f2) {
        if (f2 == 0.0f) {
            return f;
        }
        return Math.pow(10.0, f) - (double)(f2 * f2) * Math.pow(10.0, -f) / 4.0;
    }

    public static boolean isApproxEqual(float f, float f2, float f3) {
        if (f == f2) {
            return true;
        }
        return f + f3 > f2 && f - f3 < f2;
    }

    public static boolean isApproxEqual(double d, double d2, double d3) {
        if (d == d2) {
            return true;
        }
        return d + d3 > d2 && d - d3 < d2;
    }

    public static int round(float f) {
        return (int)(f + 0.5f * Math.signum(f));
    }

    public static long round(double d) {
        return (long)(d + 0.5 * Math.signum(d));
    }

    public static double[] createGaussianKernel1DDouble(double d, boolean bl) {
        double d2;
        double[] dArray;
        int n = 3;
        if (d <= 0.0) {
            dArray = new double[3];
            dArray[1] = 1.0;
        } else {
            n = Math.max(3, 2 * (int)(3.0 * d + 0.5) + 1);
            d2 = 2.0 * d * d;
            dArray = new double[n];
            for (int i = n / 2; i >= 0; --i) {
                double d3;
                dArray[n / 2 - i] = d3 = Math.exp((double)(-(i * i)) / d2);
                dArray[n / 2 + i] = d3;
            }
        }
        if (bl) {
            d2 = 0.0;
            for (double d4 : dArray) {
                d2 += d4;
            }
            int n2 = 0;
            while (n2 < dArray.length) {
                int n3 = n2++;
                dArray[n3] = dArray[n3] / d2;
            }
        }
        return dArray;
    }

    public static <T extends ExponentialMathType<T>> T[] createGaussianKernel1D(T exponentialMathType, boolean bl) {
        int n;
        ExponentialMathType[] exponentialMathTypeArray;
        int n2;
        ExponentialMathType exponentialMathType2 = (ExponentialMathType)exponentialMathType.createVariable();
        ExponentialMathType exponentialMathType3 = (ExponentialMathType)exponentialMathType.createVariable();
        ExponentialMathType exponentialMathType4 = (ExponentialMathType)exponentialMathType.createVariable();
        ExponentialMathType exponentialMathType5 = (ExponentialMathType)exponentialMathType.createVariable();
        ExponentialMathType exponentialMathType6 = (ExponentialMathType)exponentialMathType2.createVariable();
        ExponentialMathType exponentialMathType7 = (ExponentialMathType)exponentialMathType.createVariable();
        ExponentialMathType exponentialMathType8 = (ExponentialMathType)exponentialMathType.createVariable();
        ExponentialMathType exponentialMathType9 = (ExponentialMathType)exponentialMathType.createVariable();
        ExponentialMathType exponentialMathType10 = (ExponentialMathType)exponentialMathType.createVariable();
        exponentialMathType2.setZero();
        exponentialMathType4.setOne();
        exponentialMathType3.setOne();
        exponentialMathType3.add(exponentialMathType4);
        exponentialMathType5.setZero();
        exponentialMathType5.sub(exponentialMathType4);
        if (exponentialMathType.compareTo((ExponentialMathType)exponentialMathType2) <= 0) {
            n2 = 3;
            exponentialMathTypeArray = (ExponentialMathType[])exponentialMathType2.createArray1D(3);
            exponentialMathTypeArray[1].set(exponentialMathType4);
        } else {
            exponentialMathType10.set(exponentialMathType);
            exponentialMathType10.mul(3.0);
            exponentialMathType10.round();
            exponentialMathType10.mul(2.0);
            exponentialMathType10.add(exponentialMathType4);
            n2 = Util.round(exponentialMathType10.getRealFloat());
            n2 = Math.max(3, n2);
            if (n2 % 2 == 0) {
                ++n2;
            }
            exponentialMathType6.set(exponentialMathType3);
            exponentialMathType6.mul(exponentialMathType);
            exponentialMathType6.mul(exponentialMathType);
            exponentialMathTypeArray = (ExponentialMathType[])exponentialMathType2.createArray1D(n2);
            for (n = 0; n < exponentialMathTypeArray.length; ++n) {
                exponentialMathTypeArray[n] = (ExponentialMathType)exponentialMathType2.createVariable();
            }
            exponentialMathType9.setZero();
            for (n = 1; n <= n2 / 2; ++n) {
                exponentialMathType9.add(exponentialMathType4);
            }
            for (n = n2 / 2; n >= 0; --n) {
                exponentialMathType8.set(exponentialMathType9);
                exponentialMathType8.mul(exponentialMathType9);
                exponentialMathType8.mul(exponentialMathType5);
                exponentialMathType8.div(exponentialMathType6);
                exponentialMathType8.exp();
                exponentialMathTypeArray[n2 / 2 - n].set(exponentialMathType8);
                exponentialMathTypeArray[n2 / 2 + n].set(exponentialMathType8);
                exponentialMathType9.sub(exponentialMathType4);
            }
        }
        if (bl) {
            exponentialMathType7.setZero();
            for (ExponentialMathType exponentialMathType11 : exponentialMathTypeArray) {
                exponentialMathType7.add(exponentialMathType11);
            }
            for (n = 0; n < exponentialMathTypeArray.length; ++n) {
                exponentialMathTypeArray[n].div(exponentialMathType7);
            }
        }
        for (n = 0; n < exponentialMathTypeArray.length; ++n) {
            System.out.println(exponentialMathTypeArray[n]);
        }
        return exponentialMathTypeArray;
    }

    public static int getSuggestedKernelDiameter(double d) {
        int n = 3;
        if (d > 0.0) {
            n = Math.max(3, 2 * (int)(3.0 * d + 0.5) + 1);
        }
        return n;
    }

    public static String printCoordinates(float[] fArray) {
        String string = "(Array empty)";
        if (fArray == null || fArray.length == 0) {
            return string;
        }
        string = "(" + fArray[0];
        for (int i = 1; i < fArray.length; ++i) {
            string = string + ", " + fArray[i];
        }
        string = string + ")";
        return string;
    }

    public static String printCoordinates(int[] nArray) {
        String string = "(Array empty)";
        if (nArray == null || nArray.length == 0) {
            return string;
        }
        string = "(" + nArray[0];
        for (int i = 1; i < nArray.length; ++i) {
            string = string + ", " + nArray[i];
        }
        string = string + ")";
        return string;
    }

    public static String printCoordinates(boolean[] blArray) {
        String string = "(Array empty)";
        if (blArray == null || blArray.length == 0) {
            return string;
        }
        string = "(";
        string = blArray[0] ? string + "1" : string + "0";
        for (int i = 1; i < blArray.length; ++i) {
            string = string + ", ";
            string = blArray[i] ? string + "1" : string + "0";
        }
        string = string + ")";
        return string;
    }

    public static int pow(int n, int n2) {
        if (n2 == 0) {
            return 1;
        }
        if (n2 == 1) {
            return n;
        }
        int n3 = n;
        for (int i = 1; i < n2; ++i) {
            n3 *= n;
        }
        return n3;
    }

    public static <T extends Type<T> & Comparable<T>> T max(T t, T t2) {
        if (((Comparable<T>)t).compareTo(t2) >= 0) {
            return t;
        }
        return t2;
    }

    public static <T extends Type<T> & Comparable<T>> T min(T t, T t2) {
        if (((Comparable<T>)t).compareTo(t2) <= 0) {
            return t;
        }
        return t2;
    }

    public static boolean[][] getRecursiveCoordinates(int n) {
        boolean[][] blArray = new boolean[Util.pow(2, n)][n];
        Util.setCoordinateRecursive(n - 1, n, new int[n], blArray);
        return blArray;
    }

    public static void setCoordinateRecursive(int n, int n2, int[] nArray, boolean[][] blArray) {
        int n3;
        int[] nArray2 = new int[n2];
        int[] nArray3 = new int[n2];
        for (n3 = 0; n3 < n2; ++n3) {
            nArray2[n3] = nArray[n3];
            nArray3[n3] = nArray[n3];
        }
        nArray2[n] = 0;
        nArray3[n] = 1;
        if (n == 0) {
            int n4;
            n3 = 0;
            int n5 = 0;
            for (n4 = 0; n4 < n2; ++n4) {
                n3 += nArray2[n4] * Util.pow(2, n4);
                n5 += nArray3[n4] * Util.pow(2, n4);
            }
            for (n4 = 0; n4 < n2; ++n4) {
                blArray[n3][n4] = nArray2[n4] == 1;
                blArray[n5][n4] = nArray3[n4] == 1;
            }
        } else {
            Util.setCoordinateRecursive(n - 1, n2, nArray2, blArray);
            Util.setCoordinateRecursive(n - 1, n2, nArray3, blArray);
        }
    }
}

