/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.type.numeric.real;

import mpicbg.imglib.image.Image;
import mpicbg.imglib.image.display.Display;
import mpicbg.imglib.image.display.RealTypeDisplay;
import mpicbg.imglib.type.numeric.RealType;
import mpicbg.imglib.type.numeric.complex.ComplexTypeImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RealTypeImpl<T extends RealTypeImpl<T>>
extends ComplexTypeImpl<T>
implements RealType<T> {
    @Override
    public int getEntitiesPerPixel() {
        return 1;
    }

    @Override
    public Display<T> getDefaultDisplay(Image<T> image) {
        return new RealTypeDisplay<T>(image);
    }

    @Override
    public float getComplexFloat() {
        return 0.0f;
    }

    @Override
    public double getComplexDouble() {
        return 0.0;
    }

    @Override
    public void setComplex(float f) {
    }

    @Override
    public void setComplex(double d) {
    }

    @Override
    public void inc() {
        this.setReal(this.getRealDouble() + 1.0);
    }

    @Override
    public void dec() {
        this.setReal(this.getRealDouble() - 1.0);
    }

    @Override
    public void set(T t) {
        this.setReal(t.getRealDouble());
    }

    @Override
    public void mul(float f) {
        this.setReal(this.getRealDouble() * (double)f);
    }

    @Override
    public void mul(double d) {
        this.setReal(this.getRealDouble() * d);
    }

    @Override
    public void add(T t) {
        this.setReal(this.getRealDouble() + t.getRealDouble());
    }

    @Override
    public void div(T t) {
        this.setReal(this.getRealDouble() / t.getRealDouble());
    }

    @Override
    public void mul(T t) {
        this.setReal(this.getRealDouble() * t.getRealDouble());
    }

    @Override
    public void sub(T t) {
        this.setReal(this.getRealDouble() - t.getRealDouble());
    }

    @Override
    public void setZero() {
        this.setReal(0.0f);
    }

    @Override
    public void setOne() {
        this.setReal(1.0f);
    }

    @Override
    public int compareTo(T t) {
        double d;
        double d2 = this.getRealDouble();
        if (d2 > (d = t.getRealDouble())) {
            return 1;
        }
        if (d2 < d) {
            return -1;
        }
        return 0;
    }

    @Override
    public float getPowerFloat() {
        return this.getRealFloat();
    }

    @Override
    public double getPowerDouble() {
        return this.getRealDouble();
    }

    @Override
    public float getPhaseFloat() {
        return 0.0f;
    }

    @Override
    public double getPhaseDouble() {
        return 0.0;
    }

    @Override
    public void updateIndex(int n) {
        this.i = n;
    }

    @Override
    public void incIndex() {
        ++this.i;
    }

    @Override
    public void incIndex(int n) {
        this.i += n;
    }

    @Override
    public void decIndex() {
        --this.i;
    }

    @Override
    public void decIndex(int n) {
        this.i -= n;
    }

    @Override
    public String toString() {
        return "" + this.getRealDouble();
    }
}

