/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.type.numeric.real;

import mpicbg.imglib.algorithm.Precision;
import mpicbg.imglib.container.DirectAccessContainer;
import mpicbg.imglib.container.DirectAccessContainerFactory;
import mpicbg.imglib.container.basictypecontainer.FloatAccess;
import mpicbg.imglib.container.basictypecontainer.array.FloatArray;
import mpicbg.imglib.cursor.Cursor;
import mpicbg.imglib.type.numeric.RealType;
import mpicbg.imglib.type.numeric.real.RealTypeImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FloatType
extends RealTypeImpl<FloatType>
implements RealType<FloatType> {
    final DirectAccessContainer<FloatType, ? extends FloatAccess> storage;
    FloatAccess b;

    public FloatType(DirectAccessContainer<FloatType, ? extends FloatAccess> directAccessContainer) {
        this.storage = directAccessContainer;
    }

    public FloatType(float f) {
        this.storage = null;
        this.b = new FloatArray(1);
        this.set(f);
    }

    public FloatType() {
        this(0.0f);
    }

    @Override
    public DirectAccessContainer<FloatType, ? extends FloatAccess> createSuitableDirectAccessContainer(DirectAccessContainerFactory directAccessContainerFactory, int[] nArray) {
        DirectAccessContainer<FloatType, FloatAccess> directAccessContainer = directAccessContainerFactory.createFloatInstance(nArray, 1);
        FloatType floatType = new FloatType(directAccessContainer);
        directAccessContainer.setLinkedType(floatType);
        return directAccessContainer;
    }

    @Override
    public void updateContainer(Cursor<?> cursor) {
        this.b = this.storage.update(cursor);
    }

    @Override
    public FloatType duplicateTypeOnSameDirectAccessContainer() {
        return new FloatType(this.storage);
    }

    public float get() {
        return this.b.getValue(this.i);
    }

    @Override
    public void set(float f) {
        this.b.setValue(this.i, f);
    }

    @Override
    public float getRealFloat() {
        return this.get();
    }

    @Override
    public double getRealDouble() {
        return this.get();
    }

    @Override
    public void setReal(float f) {
        this.set(f);
    }

    @Override
    public void setReal(double d) {
        this.set((float)d);
    }

    @Override
    public Precision.PrecisionReal getPreferredRealPrecision() {
        return Precision.PrecisionReal.Float;
    }

    @Override
    public double getMaxValue() {
        return 3.4028234663852886E38;
    }

    @Override
    public double getMinValue() {
        return -3.4028234663852886E38;
    }

    @Override
    public double getMinIncrement() {
        return 1.4E-45f;
    }

    @Override
    public void mul(float f) {
        this.set(this.get() * f);
    }

    @Override
    public void mul(double d) {
        this.set((float)((double)this.get() * d));
    }

    @Override
    public void add(FloatType floatType) {
        this.set(this.get() + floatType.get());
    }

    @Override
    public void div(FloatType floatType) {
        this.set(this.get() / floatType.get());
    }

    @Override
    public void mul(FloatType floatType) {
        this.set(this.get() * floatType.get());
    }

    @Override
    public void sub(FloatType floatType) {
        this.set(this.get() - floatType.get());
    }

    @Override
    public int compareTo(FloatType floatType) {
        float f;
        float f2 = this.get();
        if (f2 > (f = floatType.get())) {
            return 1;
        }
        if (f2 < f) {
            return -1;
        }
        return 0;
    }

    @Override
    public void set(FloatType floatType) {
        this.set(floatType.get());
    }

    @Override
    public void setOne() {
        this.set(1.0f);
    }

    @Override
    public void setZero() {
        this.set(0.0f);
    }

    @Override
    public void inc() {
        float f = this.get();
        this.set(f += 1.0f);
    }

    @Override
    public void dec() {
        float f = this.get();
        this.set(f -= 1.0f);
    }

    public FloatType[] createArray1D(int n) {
        return new FloatType[n];
    }

    public FloatType[][] createArray2D(int n, int n2) {
        return new FloatType[n][n2];
    }

    public FloatType[][][] createArray3D(int n, int n2, int n3) {
        return new FloatType[n][n2][n3];
    }

    @Override
    public FloatType createVariable() {
        return new FloatType(0.0f);
    }

    @Override
    public FloatType copy() {
        return new FloatType(this.get());
    }
}

