/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.type.numeric.integer;

import mpicbg.imglib.container.DirectAccessContainer;
import mpicbg.imglib.container.DirectAccessContainerFactory;
import mpicbg.imglib.container.basictypecontainer.ShortAccess;
import mpicbg.imglib.type.numeric.integer.GenericShortType;
import mpicbg.imglib.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnsignedShortType
extends GenericShortType<UnsignedShortType> {
    public UnsignedShortType(DirectAccessContainer<UnsignedShortType, ? extends ShortAccess> directAccessContainer) {
        super(directAccessContainer);
    }

    public UnsignedShortType(int n) {
        super(UnsignedShortType.getCodedSignedShortChecked(n));
    }

    public UnsignedShortType() {
        this(0);
    }

    public static short getCodedSignedShortChecked(int n) {
        if (n < 0) {
            n = 0;
        } else if (n > 65535) {
            n = 65535;
        }
        return UnsignedShortType.getCodedSignedShort(n);
    }

    public static short getCodedSignedShort(int n) {
        return (short)(n & 0xFFFF);
    }

    public static int getUnsignedShort(short s) {
        return s & 0xFFFF;
    }

    @Override
    public DirectAccessContainer<UnsignedShortType, ? extends ShortAccess> createSuitableDirectAccessContainer(DirectAccessContainerFactory directAccessContainerFactory, int[] nArray) {
        DirectAccessContainer<UnsignedShortType, ShortAccess> directAccessContainer = directAccessContainerFactory.createShortInstance(nArray, 1);
        UnsignedShortType unsignedShortType = new UnsignedShortType((DirectAccessContainer<UnsignedShortType, ? extends ShortAccess>)directAccessContainer);
        directAccessContainer.setLinkedType(unsignedShortType);
        return directAccessContainer;
    }

    @Override
    public UnsignedShortType duplicateTypeOnSameDirectAccessContainer() {
        return new UnsignedShortType(this.storage);
    }

    @Override
    public void mul(float f) {
        int n = UnsignedShortType.getUnsignedShort(this.getValue());
        this.setValue(UnsignedShortType.getCodedSignedShort(Util.round((float)n * f)));
    }

    @Override
    public void mul(double d) {
        int n = UnsignedShortType.getUnsignedShort(this.getValue());
        this.setValue(UnsignedShortType.getCodedSignedShort((int)Util.round((double)n * d)));
    }

    public int get() {
        return UnsignedShortType.getUnsignedShort(this.getValue());
    }

    @Override
    public void set(int n) {
        this.setValue(UnsignedShortType.getCodedSignedShort(n));
    }

    @Override
    public int getInteger() {
        return this.get();
    }

    @Override
    public long getIntegerLong() {
        return this.get();
    }

    @Override
    public void setInteger(int n) {
        this.set(n);
    }

    @Override
    public void setInteger(long l) {
        this.set((int)l);
    }

    @Override
    public double getMaxValue() {
        return 65535.0;
    }

    @Override
    public double getMinValue() {
        return 0.0;
    }

    @Override
    public void div(UnsignedShortType unsignedShortType) {
        this.set(this.get() / unsignedShortType.get());
    }

    @Override
    public int compareTo(UnsignedShortType unsignedShortType) {
        int n;
        int n2 = this.get();
        if (n2 > (n = unsignedShortType.get())) {
            return 1;
        }
        if (n2 < n) {
            return -1;
        }
        return 0;
    }

    public UnsignedShortType[] createArray1D(int n) {
        return new UnsignedShortType[n];
    }

    public UnsignedShortType[][] createArray2D(int n, int n2) {
        return new UnsignedShortType[n][n2];
    }

    public UnsignedShortType[][][] createArray3D(int n, int n2, int n3) {
        return new UnsignedShortType[n][n2][n3];
    }

    @Override
    public UnsignedShortType createVariable() {
        return new UnsignedShortType(0);
    }

    @Override
    public UnsignedShortType copy() {
        return new UnsignedShortType(this.get());
    }
}

