/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.type.numeric.integer;

import mpicbg.imglib.container.DirectAccessContainer;
import mpicbg.imglib.container.DirectAccessContainerFactory;
import mpicbg.imglib.container.basictypecontainer.IntAccess;
import mpicbg.imglib.type.numeric.integer.GenericIntType;
import mpicbg.imglib.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnsignedIntType
extends GenericIntType<UnsignedIntType> {
    public UnsignedIntType(DirectAccessContainer<UnsignedIntType, ? extends IntAccess> directAccessContainer) {
        super(directAccessContainer);
    }

    public UnsignedIntType(long l) {
        super(UnsignedIntType.getCodedSignedIntChecked(l));
    }

    public UnsignedIntType() {
        this(0L);
    }

    public static int getCodedSignedIntChecked(long l) {
        if (l < 0L) {
            l = 0L;
        } else if (l > 0xFFFFFFFFL) {
            l = 0xFFFFFFFFL;
        }
        return UnsignedIntType.getCodedSignedInt(l);
    }

    public static int getCodedSignedInt(long l) {
        return (int)(l & 0xFFFFFFFFFFFFFFFFL);
    }

    public static long getUnsignedInt(int n) {
        return (long)n & 0xFFFFFFFFL;
    }

    @Override
    public DirectAccessContainer<UnsignedIntType, ? extends IntAccess> createSuitableDirectAccessContainer(DirectAccessContainerFactory directAccessContainerFactory, int[] nArray) {
        DirectAccessContainer<UnsignedIntType, IntAccess> directAccessContainer = directAccessContainerFactory.createIntInstance(nArray, 1);
        UnsignedIntType unsignedIntType = new UnsignedIntType((DirectAccessContainer<UnsignedIntType, ? extends IntAccess>)directAccessContainer);
        directAccessContainer.setLinkedType(unsignedIntType);
        return directAccessContainer;
    }

    @Override
    public UnsignedIntType duplicateTypeOnSameDirectAccessContainer() {
        return new UnsignedIntType(this.storage);
    }

    @Override
    public void mul(float f) {
        long l = UnsignedIntType.getUnsignedInt(this.getValue());
        this.setValue(UnsignedIntType.getCodedSignedInt(Util.round((float)l * f)));
    }

    @Override
    public void mul(double d) {
        long l = UnsignedIntType.getUnsignedInt(this.getValue());
        this.setValue(UnsignedIntType.getCodedSignedInt((int)Util.round((double)l * d)));
    }

    public long get() {
        return UnsignedIntType.getUnsignedInt(this.getValue());
    }

    @Override
    public void set(long l) {
        this.setValue(UnsignedIntType.getCodedSignedInt(l));
    }

    @Override
    public int getInteger() {
        return (int)this.get();
    }

    @Override
    public long getIntegerLong() {
        return this.get();
    }

    @Override
    public void setInteger(int n) {
        this.set(n);
    }

    @Override
    public void setInteger(long l) {
        this.set(l);
    }

    @Override
    public double getMaxValue() {
        return 4.294967295E9;
    }

    @Override
    public double getMinValue() {
        return 0.0;
    }

    @Override
    public void div(UnsignedIntType unsignedIntType) {
        this.set(this.get() / unsignedIntType.get());
    }

    @Override
    public int compareTo(UnsignedIntType unsignedIntType) {
        long l;
        long l2 = this.get();
        if (l2 > (l = unsignedIntType.get())) {
            return 1;
        }
        if (l2 < l) {
            return -1;
        }
        return 0;
    }

    public UnsignedIntType[] createArray1D(int n) {
        return new UnsignedIntType[n];
    }

    public UnsignedIntType[][] createArray2D(int n, int n2) {
        return new UnsignedIntType[n][n2];
    }

    public UnsignedIntType[][][] createArray3D(int n, int n2, int n3) {
        return new UnsignedIntType[n][n2][n3];
    }

    @Override
    public UnsignedIntType createVariable() {
        return new UnsignedIntType(0L);
    }

    @Override
    public UnsignedIntType copy() {
        return new UnsignedIntType(this.get());
    }
}

