/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.type.numeric.integer;

import mpicbg.imglib.container.DirectAccessContainer;
import mpicbg.imglib.container.DirectAccessContainerFactory;
import mpicbg.imglib.container.basictypecontainer.ByteAccess;
import mpicbg.imglib.type.numeric.integer.GenericByteType;
import mpicbg.imglib.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnsignedByteType
extends GenericByteType<UnsignedByteType> {
    public UnsignedByteType(DirectAccessContainer<UnsignedByteType, ? extends ByteAccess> directAccessContainer) {
        super(directAccessContainer);
    }

    public UnsignedByteType(int n) {
        super(UnsignedByteType.getCodedSignedByteChecked(n));
    }

    public UnsignedByteType() {
        this(0);
    }

    public static byte getCodedSignedByteChecked(int n) {
        if (n < 0) {
            n = 0;
        } else if (n > 255) {
            n = 255;
        }
        return UnsignedByteType.getCodedSignedByte(n);
    }

    public static byte getCodedSignedByte(int n) {
        return (byte)(n & 0xFF);
    }

    public static int getUnsignedByte(byte by) {
        return by & 0xFF;
    }

    @Override
    public DirectAccessContainer<UnsignedByteType, ? extends ByteAccess> createSuitableDirectAccessContainer(DirectAccessContainerFactory directAccessContainerFactory, int[] nArray) {
        DirectAccessContainer<UnsignedByteType, ByteAccess> directAccessContainer = directAccessContainerFactory.createByteInstance(nArray, 1);
        UnsignedByteType unsignedByteType = new UnsignedByteType((DirectAccessContainer<UnsignedByteType, ? extends ByteAccess>)directAccessContainer);
        directAccessContainer.setLinkedType(unsignedByteType);
        return directAccessContainer;
    }

    @Override
    public UnsignedByteType duplicateTypeOnSameDirectAccessContainer() {
        return new UnsignedByteType(this.storage);
    }

    @Override
    public void mul(float f) {
        int n = UnsignedByteType.getUnsignedByte(this.getValue());
        this.setValue(UnsignedByteType.getCodedSignedByte(Util.round((float)n * f)));
    }

    @Override
    public void mul(double d) {
        int n = UnsignedByteType.getUnsignedByte(this.getValue());
        this.setValue(UnsignedByteType.getCodedSignedByte((int)Util.round((double)n * d)));
    }

    public int get() {
        return UnsignedByteType.getUnsignedByte(this.getValue());
    }

    @Override
    public void set(int n) {
        this.setValue(UnsignedByteType.getCodedSignedByte(n));
    }

    @Override
    public int getInteger() {
        return this.get();
    }

    @Override
    public long getIntegerLong() {
        return this.get();
    }

    @Override
    public void setInteger(int n) {
        this.set(n);
    }

    @Override
    public void setInteger(long l) {
        this.set((int)l);
    }

    @Override
    public double getMaxValue() {
        return 255.0;
    }

    @Override
    public double getMinValue() {
        return 0.0;
    }

    @Override
    public void div(UnsignedByteType unsignedByteType) {
        this.set(this.get() / unsignedByteType.get());
    }

    @Override
    public int compareTo(UnsignedByteType unsignedByteType) {
        int n;
        int n2 = this.get();
        if (n2 > (n = unsignedByteType.get())) {
            return 1;
        }
        if (n2 < n) {
            return -1;
        }
        return 0;
    }

    public UnsignedByteType[] createArray1D(int n) {
        return new UnsignedByteType[n];
    }

    public UnsignedByteType[][] createArray2D(int n, int n2) {
        return new UnsignedByteType[n][n2];
    }

    public UnsignedByteType[][][] createArray3D(int n, int n2, int n3) {
        return new UnsignedByteType[n][n2][n3];
    }

    @Override
    public UnsignedByteType createVariable() {
        return new UnsignedByteType(0);
    }

    @Override
    public UnsignedByteType copy() {
        return new UnsignedByteType(this.get());
    }
}

