/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.type.numeric.integer;

import mpicbg.imglib.container.DirectAccessContainer;
import mpicbg.imglib.container.DirectAccessContainerFactory;
import mpicbg.imglib.container.basictypecontainer.BitAccess;
import mpicbg.imglib.container.basictypecontainer.array.BitArray;
import mpicbg.imglib.cursor.Cursor;
import mpicbg.imglib.type.numeric.integer.IntegerTypeImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Unsigned12BitType
extends IntegerTypeImpl<Unsigned12BitType> {
    final DirectAccessContainer<Unsigned12BitType, ? extends BitAccess> storage;
    int j1;
    int j2;
    int j3;
    int j4;
    int j5;
    int j6;
    int j7;
    int j8;
    int j9;
    int j10;
    int j11;
    int j12;
    BitAccess b;

    public Unsigned12BitType(DirectAccessContainer<Unsigned12BitType, ? extends BitAccess> directAccessContainer) {
        this.storage = directAccessContainer;
        this.updateIndex(0);
    }

    public Unsigned12BitType(short s) {
        this.storage = null;
        this.updateIndex(0);
        this.b = new BitArray(12);
        this.set(s);
    }

    public Unsigned12BitType() {
        this(0);
    }

    @Override
    public DirectAccessContainer<Unsigned12BitType, ? extends BitAccess> createSuitableDirectAccessContainer(DirectAccessContainerFactory directAccessContainerFactory, int[] nArray) {
        DirectAccessContainer<Unsigned12BitType, BitAccess> directAccessContainer = directAccessContainerFactory.createBitInstance(nArray, 12);
        Unsigned12BitType unsigned12BitType = new Unsigned12BitType(directAccessContainer);
        directAccessContainer.setLinkedType(unsigned12BitType);
        return directAccessContainer;
    }

    @Override
    public void updateContainer(Cursor<?> cursor) {
        this.b = this.storage.update(cursor);
    }

    @Override
    public Unsigned12BitType duplicateTypeOnSameDirectAccessContainer() {
        return new Unsigned12BitType(this.storage);
    }

    public short get() {
        short s = 0;
        if (this.b.getValue(this.j1)) {
            s = (short)(s + 1);
        }
        if (this.b.getValue(this.j2)) {
            s = (short)(s + 2);
        }
        if (this.b.getValue(this.j3)) {
            s = (short)(s + 4);
        }
        if (this.b.getValue(this.j4)) {
            s = (short)(s + 8);
        }
        if (this.b.getValue(this.j5)) {
            s = (short)(s + 16);
        }
        if (this.b.getValue(this.j6)) {
            s = (short)(s + 32);
        }
        if (this.b.getValue(this.j7)) {
            s = (short)(s + 64);
        }
        if (this.b.getValue(this.j8)) {
            s = (short)(s + 128);
        }
        if (this.b.getValue(this.j9)) {
            s = (short)(s + 256);
        }
        if (this.b.getValue(this.j10)) {
            s = (short)(s + 512);
        }
        if (this.b.getValue(this.j11)) {
            s = (short)(s + 1024);
        }
        if (this.b.getValue(this.j12)) {
            s = (short)(s + 2048);
        }
        return s;
    }

    @Override
    public void set(short s) {
        this.b.setValue(this.j1, (s & 1) == 1);
        this.b.setValue(this.j2, (s & 2) == 2);
        this.b.setValue(this.j3, (s & 4) == 4);
        this.b.setValue(this.j4, (s & 8) == 8);
        this.b.setValue(this.j5, (s & 0x10) == 16);
        this.b.setValue(this.j6, (s & 0x20) == 32);
        this.b.setValue(this.j7, (s & 0x40) == 64);
        this.b.setValue(this.j8, (s & 0x80) == 128);
        this.b.setValue(this.j9, (s & 0x100) == 256);
        this.b.setValue(this.j10, (s & 0x200) == 512);
        this.b.setValue(this.j11, (s & 0x400) == 1024);
        this.b.setValue(this.j12, (s & 0x800) == 2048);
    }

    @Override
    public int getInteger() {
        return this.get();
    }

    @Override
    public long getIntegerLong() {
        return this.get();
    }

    @Override
    public void setInteger(int n) {
        this.set((short)n);
    }

    @Override
    public void setInteger(long l) {
        this.set((short)l);
    }

    @Override
    public double getMaxValue() {
        return 4095.0;
    }

    @Override
    public double getMinValue() {
        return 0.0;
    }

    @Override
    public void updateIndex(int n) {
        this.i = n;
        this.j1 = n * 12;
        this.j2 = this.j1 + 1;
        this.j3 = this.j1 + 2;
        this.j4 = this.j1 + 3;
        this.j5 = this.j1 + 4;
        this.j6 = this.j1 + 5;
        this.j7 = this.j1 + 6;
        this.j8 = this.j1 + 7;
        this.j9 = this.j1 + 8;
        this.j10 = this.j1 + 9;
        this.j11 = this.j1 + 10;
        this.j12 = this.j1 + 11;
    }

    @Override
    public void incIndex() {
        ++this.i;
        this.j1 += 12;
        this.j2 += 12;
        this.j3 += 12;
        this.j4 += 12;
        this.j5 += 12;
        this.j6 += 12;
        this.j7 += 12;
        this.j8 += 12;
        this.j9 += 12;
        this.j10 += 12;
        this.j11 += 12;
        this.j12 += 12;
    }

    @Override
    public void incIndex(int n) {
        this.i += n;
        int n2 = 12 * n;
        this.j1 += n2;
        this.j2 += n2;
        this.j3 += n2;
        this.j4 += n2;
        this.j5 += n2;
        this.j6 += n2;
        this.j7 += n2;
        this.j8 += n2;
        this.j9 += n2;
        this.j10 += n2;
        this.j11 += n2;
        this.j12 += n2;
    }

    @Override
    public void decIndex() {
        --this.i;
        this.j1 -= 12;
        this.j2 -= 12;
        this.j3 -= 12;
        this.j4 -= 12;
        this.j5 -= 12;
        this.j6 -= 12;
        this.j7 -= 12;
        this.j8 -= 12;
        this.j9 -= 12;
        this.j10 -= 12;
        this.j11 -= 12;
        this.j12 -= 12;
    }

    @Override
    public void decIndex(int n) {
        this.i -= n;
        int n2 = 12 * n;
        this.j1 -= n2;
        this.j2 -= n2;
        this.j3 -= n2;
        this.j4 -= n2;
        this.j5 -= n2;
        this.j6 -= n2;
        this.j7 -= n2;
        this.j8 -= n2;
        this.j9 -= n2;
        this.j10 -= n2;
        this.j11 -= n2;
        this.j12 -= n2;
    }

    public Unsigned12BitType[] createArray1D(int n) {
        return new Unsigned12BitType[n];
    }

    public Unsigned12BitType[][] createArray2D(int n, int n2) {
        return new Unsigned12BitType[n][n2];
    }

    public Unsigned12BitType[][][] createArray3D(int n, int n2, int n3) {
        return new Unsigned12BitType[n][n2][n3];
    }

    @Override
    public Unsigned12BitType createVariable() {
        return new Unsigned12BitType();
    }

    @Override
    public Unsigned12BitType copy() {
        return new Unsigned12BitType(this.get());
    }
}

