/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.type.numeric.integer;

import mpicbg.imglib.container.DirectAccessContainer;
import mpicbg.imglib.container.DirectAccessContainerFactory;
import mpicbg.imglib.container.basictypecontainer.LongAccess;
import mpicbg.imglib.container.basictypecontainer.array.LongArray;
import mpicbg.imglib.cursor.Cursor;
import mpicbg.imglib.type.numeric.integer.IntegerTypeImpl;
import mpicbg.imglib.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LongType
extends IntegerTypeImpl<LongType> {
    final DirectAccessContainer<LongType, ? extends LongAccess> storage;
    LongAccess b;

    public LongType(DirectAccessContainer<LongType, ? extends LongAccess> directAccessContainer) {
        this.storage = directAccessContainer;
    }

    public LongType(long l) {
        this.storage = null;
        this.b = new LongArray(1);
        this.set(l);
    }

    public LongType() {
        this(0L);
    }

    @Override
    public DirectAccessContainer<LongType, ? extends LongAccess> createSuitableDirectAccessContainer(DirectAccessContainerFactory directAccessContainerFactory, int[] nArray) {
        DirectAccessContainer<LongType, LongAccess> directAccessContainer = directAccessContainerFactory.createLongInstance(nArray, 1);
        LongType longType = new LongType(directAccessContainer);
        directAccessContainer.setLinkedType(longType);
        return directAccessContainer;
    }

    @Override
    public void updateContainer(Cursor<?> cursor) {
        this.b = this.storage.update(cursor);
    }

    @Override
    public LongType duplicateTypeOnSameDirectAccessContainer() {
        return new LongType(this.storage);
    }

    public long get() {
        return this.b.getValue(this.i);
    }

    @Override
    public void set(long l) {
        this.b.setValue(this.i, l);
    }

    @Override
    public int getInteger() {
        return (int)this.get();
    }

    @Override
    public long getIntegerLong() {
        return this.get();
    }

    @Override
    public void setInteger(int n) {
        this.set(n);
    }

    @Override
    public void setInteger(long l) {
        this.set(l);
    }

    @Override
    public double getMaxValue() {
        return 9.223372036854776E18;
    }

    @Override
    public double getMinValue() {
        return -9.223372036854776E18;
    }

    @Override
    public void mul(float f) {
        this.set(Util.round((float)this.get() * f));
    }

    @Override
    public void mul(double d) {
        this.set(Util.round((double)this.get() * d));
    }

    @Override
    public void add(LongType longType) {
        this.set(this.get() + longType.get());
    }

    @Override
    public void div(LongType longType) {
        this.set(this.get() / longType.get());
    }

    @Override
    public void mul(LongType longType) {
        this.set(this.get() * longType.get());
    }

    @Override
    public void sub(LongType longType) {
        this.set(this.get() - longType.get());
    }

    @Override
    public int compareTo(LongType longType) {
        long l;
        long l2 = this.get();
        if (l2 > (l = longType.get())) {
            return 1;
        }
        if (l2 < l) {
            return -1;
        }
        return 0;
    }

    @Override
    public void set(LongType longType) {
        this.set(longType.get());
    }

    @Override
    public void setOne() {
        this.set(1L);
    }

    @Override
    public void setZero() {
        this.set(0L);
    }

    @Override
    public void inc() {
        long l = this.get();
        this.set(++l);
    }

    @Override
    public void dec() {
        long l = this.get();
        this.set(--l);
    }

    public LongType[] createArray1D(int n) {
        return new LongType[n];
    }

    public LongType[][] createArray2D(int n, int n2) {
        return new LongType[n][n2];
    }

    public LongType[][][] createArray3D(int n, int n2, int n3) {
        return new LongType[n][n2][n3];
    }

    @Override
    public LongType createVariable() {
        return new LongType(0L);
    }

    @Override
    public LongType copy() {
        return new LongType(this.get());
    }
}

