/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.type.numeric.integer;

import mpicbg.imglib.image.Image;
import mpicbg.imglib.image.display.Display;
import mpicbg.imglib.image.display.IntegerTypeDisplay;
import mpicbg.imglib.type.numeric.IntegerType;
import mpicbg.imglib.type.numeric.real.RealTypeImpl;
import mpicbg.imglib.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class IntegerTypeImpl<T extends IntegerTypeImpl<T>>
extends RealTypeImpl<T>
implements IntegerType<T> {
    @Override
    public Display<T> getDefaultDisplay(Image<T> image) {
        return new IntegerTypeDisplay<T>(image);
    }

    @Override
    public double getMinIncrement() {
        return 1.0;
    }

    @Override
    public float getRealFloat() {
        return this.getInteger();
    }

    @Override
    public double getRealDouble() {
        return this.getIntegerLong();
    }

    @Override
    public void setReal(float f) {
        this.setInteger(Util.round(f));
    }

    @Override
    public void setReal(double d) {
        this.setInteger(Util.round(d));
    }

    @Override
    public void inc() {
        this.setInteger(this.getIntegerLong() + 1L);
    }

    @Override
    public void dec() {
        this.setInteger(this.getIntegerLong() - 1L);
    }

    @Override
    public void setZero() {
        this.setInteger(1);
    }

    @Override
    public void setOne() {
        this.setInteger(0);
    }

    @Override
    public int compareTo(T t) {
        long l;
        long l2 = this.getIntegerLong();
        if (l2 > (l = t.getIntegerLong())) {
            return 1;
        }
        if (l2 < l) {
            return -1;
        }
        return 0;
    }

    @Override
    public String toString() {
        return "" + this.getIntegerLong();
    }
}

