/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.type.numeric.integer;

import mpicbg.imglib.container.DirectAccessContainer;
import mpicbg.imglib.container.basictypecontainer.ShortAccess;
import mpicbg.imglib.container.basictypecontainer.array.ShortArray;
import mpicbg.imglib.cursor.Cursor;
import mpicbg.imglib.type.numeric.integer.IntegerTypeImpl;
import mpicbg.imglib.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GenericShortType<T extends GenericShortType<T>>
extends IntegerTypeImpl<T> {
    final DirectAccessContainer<T, ? extends ShortAccess> storage;
    ShortAccess b;

    public GenericShortType(DirectAccessContainer<T, ? extends ShortAccess> directAccessContainer) {
        this.storage = directAccessContainer;
    }

    public GenericShortType(short s) {
        this.storage = null;
        this.b = new ShortArray(1);
        this.setValue(s);
    }

    public GenericShortType() {
        this(0);
    }

    @Override
    public void updateContainer(Cursor<?> cursor) {
        this.b = this.storage.update(cursor);
    }

    protected short getValue() {
        return this.b.getValue(this.i);
    }

    protected void setValue(short s) {
        this.b.setValue(this.i, s);
    }

    @Override
    public void mul(float f) {
        short s = this.getValue();
        this.setValue((short)Util.round((float)s * f));
    }

    @Override
    public void mul(double d) {
        short s = this.getValue();
        this.setValue((short)Util.round((double)s * d));
    }

    @Override
    public void add(T t) {
        short s = this.getValue();
        this.setValue((short)(s + ((GenericShortType)t).getValue()));
    }

    @Override
    public void div(T t) {
        short s = this.getValue();
        this.setValue((short)(s / ((GenericShortType)t).getValue()));
    }

    @Override
    public void mul(T t) {
        short s = this.getValue();
        this.setValue((short)(s * ((GenericShortType)t).getValue()));
    }

    @Override
    public void sub(T t) {
        short s = this.getValue();
        this.setValue((byte)(s - ((GenericShortType)t).getValue()));
    }

    @Override
    public int compareTo(T t) {
        short s;
        short s2 = this.getValue();
        if (s2 > (s = ((GenericShortType)t).getValue())) {
            return 1;
        }
        if (s2 < s) {
            return -1;
        }
        return 0;
    }

    @Override
    public void set(T t) {
        this.setValue(((GenericShortType)t).getValue());
    }

    @Override
    public void setOne() {
        this.setValue((short)1);
    }

    @Override
    public void setZero() {
        this.setValue((short)0);
    }

    @Override
    public void inc() {
        short s = this.getValue();
        s = (short)(s + 1);
        this.setValue(s);
    }

    @Override
    public void dec() {
        short s = this.getValue();
        s = (short)(s - 1);
        this.setValue(s);
    }

    @Override
    public String toString() {
        return "" + this.getValue();
    }
}

